/* This file is part of Cloudy and is copyright (C) 1978-2003 by Gary J. Ferland.
 * For conditions of distribution and use, see copyright notice in license.txt */
/* rfield.h */

/* zero out rfield arrays between certain limits, code in zero.c */
void rfield_opac_zero( long lo , long ihi );

/* set true when malloced, init to false */
extern int lgRfieldMalloced;

EXTERN struct t_rfield {

	/* ================================================================================= */
	/* the following define the continuum energy scale and its limits */

	/* nflux is number of continuum points needed to get to high energy
	 * end of this continuum.  this is initally set to nupper in ContCreatePointers,
	 * and then trimed down in ContSetIntensity.  It is finally reset in ConvInitTemp,
	 * to make sure continuum includes all possible line and continuum emission
	 * produced by the code */
	long int nflux;

	/* number of frequency cells needed to get full energy resolution of code */
	long int nupper;

	/* the energy of the lower limit of the continuum */
	float emm;

	/* the energy of the upper limit of the continuum */
	float egamry;

	/*faintest high energy flux to consider, set with set flxfnt command */
	float FluxFaint;

	/* energy in Ryd of center of cell */
	float *anu/*[NC_ELL]*/;

	/* original set of energy units, always the same no matter what the
	 * shape of the continuum - actual energy units change with shape */
	float *AnuOrg/*[NC_ELL]*/;

	/* width of cells in ryd */
	float *widflx/*[NC_ELL]*/;

	/* used to keep track of number of lines per freq interval */
	long int *line_count;

	/* brems occupation number - only used for two photon */
	float *OccNumbBremsCont;

	/* these are log, sqrt, square, and cube of anu array */
	float *anulog/*[NC_ELL]*/, 
	  *anusqr/*[NC_ELL]*/, 
	  *anu2/*[NC_ELL]*/, 
	  *anu3/*[NC_ELL]*/;

	/* ================================================================================= */
	/* the following are the arrays containing the local radiation field */

	/*flux is photons per cell N.B. width of cells vary with energy, given by widflx */
	float *flux/*[NC_ELL]*/;

	/* the accumulated flux, sum from this energy to infinity */
	float *flux_accum/*[NC_ELL]*/;

	/* convoc is the conversion factor from rfield to OccNumbIncidCont */
	float *convoc/*[NC_ELL]*/;

	/* OccNumbIncidCont is the continuum occupation number, attenuated incident ONLY */
	float *OccNumbIncidCont/*[NC_ELL]*/;

	/* OccNumbDiffCont is the continuum occupation number, for local diffuse continuum */
	float *OccNumbDiffCont/*[NC_ELL]*/;

	/* array of Boltzmann factors for the continuum energy grid and current temperature */
	/* >>>chng 00 apr 04 from float to double so that corr for stim emis H- not go negative */
	double *ContBoltz/*[NC_ELL]*/;

	/* ConEmitLocal is local diffuse continuum, per unit vol,
	 * for current zone, evaluated in RTDiffuse */
	float *ConEmitLocal/*[NC_ELL]*/;

	/* reflected diffuse emission continuum */
	float *ConEmitReflec/*[NC_ELL]*/;

	/* outward diffuse emission continuum (not the interactive one),
	 * this is incremented in radinc because of interplay between absorption
	 * and emission - get the outward brems right */
	float *ConEmitOut/*[NC_ELL]*/;

	/* this is set in RTDiffuse and carries interactive continua */
	float *ConInterOut/*[NC_ELL]*/;

	/* ConRefIncid is reflected portion of incident continuum */
	float *ConRefIncid/*[NC_ELL]*/;

	/* this is the spectrum of continuum thrown into the outward beam,
	 * this is only used in metdif and makediffuse, remove after combining
	 * these routines */
	float *ThrowOut/*[NC_ELL]*/;

	/* these are energy-by-energy sums of various arrays, used to save time in
	 * evaluating rate integrals */
	float *SummedCon/*[NC_ELL]*/;
	float *SummedDif/*[NC_ELL]*/;
	float *SummedOcc/*[NC_ELL]*/;

	/* this will contail array of locally destroyed continuum photons,
	 * zeroed and evaluated in RTDiffuse, currently only two-photon */
	float *ConOTS_local_photons/*[NC_ELL]*/,
		/* the local photoionization rate corresponding to above photons */
		*ConOTS_local_OTS_rate/*[NC_ELL]*/;

	/* saves total two photon continuum for debugging, set in RTDiffuse */
	float *TotDiff2Pht;

	/* otsline and ots con - local ots fields for line and continua
	 * outlin outward line fields */
	float 
		/* the local ots line rates */
		*otslin/*[NC_ELL]*/, 
		/* the local ots continuum rates */
		*otscon/*[NC_ELL]*/, 

		/* these two are the new rates, that will be entered into the above once
		 * RTOTSUpdata has been called */
		 *otslinNew/*[NC_ELL]*/,
		 *otsconNew/*[NC_ELL]*/,

		*outlin/*[NC_ELL]*/, 
		**otssav/*[NC_ELL][2]*/;

	/* reflected line */
	float *reflin/*[NC_ELL]*/;

	/* save incident continuum for later iterations */
	float *FluxSave/*[NC_ELL]*/;

	/* variables related to deriving the ratio of outward to incident continuum */
	/* SumHOutCon is H-ionizing only*/
	float SumOutCon, 
	  SumIncCon, 
	  /* sumOutCon is summed out outlin and ConInterOut less SavOutCon for all energy*/
	  *SavOutCon/*[NC_ELL]*/, 
	  SumHOutCon, 
	  SumHIncCon, 
	  /* SumOutMax - energy where max occurs, ipSumOutMax pointer to this*/
	  SumOutMax;

	long int ipSumOutMax;

	/* this is zero or one depending whether pumping by diffuse fields
	 * is turned on (1) or turned off (0) */
	float DiffPumpOn;

	/* string identifing the first line that occured at this energy */
	char **chLineLabel/*[NC_ELL][5]*/;

	/* string identifing the first continuum edge that occured at this energy */
	char **chContLabel/*[NC_ELL][5]*/;

	/* free free gaunt factor for all charges */
	/* First index is EFFECTIVE CHARGE!	*/
	float **gff/*[LIMELM][NC_ELL]*/;

	/* flag which, if set to false, causes gauntff.dat, if it exists, to be read in,
	 * or if true, causes the file gauntff.dat to be created. rfield.gff[][] is
	 * filled by interpolation on the values in this file	*/
	int lgCompileGauntFF;

	/* method for transferring diffuse continuum
	 * either 'ots' or 'oux' where x is n for which */
	char chDffTrns[4];

	/* another flag, true if outward only - 
	 * used to multipy the ConInterOut continuum for creating the interactive
	 * continuum - when false, no outward only, this is not added */
	int lgOutOnly;

	/* ipEnergyBremsThin is index for lowest energy thin to ff abs and plasma frequency
	 * EnergyBremsThin is energy there, ryd */
	long int ipEnergyBremsThin;
	float EnergyBremsThin;

	/* index of highest cell with positive Boltzmann factor */
	long int ipMaxBolt;

	/* turn off continuum pumping, set with 'no induced processes' command */
	int lgInducProcess;

	/* saves for the upward and downward compton shifts */
	double *comup/*[NC_ELL]*/, 
	  *comdn/*[NC_ELL]*/;

	/* array indices for centers of B and V filters */
	long int ipB_filter , ipV_filter;

	/* extinction at B and V filters */
	double extin_B , extin_V;

	/* coefficients for fitting Tarter expressions for compton 
	 * heating and cooling, over full energy range of code */
	float *csigh/*[NC_ELL]*/, 
	  *csigc/*[NC_ELL]*/;

	double comtot, 
	  cmheat, 
	  cmcool, 
	  comoff, 
	  cinrat;

	/* set true if compton cooling underflows */
	int lgComUndr;

	/* parameters to do with incident continuum */
	/* limit to number of spectra that can be entered */
#	define	LIMSPC	10

	/* the limit to the size of the continuum array */
#	define	NCELL	130000

	double totpow[LIMSPC], 
	  slope[LIMSPC], 
	  cutoff[3][LIMSPC], 
	  spfac[LIMSPC];

	long int nspec, 
	  ipspec;

	/* these are used for interpolate and table commands, 
	 * this is the linear energy Rydbergs of continuum point */
	/* >>chng 01 oct 16, made into explicit arrays again so that
	 * table commands will work before continuum defined.*/
	double tNuRyd[NCELL][LIMSPC], 
	  tslop[NCELL][LIMSPC], 
	  /* this is the log of f_nu of continuum point */
	  tFluxLog[NCELL][LIMSPC], 

	  /* range for particular continuum source */
	  range[2][LIMSPC];

	/* save array for table read command, to save continuum previously punched */
	float *ConTabRead/*[NC_ELL]*/;

	/* chSpNorm says how spectrum was normlized - are or lum
	 * chrspec says whether per unit anea or tot 4 pi  */
	char chSpNorm[LIMSPC][5], 
	  chRSpec[LIMSPC][5], 
	  chSpType[LIMSPC][6];

	/* pointer to file for table read command, only 1 possible */
	FILE *ioTableRead[LIMSPC];

	/* these are total numbers of photons over various energy ranges */
	float qhtot, 
	  qhe, 
	  qheii, 
	  qbal, 
	  qrad, 
	  qtot;

	/* hydrogen ionization parameter */
	float uh;

	/* helium ion ionization parameter */
	float uheii;

	/* lgUSphON flag set when we hit stromgren radius in spherical geometry	*/
	int lgUSphON;
	/* the stromgren radius var set to get u spherical */
	float rstrom;

	/* flag set if incident radiation field less than
	 * 10x the Habing ISM field */
	int lgHabing;

	/* >>chng 03 feb 12, add fine array to keep track of line overlap */
	/* low and high bounds of fine array - only must include resonance lines */
	float fine_lo, fine_hi;
	/* the number of elements - will be several million */
	long nfine;
	/* the resolution of the array - initally 1 km/s */
	double fine_resol;
	/* the opacity array itself */
	float *fine_opac;

	/* flag saying to update fine opacities - not done all the time */
	int lgFine_opac_update;

}	rfield;

