/* This file is part of Cloudy and is copyright (C) 1978-2003 by Gary J. Ferland.
 * For conditions of distribution and use, see copyright notice in license.txt */
/*esc_PRD_1side fundamental escape probability radiative transfer routine for incomplete redistribution */
double esc_PRD_1side(double tau, 
  double a);

/*esc_CRDwing_1side fundamental escape probability radiative transfer routine, for complete redistribution */
double esc_CRDwing_1side(double tau, 
  double a );

/*RTesc_lya escape prob for hydrogen atom Lya, using Hummer and Kunasz results */
double RTesc_lya(float *esin, 
  float *dest, 
  double abund, 
  long int ipZ);/* 0 for H, */

/*escsub escape probability radiative transfer for subordinate lines
double escsub(double tau, 
  double tout, 
  double damp,
  int ipREDIS ); */

/*esc_CRDwing escape probability CRD with wings, for subordinate lines */
double esc_CRDwing(double tau, 
  double tout, 
  double damp);

/*esc_CRDcore escape probability CRD with no wings, for subordinate lines */
double esc_CRDcore(double tau, 
  double tout);

/*esc_PRD escape probability radiative transfer for incomplete redistribution */
double esc_PRD(double tau, 
  double tout, 
  double damp );

/*esca0k2 derive Hummer's K2 escape probability for Doppler core only */
double esca0k2(double taume);

/*escpcn continuum escape probability */
double esccon(double tau, 
  double hnukt);

/*conesc one of the forms of the continuum escape probability */
double escConE2(double x);

/*RT_DestProb returns line destruction probability due to continuum opacity */
double RT_DestProb(
	  /* abundance of species */
	  double abund, 
	  /* its line absorption cross section */
	  double crsec, 
	  /* pointer to energy within continuum array, to get background opacity,
	   * this is on the f not c scale */
	  long int ipanu, 
	  /* line width */
	  double widl, 
	  /* escape probability */
	  double escp, 
	  /* type of redistribution function */
	  char *chCore);

/*wrapper to call RT_LineWidth for the special case of Lya */
double RT_LyaWidth(
			 double tauin, 
			 double tauout, 
			 double a, 
			 /* answer will be in whatever units vth is in, since only generates
			  * optical depth dependent scale factor */
			 double vth);

/*RT_LineWidth compute line width (cm/sec), using optical depth array information */
double RT_LineWidth(EmLine * t);

/* beta is ratio of continuum to mean line opacity,
 * returns dest prob = beta F(beta) */
double RT_DestHummer(double beta); 
