/* This file is part of Cloudy and is copyright (C) 1978-2003 by Gary J. Ferland.
 * For conditions of distribution and use, see copyright notice in license.txt */
/*RTOptDepthIncre increment optical depths once per zone, called after RadInc */
#include "cddefines.h"
#include "lines_service.h"
#define	CAPMASER	(-30.)
#include "taulines.h"
#include "iso.h"
#include "rfield.h"
#include "trace.h"
#include "dense.h"
#include "hyperfine.h"
#include "wind.h"
#include "ionrange.h"
#include "prtmet.h"
#include "h2.h"
#include "hmi.h"
#include "opacity.h"
#include "radius.h"
#include "fe2ovr.h"
#include "dtmase.h"
#include "atomfeii.h"
#include "rt.h"

void RTOptDepthIncre(void)
{

	char chLbl[11];

	long int i, 
	  ipHi, 
	  nelem, 
	  ipLo;

	double factor;

#	ifdef DEBUG_FUN
	fputs( "<+>RTOptDepthIncre()\n", debug_fp );
#	endif

	if( trace.lgTrace )
	{
		fprintf( ioQQQ, " RTOptDepthIncre called.\n" );
	}

	/* call RTMake one last time in this zone, to get fine opacities defined */
	RTMake( FALSE , TRUE);

	opac.telec += (float)(radius.drad_x_fillfac*dense.eden*6.65e-25);
	opac.thmin += 
		(float)(radius.drad_x_fillfac*hmi.Molec[ipMHm]*3.9e-17*(1. - rfield.ContBoltz[hmi.iphmin-1]/
	  hmi.hmidep));

	/* following used for wind solution in TAUCHN */
	/* >>chng 01 mar 24, removed following, equivalent logic now in RTLineTauInc */
	/*if( wind.windv > 0. )
		wind.wndeff = 
		(float)(MIN2(radius.depth,radius.Radius)/MAX2(DoppVel.doppler[0],
		  wind.windv)*geometry.FillFac);*/

	/* prevent maser runaway */
	dtMase.dTauMase = 0.;

	/* if following is still zero when maser used, then maser was in
	 * heavy element line */
	dtMase.ijMase = 0;

	/* hydrogenic species */
	for( nelem=0; nelem < LIMELM; nelem++ )
	{
		if( (IonRange.IonHigh[nelem] == nelem + 1)  )
		{
			/* must convert to physical scale for opacities,
			 * get ionic abundances first */
			if( dense.xIonDense[nelem][nelem+1] > 1e-30 )
			{
				factor = dense.xIonDense[nelem][nelem+1];
			}
			else
			{
				/* case where almost no parent ion - this will make
				 * very large line opacity, so background dest small */
				factor = 1.;
			}

			for( ipLo=0; ipLo < (iso.numLevels[ipH_LIKE][nelem] - 1); ipLo++ )
			{
				for( ipHi=ipLo + 1; ipHi < iso.numLevels[ipH_LIKE][nelem]; ipHi++ )
				{
					/* must temporarily make ipLnPopOpc physical */
					EmisLines[ipH_LIKE][nelem][ipHi][ipLo].PopOpc *= 
						(float)factor;
					/* actually do the work */
					RTLineTauInc(&EmisLines[ipH_LIKE][nelem][ipHi][ipLo]);
					/* go back to original units so that final correction ok */
					EmisLines[ipH_LIKE][nelem][ipHi][ipLo].PopOpc /= 
						(float)factor;
				}
			}
			ipLo = 0;
			/* these are the extra lyman lines */
			for( ipHi=2; ipHi < iso.nLyman[ipH_LIKE]; ipHi++ )
			{
				/* must matke ipLnPopOpc physical */
				iso.ExtraLymanLines[ipH_LIKE][nelem][ipHi].PopOpc = EmisLines[ipH_LIKE][nelem][3][ipLo].PopOpc *(float)factor;
				/* actually do the work */
				RTLineTauInc(&iso.ExtraLymanLines[ipH_LIKE][nelem][ipHi]);
			}
		}
	}

	/* he-like species */
	for( nelem=1; nelem < LIMELM; nelem++ )
	{
		if( IonRange.IonHigh[nelem] >= nelem )
		{
			/* must convert to physical scale for opacities,
			 * get ionic abundances first */
			if( dense.xIonDense[nelem][nelem] > 1e-30 )
			{
				factor = dense.xIonDense[nelem][nelem];
			}
			else
			{
				/* case where almost no parent ion - this will make
				 * very large line opacity, so background dest small */
				factor = 1.;
			}

			for( ipHi=1; ipHi < iso.numLevels[ipHE_LIKE][nelem]; ipHi++ )
			{
				for( ipLo=0; ipLo < ipHi; ipLo++ )
				{
					/* must temporarily make ipLnPopOpc physical */
					EmisLines[ipHE_LIKE][nelem][ipHi][ipLo].PopOpc *= 
						(float)factor;
					/* actually do the work */
					RTLineTauInc(&EmisLines[ipHE_LIKE][nelem][ipHi][ipLo]);
					/* go back to original units so that final correction ok */
					EmisLines[ipHE_LIKE][nelem][ipHi][ipLo].PopOpc /= 
						(float)factor;
				}
			}
			ipLo = 0;
			/* these are the extra lyman lines */
			for( ipHi=2; ipHi < iso.nLyman[ipHE_LIKE]; ipHi++ )
			{
				/* must make ipLnPopOpc physical */
				iso.ExtraLymanLines[ipHE_LIKE][nelem][ipHi].PopOpc = EmisLines[ipHE_LIKE][nelem][3][ipLo].PopOpc *(float)factor;
				/* actually do the work */
				RTLineTauInc(&iso.ExtraLymanLines[ipHE_LIKE][nelem][ipHi]);
			}
		}
	}

	/* increment optical depths for all heavy element lines
	 * same routine does wind and static,
	 * does not start from 0 since first line is dummy */
	/*DumpLine( &TauLines[ipT63] );*/
	for( i=1; i <= nLevel1; i++ )
	{
		RTLineTauInc(&TauLines[i]);
		if( TauLines[i].TauIn < CAPMASER )
		{
			fprintf( ioQQQ, " RTOptDepthIncre, Tau line maser tau too small,%10.2e\n", 
			  TauLines[i].TauIn );
			strcpy( chLbl, chLineLbl(&TauLines[i] ) );
			fprintf( ioQQQ, " line=%3ld zone=%4ld %10.10s\n", 
			  i, nzone, chLbl );
			ShowMe();
			puts( "[Stop in RTOptDepthIncre]" );
			cdEXIT(EXIT_FAILURE);
		}
	}

	/* all lines in cooling with g-bar */
	for( i=0; i < nWindLine; i++ )
	{
		if( TauLine2[i].nelem != TauLine2[i].IonStg )
		{
			RTLineTauInc(&TauLine2[i]);
			if( TauLine2[i].TauIn < CAPMASER )
			{
				fprintf( ioQQQ, " RTOptDepthIncre, Wind line maser tau too small,%10.2e\n", 
				  TauLine2[i].TauIn );
				fprintf( ioQQQ, " line=%3ld zone=%4ld\n", i, nzone );
				ShowMe();
				puts( "[Stop in RTOptDepthIncre]" );
				cdEXIT(EXIT_FAILURE);
			}
		}
	}

	/* the block of inner shell lines */
	for( i=0; i < nUTA; i++ )
	{
		/* populations have not been set */
		UTALines[i].PopOpc = dense.xIonDense[UTALines[i].nelem-1][UTALines[i].IonStg-1];
		UTALines[i].PopLo = dense.xIonDense[UTALines[i].nelem-1][UTALines[i].IonStg-1];
		UTALines[i].PopHi = 0.;
		RTLineTauInc(&UTALines[i]);
	}

	/* all hyper fine structure lines  */
	for( i=0; i < nHFLines; i++ )
	{
		/* remember current gas-phase abundances */
		float save = dense.xIonDense[HFLines[i].nelem-1][HFLines[i].IonStg-1];

		/* bail if no abundance */
		if( save<=0. ) continue;

		/* set gas-phase abundance to total times isotope ratio */
		dense.xIonDense[HFLines[i].nelem-1][HFLines[i].IonStg-1] *= hyperfine.HFLabundance[i] ;

		RTLineTauInc(&HFLines[i]);
		if( HFLines[i].TauIn < CAPMASER )
		{
			fprintf( ioQQQ, " RTOptDepthIncre, Wind line maser tau too small,%10.2e\n", 
				HFLines[i].TauIn );
			fprintf( ioQQQ, " line=%3ld zone=%4ld\n", i, nzone );
			ShowMe();
			puts( "[Stop in RTOptDepthIncre]" );
			cdEXIT(EXIT_FAILURE);
		}

		/* put the correct gas-phase abundance back in the array */
		dense.xIonDense[HFLines[i].nelem-1][HFLines[i].IonStg-1] = save;
	}
#	if 0
	{
		/* this is an option to print out one of the two photon continua */
		/*@-redef@*/
		enum {DEBUG_LOC=FALSE};
		/*@+redef@*/
		if( DEBUG_LOC )
		{	
			fprintf(ioQQQ,"isotope pops\t%.3e\t%.3e\t%.3e\t%.3e\n",
				/*HFLines[0].PopOpc , HFLines[0].opacity,
				TauLines[ipH21cm].PopOpc , TauLines[ipH21cm].opacity);*/
				HFLines[0].TauIn , HFLines[0].TauTot,
				TauLines[ipH21cm].TauIn , TauLines[ipH21cm].TauTot);
		}
	}
#	endif

	/* carbon monoxide co lines */
	for( i=0; i < nCORotate; i++ )
	{
		RTLineTauInc(&C12O16Rotate[i]);
		if( C12O16Rotate[i].TauIn < CAPMASER )
		{
			fprintf( ioQQQ, " RTOptDepthIncre, C12O16 line maser tau too small,%10.2e\n", 
			  C12O16Rotate[i].TauIn );
			fprintf( ioQQQ, " line=%3ld zone=%4ld\n", i, nzone );
			ShowMe();
			puts( "[Stop in RTOptDepthIncre]" );
			cdEXIT(EXIT_FAILURE);
		}
	}
	for( i=0; i < nCORotate; i++ )
	{
		RTLineTauInc(&C13O16Rotate[i]);
		if( C13O16Rotate[i].TauIn < CAPMASER )
		{
			fprintf( ioQQQ, " RTOptDepthIncre, C13O16 line maser tau too small,%10.2e\n", 
			  C13O16Rotate[i].TauIn );
			fprintf( ioQQQ, " line=%3ld zone=%4ld\n", i, nzone );
			ShowMe();
			puts( "[Stop in RTOptDepthIncre]" );
			cdEXIT(EXIT_FAILURE);
		}
	}

	/* do large FeII atom if this is enabled */
	if( FeII.lgFeIION )
	{
		FeIITauInc();
	}

	/* increment optical depth for the H2 molecule */
	H2_TauInc();

	/* following is for static atmosphere */
	if( wind.windv == 0. )
	{
		/* iron fe feii fe2 
		 * first are overlapping feii lines */
		for( i=0; i < NFEII; i++ )
		{
			/* optical depths for Feii dest of lya when large feii not used */
			fe2ovr_la.Fe2TauLte[i] += fe2ovr_la.feopc[i]*(float)radius.drad_x_fillfac;
		}
	}

	if( trace.lgTrace && trace.lgOptcBug )
	{
		fprintf( ioQQQ, " RTOptDepthIncre updated optical depths:\n" );

		prtmet();

	}

	if( trace.lgTrace )
	{
		fprintf( ioQQQ, " RTOptDepthIncre returns.\n" );
	}

#	ifdef DEBUG_FUN
	fputs( " <->RTOptDepthIncre()\n", debug_fp );
#	endif
	return;
}

