/* This file is part of Cloudy and is copyright (C) 1978-2003 by Gary J. Ferland.
 * For conditions of distribution and use, see copyright notice in license.txt */
/*
 * these save EXTERN structure variables, like te vs depth
 * zeroed out in zero, incremented in RTOptDepthIncre
 */

EXTERN struct t_struc {

	/* this is the new variable that replaces the old NZLIM,
	 * it gives the largest number of zones that will be neede
	 * in the current calculation, and is used to create
	 * space for the following variables, and also similar
	 * variables in dynamics.c */
	long int nzlim;

	/* these will all become vectors with length given by the limit to the number of zones */
	float *testr, 
	  *volstr, 
	  *radstr, 
	  /* the thickness of the current zone */
	  *drad, 
	  *histr, 
	  *hiistr, 
	  *ednstr, 
	  *o3str, 
	  /* the total pressure, including all terms (ram, radiation, integrated incident, gas)*/
	  *pressure,
	  /* just the gas pressure, nkT */
	  *GasPressure ,
	  /* radiation pressure */
	  *PresRadCurr ,
	  /* >>chng 02 May 2001 rjrw: add hden for dilution */
	  *hden ,
	  /* total particles per unit vol */
	  *DenParticles ,
	  /* density, gm/cm3 total grams per unit vol */
	  *DenMass,
	  /* depth of this position */
	  *depth,
	  /* Lyman continuum optical depth for current iteration */
	  *xLyman_depth;

	/* save ionization balance array across model */
	float ***xIonDense ;

	/* the hydrogen molecules */
#if 1
	/*float *Molec[N_H_MOLEC];*/
	float **Molec;
#else
	float *hminus,
		*htwo,
		*htwo_star,
		*hehp,
		*h2plus,
		*h3plus;
#endif

	/* total gas phase abundances */
	float **gas_phase;

	  /* cooling and heating for each zone */
	double *coolstr ,
	  *heatstr;

	}	struc;

