/* This file is part of Cloudy and is copyright (C) 1978-2003 by Gary J. Ferland.
 * For conditions of distribution and use, see copyright notice in license.txt */
/* trace.h */

EXTERN struct t_trace {

	/* flag saying that trace has been set */
	int lgTrace;

	/* lgTraceInput is set TRUE if the key TRACE occurs in the input stream */
	int lgTraceInput;

	/*nznbug zone to turn on trace, set by trace command, npsbug is iteratoin number */
	long int nznbug;

	/* which iteration to turn on trace */
	long int npsbug;

	/*flag set to true by trace heavy command */
	int lgHeavyBug;

	/*trace convergence */
	int lgTrConvg;

	/* flag to indicate level of detail in trace, now only in trace convergence */
	/* flag set with trace leveln command, for n level atom */
	int lgTrLevN;

	/* flag set with trace pointers command */
	int lgPointBug;

	/* trace compton flag */
	int lgComBug;

	/* flag set with trace neon command */
	int lgNeonBug;

	/* flag set with trace line command */
	int lgTrLine; 

	/* flag set with trace iron bug */
	int lgFeBug;

	/* flag set if negative opacities every occured */
	int lgOptcBug;

	/* trace 3 body recombination routines, trace three body */
	int lgTrace3Bod;

	/* flag set with trace molecules command */
	int lgTrMole;

	/* flag set by trace heating command */
	int lgHeatBug;

	/* flag set with trace gaunt command */
	int lgTrGant;

	/* flag set with trace dr command */
	int lgDrBug;

	/* flag set with trace optimizer command */
	int lgTrOptm;

	/* flag set with trace difuse fields command */
	int lgTrDiff;

	/* flag set with trace beta command */
	int lgTr8446;

	/* flag set with trace opacity */
	int lgOpacBug;

	/* flag set with trace grains command */
	int lgDustBug;

	/* flags set with trace helium (lgHeBug) */
	int lgHeBug;

	/* lgHe1Bug is singlets or atom */
	int lgHe1Bug;

	/* lgHe2Bug is helium ion */
	int lgHe2Bug;

	/* lgHe3Bug is triplet */
	int lgHe3Bug;

	/* lgHBug set with trace hydrogen command */
	int lgHBug;

	/* set full trace with trace h-like or he-like full command */
	int lgIsoTraceFull[NISO];

	/* ipIsoTrace is atomic number for iso-electronic species with full trace */
	long int ipIsoTrace[NISO];

	/* trace calcium atom flag */
	int lgCalBug;

	/* trace carbon flag */
	int lgCarBug;

	/* flag set with trace continuum command */
	int lgConBug;

	/* flag set with trace ots command */
	int lgOTSBug;

	/* flag set with trace two photon command */
	int lgBug2nu;

	/* flag set with trace cooling */
	int lgCoolTr;

	/* set true if trace eden is entered */
	int lgNeBug;

	/* flag set with drive pointers command */
	int lgPtrace;

	/* the drive cdline command, which checks that all lines can be pulled out by cdLine */
	int lgDrv_cdLine;

	/* debug level for use with dbg_printf command (in servicce.c)*/
	int debug_level;

	/* flag affecting which iteration to turn on trace */
	int lgTrOvrd;

	}	trace;
