/* This file is part of Cloudy and is copyright (C) 1978-2003 by Gary J. Ferland.
 * For conditions of distribution and use, see copyright notice in license.txt */
/* wind.h */
EXTERN struct t_wind {

	/* parameters for wind model;
	 * initial wind velocity, will be negative for D-critical flow */
	float windv0;

	/* contral object mass, to compute inward acceleration */
	float comass;

	/* current wind velocity, code tests for wind soln by
	 * seeing whether this is positive, static soln if 0 */
	float windv;

	/* mass loss rate, n*v, set in parsecommands.  needs r^2 to be real flux */
	float emdot;

	/* *flag set if wind not ok, (below sonic point) */
	int lgWindOK;

	/* variables for tracking average radiative acceleration */
	float AccelAver, 
	  acldr;

	/* inward gravitational acceleration */
	float agrav;

	/*AccelTot is total radiative acceleration, lines and continuum */
	float AccelTot;

	/*AccelCont continuum radiative acceleration - old faccel(1) */
	float AccelCont;

	/*AccelLine line radiative acceleration - old faccel(2) */
	float AccelLine;

	/*AccelPres change in pressure acceleration - old faccel(3) */
	float AccelPres;

	/* force multiplyer */
	float fmul;

	/*AccelMax is largest acceleration, usually at illuminated face */
	float AccelMax;

	/* flag set if wind solution had negative velocity */
	int lgVelPos;

	}	wind;

