#!perl -w
# all statements that start with a # are comments in perl
# -w turns on some warnings in above


# this is the perl script that is automatically run every night to verify cloudy
# it ends with sending an email message announcing success or failure - this needs
# to be modifies of deleted if you are not me

# the variable $exe must be set below to point to a valid cloudy executable
# for the OS in use

# bring in the perl module that includes copy
use File::Copy;

$TRUE = 1;
$FALSE = 0;

# if true then always recompute even when exe is older than results
$lgForceCompute = $TRUE;
# if false then only recompute when newer exe than results
$lgForceCompute = $FALSE;

# will we send stderr to a file or the screen?
$lgSTDERR2FILE = $TRUE;

# flag to remember if this is my win nt machine, set true below if nt and machine name correct
$lgWinNT = $FALSE;

# option to turn on logging print informatoin
$lgLOGGING = $TRUE;

# sest this true to only run script without exe cloudy or doing backups
# does not do backups, does not execute cloudy, but does generate *.out names
$lgDO_NO_WORK = $FALSE;

# find the name of machine processor, write into file machine.txt.
system "uname -a >machine.txt";

# open file named machine.txt with file handle MA;
open(MA,"machine.txt");

# copy file to perl special variable $_ (It will be used to check
# expression below)
$_ =<MA>;

# For different processor, give different option to complie program
if (/sparc/)
{
#	for sparc 
	$exe = "/homes/home37/feng/cloudy/current/sparc/cloudy_sparc.exe";
}
elsif (/alpha/)
{
#	for alpha 
	$exe = "/homes/home37/feng/cloudy/current/alpha/cloudy_alpha.exe";
}
elsif (/Linux/)
{
#	for Linux machine
	$exe = "/home/feng/Perl/object/cloudy_linux.exe";
}
elsif(/spp/)
{
#	for spp machine
	$in_dir = "/users/gary/cloudy/tsuite";
	$exe = "/users2/zfeng1/cloudy/object/cloudy_spp.exe";    
}
#     check for both nt and name since bash shell does not say windows
elsif (/Windows_NT/ || /CUMULUS/  || /LENTICULAR/)
{
#	nt
	# the disk drive 
	$c = "c";
	# input and output directories
	# $in_dir = "$c:/projects/cloudy/tsuite/short/";
	# $out_dir = "$c:/projects/cloudy/tsuite/short/";
	$in_dir = "$c:/projects/cloudy/current/tsuite/auto/";
	$out_dir = "$c:/projects/cloudy/current/tsuite/auto/";

	# the exe file name for the fast (release) version - faster but no asserts
	$exe = "$c:/projects/cloudy/current/release/current.exe";
	# the exe file name for the debug version - this has asserts and is safer
	$exe = "$c:/projects/Cloudy/current_net/Debug/current_net.exe";
	$exe = "$c:\\projects\\Cloudy\\current\\current_net\\Debug\\current_net.exe";
	$exe = "$c:/projects/cloudy/current/debug/current.exe";

#	$source = "$c:/projects/cloudy/current/source/";
#	the "current" project directory
       	$current= "$c:/projects/cloudy/current/";
#	$data = "c:/projects/cloudy/current/data/";

	if(/CUMULUS/ || /LENTICULAR/ )
	{
	   # remember if this is my win nt machine
	   $lgWinNT = $TRUE;
	}
}
else 
{
#	exit if not in the above machine
	print STDERR "This machine is not on the list so EXIT !!!";
	exit;
}

# file containing any errors, also used for timestamp
$errors = "$out_dir"."errors.txt";
# this file exists while long checking runs with purify are in pregress
$blockrun = "$out_dir"."blockfile.txt";
$log_file = "$out_dir"."autorun.log";
# file with list of PROBLEM strings
$problem_file = "$out_dir"."problems.txt";

# option to write STDERR to file instead of screen
if( $lgSTDERR2FILE )
{
	open( STDERR , ">$out_dir"."stderr.log" );
}

if( $lgLOGGING )
{
	open( ioLOG , ">$log_file" );
	printf( ioLOG "logging file opened\n");
}

# does $exe exist?
if( !open(EXEFILE, "$exe") ) 
{
	if( $lgLOGGING )
	{
		printf( ioLOG "executable did not exist so exiting without running.\n" );
	}
	printf( STDERR "executable did not exist so exiting without running.\n" );
	exit;
}

if( $lgLOGGING )
{
	printf( ioLOG "opened the executable %s\n" , "$exe" );
}

# see if errors.txt exists, if it does, and younger than exe file, just quit
# $lgForceCompute set above, option to force recomputing model
if( !$lgForceCompute  )
{
	if( -e $errors )
	{
		if( $lgLOGGING )
		{
			printf( ioLOG "errors file exits so checking timestamp\n" );
		}
		# is age of errors file smaler than exe file?
		if( (-M $errors) < (-M EXEFILE ) )
		{
			if( $lgLOGGING )
			{
				printf( ioLOG "errors file younger than exe so exiting\n" );
			}
			# no need to run tests, just quit
			exit;
		}
                # this file created when purify test is running 
                if( -e $blockrun )
                {
                   if( $lgLOGGING )
                   {
                           printf( ioLOG "blocking file exists so exiting\n" );
                   }
                   # no need to run tests, just quit
                   exit;
                }
	}
}

# backup source, data, exe files
backup_old_files();

# run the models 
run_cloudy();

# look for errors, this creates errors.txt, which we will copy to gradj
check_output();

# send mail announcing results
send_mail();

# check whether exectime has changed
# system("perl extime.pl");
# finally, check whether iter/zone has changed
system("perl ir_extime.pl");

if( $lgLOGGING )
{
	printf( ioLOG "autorun.pl terminates\n" );
}

exit;

#===========================================================
#
#          sub backup_old_files()
#
#===========================================================
sub backup_old_files 
{
	if( $lgLOGGING ) 
	{
		printf( ioLOG "backup_old_files entered\n" );
	}
	# return if not on cumulus
	if( !$lgWinNT )
	{
		if( $lgLOGGING ) 
		{
			printf(ioLOG  "backup_old_files returns since not on cumulus\n" );
		}
		return;
	}
	# option to not actually do anything (for debugging)
	if( $lgDO_NO_WORK )
	{
		return;
	}
	# move to the output directory
	if( !chdir( $out_dir ) )
	{
		printf(" invalid directory for output of test suite\n");
		printf(" was ==%s==\n",$out_dir );
		if( $lgLOGGING ) 
		{
			printf(ioLOG " invalid directory for output of test suite\n");
			printf(ioLOG " was ==%s==\n",$out_dir );
		}
		exit(1);
	}

	# make successive backups of all cloudy executables
	if( -e "cloudy_bk6.exe" )
	{
		rename( "cloudy_bk6.exe" , "cloudy_bk7.exe" );
	}
	if( -e "cloudy_bk5.exe" )
	{
		rename( "cloudy_bk5.exe" , "cloudy_bk6.exe" );
	}
	if( -e "cloudy_bk4.exe" )
	{
		rename( "cloudy_bk4.exe" , "cloudy_bk5.exe" );
	}
	if( -e "cloudy_bk3.exe" )
	{
		rename( "cloudy_bk3.exe" , "cloudy_bk4.exe" );
	}
	if( -e "cloudy_bk2.exe" )
	{
		rename( "cloudy_bk2.exe" , "cloudy_bk3.exe" );
	}
	if( -e "cloudy_bk1.exe" )
	{
		rename( "cloudy_bk1.exe" , "cloudy_bk2.exe" );
	}
	if( -e "cloudy_bak.exe" )
	{
		rename( "cloudy_bak.exe" , "cloudy_bk1.exe" );
	}
	if( -e "cloudy.exe" )
	{
		rename( "cloudy.exe" , "cloudy_bak.exe" );
	}
	# finally copy exe file here
	copy( $exe , "cloudy.exe" );

	# now make backups of all output files
	while(defined($output= glob("*.out")) )
	{ 
		# get basename
		$output =~ s/.out//gi;
		if( -e "$output".".bk6" )
		{
			rename( "$output".".bk6" , "$output".".bk7" );
		}
		if( -e "$output".".bk5" )
		{
			rename( "$output".".bk5" , "$output".".bk6" );
		}
		if( -e "$output".".bk4" )
		{
			rename( "$output".".bk4" , "$output".".bk5" );
		}
		if( -e "$output".".bk3" )
		{
			rename( "$output".".bk3" , "$output".".bk4" );
		}
		if( -e "$output".".bk2" )
		{
			rename( "$output".".bk2" , "$output".".bk3" );
		}
		if( -e "$output".".bk1" )
		{
			rename( "$output".".bk1" , "$output".".bk2" );
		}
		if( -e "$output".".bak" )
		{
			rename( "$output".".bak" , "$output".".bk1" );
		}
		if( -e "$output".".out" )
		{
			rename( "$output".".out" , "$output".".bak" );
		}
	}

        # demote all old copies of source files
	if( -e "source_bk6.tar" )
	{
		rename( "source_bk6.tar" , "source_bk7.tar" );
	}
	if( -e "source_bk5.tar" )
	{
		rename( "source_bk5.tar" , "source_bk6.tar" );
	}
	if( -e "source_bk4.tar" )
	{
		rename( "source_bk4.tar" , "source_bk5.tar" );
	}
	if( -e "source_bk3.tar" )
	{
		rename( "source_bk3.tar" , "source_bk4.tar" );
	}
	if( -e "source_bk2.tar" )
	{
		rename( "source_bk2.tar" , "source_bk3.tar" );
	}
	if( -e "source_bk1.tar" )
	{
		rename( "source_bk1.tar" , "source_bk2.tar" );
	}
	if( -e "source_bak.tar" )
	{
		rename( "source_bak.tar" , "source_bk1.tar" );
	}
	if( -e "source.tar" )
	{
		rename( "source.tar" , "source_bak.tar" );
	}

        # demote all old copies of data files
	if( -e "data_bk6.tar" )
	{
		rename( "data_bk6.tar" , "data_bk7.tar" );
	}
	if( -e "data_bk5.tar" )
	{
		rename( "data_bk5.tar" , "data_bk6.tar" );
	}
	if( -e "data_bk4.tar" )
	{
		rename( "data_bk4.tar" , "data_bk5.tar" );
	}
	if( -e "data_bk3.tar" )
	{
		rename( "data_bk3.tar" , "data_bk4.tar" );
	}
	if( -e "data_bk2.tar" )
	{
		rename( "data_bk2.tar" , "data_bk3.tar" );
	}
	if( -e "data_bk1.tar" )
	{
		rename( "data_bk1.tar" , "data_bk2.tar" );
	}
	if( -e "data_bak.tar" )
	{
		rename( "data_bak.tar" , "data_bk1.tar" );
	}
	if( -e "data.tar" )
	{
		rename( "data.tar" , "data_bak.tar" );
	}

	# move to the cloudy current directory, one level above data, source, tsuite
	if( !chdir( $current ) )
	{
		printf(" invalid directory for current project\n");
		printf(" was ==%s==\n",$out_dir );
		if( $lgLOGGING ) 
		{
			printf(ioLOG " invalid directory for current project\n");
			printf(ioLOG " was ==%s==\n",$out_dir );
		}
		exit(1);
	}
	# now make backup copy of source
	system( 
	"tar -cvf \"$out_dir\"\"source.tar\" source/*.*");
	# now make backup copy of data 
	system( 
	"tar -cvf \"$out_dir\"\"data.tar\" data/*.dat data/*.ini data/*.in data/*.rfi data/*.szd data/*.txt");

	if( $lgLOGGING ) 
	{
		printf( ioLOG  "backup_old_files exits\n" );
	
        }
        # move back to auto dir
	# move to the output directory
	if( !chdir( $out_dir ) )
	{
		printf(" invalid directory for output of test suite\n");
		printf(" was ==%s==\n",$out_dir );
		if( $lgLOGGING ) 
		{
			printf(ioLOG " invalid directory for output of test suite\n");
			printf(ioLOG " was ==%s==\n",$out_dir );
		}
		exit(1);
	}
}

sub run_cloudy
{
	# move to the output directory
	if( !chdir( $out_dir ) )
	{
		printf(" invalid directory for output of test suite\n");
		printf(" was ==%s==\n",$out_dir );
		exit(1);
	}
	if( $lgLOGGING )
	{
		printf( ioLOG "run_cloudy about to glob input files in dir %s\n", $in_dir );
	}

	while( defined( $input = glob("$in_dir*.in") ) )
	{
		# copy input file to fileout to exit it
		$output = $input;
		# change input dir name to output
		$output =~ s/$in_dir/$out_dir/gi;
		# change .in to .out
		$output =~ s/\.in/.out/gi;
		# $output = "$out_dir"."$output";
		if( $lgLOGGING )
		{
			printf(  ioLOG "from %s \n  to %s \n", $input , $output );
		}
		# option to not do anything (for testing )
		if( !$lgDO_NO_WORK )
		{
			system "nice -n 5 $exe < $input  > $output ";
		}
	}

	# the above loop should have run fileopac1.in (file opacities) and 
	# fileopac2.in (computed opacities)
	# these produced tables of ionization, fileopac1.ion and fileopac2.ion
	# compare them to see if identical
	# make fake cloudy output for later tests to detect
	#open( ioOPAC , ">fileopac.out" );
	#if( system( "cmp fileopac1.ion fileopac2.ion" )==0 )
	#{
	#	printf ioOPAC " Cloudy ends: -- opac files compare ok\n" 
	#}
	#	else
	#{
	#	printf ioOPAC  "botched assert BOTCHED ASSERT - opac files no compare\n" 
	#}
	#if( $lgLOGGING )
	#{
	#	printf( ioLOG "models complete, run_cloudy exits\n");
	#}
}


#===========================================================
#          check_output()
#===========================================================
sub check_output 
{

	#find "BOTCH " and "W-" string in all the output file and write
	#corresponding line into messages file.
	if( $lgLOGGING )
	{
		printf( ioLOG "check_output entered\n");
	}

	system "grep Botch  $out_dir*.out >$errors";
	system "grep W-  $out_dir*.out >> $errors";

	if( !open( ioERRORS , ">>$errors" ) ) 
	{
		die( "could not open errors.txt" );
	}

	# check  output file to see whether they contain "Cloudy ends:"
	# string and write corresponding line into checkend.txt file.
	# if size of file $out_dir/checkend.txt is zero, then program crashed.  

	$checkend = "$out_dir"."checkend.txt";
	while(defined($output= glob("$out_dir*.out")) )
	{ 
		system "grep 'ChkAssert'  $output > $checkend ";
		# check whether output file exists and has zero size (string did not occur)
		if(-z "$checkend")
		{
			printf( ioERRORS "%s did not end or had no asserts\n", $output);      
		}
	}

         # check whether any models were skipped because they were renamed *.skip
         system "ls \"$out_dir*.skip\" > skip.txt" ;
         # skipfile will have non-zero length if *.skip returned any names
         if( -s "skip.txt" )
         {
            print STDERR "\n\n some files were skipped by renmaing to .skip - list is in skip.txt\n" ;
            system "echo some files were skipped by renmaing to .skip - list is in skip.txt >> checkall.txt ";
         }

	if( $lgLOGGING )
	{
		printf( ioLOG "check_output exits\n");
	}
	close( ioERRORS);

        # finally copy errors.txt (which we hope is empty) to gradj
	copy( $errors , "u:/pub/gjf/last/errors.txt" );

        # search for PROBLEM in any file
        if( -e $problem_file )
        {
           unlink( $problem_file );
        }
        system( "grep \"PROBLEM\" *.out > $problem_file" );
        # now copy this file to the gradj site 
        copy( $problem_file , "u:/pub/gjf/last/problems.txt" );

}

#=============================================================
#             send_mail(),
#=============================================================

sub send_mail 
{


	# does errors exist and have non-zero size?
	if( -s "$errors" )
	{
		#$DevMailer->{Body} = "problems were found\r\nLine 2\r\n";
		#$DevMailer->{Body} = $DevMailer->{Body} . "Line 3\r\n";
                system("c:\\u\\blat\\blat.exe errors.txt -t gary\@pa.uky.edu -s \"Cloudy had problems on the pc\" " );
	}
	else
	{
                 open( ioEMAIL , ">message.txt" );
      
                 printf( ioEMAIL " test suite ran OK on my pc\n");  
                 printf( ioEMAIL " no problems were found on the pc\r\n" ) ;
                 printf( ioEMAIL " last being copies to last_good\r\n" ) ;
                 close( ioEMAIL );
#		$DevMailer->{Subject} = "test suite successfully run";  
#		$DevMailer->{Body} = "no problems were found\r\n";
                system("c:\\u\\blat\\blat.exe message.txt -t gary\@pa.uky.edu -s \"test suite successfully run\" " );

                # copy files to last_good location, since we just ran cleanly
                system( "perl last_good.pl" );
	}

        # now check for problems that occurred
        if( -s "$problem_file" )
        {
                system("c:\\u\\blat\\blat.exe problems.txt -t gary\@pa.uky.edu -s \"PROBLEM string was printed on PC\" " );
        }
 }

