#!/usr/bin/perl -w
#
# all statement starting with a # are comments
#
# look for botched asserts and warnings,
# and check for models that did not end.
# summary of errors will be in checkall.txt
#
# execute this script from within the directory where the
# *.out files live.  The following command should work:
# perl checkall.pl
#

# flag to remember whether we found problems
$lgProblems = 0;

print( "\nAbout to look for botched results and warnings:\n");

# find "BOTCH " "W-" and PROBLEM string in all the output file and write
# corresponding line into checkall.txt file.
system "grep Botched  *.out >checkall.txt";
system "grep W-  *.out >> checkall.txt";

# if this file has non-zero length, we detected a problem
if( -s "checkall.txt")
{
  print STDERR "\n WARNING! botchs, warnings or problems were found. \n Check the file checkall.txt for a list of names, checkall.asr for the asserts.\n\n";      
  system "grep Cloudy < checkall.txt ";
  system "grep botch  *.out >checkall.asr";
  $lgProblems = 1;
}
else
{
	print "no botched asserts so far ...\n";
}

# now look for string PROBLEM, which indicates an internal problem
# during the calculation
system "grep PROBLEM  *.out > problems.txt";
# if this file has non-zero length, we detected a problem
if( -s "problems.txt")
{
  print "\nPROBLEM string was found. \nCheck problems.txt for a list of names.\n\n";      
}
    
    
# check all output files to see whether they contain "Cloudy ends:"
# string and write corresponding line into checkend.txt file.
# if size of file $o_dir/checkend.txt is zero, then program crashed.  

printf( "now looking for models that did not end:\n");

$nMod = 0;
while(defined($output= glob("*.out")) )
{
	++$nMod;
	#system "grep 'Cloudy ends'  $output >checkend.txt";
	system "grep 'ChkAssert'  $output >checkend.txt";
	printf( "n");

#	if zero length, code did  not end
	if(-z "checkend.txt")
	{
	  printf( STDERR "\n Cloudy crashed or had no asserts in:%s \n" , $output );      
	  system "echo crash or no asserts in $output >> checkall.txt ";
  	  $lgProblems = 1;
	}
}

# check whether any models were skipped because they were renamed *.skip
system "ls *.skip > skip.txt" ;
# skipfile will have non-zero length if *.skip returned any names
if( -s "skip.txt" )
{
   print STDERR "\n\n some files were skipped by renmaing to .skip - list is in skip.txt\n" ;
   system "echo some files were skipped by renmaing to .skip - list is in skip.txt >> checkall.txt ";
}

printf( "\n %i models were checked.\n ",$nMod);

if( $lgProblems )
{
	print "\n problems were found, see checkall.txt for summary\n\n ";
}
else
{
	print "\n\nCongratulations!! No problems were found\n\n";
}
