/* This file is part of Cloudy and is copyright (C) 1978-2004 by Gary J. Ferland.
 * For conditions of distribution and use, see copyright notice in license.txt */
/* these routines are in FeIILevelPops.c */
/* called by assert feii depart coef command */
void AssertFeIIDep( double *pred , double *BigError , double *StdDev );

void FeIIFillLow16(void);

/* reads in feii data from disk, creates space for main arrays */
void FeIICreate(void);
void FeIIPrint(void);

void FeIILevelPops(void);

/* called in LineSet4, this sums over FeII bands and returns intensities
 * args are lower and upper edges of bands as set in fe2bands.dat */
double FeIISumBand(float wl1, 
	  float wl2);

void FeIITauInc(void);

void FeIITauAver(void);

void FeIIPoint(void);

void FeIIAccel(double *fe2drive);

void FeIIRTMake( int lgDoEsc , 
				int lgUpdateFineOpac );

/* called by LineSet4, this adds feii line intensities together */
void FeIIAddLines( void );

/* called by dopunch, this creates the punch verner file */
void FeIIPunchLines( FILE * ioPUN );

/*void FeIIEmitOut(double VolFac, 
  double ref);*/

/* initialize optical depth arrays, called by TauOut */
void FeII_LineZero(void);

/*FeIIIntenZero zero out intensity of FeII atom */
void FeIIIntenZero(void);

/* rad pre due to FeII lines called in PresTotCurrent*/
double FeIIRadPress(void);

/* internal energy of FeII called in PresTotCurrent */
double FeII_InterEnergy(void);

/* punch some departure coef for large atom, set with punch feii departure command*/
void FeIIPunDepart(FILE* ioPUN , 
	/* option to punch all dep coef if TRUE */
	int lgDoAll );

void PunFeII( FILE * io );

/* send the departure coef for physical level nPUN to unit ioPUN */
void FeIIPun1Depart( 
	/* the io unit where the print should be directed */
	FILE * ioPUN , 
	/* the physical (not c) number of the level */
	long int nPUN );
/* punch line data for FeII atom */
void FeIIPunData(
	/* io unit for punch */
	FILE* ioPUN ,
	/* punch all levels if true, only subset if false */
	int lgDoAll );

/* punch some level pops for large atom, set with punch feii level populations command*/
void FeIIPunPop(FILE* ioPUN , 
	/* option to punch all level pops if TRUE */
	int lgDoAll );

/* include FeII lines in punched optical depths, etc, called from PunchLineStuff */
void FeIIPunchLineStuff( FILE * io , float xLimit  , long index);

/* send the level pops for physical level nPUN to unit ioPUN */
void FeIIPun1Pop( 
	/* the io unit where the print should be directed */
	FILE * ioPUN , 
	/* the physical (not c) number of the level */
	long int nPUN );

/* zero out variables that deal with FeII, called by zero */
void FeIIZero(void);

/* initialize some variables, called by zero */
void FeIIReset(void);

/* do OTS and outward parts of FeII lines, if large atom is turned on */
void FeII_OTS(void);

/* do outward rates for FeII, called by RT_diffuse */
void FeII_RTOut(void);

/*ParseAtomFeII parse the atom feii command */
void ParseAtomFeII(char *chCard );

/* this is the number of levels for the large FeII atom */
#define	NFE2LEVN	371

/* this is set true when space is allocated for the FeII arrays,
 * once this happens nFeIILevel cannot be changed with the atom feii levels command 
 * set false in cddefines */
extern int lgFeIIMalloc;

/* number of levels for the large FeII atom, changed with the atom feii levels command 
 * set to NFE2LEVN in cddefines */
EXTERN long int nFeIILevel;
/* this remembers number of FeII levels allocated when MALLOC first called.  */
EXTERN long int nFeIILevelAlloc;

EXTERN struct t_fe2 {
	/*
	 * lgFeIION is set true if the feii verner command is given, 
	 */
	int lgFeIION;

	/* option to always evaluate model atom, set with SLOW key on atom feii command */
	int lgSlow;

	/* option to print calls to FeIILevelPops, set with print key on atom feii */
	int lgPrint;

	/* option to only simulate calls to FeIILevelPops */
	int lgSimulate;

	/* say which FeII atom this is, Verner or Netzer */
	char chFeIIAtom[7];

	/* punch verner short for shorter punch */
	int lgShortFe2;

	/* says whether (true) or not (false) pumping of the FeiI model atom by HI Lya is included
	 * normally true, set false with the NO FEII command */
	int lgLyaPumpOn;

	/* energy range for FeII lines output with punch verner, 
	 * set with punch verner range e ryd, e ryd */
	float fe2ener[2];

	/* energy range and threshold for FeII lines output with punch verner */
	float fe2thresh;

	/* these are the lower and upper bounds to the FeII continuum, in Angstroms,*/
	float fe2con_wl1 , fe2con_wl2;
	/* the number of intervals to break the FeII continuum into */
	long int nfe2con;

	/* redistribution function to use for resonance and subordinate lines */
	int ipRedisFcnResonance;
	int ipRedisFcnSubordinate;

	/* cooling computed by large FeII model atom
	 * fcool is total cooling (or heating if negative)
	 * and dfcool is its derivative wrt temperature */
	float fcool, 
	  dfcool, 
	  feheat;

	/* total cooling due to 16 level model FeII atom
	 * fe2cool is total cooling due to 16 level atom, */
	double Fe2L16Tot;
	/* lines from the lowest 16 levels, predicted in both Fe2Lev16
	 * and FeIILevelPops routine FeIIFillLow16*/
	double fe21308, 
	  fe21207, 
	  fe21106, 
	  fe21006, 
	  fe21204, 
	  fe21103, 
	  fe21104, 
	  fe21001, 
	  fe21002, 
	  fe20201, 
	  fe20302, 
	  fe20706, 
	  fe20807, 
	  fe20908, 
	  fe21007, 
	  fe21107, 
	  fe21108, 
	  fe21110, 
	  fe21507, 
	  fe21208, 
	  fe21209, 
	  fe21211, 
	  fe21406, 
	  fe21508, 
	  fe21609;
	/* these are only predicted by the very large feii atom */
	double 
	fe25to6 ,
	fe27to7 ,
	fe28to8 ,
	fe29to9 ,
 	fe32to6 ,
 	fe33to7 ,
 	fe37to7 ,
 	fe39to8 ,
 	fe40to9 ,
 	fe37to6 ,
 	fe39to7 ,
 	fe40to8 ,
 	fe41to9 ,
 	fe39to6 ,
 	fe40to7 ,
	fe42to7 ,
 	fe41to8 ,
	fe42to6 ,
	fe43to7 ,
	fe36to2 ,
	fe36to3 ,
	fe32to1 ,
	fe33to2 ,
	fe36to5 ,
	fe32to2 ,
	fe33to3 ,
	fe30to3 ,
	fe33to6 ,
	fe24to2 ,
	fe32to7 ,
	fe35to8 ,
	fe34to8 ,
	fe27to6 ,
	fe28to7 ,
	fe30to8 ,
	fe24to6 ,
	fe29to8 ,
	fe24to7 ,
	fe22to7 ,
	fe38to11 ,
	fe19to8 ,
	fe17to6 ,
	fe18to7 ,
	fe18to8 ,
	fe80to28 ,
	fe17to7 ;

	}	FeII;

	/* this info used to estimate destruction of Lya by overlap with FeII
 * in case where large atom is not turned on */

/*  number of FeII lines in Fred's atom */
#define	NFEII	373

/*Fe2_ovr_DataInit storing energy levels for Fred's FeII ground,
 * called */
void Fe2_ovr_DataInit(void);

/*atoms_fe2ovr compute FeII overlap with Lya */
void atoms_fe2ovr(void);

/*pfeii create punch output describing pumping of FeII by Lya */
void pfeii(FILE* io);

EXTERN struct t_ipfe2Com {
	long int ipfe2[NFEII];

	/* opacity and optical depths for ground of Fred's FeII atom */
	float feopc[NFEII], 
	  Fe2TauLte[NFEII], 
	  Fe2PopLte[NFEII];

	float fe2lam[NFEII], 
	  fe2osc[NFEII], 
	  fe2enr[NFEII], 
	  fe2gs[NFEII];

}	fe2ovr_la;
