/* This file is part of Cloudy and is copyright (C) 1978-2004 by Gary J. Ferland.
 * For conditions of distribution and use, see copyright notice in license.txt */
/*CO_step fills in matrix for heavy elements molecular routines */
/*CO_PopsEmisCool evaluate rotation levels populations, emission, and cooling */
/*cdCO_colden return column density in H2, negative -1 if cannot find state,
 * header is cddrive */
/*CO_Init called from cdInit to initialized co routines */
/* 
 * change following to TRUE to turn on debug statements 
 *
 * Nick Abel between July and October of 2003 assisted Dr. Ferland in improving the heavy element 
 * molecular network in Cloudy. Before this routine would predict negative abundances if 
 * the fraction of carbon in the form of molecules came close to 100%. A reorganizing of 
 * the reaction network detected several bugs.  Treatment of "coupled reactions",
 * in which both densities in the reaction rate were being predicted by Cloudy, were also 
 * added.  Due to these improvements, Cloudy can now perform calculations
 * where 100% of the carbon is in the form of CO without predicting negative abundances
 *
 * Additional changes were made in November of 2003 so that our reaction 
 * network would include all reactions from the TH85 paper.  This involved 
 * adding silicon to the chemical network.  Also the reaction rates were
 * labeled to make identification with the reaction easier and the matrix 
 * elements of atomic C, O, and Si are now done in a loop, which makes 
 * the addition of future chemical species (like N or S) easy.
 * */
/*   */
/*   */
/*   */
#include "cddefines.h"
#include "physconst.h"
#include "taulines.h"
#include "secondaries.h"
#include "dense.h"
#include "ionbal.h"
#include "thermal.h"
#include "grainvar.h"
#include "hmi.h"
#include "converge.h"
#include "trace.h"
#include "radius.h"
#include "rfield.h"
#include "atoms.h"
#include "phycon.h"
#include "doppvel.h"
#include "rt.h"
#include "lines_service.h"
#include "coolheavy.h"
#include "timesc.h"
#include "lapack.h"
#include "hmrate.h"
#include "cddrive.h"
#include "co.h"
/*lint -e778 constant expression evaluatess to 0 in operation '-' */
/*=================================================================*/

/* will be used to save CO column densities */
static double *col12 , *col13;

/*CO_Init called from cdInit to initialized co routines */
void CO_Init(void)
{
	long int i;

#	ifdef DEBUG_FUN
	fputs( "<+>CO_Init()\n", debug_fp );
#	endif

	/* these tell the molecular solver what zone and iteration it has
	 * been evaluated on */
	co.co_nzone = -2;
	co.iteration_co = -2;

	/* atomic number of element that limits each molecule */
	co.nelem_hevmol[ipCH] = ipCARBON;
	co.nelem_hevmol[ipCHP] = ipCARBON;
	co.nelem_hevmol[ipOH] = ipOXYGEN;
	co.nelem_hevmol[ipOHP] = ipOXYGEN;
	co.nelem_hevmol[ipO2] = ipOXYGEN;
	co.nelem_hevmol[ipCO] = ipCARBON;
	co.nelem_hevmol[ipCOP] = ipCARBON;
	co.nelem_hevmol[ipH2O] = ipOXYGEN;
	co.nelem_hevmol[ipH2OP] = ipOXYGEN;
	co.nelem_hevmol[ipO2P] = ipOXYGEN;
	co.nelem_hevmol[ipH3OP] = ipOXYGEN;
	co.nelem_hevmol[ipCH2P] = ipCARBON;
	co.nelem_hevmol[ipCH2] = ipCARBON;
	co.nelem_hevmol[ipHCOP] = ipCARBON;
	co.nelem_hevmol[ipCH3P] = ipCARBON;
	co.nelem_hevmol[ipCH3] = ipCARBON;
	co.nelem_hevmol[ipCH4] = ipCARBON;
	co.nelem_hevmol[ipCH4P] = ipCARBON;
	co.nelem_hevmol[ipCH5P] = ipCARBON;
	co.nelem_hevmol[ipSIH2P] = ipSILICON;
	co.nelem_hevmol[ipSIH] = ipSILICON;
	co.nelem_hevmol[ipHOSIP] = ipSILICON;
	co.nelem_hevmol[ipSIO] = ipSILICON;
	co.nelem_hevmol[ipSIOP] = ipSILICON;
	co.nelem_hevmol[ipCP] = ipCARBON;
	co.nelem_hevmol[ipOP] = ipOXYGEN;
	co.nelem_hevmol[ipSIP] = ipSILICON;
	co.nelem_hevmol[ipATC] = ipCARBON;
	co.nelem_hevmol[ipATO] = ipOXYGEN;
	co.nelem_hevmol[ipATSI] = ipSILICON;
	co.nelem_hevmol[ipN2] = ipNITROGEN;
	co.nelem_hevmol[ipN2P] = ipNITROGEN;
	co.nelem_hevmol[ipNO] = ipNITROGEN;
	co.nelem_hevmol[ipNOP] = ipNITROGEN;
	co.nelem_hevmol[ipS2] = ipSULPHUR;
	co.nelem_hevmol[ipS2P] = ipSULPHUR;
	co.nelem_hevmol[ipOCN] = ipNITROGEN;
	co.nelem_hevmol[ipOCNP] = ipNITROGEN;
	co.nelem_hevmol[ipNH] = ipNITROGEN;
	co.nelem_hevmol[ipNHP] = ipNITROGEN;
	co.nelem_hevmol[ipNH2] = ipNITROGEN;
	co.nelem_hevmol[ipNH2P] = ipNITROGEN;
	co.nelem_hevmol[ipNH3] = ipNITROGEN;
	co.nelem_hevmol[ipNH3P] = ipNITROGEN;
	co.nelem_hevmol[ipNH4P] = ipNITROGEN;
	co.nelem_hevmol[ipCN] = ipNITROGEN;
	co.nelem_hevmol[ipCNP] = ipNITROGEN;
	co.nelem_hevmol[ipHCN] = ipNITROGEN;
	co.nelem_hevmol[ipHCNP] = ipNITROGEN;
	co.nelem_hevmol[ipHNO] = ipNITROGEN;
	co.nelem_hevmol[ipHNOP] = ipNITROGEN;
	co.nelem_hevmol[ipHS] = ipSULPHUR;
	co.nelem_hevmol[ipHSP] = ipSULPHUR;
	co.nelem_hevmol[ipCS] = ipSULPHUR;
	co.nelem_hevmol[ipCSP] = ipSULPHUR;
	co.nelem_hevmol[ipNO2] = ipNITROGEN;
	co.nelem_hevmol[ipNO2P] = ipNITROGEN;
	co.nelem_hevmol[ipNS] = ipSULPHUR;
	co.nelem_hevmol[ipNSP] = ipSULPHUR;
	co.nelem_hevmol[ipSO] = ipSULPHUR;
	co.nelem_hevmol[ipSOP] = ipSULPHUR;
	co.nelem_hevmol[ipSIN] = ipSILICON;
	co.nelem_hevmol[ipSINP] = ipSILICON;
	co.nelem_hevmol[ipN2O] = ipNITROGEN;
	co.nelem_hevmol[ipHCSP] = ipSULPHUR;
	co.nelem_hevmol[ipOCS] = ipSULPHUR;
	co.nelem_hevmol[ipOCSP] = ipSULPHUR;
	co.nelem_hevmol[ipNP] = ipNITROGEN;
	co.nelem_hevmol[ipSP] = ipSULPHUR;
	co.nelem_hevmol[ipATN] = ipNITROGEN;
	co.nelem_hevmol[ipATS] = ipSULPHUR;



	/* number of H, O, C, Si,  and e- in each molecule */
	for( i=0; i< NUM_COMOLE_CALC; ++i )
	{
		co.nOxyg[i] = 0;
		co.nCarb[i] = 0;
		co.nElec[i] = 0;
		co.nHydr[i] = 0;
		co.nSulp[i] = 0;
		co.nNitr[i] = 0;
		co.nElec[i] = 0;

		co.co_save[i] = 0.;
	}
	/* set up array indices  */
	strcpy( co.chLab[ipCH],   "CH   " );
	co.nCarb[ipCH] = 1;
	co.nHydr[ipCH] = 1;

	strcpy( co.chLab[ipCHP],  "CH+  " );
	co.nCarb[ipCHP] = 1;
	co.nHydr[ipCHP] = 1;
	co.nElec[ipCHP] = 1;

	strcpy( co.chLab[ipOH],   "OH   " );
	co.nOxyg[ipOH] = 1;
	co.nHydr[ipOH] = 1;

	strcpy( co.chLab[ipOHP],  "OH+  " );
	co.nOxyg[ipOHP] = 1;
	co.nElec[ipOHP] = 1;
	co.nHydr[ipOHP] = 1;

	strcpy( co.chLab[ipO2],   "O2   " );
	co.nOxyg[ipO2] = 2;
	
	strcpy( co.chLab[ipCO],   "CO   " );
	co.nOxyg[ipCO] = 1;
	co.nCarb[ipCO] = 1;
	
	strcpy( co.chLab[ipCOP],  "CO+  " );
	co.nOxyg[ipCOP] = 1;
	co.nCarb[ipCOP] = 1;
	co.nElec[ipCOP] = 1;
	
	strcpy( co.chLab[ipH2O],  "H2O  " );
	co.nOxyg[ipH2O] = 1;
	co.nHydr[ipH2O] = 2;

	strcpy( co.chLab[ipH2OP], "H2O+ " );
	co.nOxyg[ipH2OP] = 1;
	co.nElec[ipH2OP] = 1;
	co.nHydr[ipH2OP] = 2;

	strcpy( co.chLab[ipO2P],  "O2+  " );
	co.nOxyg[ipO2P] = 2;
	co.nElec[ipO2P] = 1;
	
	strcpy( co.chLab[ipH3OP], "H3O+ " );
	co.nOxyg[ipH3OP] = 1;
	co.nElec[ipH3OP] = 1;
	co.nHydr[ipH3OP] = 3;

	strcpy( co.chLab[ipCH2P], "CH2+ " );
	co.nCarb[ipCH2P] = 1;
	co.nElec[ipCH2P] = 1;
	co.nHydr[ipCH2P] = 2;

	strcpy( co.chLab[ipCH2],  "CH2  " );
	co.nCarb[ipCH2] = 1;
	co.nHydr[ipCH2] = 2;

	strcpy( co.chLab[ipHCOP], "HCO+ " );
	co.nOxyg[ipHCOP] = 1;
	co.nCarb[ipHCOP] = 1;
	co.nElec[ipHCOP] = 1;
	co.nHydr[ipHCOP] = 1;

	strcpy( co.chLab[ipCH3P], "CH3+ " );
	co.nHydr[ipCH3P] = 3;
	co.nCarb[ipCH3P] = 1;
	co.nElec[ipCH3P] = 1;

	strcpy( co.chLab[ipCH3],  "CH3  " );
	co.nHydr[ipCH3] = 3;
	co.nCarb[ipCH3] = 1;
	
	strcpy( co.chLab[ipCH4],  "CH4  " );
	co.nHydr[ipCH4] = 4;
	co.nCarb[ipCH4] = 1;
	
	strcpy( co.chLab[ipCH4P], "CH4+ " );
	co.nHydr[ipCH4P] = 4;
	co.nCarb[ipCH4P] = 1;
	co.nElec[ipCH4P] = 1;

	strcpy( co.chLab[ipCH5P], "CH5+ " );
	co.nHydr[ipCH5P] = 5;
	co.nCarb[ipCH5P] = 1;
	co.nElec[ipCH5P] = 1;
	
	strcpy( co.chLab[ipSIH2P],"SiH2+" );
	co.nHydr[ipSIH2P] = 2;
	co.nSili[ipSIH2P] = 1;
	co.nElec[ipSIH2P] = 1;
	
	strcpy( co.chLab[ipSIH],  "SiH  " );
	co.nHydr[ipSIH] = 1;
	co.nSili[ipSIH] = 1;

	strcpy( co.chLab[ipHOSIP],"HOSi+" );
	co.nOxyg[ipHOSIP] = 1;
	co.nElec[ipHOSIP] = 1;
	co.nHydr[ipHOSIP] = 1;
	co.nSili[ipHOSIP] = 1;

	strcpy( co.chLab[ipSIO],  "SiO  " );
	co.nOxyg[ipSIO] = 1;
	co.nSili[ipSIO] = 1;

	strcpy( co.chLab[ipSIOP], "SiO+ " );
	co.nOxyg[ipSIOP] = 1;
	co.nSili[ipSIOP] = 1;
	co.nElec[ipSIOP] = 1;

	strcpy( co.chLab[ipN2],   "N2   " );
	
	co.nNitr[ipN2] = 2;

	strcpy( co.chLab[ipN2P],  "N2+  " );
	
	co.nNitr[ipN2P] = 2;
	co.nElec[ipN2P] = 1;

	strcpy( co.chLab[ipNO],   "NO   " );

	co.nOxyg[ipNO] = 1;
	co.nNitr[ipNO] = 1;

	strcpy( co.chLab[ipNOP],  "NO+  " );

	co.nOxyg[ipNOP] = 1;
	co.nElec[ipNOP] = 1;
	co.nNitr[ipNOP] = 1;

	strcpy( co.chLab[ipS2],   "S2   " );
	
	co.nSulp[ipS2] = 2;

	strcpy( co.chLab[ipS2P],  "S2+  " );
	
	co.nSulp[ipS2P] = 2;
	co.nElec[ipS2P] = 1;

	strcpy( co.chLab[ipOCN],  "OCN  " );

	co.nOxyg[ipOCN] = 1;
	co.nCarb[ipOCN] = 1;
	co.nNitr[ipOCN] = 1;

	strcpy( co.chLab[ipOCNP], "OCN+ " );
	
	co.nOxyg[ipOCNP] = 1;
	co.nCarb[ipOCNP] = 1;
	co.nElec[ipOCNP] = 1;
	co.nNitr[ipOCNP] = 1;

	strcpy( co.chLab[ipNH],   "NH   " );
	
	co.nNitr[ipNH] = 1;
	co.nHydr[ipNH] = 1;

	strcpy( co.chLab[ipNHP],  "NH+  " );
	
	co.nNitr[ipNHP] = 1;
	co.nElec[ipNHP] = 1;
	co.nHydr[ipNHP] = 1;

	strcpy( co.chLab[ipNH2],  "NH2  " );
	
	co.nNitr[ipNH2] = 1;
	co.nHydr[ipNH2] = 2;

	strcpy( co.chLab[ipNH2P], "NH2+ " );
	
	co.nNitr[ipNH2P] = 1;
	co.nElec[ipNH2P] = 1;
	co.nHydr[ipNH2P] = 2;

	strcpy( co.chLab[ipNH3],  "NH3  " );
	
	co.nNitr[ipNH3] = 1;
	co.nHydr[ipNH3] = 3;

	strcpy( co.chLab[ipNH3P], "NH3+ " );
	
	co.nNitr[ipNH3P] = 1;
	co.nElec[ipNH3P] = 1;
	co.nHydr[ipNH3P] = 3;

	strcpy( co.chLab[ipNH4P], "NH4+ " );
	
	co.nNitr[ipNH4P] = 1;
	co.nElec[ipNH4P] = 1;
	co.nHydr[ipNH4P] = 4;

	strcpy( co.chLab[ipCN],   "CN   " );
	
	co.nCarb[ipCN] = 1;
	co.nNitr[ipCN] = 1;

	strcpy( co.chLab[ipCNP],  "CN+  " );
	
	co.nCarb[ipCNP] = 1;
	co.nElec[ipCNP] = 1;
	co.nNitr[ipCNP] = 1;

	strcpy( co.chLab[ipHCN],  "HCN  " );
	
	co.nCarb[ipHCN] = 1;
	co.nNitr[ipHCN] = 1;
	co.nHydr[ipHCN] = 1;

	strcpy( co.chLab[ipHCNP], "HCN+ " );
	
	co.nNitr[ipHCNP] = 1;
	co.nCarb[ipHCNP] = 1;
	co.nElec[ipHCNP] = 1;
	co.nHydr[ipHCNP] = 1;

	strcpy( co.chLab[ipHNO],  "HNO  " );

	co.nOxyg[ipHNO] = 1;
	co.nNitr[ipHNO] = 1;
	co.nHydr[ipHNO] = 1;

	strcpy( co.chLab[ipHNOP], "HNO+ " );

	co.nOxyg[ipHNOP] = 1;
	co.nNitr[ipHNOP] = 1;
	co.nElec[ipHNOP] = 1;
	co.nHydr[ipHNOP] = 1;

	strcpy( co.chLab[ipHS],   "HS   " );
	
	co.nHydr[ipHS] = 1;
	co.nSulp[ipHS] = 1;

	strcpy( co.chLab[ipHSP],  "HS+  " );
	
	co.nSulp[ipHSP] = 1;
	co.nElec[ipHSP] = 1;
	co.nHydr[ipHSP] = 1;

	strcpy( co.chLab[ipCS],   "CS   " );
	
	co.nCarb[ipCS] = 1;
	co.nSulp[ipCS] = 1;

	strcpy( co.chLab[ipCSP],  "CS+  " );
	
	co.nCarb[ipCSP] = 1;
	co.nElec[ipCSP] = 1;
	co.nSulp[ipCSP] = 1;

	strcpy( co.chLab[ipNO2],  "NO2  " );

	co.nOxyg[ipNO2] = 2;
	co.nNitr[ipNO2] = 1;

	strcpy( co.chLab[ipNO2P], "NO2+ " );

	co.nOxyg[ipNO2P] = 2;
	co.nNitr[ipNO2P] = 1;
	co.nElec[ipNO2P] = 1;

	strcpy( co.chLab[ipNS],   "NS   " );
	
	co.nNitr[ipNS] = 1;
	co.nSulp[ipNS] = 1;

	strcpy( co.chLab[ipNSP],  "NS+  " );
	
	co.nNitr[ipNSP] = 1;
	co.nElec[ipNSP] = 1;
	co.nSulp[ipNSP] = 1;

	strcpy( co.chLab[ipSO],   "SO   " );
	co.nOxyg[ipSO] = 1;
	co.nSulp[ipSO] = 1;

	strcpy( co.chLab[ipSOP],  "SO+  " );

	co.nOxyg[ipSOP] = 1;
	co.nElec[ipSOP] = 1;
	co.nSulp[ipSOP] = 1;

	strcpy( co.chLab[ipSIN],  "SiN  " );
	
	co.nSili[ipSIN] = 1;
	co.nNitr[ipSIN] = 1;

	strcpy( co.chLab[ipSINP], "SiN+ " );
	
	co.nSili[ipSINP] = 1;
	co.nElec[ipSINP] = 1;
	co.nNitr[ipSINP] = 1;

	strcpy( co.chLab[ipN2O],  "N2O  " );

	co.nOxyg[ipN2O] = 1;
	co.nNitr[ipN2O] = 2;

	strcpy( co.chLab[ipHCSP], "HCS+ " );
	
	co.nCarb[ipHCSP] = 1;
	co.nSulp[ipHCSP] = 1;
	co.nElec[ipHCSP] = 1;
	co.nHydr[ipHCSP] = 1;

	strcpy( co.chLab[ipOCS],  "OCS  " );

	co.nOxyg[ipOCS] = 1;
	co.nCarb[ipOCS] = 1;
	co.nSulp[ipOCS] = 1;

	strcpy( co.chLab[ipOCSP], "OCS+ " );

	co.nOxyg[ipOCSP] = 1;
	co.nCarb[ipOCSP] = 1;
	co.nElec[ipOCSP] = 1;
	co.nSulp[ipOCSP] = 1;

	strcpy( co.chLab[ipCP],   "C+   " );
	co.nCarb[ipCP] = 1;
	
	strcpy( co.chLab[ipOP],   "O+   " );
	co.nOxyg[ipOP] = 1;

	strcpy( co.chLab[ipSIP],  "Si+  " );
	co.nSili[ipSIP] = 1;

	strcpy( co.chLab[ipATC],  "C    " );
	co.nCarb[ipATC] = 1;
	
	strcpy( co.chLab[ipATO],  "O    " );
	co.nOxyg[ipATO] = 1;		

	strcpy( co.chLab[ipATSI], "Si   " );
	co.nSili[ipATSI] = 1;

	strcpy( co.chLab[ipNP],   "N+   " );
	co.nNitr[ipNP] = 1;

	strcpy( co.chLab[ipATN],  "N    " );
	co.nNitr[ipATN] = 1;
	
	strcpy( co.chLab[ipATS],  "S    " );
	co.nSulp[ipATS] = 1;

	strcpy( co.chLab[ipSP],   "S+   " );
	co.nSulp[ipSP] = 1;		



	/* rate for He+ + CO -> He + O + C+ */
	co.rate_co_hep_o_cp_he = 0.;


#	ifdef DEBUG_FUN
	fputs( " <->CO_Init()\n", debug_fp );
#	endif

	return;

}

/*CO_step fills in matrix for heavy elements molecular routines */
void CO_step(
	/* set true if we found neg pops */
	int *lgNegPop, 
	/* set true if we tried to compute the pops, but some were zero */
	int *lgZerPop )
{

	/* this routine works with the heavy molecules, of which there are NUM_HEAVY_MOLEC,
	 * plus C and O, making a total of NUM_COMOLE_CALC*/
	int32 ipiv[NUM_COMOLE_CALC], merror;
	long int i, j;
	double 
	C_CH2_CH_CH_1,
	C_COP_CO_CP_1,
	C_H2OP_OH_CHP_1,
	C_H3OP_HCOP_H2_1,
	C_HCOP_CO_CHP_1,
	C_O_CO_nu_1,
	C_O2_CO_O_1,
	C_O2P_O2_CP_1,
	C_O2P_COP_O_1,
	C_OH_O_CH_1,
	C_OH_CO_H_1,
	C_OHP_O_CHP_1,
	C_SiOP_SiP_CO_1,
	CP_OH_CO_HP_1,
	CP_CH_CHP_C_1,
	CP_SiO_SiP_CO_1,
	CP_CH2_CH2P_C_1,
	CP_H2O_HCOP_H_1,
	CP_O_COP_nu_1,
	CP_O2_COP_O_1,
	CP_O2_CO_OP_1,
	CP_OH_COP_H_1,
	O_CH_OH_C_1,
	O_CH_HCOP_e_1,
	O_CH_CO_H_1,
	O_CHP_COP_H_1,
	O_CH2_OH_CH_1,
	O_CH2_CO_H_H_1,
	O_CH2_CO_H2_1,
	O_CH2P_HCOP_H_1,
	O_CH3P_HCOP_H2_1,
	O_COP_CO_OP_1,
	O_H2O_OH_OH_1,
	O_H2OP_O2P_H2_1,
	O_O_O2_nu_1,
	O_OH_O2_H_1,
	O_OHP_O2P_H_1,
	O_Si_SiO_nu_1,
	O_SiP_SiOP_nu_1,
	O_SiH_SiO_H_1,
	O_SiH2P_SiOHP_H_1,
	O_SiOP_O2_SiP_1,
	OP_CH_O_CHP_1,
	OP_CH_COP_H_1,
	OP_CH2_O_CH2P_1,
	OP_CO_COP_O_1,
	OP_H2O_H2OP_O_1,
	OP_O2_O2P_O_1,
	OP_OH_O2P_H_1,
	OP_OH_OHP_O_1,
	Si_CHP_SiP_CH_1,
	Si_H2OP_SiP_H2O_1,
	Si_OH_SiO_H_1,
	Si_O2P_O2_SiP_1,
	SiP_H2O_SiOHP_H_1,
	SiP_OH_SiOP_H_1,
	SiP_O2_SiOP_O_1,
	CH_COP_HCOP_C_1,
	CH_COP_CO_CHP_1,
	CH_H2OP_H2O_CHP_1,
	CH_H2OP_OH_CH2P_1,
	CH_H3OP_H2O_CH2P_1,
	CH_HCOP_CO_CH2P_1,
	CH_O2_CO_OH_1,
	CH_O2P_O2_CHP_1,
	CH_O2P_HCOP_O_1,
	CH_OHP_OH_CHP_1,
	CH_OHP_O_CH2P_1,
	CH_SiOP_HCOP_Si_1,
	CHP_H2O_H3OP_C_1,
	CHP_OH_COP_H2_1,
	CHP_H2O_HCOP_H2_1,
	CHP_O2_HCOP_O_1,
	CHP_O2_COP_OH_1,
	CH2_COP_HCOP_CH_1,
	CH2_COP_CO_CH2P_1,
	CH2_H2OP_H2O_CH2P_1,
	CH2_H2OP_OH_CH3P_1,
	CH2_H3OP_H2O_CH3P_1,
	CH2_HCOP_CO_CH3P_1,
	CH2_O2_CO_H2O_1,
	CH2_O2P_O2_CH2P_1,
	CH2_OH_H2O_CH_1,
	CH2_OHP_OH_CH2P_1,
	CH2_OHP_O_CH3P_1,
	CH2P_O2_HCOP_OH_1,
	COP_O2_O2P_CO_1,
	H2O_COP_CO_H2OP_1,
	H2O_COP_HCOP_OH_1,
	H2O_HCOP_CO_H3OP_1,
	H2OP_CO_HCOP_OH_1,
	H2OP_H2O_H3OP_OH_1,
	H2OP_O2_O2P_H2O_1,
	H3OP_SiH_SiH2P_H2O_1,
	H3OP_SiO_SiOHP_H2O_1,
	HCOP_SiH_SiH2P_CO_1,
	HCOP_SiO_SiOHP_CO_1,
	OH_COP_HCOP_O_1,
	OH_COP_CO_OHP_1,
	OH_H2OP_H3OP_O_1,
	OH_HCOP_CO_H2OP_1,
	OH_OH_H2O_O_1,
	OHP_CO_HCOP_O_1,
	OHP_H2O_H3OP_O_1,
	OHP_H2O_H2OP_OH_1,
	OHP_O2_O2P_OH_1,
	OHP_OH_H2OP_O_1,
	OHP_SiH_SiH2P_O_1,
	OHP_SiO_SiOHP_O_1,
	C_CH2_CH_CH_2,
	C_COP_CO_CP_2,
	C_H2OP_OH_CHP_2,
	C_H3OP_HCOP_H2_2,
	C_HCOP_CO_CHP_2,
	C_O_CO_nu_2,
	C_O2_CO_O_2,
	C_O2P_O2_CP_2,
	C_O2P_COP_O_2,
	C_OH_O_CH_2,
	C_OH_CO_H_2,
	C_OHP_O_CHP_2,
	C_SiOP_SiP_CO_2,
	CP_OH_CO_HP_2,
	CP_CH_CHP_C_2,
	CP_SiO_SiP_CO_2,
	CP_CH2_CH2P_C_2,
	CP_H2O_HCOP_H_2,
	CP_O_COP_nu_2,
	CP_O2_COP_O_2,
	CP_O2_CO_OP_2,
	CP_OH_COP_H_2,
	O_CH_OH_C_2,
	O_CH_HCOP_e_2,
	O_CH_CO_H_2,
	O_CHP_COP_H_2,
	O_CH2_OH_CH_2,
	O_CH2_CO_H_H_2,
	O_CH2_CO_H2_2,
	O_CH2P_HCOP_H_2,
	O_CH3P_HCOP_H2_2,
	O_COP_CO_OP_2,
	O_H2O_OH_OH_2,
	O_H2OP_O2P_H2_2,
	O_O_O2_nu_2,
	O_OH_O2_H_2,
	O_OHP_O2P_H_2,
	O_Si_SiO_nu_2,
	O_SiP_SiOP_nu_2,
	O_SiH_SiO_H_2,
	O_SiH2P_SiOHP_H_2,
	O_SiOP_O2_SiP_2,
	OP_CH_O_CHP_2,
	OP_CH_COP_H_2,
	OP_CH2_O_CH2P_2,
	OP_CO_COP_O_2,
	OP_H2O_H2OP_O_2,
	OP_O2_O2P_O_2,
	OP_OH_O2P_H_2,
	OP_OH_OHP_O_2,
	Si_CHP_SiP_CH_2,
	Si_H2OP_SiP_H2O_2,
	Si_OH_SiO_H_2,
	Si_O2P_O2_SiP_2,
	SiP_H2O_SiOHP_H_2,
	SiP_OH_SiOP_H_2,
	SiP_O2_SiOP_O_2,
	CH_COP_HCOP_C_2,
	CH_COP_CO_CHP_2,
	CH_H2OP_H2O_CHP_2,
	CH_H2OP_OH_CH2P_2,
	CH_H3OP_H2O_CH2P_2,
	CH_HCOP_CO_CH2P_2,
	CH_O2_CO_OH_2,
	CH_O2P_O2_CHP_2,
	CH_O2P_HCOP_O_2,
	CH_OHP_OH_CHP_2,
	CH_OHP_O_CH2P_2,
	CH_SiOP_HCOP_Si_2,
	CHP_H2O_H3OP_C_2,
	CHP_OH_COP_H2_2,	
	CHP_H2O_HCOP_H2_2,
	CHP_O2_HCOP_O_2,
	CHP_O2_COP_OH_2,
	CH2_COP_HCOP_CH_2,
	CH2_COP_CO_CH2P_2,
	CH2_H2OP_H2O_CH2P_2,
	CH2_H2OP_OH_CH3P_2,
	CH2_H3OP_H2O_CH3P_2,
	CH2_HCOP_CO_CH3P_2,
	CH2_O2_CO_H2O_2,
	CH2_O2P_O2_CH2P_2,
	CH2_OH_H2O_CH_2,
	CH2_OHP_OH_CH2P_2,
	CH2_OHP_O_CH3P_2,
	CH2P_O2_HCOP_OH_2,
	COP_O2_O2P_CO_2,
	H2O_COP_CO_H2OP_2,
	H2O_COP_HCOP_OH_2,
	H2O_HCOP_CO_H3OP_2,
	H2OP_CO_HCOP_OH_2,
	H2OP_H2O_H3OP_OH_2,
	H2OP_O2_O2P_H2O_2,
	H3OP_SiH_SiH2P_H2O_2,
	H3OP_SiO_SiOHP_H2O_2,
	HCOP_SiH_SiH2P_CO_2,
	HCOP_SiO_SiOHP_CO_2,
	OH_COP_HCOP_O_2,
	OH_COP_CO_OHP_2,
	OH_H2OP_H3OP_O_2,
	OH_HCOP_CO_H2OP_2,
	OH_OH_H2O_O_2,
	OHP_CO_HCOP_O_2,
	OHP_H2O_H3OP_O_2,
	OHP_H2O_H2OP_OH_2,
	OHP_O2_O2P_OH_2,
	OHP_OH_H2OP_O_2,
	OHP_SiH_SiH2P_O_2,
	OHP_SiO_SiOHP_O_2,
	H_CH_C_H_H,
	H_OH_O_H_H,
	H_H2O_OH_H_H,
	H_COP_CO_HP,
	H_CH_C_H2,
	H_CHP_CP_H2,
	H_CH2_CH_H2,
	H_CH3P_CH2P_H2,
	H_OH_O_H2,
	H_H2O_OH_H2,
	H_O2_OH_O,
	H_O2_O_O_H,
	H_C_CH_nu,
	H_CP_CHP_nu,
	H_OH_H2O_nu,
	H_O_OH_nu,
	Hminus_CH_CH2_e,
	Hminus_C_CH_e,
	Hminus_OH_H2O_e,
	Hminus_O_OH_e,
	Hminus_HCOP_CO_H2,
	Hminus_H3OP_H2O_H2,
	Hminus_H3OP_OH_H2_H,
	HP_CH_CHP_H,
	HP_CH2_CH2P_H,
	HP_H2O_H2OP_H,
	HP_O2_O2P_H,
	HP_OH_OHP_H,
	HP_SiO_SiOP_H,
	HP_CH2_CHP_H2,
	HP_SiH_SiP_H2,
	H2_C_CH_H,
	H2_CP_CHP_H,
	H2_CH_CH2_H,
	H2_CHP_CH2P_H,
	H2_OH_H2O_H,
	H2_OHP_H2OP_H,
	H2_H2OP_H3OP_H,
	H2_COP_HCOP_H,
	H2_O_OH_H,
	H2_OP_OHP_H,
	H2_SiOP_SiOHP_H,
	H2_CH_C_H2_H,
	H2_OH_O_H2_H,
	H2_CH2P_CH3P_H,
	H2_H2O_OH_H2_H,
	H2_O2_O_O_H2,
	H2_O2_OH_OH,
	H2_C_CH2_nu,
	H2_CP_CH2P_nu,
	H2_SiP_SiH2P_nu,
	H2P_C_CHP_H,
	H2P_CH_CH2P_H,
	H2P_CH2_CH3P_H,
	H2P_OH_H2OP_H,
	H2P_H2O_H3OP_H,
	H2P_CO_HCOP_H,
	H2P_O_OHP_H,
	H2P_CH_CHP_H2,
	H2P_CH2_CH2P_H2,
	H2P_CO_COP_H2,
	H2P_H2O_H2OP_H2,
	H2P_O2_O2P_H2,
	H2P_OH_OHP_H2,
	H3P_C_CHP_H2,
	H3P_CH_CH2P_H2,
	H3P_CH2_CH3P_H2,
	H3P_OH_H2OP_H2,
	H3P_H2O_H3OP_H2,
	H3P_CO_HCOP_H2,
	H3P_O_OHP_H2,
	H3P_SiH_SiH2P_H2,
	H3P_SiO_SiOHP_H2,
	HeP_CO_OP_C_He,
	HeP_CO_O_CP_He,
	HeP_CH_CHP_He,
	HeP_H2O_H2OP_He,
	HeP_O2_O2P_He,
	HeP_Si_SiP_He,
	HeP_CH_CP_He_H,
	HeP_CH2_CHP_He_H,
	HeP_OH_OP_He_H,
	HeP_H2O_OHP_He_H,
	HeP_SiH_SiP_He_H,
	HeP_H2O_OH_He_HP,
	HeP_CH2_CP_He_H2,
	HeP_O2_OP_O_He,
	HeP_SiO_SiP_O_He,
	HeP_SiO_Si_OP_He,
	crnu_CH_C_H,
	crnu_CHP_CP_H,
	crnu_CO_O_C,
	crnu_H2O_OH_H,
	crnu_O2_O2P_e,
	crnu_O2_O_O,
	crnu_OH_O_H,
	crnu_SiH_Si_H,
	crnu_SiO_Si_O,
	CRP_CO_COP_e,
	nu_CH_CHP_e,
	nu_CH_C_H,
	nu_CHP_CP_H,
	nu_CH2_CH2P_e,
	nu_CH2_CH_H,
	nu_CH2P_CHP_H,
	nu_CH3P_CH2P_H,
	nu_CH3P_CHP_H2,
	nu_CO_O_C,
	nu_H2O_H2OP_e,
	nu_H2O_OH_H,
	nu_O2_O2P_e,
	nu_O2_O_O,
	nu_OH_OHP_e,
	nu_OH_O_H,
	nu_OHP_O_HP,
	nu_SiH_Si_H,
	nu_SiO_Si_O,
	e_CHP_C_H,
	e_CH2P_CH_H,
	e_CH2P_C_H_H,
	e_CH2P_C_H2,
	e_CH3P_C_H2_H,
	e_CH3P_CH2_H,
	e_CH3P_CH_H_H,
	e_CH3P_CH_H2,
	e_CH3P_CH3_nu,
	e_COP_O_C,
	e_H2OP_OH_H,
	e_H2OP_O_H_H,
	e_H2OP_O_H2,
	e_H3OP_H2O_H,
	e_H3OP_OH_H_H,
	e_H3OP_OH_H2,
	e_H3OP_O_H2_H,
	e_HCOP_CO_H,
	e_O2P_O_O,
	e_OHP_O_H,
	e_SiH2P_SiH_H,
	e_SiH2P_Si_H_H,
	e_SiH2P_Si_H2,
	e_SiOP_Si_O,
	e_SiOHP_SiO_H,
	e_SiOHP_Si_OH,
	co_e_c_o_e,
	h2s_ch_ch2_h,
	h2s_o_oh_h,
	h2s_oh_h2o_h,
	h2s_o2_twooh,
	h2s_c_ch_h,
	h2s_cp_chp_h,

	/* These reactions were put in by NPA so that we can have EXACTLY the same 
	   reaction network as the others in Leiden */

	H2s_CH_C_H2_H, 
	H2s_OH_O_H2_H, 
	H2s_H2O_OH_H2_H, 
	H2s_O2_O_O_H2, 
	H2s_CH2_CH3_H,  
	H2s_CH_CH3_nu,
	H2s_CH3_CH4_H,

	H_CH3_CH2_H2,
	H_CH4P_CH3P_H2,
	H_CH5P_CH4P_H2,
	H2_CH2_CH3_H,
	H2_CH_CH3_nu,
	H2_CH3_CH4_H,
	H2_CH4P_CH5P_H,
	H2_CH3P_CH5P_nu,
	H2P_CH4_CH3P_H2,
	H2P_CH4_CH4P_H2,
	H2P_CH4_CH5P_H,
	H3P_CH3_CH4P_H2,
	H3P_CH4_CH5P_H2,
	HeP_CH3_CHP_He,
	HeP_CH4_CHP_He,
	HeP_CH4_CH2P_He,
	HeP_CH4_CH3_He,
	HeP_CH4_CH3P_He,
	HeP_CH4_CH4P_He,
	Hminus_CH2_CH3_e,
	Hminus_CH3_CH4_e,
	HP_CH3_CH3P_H,
	HP_CH4_CH3P_H2,
	HP_CH4_CH4P_H,
	nu_CH3_CH3P_e,
	nu_CH3_CH2_H,
	nu_CH3_CH_H2,
	crnu_CH3_CH3P_e,
	crnu_CH3_CH2_H,
	crnu_CH3_CH_H2,
	nu_CH4_CH3_H,
	nu_CH4_CH2_H2,
	nu_CH4_CH_H2,
	crnu_CH4_CH2_H2,
	e_CH5P_CH3_H2,
	e_CH5P_CH4_H,
	e_CH4P_CH3_H,
	e_CH4P_CH2_H_H,
	C_CH5P_CH4_CHP_1, 
	C_CH5P_CH4_CHP_2, 
	O_CH4_OH_CH3_1, 
	O_CH4_OH_CH3_2, 
	O_CH4P_OH_CH3P_1, 
	O_CH4P_OH_CH3P_2, 
	O_CH5P_H3OP_CH2_1, 
	O_CH5P_H3OP_CH2_2, 
	OP_CH4_OH_CH3P_1, 
	OP_CH4_OH_CH3P_2, 
	OP_CH4_CH4P_O_1, 
	OP_CH4_CH4P_O_2, 
	CH4_CH_CH3_CH2_1, 
	CH4_CH_CH3_CH2_2, 
	CH5P_CH_CH4_CH2P_1, 
	CH5P_CH_CH4_CH2P_2, 
	CH2_CH2_CH3_CH_1, 
	CH2_CH2_CH3_CH_2, 
	CH4_CH2_CH3_CH3_1, 
	CH4_CH2_CH3_CH3_2, 
	OH_CH2_O_CH3_1, 
	OH_CH2_O_CH3_2, 
	CH5P_CH2_CH4_CH3P_1, 
	CH5P_CH2_CH4_CH3P_2, 
	OH_CH3_CH4_O_1, 
	OH_CH3_CH4_O_2, 
	OH_CH3_H2O_CH2_1, 
	OH_CH3_H2O_CH2_2, 
	H2O_CH3_OH_CH4_1, 
	H2O_CH3_OH_CH4_2, 
	CH3_CH3_CH4_CH2_1, 
	CH3_CH3_CH4_CH2_2, 
	OH_CH4_H2O_CH3_1, 
	OH_CH4_H2O_CH3_2, 
	OHP_CH4_CH5P_O_1, 
	OHP_CH4_CH5P_O_2, 
	OHP_CH4_H3OP_CH2_1, 
	OHP_CH4_H3OP_CH2_2, 
	H2OP_CH4_H3OP_CH3_1, 
	H2OP_CH4_H3OP_CH3_2, 
	COP_CH4_HCOP_CH3_1, 
	COP_CH4_HCOP_CH3_2, 
	COP_CH4_CO_CH4P_1, 
	COP_CH4_CO_CH4P_2, 
	CH4_CH4P_CH5P_CH3_1, 
	CH4_CH4P_CH5P_CH3_2, 
	H2O_CH4P_H3OP_CH3_1, 
	H2O_CH4P_H3OP_CH3_2, 
	CO_CH4P_HCOP_CH3_1, 
	CO_CH4P_HCOP_CH3_2, 
	O2_CH4P_O2P_CH4_1, 
	O2_CH4P_O2P_CH4_2, 
	H2O_CH5P_H3OP_CH4_1, 
	H2O_CH5P_H3OP_CH4_2, 
	CO_CH5P_HCOP_CH4_1, 
	CO_CH5P_HCOP_CH4_2, 
	CH5P_OH_H2OP_CH4_1, 
	CH5P_OH_H2OP_CH4_2, 


	PRODUCT_C_CH2,
	PRODUCT_C_COP,
	PRODUCT_C_H2OP,
	PRODUCT_C_H3OP,
	PRODUCT_C_HCOP,
	PRODUCT_C_O,
	PRODUCT_C_O2,
	PRODUCT_C_O2P,
	PRODUCT_C_OH,
	PRODUCT_C_OHP,
	PRODUCT_C_SiOP,
	PRODUCT_CP_OH,
	PRODUCT_CP_CH,
	PRODUCT_CP_SiO,
	PRODUCT_CP_CH2,
	PRODUCT_CP_H2O,
	PRODUCT_CP_O,
	PRODUCT_CP_O2,
	PRODUCT_O_CH,
	PRODUCT_O_CHP,
	PRODUCT_O_CH2,
	PRODUCT_O_CH2P,
	PRODUCT_O_CH3P,
	PRODUCT_O_COP,
	PRODUCT_O_H2O,
	PRODUCT_O_H2OP,
	PRODUCT_O_O,
	PRODUCT_O_OH,
	PRODUCT_O_OHP,
	PRODUCT_O_Si,
	PRODUCT_O_SiP,
	PRODUCT_O_SiH,
	PRODUCT_O_SiH2P,
	PRODUCT_O_SiOP,
	PRODUCT_OP_CH,
	PRODUCT_OP_CH2,
	PRODUCT_OP_CO,
	PRODUCT_OP_H2O,
	PRODUCT_OP_O2,
	PRODUCT_OP_OH,
	PRODUCT_Si_CHP,
	PRODUCT_Si_H2OP,
	PRODUCT_Si_OH,
	PRODUCT_Si_O2P,
	PRODUCT_SiP_H2O,
	PRODUCT_SiP_OH,
	PRODUCT_SiP_O2,
	PRODUCT_CH_COP,
	PRODUCT_CH_H2OP,
	PRODUCT_CH_H3OP,
	PRODUCT_CH_HCOP,
	PRODUCT_CH_O2,
	PRODUCT_CH_O2P,
	PRODUCT_CH_OHP,
	PRODUCT_CH_SiOP,
	PRODUCT_CHP_H2O,
	PRODUCT_CHP_O2,
	PRODUCT_CHP_OH,
	PRODUCT_CH2_COP,
	PRODUCT_CH2_H2OP,
	PRODUCT_CH2_H3OP,
	PRODUCT_CH2_HCOP,
	PRODUCT_CH2_O2,
	PRODUCT_CH2_O2P,
	PRODUCT_CH2_OH,
	PRODUCT_CH2_OHP,
	PRODUCT_CH2P_O2,
	PRODUCT_COP_O2,
	PRODUCT_H2O_COP,
	PRODUCT_H2O_HCOP,
	PRODUCT_H2OP_CO,
	PRODUCT_H2OP_H2O,
	PRODUCT_H2OP_O2,
	PRODUCT_H3OP_SiH,
	PRODUCT_H3OP_SiO,
	PRODUCT_HCOP_SiH,
	PRODUCT_HCOP_SiO,
	PRODUCT_OH_COP,
	PRODUCT_OH_H2OP,
	PRODUCT_OH_HCOP,
	PRODUCT_OH_OH,
	PRODUCT_OHP_CO,
	PRODUCT_OHP_H2O,
	PRODUCT_OHP_O2,
	PRODUCT_OHP_OH,
	PRODUCT_OHP_SiH,
	PRODUCT_OHP_SiO,

	/* new products */
	PRODUCT_C_CH5P,
	PRODUCT_O_CH4,
	PRODUCT_O_CH4P,
	PRODUCT_O_CH5P,
	PRODUCT_OP_CH4,
	PRODUCT_CH4_CH,
	PRODUCT_CH5P_CH,
	PRODUCT_CH2_CH2,
	PRODUCT_CH4_CH2,
	PRODUCT_OH_CH2,
	PRODUCT_CH5P_CH2,
	PRODUCT_OH_CH3,
	PRODUCT_H2O_CH3,
	PRODUCT_CH3_CH3,
	PRODUCT_OH_CH4,
	PRODUCT_OHP_CH4,
	PRODUCT_H2OP_CH4,
	PRODUCT_COP_CH4,
	PRODUCT_CH4_CH4P,
	PRODUCT_H2O_CH4P,
	PRODUCT_CO_CH4P,
	PRODUCT_O2_CH4P,
	PRODUCT_H2O_CH5P,
	PRODUCT_CO_CH5P,
	PRODUCT_CH5P_OH,

	bvec_C_CH2_CH_CH,
	bvec_C_COP_CO_CP,
	bvec_C_H2OP_OH_CHP,
	bvec_C_H3OP_HCOP_H2,
	bvec_C_HCOP_CO_CHP,
	bvec_C_O_CO_nu,
	bvec_C_O2_CO_O,
	bvec_C_O2P_O2_CP,
	bvec_C_O2P_COP_O,
	bvec_C_OH_O_CH,
	bvec_C_OH_CO_H,
	bvec_C_OHP_O_CHP,
	bvec_C_SiOP_SiP_CO,
	bvec_CP_OH_CO_HP,
	bvec_CP_CH_CHP_C,
	bvec_CP_SiO_SiP_CO,
	bvec_CP_CH2_CH2P_C,
	bvec_CP_H2O_HCOP_H,
	bvec_CP_O_COP_nu,
	bvec_CP_O2_COP_O,
	bvec_CP_O2_CO_OP,
	bvec_CP_OH_COP_H,
	bvec_O_CH_OH_C,
	bvec_O_CH_HCOP_e,
	bvec_O_CH_CO_H,
	bvec_O_CHP_COP_H,
	bvec_O_CH2_OH_CH,
	bvec_O_CH2_CO_H_H,
	bvec_O_CH2_CO_H2,
	bvec_O_CH2P_HCOP_H,
	bvec_O_CH3P_HCOP_H2,
	bvec_O_COP_CO_OP,
	bvec_O_H2O_OH_OH,
	bvec_O_H2OP_O2P_H2,
	bvec_O_O_O2_nu,
	bvec_O_OH_O2_H,
	bvec_O_OHP_O2P_H,
	bvec_O_Si_SiO_nu,
	bvec_O_SiP_SiOP_nu,
	bvec_O_SiH_SiO_H,
	bvec_O_SiH2P_SiOHP_H,
	bvec_O_SiOP_O2_SiP,
	bvec_OP_CH_O_CHP,
	bvec_OP_CH_COP_H,
	bvec_OP_CH2_O_CH2P,
	bvec_OP_CO_COP_O,
	bvec_OP_H2O_H2OP_O,
	bvec_OP_O2_O2P_O,
	bvec_OP_OH_O2P_H,
	bvec_OP_OH_OHP_O,
	bvec_Si_CHP_SiP_CH,
	bvec_Si_H2OP_SiP_H2O,
	bvec_Si_OH_SiO_H,
	bvec_Si_O2P_O2_SiP,
	bvec_SiP_H2O_SiOHP_H,
	bvec_SiP_OH_SiOP_H,
	bvec_SiP_O2_SiOP_O,
	bvec_CH_COP_HCOP_C,
	bvec_CH_COP_CO_CHP,
	bvec_CH_H2OP_H2O_CHP,
	bvec_CH_H2OP_OH_CH2P,
	bvec_CH_H3OP_H2O_CH2P,
	bvec_CH_HCOP_CO_CH2P,
	bvec_CH_O2_CO_OH,
	bvec_CH_O2P_O2_CHP,
	bvec_CH_O2P_HCOP_O,
	bvec_CH_OHP_OH_CHP,
	bvec_CH_OHP_O_CH2P,
	bvec_CH_SiOP_HCOP_Si,
	bvec_CHP_H2O_H3OP_C,
	bvec_CHP_OH_COP_H2,
	bvec_CHP_H2O_HCOP_H2,
	bvec_CHP_O2_HCOP_O,
	bvec_CHP_O2_COP_OH,
	bvec_CH2_COP_HCOP_CH,
	bvec_CH2_COP_CO_CH2P,
	bvec_CH2_H2OP_H2O_CH2P,
	bvec_CH2_H2OP_OH_CH3P,
	bvec_CH2_H3OP_H2O_CH3P,
	bvec_CH2_HCOP_CO_CH3P,
	bvec_CH2_O2_CO_H2O,
	bvec_CH2_O2P_O2_CH2P,
	bvec_CH2_OH_H2O_CH,
	bvec_CH2_OHP_OH_CH2P,
	bvec_CH2_OHP_O_CH3P,
	bvec_CH2P_O2_HCOP_OH,
	bvec_COP_O2_O2P_CO,
	bvec_H2O_COP_CO_H2OP,
	bvec_H2O_COP_HCOP_OH,
	bvec_H2O_HCOP_CO_H3OP,
	bvec_H2OP_CO_HCOP_OH,
	bvec_H2OP_H2O_H3OP_OH,
	bvec_H2OP_O2_O2P_H2O,
	bvec_H3OP_SiH_SiH2P_H2O,
	bvec_H3OP_SiO_SiOHP_H2O,
	bvec_HCOP_SiH_SiH2P_CO,
	bvec_HCOP_SiO_SiOHP_CO,
	bvec_OH_COP_HCOP_O,
	bvec_OH_COP_CO_OHP,
	bvec_OH_H2OP_H3OP_O,
	bvec_OH_HCOP_CO_H2OP,
	bvec_OH_OH_H2O_O,
	bvec_OHP_CO_HCOP_O,
	bvec_OHP_H2O_H3OP_O,
	bvec_OHP_H2O_H2OP_OH,
	bvec_OHP_O2_O2P_OH,
	bvec_OHP_OH_H2OP_O,
	bvec_OHP_SiH_SiH2P_O,
	bvec_OHP_SiO_SiOHP_O,

	/* new bvecs */

	bvec_C_CH5P_CH4_CHP,
	bvec_O_CH4_OH_CH3,
	bvec_O_CH4P_OH_CH3P,
	bvec_O_CH5P_H3OP_CH2,
	bvec_OP_CH4_OH_CH3P,
	bvec_OP_CH4_CH4P_O,
	bvec_CH4_CH_CH3_CH2,
	bvec_CH5P_CH_CH4_CH2P,
	bvec_CH2_CH2_CH3_CH,
	bvec_CH4_CH2_CH3_CH3,
	bvec_OH_CH2_O_CH3,
	bvec_CH5P_CH2_CH4_CH3P,
	bvec_OH_CH3_CH4_O,
	bvec_OH_CH3_H2O_CH2,
	bvec_H2O_CH3_OH_CH4,
	bvec_CH3_CH3_CH4_CH2,
	bvec_OH_CH4_H2O_CH3,
	bvec_OHP_CH4_CH5P_O,
	bvec_OHP_CH4_H3OP_CH2,
	bvec_H2OP_CH4_H3OP_CH3,
	bvec_COP_CH4_HCOP_CH3,
	bvec_COP_CH4_CO_CH4P,
	bvec_CH4_CH4P_CH5P_CH3,
	bvec_H2O_CH4P_H3OP_CH3,
	bvec_CO_CH4P_HCOP_CH3,
	bvec_O2_CH4P_O2P_CH4,
	bvec_H2O_CH5P_H3OP_CH4,
	bvec_CO_CH5P_HCOP_CH4,
	bvec_CH5P_OH_H2OP_CH4,

	csav[NUM_COMOLE_CALC][NUM_COMOLE_CALC],
	saha,
	expcop,	
	coplte,
	expco,
	pcolte,
	expchp,
	chplte,
	expc2,
	pc2lte,
	expo2,
	po2lte,
	esc_co,

	/* >>chng 04 jul 16 -- NPA.  This is the new reactions that involve N or 
	 * S bearing molecules */

	C_NH_N_CH_1,          
	C_NH_CN_H_1,         
	C_NH2_HCN_H_1,      
	C_N2_CN_N_1,      
	C_NO_CN_O_1,      
	C_NO_CO_N_1,     
	C_HS_S_CH_1,    
	C_HS_CS_H_1,   
	C_OCN_CO_CN_1, 
	C_NS_S_CN_1,   
	C_NS_CS_N_1,   
	C_SO_S_CO_1,   
	C_SO_CS_O_1,   
	C_S2_CS_S_1,       
	CH_N_NH_C_1,       
	CH_N_CN_H_1,       
	CH_N2_HCN_N_1,     
	CH_NO_HCN_O_1,     
	CH_NO_CN_OH_1,     
	CH_NO_OCN_H_1,     
	CH_HNO_NO_CH2_1,   
	CH_S_HS_C_1,       
	CH_S_CS_H_1,       
	N_NH_N2_H_1,       
	N_CH3_HCN_H_H_1,   
	N_CH3_HCN_H2_1,    
	N_OH_O_NH_1,       
	N_OH_NO_H_1,       
	N_CN_N2_C_1,       
	N_SIH_SIN_H_1,     
	N_NO_N2_O_1,       
	N_HNO_NO_NH_1,     
	N_HNO_N2O_H_1,     
	N_O2_NO_O_1,       
	N_HS_NS_H_1,       
	N_HS_S_NH_1,       
	N_CS_S_CN_1,       
	N_NS_S_N2_1,       
	N_SO_NS_O_1,       
	N_SO_S_NO_1,       
	N_S2_NS_S_1,       
	CH2_CN_HCN_CH_1,   
	CH2_NO_HCN_OH_1,   
	CH2_HNO_NO_CH3_1,  
	NH_NH_N2_H_H_1,    
	NH_NH_N2_H2_1,     
	NH_O_OH_N_1,       
	NH_O_NO_H_1,       
	NH_OH_HNO_H_1,     
	NH_OH_NH2_O_1,     
	NH_OH_H2O_N_1,     
	NH_H2O_OH_NH2_1,   
	NH_CN_HCN_N_1,     
	NH_NO_N2O_H_1,     
	NH_NO_N2_O_H_1,    
	NH_NO_N2_OH_1,     
	NH_S_HS_N_1,       
	NH_S_NS_H_1,       
	NH_NO2_HNO_NO_1,   
	NH_NO2_N2O_OH_1,   
	CH3_NH3_CH4_NH2_1, 
	CH3_CN_HCN_CH2_1,  
	CH3_HNO_NO_CH4_1,  
	O_NH2_OH_NH_1,     
	O_NH2_NO_H2_1,     
	O_NH3_OH_NH2_1,    
	O_CN_NO_C_1,       
	O_CN_CO_N_1,       
	O_HCN_CN_OH_1,     
	O_HCN_CO_NH_1,     
	O_HCN_OCN_H_1,     
	O_N2_NO_N_1,       
	O_NO_O2_N_1,       
	O_HNO_NO_OH_1,     
	O_HNO_O2_NH_1,  
	O_HNO_NO2_H_1, 
	O_HS_S_OH_1,  
	O_HS_SO_H_1, 
	O_OCN_NO_CO_1,
	O_OCN_O2_CN_1,
	O_SIN_NO_SI_1,
	O_SIN_SIO_N_1,
	O_N2O_NO_NO_1,
	O_N2O_O2_N2_1,
	O_CS_S_CO_1,  
	O_CS_SO_C_1,  
	O_NS_S_NO_1,  
	O_NS_SO_N_1,  
	O_SO_S_O2_1,  
	O_OCS_SO_CO_1,
	O_S2_SO_S_1,     
	NH2_OH_NH3_O_1,  
	NH2_OH_H2O_NH_1, 
	NH2_NO_N2_OH_H_1,
	NH2_NO_N2_H2O_1, 
	CH4_CN_HCN_CH3_1,
	OH_NH3_H2O_NH2_1,
	OH_CN_HCN_O_1,   
	OH_CN_OCN_H_1,     
	OH_HCN_CN_H2O_1,   
	OH_HCN_CO_NH2_1,   
	OH_NO_NO2_H_1,     
	OH_S_HS_O_1,       
	OH_S_SO_H_1,       
	OH_N2O_HNO_NO_1,   
	OH_CS_OCS_H_1,     
	NH3_CN_HCN_NH2_1,  
	CN_NO_N2_CO_1,     
	CN_NO_OCN_N_1,     
	CN_HNO_NO_HCN_1,   
	CN_O2_NO_CO_1,     
	CN_S_NS_C_1,       
	CN_S_CS_N_1,       
	CO_HS_OCS_H_1,     
	N2_O2_N2O_O_1,     
	NO_NO_O2_N2_1,     
	NO_NO_N2O_O_1,     
	NO_HNO_N2O_OH_1,   
	NO_S_NS_O_1,       
	NO_S_SO_N_1,       
	O2_S_SO_O_1,       
	S_SO_S2_O_1,       
	C_NHP_N_CHP_1,     
	CP_NH_CNP_H_1,     
	CP_NH2_HCNP_H_1,   
	C_NH2P_NH_CHP_1,   
	CP_NH3_HCNP_H2_1,  
	C_NH3P_NH_CH2P_1,  
	C_HCNP_CN_CHP_1,   
	C_HNOP_NO_CHP_1,   
	CP_HS_CSP_H_1,     
	C_HSP_CSP_H_1,     
	CP_OCN_COP_CN_1,   
	CP_NS_CSP_N_1,     
	CP_H2CS_CS_CH2P_1, 
	CP_SO_SP_CO_1,     
	CP_SO_S_COP_1,     
	CP_SO_CSP_O_1,     
	CP_OCS_CSP_CO_1,   
	CHP_N_CNP_H_1,     
	CH_NP_CNP_H_1,     
	CH_NHP_CH2P_N_1,   
	CHP_NH_CNP_H2_1,   
	CHP_NH2_HCNP_H2_1, 
	CH_NH2P_NH_CH2P_1, 
	CHP_NH3_NH4P_C_1,  
	CH_NH3P_NH4P_C_1,  
	CH_HCNP_CN_CH2P_1, 
	CH_HNOP_NO_CH2P_1, 
	CHP_S_HSP_C_1,     
	CHP_S_CSP_H_1,     
	CH_SP_CSP_H_1,     
	CH_HSP_S_CH2P_1,   
	CHP_OCS_HCSP_CO_1, 
	N_CH2P_HCNP_H_1,   
	NP_NH_N2P_H_1,     
	N_NHP_N2P_H_1,     
	NP_CH4_HCNP_H2_H_1,
	N_OHP_NOP_H_1,     
	NP_NH3_NH2P_NH_1,  
	N_H2OP_HNOP_H_1,   
	NP_CO_NOP_C_1,     
	NP_NO_N2P_O_1,     
	NP_O2_NO_OP_1,     
	NP_O2_NOP_O_1,     
	N_O2P_NOP_O_1,    
	N_HSP_NSP_H_1,    
	N_SIOP_NOP_SI_1,  
	N_SIOP_NO_SIP_1,  
	N_SOP_NSP_O_1,    
	NP_OCS_SP_CO_N_1, 
	NP_OCS_CSP_NO_1,  
	CH2_NHP_CH3P_N_1, 
	CH2_NH2P_CH3P_NH_1,
	CH2P_NH3_NH4P_CH_1, 
	CH2_NH3P_NH2_CH3P_1,
	CH2_HCNP_CN_CH3P_1, 
	CH2_HNOP_NO_CH3P_1, 
	CH2P_S_HCSP_H_1,    
	CH2_SP_HCSP_H_1,    
	NHP_NH_NH2P_N_1,    
	NHP_O_OHP_N_1,      
	NH_OP_NOP_H_1,      
	NHP_NH2_NH3P_N_1,   
	NH_NH2P_NH3P_N_1,   
	NHP_OH_H2OP_N_1,    
	NH_OHP_NH2P_O_1,    
	NHP_NH3_NH4P_N_1,   
	NH_NH3P_NH4P_N_1,   
	NH_CH5P_CH4_NH2P_1, 
	NHP_H2O_NH3P_O_1,   
	NHP_H2O_H3OP_N_1,   
	NHP_H2O_HNOP_H2_1,    
	NH_H2OP_H3OP_N_1,     
	NHP_H2O_OH_NH2P_1,    
	NHP_CN_HCNP_N_1,      
	NH_HCNP_CN_NH2P_1,    
	NHP_CO_HCOP_N_1,      
	NH_COP_HCOP_N_1,      
	NHP_CO_OCNP_H_1,      
	NH_SIP_SINP_H_1,      
	NH_HCOP_CO_NH2P_1,    
	NH_HNOP_NO_NH2P_1,    
	NH_O2P_HNOP_O_1,      
	NHP_O2_NOP_OH_1,      
	NH_O2P_NO2P_H_1,      
	NHP_S_HSP_N_1,        
	NHP_S_NSP_H_1,        
	NH_SP_NSP_H_1,        
	CH3P_NH2_CH4NP_H_1,   
	CH3P_NH3_NH4P_CH2_1,  
	CH3P_S_HCSP_H2_1,     
	O_NH2P_HNOP_H_1,      
	O_NH3P_HNOP_H2_1,     
	OP_CN_NOP_C_1,        
	OP_HCN_COP_NH_1,      
	OP_HCN_NOP_CH_1,      
	OP_HCN_HCOP_N_1,      
	OP_N2_NOP_N_1,        
	O_N2P_NOP_N_1,        
	O_HNOP_NO2P_H_1,      
	O_HSP_SP_OH_1,       
	O_HSP_SOP_H_1,       
	O_SINP_SIOP_N_1,     
	OP_N2O_NOP_NO_1,     
	O_CSP_S_COP_1,       
	O_HCSP_S_HCOP_1,    
	O_HCSP_OCSP_H_1,    
	OP_NO2_O2_NOP_1,    
	O_NSP_S_NOP_1,      
	NH2P_NH2_NH3P_NH_1, 
	NH2_OHP_NH3P_O_1,   
	NH2P_OH_H2OP_NH_1,  
	NH2P_NH3_NH4P_NH_1, 
	NH2_NH3P_NH4P_NH_1,
	NH2_CH5P_NH3P_CH4_1, 
	NH2P_H2O_NH3P_OH_1,  
	NH2P_H2O_H3OP_NH_1,  
	NH2_H2OP_NH3P_OH_1,  
	NH2P_H2O_NH4P_O_1,   
	NH2_H3OP_H2O_NH3P_1, 
	NH2_HCNP_CN_NH3P_1,  
	NH2_COP_HCOP_NH_1,   
	NH2_HCOP_CO_NH3P_1,  
	NH2_HNOP_NO_NH3P_1,  
	NH2P_O2_HNOP_OH_1,   
	NH2P_S_HSP_NH_1,     
	CH4P_NH3_NH4P_CH3_1, 
	CH4_NH3P_NH4P_CH3_1, 
	CH4_N2P_N2_CH2P_H2_1,
	CH4_N2P_N2_CH3P_H_1, 
	CH4_HNOP_NO_CH5P_1,   
	CH4_SP_HCSP_H2_H_1,   
	CH4_CSP_HCSP_CH3_1,   
	OHP_NH3_NH4P_O_1,     
	OH_NH3P_NH4P_O_1,     
	OHP_CN_HCNP_O_1,      
	OH_HCNP_CN_H2OP_1,    
	OHP_NO_HNOP_O_1,      
	OH_HNOP_NO_H2OP_1,    
	OHP_S_HSP_O_1,        
	OHP_S_SOP_H_1,        
	OH_SP_SOP_H_1,        
	NH3P_NH3_NH4P_NH2_1,  
	NH3_CH5P_NH4P_CH4_1,  
	NH3P_H2O_NH4P_OH_1,   
	NH3_H2OP_NH4P_OH_1,   
	NH3_H3OP_NH4P_H2O_1,  
	NH3_COP_HCOP_NH2_1,   
	NH3_HCOP_CO_NH4P_1,   
	NH3_HNOP_NO_NH4P_1,   
	NH3_HSP_S_NH4P_1,     
	NH3_HCSP_CS_NH4P_1,   
	CH5P_S_HSP_CH4_1,     
	H2O_CNP_HCNP_OH_1,    
	H2O_CNP_HCOP_NH_1,    
	H2O_HCNP_CN_H3OP_1,   
	H2O_HNOP_NO_H3OP_1,   
	H2OP_S_HSP_OH_1,      
	H2O_HSP_S_H3OP_1,     
	H3OP_CS_HCSP_H2O_1,   
	CNP_NO_OCNP_N_1,      
	CN_HNOP_NO_HCNP_1,    
	CNP_O2_NOP_CO_1,      
	CNP_O2_OCNP_O_1,      
	HCNP_CO_HCOP_CN_1,    
	HCNP_S_HSP_CN_1,      
	CO_HNOP_NO_HCOP_1,    
	N2P_OCS_SP_N2_CO_1,   
	HCOP_S_HSP_CO_1,      
	HCOP_CS_HCSP_CO_1,    
	HNOP_S_HSP_NO_1,      
	O2_SP_SOP_O_1,        
	O2P_S_SOP_O_1,        
	O2_CSP_OCSP_O_1,      
	S_SIOP_SO_SIP_1,      
	CP_NH3_NH3P_C_1,     
	C_CNP_CN_CP_1,       
	C_N2P_N2_CP_1,      
	CP_NO_NOP_C_1,      
	CP_SIN_SINP_C_1,    
	C_CSP_CS_CP_1,      
	CP_NS_NSP_C_1,      
	CP_SO_SOP_C_1,      
	CP_OCS_OCSP_C_1,    
	CH_NH2P_NH2_CHP_1,  
	CHP_NH3_NH3P_CH_1,  
	CH_CNP_CN_CHP_1,    
	CH_N2P_N2_CHP_1,    
	CHP_NO_NOP_CH_1,    
	NP_NH_NHP_N_1,      
	NP_NH2_NH2P_N_1,    
	NP_NH3_NH3P_N_1,    
	NP_CN_CNP_N_1,      
	NP_HCN_HCNP_N_1,    
	N_N2P_N2_NP_1,      
	NP_NO_NOP_N_1,      
	NP_OCS_OCSP_N_1,    
	CH2_NH2P_NH2_CH2P_1,
	CH2_CNP_CN_CH2P_1,  
	CH2_N2P_N2_CH2P_1,  
	CH2P_NO_NOP_CH2_1,  
	NH_OP_O_NHP_1,      
	NH_OHP_OH_NHP_1,    
	NHP_NH3_NH3P_NH_1,  
	NHP_H2O_H2OP_NH_1,  
	NH_CNP_CN_NHP_1,    
	NH_COP_CO_NHP_1,    
	NH_N2P_N2_NHP_1,    
	NHP_NO_NOP_NH_1,    
	NHP_O2_O2P_NH_1,    
	NHP_S_SP_NH_1,      
	CH3P_NO_NOP_CH3_1,  
	OP_NH2_NH2P_O_1,    
	OP_NH3_NH3P_O_1,    
	O_CNP_CN_OP_1,      
	O_HCNP_HCN_OP_1,    
	O_N2P_N2_OP_1,      
	OP_NO_NOP_O_1,      
	OP_OCS_OCSP_O_1,    
	NH2_OHP_OH_NH2P_1,  
	NH2P_NH3_NH3P_NH2_1,
	NH2_H2OP_H2O_NH2P_1,  
	NH2_CNP_CN_NH2P_1,    
	NH2_COP_CO_NH2P_1,    
	NH2_N2P_N2_NH2P_1,    
	NH2P_NO_NOP_NH2_1,    
	NH2_O2P_O2_NH2P_1,    
	NH2P_S_SP_NH2_1,      
	CH4P_NH3_NH3P_CH4_1,  
	CH4P_OCS_OCSP_CH4_1,  
	OHP_NH3_NH3P_OH_1,    
	OH_CNP_CN_OHP_1,      
	OH_N2P_N2_OHP_1,      
	OHP_NO_NOP_OH_1,      
	NH3_H2OP_H2O_NH3P_1,  
	NH3_HCNP_HCN_NH3P_1,  
	NH3_COP_CO_NH3P_1,    
	NH3_N2P_N2_NH3P_1,    
	NH3P_SI_SIP_NH3_1,    
	NH3P_NO_NOP_NH3_1,    
	NH3_O2P_O2_NH3P_1,    
	NH3_SP_S_NH3P_1,      
	NH3_HSP_HS_NH3P_1,    
	NH3_SOP_SO_NH3P_1,    
	H2O_HCNP_HCN_H2OP_1,  
	H2O_N2P_N2_H2OP_1,    
	H2OP_NO_NOP_H2O_1,    
	CNP_HCN_HCNP_CN_1,    
	CNP_CO_COP_CN_1,      
	CN_N2P_N2_CNP_1,      
	CNP_NO_NOP_CN_1,      
	CNP_O2_O2P_CN_1,      
	CNP_S_SP_CN_1,        
	HCN_COP_CO_HCNP_1,    
	HCN_N2P_N2_HCNP_1,    
	HCNP_NO_NOP_HCN_1,    
	HCNP_O2_O2P_HCN_1,    
	HCNP_S_SP_HCN_1,      
	CO_N2P_N2_COP_1,      
	COP_NO_NOP_CO_1,      
	N2P_NO_NOP_N2_1,      
	N2P_O2_O2P_N2_1,      
	N2P_S_SP_N2_1,        
	SI_NOP_NO_SIP_1,      
	SI_HSP_HS_SIP_1,      
	SI_CSP_CS_SIP_1,      
	NO_HNOP_HNO_NOP_1,    
	NO_O2P_O2_NOP_1,      
	NO_SP_S_NOP_1,        
	NO_HSP_HS_NOP_1,      
	NO_SIOP_SIO_NOP_1,    
	NO_S2P_S2_NOP_1,      
	O2P_NO2_NO2P_O2_1,    
	S_HSP_HS_SP_1,        
	C_N_CN_NU_1,          
	C_S_CS_NU_1,          
	CP_S_CSP_NU_1,        
	NP_N_N2P_NU_1,        
	CO_S_OCS_NU_1,        
	CH_NP_N_CHP_1,        
	CHP_S_SP_CH_1,        
	NP_CH2_CH2P_N_1,      
	NP_CH4_CH4P_N_1,      
	NP_OH_OHP_N_1,        
	NP_H2O_H2OP_N_1,      
	NP_CO_COP_N_1,        
	NP_O2_O2P_N_1,        
	OHP_S_SP_OH_1,        
	H2OP_S_SP_H2O_1,      
	COP_S_SP_CO_1,        
	SI_SP_S_SIP_1,        
	O2P_S_SP_O2_1,        
	C_NH_N_CH_2,          
	C_NH_CN_H_2,         
	C_N2_CN_N_2,      
	C_NO_CN_O_2,      
	C_NO_CO_N_2,     
	C_HS_S_CH_2,    
	C_HS_CS_H_2,   
	C_OCN_CO_CN_2, 
	C_NS_S_CN_2,   
	C_NS_CS_N_2,   
	C_SO_S_CO_2,   
	C_SO_CS_O_2,   
	C_S2_CS_S_2,       
	CH_N_NH_C_2,       
	CH_N_CN_H_2,       
	CH_N2_HCN_N_2,     
	CH_NO_HCN_O_2,     
	CH_NO_CN_OH_2,     
	CH_NO_OCN_H_2,     
	CH_HNO_NO_CH2_2,   
	CH_S_HS_C_2,       
	CH_S_CS_H_2,       
	N_NH_N2_H_2,       
	N_CH3_HCN_H_H_2,   
	N_CH3_HCN_H2_2,    
	N_OH_O_NH_2,       
	N_OH_NO_H_2,       
	N_CN_N2_C_2,       
	N_SIH_SIN_H_2,     
	N_NO_N2_O_2,       
	N_HNO_NO_NH_2,     
	N_HNO_N2O_H_2,     
	N_O2_NO_O_2,       
	N_HS_NS_H_2,       
	N_HS_S_NH_2,       
	N_CS_S_CN_2,       
	N_NS_S_N2_2,       
	N_SO_NS_O_2,       
	N_SO_S_NO_2,       
	N_S2_NS_S_2,       
	CH2_CN_HCN_CH_2,   
	CH2_NO_HCN_OH_2,   
	CH2_HNO_NO_CH3_2,  
	NH_NH_N2_H_H_2,    
	NH_NH_N2_H2_2,     
	NH_O_OH_N_2,       
	NH_O_NO_H_2,       
	NH_OH_HNO_H_2,     
	NH_OH_NH2_O_2,     
	NH_OH_H2O_N_2,     
	NH_H2O_OH_NH2_2,   
	NH_CN_HCN_N_2,     
	NH_NO_N2O_H_2,     
	NH_NO_N2_O_H_2,    
	NH_NO_N2_OH_2,     
	NH_S_HS_N_2,       
	NH_S_NS_H_2,       
	NH_NO2_HNO_NO_2,   
	NH_NO2_N2O_OH_2,   
	CH3_NH3_CH4_NH2_2, 
	CH3_CN_HCN_CH2_2,  
	CH3_HNO_NO_CH4_2,  
	O_NH2_OH_NH_2,     
	O_NH2_NO_H2_2,     
	O_NH3_OH_NH2_2,    
	O_CN_NO_C_2,       
	O_CN_CO_N_2,       
	O_HCN_CN_OH_2,     
	O_HCN_CO_NH_2,     
	O_HCN_OCN_H_2,     
	O_N2_NO_N_2,       
	O_NO_O2_N_2,       
	O_HNO_NO_OH_2,     
	O_HNO_O2_NH_2,  
	O_HNO_NO2_H_2, 
	O_HS_S_OH_2,  
	O_HS_SO_H_2, 
	O_OCN_NO_CO_2,
	O_OCN_O2_CN_2,
	O_SIN_NO_SI_2,
	O_SIN_SIO_N_2,
	O_N2O_NO_NO_2,
	O_N2O_O2_N2_2,
	O_CS_S_CO_2,  
	O_CS_SO_C_2,  
	O_NS_S_NO_2,  
	O_NS_SO_N_2,  
	O_SO_S_O2_2,  
	O_OCS_SO_CO_2,
	O_S2_SO_S_2,     
	NH2_OH_NH3_O_2,  
	NH2_OH_H2O_NH_2, 
	NH2_NO_N2_OH_H_2,
	NH2_NO_N2_H2O_2, 
	CH4_CN_HCN_CH3_2,
	OH_NH3_H2O_NH2_2,
	OH_CN_HCN_O_2,   
	OH_CN_OCN_H_2,     
	OH_HCN_CN_H2O_2,   
	OH_HCN_CO_NH2_2,   
	OH_NO_NO2_H_2,     
	OH_S_HS_O_2,       
	OH_S_SO_H_2,       
	OH_N2O_HNO_NO_2,   
	OH_CS_OCS_H_2,     
	NH3_CN_HCN_NH2_2,  
	CN_NO_N2_CO_2,     
	CN_NO_OCN_N_2,     
	CN_HNO_NO_HCN_2,   
	CN_O2_NO_CO_2,     
	CN_S_NS_C_2,       
	CN_S_CS_N_2,       
	CO_HS_OCS_H_2,     
	N2_O2_N2O_O_2,     
	NO_NO_O2_N2_2,     
	NO_NO_N2O_O_2,     
	NO_HNO_N2O_OH_2,   
	NO_S_NS_O_2,       
	NO_S_SO_N_2,       
	O2_S_SO_O_2,       
	S_SO_S2_O_2,       
	C_NHP_N_CHP_2,     
	CP_NH_CNP_H_2,     
	CP_NH2_HCNP_H_2,   
	C_NH2P_NH_CHP_2,   
	CP_NH3_HCNP_H2_2,  
	C_NH3P_NH_CH2P_2,  
	C_HCNP_CN_CHP_2,   
	C_HNOP_NO_CHP_2,   
	CP_HS_CSP_H_2,     
	C_HSP_CSP_H_2,     
	CP_OCN_COP_CN_2,   
	CP_NS_CSP_N_2,     
	CP_SO_SP_CO_2,     
	CP_SO_S_COP_2,     
	CP_SO_CSP_O_2,     
	CP_OCS_CSP_CO_2,   
	CHP_N_CNP_H_2,     
	CH_NP_CNP_H_2,     
	CH_NHP_CH2P_N_2,   
	CHP_NH_CNP_H2_2,   
	CHP_NH2_HCNP_H2_2, 
	CH_NH2P_NH_CH2P_2, 
	CHP_NH3_NH4P_C_2,  
	CH_NH3P_NH4P_C_2,  
	CH_HCNP_CN_CH2P_2, 
	CH_HNOP_NO_CH2P_2, 
	CHP_S_HSP_C_2,     
	CHP_S_CSP_H_2,     
	CH_SP_CSP_H_2,     
	CH_HSP_S_CH2P_2,   
	CHP_OCS_HCSP_CO_2, 
	N_CH2P_HCNP_H_2,   
	NP_NH_N2P_H_2,     
	N_NHP_N2P_H_2,     
	NP_CH4_HCNP_H2_H_2,
	N_OHP_NOP_H_2,     
	NP_NH3_NH2P_NH_2,  
	N_H2OP_HNOP_H_2,   
	NP_CO_NOP_C_2,     
	NP_NO_N2P_O_2,     
	NP_O2_NO_OP_2,     
	NP_O2_NOP_O_2,     
	N_O2P_NOP_O_2,    
	N_HSP_NSP_H_2,    
	N_SIOP_NOP_SI_2,  
	N_SIOP_NO_SIP_2,  
	N_SOP_NSP_O_2,    
	NP_OCS_SP_CO_N_2, 
	NP_OCS_CSP_NO_2,  
	CH2_NHP_CH3P_N_2, 
	CH2_NH2P_CH3P_NH_2,
	CH2P_NH3_NH4P_CH_2, 
	CH2_NH3P_NH2_CH3P_2,
	CH2_HCNP_CN_CH3P_2, 
	CH2_HNOP_NO_CH3P_2, 
	CH2P_S_HCSP_H_2,    
	CH2_SP_HCSP_H_2,    
	NHP_NH_NH2P_N_2,    
	NHP_O_OHP_N_2,      
	NH_OP_NOP_H_2,      
	NHP_NH2_NH3P_N_2,   
	NH_NH2P_NH3P_N_2,   
	NHP_OH_H2OP_N_2,    
	NH_OHP_NH2P_O_2,    
	NHP_NH3_NH4P_N_2,   
	NH_NH3P_NH4P_N_2,   
	NH_CH5P_CH4_NH2P_2, 
	NHP_H2O_NH3P_O_2,   
	NHP_H2O_H3OP_N_2,   
	NHP_H2O_HNOP_H2_2,    
	NH_H2OP_H3OP_N_2,     
	NHP_H2O_OH_NH2P_2,    
	NHP_CN_HCNP_N_2,      
	NH_HCNP_CN_NH2P_2,    
	NHP_CO_HCOP_N_2,      
	NH_COP_HCOP_N_2,      
	NHP_CO_OCNP_H_2,      
	NH_SIP_SINP_H_2,      
	NH_HCOP_CO_NH2P_2,    
	NH_HNOP_NO_NH2P_2,    
	NH_O2P_HNOP_O_2,      
	NHP_O2_NOP_OH_2,      
	NH_O2P_NO2P_H_2,      
	NHP_S_HSP_N_2,        
	NHP_S_NSP_H_2,        
	NH_SP_NSP_H_2,        
	CH3P_NH2_CH4NP_H_2,   
	CH3P_NH3_NH4P_CH2_2,  
	CH3P_S_HCSP_H2_2,     
	O_NH2P_HNOP_H_2,      
	O_NH3P_HNOP_H2_2,     
	OP_CN_NOP_C_2,        
	OP_HCN_COP_NH_2,      
	OP_HCN_NOP_CH_2,      
	OP_HCN_HCOP_N_2,      
	OP_N2_NOP_N_2,        
	O_N2P_NOP_N_2,        
	O_HNOP_NO2P_H_2,      
	O_HSP_SP_OH_2,       
	O_HSP_SOP_H_2,       
	O_SINP_SIOP_N_2,     
	OP_N2O_NOP_NO_2,     
	O_CSP_S_COP_2,       
	O_HCSP_S_HCOP_2,    
	O_HCSP_OCSP_H_2,    
	OP_NO2_O2_NOP_2,    
	O_NSP_S_NOP_2,      
	NH2P_NH2_NH3P_NH_2, 
	NH2_OHP_NH3P_O_2,   
	NH2P_OH_H2OP_NH_2,  
	NH2P_NH3_NH4P_NH_2, 
	NH2_NH3P_NH4P_NH_2,
	NH2_CH5P_NH3P_CH4_2, 
	NH2P_H2O_NH3P_OH_2,  
	NH2P_H2O_H3OP_NH_2,  
	NH2_H2OP_NH3P_OH_2,  
	NH2P_H2O_NH4P_O_2,   
	NH2_H3OP_H2O_NH3P_2, 
	NH2_HCNP_CN_NH3P_2,  
	NH2_COP_HCOP_NH_2,   
	NH2_HCOP_CO_NH3P_2,  
	NH2_HNOP_NO_NH3P_2,  
	NH2P_O2_HNOP_OH_2,   
	NH2P_S_HSP_NH_2,     
	CH4P_NH3_NH4P_CH3_2, 
	CH4_NH3P_NH4P_CH3_2, 
	CH4_N2P_N2_CH2P_H2_2,
	CH4_N2P_N2_CH3P_H_2, 
	CH4_HNOP_NO_CH5P_2,   
	CH4_SP_HCSP_H2_H_2,   
	CH4_CSP_HCSP_CH3_2,   
	OHP_NH3_NH4P_O_2,     
	OH_NH3P_NH4P_O_2,     
	OHP_CN_HCNP_O_2,      
	OH_HCNP_CN_H2OP_2,    
	OHP_NO_HNOP_O_2,      
	OH_HNOP_NO_H2OP_2,    
	OHP_S_HSP_O_2,        
	OHP_S_SOP_H_2,        
	OH_SP_SOP_H_2,        
	NH3P_NH3_NH4P_NH2_2,  
	NH3_CH5P_NH4P_CH4_2,  
	NH3P_H2O_NH4P_OH_2,   
	NH3_H2OP_NH4P_OH_2,   
	NH3_H3OP_NH4P_H2O_2,  
	NH3_COP_HCOP_NH2_2,   
	NH3_HCOP_CO_NH4P_2,   
	NH3_HNOP_NO_NH4P_2,   
	NH3_HSP_S_NH4P_2,     
	NH3_HCSP_CS_NH4P_2,   
	CH5P_S_HSP_CH4_2,     
	H2O_CNP_HCNP_OH_2,    
	H2O_CNP_HCOP_NH_2,    
	H2O_HCNP_CN_H3OP_2,   
	H2O_HNOP_NO_H3OP_2,   
	H2OP_S_HSP_OH_2,      
	H2O_HSP_S_H3OP_2,     
	H3OP_CS_HCSP_H2O_2,   
	CNP_NO_OCNP_N_2,      
	CN_HNOP_NO_HCNP_2,    
	CNP_O2_NOP_CO_2,      
	CNP_O2_OCNP_O_2,      
	HCNP_CO_HCOP_CN_2,    
	HCNP_S_HSP_CN_2,      
	CO_HNOP_NO_HCOP_2,    
	N2P_OCS_SP_N2_CO_2,   
	HCOP_S_HSP_CO_2,      
	HCOP_CS_HCSP_CO_2,    
	HNOP_S_HSP_NO_2,      
	O2_SP_SOP_O_2,        
	O2P_S_SOP_O_2,        
	O2_CSP_OCSP_O_2,      
	S_SIOP_SO_SIP_2,      
	CP_NH3_NH3P_C_2,     
	C_CNP_CN_CP_2,       
	C_N2P_N2_CP_2,      
	CP_NO_NOP_C_2,      
	CP_SIN_SINP_C_2,    
	C_CSP_CS_CP_2,      
	CP_NS_NSP_C_2,      
	CP_SO_SOP_C_2,      
	CP_OCS_OCSP_C_2,    
	CH_NH2P_NH2_CHP_2,  
	CHP_NH3_NH3P_CH_2,  
	CH_CNP_CN_CHP_2,    
	CH_N2P_N2_CHP_2, 
	CH_NP_N_CHP_2,
	CHP_NO_NOP_CH_2,    
	NP_NH_NHP_N_2,      
	NP_NH2_NH2P_N_2,    
	NP_NH3_NH3P_N_2,    
	NP_CN_CNP_N_2,      
	NP_HCN_HCNP_N_2,    
	N_N2P_N2_NP_2,      
	NP_NO_NOP_N_2,      
	NP_OCS_OCSP_N_2,    
	CH2_NH2P_NH2_CH2P_2,
	CH2_CNP_CN_CH2P_2,  
	CH2_N2P_N2_CH2P_2,  
	CH2P_NO_NOP_CH2_2,  
	NH_OP_O_NHP_2,      
	NH_OHP_OH_NHP_2,    
	NHP_NH3_NH3P_NH_2,  
	NHP_H2O_H2OP_NH_2,  
	NH_CNP_CN_NHP_2,    
	NH_COP_CO_NHP_2,    
	NH_N2P_N2_NHP_2,    
	NHP_NO_NOP_NH_2,    
	NHP_O2_O2P_NH_2,    
	NHP_S_SP_NH_2,      
	CH3P_NO_NOP_CH3_2,  
	OP_NH2_NH2P_O_2,    
	OP_NH3_NH3P_O_2,    
	O_CNP_CN_OP_2,      
	O_HCNP_HCN_OP_2,    
	O_N2P_N2_OP_2,      
	OP_NO_NOP_O_2,      
	OP_OCS_OCSP_O_2,    
	NH2_OHP_OH_NH2P_2,  
	NH2P_NH3_NH3P_NH2_2,
	NH2_H2OP_H2O_NH2P_2,  
	NH2_CNP_CN_NH2P_2,    
	NH2_COP_CO_NH2P_2,    
	NH2_N2P_N2_NH2P_2,    
	NH2P_NO_NOP_NH2_2,    
	NH2_O2P_O2_NH2P_2,    
	NH2P_S_SP_NH2_2,      
	CH4P_NH3_NH3P_CH4_2,  
	CH4P_OCS_OCSP_CH4_2,  
	OHP_NH3_NH3P_OH_2,    
	OH_CNP_CN_OHP_2,      
	OH_N2P_N2_OHP_2,      
	OHP_NO_NOP_OH_2,      
	NH3_H2OP_H2O_NH3P_2,  
	NH3_HCNP_HCN_NH3P_2,  
	NH3_COP_CO_NH3P_2,    
	NH3_N2P_N2_NH3P_2,    
	NH3P_SI_SIP_NH3_2,    
	NH3P_NO_NOP_NH3_2,    
	NH3_O2P_O2_NH3P_2,    
	NH3_SP_S_NH3P_2,      
	NH3_HSP_HS_NH3P_2,    
	NH3_SOP_SO_NH3P_2,    
	H2O_HCNP_HCN_H2OP_2,  
	H2O_N2P_N2_H2OP_2,    
	H2OP_NO_NOP_H2O_2,    
	CNP_HCN_HCNP_CN_2,    
	CNP_CO_COP_CN_2,      
	CN_N2P_N2_CNP_2,      
	CNP_NO_NOP_CN_2,      
	CNP_O2_O2P_CN_2,      
	CNP_S_SP_CN_2,        
	HCN_COP_CO_HCNP_2,    
	HCN_N2P_N2_HCNP_2,    
	HCNP_NO_NOP_HCN_2,    
	HCNP_O2_O2P_HCN_2,    
	HCNP_S_SP_HCN_2,      
	CO_N2P_N2_COP_2,      
	COP_NO_NOP_CO_2,      
	N2P_NO_NOP_N2_2,      
	N2P_O2_O2P_N2_2,      
	N2P_S_SP_N2_2,        
	SI_NOP_NO_SIP_2,      
	SI_HSP_HS_SIP_2,      
	SI_CSP_CS_SIP_2,      
	NO_HNOP_HNO_NOP_2,    
	NO_O2P_O2_NOP_2,      
	NO_SP_S_NOP_2,        
	NO_HSP_HS_NOP_2,      
	NO_SIOP_SIO_NOP_2,    
	NO_S2P_S2_NOP_2,      
	O2P_NO2_NO2P_O2_2,    
	S_HSP_HS_SP_2,        
	C_N_CN_NU_2,          
	C_S_CS_NU_2,          
	CP_S_CSP_NU_2,        
	NP_N_N2P_NU_2,        
	CO_S_OCS_NU_2,        
	CHP_S_SP_CH_2,        
	NP_CH2_CH2P_N_2,      
	NP_CH4_CH4P_N_2,      
	NP_OH_OHP_N_2,        
	NP_H2O_H2OP_N_2,      
	NP_CO_COP_N_2,        
	NP_O2_O2P_N_2,        
	OHP_S_SP_OH_2,        
	H2OP_S_SP_H2O_2,      
	COP_S_SP_CO_2,        
	SI_SP_S_SIP_2,        
	O2P_S_SP_O2_2, 
	H2_N_NH_H          , 
	H2_NH_NH2_H         ,
	H2_NH2_NH3_H        ,
	H2_CN_HCN_H         ,
	HP_HNO_NOP_H2       ,
	HP_HS_SP_H2         ,
	H_HSP_SP_H2         ,
	HP_OCS_HSP_CO       ,
	H2P_N_NHP_H         ,
	H2_NP_NHP_H         ,
	H2_NHP_N_H3P        ,
	H2P_NH_NH2P_H       ,
	H2_NHP_NH2P_H       ,
	H2_NH2P_NH3P_H      ,
	H2_NH3P_NH4P_H      ,
	H2P_CN_HCNP_H      ,
	H2_CNP_HCNP_H       ,
	H2P_NO_HNOP_H       ,
	H2_SP_HSP_H         ,
	H2_CSP_HCSP_H       ,
	H2_NO2P_NOP_H2O     ,
	H3P_NH_NH2P_H2      ,
	H3P_NH2_NH3P_H2     ,
	H3P_NH3_NH4P_H2     ,
	H3P_CN_HCNP_H2      ,
	H3P_NO_HNOP_H2      ,
	H3P_S_HSP_H2        ,
	H3P_CS_HCSP_H2      ,
	H3P_NO2_NOP_OH_H2   ,
	HeP_NH_NP_He_H      ,
	HeP_NH2_NP_He_H2    ,
	HeP_NH2_NHP_He_H    ,
	HeP_NH3_NHP_He_H2   ,
	HeP_NH3_NH2P_He_H   ,
	HeP_CN_N_CP_He      ,
	HeP_CN_NP_C_He      ,
	HeP_HCN_N_CHP_He    ,
	HeP_HCN_NP_CH_He    ,
	HeP_HCN_N_CP_He_H   ,
	HeP_HCN_CNP_He_H    ,
	HeP_N2_NP_N_He      ,
	HeP_NO_OP_N_He      ,
	HeP_NO_O_NP_He      ,
	HeP_HNO_NOP_He_H    ,
	HeP_HNO_NO_He_HP    ,
	HeP_HS_SP_He_H      ,
	HeP_OCN_CN_OP_He    ,
	HeP_OCN_CNP_O_He    ,
	HeP_SIN_SIP_N_He    ,
	HeP_N2O_N2_OP_He    ,
	HeP_N2O_N2P_O_He    ,
	HeP_N2O_NO_NP_He    ,
	HeP_N2O_NOP_N_He,
	HeP_CS_SP_C_He  ,
	HeP_CS_S_CP_He  ,
	HeP_NS_S_NP_He  ,
	HeP_NS_SP_N_He  ,
	HeP_SO_S_OP_He  ,
	HeP_SO_SP_O_He  ,
	HeP_OCS_SP_CO_He,
	HeP_OCS_S_COP_He,
	HeP_OCS_CSP_O_He,
	HeP_OCS_CS_OP_He,
	HeP_S2_SP_S_He  ,
	HP_NH_NHP_H ,
	HP_NH2_NH2P_H   ,
	HP_NH3_NH3P_H   ,
	H_CNP_CN_HP ,
	HP_HCN_HCNP_H   ,
	H_HCNP_HCN_HP   ,
	H_N2P_N2_HP ,
	HP_NO_NOP_H ,
	HP_HS_HSP_H ,
	HP_SIN_SINP_H   ,
	HP_CS_CSP_H ,
	HP_NS_NSP_H ,
	HP_SO_SOP_H ,
	HP_OCS_OCSP_H   ,
	HP_S2_S2P_H ,
	H2P_NH_NHP_H2   ,
	H2P_NH2_NH2P_H2 ,
	H2P_NH3_NH3P_H2 ,
	H2P_CN_CNP_H2   ,
	H2P_HCN_HCNP_H2 ,
	H2P_NO_NOP_H2   ,
	HeP_NH3_NH3P_He ,
	HeP_N2_N2P_He   ,
	NHP_e_N_H ,
	NH2P_e_N_H_H  ,
	NH2P_e_NH_H   ,
	NH3P_e_NH_H_H ,
	NH3P_e_NH2_H  ,
	NH4P_e_NH2_H_H,
	NH4P_e_NH2_H2 ,
	NH4P_e_NH3_H  ,
	CNP_e_N_C ,
	HCNP_e_CN_H   ,
	N2P_e_N_N ,
	NOP_e_O_N ,
	HNOP_e_NO_H   ,
	HSP_e_S_H ,
	OCNP_e_CO_N   ,
	SINP_e_SI_N   ,
	CSP_e_S_C ,
	HCSP_e_CS_H   ,
	NO2P_e_NO_O   ,
	NSP_e_S_N ,
	SOP_e_S_O ,
	OCSP_e_S_CO   ,
	OCSP_e_CS_O   ,
	S2P_e_S_S ,
	Hminus_N_NH_e ,
	Hminus_NH_NH2_e   ,
	Hminus_NH2_NH3_e  ,
	Hminus_CN_HCN_e   ,
	Hminus_NH4P_NH3_H2,
	Hminus_NP_N_H ,
	NH_NU_NHP_e   ,
	NH_NU_N_H ,
	NH2_NU_NH_H   ,
	NH2_NU_NH2P_e ,
	NH3_NU_NH3P_e ,
	NH3_NU_NH_H2  ,
	NH3_NU_NH2_H  ,
	CN_NU_N_C ,
	HCN_NU_CN_H   ,
	N2_NU_N_N ,
	NO_NU_O_N ,
	NO_NU_NOP_e   ,
	HNO_NU_NO_H   ,
	HS_NU_S_H ,
	HSP_NU_SP_H   ,
	OCN_NU_CN_O   ,
	CS_NU_S_C ,
	CSP_NU_SP_C   ,
	CS_NU_CSP_e   ,
	NO2_NU_NO_O   ,
	NS_NU_S_N ,
	SO_NU_S_O ,
	SO_NU_SOP_e   ,
	OCS_NU_S_CO   ,
	OCS_NU_OCSP_e ,
	NH_CRP_NHP_e,
	NH_CRP_N_H   ,     
	NH2_CRP_NH_H  ,    
	NH2_CRP_NH2P_e ,   
	NH3_CRP_NH3P_e  ,  
	NH3_CRP_NH_H2    , 
	NH3_CRP_NH2_H     ,
	CN_CRP_N_C        ,
	HCN_CRP_CN_H      ,
	N2_CRP_N_N        ,
	NO_CRP_O_N        ,
	NO_CRP_NOP_e      ,
	HNO_CRP_NO_H      ,
	HS_CRP_S_H        ,
	OCN_CRP_CN_O      ,
	CS_CRP_S_C        ,
	CS_CRP_CSP_e      ,
	NO2_CRP_NO_O      ,
	NS_CRP_S_N        ,
	SO_CRP_S_O        ,
	SO_CRP_SOP_e      ,
	OCS_CRP_S_CO      ,
	OCS_CRP_OCSP_e    ,
	bvec_C_NH_N_CH ,  
	bvec_C_NH_CN_H , 
	bvec_C_NH2_NH_CH , 
	bvec_C_N2_CN_N ,  
	bvec_C_NO_CN_O ,  
	bvec_C_NO_CO_N , 
	bvec_C_HS_S_CH ,
	bvec_C_HS_CS_H ,   
	bvec_C_OCN_CO_CN , 
	bvec_C_NS_S_CN ,   
	bvec_C_NS_CS_N ,   
	bvec_C_SO_S_CO ,   
	bvec_C_SO_CS_O ,   
	bvec_C_S2_CS_S ,   
	bvec_CH_N_NH_C ,   
	bvec_CH_N_CN_H ,   
	bvec_CH_N2_HCN_N , 
	bvec_CH_NO_HCN_O , 
	bvec_CH_NO_CN_OH , 
	bvec_CH_NO_OCN_H , 
	bvec_CH_HNO_NO_CH2 ,   
	bvec_CH_S_HS_C ,   
	bvec_CH_S_CS_H ,   
	bvec_N_NH_N2_H ,   
	bvec_N_CH3_HCN_H_H ,   
	bvec_N_CH3_HCN_H2 ,
	bvec_N_OH_O_NH ,   
	bvec_N_OH_NO_H ,   
	bvec_N_CN_N2_C ,   
	bvec_N_SIH_SIN_H , 
	bvec_N_NO_N2_O ,   
	bvec_N_HNO_NO_NH , 
	bvec_N_HNO_N2O_H , 
	bvec_N_O2_NO_O ,   
	bvec_N_HS_NS_H ,   
	bvec_N_HS_S_NH ,   
	bvec_N_CS_S_CN ,   
	bvec_N_NS_S_N2 ,   
	bvec_N_SO_NS_O ,   
	bvec_N_SO_S_NO ,   
	bvec_N_S2_NS_S ,   
	bvec_CH2_CN_HCN_CH ,   
	bvec_CH2_NO_HCN_OH ,   
	bvec_CH2_HNO_NO_CH3 ,  
	bvec_NH_NH_N2_H_H ,
	bvec_NH_NH_N2_H2 , 
	bvec_NH_O_OH_N ,   
	bvec_NH_O_NO_H ,   
	bvec_NH_OH_HNO_H , 
	bvec_NH_OH_NH2_O , 
	bvec_NH_OH_H2O_N , 
	bvec_NH_H2O_OH_NH2 ,   
	bvec_NH_CN_HCN_N , 
	bvec_NH_NO_N2O_H , 
	bvec_NH_NO_N2_O_H ,
	bvec_NH_NO_N2_OH , 
	bvec_NH_S_HS_N ,       
	bvec_NH_S_NS_H ,       
	bvec_NH_NO2_HNO_NO ,   
	bvec_NH_NO2_N2O_OH ,   
	bvec_CH3_NH3_CH4_NH2 , 
	bvec_CH3_CN_HCN_CH2 ,  
	bvec_CH3_HNO_NO_CH4 ,  
	bvec_O_NH2_OH_NH ,     
	bvec_O_NH2_NO_H2 ,     
	bvec_O_NH3_OH_NH2 ,    
	bvec_O_CN_NO_C ,       
	bvec_O_CN_CO_N ,       
	bvec_O_HCN_CN_OH ,     
	bvec_O_HCN_CO_NH ,     
	bvec_O_HCN_OCN_H ,     
	bvec_O_N2_NO_N ,       
	bvec_O_NO_O2_N ,       
	bvec_O_HNO_NO_OH ,     
	bvec_O_HNO_O2_NH ,  
	bvec_O_HNO_NO2_H , 
	bvec_O_HS_S_OH ,  
	bvec_O_HS_SO_H , 
	bvec_O_OCN_NO_CO ,
	bvec_O_OCN_O2_CN ,
	bvec_O_SIN_NO_SI ,
	bvec_O_SIN_SIO_N ,
	bvec_O_N2O_NO_NO ,
	bvec_O_N2O_O2_N2 ,
	bvec_O_CS_S_CO ,  
	bvec_O_CS_SO_C ,  
	bvec_O_NS_S_NO ,  
	bvec_O_NS_SO_N ,  
	bvec_O_SO_S_O2 ,  
	bvec_O_OCS_SO_CO ,
	bvec_O_S2_SO_S ,     
	bvec_NH2_OH_NH3_O ,  
	bvec_NH2_OH_H2O_NH , 
	bvec_NH2_NO_N2_OH_H ,
	bvec_NH2_NO_N2_H2O , 
	bvec_CH4_CN_HCN_CH3 ,
	bvec_OH_NH3_H2O_NH2 ,
	bvec_OH_CN_HCN_O ,   
	bvec_OH_CN_OCN_H ,     
	bvec_OH_HCN_CN_H2O ,   
	bvec_OH_HCN_CO_NH2 ,   
	bvec_OH_NO_NO2_H ,     
	bvec_OH_S_HS_O ,       
	bvec_OH_S_SO_H ,       
	bvec_OH_N2O_HNO_NO ,   
	bvec_OH_CS_OCS_H ,     
	bvec_NH3_CN_HCN_NH2 ,  
	bvec_CN_NO_N2_CO ,     
	bvec_CN_NO_OCN_N ,     
	bvec_CN_HNO_NO_HCN ,   
	bvec_CN_O2_NO_CO ,     
	bvec_CN_S_NS_C ,       
	bvec_CN_S_CS_N ,       
	bvec_CO_HS_OCS_H ,     
	bvec_N2_O2_N2O_O ,     
	bvec_NO_NO_O2_N2 ,     
	bvec_NO_NO_N2O_O ,     
	bvec_NO_HNO_N2O_OH ,   
	bvec_NO_S_NS_O ,       
	bvec_NO_S_SO_N ,       
	bvec_O2_S_SO_O ,       
	bvec_S_SO_S2_O ,       
	bvec_C_NHP_N_CHP ,     
	bvec_CP_NH_CNP_H ,     
	bvec_CP_NH2_HCNP_H ,   
	bvec_C_NH2P_NH_CHP ,   
	bvec_CP_NH3_HCNP_H2 ,  
	bvec_C_NH3P_NH_CH2P ,  
	bvec_C_HCNP_CN_CHP ,   
	bvec_C_HNOP_NO_CHP ,   
	bvec_CP_HS_CSP_H ,     
	bvec_C_HSP_CSP_H ,     
	bvec_CP_OCN_COP_CN ,   
	bvec_CP_NS_CSP_N ,     
	bvec_CP_SO_SP_CO ,     
	bvec_CP_SO_S_COP ,     
	bvec_CP_SO_CSP_O ,     
	bvec_CP_OCS_CSP_CO ,   
	bvec_CHP_N_CNP_H ,     
	bvec_CH_NP_CNP_H ,     
	bvec_CH_NHP_CH2P_N ,   
	bvec_CHP_NH_CNP_H2 ,   
	bvec_CHP_NH2_HCNP_H2 , 
	bvec_CH_NH2P_NH_CH2P , 
	bvec_CHP_NH3_NH4P_C ,  
	bvec_CH_NH3P_NH4P_C ,  
	bvec_CH_HCNP_CN_CH2P , 
	bvec_CH_HNOP_NO_CH2P , 
	bvec_CHP_S_HSP_C ,     
	bvec_CHP_S_CSP_H ,     
	bvec_CH_SP_CSP_H ,     
	bvec_CH_HSP_S_CH2P ,   
	bvec_CHP_OCS_HCSP_CO , 
	bvec_N_CH2P_HCNP_H ,   
	bvec_NP_NH_N2P_H ,     
	bvec_N_NHP_N2P_H ,     
	bvec_NP_CH4_HCNP_H2_H ,
	bvec_N_OHP_NOP_H ,     
	bvec_NP_NH3_NH2P_NH ,  
	bvec_N_H2OP_HNOP_H ,   
	bvec_NP_CO_NOP_C ,     
	bvec_NP_NO_N2P_O ,     
	bvec_NP_O2_NO_OP ,     
	bvec_NP_O2_NOP_O ,     
	bvec_N_O2P_NOP_O ,    
	bvec_N_HSP_NSP_H ,    
	bvec_N_SIOP_NOP_SI ,  
	bvec_N_SIOP_NO_SIP ,  
	bvec_N_SOP_NSP_O ,    
	bvec_NP_OCS_SP_CO_N , 
	bvec_NP_OCS_CSP_NO ,  
	bvec_CH2_NHP_CH3P_N , 
	bvec_CH2_NH2P_CH3P_NH ,
	bvec_CH2P_NH3_NH4P_CH , 
	bvec_CH2_NH3P_NH2_CH3P ,
	bvec_CH2_HCNP_CN_CH3P , 
	bvec_CH2_HNOP_NO_CH3P , 
	bvec_CH2P_S_HCSP_H ,    
	bvec_CH2_SP_HCSP_H ,    
	bvec_NHP_NH_NH2P_N ,    
	bvec_NHP_O_OHP_N ,      
	bvec_NH_OP_NOP_H ,      
	bvec_NHP_NH2_NH3P_N ,   
	bvec_NH_NH2P_NH3P_N ,   
	bvec_NHP_OH_H2OP_N ,    
	bvec_NH_OHP_NH2P_O ,    
	bvec_NHP_NH3_NH4P_N ,   
	bvec_NH_NH3P_NH4P_N ,   
	bvec_NH_CH5P_CH4_NH2P , 
	bvec_NHP_H2O_NH3P_O ,   
	bvec_NHP_H2O_H3OP_N ,   
	bvec_NHP_H2O_HNOP_H2 ,    
	bvec_NH_H2OP_H3OP_N ,     
	bvec_NHP_H2O_OH_NH2P ,    
	bvec_NHP_CN_HCNP_N ,      
	bvec_NH_HCNP_CN_NH2P ,    
	bvec_NHP_CO_HCOP_N ,      
	bvec_NH_COP_HCOP_N ,      
	bvec_NHP_CO_OCNP_H ,      
	bvec_NH_SIP_SINP_H ,      
	bvec_NH_HCOP_CO_NH2P ,    
	bvec_NH_HNOP_NO_NH2P ,    
	bvec_NH_O2P_HNOP_O ,      
	bvec_NHP_O2_NOP_OH ,      
	bvec_NH_O2P_NO2P_H ,      
	bvec_NHP_S_HSP_N ,        
	bvec_NHP_S_NSP_H ,        
	bvec_NH_SP_NSP_H ,        
	bvec_CH3P_NH2_CH4NP_H ,   
	bvec_CH3P_NH3_NH4P_CH2 ,  
	bvec_CH3P_S_HCSP_H2 ,     
	bvec_O_NH2P_HNOP_H ,      
	bvec_O_NH3P_HNOP_H2 ,     
	bvec_OP_CN_NOP_C ,        
	bvec_OP_HCN_COP_NH ,      
	bvec_OP_HCN_NOP_CH ,      
	bvec_OP_HCN_HCOP_N ,      
	bvec_OP_N2_NOP_N ,        
	bvec_O_N2P_NOP_N ,        
	bvec_O_HNOP_NO2P_H ,      
	bvec_O_HSP_SP_OH ,       
	bvec_O_HSP_SOP_H ,       
	bvec_O_SINP_SIOP_N ,     
	bvec_OP_N2O_NOP_NO ,     
	bvec_O_CSP_S_COP ,       
	bvec_O_HCSP_S_HCOP ,    
	bvec_O_HCSP_OCSP_H ,    
	bvec_OP_NO2_O2_NOP ,    
	bvec_O_NSP_S_NOP ,      
	bvec_NH2P_NH2_NH3P_NH , 
	bvec_NH2_OHP_NH3P_O ,   
	bvec_NH2P_OH_H2OP_NH ,  
	bvec_NH2P_NH3_NH4P_NH , 
	bvec_NH2_NH3P_NH4P_NH ,
	bvec_NH2_CH5P_NH3P_CH4 , 
	bvec_NH2P_H2O_NH3P_OH ,  
	bvec_NH2P_H2O_H3OP_NH ,  
	bvec_NH2_H2OP_NH3P_OH ,  
	bvec_NH2P_H2O_NH4P_O ,   
	bvec_NH2_H3OP_H2O_NH3P , 
	bvec_NH2_HCNP_CN_NH3P ,  
	bvec_NH2_COP_HCOP_NH ,   
	bvec_NH2_HCOP_CO_NH3P ,  
	bvec_NH2_HNOP_NO_NH3P ,  
	bvec_NH2P_O2_HNOP_OH ,   
	bvec_NH2P_S_HSP_NH ,     
	bvec_CH4P_NH3_NH4P_CH3 , 
	bvec_CH4_NH3P_NH4P_CH3 , 
	bvec_CH4_N2P_N2_CH2P_H2 ,
	bvec_CH4_N2P_N2_CH3P_H , 
	bvec_CH4_HNOP_NO_CH5P ,   
	bvec_CH4_SP_HCSP_H2_H ,   
	bvec_CH4_CSP_HCSP_CH3 ,   
	bvec_OHP_NH3_NH4P_O ,     
	bvec_OH_NH3P_NH4P_O ,     
	bvec_OHP_CN_HCNP_O ,      
	bvec_OH_HCNP_CN_H2OP ,    
	bvec_OHP_NO_HNOP_O ,      
	bvec_OH_HNOP_NO_H2OP ,    
	bvec_OHP_S_HSP_O ,        
	bvec_OHP_S_SOP_H ,        
	bvec_OH_SP_SOP_H ,        
	bvec_NH3P_NH3_NH4P_NH2 ,  
	bvec_NH3_CH5P_NH4P_CH4 ,  
	bvec_NH3P_H2O_NH4P_OH ,   
	bvec_NH3_H2OP_NH4P_OH ,   
	bvec_NH3_H3OP_NH4P_H2O ,  
	bvec_NH3_COP_HCOP_NH2 ,   
	bvec_NH3_HCOP_CO_NH4P ,   
	bvec_NH3_HNOP_NO_NH4P ,   
	bvec_NH3_HSP_S_NH4P ,     
	bvec_NH3_HCSP_CS_NH4P ,   
	bvec_CH5P_S_HSP_CH4 ,     
	bvec_H2O_CNP_HCNP_OH ,    
	bvec_H2O_CNP_HCOP_NH ,    
	bvec_H2O_HCNP_CN_H3OP ,   
	bvec_H2O_HNOP_NO_H3OP ,   
	bvec_H2OP_S_HSP_OH ,      
	bvec_H2O_HSP_S_H3OP ,     
	bvec_H3OP_CS_HCSP_H2O ,   
	bvec_CNP_NO_OCNP_N ,      
	bvec_CN_HNOP_NO_HCNP ,    
	bvec_CNP_O2_NOP_CO ,      
	bvec_CNP_O2_OCNP_O ,      
	bvec_HCNP_CO_HCOP_CN ,    
	bvec_HCNP_S_HSP_CN ,      
	bvec_CO_HNOP_NO_HCOP ,    
	bvec_N2P_OCS_SP_N2_CO ,   
	bvec_HCOP_S_HSP_CO ,      
	bvec_HCOP_CS_HCSP_CO ,    
	bvec_HNOP_S_HSP_NO ,      
	bvec_O2_SP_SOP_O ,        
	bvec_O2P_S_SOP_O ,        
	bvec_O2_CSP_OCSP_O ,      
	bvec_S_SIOP_SO_SIP ,      
	bvec_CP_NH3_NH3P_C ,     
	bvec_C_CNP_CN_CP ,       
	bvec_C_N2P_N2_CP ,      
	bvec_CP_NO_NOP_C ,      
	bvec_CP_SIN_SINP_C ,    
	bvec_C_CSP_CS_CP ,      
	bvec_CP_NS_NSP_C ,      
	bvec_CP_SO_SOP_C ,      
	bvec_CP_OCS_OCSP_C ,    
	bvec_CH_NH2P_NH2_CHP ,  
	bvec_CHP_NH3_NH3P_CH ,  
	bvec_CH_CNP_CN_CHP ,    
	bvec_CH_N2P_N2_CHP ,    
	bvec_CHP_NO_NOP_CH ,    
	bvec_NP_NH_NHP_N ,      
	bvec_NP_NH2_NH2P_N ,    
	bvec_NP_NH3_NH3P_N ,    
	bvec_NP_CN_CNP_N ,      
	bvec_NP_HCN_HCNP_N ,    
	bvec_N_N2P_N2_NP ,      
	bvec_NP_NO_NOP_N ,      
	bvec_NP_OCS_OCSP_N ,    
	bvec_CH2_NH2P_NH2_CH2P ,
	bvec_CH2_CNP_CN_CH2P ,  
	bvec_CH2_N2P_N2_CH2P ,  
	bvec_CH2P_NO_NOP_CH2 ,  
	bvec_NH_OP_O_NHP ,      
	bvec_NH_OHP_OH_NHP ,    
	bvec_NHP_NH3_NH3P_NH ,  
	bvec_NHP_H2O_H2OP_NH ,  
	bvec_NH_CNP_CN_NHP ,    
	bvec_NH_COP_CO_NHP ,    
	bvec_NH_N2P_N2_NHP ,    
	bvec_NHP_NO_NOP_NH ,    
	bvec_NHP_O2_O2P_NH ,    
	bvec_NHP_S_SP_NH ,      
	bvec_CH3P_NO_NOP_CH3 ,  
	bvec_OP_NH2_NH2P_O ,    
	bvec_OP_NH3_NH3P_O ,    
	bvec_O_CNP_CN_OP ,      
	bvec_O_HCNP_HCN_OP ,    
	bvec_O_N2P_N2_OP ,      
	bvec_OP_NO_NOP_O ,      
	bvec_OP_OCS_OCSP_O ,    
	bvec_NH2_OHP_OH_NH2P ,  
	bvec_NH2P_NH3_NH3P_NH2 ,
	bvec_NH2_H2OP_H2O_NH2P ,  
	bvec_NH2_CNP_CN_NH2P ,    
	bvec_NH2_COP_CO_NH2P ,    
	bvec_NH2_N2P_N2_NH2P ,    
	bvec_NH2P_NO_NOP_NH2 ,    
	bvec_NH2_O2P_O2_NH2P ,    
	bvec_NH2P_S_SP_NH2 ,      
	bvec_CH4P_NH3_NH3P_CH4 ,  
	bvec_CH4P_OCS_OCSP_CH4 ,  
	bvec_OHP_NH3_NH3P_OH ,    
	bvec_OH_CNP_CN_OHP ,      
	bvec_OH_N2P_N2_OHP ,      
	bvec_OHP_NO_NOP_OH ,      
	bvec_NH3_H2OP_H2O_NH3P ,  
	bvec_NH3_HCNP_HCN_NH3P ,  
	bvec_NH3_COP_CO_NH3P ,    
	bvec_NH3_N2P_N2_NH3P ,    
	bvec_NH3P_SI_SIP_NH3 ,    
	bvec_NH3P_NO_NOP_NH3 ,    
	bvec_NH3_O2P_O2_NH3P ,    
	bvec_NH3_SP_S_NH3P ,      
	bvec_NH3_HSP_HS_NH3P ,    
	bvec_NH3_SOP_SO_NH3P ,    
	bvec_H2O_HCNP_HCN_H2OP ,  
	bvec_H2O_N2P_N2_H2OP ,    
	bvec_H2OP_NO_NOP_H2O ,    
	bvec_CNP_HCN_HCNP_CN ,    
	bvec_CNP_CO_COP_CN ,      
	bvec_CN_N2P_N2_CNP ,      
	bvec_CNP_NO_NOP_CN ,      
	bvec_CNP_O2_O2P_CN ,      
	bvec_CNP_S_SP_CN ,        
	bvec_HCN_COP_CO_HCNP ,    
	bvec_HCN_N2P_N2_HCNP ,    
	bvec_HCNP_NO_NOP_HCN ,    
	bvec_HCNP_O2_O2P_HCN ,    
	bvec_HCNP_S_SP_HCN ,      
	bvec_CO_N2P_N2_COP ,      
	bvec_COP_NO_NOP_CO ,      
	bvec_N2P_NO_NOP_N2 ,      
	bvec_N2P_O2_O2P_N2 ,      
	bvec_N2P_S_SP_N2 ,        
	bvec_SI_NOP_NO_SIP ,      
	bvec_SI_HSP_HS_SIP ,      
	bvec_SI_CSP_CS_SIP ,      
	bvec_NO_HNOP_HNO_NOP ,    
	bvec_NO_O2P_O2_NOP ,      
	bvec_NO_SP_S_NOP ,        
	bvec_NO_HSP_HS_NOP ,      
	bvec_NO_SIOP_SIO_NOP ,    
	bvec_NO_S2P_S2_NOP ,      
	bvec_O2P_NO2_NO2P_O2 ,    
	bvec_S_HSP_HS_SP ,        
	bvec_C_N_CN_NU ,          
	bvec_C_S_CS_NU ,          
	bvec_CP_S_CSP_NU ,        
	bvec_NP_N_N2P_NU ,        
	bvec_CO_S_OCS_NU ,        
	bvec_CH_NP_N_CHP ,        
	bvec_CHP_S_SP_CH ,        
	bvec_NP_CH2_CH2P_N ,      
	bvec_NP_CH4_CH4P_N ,      
	bvec_NP_OH_OHP_N ,        
	bvec_NP_H2O_H2OP_N ,      
	bvec_NP_CO_COP_N ,        
	bvec_NP_O2_O2P_N ,        
	bvec_OHP_S_SP_OH ,        
	bvec_H2OP_S_SP_H2O ,      
	bvec_COP_S_SP_CO ,        
	bvec_SI_SP_S_SIP ,        
	bvec_O2P_S_SP_O2 ,  
	PRODUCT_C_NH       ,      
	PRODUCT_C_NH2       ,    
	PRODUCT_C_N2       ,    
	PRODUCT_C_NO       ,   
	PRODUCT_C_HS       ,  
	PRODUCT_C_OCN       ,
	PRODUCT_C_NS       ,
	PRODUCT_C_SO       ,
	PRODUCT_C_S2       ,
	PRODUCT_C_NH3P       ,   
	PRODUCT_C_HCNP       ,   
	PRODUCT_C_HNOP       ,   
	PRODUCT_CH_N       ,     
	PRODUCT_CH_N2       ,    
	PRODUCT_CH_NO       ,    
	PRODUCT_CH_HNO       ,   
	PRODUCT_CH_S       ,     
	PRODUCT_N_NH       ,     
	PRODUCT_N_CH3       ,    
	PRODUCT_N_OH       ,     
	PRODUCT_N_CN       ,     
	PRODUCT_N_SIH       ,    
	PRODUCT_N_NO       ,     
	PRODUCT_N_HNO       ,    
	PRODUCT_N_O2       ,    
	PRODUCT_N_HS       ,     
	PRODUCT_N_CS       ,        
	PRODUCT_N_NS       ,       
	PRODUCT_N_SO       ,      
	PRODUCT_N_S2       ,     
	PRODUCT_CH2_CN       ,  
	PRODUCT_CH2_NO       , 
	PRODUCT_CH2_HNO       ,     
	PRODUCT_CH2_S       ,      
	PRODUCT_NH_NH       ,     
	PRODUCT_NH_O       ,     
	PRODUCT_NH_OH       ,   
	PRODUCT_NH_H2O       , 
	PRODUCT_NH_CN       , 
	PRODUCT_NH_NO       ,        
	PRODUCT_NH_S       ,        
	PRODUCT_NH_NO2       ,     
	PRODUCT_CH3_NH3       ,   
	PRODUCT_CH3_CN       ,   
	PRODUCT_CH3_HNO       , 
	PRODUCT_O_NH2       ,      
	PRODUCT_O_NH3       ,     
	PRODUCT_O_CN       ,     
	PRODUCT_O_HCN       ,   
	PRODUCT_O_N2       ,   
	PRODUCT_O_NO       ,  
	PRODUCT_O_HNO       ,
	PRODUCT_O_HS       ,        
	PRODUCT_O_OCN       ,      
	PRODUCT_O_SIN       ,     
	PRODUCT_O_N2O       ,    
	PRODUCT_O_CS       ,    
	PRODUCT_O_NO2       ,  
	PRODUCT_O_NS       ,  
	PRODUCT_O_SO       , 
	PRODUCT_O_OCS       ,        
	PRODUCT_O_S2       ,        
	PRODUCT_NH2_OH       ,     
	PRODUCT_NH2_NO       ,    
	PRODUCT_CH4_CN       ,   
	PRODUCT_OH_NH3       ,  
	PRODUCT_OH_CN       ,  
	PRODUCT_OH_HCN       ,       
	PRODUCT_OH_NO       ,       
	PRODUCT_OH_HNO       ,     
	PRODUCT_OH_S       ,      
	PRODUCT_OH_N2O       ,   
	PRODUCT_OH_CS       ,   
	PRODUCT_NH3_CN       , 
	PRODUCT_CN_NO       , 
	PRODUCT_CN_HNO       ,       
	PRODUCT_CN_O2       ,       
	PRODUCT_CN_S       ,       
	PRODUCT_CO_HS       ,     
	PRODUCT_N2_O2       ,    
	PRODUCT_NO_NO       ,   
	PRODUCT_NO_HNO       , 
	PRODUCT_NO_S       ,  
	PRODUCT_O2_S       , 
	PRODUCT_S_SO       ,        
	PRODUCT_C_NHP       ,      
	PRODUCT_CP_NH       ,     
	PRODUCT_CP_NH2       ,   
	PRODUCT_C_NH2P       ,  
	PRODUCT_CP_NH3       , 
	PRODUCT_CP_HS       , 
	PRODUCT_C_HSP       ,
	PRODUCT_CP_OCN       ,       
	PRODUCT_CP_NS       ,       
	PRODUCT_CP_SO       ,      
	PRODUCT_CP_OCS       ,    
	PRODUCT_CHP_N       ,    
	PRODUCT_CH_NP       ,   
	PRODUCT_CH_NHP       , 
	PRODUCT_CHP_NH       ,
	PRODUCT_CHP_NH2       ,        
	PRODUCT_CH_NH2P       ,       
	PRODUCT_CHP_NH3       ,      
	PRODUCT_CH_NH3P       ,     
	PRODUCT_CH_HCNP       ,    
	PRODUCT_CH_HNOP       ,   
	PRODUCT_CHP_S       ,    
	PRODUCT_CH_SP       ,   
	PRODUCT_CH_HSP       , 
	PRODUCT_CHP_OCS       ,       
	PRODUCT_N_CH2P       ,       
	PRODUCT_NP_NH       ,       
	PRODUCT_N_NHP       ,      
	PRODUCT_NP_CH4       ,    
	PRODUCT_N_OHP       ,    
	PRODUCT_NP_NH3       ,  
	PRODUCT_N_H2OP       , 
	PRODUCT_NP_CO       , 
	PRODUCT_NP_NO       ,        
	PRODUCT_NP_O2       ,       
	PRODUCT_N_O2P       ,      
	PRODUCT_N_HSP       ,     
	PRODUCT_N_SIOP       ,   
	PRODUCT_N_SOP       ,   
	PRODUCT_NP_OCS       , 
	PRODUCT_CH2_NHP       ,        
	PRODUCT_CH2_NH2P       ,      
	PRODUCT_CH2P_NH3       ,     
	PRODUCT_CH2_NH3P       ,    
	PRODUCT_CH2_HCNP       ,   
	PRODUCT_CH2_HNOP       ,  
	PRODUCT_CH2P_S       ,   
	PRODUCT_CH2_SP       ,  
	PRODUCT_NHP_NH       , 
	PRODUCT_NHP_O       , 
	PRODUCT_NH_OP       ,
	PRODUCT_NHP_NH2       ,        
	PRODUCT_NH_NH2P       ,       
	PRODUCT_NHP_OH       ,       
	PRODUCT_NH_OHP       ,      
	PRODUCT_NHP_NH3       ,    
	PRODUCT_NH_NH3P       ,   
	PRODUCT_NH_CH5P       ,  
	PRODUCT_NHP_H2O       , 
	PRODUCT_NH_H2OP       ,
	PRODUCT_NHP_CN       ,        
	PRODUCT_NH_HCNP       ,      
	PRODUCT_NH_COP       ,      
	PRODUCT_NHP_CO       ,     
	PRODUCT_NH_SIP       ,    
	PRODUCT_NH_HCOP       ,  
	PRODUCT_NH_HNOP       , 
	PRODUCT_NHP_O2       , 
	PRODUCT_NH_O2P       ,
	PRODUCT_NHP_S       ,
	PRODUCT_NH_SP       ,        
	PRODUCT_CH3P_NH2       ,    
	PRODUCT_CH3P_NH3       ,   
	PRODUCT_CH3P_S       ,    
	PRODUCT_O_NH2P       ,   
	PRODUCT_O_NH3P       ,  
	PRODUCT_OP_CN       ,  
	PRODUCT_OP_HCN       ,       
	PRODUCT_OP_N2       ,       
	PRODUCT_O_N2P       ,      
	PRODUCT_O_HNOP       ,    
	PRODUCT_O_HSP       ,    
	PRODUCT_O_SINP       ,  
	PRODUCT_OP_N2O       , 
	PRODUCT_O_CSP       , 
	PRODUCT_O_HCSP       ,        
	PRODUCT_OP_NO2       ,       
	PRODUCT_O_NSP       ,       
	PRODUCT_NH2P_NH2       ,   
	PRODUCT_NH2_OHP       ,   
	PRODUCT_NH2P_OH       ,  
	PRODUCT_NH2P_NH3       ,        
	PRODUCT_NH2_NH3P       ,       
	PRODUCT_NH2_CH5P       ,      
	PRODUCT_NH2P_H2O       ,     
	PRODUCT_NH2_H2OP       ,    
	PRODUCT_NH2_H3OP       ,  
	PRODUCT_NH2_HCNP       , 
	PRODUCT_NH2_COP       , 
	PRODUCT_NH2_HCOP       ,       
	PRODUCT_NH2_HNOP       ,      
	PRODUCT_NH2P_O2       ,      
	PRODUCT_NH2P_S       ,      
	PRODUCT_CH4P_NH3       ,   
	PRODUCT_CH4_NH3P       ,  
	PRODUCT_CH4_N2P       ,  
	PRODUCT_CH4_HNOP       ,
	PRODUCT_CH4_SP       , 
	PRODUCT_CH4_CSP       ,        
	PRODUCT_OHP_NH3       ,       
	PRODUCT_OH_NH3P       ,      
	PRODUCT_OHP_CN       ,      
	PRODUCT_OH_HCNP       ,    
	PRODUCT_OHP_NO       ,    
	PRODUCT_OH_HNOP       ,  
	PRODUCT_OHP_S       ,   
	PRODUCT_OH_SP       ,  
	PRODUCT_NH3P_NH3       ,        
	PRODUCT_NH3_CH5P       ,       
	PRODUCT_NH3P_H2O       ,      
	PRODUCT_NH3_H2OP       ,     
	PRODUCT_NH3_H3OP       ,    
	PRODUCT_NH3_COP       ,    
	PRODUCT_NH3_HCOP       ,  
	PRODUCT_NH3_HNOP       , 
	PRODUCT_NH3_HSP       , 
	PRODUCT_NH3_HCSP       ,        
	PRODUCT_CH5P_S       ,        
	PRODUCT_H2O_CNP       ,       
	PRODUCT_H2O_HCNP       ,        
	PRODUCT_H2O_HNOP       ,       
	PRODUCT_H2OP_S       ,        
	PRODUCT_H2O_HSP       ,      
	PRODUCT_H3OP_CS       ,     
	PRODUCT_CNP_NO       ,     
	PRODUCT_CN_HNOP       ,   
	PRODUCT_CNP_O2       ,   
	PRODUCT_HCNP_CO       , 
	PRODUCT_HCNP_S       , 
	PRODUCT_CO_HNOP       ,        
	PRODUCT_N2P_OCS       ,       
	PRODUCT_HCOP_S       ,       
	PRODUCT_HCOP_CS       ,     
	PRODUCT_HNOP_S       ,     
	PRODUCT_O2_SP       ,     
	PRODUCT_O2P_S       ,    
	PRODUCT_O2_CSP       ,  
	PRODUCT_S_SIOP       , 
	PRODUCT_C_CNP       ,        
	PRODUCT_C_N2P       ,       
	PRODUCT_CP_NO       ,      
	PRODUCT_CP_SIN       ,    
	PRODUCT_C_CSP       ,    
	PRODUCT_CH_CNP       ,       
	PRODUCT_CH_N2P       ,      
	PRODUCT_CHP_NO       ,     
	PRODUCT_NP_NH2       ,   
	PRODUCT_NP_CN       ,  
	PRODUCT_NP_HCN       ,
	PRODUCT_N_N2P       ,        
	PRODUCT_CH2_CNP       ,  
	PRODUCT_CH2_N2P       , 
	PRODUCT_CH2P_NO       ,
	PRODUCT_NH_CNP       ,   
	PRODUCT_NH_N2P       , 
	PRODUCT_NHP_NO       ,
	PRODUCT_CH3P_NO       ,     
	PRODUCT_OP_NH2       ,     
	PRODUCT_OP_NH3       ,    
	PRODUCT_O_CNP       ,    
	PRODUCT_O_HCNP       ,  
	PRODUCT_OP_NO       , 
	PRODUCT_OP_OCS       ,        
	PRODUCT_NH2_CNP       ,   
	PRODUCT_NH2_N2P       , 
	PRODUCT_NH2P_NO       ,        
	PRODUCT_NH2_O2P       ,       
	PRODUCT_CH4P_OCS       ,   
	PRODUCT_OH_CNP       ,   
	PRODUCT_OH_N2P       ,  
	PRODUCT_NH3_HCNP       ,       
	PRODUCT_NH3_N2P       ,      
	PRODUCT_NH3P_SI       ,     
	PRODUCT_NH3P_NO       ,    
	PRODUCT_NH3_O2P       ,   
	PRODUCT_NH3_SP       ,   
	PRODUCT_NH3_SOP       ,
	PRODUCT_H2O_N2P       ,       
	PRODUCT_H2OP_NO       ,      
	PRODUCT_CNP_HCN       ,     
	PRODUCT_CNP_CO       ,     
	PRODUCT_CN_N2P       ,    
	PRODUCT_CNP_S       ,  
	PRODUCT_HCN_COP       ,        
	PRODUCT_HCN_N2P       ,       
	PRODUCT_HCNP_NO       ,      
	PRODUCT_HCNP_O2       ,     
	PRODUCT_CO_N2P       ,    
	PRODUCT_COP_NO       ,   
	PRODUCT_N2P_NO       ,  
	PRODUCT_N2P_O2       , 
	PRODUCT_N2P_S       , 
	PRODUCT_SI_NOP       ,        
	PRODUCT_SI_HSP       ,       
	PRODUCT_SI_CSP       ,      
	PRODUCT_NO_HNOP       ,    
	PRODUCT_NO_O2P       ,    
	PRODUCT_NO_SP       ,    
	PRODUCT_NO_HSP       ,  
	PRODUCT_NO_SIOP       ,
	PRODUCT_NO_S2P       ,        
	PRODUCT_O2P_NO2       ,      
	PRODUCT_S_HSP       ,       
	PRODUCT_C_N       ,        
	PRODUCT_C_S       ,       
	PRODUCT_CP_S       ,     
	PRODUCT_NP_N       ,    
	PRODUCT_CO_S       ,   
	PRODUCT_NP_CH2       ,      
	PRODUCT_NP_OH       ,     
	PRODUCT_NP_H2O       ,   
	PRODUCT_COP_S       ,      
	PRODUCT_SI_SP       ;     
	
	double
		amat[NUM_COMOLE_CALC][NUM_COMOLE_CALC], 
		bvec[NUM_COMOLE_CALC], 
		c[NUM_COMOLE_CALC + 1][NUM_COMOLE_CALC + 1],
		matrix_value, 
		co_denominator;
	int ns;


	float abundan;
	float cartot_mol, oxytot_mol , cartot_ion, oxytot_ion, siltot_mol, siltot_ion,
		nitrotot_mol, nitrotot_ion, sulptot_mol, sulptot_ion;

#	ifdef DEBUG_FUN
	fputs( "<+>CO_step()\n", debug_fp );
#	endif

	*lgNegPop = FALSE; 
	*lgZerPop = FALSE;

	saha = sqrt(SAHA2);

	/* dissociation energies;
	 * CO 11.09, CO+ 8.3eV, CH+ 3.8eV
	 * LTE population of CO+ */

	/* following, pc2lte, chplte, po2lte, coplte, pcolte, are not ever
	 * used for anything - first document what they are relative to, and
	 * then use them to define departure coefficients */
	/* turn this error off for now */
	/*lint -e550 */
	expcop = sexp(9.632e4/phycon.te);
	if ( expcop > 0. )
	{
		coplte = saha/(phycon.te32*expcop)*(1./(6.*9.));
	}
	else
	{
		coplte = 0.;
	}

	expco = sexp(1.287e5/phycon.te);
	if ( expco > 0. )
	{
		pcolte = saha/(phycon.te32*expco)*(1./(9.*9.));
	}
	else
	{
		pcolte = 0.;
	}

	expchp = sexp(4.4098e4/phycon.te);
	if ( expchp > 0. )
	{
		chplte = saha/(phycon.te32*expchp)*(1./(1.*6.));
	}
	else
	{
		chplte = 0.;
	}

	expc2 = sexp(4.4098e4/phycon.te);
	if ( expc2 > 0. )
	{
		pc2lte = saha/(phycon.te32*expc2)*(1./(9.*9.));
	}
	else
	{
		pc2lte = 0.;
	}

	expo2 = sexp(4.4098e4/phycon.te);
	if ( expo2 > 0. )
	{
		po2lte = saha/(phycon.te32*expo2)*(3./(9.*9.));
	}
	else
	{
		po2lte = 0.;
	}

	/* zero out array used for formation rates */
	for ( i=0; i < NUM_COMOLE_CALC; i++ )
	{
		bvec[i] = 0.;
		for ( j=0; j < NUM_COMOLE_CALC; j++ )
		{
			c[j][i] = 0.;
		}
	}

	/* carbon conservation, add up all ion forms of carbon that
	 * are not explictly included in the matrix.  The chemistry
	 * netowrk works with CO, C^0, and C^+ */
	cartot_mol = dense.xMolecules[ipCARBON] + co.hevmol[ipATC] + co.hevmol[ipCP];
	oxytot_mol = dense.xMolecules[ipOXYGEN] + co.hevmol[ipATO] + co.hevmol[ipOP];
	siltot_mol = dense.xMolecules[ipSILICON] + co.hevmol[ipATSI] + co.hevmol[ipSIP];
	nitrotot_mol = dense.xMolecules[ipNITROGEN] + co.hevmol[ipATN] + co.hevmol[ipNP];
	sulptot_mol = dense.xMolecules[ipSULPHUR] + co.hevmol[ipATS] + co.hevmol[ipSP];

	ASSERT( cartot_mol >= 0. && oxytot_mol >= 0.);

	/* now see how much is in the gas phase and ions */

	cartot_ion = dense.gas_phase[ipCARBON];
	oxytot_ion = dense.gas_phase[ipOXYGEN];
	siltot_ion = dense.gas_phase[ipSILICON];
	nitrotot_ion = dense.gas_phase[ipNITROGEN];
	sulptot_ion = dense.gas_phase[ipSULPHUR];

	for ( i=2; i < ipCARBON+2; i++ )
	{
		cartot_ion -= dense.xIonDense[ipCARBON][i];
	}
	for ( i=2; i < ipOXYGEN+2; i++ )
	{
		oxytot_ion -= dense.xIonDense[ipOXYGEN][i];
	}

	for ( i=2; i < ipSILICON+2; i++ )
	{
		siltot_ion -= dense.xIonDense[ipSILICON][i];
	}
	
	for ( i=2; i < ipNITROGEN+2; i++ )
	{
		nitrotot_ion -= dense.xIonDense[ipNITROGEN][i];
	}

	for ( i=2; i < ipSULPHUR+2; i++ )
	{
		sulptot_ion -= dense.xIonDense[ipSULPHUR][i];
	}

	/* at this point the cartot_mol, sum of molecules and atom/first ion,
	 * should be equal to the gas_phase minus double and higher ions */
	/*fprintf(ioQQQ," dbuggggas\t %.2f\t%f\t%f\n",fnzone,
		cartot_mol/cartot_ion,
		oxytot_mol/oxytot_ion);*/

	bvec[ipATC]  = cartot_ion;
	bvec[ipATO]  = oxytot_ion;
	bvec[ipATSI] = siltot_ion;
	bvec[ipATN] = nitrotot_ion;
	bvec[ipATS]  = sulptot_ion;

	/* <<chng 03 Nov 11--Nick Abel,  Set up the non-zero matrix elements that go into the conservation equations
	   for atomic C, O, and Si, this is now set up by looping over the atomic species in
	   co.h and setting the number of atoms of C, O, and Si equal to the variable co.nCarb, 
	   co.nOxyg, and co.nSili respectively.  For every element (excluding Hydrogen) not in
	   the network an if statement will be needed */

	for ( i=NUM_COMOLE_CALC - NUM_ELEMENTS; i < NUM_COMOLE_CALC; i++ )
	{
			for ( j=0; j < NUM_COMOLE_CALC; j++ )

			{
					if ( i == (NUM_COMOLE_CALC - 5) )	
						
					{	
						matrix_value = co.nCarb[j];
						c[j][i] = matrix_value;
					}

					else if ( i == (NUM_COMOLE_CALC - 4 ))	
						
					{
						matrix_value = co.nOxyg[j];
						c[j][i] = matrix_value;
					}
					
					else if ( i == (NUM_COMOLE_CALC - 3) )
						
					{	
						matrix_value = co.nSili[j];
						c[j][i] = matrix_value;
					}

					else if ( i == (NUM_COMOLE_CALC - 2) )
						
					{	
						matrix_value = co.nNitr[j];
						c[j][i] = matrix_value;
					}
				
					else if ( i == (NUM_COMOLE_CALC - 1) )
						
					{	
						matrix_value = co.nSulp[j];
						c[j][i] = matrix_value;
					}


			}

	}

	/******************************************************************************
	*																			  *
	*																			  *
	*						THE REACTION NETWORK								  *
	*																			  *
	*******************************************************************************

	This part of the code sets of the matrix elements used to predict molecular abundances 
	for all "heavy element" molecules.  This means molecules that contain either a carbon, 
	oxygen, or a silicon atom.  H2 formation and destruction is not treated here, it is 
	done separately in h2.c and hmole.c.

	The network of reactions include every reaction in the appendix of the TH85 paper
	(Tables 5-14, see references below) although many of the rates come from the later
	paper by Hollenbach and McKee (1989--Tables 3,4, and 5 and henceforth referred to 
	as HM89).  Other reactions not included in the TH85 paper but presented in other
	papers are also part of our reaction network.  These include cosmic ray 
	photodissociation reactions and many neutral-neutral reactions given in the HM89 paper.
	  
	Each term is put in with its reference so that a table of reactions can be put together. 
	In order to put a reaction in, one should follow the following format. */
	
	
	/* >>refer <tab> molecule <tab> reactant1_+_reactant2_=>_product1_product2 <tab> reference 

	  
	Here the underscore denotes spacing and the <tab> means places where the tab key should
	be struck.  In the future more reactions will be inserted, so it is a good idea to 
	continue putting reactions into Cloudy in this format so future tables can be made easily  
	by running the perl script extract_atomic_data.pl.  In the future, if one wants to insert
	a new molecule into the network, three files must be modified
	
	1.  The reactions must be put into this program (co.c)
	2.  The new molecule must be defined and the molecule variables updated in co.h
	3.  pressuretotal.c must be adjusted to account for the new species
	
	Additionally, if the new molecule has as a constituent an element that is not 
	a part of the chemical network, the elements ionization must account for the amount
	of that element in molecules.  This is done in the series of files labeled ion(element).c
	Examples are ioncarbo.c and ionsilic.c.  The adjusting of the new elements file will
	work by exact analogy with the previously mentioned examples.*/

	/* Define all the products of two densities that comole tries to update here, these are used in coupled
	 * reactions.  The purpose of doing this is to assure that the code always uses the same sequence in multiplying
	 * two densities, if this is not done then the code can have problems with precision when 100% CO is reached */

	/*****************************************************************************************
	*																					     *
	*  Certain reactions require special attention because one of						     *
	*  the densities that we multiply by in the square matrix A is a density we are also     *
	*  trying to solve for.  This non-linearity has to be dealt with in order to converge on *
	*  an accurate solution.  We will use a scheme outlined by E. Muller on pg. 421-423 of   *
	*  "Computational Methods for Astrophysical Fluid Flows".  For a reaction rate of the    *
	*  form:																				 *
	*																						 *
	*                    Rate = (+/-)k*X(new)Y(new)                                          *
	*																						 *
	*  where X(new) and Y(new) are the densities that we are solving for we can approximate  *
	*  this product by assuming that the difference between the old and new densities are    *
	*  small.  Defining this difference as:													 *
	*																						 *
	*					deltax = X(new) - X(old)											 *													
	*					deltay = Y(new) - Y(old)											 *
	*																						 *
	*  and then keeping terms to first order in delta gives the rate as:					 *
	*																						 *
	*                  Rate = (+/-)k*[X(new)Y(old) + X(old)Y(new) - X(old)Y(old)]		     *
	*																						 *
	*  Setting the rate = 0 for a time steady solution then gives:							 *
	*																						 *
	*				(+/-)k*X(old)Y(old) = (+/-)k*[X(new)Y(old) + X(old)Y(new)]				 *
	*																						 *
	*  For the matrix equation:																 *
	*																						 *
	*								Ax = B													 *	
	*																						 *
	*  The new densities get put into the solution column matrix x, the product of old		 * 
	*  density times k gets put into the square matrix A, and the product of k times the	 *
	*  old densities gets put intot the column vector B (here labeled as bvec[i])			 *
	*																						 *
	*****************************************************************************************/  
	
	PRODUCT_C_CH2 = co.hevmol[ipATC]*co.hevmol[ipCH2];
	PRODUCT_C_COP = co.hevmol[ipATC]*co.hevmol[ipCOP];
	PRODUCT_C_H2OP= co.hevmol[ipATC]*co.hevmol[ipH2OP];
	PRODUCT_C_H3OP= co.hevmol[ipATC]*co.hevmol[ipH3OP];
	PRODUCT_C_HCOP= co.hevmol[ipATC]*co.hevmol[ipHCOP];
	PRODUCT_C_O= co.hevmol[ipATC]*co.hevmol[ipATO];
	PRODUCT_C_O2= co.hevmol[ipATC]*co.hevmol[ipO2];
	PRODUCT_C_O2P= co.hevmol[ipATC]*co.hevmol[ipO2P];
	PRODUCT_C_OH= co.hevmol[ipATC]*co.hevmol[ipOH];
	PRODUCT_C_OHP= co.hevmol[ipATC]*co.hevmol[ipOHP];
	PRODUCT_C_SiOP= co.hevmol[ipATC]*co.hevmol[ipSIOP];
	PRODUCT_CP_OH= co.hevmol[ipCP]*co.hevmol[ipOH];
	PRODUCT_CP_CH = co.hevmol[ipCP]*co.hevmol[ipCH];
	PRODUCT_CP_SiO = co.hevmol[ipCP]*co.hevmol[ipSIO];
	PRODUCT_CP_CH2 = co.hevmol[ipCP]*co.hevmol[ipCH2];
	PRODUCT_CP_H2O = co.hevmol[ipCP]*co.hevmol[ipH2O];
	PRODUCT_CP_O = co.hevmol[ipCP]*co.hevmol[ipATO];
	PRODUCT_CP_O2 = co.hevmol[ipCP]*co.hevmol[ipO2];
	PRODUCT_CP_OH = co.hevmol[ipCP]*co.hevmol[ipOH];
	PRODUCT_O_CH = co.hevmol[ipATO]*co.hevmol[ipCH];
	PRODUCT_O_CHP = co.hevmol[ipATO]*co.hevmol[ipCHP];
	PRODUCT_O_CH2 = co.hevmol[ipATO]*co.hevmol[ipCH2];
	PRODUCT_O_CH2P = co.hevmol[ipATO]*co.hevmol[ipCH2P]; 
	PRODUCT_O_CH3P = co.hevmol[ipATO]*co.hevmol[ipCH3P];
	PRODUCT_O_COP = co.hevmol[ipATO]*co.hevmol[ipCOP];
	PRODUCT_O_H2O = co.hevmol[ipATO]*co.hevmol[ipH2O];
	PRODUCT_O_H2OP = co.hevmol[ipATO]*co.hevmol[ipH2OP];
	PRODUCT_O_O = co.hevmol[ipATO]*co.hevmol[ipATO];
	PRODUCT_O_OH = co.hevmol[ipATO]*co.hevmol[ipOH];
	PRODUCT_O_OHP = co.hevmol[ipATO]*co.hevmol[ipOHP];
	PRODUCT_O_Si = co.hevmol[ipATO]*co.hevmol[ipATSI];
	PRODUCT_O_SiP = co.hevmol[ipATO]*co.hevmol[ipSIP];
	PRODUCT_O_SiH = co.hevmol[ipATO]*co.hevmol[ipSIH];
	PRODUCT_O_SiH2P = co.hevmol[ipATO]*co.hevmol[ipSIH2P];
	PRODUCT_O_SiOP = co.hevmol[ipATO]*co.hevmol[ipSIOP];
	PRODUCT_OP_CH = co.hevmol[ipOP]*co.hevmol[ipCH];
	PRODUCT_OP_CH2 = co.hevmol[ipOP]*co.hevmol[ipCH2];
	PRODUCT_OP_CO = co.hevmol[ipOP]*co.hevmol[ipCO];
	PRODUCT_OP_H2O = co.hevmol[ipOP]*co.hevmol[ipH2O];
	PRODUCT_OP_O2 = co.hevmol[ipOP]*co.hevmol[ipO2];
	PRODUCT_OP_OH = co.hevmol[ipOP]*co.hevmol[ipOH];
	PRODUCT_Si_CHP = co.hevmol[ipATSI]*co.hevmol[ipCHP];
	PRODUCT_Si_H2OP = co.hevmol[ipATSI]*co.hevmol[ipH2OP];
	PRODUCT_Si_OH = co.hevmol[ipATSI]*co.hevmol[ipOH];
	PRODUCT_Si_O2P = co.hevmol[ipATSI]*co.hevmol[ipO2P];
	PRODUCT_SiP_H2O = co.hevmol[ipSIP]*co.hevmol[ipH2O];
	PRODUCT_SiP_OH = co.hevmol[ipSIP]*co.hevmol[ipOH];
	PRODUCT_SiP_O2 = co.hevmol[ipSIP]*co.hevmol[ipO2];
	PRODUCT_CH_COP = co.hevmol[ipCH]*co.hevmol[ipCOP];
	PRODUCT_CH_H2OP = co.hevmol[ipCH]*co.hevmol[ipH2OP];
	PRODUCT_CH_H3OP = co.hevmol[ipCH]*co.hevmol[ipH3OP];
	PRODUCT_CH_HCOP = co.hevmol[ipCH]*co.hevmol[ipHCOP];
	PRODUCT_CH_O2 = co.hevmol[ipCH]*co.hevmol[ipO2];
	PRODUCT_CH_O2P = co.hevmol[ipCH]*co.hevmol[ipO2P];
	PRODUCT_CH_OHP = co.hevmol[ipCH]*co.hevmol[ipOHP];
	PRODUCT_CH_SiOP = co.hevmol[ipCH]*co.hevmol[ipSIOP];
	PRODUCT_CHP_H2O = co.hevmol[ipCHP]*co.hevmol[ipH2O];
	PRODUCT_CHP_OH = co.hevmol[ipCHP]*co.hevmol[ipOH];
	PRODUCT_CHP_O2 = co.hevmol[ipCHP]*co.hevmol[ipO2];
	PRODUCT_CH2_COP = co.hevmol[ipCH2]*co.hevmol[ipCOP];
	PRODUCT_CH2_H2OP = co.hevmol[ipCH2]*co.hevmol[ipH2OP];
	PRODUCT_CH2_H3OP = co.hevmol[ipCH2]*co.hevmol[ipH3OP];
	PRODUCT_CH2_HCOP = co.hevmol[ipCH2]*co.hevmol[ipHCOP];
	PRODUCT_CH2_O2 = co.hevmol[ipCH2]*co.hevmol[ipO2];
	PRODUCT_CH2_O2P = co.hevmol[ipCH2]*co.hevmol[ipO2P];
	PRODUCT_CH2_OH = co.hevmol[ipCH2]*co.hevmol[ipOH];
	PRODUCT_CH2_OHP = co.hevmol[ipCH2]*co.hevmol[ipOHP];
	PRODUCT_CH2P_O2 = co.hevmol[ipCH2P]*co.hevmol[ipO2];
	PRODUCT_COP_O2 = co.hevmol[ipCOP]*co.hevmol[ipO2];
	PRODUCT_H2O_COP = co.hevmol[ipH2O]*co.hevmol[ipCOP];
	PRODUCT_H2O_HCOP = co.hevmol[ipH2O]*co.hevmol[ipHCOP];
	PRODUCT_H2OP_CO = co.hevmol[ipH2OP]*co.hevmol[ipCO];
	PRODUCT_H2OP_H2O = co.hevmol[ipH2OP]*co.hevmol[ipH2O];
	PRODUCT_H2OP_O2 = co.hevmol[ipH2OP]*co.hevmol[ipO2];
	PRODUCT_H3OP_SiH = co.hevmol[ipH3OP]*co.hevmol[ipSIH];
	PRODUCT_H3OP_SiO = co.hevmol[ipH3OP]*co.hevmol[ipSIO];
	PRODUCT_HCOP_SiH = co.hevmol[ipHCOP]*co.hevmol[ipSIH];
	PRODUCT_HCOP_SiO = co.hevmol[ipHCOP]*co.hevmol[ipSIO];
	PRODUCT_OH_COP = co.hevmol[ipOH]*co.hevmol[ipCOP];
	PRODUCT_OH_H2OP = co.hevmol[ipOH]*co.hevmol[ipH2OP];
	PRODUCT_OH_HCOP = co.hevmol[ipOH]*co.hevmol[ipHCOP];
	PRODUCT_OH_OH = co.hevmol[ipOH]*co.hevmol[ipOH];
	PRODUCT_OHP_CO = co.hevmol[ipOHP]*co.hevmol[ipCO];
	PRODUCT_OHP_H2O = co.hevmol[ipOHP]*co.hevmol[ipH2O];
	PRODUCT_OHP_O2 = co.hevmol[ipOHP]*co.hevmol[ipO2];
	PRODUCT_OHP_OH = co.hevmol[ipOHP]*co.hevmol[ipOH];
	PRODUCT_OHP_SiH = co.hevmol[ipOHP]*co.hevmol[ipSIH];
	PRODUCT_OHP_SiO = co.hevmol[ipOHP]*co.hevmol[ipSIO];

	/* new products */

	PRODUCT_C_CH5P = co.hevmol[ipATC]*co.hevmol[ipCH5P];
	PRODUCT_O_CH4 = co.hevmol[ipATO]*co.hevmol[ipCH4];
	PRODUCT_O_CH4P = co.hevmol[ipATO]*co.hevmol[ipCH4P];
	PRODUCT_O_CH5P = co.hevmol[ipATO]*co.hevmol[ipCH5P];
	PRODUCT_OP_CH4 = co.hevmol[ipOP]*co.hevmol[ipCH4];
	PRODUCT_CH4_CH = co.hevmol[ipCH4]*co.hevmol[ipCH];
	PRODUCT_CH5P_CH = co.hevmol[ipCH5P]*co.hevmol[ipCH];
	PRODUCT_CH2_CH2 = co.hevmol[ipCH2]*co.hevmol[ipCH2];
	PRODUCT_CH4_CH2 = co.hevmol[ipCH4]*co.hevmol[ipCH2];
	PRODUCT_OH_CH2 = co.hevmol[ipOH]*co.hevmol[ipCH2];
	PRODUCT_CH5P_CH2 = co.hevmol[ipCH5P]*co.hevmol[ipCH2];
	PRODUCT_OH_CH3 = co.hevmol[ipOH]*co.hevmol[ipCH3];
	PRODUCT_OH_CH3 = co.hevmol[ipOH]*co.hevmol[ipCH3];
	PRODUCT_H2O_CH3 = co.hevmol[ipH2O]*co.hevmol[ipCH3];
	PRODUCT_CH3_CH3 = co.hevmol[ipCH3]*co.hevmol[ipCH3];
	PRODUCT_OH_CH4 = co.hevmol[ipOH]*co.hevmol[ipCH4];
	PRODUCT_OHP_CH4 = co.hevmol[ipOHP]*co.hevmol[ipCH4];
	PRODUCT_H2OP_CH4 = co.hevmol[ipH2OP]*co.hevmol[ipCH4];
	PRODUCT_COP_CH4 = co.hevmol[ipCOP]*co.hevmol[ipCH4];
	PRODUCT_CH4_CH4P = co.hevmol[ipCH4]*co.hevmol[ipCH4P];
	PRODUCT_H2O_CH4P = co.hevmol[ipH2O]*co.hevmol[ipCH4P];
	PRODUCT_CO_CH4P = co.hevmol[ipCO]*co.hevmol[ipCH4P];
	PRODUCT_O2_CH4P = co.hevmol[ipO2]*co.hevmol[ipCH4P];
	PRODUCT_H2O_CH5P = co.hevmol[ipH2O]*co.hevmol[ipCH5P];
	PRODUCT_CO_CH5P = co.hevmol[ipCO]*co.hevmol[ipCH5P];
	PRODUCT_CH5P_OH = co.hevmol[ipCH5P]*co.hevmol[ipOH];



	 /* ***************************************************************************************************
	  *Here we are defining the reaction rates for all the reactions in the network, the exceptions		  *
	  * will be a few factors such as the CO self shielding term, this will come in later.  Each reaction *
	  * rate is labeled to make the actual reaction self-explanetary.  For example, in the first reaction *
	  * rate:																							  *	
	  *																									  *	
	  *    C_CH2_CH_CH_1																				  *
	  *																									  *
	  *the rate is for the reaction:																	  *
      *																								      *
	  *    C + CH2 -> CH + CH.																			  *
	  *																									  *
	  * All terms that are "coupled" (see below) will have a one or a two at the end.  Any future		  *
	  * reaction (for as long as this system is desired) should be put in this same way.				  *
	  *****************************************************************************************************/


	

	/* Coupled Reactions !!! */

	C_CH2_CH_CH_1		    = hmrate(0.00000000000269,0,23550)*co.hevmol[ipATC];
	C_COP_CO_CP_1		    = hmrate(0.00000000011,0,0)*co.hevmol[ipATC];
	C_H2OP_OH_CHP_1		    = hmrate(0.0000000011,0,0)*co.hevmol[ipATC];
	C_H3OP_HCOP_H2_1	    = hmrate(0.00000000001,0,0)*co.hevmol[ipATC];
	C_HCOP_CO_CHP_1		    = hmrate(0.0000000011,0,0)*co.hevmol[ipATC];
	C_O_CO_nu_1			    = hmrate(2.1E-19,0,0)*co.hevmol[ipATC];
	C_O2_CO_O_1			    = hmrate(0.000000000033,0,0)*co.hevmol[ipATC];
	C_O2P_O2_CP_1		    = hmrate(0.000000000052,0,0)*co.hevmol[ipATC];
	C_O2P_COP_O_1		    = hmrate(0.000000000052,0,0)*co.hevmol[ipATC];
	C_OH_O_CH_1			    = hmrate(0.0000000000225,0.5,14800)*co.hevmol[ipATC];
	C_OH_CO_H_1			    = hmrate(0.00000000011,0.5,0)*co.hevmol[ipATC];
	C_OHP_O_CHP_1		    = hmrate(0.0000000012,0,0)*co.hevmol[ipATC];
	C_SiOP_SiP_CO_1		    = hmrate(0.000000001,0,0)*co.hevmol[ipATC];
	CP_OH_CO_HP_1		    = hmrate(0.00000000077,0,0)*co.hevmol[ipCP];
	CP_CH_CHP_C_1		    = hmrate(0.00000000038,0,0)*co.hevmol[ipCP];
	CP_SiO_SiP_CO_1		    = hmrate(0.00000000054,0,0)*co.hevmol[ipCP];
	CP_CH2_CH2P_C_1		    = hmrate(0.00000000052,0,0)*co.hevmol[ipCP];
	CP_H2O_HCOP_H_1		    = hmrate(0.0000000009,0,0)*co.hevmol[ipCP];
	CP_O_COP_nu_1		    = hmrate(2.5E-18,0,0)*co.hevmol[ipCP];
	CP_O2_COP_O_1		    = hmrate(0.00000000038,0,0)*co.hevmol[ipCP];
	CP_O2_CO_OP_1		    = hmrate(0.00000000062,0,0)*co.hevmol[ipCP];
	CP_OH_COP_H_1		    = hmrate(0.00000000077,0,0)*co.hevmol[ipCP];
	O_CH_OH_C_1			    = hmrate(0.0000000000252,0,2381)*co.hevmol[ipATO];
	O_CH_HCOP_e_1		    = hmrate(0.00000000002,0.44,0)*co.hevmol[ipATO];
	O_CH_CO_H_1			    = hmrate(0.000000000066,0,0)*co.hevmol[ipATO];
	O_CHP_COP_H_1		    = hmrate(0.00000000035,0,0)*co.hevmol[ipATO];
	O_CH2_OH_CH_1		    = hmrate(0.000000000498,0,6000)*co.hevmol[ipATO];
	O_CH2_CO_H_H_1		    = hmrate(0.000000000133,0,0)*co.hevmol[ipATO];
	O_CH2_CO_H2_1		    = hmrate(0.00000000008,0,0)*co.hevmol[ipATO];
	O_CH2P_HCOP_H_1		    = hmrate(0.00000000075,0,0)*co.hevmol[ipATO];
	O_CH3P_HCOP_H2_1	    = hmrate(0.0000000004,0,0)*co.hevmol[ipATO];
	O_COP_CO_OP_1		    = hmrate(0.00000000014,0,0)*co.hevmol[ipATO];
	O_H2O_OH_OH_1		    = hmrate(0.0000000000185,0.95,8571)*co.hevmol[ipATO];
	O_H2OP_O2P_H2_1		    = hmrate(0.00000000004,0,0)*co.hevmol[ipATO];
	O_O_O2_nu_1			    = hmrate(4.9E-20,1.58,0)*co.hevmol[ipATO];
	O_OH_O2_H_1			    = hmrate(0.0000000000434,-0.5,30)*co.hevmol[ipATO];
	O_OHP_O2P_H_1		    = hmrate(0.00000000071,0,0)*co.hevmol[ipATO];
	O_Si_SiO_nu_1		    = hmrate(5.52E-18,0.31,0)*co.hevmol[ipATO];
	O_SiP_SiOP_nu_1		    = hmrate(0.00000000000000001,0,0)*co.hevmol[ipATO];
	O_SiH_SiO_H_1		    = hmrate(0.00000000004,0.5,0)*co.hevmol[ipATO];
	O_SiH2P_SiOHP_H_1	    = hmrate(0.00000000063,0,0)*co.hevmol[ipATO];
	O_SiOP_O2_SiP_1		    = hmrate(0.0000000002,0,0)*co.hevmol[ipATO];
	OP_CH_O_CHP_1		    = hmrate(0.00000000035,0,0)*co.hevmol[ipOP];
	OP_CH_COP_H_1		    = hmrate(0.00000000035,0,0)*co.hevmol[ipOP];
	OP_CH2_O_CH2P_1		    = hmrate(0.00000000097,0,0)*co.hevmol[ipOP];
	OP_CO_COP_O_1		    = hmrate(0.0000000000049,0.5,4580)*co.hevmol[ipOP];
	OP_H2O_H2OP_O_1		    = hmrate(0.0000000032,0,0)*co.hevmol[ipOP];
	OP_O2_O2P_O_1		    = hmrate(0.000000000019,0,0)*co.hevmol[ipOP];
	OP_OH_O2P_H_1		    = hmrate(0.00000000036,0,0)*co.hevmol[ipOP];
	OP_OH_OHP_O_1		    = hmrate(0.00000000036,0,0)*co.hevmol[ipOP];
	Si_CHP_SiP_CH_1		    = hmrate(0.0000000002,0,0)*co.hevmol[ipATSI];
	Si_H2OP_SiP_H2O_1	    = hmrate(0.000000003,0,0)*co.hevmol[ipATSI];
	Si_OH_SiO_H_1		    = hmrate(0.0000000002,0.5,0)*co.hevmol[ipATSI];
	Si_O2P_O2_SiP_1		    = hmrate(0.0000000016,0,0)*co.hevmol[ipATSI];
	SiP_H2O_SiOHP_H_1	    = hmrate(0.00000000023,0,0)*co.hevmol[ipSIP];
	SiP_OH_SiOP_H_1		    = hmrate(0.00000000063,0,0)*co.hevmol[ipSIP];
	SiP_O2_SiOP_O_1		    = hmrate(0.0000000000001,0,0)*co.hevmol[ipSIP];
	CH_COP_HCOP_C_1		    = hmrate(0.00000000032,0,0)*co.hevmol[ipCH];
	CH_COP_CO_CHP_1		    = hmrate(0.00000000032,0,0)*co.hevmol[ipCH];
	CH_H2OP_H2O_CHP_1	    = hmrate(0.00000000034,0,0)*co.hevmol[ipCH];
	CH_H2OP_OH_CH2P_1	    = hmrate(0.00000000034,0,0)*co.hevmol[ipCH];	
	CH_H3OP_H2O_CH2P_1	    = hmrate(0.00000000068,0,0)*co.hevmol[ipCH];
	CH_HCOP_CO_CH2P_1	    = hmrate(0.00000000063,0,0)*co.hevmol[ipCH];
	CH_O2_CO_OH_1		    = hmrate(0.000000000026,0,0)*co.hevmol[ipCH];
	CH_O2P_O2_CHP_1		    = hmrate(0.00000000031,0,0)*co.hevmol[ipCH];
	CH_O2P_HCOP_O_1		    = hmrate(0.00000000031,0,0)*co.hevmol[ipCH];
	CH_OHP_OH_CHP_1		    = hmrate(0.00000000035,0,0)*co.hevmol[ipCH];
	CH_OHP_O_CH2P_1		    = hmrate(0.00000000035,0,0)*co.hevmol[ipCH];
	CH_SiOP_HCOP_Si_1	    = hmrate(0.00000000059,0,0)*co.hevmol[ipCH];
	CHP_H2O_H3OP_C_1	    = hmrate(0.00000000058,0,0)*co.hevmol[ipCHP];
	CHP_H2O_HCOP_H2_1	    = hmrate(0.0000000029,0,0)*co.hevmol[ipCHP];
	CHP_OH_COP_H2_1	        = hmrate(7.5e-10,0,0)*co.hevmol[ipCHP];
	CHP_O2_HCOP_O_1		    = hmrate(0.00000000097,0,0)*co.hevmol[ipCHP];
	CHP_O2_COP_OH_1		    = hmrate(0.00000000001,0,0)*co.hevmol[ipCHP];
	CH2_COP_HCOP_CH_1	    = hmrate(0.00000000043,0,0)*co.hevmol[ipCH2];
	CH2_COP_CO_CH2P_1	    = hmrate(0.00000000043,0,0)*co.hevmol[ipCH2];
	CH2_H2OP_H2O_CH2P_1     = hmrate(0.00000000047,0,0)*co.hevmol[ipCH2];
	CH2_H2OP_OH_CH3P_1	    = hmrate(0.00000000047,0,0)*co.hevmol[ipCH2];
	CH2_H3OP_H2O_CH3P_1     = hmrate(0.00000000094,0,0)*co.hevmol[ipCH2];
	CH2_HCOP_CO_CH3P_1	    = hmrate(0.00000000086,0,0)*co.hevmol[ipCH2];
	CH2_O2_CO_H2O_1		    = hmrate(0.000000000248,-3.3,1443)*co.hevmol[ipCH2];
	CH2_O2P_O2_CH2P_1	    = hmrate(0.00000000043,0,0)*co.hevmol[ipCH2];
	CH2_OH_H2O_CH_1		    = hmrate(0.0000000000144,0.5,3000)*co.hevmol[ipCH2];
	CH2_OHP_OH_CH2P_1	    = hmrate(0.00000000048,0,0)*co.hevmol[ipCH2];
	CH2_OHP_O_CH3P_1	    = hmrate(0.00000000048,0,0)*co.hevmol[ipCH2];
	CH2P_O2_HCOP_OH_1	    = hmrate(0.00000000091,0,0)*co.hevmol[ipCH2P];
	COP_O2_O2P_CO_1		    = hmrate(0.00000000012,0,0)*co.hevmol[ipCOP];
	H2O_COP_CO_H2OP_1	    = hmrate(0.00000000172,0,0)*co.hevmol[ipH2O];
	H2O_COP_HCOP_OH_1	    = hmrate(0.000000000884,0,0)*co.hevmol[ipH2O];
	H2O_HCOP_CO_H3OP_1	    = hmrate(0.0000000025,0,0)*co.hevmol[ipH2O];
	H2OP_CO_HCOP_OH_1	    = hmrate(0.0000000005,0,0)*co.hevmol[ipH2OP];
	H2OP_H2O_H3OP_OH_1	    = hmrate(0.0000000021,0,0)*co.hevmol[ipH2OP];
	H2OP_O2_O2P_H2O_1	    = hmrate(0.00000000046,0,0)*co.hevmol[ipH2OP];
	H3OP_SiH_SiH2P_H2O_1    = hmrate(0.00000000097,0,0)*co.hevmol[ipH3OP];
	H3OP_SiO_SiOHP_H2O_1    = hmrate(0.000000002,0,0)*co.hevmol[ipH3OP];
	HCOP_SiH_SiH2P_CO_1     = hmrate(0.00000000087,0,0)*co.hevmol[ipHCOP];
	HCOP_SiO_SiOHP_CO_1     = hmrate(0.00000000079,0,0)*co.hevmol[ipHCOP];
	OH_COP_HCOP_O_1		    = hmrate(0.00000000031,0,0)*co.hevmol[ipOH];
	OH_COP_CO_OHP_1		    = hmrate(0.00000000031,0,0)*co.hevmol[ipOH];
	OH_H2OP_H3OP_O_1	    = hmrate(0.00000000069,0,0)*co.hevmol[ipOH];
	OH_HCOP_CO_H2OP_1	    = hmrate(0.00000000062,0,0)*co.hevmol[ipOH];
	OH_OH_H2O_O_1		    = hmrate(0.00000000000165,1.14,50)*co.hevmol[ipOH];
	OHP_CO_HCOP_O_1		    = hmrate(0.00000000105,0,0)*co.hevmol[ipOHP];

	OHP_H2O_H3OP_O_1	    = hmrate(0.0000000013,0,0)*co.hevmol[ipOHP];
	OHP_H2O_H2OP_OH_1	    = hmrate(0.00000000159,0,0)*co.hevmol[ipOHP];
	OHP_O2_O2P_OH_1		    = hmrate(0.00000000059,0,0)*co.hevmol[ipOHP];
	OHP_OH_H2OP_O_1		    = hmrate(0.0000000007,0,0)*co.hevmol[ipOHP];
	OHP_SiH_SiH2P_O_1	    = hmrate(0.000000001,0,0)*co.hevmol[ipOHP];
	OHP_SiO_SiOHP_O_1	    = hmrate(0.00000000094,0,0)*co.hevmol[ipOHP];
	
	C_CH2_CH_CH_2		    = hmrate(0.00000000000269,0,23550)*co.hevmol[ipCH2];
	C_COP_CO_CP_2		    = hmrate(0.00000000011,0,0)*co.hevmol[ipCOP];
	C_H2OP_OH_CHP_2		    = hmrate(0.0000000011,0,0)*co.hevmol[ipH2OP];
	C_H3OP_HCOP_H2_2	    = hmrate(0.00000000001,0,0)*co.hevmol[ipH3OP];
	C_HCOP_CO_CHP_2		    = hmrate(0.0000000011,0,0)*co.hevmol[ipHCOP];
	C_O_CO_nu_2			    = hmrate(2.1E-19,0,0)*co.hevmol[ipATO];
	C_O2_CO_O_2			    = hmrate(0.000000000033,0,0)*co.hevmol[ipO2];
	C_O2P_O2_CP_2		    = hmrate(0.000000000052,0,0)*co.hevmol[ipO2P];
	C_O2P_COP_O_2		    = hmrate(0.000000000052,0,0)*co.hevmol[ipO2P];
	C_OH_O_CH_2			    = hmrate(0.0000000000225,0.5,14800)*co.hevmol[ipOH];
	C_OH_CO_H_2			    = hmrate(0.00000000011,0.5,0)*co.hevmol[ipOH];
	C_OHP_O_CHP_2		    = hmrate(0.0000000012,0,0)*co.hevmol[ipOHP];
	C_SiOP_SiP_CO_2		    = hmrate(0.000000001,0,0)*co.hevmol[ipSIOP];
	CP_OH_CO_HP_2		    = hmrate(0.00000000077,0,0)*co.hevmol[ipOH];
	CP_CH_CHP_C_2		    = hmrate(0.00000000038,0,0)*co.hevmol[ipCH];
	CP_SiO_SiP_CO_2		    = hmrate(0.00000000054,0,0)*co.hevmol[ipSIO];
	CP_CH2_CH2P_C_2		    = hmrate(0.00000000052,0,0)*co.hevmol[ipCH2];
	CP_H2O_HCOP_H_2		    = hmrate(0.0000000009,0,0)*co.hevmol[ipH2O];
	CP_O_COP_nu_2		    = hmrate(2.5E-18,0,0)*co.hevmol[ipATO];
	CP_O2_COP_O_2		    = hmrate(0.00000000038,0,0)*co.hevmol[ipO2];
	CP_O2_CO_OP_2		    = hmrate(0.00000000062,0,0)*co.hevmol[ipO2];
	CP_OH_COP_H_2		    = hmrate(0.00000000077,0,0)*co.hevmol[ipOH];
	O_CH_OH_C_2			    = hmrate(0.0000000000252,0,2381)*co.hevmol[ipCH];
	O_CH_HCOP_e_2		    = hmrate(0.00000000002,0.44,0)*co.hevmol[ipCH];
	O_CH_CO_H_2			    = hmrate(0.000000000066,0,0)*co.hevmol[ipCH];
	O_CHP_COP_H_2		    = hmrate(0.00000000035,0,0)*co.hevmol[ipCHP];
	O_CH2_OH_CH_2		    = hmrate(0.000000000498,0,6000)*co.hevmol[ipCH2];
	O_CH2_CO_H_H_2		    = hmrate(0.000000000133,0,0)*co.hevmol[ipCH2];
	O_CH2_CO_H2_2		    = hmrate(0.00000000008,0,0)*co.hevmol[ipCH2];
	O_CH2P_HCOP_H_2		    = hmrate(0.00000000075,0,0)*co.hevmol[ipCH2P];
	O_CH3P_HCOP_H2_2	    = hmrate(0.0000000004,0,0)*co.hevmol[ipCH3P];
	O_COP_CO_OP_2		    = hmrate(0.00000000014,0,0)*co.hevmol[ipCOP];
	O_H2O_OH_OH_2		    = hmrate(0.0000000000185,0.95,8571)*co.hevmol[ipH2O];
	O_H2OP_O2P_H2_2		    = hmrate(0.00000000004,0,0)*co.hevmol[ipH2OP];
	O_O_O2_nu_2			    = hmrate(4.9E-20,1.58,0)*co.hevmol[ipATO];
	O_OH_O2_H_2			    = hmrate(0.0000000000434,-0.5,30)*co.hevmol[ipOH];
	O_OHP_O2P_H_2		    = hmrate(0.00000000071,0,0)*co.hevmol[ipOHP];
	O_Si_SiO_nu_2		    = hmrate(5.52E-18,0.31,0)*co.hevmol[ipATSI];
	O_SiP_SiOP_nu_2		    = hmrate(0.00000000000000001,0,0)*co.hevmol[ipSIP];
	O_SiH_SiO_H_2		    = hmrate(0.00000000004,0.5,0)*co.hevmol[ipSIH];
	O_SiH2P_SiOHP_H_2	    = hmrate(0.00000000063,0,0)*co.hevmol[ipSIH2P];
	O_SiOP_O2_SiP_2		    = hmrate(0.0000000002,0,0)*co.hevmol[ipSIOP];
	OP_CH_O_CHP_2		    = hmrate(0.00000000035,0,0)*co.hevmol[ipCH];
	OP_CH_COP_H_2		    = hmrate(0.00000000035,0,0)*co.hevmol[ipCH];
	OP_CH2_O_CH2P_2		    = hmrate(0.00000000097,0,0)*co.hevmol[ipCH2];
	OP_CO_COP_O_2		    = hmrate(0.0000000000049,0.5,4580)*co.hevmol[ipCO];
	OP_H2O_H2OP_O_2		    = hmrate(0.0000000032,0,0)*co.hevmol[ipH2O];
	OP_O2_O2P_O_2		    = hmrate(0.000000000019,0,0)*co.hevmol[ipO2];
	OP_OH_O2P_H_2		    = hmrate(0.00000000036,0,0)*co.hevmol[ipOH];
	OP_OH_OHP_O_2		    = hmrate(0.00000000036,0,0)*co.hevmol[ipOH];
	Si_CHP_SiP_CH_2		    = hmrate(0.0000000002,0,0)*co.hevmol[ipCHP];
	Si_H2OP_SiP_H2O_2	    = hmrate(0.000000003,0,0)*co.hevmol[ipH2OP];
	Si_OH_SiO_H_2		    = hmrate(0.0000000002,0.5,0)*co.hevmol[ipOH];
	Si_O2P_O2_SiP_2		    = hmrate(0.0000000016,0,0)*co.hevmol[ipO2P];
	SiP_H2O_SiOHP_H_2	    = hmrate(0.00000000023,0,0)*co.hevmol[ipH2O];
	SiP_OH_SiOP_H_2		    = hmrate(0.00000000063,0,0)*co.hevmol[ipOH];
	SiP_O2_SiOP_O_2		    = hmrate(0.0000000000001,0,0)*co.hevmol[ipO2];
	CH_COP_HCOP_C_2		    = hmrate(0.00000000032,0,0)*co.hevmol[ipCOP];
	CH_COP_CO_CHP_2		    = hmrate(0.00000000032,0,0)*co.hevmol[ipCOP];
	CH_H2OP_H2O_CHP_2	    = hmrate(0.00000000034,0,0)*co.hevmol[ipH2OP];
	CH_H2OP_OH_CH2P_2	    = hmrate(0.00000000034,0,0)*co.hevmol[ipH2OP];
	CH_H3OP_H2O_CH2P_2	    = hmrate(0.00000000068,0,0)*co.hevmol[ipH3OP];
	CH_HCOP_CO_CH2P_2	    = hmrate(0.00000000063,0,0)*co.hevmol[ipHCOP];
	CH_O2_CO_OH_2		    = hmrate(0.000000000026,0,0)*co.hevmol[ipO2];
	CH_O2P_O2_CHP_2		    = hmrate(0.00000000031,0,0)*co.hevmol[ipO2P];
	CH_O2P_HCOP_O_2		    = hmrate(0.00000000031,0,0)*co.hevmol[ipO2P];
	CH_OHP_OH_CHP_2		    = hmrate(0.00000000035,0,0)*co.hevmol[ipOHP];
	CH_OHP_O_CH2P_2		    = hmrate(0.00000000035,0,0)*co.hevmol[ipOHP];
	CH_SiOP_HCOP_Si_2	    = hmrate(0.00000000059,0,0)*co.hevmol[ipSIOP];
	CHP_H2O_H3OP_C_2	    = hmrate(0.00000000058,0,0)*co.hevmol[ipH2O];
	CHP_H2O_HCOP_H2_2	    = hmrate(0.0000000029,0,0)*co.hevmol[ipH2O];
	CHP_OH_COP_H2_2	        = hmrate(7.5e-10,0,0)*co.hevmol[ipOH];
	CHP_O2_HCOP_O_2		    = hmrate(0.00000000097,0,0)*co.hevmol[ipO2];
	CHP_O2_COP_OH_2		    = hmrate(0.00000000001,0,0)*co.hevmol[ipO2];
	CH2_COP_HCOP_CH_2	    = hmrate(0.00000000043,0,0)*co.hevmol[ipCOP];
	CH2_COP_CO_CH2P_2	    = hmrate(0.00000000043,0,0)*co.hevmol[ipCOP];
	CH2_H2OP_H2O_CH2P_2     = hmrate(0.00000000047,0,0)*co.hevmol[ipH2OP];
	CH2_H2OP_OH_CH3P_2	    = hmrate(0.00000000047,0,0)*co.hevmol[ipH2OP];
	CH2_H3OP_H2O_CH3P_2     = hmrate(0.00000000094,0,0)*co.hevmol[ipH3OP];
	CH2_HCOP_CO_CH3P_2	    = hmrate(0.00000000086,0,0)*co.hevmol[ipHCOP];
	CH2_O2_CO_H2O_2		    = hmrate(0.000000000248,-3.3,1443)*co.hevmol[ipO2];
	CH2_O2P_O2_CH2P_2	    = hmrate(0.00000000043,0,0)*co.hevmol[ipO2P];
	CH2_OH_H2O_CH_2		    = hmrate(0.0000000000144,0.5,3000)*co.hevmol[ipOH];
	CH2_OHP_OH_CH2P_2	    = hmrate(0.00000000048,0,0)*co.hevmol[ipOHP];
	CH2_OHP_O_CH3P_2	    = hmrate(0.00000000048,0,0)*co.hevmol[ipOHP];
	CH2P_O2_HCOP_OH_2	    = hmrate(0.00000000091,0,0)*co.hevmol[ipO2];
	COP_O2_O2P_CO_2		    = hmrate(0.00000000012,0,0)*co.hevmol[ipO2];
	H2O_COP_CO_H2OP_2	    = hmrate(0.00000000172,0,0)*co.hevmol[ipCOP];
	H2O_COP_HCOP_OH_2	    = hmrate(0.000000000884,0,0)*co.hevmol[ipCOP];
	H2O_HCOP_CO_H3OP_2	    = hmrate(0.0000000025,0,0)*co.hevmol[ipHCOP];
	H2OP_CO_HCOP_OH_2	    = hmrate(0.0000000005,0,0)*co.hevmol[ipCO];
	H2OP_H2O_H3OP_OH_2	    = hmrate(0.0000000021,0,0)*co.hevmol[ipH2O];
	H2OP_O2_O2P_H2O_2	    = hmrate(0.00000000046,0,0)*co.hevmol[ipO2];
	H3OP_SiH_SiH2P_H2O_2    = hmrate(0.00000000097,0,0)*co.hevmol[ipSIH];
	H3OP_SiO_SiOHP_H2O_2    = hmrate(0.000000002,0,0)*co.hevmol[ipSIO];
	HCOP_SiH_SiH2P_CO_2     = hmrate(0.00000000087,0,0)*co.hevmol[ipSIH];
	HCOP_SiO_SiOHP_CO_2     = hmrate(0.00000000079,0,0)*co.hevmol[ipSIO];
	OH_COP_HCOP_O_2		    = hmrate(0.00000000031,0,0)*co.hevmol[ipCOP];
	OH_COP_CO_OHP_2		    = hmrate(0.00000000031,0,0)*co.hevmol[ipCOP];
	OH_H2OP_H3OP_O_2	    = hmrate(0.00000000069,0,0)*co.hevmol[ipH2OP];
	OH_HCOP_CO_H2OP_2	    = hmrate(0.00000000062,0,0)*co.hevmol[ipHCOP];
	OH_OH_H2O_O_2		    = hmrate(0.00000000000165,1.14,50)*co.hevmol[ipOH];
	OHP_CO_HCOP_O_2		    = hmrate(0.00000000105,0,0)*co.hevmol[ipCO];
	OHP_H2O_H3OP_O_2	    = hmrate(0.0000000013,0,0)*co.hevmol[ipH2O];
	OHP_H2O_H2OP_OH_2	    = hmrate(0.00000000159,0,0)*co.hevmol[ipH2O];
	OHP_O2_O2P_OH_2		    = hmrate(0.00000000059,0,0)*co.hevmol[ipO2];
	OHP_OH_H2OP_O_2		    = hmrate(0.0000000007,0,0)*co.hevmol[ipOH];
	OHP_SiH_SiH2P_O_2	    = hmrate(0.000000001,0,0)*co.hevmol[ipSIH];
	OHP_SiO_SiOHP_O_2	    = hmrate(0.00000000094,0,0)*co.hevmol[ipSIO];

	/* New reactions */
	C_CH5P_CH4_CHP_1	    = hmrate(0.0000000012,0,0)*co.hevmol[ipCH5P];
	C_CH5P_CH4_CHP_2	    = hmrate(0.0000000012,0,0)*co.hevmol[ipATC];
	O_CH4_OH_CH3_1		    = hmrate(0.00000000000229,2.2,3820)*co.hevmol[ipCH4];
	O_CH4_OH_CH3_2		    = hmrate(0.00000000000229,2.2,3820)*co.hevmol[ipATO];
	O_CH4P_OH_CH3P_1	    = hmrate(0.000000001,0,0)*co.hevmol[ipCH4P];
	O_CH4P_OH_CH3P_2	    = hmrate(0.000000001,0,0)*co.hevmol[ipATO];
	O_CH5P_H3OP_CH2_1	    = hmrate(0.00000000022,0,0)*co.hevmol[ipCH5P];
	O_CH5P_H3OP_CH2_2	    = hmrate(0.00000000022,0,0)*co.hevmol[ipATO];
	OP_CH4_OH_CH3P_1	    = hmrate(0.00000000011,0,0)*co.hevmol[ipCH4];
	OP_CH4_OH_CH3P_2	    = hmrate(0.00000000011,0,0)*co.hevmol[ipOP];
	OP_CH4_CH4P_O_1		    = hmrate(0.00000000089,0,0)*co.hevmol[ipCH4];
	OP_CH4_CH4P_O_2		    = hmrate(0.00000000089,0,0)*co.hevmol[ipOP];
	CH4_CH_CH3_CH2_1	    = hmrate(0.0000000000228,0.7,3000)*co.hevmol[ipCH];
	CH4_CH_CH3_CH2_2	    = hmrate(0.0000000000228,0.7,3000)*co.hevmol[ipCH4];
	CH5P_CH_CH4_CH2P_1      = hmrate(0.00000000069,0,0)*co.hevmol[ipCH];
	CH5P_CH_CH4_CH2P_2      = hmrate(0.00000000069,0,0)*co.hevmol[ipCH5P];
	CH2_CH2_CH3_CH_1	    = hmrate(0.0000000004,0,5000)*co.hevmol[ipCH2];
	CH2_CH2_CH3_CH_2	    = hmrate(0.0000000004,0,5000)*co.hevmol[ipCH2];
	CH4_CH2_CH3_CH3_1	    = hmrate(0.00000000000713,0,5050)*co.hevmol[ipCH2];
	CH4_CH2_CH3_CH3_2	    = hmrate(0.00000000000713,0,5050)*co.hevmol[ipCH4];
	OH_CH2_O_CH3_1		    = hmrate(0.0000000000144,0.5,3000)*co.hevmol[ipCH2];
	OH_CH2_O_CH3_2		    = hmrate(0.0000000000144,0.5,3000)*co.hevmol[ipOH];
	CH5P_CH2_CH4_CH3P_1     = hmrate(0.00000000096,0,0)*co.hevmol[ipCH2];
	CH5P_CH2_CH4_CH3P_2     = hmrate(0.00000000096,0,0)*co.hevmol[ipCH5P];
	OH_CH3_CH4_O_1		    = hmrate(0.0000000000000327,2.2,2240)*co.hevmol[ipCH3];
	OH_CH3_CH4_O_2		    = hmrate(0.0000000000000327,2.2,2240)*co.hevmol[ipOH];
	OH_CH3_H2O_CH2_1	    = hmrate(0.00000000012,0,1400)*co.hevmol[ipCH3];
	OH_CH3_H2O_CH2_2	    = hmrate(0.00000000012,0,1400)*co.hevmol[ipOH];
	H2O_CH3_OH_CH4_1	    = hmrate(0.0000000000000023,3.47,6681)*co.hevmol[ipCH3];
	H2O_CH3_OH_CH4_2	    = hmrate(0.0000000000000023,3.47,6681)*co.hevmol[ipH2O];
	CH3_CH3_CH4_CH2_1	    = hmrate(0.00000000000713,0,5052)*co.hevmol[ipCH3];
	CH3_CH3_CH4_CH2_2	    = hmrate(0.00000000000713,0,5052)*co.hevmol[ipCH3];
	OH_CH4_H2O_CH3_1	    = hmrate(0.000000000000377,2.42,1162)*co.hevmol[ipCH4];
	OH_CH4_H2O_CH3_2	    = hmrate(0.000000000000377,2.42,1162)*co.hevmol[ipOH];
	OHP_CH4_CH5P_O_1        = hmrate(0.000000000195,0,0)*co.hevmol[ipCH4];
	OHP_CH4_CH5P_O_2        = hmrate(0.000000000195,0,0)*co.hevmol[ipOHP];
	OHP_CH4_H3OP_CH2_1      = hmrate(0.00000000131,0,0)*co.hevmol[ipCH4];
	OHP_CH4_H3OP_CH2_2      = hmrate(0.00000000131,0,0)*co.hevmol[ipOHP];
	H2OP_CH4_H3OP_CH3_1     = hmrate(0.0000000014,0,0)*co.hevmol[ipCH4];
	H2OP_CH4_H3OP_CH3_2     = hmrate(0.0000000014,0,0)*co.hevmol[ipH2OP];
	COP_CH4_HCOP_CH3_1      = hmrate(0.000000000455,0,0)*co.hevmol[ipCH4];
	COP_CH4_HCOP_CH3_2      = hmrate(0.000000000455,0,0)*co.hevmol[ipCOP];
	COP_CH4_CO_CH4P_1	    = hmrate(0.000000000793,0,0)*co.hevmol[ipCH4];
	COP_CH4_CO_CH4P_2	    = hmrate(0.000000000793,0,0)*co.hevmol[ipCOP];
	CH4_CH4P_CH5P_CH3_1     = hmrate(0.0000000015,0,0)*co.hevmol[ipCH4P];
	CH4_CH4P_CH5P_CH3_2     = hmrate(0.0000000015,0,0)*co.hevmol[ipCH4];
	H2O_CH4P_H3OP_CH3_1     = hmrate(0.0000000026,0,0)*co.hevmol[ipCH4P];
	H2O_CH4P_H3OP_CH3_2     = hmrate(0.0000000026,0,0)*co.hevmol[ipH2O];
	CO_CH4P_HCOP_CH3_1      = hmrate(0.0000000014,0,0)*co.hevmol[ipCH4P];
	CO_CH4P_HCOP_CH3_2      = hmrate(0.0000000014,0,0)*co.hevmol[ipCO];
	O2_CH4P_O2P_CH4_1	    = hmrate(0.0000000004,0,0)*co.hevmol[ipCH4P];
	O2_CH4P_O2P_CH4_2	    = hmrate(0.0000000004,0,0)*co.hevmol[ipO2];
	H2O_CH5P_H3OP_CH4_1     = hmrate(0.0000000037,0,0)*co.hevmol[ipCH5P];
	H2O_CH5P_H3OP_CH4_2     = hmrate(0.0000000037,0,0)*co.hevmol[ipH2O];
	CO_CH5P_HCOP_CH4_1      = hmrate(0.000000001,0,0)*co.hevmol[ipCH5P];
	CO_CH5P_HCOP_CH4_2      = hmrate(0.000000001,0,0)*co.hevmol[ipCO];
	CH5P_OH_H2OP_CH4_1      = hmrate(0.0000000007,0,0)*co.hevmol[ipOH];
	CH5P_OH_H2OP_CH4_2      = hmrate(0.0000000007,0,0)*co.hevmol[ipCH5P];



	/* Simpler, non-coupled reactions */

	H_CH_C_H_H			    = hmrate(0.000000006,0,40200)*dense.xIonDense[ipHYDROGEN][0];
	H_OH_O_H_H			    = hmrate(0.000000006,0,50900)*dense.xIonDense[ipHYDROGEN][0];
	H_H2O_OH_H_H		    = hmrate(0.0000000058,0,52900)*dense.xIonDense[ipHYDROGEN][0];
	H_COP_CO_HP			    = hmrate(0.00000000075,0,0)*dense.xIonDense[ipHYDROGEN][0];
	H_CH_C_H2			    = hmrate(0.000000000027,0.38,0)*dense.xIonDense[ipHYDROGEN][0];
	H_CHP_CP_H2			    = hmrate(0.00000000075,0,0)*dense.xIonDense[ipHYDROGEN][0];
	H_CH2_CH_H2			    = hmrate(0.0000000000664,0,0)*dense.xIonDense[ipHYDROGEN][0];
	H_CH3P_CH2P_H2		    = hmrate(0.0000000007,0,10560)*dense.xIonDense[ipHYDROGEN][0];
	H_OH_O_H2			    = hmrate(0.0000000000000699,2.8,1950)*dense.xIonDense[ipHYDROGEN][0];
	H_H2O_OH_H2			    = hmrate(0.0000000000159,1.2,9610)*dense.xIonDense[ipHYDROGEN][0];
	H_O2_OH_O			    = hmrate(0.000000000261,0,8156)*dense.xIonDense[ipHYDROGEN][0];
	H_O2_O_O_H			    = hmrate(0.000000006,0,52300)*dense.xIonDense[ipHYDROGEN][0];
	H_C_CH_nu               = hmrate(0.00000000000000001,0,0)*dense.xIonDense[ipHYDROGEN][0];
	H_CP_CHP_nu             = hmrate(0.000000000000000017,0,0)*dense.xIonDense[ipHYDROGEN][0];
	H_OH_H2O_nu             = hmrate(5.26E-18,-5.22,90)*dense.xIonDense[ipHYDROGEN][0];
	H_O_OH_nu               = hmrate(9.9E-19,-0.38,0)*dense.xIonDense[ipHYDROGEN][0];
	Hminus_CH_CH2_e         = hmrate(0.0000000001,0,0)*hmi.Hmolec[ipMHm];
	Hminus_C_CH_e			= hmrate(0.000000001,0,0)*hmi.Hmolec[ipMHm];
	Hminus_OH_H2O_e         = hmrate(0.0000000001,0,0)*hmi.Hmolec[ipMHm];
	Hminus_O_OH_e           = hmrate(0.000000001,0,0)*hmi.Hmolec[ipMHm];
	Hminus_HCOP_CO_H2       = hmrate(0.00000023,-0.5,0)*hmi.Hmolec[ipMHm];
	Hminus_H3OP_H2O_H2      = hmrate(0.00000023,-0.5,0)*hmi.Hmolec[ipMHm];
	Hminus_H3OP_OH_H2_H     = hmrate(0.00000023,-0.5,0)*hmi.Hmolec[ipMHm];
	HP_CH_CHP_H             = hmrate(0.0000000019,0,0)*dense.xIonDense[ipHYDROGEN][1];
	HP_CH2_CH2P_H           = hmrate(0.0000000014,0,0)*dense.xIonDense[ipHYDROGEN][1];
	HP_H2O_H2OP_H           = hmrate(0.0000000069,0,0)*dense.xIonDense[ipHYDROGEN][1];
	HP_O2_O2P_H             = hmrate(0.000000002,0,0)*dense.xIonDense[ipHYDROGEN][1];
	HP_OH_OHP_H             = hmrate(0.0000000021,0,0)*dense.xIonDense[ipHYDROGEN][1];
	HP_SiO_SiOP_H           = hmrate(0.0000000033,0,0)*dense.xIonDense[ipHYDROGEN][1];
	HP_CH2_CHP_H2           = hmrate(0.0000000014,0,0)*dense.xIonDense[ipHYDROGEN][1];
	HP_SiH_SiP_H2           = hmrate(0.0000000017,0,0)*dense.xIonDense[ipHYDROGEN][1];
	H2_CHP_CH2P_H           = hmrate(0.0000000012,0,0)*hmi.Hmolec[ipMH2g];
	H2_CH2P_CH3P_H          = hmrate(0.0000000016,0,0)*hmi.Hmolec[ipMH2g];
	H2_OHP_H2OP_H           = hmrate(0.00000000101,0,0)*hmi.Hmolec[ipMH2g];
	H2_H2OP_H3OP_H          = hmrate(0.00000000064,0,0)*hmi.Hmolec[ipMH2g];
	H2_COP_HCOP_H           = hmrate(0.0000000018,0,0)*hmi.Hmolec[ipMH2g];
	H2_OP_OHP_H             = hmrate(0.0000000017,0,0)*hmi.Hmolec[ipMH2g];
	H2_SiOP_SiOHP_H         = hmrate(0.00000000032,0,0)*hmi.Hmolec[ipMH2g];
	H2_C_CH2_nu             = hmrate(0.00000000000000001,0,0)*hmi.Hmolec[ipMH2g];
	H2_CP_CH2P_nu           = hmrate(0.0000000000000004,-0.2,0)*hmi.Hmolec[ipMH2g];
	H2_SiP_SiH2P_nu         = hmrate(0.000000000000000003,0,0)*hmi.Hmolec[ipMH2g];
	H2_C_CH_H               = hmrate(0.000000000664,0,11700)*hmi.Hmolec[ipMH2g];
	H2_CP_CHP_H             = hmrate(0.0000000001,0,4640)*hmi.Hmolec[ipMH2g];
	H2_CH_CH2_H             = hmrate(0.000000000546,0,1943)*hmi.Hmolec[ipMH2g];
	H2_OH_H2O_H             = hmrate(0.00000000000205,1.52,1736)*hmi.Hmolec[ipMH2g];
	H2_O_OH_H               = hmrate(0.000000000000314,2.7,3150)*hmi.Hmolec[ipMH2g];
	H2_CH_C_H2_H            = hmrate(0.000000006,0,40200)*hmi.Hmolec[ipMH2g];
	H2_OH_O_H2_H            = hmrate(0.000000006,0,50900)*hmi.Hmolec[ipMH2g];
	H2_H2O_OH_H2_H          = hmrate(0.0000000058,0,52900)*hmi.Hmolec[ipMH2g];
	H2_O2_O_O_H2            = hmrate(0.000000006,0,52300)*hmi.Hmolec[ipMH2g];
	H2_O2_OH_OH             = hmrate(0.000000000316,0,21890)*hmi.Hmolec[ipMH2g];
	H2_C_CH_H               = hmrate(0.000000000664,0,11700)*hmi.Hmolec[ipMH2g];

	/* H2* */
	H2s_CH_C_H2_H           = hmrate(0.000000006,0,0)*hmi.Hmolec[ipMH2s]*hmi.lgLeiden_Keep_ipMH2s;
	H2s_OH_O_H2_H           = hmrate(0.000000006,0,0)*hmi.Hmolec[ipMH2s]*hmi.lgLeiden_Keep_ipMH2s;
	H2s_H2O_OH_H2_H         = hmrate(0.0000000058,0,0)*hmi.Hmolec[ipMH2s]*hmi.lgLeiden_Keep_ipMH2s;
	H2s_O2_O_O_H2           = hmrate(0.000000006,0,0)*hmi.Hmolec[ipMH2s]*hmi.lgLeiden_Keep_ipMH2s;


	H2P_C_CHP_H             = hmrate(0.0000000024,0,0)*hmi.Hmolec[ipMH2p];
	H2P_CH_CH2P_H           = hmrate(0.00000000071,0,0)*hmi.Hmolec[ipMH2p];
	H2P_CH2_CH3P_H          = hmrate(0.000000001,0,0)*hmi.Hmolec[ipMH2p];
	H2P_OH_H2OP_H           = hmrate(0.00000000076,0,0)*hmi.Hmolec[ipMH2p];
	H2P_H2O_H3OP_H          = hmrate(0.0000000034,0,0)*hmi.Hmolec[ipMH2p];
	H2P_CO_HCOP_H           = hmrate(0.00000000216,0,0)*hmi.Hmolec[ipMH2p];
	H2P_O_OHP_H             = hmrate(0.0000000015,0,0)*hmi.Hmolec[ipMH2p];
	H2P_CH_CHP_H2           = hmrate(0.00000000071,0,0)*hmi.Hmolec[ipMH2p];
	H2P_CH2_CH2P_H2         = hmrate(0.000000001,0,0)*hmi.Hmolec[ipMH2p];
	H2P_CO_COP_H2           = hmrate(0.00000000064,0,0)*hmi.Hmolec[ipMH2p];
	H2P_H2O_H2OP_H2         = hmrate(0.0000000039,0,0)*hmi.Hmolec[ipMH2p];
	H2P_O2_O2P_H2           = hmrate(0.0000000008,0,0)*hmi.Hmolec[ipMH2p];
	H2P_OH_OHP_H2           = hmrate(0.00000000076,0,0)*hmi.Hmolec[ipMH2p];
	H3P_C_CHP_H2            = hmrate(0.000000002,0,0)*hmi.Hmolec[ipMH3p];
	H3P_CH_CH2P_H2          = hmrate(0.0000000012,0,0)*hmi.Hmolec[ipMH3p];
	H3P_CH2_CH3P_H2         = hmrate(0.0000000017,0,0)*hmi.Hmolec[ipMH3p];
	H3P_OH_H2OP_H2          = hmrate(0.0000000013,0,0)*hmi.Hmolec[ipMH3p];
	H3P_H2O_H3OP_H2         = hmrate(0.0000000059,0,0)*hmi.Hmolec[ipMH3p];
	H3P_CO_HCOP_H2          = hmrate(0.0000000017,0,0)*hmi.Hmolec[ipMH3p];
	H3P_O_OHP_H2            = hmrate(0.0000000008,0,0)*hmi.Hmolec[ipMH3p];
	H3P_SiH_SiH2P_H2        = hmrate(0.000000002,0,0)*hmi.Hmolec[ipMH3p];
	H3P_SiO_SiOHP_H2        = hmrate(0.000000002,0,0)*hmi.Hmolec[ipMH3p];
	HeP_CO_OP_C_He          = hmrate(0.00000000000000014,-0.5,0)*dense.xIonDense[ipHELIUM][1];
	HeP_CO_O_CP_He          = hmrate(0.0000000016,0,0)*dense.xIonDense[ipHELIUM][1];
	HeP_CH_CHP_He           = hmrate(0.0000000005,0,0)*dense.xIonDense[ipHELIUM][1];
	HeP_H2O_H2OP_He         = hmrate(0.0000000000605,0,0)*dense.xIonDense[ipHELIUM][1];
	HeP_O2_O2P_He           = hmrate(0.000000000033,0,0)*dense.xIonDense[ipHELIUM][1];
	HeP_Si_SiP_He           = hmrate(0.0000000033,0,0)*dense.xIonDense[ipHELIUM][1];
	HeP_CH_CP_He_H          = hmrate(0.0000000011,0,0)*dense.xIonDense[ipHELIUM][1];
	HeP_CH2_CHP_He_H        = hmrate(0.00000000075,0,0)*dense.xIonDense[ipHELIUM][1];
	HeP_OH_OP_He_H          = hmrate(0.0000000011,0,0)*dense.xIonDense[ipHELIUM][1];
	HeP_H2O_OHP_He_H        = hmrate(0.000000000286,0,0)*dense.xIonDense[ipHELIUM][1];
	HeP_SiH_SiP_He_H        = hmrate(0.0000000018,0,0)*dense.xIonDense[ipHELIUM][1];
	HeP_H2O_OH_He_HP        = hmrate(0.000000000204,0,0)*dense.xIonDense[ipHELIUM][1];
	HeP_CH2_CP_He_H2        = hmrate(0.00000000075,0,0)*dense.xIonDense[ipHELIUM][1];
	HeP_O2_OP_O_He          = hmrate(0.000000001,0,0)*dense.xIonDense[ipHELIUM][1];
	HeP_SiO_SiP_O_He        = hmrate(0.00000000086,0,0)*dense.xIonDense[ipHELIUM][1];
	HeP_SiO_Si_OP_He        = hmrate(0.00000000086,0,0)*dense.xIonDense[ipHELIUM][1];
	crnu_CH_C_H             = secondaries.csupra[ipHYDROGEN][0] * 2. * 756;
	crnu_CHP_CP_H           = secondaries.csupra[ipHYDROGEN][0] * 2. * 183;
	crnu_CO_O_C             = secondaries.csupra[ipHYDROGEN][0] * 2. * 10;
	crnu_H2O_OH_H           = secondaries.csupra[ipHYDROGEN][0] * 2. * 979;
	crnu_O2_O2P_e           = secondaries.csupra[ipHYDROGEN][0] * 2. *88;
	crnu_O2_O_O             = secondaries.csupra[ipHYDROGEN][0] * 2. *730;
	crnu_OH_O_H             = secondaries.csupra[ipHYDROGEN][0] * 2. *522;
	crnu_SiH_Si_H           = secondaries.csupra[ipHYDROGEN][0] * 2. *500;
	crnu_SiO_Si_O           = secondaries.csupra[ipHYDROGEN][0] * 2. *500;
	CRP_CO_COP_e            = 0.000000000000000039;
	nu_CO_O_C               = hmrate(0.0000000002,0,0);
	e_CHP_C_H               = hmrate(0.00000015,-0.42,0)*dense.eden;
	e_CH2P_CH_H             = hmrate(0.00000016,-0.6,0)*dense.eden;
	e_CH2P_C_H_H            = hmrate(0.000000403,-0.6,0)*dense.eden;
	e_CH2P_C_H2             = hmrate(0.0000000768,-0.6,0)*dense.eden;
	e_CH3P_C_H2_H           = hmrate(0.000000105,-0.5,0)*dense.eden;
	e_CH3P_CH2_H            = hmrate(0.00000014,-0.5,0)*dense.eden;
	e_CH3P_CH_H_H           = hmrate(0.000000056,-0.5,0)*dense.eden;
	e_CH3P_CH_H2            = hmrate(0.000000049,-0.5,0)*dense.eden;
	e_CH3P_CH3_nu           = hmrate(1.1e-10,-0.5,0)*dense.eden;
	e_COP_O_C               = hmrate(0.0000002,-0.48,0)*dense.eden;
	e_H2OP_OH_H             = hmrate(0.0000000792,-0.5,0)*dense.eden;
	e_H2OP_O_H_H            = hmrate(0.000000245,-0.5,0)*dense.eden;
	e_H2OP_O_H2             = hmrate(0.000000036,-0.5,0)*dense.eden;
	e_H3OP_H2O_H            = hmrate(0.000000108,-0.5,0)*dense.eden;
	e_H3OP_OH_H_H           = hmrate(0.000000258,-0.5,0)*dense.eden;
	e_H3OP_OH_H2            = hmrate(0.0000000645,-0.5,0)*dense.eden;
	e_H3OP_O_H2_H           = hmrate(0.00000000559,-0.5,0)*dense.eden;
	e_HCOP_CO_H             = hmrate(0.00000011,-1,0)*dense.eden;
	e_O2P_O_O               = hmrate(0.000000195,-0.7,0)*dense.eden;
	e_OHP_O_H               = hmrate(0.0000000375,-0.5,0)*dense.eden;
	e_SiH2P_SiH_H           = hmrate(0.00000015,-0.5,0)*dense.eden;
	e_SiH2P_Si_H_H          = hmrate(0.0000002,-0.5,0)*dense.eden;
	e_SiH2P_Si_H2           = hmrate(0.00000015,-0.5,0)*dense.eden;
	e_SiOP_Si_O             = hmrate(0.0000002,-0.5,0)*dense.eden;
	e_SiOHP_SiO_H           = hmrate(0.00000015,-0.5,0)*dense.eden;
	e_SiOHP_Si_OH           = hmrate(0.00000015,-0.5,0)*dense.eden;
	h2s_ch_ch2_h            = hmrate(0.000000000546,0, 0. )*hmi.Hmolec[ipMH2s]*hmi.lgLeiden_Keep_ipMH2s;
	h2s_o_oh_h              = hmrate(0.000000000000314,2.7, 0. )*hmi.Hmolec[ipMH2s]*hmi.lgLeiden_Keep_ipMH2s;
	h2s_oh_h2o_h            = hmrate(0.00000000000205,1.52, 0. )*hmi.Hmolec[ipMH2s]*hmi.lgLeiden_Keep_ipMH2s;
	h2s_o2_twooh            = hmrate(0.000000000316,0, 0. )*hmi.Hmolec[ipMH2s]*hmi.lgLeiden_Keep_ipMH2s;
	h2s_c_ch_h              = hmrate(0.000000000664,0, 0. )*hmi.Hmolec[ipMH2s]*hmi.lgLeiden_Keep_ipMH2s;
	h2s_cp_chp_h            = hmrate(0.0000000001,0, 0. )*hmi.Hmolec[ipMH2s]*hmi.lgLeiden_Keep_ipMH2s;

	/* New reactions */

	H_CH3_CH2_H2            = hmrate(0.0000000001,0,7600)*dense.xIonDense[ipHYDROGEN][0];
	H_CH4P_CH3P_H2          = hmrate(0.00000000001,0,0)*dense.xIonDense[ipHYDROGEN][0];
	H_CH5P_CH4P_H2          = hmrate(0.00000000002,0,0)*dense.xIonDense[ipHYDROGEN][0];
	H2_CH2_CH3_H            = hmrate(0.0000000000518,0.17,6400)*hmi.Hmolec[ipMH2g];
	H2_CH_CH3_nu            = hmrate(5.09E-18,-0.71,11.6)*hmi.Hmolec[ipMH2g];
	H2_CH3_CH4_H            = hmrate(0.0000000000000686,2.74,4740)*hmi.Hmolec[ipMH2g];
	H2_CH4P_CH5P_H          = hmrate(0.000000000033,0,0)*hmi.Hmolec[ipMH2g];
	H2_CH3P_CH5P_nu         = hmrate(0.000000000000013,-1,0)*hmi.Hmolec[ipMH2g];
	H2s_CH2_CH3_H           = hmrate(0.0000000000518,0.17,0)*hmi.Hmolec[ipMH2s]*hmi.lgLeiden_Keep_ipMH2s;
	H2s_CH_CH3_nu           = hmrate(5.09E-18,-0.71,0)*hmi.Hmolec[ipMH2s]*hmi.lgLeiden_Keep_ipMH2s;
	H2s_CH3_CH4_H           = hmrate(0.0000000000000686,2.74,0)*hmi.Hmolec[ipMH2s]*hmi.lgLeiden_Keep_ipMH2s;
	H2P_CH4_CH3P_H2         = hmrate(0.0000000023,0,0)*hmi.Hmolec[ipMH2p];
	H2P_CH4_CH4P_H2         = hmrate(0.0000000014,0,0)*hmi.Hmolec[ipMH2p];
	H2P_CH4_CH5P_H          = hmrate(0.000000000114,0,0)*hmi.Hmolec[ipMH2p];
	H3P_CH3_CH4P_H2         = hmrate(0.0000000021,0,0)*hmi.Hmolec[ipMH3p];
	H3P_CH4_CH5P_H2         = hmrate(0.0000000024,0,0)*hmi.Hmolec[ipMH3p];
	HeP_CH3_CHP_He          = hmrate(0.0000000018,0,0)*dense.xIonDense[ipHELIUM][1];
	HeP_CH4_CHP_He          = hmrate(0.00000000024,0,0)*dense.xIonDense[ipHELIUM][1];
	HeP_CH4_CH2P_He         = hmrate(0.00000000095,0,0)*dense.xIonDense[ipHELIUM][1];
	HeP_CH4_CH3_He          = hmrate(0.00000000048,0,0)*dense.xIonDense[ipHELIUM][1];
	HeP_CH4_CH3P_He         = hmrate(0.000000000085,0,0)*dense.xIonDense[ipHELIUM][1];
	HeP_CH4_CH4P_He         = hmrate(0.000000000051,0,0)*dense.xIonDense[ipHELIUM][1];
	Hminus_CH2_CH3_e        = hmrate(0.000000001,0,0)*hmi.Hmolec[ipMHm];
	Hminus_CH3_CH4_e        = hmrate(0.000000001,0,0)*hmi.Hmolec[ipMHm];
	HP_CH3_CH3P_H           = hmrate(0.0000000034,0,0)*dense.xIonDense[ipHYDROGEN][1];
	HP_CH4_CH3P_H2          = hmrate(0.0000000023,0,0)*dense.xIonDense[ipHYDROGEN][1];
	HP_CH4_CH4P_H           = hmrate(0.0000000015,0,0)*dense.xIonDense[ipHYDROGEN][1];
	crnu_CH3_CH3P_e         = secondaries.csupra[ipHYDROGEN][0] * 2.*500;
	crnu_CH3_CH2_H          = secondaries.csupra[ipHYDROGEN][0] * 2.*500;
	crnu_CH3_CH_H2          = secondaries.csupra[ipHYDROGEN][0] * 2.*500;
	crnu_CH4_CH2_H2         = secondaries.csupra[ipHYDROGEN][0] * 2.*2272;
	e_CH5P_CH3_H2           = hmrate(0.00000055,-0.3,0)*dense.eden;
	e_CH5P_CH4_H            = hmrate(0.00000055,-0.3,0)*dense.eden;
	e_CH4P_CH3_H            = hmrate(0.000000175,-0.5,0)*dense.eden;
	e_CH4P_CH2_H_H			= hmrate(0.000000175,-0.5,0)*dense.eden;
	
	
	/* This is an additional term used in calculating reactions that are coupled, it appears as a non-zero *
	 * contribution to the Ax     = b equation */

	bvec_C_CH2_CH_CH	    = hmrate(0.00000000000269,0,23550)*PRODUCT_C_CH2;
	bvec_C_COP_CO_CP	    = hmrate(0.00000000011,0,0)*PRODUCT_C_COP;
	bvec_C_H2OP_OH_CHP	    = hmrate(0.0000000011,0,0)*PRODUCT_C_H2OP;
	bvec_C_H3OP_HCOP_H2     = hmrate(0.00000000001,0,0)*PRODUCT_C_H3OP;
	bvec_C_HCOP_CO_CHP	    = hmrate(0.0000000011,0,0)*PRODUCT_C_HCOP;
	bvec_C_O_CO_nu		    = hmrate(2.1E-19,0,0)*PRODUCT_C_O;
	bvec_C_O2_CO_O		    = hmrate(0.000000000033,0,0)*PRODUCT_C_O2;
	bvec_C_O2P_O2_CP	    = hmrate(0.000000000052,0,0)*PRODUCT_C_O2P;
	bvec_C_O2P_COP_O	    = hmrate(0.000000000052,0,0)*PRODUCT_C_O2P;
	bvec_C_OH_O_CH		    = hmrate(0.0000000000225,0.5,14800)*PRODUCT_C_OH;
	bvec_C_OH_CO_H		    = hmrate(0.00000000011,0.5,0)*PRODUCT_C_OH;
	bvec_C_OHP_O_CHP	    = hmrate(0.0000000012,0,0)*PRODUCT_C_OHP;
	bvec_C_SiOP_SiP_CO	    = hmrate(0.000000001,0,0)*PRODUCT_C_SiOP;
	bvec_CP_OH_CO_HP	    = hmrate(0.00000000077,0,0)*PRODUCT_CP_OH;
	bvec_CP_CH_CHP_C	    = hmrate(0.00000000038,0,0)*PRODUCT_CP_CH;
	bvec_CP_SiO_SiP_CO	    = hmrate(0.00000000054,0,0)*PRODUCT_CP_SiO;
	bvec_CP_CH2_CH2P_C	    = hmrate(0.00000000052,0,0)*PRODUCT_CP_CH2;
	bvec_CP_H2O_HCOP_H	    = hmrate(0.0000000009,0,0)*PRODUCT_CP_H2O;
	bvec_CP_O_COP_nu	    = hmrate(2.5E-18,0,0)*PRODUCT_CP_O;
	bvec_CP_O2_COP_O	    = hmrate(0.00000000038,0,0)*PRODUCT_CP_O2;
	bvec_CP_O2_CO_OP	    = hmrate(0.00000000062,0,0)*PRODUCT_CP_O2;
	bvec_CP_OH_COP_H	    = hmrate(0.00000000077,0,0)*PRODUCT_CP_OH;
	bvec_O_CH_OH_C		    = hmrate(0.0000000000252,0,2381)*PRODUCT_O_CH;
	bvec_O_CH_HCOP_e	    = hmrate(0.00000000002,0.44,0)*PRODUCT_O_CH;
	bvec_O_CH_CO_H		    = hmrate(0.000000000066,0,0)*PRODUCT_O_CH;
	bvec_O_CHP_COP_H	    = hmrate(0.00000000035,0,0)*PRODUCT_O_CHP;
	bvec_O_CH2_OH_CH	    = hmrate(0.000000000498,0,6000)*PRODUCT_O_CH2;
	bvec_O_CH2_CO_H_H	    = hmrate(0.000000000133,0,0)*PRODUCT_O_CH2;
	bvec_O_CH2_CO_H2	    = hmrate(0.00000000008,0,0)*PRODUCT_O_CH2;
	bvec_O_CH2P_HCOP_H	    = hmrate(0.00000000075,0,0)*PRODUCT_O_CH2P;
	bvec_O_CH3P_HCOP_H2     = hmrate(0.0000000004,0,0)*PRODUCT_O_CH3P;
	bvec_O_COP_CO_OP	    = hmrate(0.00000000014,0,0)*PRODUCT_O_COP;
	bvec_O_H2O_OH_OH	    = hmrate(0.0000000000185,0.95,8571)*PRODUCT_O_H2O;
	bvec_O_H2OP_O2P_H2	    = hmrate(0.00000000004,0,0)*PRODUCT_O_H2OP;
	bvec_O_O_O2_nu		    = hmrate(4.9E-20,1.58,0)*PRODUCT_O_O;
	bvec_O_OH_O2_H		    = hmrate(0.0000000000434,-0.5,30)*PRODUCT_O_OH;
	bvec_O_OHP_O2P_H	    = hmrate(0.00000000071,0,0)*PRODUCT_O_OHP;
	bvec_O_Si_SiO_nu	    = hmrate(5.52E-18,0.31,0)*PRODUCT_O_Si;
	bvec_O_SiP_SiOP_nu	    = hmrate(0.00000000000000001,0,0)*PRODUCT_O_SiP;
	bvec_O_SiH_SiO_H	    = hmrate(0.00000000004,0.5,0)*PRODUCT_O_SiH;
	bvec_O_SiH2P_SiOHP_H    = hmrate(0.00000000063,0,0)*PRODUCT_O_SiH2P;
	bvec_O_SiOP_O2_SiP	    = hmrate(0.0000000002,0,0)*PRODUCT_O_SiOP;
	bvec_OP_CH_O_CHP	    = hmrate(0.00000000035,0,0)*PRODUCT_OP_CH;
	bvec_OP_CH_COP_H	    = hmrate(0.00000000035,0,0)*PRODUCT_OP_CH;
	bvec_OP_CH2_O_CH2P	    = hmrate(0.00000000097,0,0)*PRODUCT_OP_CH2;
	bvec_OP_CO_COP_O	    = hmrate(0.0000000000049,0.5,4580)*PRODUCT_OP_CO;
	bvec_OP_H2O_H2OP_O	    = hmrate(0.0000000032,0,0)*PRODUCT_OP_H2O;
	bvec_OP_O2_O2P_O	    = hmrate(0.000000000019,0,0)*PRODUCT_OP_O2;
	bvec_OP_OH_O2P_H	    = hmrate(0.00000000036,0,0)*PRODUCT_OP_OH;
	bvec_OP_OH_OHP_O	    = hmrate(0.00000000036,0,0)*PRODUCT_OP_OH;
	bvec_Si_CHP_SiP_CH	    = hmrate(0.0000000002,0,0)*PRODUCT_Si_CHP;
	bvec_Si_H2OP_SiP_H2O    = hmrate(0.000000003,0,0)*PRODUCT_Si_H2OP;
	bvec_Si_OH_SiO_H	    = hmrate(0.0000000002,0.5,0)*PRODUCT_Si_OH;
	bvec_Si_O2P_O2_SiP	    = hmrate(0.0000000016,0,0)*PRODUCT_Si_O2P;
	bvec_SiP_H2O_SiOHP_H    = hmrate(0.00000000023,0,0)*PRODUCT_SiP_H2O;
	bvec_SiP_OH_SiOP_H	    = hmrate(0.00000000063,0,0)*PRODUCT_SiP_OH;
	bvec_SiP_O2_SiOP_O	    = hmrate(0.0000000000001,0,0)*PRODUCT_SiP_O2;
	bvec_CH_COP_HCOP_C	    = hmrate(0.00000000032,0,0)*PRODUCT_CH_COP;
	bvec_CH_COP_CO_CHP	    = hmrate(0.00000000032,0,0)*PRODUCT_CH_COP;
	bvec_CH_H2OP_H2O_CHP    = hmrate(0.00000000034,0,0)*PRODUCT_CH_H2OP;
	bvec_CH_H2OP_OH_CH2P    = hmrate(0.00000000034,0,0)*PRODUCT_CH_H2OP;
	bvec_CH_H3OP_H2O_CH2P   = hmrate(0.00000000068,0,0)*PRODUCT_CH_H3OP;
	bvec_CH_HCOP_CO_CH2P    = hmrate(0.00000000063,0,0)*PRODUCT_CH_HCOP;
	bvec_CH_O2_CO_OH        = hmrate(0.000000000026,0,0)*PRODUCT_CH_O2;
	bvec_CH_O2P_O2_CHP      = hmrate(0.00000000031,0,0)*PRODUCT_CH_O2P;
	bvec_CH_O2P_HCOP_O      = hmrate(0.00000000031,0,0)*PRODUCT_CH_O2P;
	bvec_CH_OHP_OH_CHP      = hmrate(0.00000000035,0,0)*PRODUCT_CH_OHP;
	bvec_CH_OHP_O_CH2P      = hmrate(0.00000000035,0,0)*PRODUCT_CH_OHP;
	bvec_CH_SiOP_HCOP_Si    = hmrate(0.00000000059,0,0)*PRODUCT_CH_SiOP;
	bvec_CHP_H2O_H3OP_C     = hmrate(0.00000000058,0,0)*PRODUCT_CHP_H2O;
	bvec_CHP_H2O_HCOP_H2    = hmrate(0.0000000029,0,0)*PRODUCT_CHP_H2O;
	bvec_CHP_OH_COP_H2      = hmrate(7.5e-10,0,0)*PRODUCT_CHP_OH;	
	bvec_CHP_O2_HCOP_O      = hmrate(0.00000000097,0,0)*PRODUCT_CHP_O2;
	bvec_CHP_O2_COP_OH      = hmrate(0.00000000001,0,0)*PRODUCT_CHP_O2;
	bvec_CH2_COP_HCOP_CH    = hmrate(0.00000000043,0,0)*PRODUCT_CH2_COP;
	bvec_CH2_COP_CO_CH2P    = hmrate(0.00000000043,0,0)*PRODUCT_CH2_COP;
	bvec_CH2_H2OP_H2O_CH2P  = hmrate(0.00000000047,0,0)*PRODUCT_CH2_H2OP;
	bvec_CH2_H2OP_OH_CH3P   = hmrate(0.00000000047,0,0)*PRODUCT_CH2_H2OP;
	bvec_CH2_H3OP_H2O_CH3P  = hmrate(0.00000000094,0,0)*PRODUCT_CH2_H3OP;
	bvec_CH2_HCOP_CO_CH3P   = hmrate(0.00000000086,0,0)*PRODUCT_CH2_HCOP;
	bvec_CH2_O2_CO_H2O      = hmrate(0.000000000248,-3.3,1443)*PRODUCT_CH2_O2;
	bvec_CH2_O2P_O2_CH2P    = hmrate(0.00000000043,0,0)*PRODUCT_CH2_O2P;
	bvec_CH2_OH_H2O_CH      = hmrate(0.0000000000144,0.5,3000)*PRODUCT_CH2_OH;
	bvec_CH2_OHP_OH_CH2P    = hmrate(0.00000000048,0,0)*PRODUCT_CH2_OHP;
	bvec_CH2_OHP_O_CH3P     = hmrate(0.00000000048,0,0)*PRODUCT_CH2_OHP;
	bvec_CH2P_O2_HCOP_OH    = hmrate(0.00000000091,0,0)*PRODUCT_CH2P_O2;
	bvec_COP_O2_O2P_CO      = hmrate(0.00000000012,0,0)*PRODUCT_COP_O2;
	bvec_H2O_COP_CO_H2OP    = hmrate(0.00000000172,0,0)*PRODUCT_H2O_COP;
	bvec_H2O_COP_HCOP_OH    = hmrate(0.000000000884,0,0)*PRODUCT_H2O_COP;
	bvec_H2O_HCOP_CO_H3OP   = hmrate(0.0000000025,0,0)*PRODUCT_H2O_HCOP;
	bvec_H2OP_CO_HCOP_OH    = hmrate(0.0000000005,0,0)*PRODUCT_H2OP_CO;
	bvec_H2OP_H2O_H3OP_OH   = hmrate(0.0000000021,0,0)*PRODUCT_H2OP_H2O;
	bvec_H2OP_O2_O2P_H2O    = hmrate(0.00000000046,0,0)*PRODUCT_H2OP_O2;
	bvec_H3OP_SiH_SiH2P_H2O = hmrate(0.00000000097,0,0)*PRODUCT_H3OP_SiH;
	bvec_H3OP_SiO_SiOHP_H2O = hmrate(0.000000002,0,0)*PRODUCT_H3OP_SiO;
	bvec_HCOP_SiH_SiH2P_CO  = hmrate(0.00000000087,0,0)*PRODUCT_HCOP_SiH;
	bvec_HCOP_SiO_SiOHP_CO  = hmrate(0.00000000079,0,0)*PRODUCT_HCOP_SiO;
	bvec_OH_COP_HCOP_O      = hmrate(0.00000000031,0,0)*PRODUCT_OH_COP;
	bvec_OH_COP_CO_OHP      = hmrate(0.00000000031,0,0)*PRODUCT_OH_COP;
	bvec_OH_H2OP_H3OP_O     = hmrate(0.00000000069,0,0)*PRODUCT_OH_H2OP;
	bvec_OH_HCOP_CO_H2OP    = hmrate(0.00000000062,0,0)*PRODUCT_OH_HCOP;
	bvec_OH_OH_H2O_O        = hmrate(0.00000000000165,1.14,50)*PRODUCT_OH_OH;
	bvec_OHP_CO_HCOP_O      = hmrate(0.00000000105,0,0)*PRODUCT_OHP_CO;
	bvec_OHP_H2O_H3OP_O     = hmrate(0.0000000013,0,0)*PRODUCT_OHP_H2O;
	bvec_OHP_H2O_H2OP_OH    = hmrate(0.00000000159,0,0)*PRODUCT_OHP_H2O;
	bvec_OHP_O2_O2P_OH      = hmrate(0.00000000059,0,0)*PRODUCT_OHP_O2;
	bvec_OHP_OH_H2OP_O      = hmrate(0.0000000007,0,0)*PRODUCT_OHP_OH;
	bvec_OHP_SiH_SiH2P_O    = hmrate(0.000000001,0,0)*PRODUCT_OHP_SiH;
	bvec_OHP_SiO_SiOHP_O    = hmrate(0.00000000094,0,0)*PRODUCT_OHP_SiO;

	/* new bvecs */
	bvec_C_CH5P_CH4_CHP     = hmrate(0.0000000012,0,0)*PRODUCT_C_CH5P;
	bvec_O_CH4_OH_CH3       = hmrate(0.00000000000229,2.2,3820)*PRODUCT_O_CH4;
	bvec_O_CH4P_OH_CH3P     = hmrate(0.000000001,0,0)*PRODUCT_O_CH4P;
	bvec_O_CH5P_H3OP_CH2    = hmrate(0.00000000022,0,0)*PRODUCT_O_CH5P;
	bvec_OP_CH4_OH_CH3P     = hmrate(0.00000000011,0,0)*PRODUCT_OP_CH4;
	bvec_OP_CH4_CH4P_O      = hmrate(0.00000000089,0,0)*PRODUCT_OP_CH4;
	bvec_CH4_CH_CH3_CH2     = hmrate(0.0000000000228,0.7,3000)*PRODUCT_CH4_CH;
	bvec_CH5P_CH_CH4_CH2P   = hmrate(0.00000000069,0,0)*PRODUCT_CH5P_CH;
	bvec_CH2_CH2_CH3_CH     = hmrate(0.0000000004,0,5000)*PRODUCT_CH2_CH2;
	bvec_CH4_CH2_CH3_CH3    = hmrate(0.00000000000713,0,5050)*PRODUCT_CH4_CH2;
	bvec_OH_CH2_O_CH3       = hmrate(0.0000000000144,0.5,3000)*PRODUCT_OH_CH2;
	bvec_CH5P_CH2_CH4_CH3P  = hmrate(0.00000000096,0,0)*PRODUCT_CH5P_CH2;
	bvec_OH_CH3_CH4_O       = hmrate(0.0000000000000327,2.2,2240)*PRODUCT_OH_CH3;
	bvec_OH_CH3_H2O_CH2     = hmrate(0.00000000012,0,1400)*PRODUCT_OH_CH3;
	bvec_H2O_CH3_OH_CH4     = hmrate(0.0000000000000023,3.47,6681)*PRODUCT_H2O_CH3;
	bvec_CH3_CH3_CH4_CH2    = hmrate(0.00000000000713,0,5052)*PRODUCT_CH3_CH3;
	bvec_OH_CH4_H2O_CH3     = hmrate(0.000000000000377,2.42,1162)*PRODUCT_OH_CH4;
	bvec_OHP_CH4_CH5P_O     = hmrate(0.000000000195,0,0)*PRODUCT_OHP_CH4;
	bvec_OHP_CH4_H3OP_CH2   = hmrate(0.00000000131,0,0)*PRODUCT_OHP_CH4;
	bvec_H2OP_CH4_H3OP_CH3  = hmrate(0.0000000014,0,0)*PRODUCT_H2OP_CH4;
	bvec_COP_CH4_HCOP_CH3   = hmrate(0.000000000455,0,0)*PRODUCT_COP_CH4;
	bvec_COP_CH4_CO_CH4P    = hmrate(0.000000000793,0,0)*PRODUCT_COP_CH4;
	bvec_CH4_CH4P_CH5P_CH3  = hmrate(0.0000000015,0,0)*PRODUCT_CH4_CH4P;
	bvec_H2O_CH4P_H3OP_CH3  = hmrate(0.0000000026,0,0)*PRODUCT_H2O_CH4P;
	bvec_CO_CH4P_HCOP_CH3   = hmrate(0.0000000014,0,0)*PRODUCT_CO_CH4P;
	bvec_O2_CH4P_O2P_CH4    = hmrate(0.0000000004,0,0)*PRODUCT_O2_CH4P;
	bvec_H2O_CH5P_H3OP_CH4  = hmrate(0.0000000037,0,0)*PRODUCT_H2O_CH5P;
	bvec_CO_CH5P_HCOP_CH4   = hmrate(0.000000001,0,0)*PRODUCT_CO_CH5P;
	bvec_CH5P_OH_H2OP_CH4   = hmrate(0.0000000007,0,0)*PRODUCT_CH5P_OH;

	/* >>chng 02 jul 04 -- The following are dissociation rates for various molecular species
	For right now we will calculate this rate by the standard form:
	   
			(alpha)*Go*exp(-Beta*AV)


    when the command "set Leiden hack UMIST rates" is used.  Otherwise we
	will just let cloudy calculate the value of the UV radiation field */

	if (!co.lgUMISTrates)
		{

			nu_CH_CHP_e             = hmrate(0.00000000076,0,0)*(hmi.UV_Cont_rel2_Habing_TH85_face*(float)exp(-(2.8*rfield.extin_mag_V_point))/1.66);
			nu_CH_C_H               = hmrate(0.00000000086,0,0)*(hmi.UV_Cont_rel2_Habing_TH85_face*(float)exp(-(1.2*rfield.extin_mag_V_point))/1.66);
			nu_CHP_CP_H             = hmrate(0.00000000025,0,0)*(hmi.UV_Cont_rel2_Habing_TH85_face*(float)exp(-(2.5*rfield.extin_mag_V_point))/1.66);
			nu_CH2_CH2P_e           = hmrate(0.000000001,0,0)*(hmi.UV_Cont_rel2_Habing_TH85_face*(float)exp(-(2.3*rfield.extin_mag_V_point))/1.66);
			nu_CH2_CH_H             = hmrate(0.00000000072,0,0)*(hmi.UV_Cont_rel2_Habing_TH85_face*(float)exp(-(1.7*rfield.extin_mag_V_point))/1.66);
			nu_CH2P_CHP_H           = hmrate(0.0000000017,0,0)*(hmi.UV_Cont_rel2_Habing_TH85_face*(float)exp(-(1.7*rfield.extin_mag_V_point))/1.66);
			nu_CH3P_CH2P_H          = hmrate(0.000000001,0,0)*(hmi.UV_Cont_rel2_Habing_TH85_face*(float)exp(-(1.7*rfield.extin_mag_V_point))/1.66);
			nu_CH3P_CHP_H2          = hmrate(0.000000001,0,0)*(hmi.UV_Cont_rel2_Habing_TH85_face*(float)exp(-(1.7*rfield.extin_mag_V_point))/1.66);
			nu_CO_O_C               = hmrate(0.0000000002,0,0)*(hmi.UV_Cont_rel2_Habing_TH85_face*(float)exp(-(3.2*rfield.extin_mag_V_point))/1.66);;
			nu_H2O_H2OP_e           = hmrate(0.000000000033,0,0)*(hmi.UV_Cont_rel2_Habing_TH85_face*(float)exp(-(3.9*rfield.extin_mag_V_point))/1.66);
			nu_H2O_OH_H             = hmrate(0.00000000059,0,0)*(hmi.UV_Cont_rel2_Habing_TH85_face*(float)exp(-(1.7*rfield.extin_mag_V_point))/1.66);
			nu_O2_O2P_e             = hmrate(0.000000000056,0,0)*(hmi.UV_Cont_rel2_Habing_TH85_face*(float)exp(-(3.7*rfield.extin_mag_V_point))/1.66);
			nu_O2_O_O               = hmrate(0.00000000069,0,0)*(hmi.UV_Cont_rel2_Habing_TH85_face*(float)exp(-(1.8*rfield.extin_mag_V_point))/1.66);
			nu_OH_OHP_e             = hmrate(0.0000000000016,0,0)*(hmi.UV_Cont_rel2_Habing_TH85_face*(float)exp(-(3.1*rfield.extin_mag_V_point))/1.66);
			nu_OH_O_H               = hmrate(0.00000000035,0,0)*(hmi.UV_Cont_rel2_Habing_TH85_face*(float)exp(-(1.7*rfield.extin_mag_V_point))/1.66);
			nu_OHP_O_HP             = hmrate(0.000000000001,0,0)*(hmi.UV_Cont_rel2_Habing_TH85_face*(float)exp(-(1.8*rfield.extin_mag_V_point))/1.66);
			nu_SiH_Si_H             = hmrate(0.0000000028,0,0)*(hmi.UV_Cont_rel2_Habing_TH85_face*(float)exp(-(1.1*rfield.extin_mag_V_point))/1.66);
			nu_SiO_Si_O             = hmrate(0.0000000001,0,0)*(hmi.UV_Cont_rel2_Habing_TH85_face*(float)exp(-(2.3*rfield.extin_mag_V_point))/1.66);
			nu_CH3_CH3P_e           = hmrate(0.0000000001,0,0)*(hmi.UV_Cont_rel2_Habing_TH85_face*(float)exp(-(2.1*rfield.extin_mag_V_point))/1.66);
			nu_CH3_CH2_H            = hmrate(0.00000000025,0,0)*(hmi.UV_Cont_rel2_Habing_TH85_face*(float)exp(-(1.9*rfield.extin_mag_V_point))/1.66);
			nu_CH3_CH_H2            = hmrate(0.00000000025,0,0)*(hmi.UV_Cont_rel2_Habing_TH85_face*(float)exp(-(1.9*rfield.extin_mag_V_point))/1.66);
			nu_CH4_CH3_H            = hmrate(0.00000000022,0,0)*(hmi.UV_Cont_rel2_Habing_TH85_face*(float)exp(-(2.2*rfield.extin_mag_V_point))/1.66);
			nu_CH4_CH2_H2           = hmrate(0.00000000098,0,0)*(hmi.UV_Cont_rel2_Habing_TH85_face*(float)exp(-(2.2*rfield.extin_mag_V_point))/1.66);
			nu_CH4_CH_H2            = hmrate(0.00000000022,0,0)*(hmi.UV_Cont_rel2_Habing_TH85_face*(float)exp(-(2.2*rfield.extin_mag_V_point))/1.66);
			
		}
		/*  This is what will usually be done, calculating the photodissociation rate by calculating the UV
		radiation field self-consistently. */
	else
		{
			
			nu_CH_CHP_e             = hmrate(0.00000000076,0,0)*(hmi.UV_Cont_rel2_Habing_TH85_depth/1.66f);
			nu_CH_C_H               = hmrate(0.00000000086,0,0)*(hmi.UV_Cont_rel2_Habing_TH85_depth/1.66f);
			nu_CHP_CP_H             = hmrate(0.00000000025,0,0)*(hmi.UV_Cont_rel2_Habing_TH85_depth/1.66f);
			nu_CH2_CH2P_e           = hmrate(0.000000001,0,0)*(hmi.UV_Cont_rel2_Habing_TH85_depth/1.66f);
			nu_CH2_CH_H             = hmrate(0.00000000072,0,0)*(hmi.UV_Cont_rel2_Habing_TH85_depth/1.66f);
			nu_CH2P_CHP_H           = hmrate(0.0000000017,0,0)*(hmi.UV_Cont_rel2_Habing_TH85_depth/1.66f);
			nu_CH3P_CH2P_H          = hmrate(0.000000001,0,0)*(hmi.UV_Cont_rel2_Habing_TH85_depth/1.66f);
			nu_CH3P_CHP_H2          = hmrate(0.000000001,0,0)*(hmi.UV_Cont_rel2_Habing_TH85_depth/1.66f);
			nu_CO_O_C               = hmrate(0.0000000002,0,0)*(hmi.UV_Cont_rel2_Habing_TH85_depth/1.66f);
			nu_H2O_H2OP_e           = hmrate(0.000000000033,0,0)*(hmi.UV_Cont_rel2_Habing_TH85_depth/1.66f);
			nu_H2O_OH_H             = hmrate(0.00000000059,0,0)*(hmi.UV_Cont_rel2_Habing_TH85_depth/1.66f);
			nu_O2_O2P_e             = hmrate(0.000000000056,0,0)*(hmi.UV_Cont_rel2_Habing_TH85_depth/1.66f);
			nu_O2_O_O               = hmrate(0.00000000069,0,0)*(hmi.UV_Cont_rel2_Habing_TH85_depth/1.66f);
			nu_OH_OHP_e             = hmrate(0.0000000000016,0,0)*(hmi.UV_Cont_rel2_Habing_TH85_depth/1.66f);
			nu_OH_O_H               = hmrate(0.00000000035,0,0)*(hmi.UV_Cont_rel2_Habing_TH85_depth/1.66f);
			nu_OHP_O_HP             = hmrate(0.000000000001,0,0)*(hmi.UV_Cont_rel2_Habing_TH85_depth/1.66f);
			nu_SiH_Si_H             = hmrate(0.0000000028,0,0)*(hmi.UV_Cont_rel2_Habing_TH85_depth/1.66f);
			nu_SiO_Si_O             = hmrate(0.0000000001,0,0)*(hmi.UV_Cont_rel2_Habing_TH85_depth/1.66f);
			nu_CH3_CH3P_e           = hmrate(0.0000000001,0,0)*(hmi.UV_Cont_rel2_Habing_TH85_depth/1.66f);
			nu_CH3_CH2_H            = hmrate(0.00000000025,0,0)*(hmi.UV_Cont_rel2_Habing_TH85_depth/1.66f);
			nu_CH3_CH_H2            = hmrate(0.00000000025,0,0)*(hmi.UV_Cont_rel2_Habing_TH85_depth/1.66f);
			nu_CH4_CH3_H            = hmrate(0.00000000022,0,0)*(hmi.UV_Cont_rel2_Habing_TH85_depth/1.66f);
			nu_CH4_CH2_H2           = hmrate(0.00000000098,0,0)*(hmi.UV_Cont_rel2_Habing_TH85_depth/1.66f);
			nu_CH4_CH_H2            = hmrate(0.00000000022,0,0)*(hmi.UV_Cont_rel2_Habing_TH85_depth/1.66f);
		}	

	/* >>refer	molecule	H	CH	=>	C	H	H	UMIST	*/
	
	c[ipCH][ipCH] -= H_CH_C_H_H;

	/* >>refer	molecule	H	OH	=>	O	H	H	UMIST	*/

	c[ipOH][ipOH] -= H_OH_O_H_H;

	/* >>refer	molecule	H	H2O	=>	OH	H	H	UMIST	*/

	c[ipH2O][ipH2O] -= H_H2O_OH_H_H;
	c[ipH2O][ipOH] += H_H2O_OH_H_H;
	
	/* >>refer	molecule	H	CO+	=>	CO	H+	UMIST	*/
	
	c[ipCOP][ipCOP] -= H_COP_CO_HP;
	c[ipCOP][ipCO] += H_COP_CO_HP;
	
	/* >>refer	molecule	H	CH	=>	C	H2	UMIST	*/
	
	c[ipCH][ipCH] -= H_CH_C_H2;
	
	/* >>refer	molecule	H	CH+	=>	C+	H2	UMIST	*/
	
	c[ipCHP][ipCHP] -= H_CHP_CP_H2;
	c[ipCHP][ipCP]  += H_CHP_CP_H2;
	
	/* >>refer	molecule	H	CH2	=>	CH	H2	UMIST	*/
		
	c[ipCH2][ipCH2] -= H_CH2_CH_H2;
	c[ipCH2][ipCH] += H_CH2_CH_H2;
	
	/* >>refer	molecule	H	CH3+	=>	CH2+	H2	UMIST	*/
	
	c[ipCH3P][ipCH3P] -= H_CH3P_CH2P_H2;
	c[ipCH3P][ipCH2P] += H_CH3P_CH2P_H2;
	
	/* >>refer	molecule	H	OH	=>	O	H2	UMIST	*/
		
	c[ipOH][ipOH] -= H_OH_O_H2;
	
	/* >>refer	molecule	H	H2O	=>	OH	H2	UMIST	*/
		
	c[ipH2O][ipH2O] -= H_H2O_OH_H2;
	c[ipH2O][ipOH]  += H_H2O_OH_H2;
	
	/* >>refer	molecule	H	O2	=>	OH	O	UMIST	*/
		
	c[ipO2][ipO2] -= H_O2_OH_O;
	c[ipO2][ipOH] += H_O2_OH_O;
	
	/* >>refer	molecule	H	O2	=>	O	O	H	UMIST	*/
		
	c[ipO2][ipO2] -= H_O2_O_O_H;
	
	/* >>refer	molecule	H	C	=>	CH	PHOTON	UMIST	*/
	
	c[ipATC][ipCH] += H_C_CH_nu;
	
	/* >>refer	molecule	H	C+	=>	CH+	PHOTON	UMIST	*/
		
	c[ipCP][ipCP]  -= H_CP_CHP_nu;
	c[ipCP][ipCHP] += H_CP_CHP_nu;
	
	/* >>refer	molecule	H	OH	=>	H2O	PHOTON	UMIST	*/
		
	c[ipOH][ipOH]  -= H_OH_H2O_nu;
	c[ipOH][ipH2O] += H_OH_H2O_nu;
	
	/* >>refer	molecule	H	O	=>	OH	PHOTON	UMIST	*/
		
	c[ipATO][ipOH] += H_O_OH_nu;
	
	/* >>refer	molecule	H-	CH	=>	CH2	e	UMIST	*/
	
	c[ipCH][ipCH]  -= Hminus_CH_CH2_e;
	c[ipCH][ipCH2] += Hminus_CH_CH2_e;
	
	/* >>refer	molecule	H-	C	=>	CH	e	UMIST	*/
	
	c[ipATC][ipCH]  += Hminus_CH_CH2_e;
	
	/* >>refer	molecule	H-	OH	=>	H2O	e	UMIST	*/
		
	c[ipOH][ipOH]  -= Hminus_OH_H2O_e;
	c[ipOH][ipH2O] += Hminus_OH_H2O_e;
	
	/* >>refer	molecule	H-	O	=>	OH	e	UMIST	*/
		
	c[ipATO][ipOH] += Hminus_O_OH_e;
		
	/* >>refer	molecule	H-	HCO+	=>	CO	H2	UMIST	*/
		
	c[ipHCOP][ipHCOP] -= Hminus_HCOP_CO_H2;
	c[ipHCOP][ipCO]   += Hminus_HCOP_CO_H2;
	
	/* >>refer	molecule	H-	H3O+	=>	H2O	H2	UMIST	*/
		
	c[ipH3OP][ipH3OP] -= Hminus_H3OP_H2O_H2;
	c[ipH3OP][ipH2O] += Hminus_H3OP_H2O_H2;
	
	/* >>refer	molecule	H-	H3O+	=>	OH	H2	H	UMIST	*/
		
	c[ipH3OP][ipH3OP] -= Hminus_H3OP_OH_H2_H;
	c[ipH3OP][ipOH] += Hminus_H3OP_OH_H2_H;
	
	/* >>refer	molecule	H+	CH	=>	CH+	H	UMIST	*/
		
	c[ipCH][ipCH] -= HP_CH_CHP_H;
	c[ipCH][ipCHP] += HP_CH_CHP_H;
	
	/* >>refer	molecule	H+	CH2	=>	CH2+	H	UMIST	*/
		
	c[ipCH2][ipCH2] -= HP_CH2_CH2P_H;
	c[ipCH2][ipCH2P] += HP_CH2_CH2P_H;
	
	/* >>refer	molecule	H+	H2O	=>	H2O+	H	UMIST	*/
		
	c[ipH2O][ipH2O] -= HP_H2O_H2OP_H;
	c[ipH2O][ipH2OP] += HP_H2O_H2OP_H;
	
	/* >>refer	molecule	H+	O2	=>	O2+	H	UMIST	*/
	
	c[ipO2][ipO2] -= HP_O2_O2P_H;
	c[ipO2][ipO2P] += HP_O2_O2P_H;
	
	/* >>refer	molecule	H+	OH	=>	OH+	H	UMIST	*/
		
	c[ipOH][ipOH] -= HP_OH_OHP_H;
	c[ipOH][ipOHP] += HP_OH_OHP_H;
	
	/* >>refer	molecule	H+	SiO	=>	SiO+	H	UMIST	*/
		
	c[ipSIO][ipSIO] -= HP_SiO_SiOP_H;
	c[ipSIO][ipSIOP] += HP_SiO_SiOP_H;
	
	/* >>refer	molecule	H+	CH2	=>	CH+	H2	UMIST	*/
		
	c[ipCH2][ipCH2] -= HP_CH2_CHP_H2;
	c[ipCH2][ipCHP] += HP_CH2_CHP_H2;
	
	/* >>refer	molecule	H+	SiH	=>	Si+	H2	UMIST	*/
		
	c[ipSIH][ipSIH] -= HP_SiH_SiP_H2;
	c[ipSIH][ipSIP] += HP_SiH_SiP_H2;
	
	/* >>refer	molecule	H2	C	=>	CH	H	UMIST	*/
	
	c[ipATC][ipCH] += H2_C_CH_H;
	
	/* >>refer	molecule	H2	C+	=>	CH+	H	UMIST	*/
		
	c[ipCP][ipCP]  -= H2_CP_CHP_H;
	c[ipCP][ipCHP] += H2_CP_CHP_H;
	
	/* >>refer	molecule	H2	CH	=>	CH2	H	UMIST	*/
		
	c[ipCH][ipCH] -= H2_CH_CH2_H;
	c[ipCH][ipCH2] += H2_CH_CH2_H;
	
	/* >>refer	molecule	H2	CH+	=>	CH2+	H	UMIST	*/
		
	c[ipCHP][ipCHP] -= H2_CHP_CH2P_H;
	c[ipCHP][ipCH2P] += H2_CHP_CH2P_H;
	
	/* >>refer	molecule	H2	OH	=>	H2O	H	UMIST	*/
		
	c[ipOH][ipOH] -= H2_OH_H2O_H;
	c[ipOH][ipH2O] += H2_OH_H2O_H;
	
	/* >>refer	molecule	H2	OH+	=>	H2O+	H	UMIST	*/
		
	c[ipOHP][ipOHP] -= H2_OHP_H2OP_H;
	c[ipOHP][ipH2OP] += H2_OHP_H2OP_H;
	
	/* >>refer	molecule	H2	H2O+	=>	H3O+	H	UMIST	*/
		
	c[ipH2OP][ipH2OP] -= H2_H2OP_H3OP_H;
	c[ipH2OP][ipH3OP] += H2_H2OP_H3OP_H;
	
	/* >>refer	molecule	H2	CO+	=>	HCO+	H	UMIST	*/
		
	c[ipCOP][ipCOP] -= H2_COP_HCOP_H;
	c[ipCOP][ipHCOP] += H2_COP_HCOP_H;
	
	/* >>refer	molecule	H2	O	=>	OH	H	UMIST	*/
		
	c[ipATO][ipOH] += H2_O_OH_H;

	/* >>refer	molecule	H2	CH2+	=>	CH3+	H	*/

	c[ipCH2P][ipCH2P] -= H2_CH2P_CH3P_H;
	c[ipCH2P][ipCH3P] += H2_CH2P_CH3P_H;
	
	/* >>refer	molecule	H2	O+	=>	OH+	H	UMIST	*/
		
	c[ipOP][ipOP]  -= H2_OP_OHP_H;
	c[ipOP][ipOHP] += H2_OP_OHP_H;
	
	/* >>refer	molecule	H2	SiO+	=>	SiOH+	H	UMIST	*/
	
	c[ipSIOP][ipSIOP] -= H2_SiOP_SiOHP_H;
	c[ipSIOP][ipHOSIP] += H2_SiOP_SiOHP_H;
	
	/* >>refer	molecule	H2	CH	=>	C	H2	H	UMIST	*/
		
	c[ipCH][ipCH] -= H2_CH_C_H2_H;
	
	/* >>refer	molecule	H2	OH	=>	O	H2	H	UMIST	*/
	
	c[ipOH][ipOH] -= H2_OH_O_H2_H;
	
	/* >>refer	molecule	H2	H2O	=>	OH	H2	H	UMIST	*/
		
	c[ipH2O][ipH2O] -= H2_H2O_OH_H2_H;
	c[ipH2O][ipOH] += H2_H2O_OH_H2_H;
	
	/* >>refer	molecule	H2	O2	=>	O	O	H2	UMIST	*/
		
	c[ipO2][ipO2] -= H2_O2_O_O_H2;
	
	/* >>refer	molecule	H2	O2	=>	OH	OH	UMIST	*/
	
	/**********************************************************************
	*                                                                     *
	*  A note here about the stoic. factors.  For a reaction of the type: *	
	*                                                                     *
	*   aA + bB => cC + dD                                                *
	*                                                                     *	
	*  The rates are related by:                                          *
	*                                                                     *
	*  (1/a)*D[A]/Dt = (1/b)*D[B]/Dt = - (1/c)*D[C]/Dt =  - (1/d)*D[D]/Dt *
	*                                                                     *
	*  (As a reference, look at most Physical Chemistry books)		      *
	*                                                                     *
	*                                                                     *
	***********************************************************************/

	c[ipO2][ipO2] -= H2_O2_OH_OH;
	c[ipO2][ipOH] += 2*H2_O2_OH_OH;
	
	/* >>refer	molecule	H2	C	=>	CH2	PHOTON	UMIST	*/
		
	c[ipATC][ipCH2] += H2_C_CH2_nu;
	
	/* >>refer	molecule	H2	C+	=>	CH2+	PHOTON	UMIST	*/
		
	c[ipCP][ipCP]   -= H2_CP_CH2P_nu;
	c[ipCP][ipCH2P] += H2_CP_CH2P_nu;
	
	/* >>refer	molecule	H2	Si+	=>	SiH2+	PHOTON	UMIST	*/
		
	c[ipSIP][ipSIP] -= H2_SiP_SiH2P_nu;
	c[ipSIP][ipSIH2P] += H2_SiP_SiH2P_nu;
	
	/* >>refer	molecule	H2+	C	=>	CH+	H	UMIST	*/
		
	c[ipATC][ipCHP] += H2P_C_CHP_H;
	
	/* >>refer	molecule	H2+	CH	=>	CH2+	H	UMIST	*/
		
	c[ipCH][ipCH] -= H2P_CH_CH2P_H;
	c[ipCH][ipCH2P] += H2P_CH_CH2P_H;
	
	/* >>refer	molecule	H2+	CH2	=>	CH3+	H	UMIST	*/
	
	c[ipCH2][ipCH2] -= H2P_CH2_CH3P_H;
	c[ipCH2][ipCH3P] += H2P_CH2_CH3P_H;
	
	/* >>refer	molecule	H2+	OH	=>	H2O+	H	UMIST	*/
		
	c[ipOH][ipOH] -= H2P_OH_H2OP_H;
	c[ipOH][ipH2OP] += H2P_OH_H2OP_H;
	
	/* >>refer	molecule	H2+	H2O	=>	H3O+	H	UMIST	*/
		
	c[ipH2O][ipH2O] -= H2P_H2O_H3OP_H;
	c[ipH2O][ipH3OP] += H2P_H2O_H3OP_H;
	
	/* >>refer	molecule	H2+	CO	=>	HCO+	H	UMIST	*/
		
	c[ipCO][ipCO] -= H2P_CO_HCOP_H;
	c[ipCO][ipHCOP] += H2P_CO_HCOP_H;
	
	/* >>refer	molecule	H2+	O	=>	OH+	H	UMIST	*/
		
	c[ipATO][ipOHP] += H2P_O_OHP_H;
	
	/* >>refer	molecule	H2+	CH	=>	CH+	H2	UMIST	*/
		
	c[ipCH][ipCH] -= H2P_CH_CHP_H2;
	c[ipCH][ipCHP] += H2P_CH_CHP_H2;
	
	/* >>refer	molecule	H2+	CH2	=>	CH2+	H2	UMIST	*/
		
	c[ipCH2][ipCH2] -= H2P_CH2_CH2P_H2;
	c[ipCH2][ipCH2P] += H2P_CH2_CH2P_H2;
	
	/* >>refer	molecule	H2+	CO	=>	CO+	H2	UMIST	*/
		
	c[ipCO][ipCO] -= H2P_CO_COP_H2;
	c[ipCO][ipCOP] += H2P_CO_COP_H2;
	
	/* >>refer	molecule	H2+	H2O	=>	H2O+	H2	UMIST	*/
		
	c[ipH2O][ipH2O] -= H2P_H2O_H2OP_H2;
	c[ipH2O][ipH2OP] += H2P_H2O_H2OP_H2;
	
	/* >>refer	molecule	H2+	O2	=>	O2+	H2	UMIST	*/
		
	c[ipO2][ipO2] -= H2P_O2_O2P_H2;
	c[ipO2][ipO2P] += H2P_O2_O2P_H2;
	
	/* >>refer	molecule	H2+	OH	=>	OH+	H2	UMIST	*/
		
	c[ipOH][ipOH] -= H2P_OH_OHP_H2;
	c[ipOH][ipOHP] += H2P_OH_OHP_H2;
	
	/* >>refer	molecule	H3+	C	=>	CH+	H2	UMIST	*/
		
	c[ipATC][ipCHP] += H3P_C_CHP_H2;
	
	/* >>refer	molecule	H3+	CH	=>	CH2+	H2	UMIST	*/
		
	c[ipCH][ipCH] -= H3P_CH_CH2P_H2;
	c[ipCH][ipCH2P] += H3P_CH_CH2P_H2;
	
	/* >>refer	molecule	H3+	CH2	=>	CH3P	H2	UMIST	*/
		
	c[ipCH2][ipCH2] -= H3P_CH2_CH3P_H2;
	c[ipCH2][ipCH3P] += H3P_CH2_CH3P_H2;
	
	/* >>refer	molecule	H3+	OH	=>	H2O+	H2	UMIST	*/
		
	c[ipOH][ipOH] -= H3P_OH_H2OP_H2;
	c[ipOH][ipH2OP] += H3P_OH_H2OP_H2;
	
	/* >>refer	molecule	H3+	H2O	=>	H3O+	H2	UMIST	*/
		
	c[ipH2O][ipH2O] -= H3P_H2O_H3OP_H2;
	c[ipH2O][ipH3OP] += H3P_H2O_H3OP_H2;
	
	/* >>refer	molecule	H3+	CO	=>	HCO+	H2	UMIST	*/
		
	c[ipCO][ipCO] -= H3P_CO_HCOP_H2;
	c[ipCO][ipHCOP] += H3P_CO_HCOP_H2;
	
	/* >>refer	molecule	H3+	O	=>	OH+	H2	UMIST	*/
	
	c[ipATO][ipOHP] += H3P_O_OHP_H2;
	
	/* >>refer	molecule	H3+	SiH	=>	SiH2+	H2	UMIST	*/
		
	c[ipSIH][ipSIH] -= H3P_SiH_SiH2P_H2;
	c[ipSIH][ipSIH2P] += H3P_SiH_SiH2P_H2;
	
	/* >>refer	molecule	H3+	SiO	=>	SiOH+	H2	UMIST	*/
		
	c[ipSIO][ipSIO] -= H3P_SiO_SiOHP_H2;
	c[ipSIO][ipHOSIP] += H3P_SiO_SiOHP_H2;
	
	/* >>refer	molecule	He+	CO	=>	O+	C	He	UMIST	*/
		
	c[ipCO][ipCO] -= HeP_CO_OP_C_He;
	c[ipCO][ipOP] += HeP_CO_OP_C_He;
	
	/* >>refer	molecule	He+	CO	=>	O	C+	He	UMIST	*/
		
	c[ipCO][ipCO] -= HeP_CO_O_CP_He;
	c[ipCO][ipCP] += HeP_CO_O_CP_He;

	co.rate_co_hep_o_cp_he = (float)(hmrate(0.0000000016,0,0));
	
	/* >>refer	molecule	He+	CH	=>	CH+	He	UMIST	*/
		
	c[ipCH][ipCH] -= HeP_CH_CHP_He;
	c[ipCH][ipCHP] += HeP_CH_CHP_He;
	
	/* >>refer	molecule	He+	H2O	=>	H2O+	He	UMIST	*/
		
	c[ipH2O][ipH2O] -= HeP_H2O_H2OP_He;
	c[ipH2O][ipH2OP] += HeP_H2O_H2OP_He;
	
	/* >>refer	molecule	He+	O2	=>	O2+	He	UMIST	*/
		
	c[ipO2][ipO2] -= HeP_O2_O2P_He;
	c[ipO2][ipO2P] += HeP_O2_O2P_He;
	
	/* >>refer	molecule	He+	CH	=>	C+	H	He	UMIST	*/
		
	c[ipCH][ipCH] -= HeP_CH_CP_He_H;
	c[ipCH][ipCP] += HeP_CH_CP_He_H;
	
	/* >>refer	molecule	He+	CH2	=>	CH+	H	He	UMIST	*/
		
	c[ipCH2][ipCH2] -= HeP_CH2_CHP_He_H;
	c[ipCH2][ipCHP] += HeP_CH2_CHP_He_H;
	
	/* >>refer	molecule	He+	OH	=>	O+	H	He	UMIST	*/
		
	c[ipOH][ipOH] -= HeP_OH_OP_He_H;
	c[ipOH][ipOP] += HeP_OH_OP_He_H;
	
	/* >>refer	molecule	He+	H2O	=>	OH+	H	He	UMIST	*/
		
	c[ipH2O][ipH2O] -= HeP_H2O_OHP_He_H;
	c[ipH2O][ipOHP] += HeP_H2O_OHP_He_H;
	
	/* >>refer	molecule	He+	SiH	=>	Si+	H	He	UMIST	*/
		
	c[ipSIH][ipSIH] -= HeP_SiH_SiP_He_H;
	c[ipSIH][ipSIP] += HeP_SiH_SiP_He_H;
	
	/* >>refer	molecule	He+	H2O	=>	OH	H+	He	UMIST	*/
		
	c[ipH2O][ipH2O] -= HeP_H2O_OH_He_HP;
	c[ipH2O][ipOH] += HeP_H2O_OH_He_HP;
		
	/* >>refer	molecule	He+	CH2	=>	C+	H2	He	UMIST	*/
	
	c[ipCH2][ipCH2] -= HeP_CH2_CP_He_H2;
	c[ipCH2][ipCP]  += HeP_CH2_CP_He_H2;
	
	/* >>refer	molecule	He+	O2	=>	O+	O	He	UMIST	*/
		
	c[ipO2][ipO2] -= HeP_O2_OP_O_He;
	c[ipO2][ipOP] += HeP_O2_OP_O_He;
	
	/* >>refer	molecule	He+	SiO	=>	Si+	O	He	UMIST	*/
		
	c[ipSIO][ipSIO] -= HeP_SiO_SiP_O_He;
	c[ipSIO][ipSIP] += HeP_SiO_SiP_O_He;
	
	/* >>refer	molecule	He+	SiO	=>	Si	O+	He	UMIST	*/
		
	c[ipSIO][ipSIO] -= HeP_SiO_Si_OP_He;
	c[ipSIO][ipOP]  += HeP_SiO_Si_OP_He;
	
	/* >>refer	molecule	cr	CH	=>	C	H	UMIST	*/
		
	c[ipCH][ipCH] -= crnu_CH_C_H;
	
	/* >>refer	molecule	cr	CH+	=>	C+	H	UMIST	*/
		
	c[ipCHP][ipCHP] -= crnu_CHP_CP_H;
	c[ipCHP][ipCP]  += crnu_CHP_CP_H;
	
	/* >>refer	molecule	cr	CO	=>	C	O	UMIST	*/
		
	c[ipCO][ipCO] -= crnu_CO_O_C;
	
	/* >>refer	molecule	cr	H2O	=>	OH	H	UMIST	*/
		
	c[ipH2O][ipH2O] -= crnu_H2O_OH_H;
	c[ipH2O][ipOH] += crnu_H2O_OH_H;
	
	/* >>refer	molecule	cr	O2	=>	O2+	e	UMIST	*/
		
	c[ipO2][ipO2] -= crnu_O2_O2P_e;
	c[ipO2][ipO2P] += crnu_O2_O2P_e;
	
	/* >>refer	molecule	cr	O2	=>	O	O	UMIST	*/
		
	c[ipO2][ipO2] -= crnu_O2_O_O;
	
	/* >>refer	molecule	cr	OH	=>	O	H	UMIST	*/
		
	c[ipOH][ipOH] -= crnu_OH_O_H;
	
	/* >>refer	molecule	cr	SiH	=>	Si	H	UMIST	*/
		
	c[ipSIH][ipSIH] -= crnu_SiH_Si_H;
	
	/* >>refer	molecule	cr	SiO	=>	Si	O	UMIST	*/
		
	c[ipSIO][ipSIO] -= crnu_SiO_Si_O;
	
	/* >>refer	molecule	CRP	CO	=>	CO+	e	UMIST	*/
		
	c[ipCO][ipCO] -= CRP_CO_COP_e;
	c[ipCO][ipCOP] += CRP_CO_COP_e;
	
	/* >>refer	molecule	PHOTON	CH	=>	CH+	e	UMIST	*/
		
	c[ipCH][ipCH] -= nu_CH_CHP_e;
	c[ipCH][ipCHP] += nu_CH_CHP_e;
	
	/* >>refer	molecule	PHOTON	CH	=>	C	H	UMIST	*/
		
	c[ipCH][ipCH] -= nu_CH_C_H;
	
	/* >>refer	molecule	PHOTON	CH+	=>	C+	H	UMIST	*/
		
	c[ipCHP][ipCHP] -= nu_CHP_CP_H;
	c[ipCHP][ipCP]  += nu_CHP_CP_H;
	
	/* >>refer	molecule	PHOTON	CH2	=>	CH2+	e	UMIST	*/
		
	c[ipCH2][ipCH2] -= nu_CH2_CH2P_e;
	c[ipCH2][ipCH2P] += nu_CH2_CH2P_e;
	
	/* >>refer	molecule	PHOTON	CH2	=>	CH	H	UMIST	*/
		
	c[ipCH2][ipCH2] -= nu_CH2_CH_H;
	c[ipCH2][ipCH] += nu_CH2_CH_H;
	
	/* >>refer	molecule	PHOTON	CH2+	=>	CH+	H	UMIST	*/
		
	c[ipCH2P][ipCH2P] -= nu_CH2P_CHP_H;
	c[ipCH2P][ipCHP] += nu_CH2P_CHP_H;
	
	/* >>refer	molecule	PHOTON	CH3+	=>	CH2+	H	UMIST	*/
		
	c[ipCH3P][ipCH3P] -= nu_CH3P_CH2P_H;
	c[ipCH3P][ipCH2P] += nu_CH3P_CH2P_H;
	
	/* >>refer	molecule	PHOTON	CH3+	=>	CH+	H2	UMIST	*/
		
	c[ipCH3P][ipCH3P] -= nu_CH3P_CHP_H2;
	c[ipCH3P][ipCHP] += nu_CH3P_CHP_H2;
	
	/* >>refer	molecule	PHOTON	CO	=>	C	O	UMIST	*/

	/******************************************************************************************
	*	   First define the rate, which is of the form:
	*	   
	*		R = (Ro)*(Go*exp(-3.2Av))*Beta(tau(CO))
	*
	*	   where:
	*
	*	   Ro = 1.67*e-10
	*	   (Go*exp(-3.2Av)) = hmi.UV_Cont_rel2_Habing_TH85_depth
	*	   tauCO = 4.4e-15 * co.hevcol[ipCO] / (DoppVel.doppler[LIMELM]/1e5) /
	*		(1. + phycon.sqrte*0.6019) ; 
	*       tauC = 1.6*e17*N(C)
	*	   Beta(tau(CO)) = esca0k2(esc_co) 
	********************************************************************************************/   
	/* eqn 12 of hollenbach et al. 91 */
	esc_co = 4.4e-15 * co.hevcol[ipCO] / 
			 /* the line width in km/s */
			 (DoppVel.doppler[LIMELM]/1e5) /
			 /* this term accounts for populations within ground elec state */
			 (1. + phycon.sqrte*0.6019);

	/* hmi.UV_Cont_rel2_Habing_TH85_depth is field relative to Habing background, dimensionless */
	/* >>chng 04 apr 01, move from TH85 to DB96, also correct leading coef to use
	 * UMIST database value */
	/*co.CO_photo_dissoc_rate = 1.67e-10f*hmi.UV_Cont_rel2_Habing_TH85_depth;*/
	co.CO_photo_dissoc_rate = (float)(nu_CO_O_C * esca0k2(esc_co));

	c[ipCO][ipCO] -= co.CO_photo_dissoc_rate;

	/* >>refer	molecule	PHOTON	H2O	=>	H2O+	e	UMIST	*/
		
	c[ipH2O][ipH2O] -= nu_H2O_H2OP_e;
	c[ipH2O][ipH2OP] += nu_H2O_H2OP_e;
	
	/* >>refer	molecule	PHOTON	H2O	=>	OH	H	UMIST	*/
		
	c[ipH2O][ipH2O] -= nu_H2O_OH_H;
	c[ipH2O][ipOH] += nu_H2O_OH_H;
	
	/* >>refer	molecule	PHOTON	O2	=>	O2+	e	UMIST	*/
		
	c[ipO2][ipO2] -= nu_O2_O2P_e;
	c[ipO2][ipO2P] += nu_O2_O2P_e;
	
	/* >>refer	molecule	PHOTON	O2	=>	O	O	UMIST	*/
	
	c[ipO2][ipO2] -= nu_O2_O_O;
	
	/* >>refer	molecule	PHOTON	OH	=>	OH+	e	UMIST	*/
		
	c[ipOH][ipOH] -= nu_OH_OHP_e;
	c[ipOH][ipOHP] += nu_OH_OHP_e;
	
	/* >>refer	molecule	PHOTON	OH	=>	O	H	UMIST	*/
		

	/* A note here is that approx. 55% of the O produced in this reaction goes into the 1D
	   state, which is the upper level of the 6300 Angstrom line, while 5% forms in the 1S
	   state and can create the 5577 line */
	
	/* >>chng 03 oct 20, following had been deleted so OH formation was always zero,
	 * this is used to get OH photo formation of [OI] 6300
	 *>>refer	OI	photoexcitation	Storzer, H., & Hollenbach, D. 2000, ApJ, 539, 751-759 
	 * discussion on bottom left side of page 752 */

	co.rate_OH_dissoc = (float)nu_OH_O_H* co.hevmol[ipOH];

	c[ipOH][ipOH] -= nu_OH_O_H;
	
	/* >>refer	molecule	PHOTON	OH+	=>	O	H+	UMIST	*/
		
	c[ipOHP][ipOHP] -= nu_OHP_O_HP;
	
	/* >>refer	molecule	PHOTON	SiH	=>	Si	H	UMIST	*/
		
	c[ipSIH][ipSIH] -= nu_SiH_Si_H;
	
	/* >>refer	molecule	PHOTON	SiO	=>	Si	O	UMIST	*/
		
	c[ipSIO][ipSIO] -= nu_SiO_Si_O;
	
	/* >>refer	molecule	e	CH+	=>	C	H	UMIST	*/
	
	c[ipCHP][ipCHP] -= e_CHP_C_H;
	
	/* >>refer	molecule	e	CH2+	=>	CH	H	UMIST	*/
		
	c[ipCH2P][ipCH2P] -= e_CH2P_CH_H;
	c[ipCH2P][ipCH] += e_CH2P_CH_H;
	
	/* >>refer	molecule	e	CH2+	=>	C	H	H	UMIST	*/
		
	c[ipCH2P][ipCH2P] -= e_CH2P_C_H_H;

	/* >>refer	molecule	e	CH2+	=>	C	H2	UMIST	*/
		
	c[ipCH2P][ipCH2P] -= e_CH2P_C_H2;
	
	/* >>refer	molecule	e	CH3+	=>	C	H2	H	UMIST	*/
		
	c[ipCH3P][ipCH3P] -= e_CH3P_C_H2_H;
	
	/* >>refer	molecule	e	CH3+	=>	CH2	H	UMIST	*/
	
	c[ipCH3P][ipCH3P] -= e_CH3P_CH2_H;
	c[ipCH3P][ipCH2] += e_CH3P_CH2_H;
	
	/* >>refer	molecule	e	CH3+	=>	CH	H	H	UMIST	*/
		
	c[ipCH3P][ipCH3P] -= e_CH3P_CH_H_H;
	c[ipCH3P][ipCH] += e_CH3P_CH_H_H;
	
	/* >>refer	molecule	e	CH3+	=>	CH	H2	UMIST	*/
		
	c[ipCH3P][ipCH3P] -= e_CH3P_CH_H2;
	c[ipCH3P][ipCH] += e_CH3P_CH_H2;
	
	/* >>refer	molecule	e	CH3+	=>	CH3	PHOTON	UMIST	*/
		
	c[ipCH3P][ipCH3P] -= e_CH3P_CH3_nu;
	c[ipCH3P][ipCH3]   += e_CH3P_CH3_nu;

	/* >>refer	molecule	e	CO+	=>	C	O	UMIST	*/
	
	c[ipCOP][ipCOP] -= e_COP_O_C;
		
	/* >>refer	molecule	e	H2O+	=>	OH	H	UMIST	*/
		
	c[ipH2OP][ipH2OP] -= e_H2OP_OH_H;
	c[ipH2OP][ipOH] += e_H2OP_OH_H;
	
	/* >>refer	molecule	e	H2O+	=>	O	H	H	UMIST	*/
		
	c[ipH2OP][ipH2OP] -= e_H2OP_O_H_H;
	
	/* >>refer	molecule	e	H2O+	=>	O	H2	UMIST	*/
		
	c[ipH2OP][ipH2OP] -= e_H2OP_O_H2;
	
	/* >>refer	molecule	e	H3O+	=>	H2O	H	UMIST	*/
		
	c[ipH3OP][ipH3OP] -= e_H3OP_H2O_H;
	c[ipH3OP][ipH2O] += e_H3OP_H2O_H;
	
	/* >>refer	molecule	e	H3O+	=>	OH	H	H	UMIST	*/
		
	c[ipH3OP][ipH3OP] -= e_H3OP_OH_H_H;
	c[ipH3OP][ipOH] += e_H3OP_OH_H_H;
	
	/* >>refer	molecule	e	H3O+	=>	OH	H2	UMIST	*/
		
	c[ipH3OP][ipH3OP] -= e_H3OP_OH_H2;
	c[ipH3OP][ipOH] += e_H3OP_OH_H2;
	
	/* >>refer	molecule	e	H3O+	=>	O	H2	H	UMIST	*/
		
	c[ipH3OP][ipH3OP] -= e_H3OP_O_H2_H;
	
	/* >>refer	molecule	e	HCO+	=>	CO	H	UMIST	*/
		
	c[ipHCOP][ipHCOP] -= e_HCOP_CO_H;
	c[ipHCOP][ipCO] += e_HCOP_CO_H;
	
	/* >>refer	molecule	e	O2+	=>	O	O	UMIST	*/
	
	c[ipO2P][ipO2P] -= e_O2P_O_O;
	
	/* >>refer	molecule	e	OH+	=>	O	H	UMIST	*/
	
	c[ipOHP][ipOHP] -= e_OHP_O_H;
	
	/* >>refer	molecule	e	SiH2+	=>	SiH	H	UMIST	*/
		
	c[ipSIH2P][ipSIH2P] -= e_SiH2P_SiH_H;
	c[ipSIH2P][ipSIH] += e_SiH2P_SiH_H;
	
	/* >>refer	molecule	e	SiH2+	=>	Si	H	H	UMIST	*/
		
	c[ipSIH2P][ipSIH2P] -= e_SiH2P_Si_H_H;
	
	/* >>refer	molecule	e	SiH2+	=>	Si	H2	UMIST	*/
		
	c[ipSIH2P][ipSIH2P] -= e_SiH2P_Si_H2;
	
	/* >>refer	molecule	e	SiO+	=>	Si	O	UMIST	*/
		
	c[ipSIOP][ipSIOP] -= e_SiOP_Si_O;
	
	/* >>refer	molecule	e	SiOH+	=>	SiO	H	UMIST	*/
		
	c[ipHOSIP][ipHOSIP] -= e_SiOHP_SiO_H;
	c[ipHOSIP][ipSIO] += e_SiOHP_SiO_H;
	
	/* >>refer	molecule	e	SiOH+	=>	Si	OH	UMIST	*/
		
	c[ipHOSIP][ipHOSIP] -= e_SiOHP_Si_OH;
	c[ipHOSIP][ipOH] += e_SiOHP_Si_OH;
	
	/* new simpler reactions for CH3, CH4, CH4+, CH5+ */
	
	/* >>refer molecule   H CH3  =>  CH2 H2   UMIST    */
	c[ipCH3][ipCH3]  -=  H_CH3_CH2_H2;
	c[ipCH3][ipCH2]  +=  H_CH3_CH2_H2;
	
	/* >>refer molecule   H CH4P  =>  CH3P H2   UMIST    */
	c[ipCH4P][ipCH4P]  -=  H_CH4P_CH3P_H2;
	c[ipCH4P][ipCH3P]  +=  H_CH4P_CH3P_H2;
	
	/* >>refer molecule   H CH5P  =>  CH4P H2   UMIST    */
	c[ipCH5P][ipCH5P]  -=  H_CH5P_CH4P_H2;
	c[ipCH5P][ipCH4P]  +=  H_CH5P_CH4P_H2;
	
	/* >>refer molecule   H2 CH2  =>  CH3 H   UMIST    */
	c[ipCH2][ipCH2]  -=  H2_CH2_CH3_H;
	c[ipCH2][ipCH3]  +=  H2_CH2_CH3_H;
	
	/* >>refer molecule   H2 CH  =>  CH3 nu   UMIST    */
	c[ipCH][ipCH]  -=  H2_CH_CH3_nu;
	c[ipCH][ipCH3]  +=  H2_CH_CH3_nu;
	
	/* >>refer molecule   H2 CH3  =>  CH4 H   UMIST    */
	c[ipCH3][ipCH3]  -=  H2_CH3_CH4_H;
	c[ipCH3][ipCH4]  +=  H2_CH3_CH4_H;
	
	/* >>refer molecule   H2 CH4P  =>  CH5P H   UMIST    */
	c[ipCH4P][ipCH4P]  -=  H2_CH4P_CH5P_H;
	c[ipCH4P][ipCH5P]  +=  H2_CH4P_CH5P_H;
	
	/* >>refer molecule   H2 CH3P  =>  CH5P nu   UMIST    */
	c[ipCH3P][ipCH3P]  -=  H2_CH3P_CH5P_nu;
	c[ipCH3P][ipCH5P]  +=  H2_CH3P_CH5P_nu;
	
	/* >>refer molecule   H2P CH4  =>  CH3P H2 H  UMIST    */
	c[ipCH4][ipCH4]  -=  H2P_CH4_CH3P_H2;
	c[ipCH4][ipCH3P]  +=  H2P_CH4_CH3P_H2;
	
	/* >>refer molecule   H2P CH4  =>  CH4P H2   UMIST    */
	c[ipCH4][ipCH4]  -=  H2P_CH4_CH4P_H2;
	c[ipCH4][ipCH4P]  +=  H2P_CH4_CH4P_H2;
	
	/* >>refer molecule   H2P CH4  =>  CH5P H   UMIST    */
	c[ipCH4][ipCH4]  -=  H2P_CH4_CH5P_H;
	c[ipCH4][ipCH5P]  +=  H2P_CH4_CH5P_H;
	
	/* >>refer molecule   H3P CH3  =>  CH4P H2   UMIST    */
	c[ipCH3][ipCH3]  -=  H3P_CH3_CH4P_H2;
	c[ipCH3][ipCH4P]  +=  H3P_CH3_CH4P_H2;
	
	/* >>refer molecule   H3P CH4  =>  CH5P H2   UMIST    */
	c[ipCH4][ipCH4]  -=  H3P_CH4_CH5P_H2;
	c[ipCH4][ipCH5P]  +=  H3P_CH4_CH5P_H2;
	
	/* >>refer molecule   HeP CH3  =>  CHP He H2  UMIST    */
	c[ipCH3][ipCH3]  -=  HeP_CH3_CHP_He;
	c[ipCH3][ipCHP]  +=  HeP_CH3_CHP_He;
	
	/* >>refer molecule   HeP CH4  =>  CHP He H2 H UMIST    */
	c[ipCH4][ipCH4]  -=  HeP_CH4_CHP_He;
	c[ipCH4][ipCHP]  +=  HeP_CH4_CHP_He;
	
	/* >>refer molecule   HeP CH4  =>  CH2P He H2  UMIST    */
	c[ipCH4][ipCH4]  -=  HeP_CH4_CH2P_He;
	c[ipCH4][ipCH2P]  +=  HeP_CH4_CH2P_He;
	
	/* >>refer molecule   HeP CH4  =>  CH3 He HP  UMIST    */
	c[ipCH4][ipCH4]  -=  HeP_CH4_CH3_He;
	c[ipCH4][ipCH3]  +=  HeP_CH4_CH3_He;
	
	/* >>refer molecule   HeP CH4  =>  CH3P He H  UMIST    */
	c[ipCH4][ipCH4]  -=  HeP_CH4_CH3P_He;
	c[ipCH4][ipCH3P]  +=  HeP_CH4_CH3P_He;
	
	/* >>refer molecule   HeP CH4  =>  CH4P He   UMIST    */
	c[ipCH4][ipCH4]  -=  HeP_CH4_CH4P_He;
	c[ipCH4][ipCH4P]  +=  HeP_CH4_CH4P_He;
	
	/* >>refer molecule   Hminus CH2  =>  CH3 e   UMIST    */
	c[ipCH2][ipCH2]  -=  Hminus_CH2_CH3_e;
	c[ipCH2][ipCH3]  +=  Hminus_CH2_CH3_e;
	
	/* >>refer molecule   Hminus CH3  =>  CH4 e   UMIST    */
	c[ipCH3][ipCH3]  -=  Hminus_CH3_CH4_e;
	c[ipCH3][ipCH4]  +=  Hminus_CH3_CH4_e;
	
	/* >>refer molecule   HP CH3  =>  CH3P H   UMIST    */
	c[ipCH3][ipCH3]  -=  HP_CH3_CH3P_H;
	c[ipCH3][ipCH3P]  +=  HP_CH3_CH3P_H;
	
	/* >>refer molecule   HP CH4  =>  CH3P H2   UMIST    */
	c[ipCH4][ipCH4]  -=  HP_CH4_CH3P_H2;
	c[ipCH4][ipCH3P]  +=  HP_CH4_CH3P_H2;
	
	/* >>refer molecule   HP CH4  =>  CH4P H   UMIST    */
	c[ipCH4][ipCH4]  -=  HP_CH4_CH4P_H;
	c[ipCH4][ipCH4P]  +=  HP_CH4_CH4P_H;
	
	/* >>refer molecule   nu CH3  =>  CH3P e   UMIST    */
	c[ipCH3][ipCH3]  -=  nu_CH3_CH3P_e;
	c[ipCH3][ipCH3P]  +=  nu_CH3_CH3P_e;
	
	/* >>refer molecule   nu CH3  =>  CH2 H   UMIST    */
	c[ipCH3][ipCH3]  -=  nu_CH3_CH2_H;
	c[ipCH3][ipCH2]  +=  nu_CH3_CH2_H;
	
	/* >>refer molecule   nu CH3  =>  CH H2   UMIST    */
	c[ipCH3][ipCH3]  -=  nu_CH3_CH_H2;
	c[ipCH3][ipCH]  +=  nu_CH3_CH_H2;
	
	/* >>refer molecule   crnu CH3  =>  CH3P e   UMIST    */
	c[ipCH3][ipCH3]  -=  crnu_CH3_CH3P_e;
	c[ipCH3][ipCH3P]  +=  crnu_CH3_CH3P_e;
	
	/* >>refer molecule   crnu CH3  =>  CH2 H   UMIST    */
	c[ipCH3][ipCH3]  -=  crnu_CH3_CH2_H;
	c[ipCH3][ipCH2]  +=  crnu_CH3_CH2_H;
	
	/* >>refer molecule   crnu CH3  =>  CH H2   UMIST    */
	c[ipCH3][ipCH3]  -=  crnu_CH3_CH_H2;
	c[ipCH3][ipCH]  +=  crnu_CH3_CH_H2;

	/* >>refer	molecule	C + crnu => C+	UMIST */
	/* >>chng 04 sep 19, rm this reaction as per NA email */
	/* This reaction should only be used when the UMIST rate file is wanted 
	if(!co.lgUMISTrates)
		c[ipATC][ipCP] += 5e-17* 2.*510 ;*/

	/* >>refer molecule   nu CH4  =>  CH3 H   UMIST    */
	c[ipCH4][ipCH4]  -=  nu_CH4_CH3_H;
	c[ipCH4][ipCH3]  +=  nu_CH4_CH3_H;	

	/* >>refer molecule   nu CH4  =>  CH2 H2   UMIST    */
	c[ipCH4][ipCH4]  -=  nu_CH4_CH2_H2;
	c[ipCH4][ipCH2]  +=  nu_CH4_CH2_H2;
	
	/* >>refer molecule   nu CH4  =>  CH H2 H  UMIST    */
	c[ipCH4][ipCH4]  -=  nu_CH4_CH_H2;
	c[ipCH4][ipCH]  +=  nu_CH4_CH_H2;
	
	/* >>refer molecule   crnu CH4  =>  CH2 H2   UMIST    */
	c[ipCH4][ipCH4]  -=  crnu_CH4_CH2_H2;
	c[ipCH4][ipCH2]  +=  crnu_CH4_CH2_H2;
	
	/* >>refer molecule   e CH5P  =>  CH3 H2   UMIST    */
	c[ipCH5P][ipCH5P]  -=  e_CH5P_CH3_H2;
	c[ipCH5P][ipCH3]  +=  e_CH5P_CH3_H2;
	
	/* >>refer molecule   e CH5P  =>  CH4 H   UMIST    */
	c[ipCH5P][ipCH5P]  -=  e_CH5P_CH4_H;
	c[ipCH5P][ipCH4]  +=  e_CH5P_CH4_H;
	
	/* >>refer molecule   e CH4P  =>  CH3 H   UMIST    */
	c[ipCH4P][ipCH4P]  -=  e_CH4P_CH3_H;
	c[ipCH4P][ipCH3]  +=  e_CH4P_CH3_H;

	/* >>refer molecule   e CH4P  =>  CH2 H	H   UMIST    */
	c[ipCH4P][ipCH4P]  -=  e_CH4P_CH2_H_H;
	c[ipCH4P][ipCH2]   +=  e_CH4P_CH2_H_H;


 
	/********************************************************************************

									COUPLED REACTIONS

	 ********************************************************************************/

	
	/* >>refer	molecule	C	CH2	=>	CH	CH	UMIST	*/
			
	c[ipCH2][ipCH2] -= C_CH2_CH_CH_1;
	c[ipATC][ipCH2] -= C_CH2_CH_CH_2;
	bvec[ipCH2]     -= bvec_C_CH2_CH_CH;

	c[ipCH2][ipCH]  += 2*C_CH2_CH_CH_1;
	c[ipATC][ipCH]  += 2*C_CH2_CH_CH_2;
	bvec[ipCH]      += 2*bvec_C_CH2_CH_CH;
	
	/* >>refer	molecule	C	CO+	=>	CO	C+	UMIST	*/
	
	c[ipCOP][ipCOP] -= C_COP_CO_CP_1;
	c[ipATC][ipCOP] -= C_COP_CO_CP_2;
	bvec[ipCOP]     -= bvec_C_COP_CO_CP;

	c[ipCOP][ipCO]  += C_COP_CO_CP_1;
	c[ipATC][ipCO]  += C_COP_CO_CP_2;
	bvec[ipCO]      += bvec_C_COP_CO_CP;

	c[ipCOP][ipCP]  += C_COP_CO_CP_1;
	c[ipATC][ipCP]  += C_COP_CO_CP_2;
	bvec[ipCP]      += bvec_C_COP_CO_CP;
	
	/* >>refer	molecule	C	H2O+	=>	OH	CH+	UMIST	*/
		
	c[ipH2OP][ipH2OP] -= C_H2OP_OH_CHP_1;
	c[ipATC][ipH2OP] -= C_H2OP_OH_CHP_2;
	bvec[ipH2OP]     -= bvec_C_H2OP_OH_CHP;
	
	c[ipH2OP][ipOH]  += C_H2OP_OH_CHP_1;
	c[ipATC][ipOH]  += C_H2OP_OH_CHP_2;
	bvec[ipOH]      += bvec_C_H2OP_OH_CHP;
	
	c[ipH2OP][ipCHP] += C_H2OP_OH_CHP_1;
	c[ipATC][ipCHP] += C_H2OP_OH_CHP_2;
	bvec[ipCHP]     += bvec_C_H2OP_OH_CHP;
	
	/* >>refer	molecule	C	H3O+	=>	HCO+	H2	UMIST	*/
		
	c[ipH3OP][ipH3OP] -= C_H3OP_HCOP_H2_1;
	c[ipATC][ipH3OP]  -= C_H3OP_HCOP_H2_2;
	bvec[ipH3OP]      -= bvec_C_H3OP_HCOP_H2;
	
	c[ipH3OP][ipHCOP] += C_H3OP_HCOP_H2_1;
	c[ipATC][ipHCOP]  += C_H3OP_HCOP_H2_2;
	bvec[ipHCOP]      += bvec_C_H3OP_HCOP_H2;
	
	/* >>refer	molecule	C	HCO+	=>	CO	CH+	UMIST	*/
	
	c[ipHCOP][ipHCOP] -= C_HCOP_CO_CHP_1;
	c[ipATC][ipHCOP]  -= C_HCOP_CO_CHP_2;
	bvec[ipHCOP]      -= bvec_C_HCOP_CO_CHP;

	c[ipHCOP][ipCO]   += C_HCOP_CO_CHP_1;
	c[ipATC][ipCO]    += C_HCOP_CO_CHP_2;
	bvec[ipCO]        += bvec_C_HCOP_CO_CHP;
	
	c[ipHCOP][ipCHP]  += C_HCOP_CO_CHP_1;
	c[ipATC][ipCHP]   += C_HCOP_CO_CHP_2;
	bvec[ipCHP]       += bvec_C_HCOP_CO_CHP;
	
	
	/* >>refer	molecule	C	O	=>	CO	PHOTON	UMIST	*/
	
	c[ipATO][ipCO] += C_O_CO_nu_1;
	c[ipATC][ipCO] += C_O_CO_nu_2;
	bvec[ipCO]     += bvec_C_O_CO_nu;
	
	/* >>refer	molecule	C	O2	=>	CO	O	UMIST	*/
	
	c[ipO2][ipO2]  -= C_O2_CO_O_1;
	c[ipATC][ipO2] -= C_O2_CO_O_2;
	bvec[ipO2]     -= bvec_C_O2_CO_O;
	
	c[ipO2][ipCO]  += C_O2_CO_O_1;
	c[ipATC][ipCO] += C_O2_CO_O_2;
	bvec[ipCO]     += bvec_C_O2_CO_O;
	
	/* >>refer	molecule	C	O2+	=>	O2	C+	UMIST	*/
		
	c[ipO2P][ipO2P] -= C_O2P_O2_CP_1;
	c[ipATC][ipO2P] -= C_O2P_O2_CP_2;
	bvec[ipO2P]     -= bvec_C_O2P_O2_CP;
	
	c[ipO2P][ipO2]  += C_O2P_O2_CP_1;
	c[ipATC][ipO2]  += C_O2P_O2_CP_2;
	bvec[ipO2]      += bvec_C_O2P_O2_CP;
	
	c[ipO2P][ipCP]  += C_O2P_O2_CP_1;
	c[ipATC][ipCP]  += C_O2P_O2_CP_2;
	bvec[ipCP]      += bvec_C_O2P_O2_CP;
	
	/* >>refer	molecule	C	O2+	=>	CO+	O	UMIST	*/
	
	c[ipO2P][ipO2P] -= C_O2P_COP_O_1;
	c[ipATC][ipO2P] -= C_O2P_COP_O_2;
	bvec[ipO2P]     -= bvec_C_O2P_COP_O;
	
	c[ipO2P][ipCOP] += C_O2P_COP_O_1;
	c[ipATC][ipCOP] += C_O2P_COP_O_2;
	bvec[ipCOP]     += bvec_C_O2P_COP_O;
	
	/* >>refer	molecule	C	OH	=>	O	CH	UMIST	*/
	
	c[ipOH][ipOH]   -= C_OH_O_CH_1;
	c[ipATC][ipOH]  -= C_OH_O_CH_2;
	bvec[ipOH]      -= bvec_C_OH_O_CH;
	
	c[ipOH][ipCH]   += C_OH_O_CH_1;
	c[ipATC][ipCH]  += C_OH_O_CH_2;
	bvec[ipCH]      += bvec_C_OH_O_CH;
	
	/* >>refer	molecule	C	OH	=>	CO	H	UMIST	*/
	
	c[ipOH][ipOH]  -= C_OH_CO_H_1;
	c[ipATC][ipOH] -= C_OH_CO_H_2;
	bvec[ipOH]     -= bvec_C_OH_CO_H;
	
	c[ipOH][ipCO]  += C_OH_CO_H_1;
	c[ipATC][ipCO] += C_OH_CO_H_2;
	bvec[ipCO]     += bvec_C_OH_CO_H;
	
	/* >>refer	molecule	C	OH+	=>	O	CH+	UMIST	*/
		
	c[ipOHP][ipOHP] -= C_OHP_O_CHP_1;
	c[ipATC][ipOHP] -= C_OHP_O_CHP_2;
	bvec[ipOHP]     -= bvec_C_OHP_O_CHP;
	
	c[ipOHP][ipCHP] += C_OHP_O_CHP_1;
	c[ipATC][ipCHP] += C_OHP_O_CHP_2;
	bvec[ipCHP]     += bvec_C_OHP_O_CHP;
	
	/* >>refer	molecule	C	SiO+	=>	Si+	CO	UMIST	*/
		
	c[ipSIOP][ipSIOP] -= C_SiOP_SiP_CO_1;
	c[ipATC][ipSIOP]  -= C_SiOP_SiP_CO_2;
	bvec[ipSIOP]      -= bvec_C_SiOP_SiP_CO;
	
	c[ipSIOP][ipCO]   += C_SiOP_SiP_CO_1;
	c[ipATC][ipCO]    += C_SiOP_SiP_CO_2;
	bvec[ipCO]        += bvec_C_SiOP_SiP_CO;
	
	c[ipSIOP][ipSIP]   += C_SiOP_SiP_CO_1;
	c[ipATC][ipSIP]    += C_SiOP_SiP_CO_2;
	bvec[ipSIP]        += bvec_C_SiOP_SiP_CO;
	
	/* >>refer	molecule	C+	OH	=>	CO	H+	UMIST	*/
	
	c[ipOH][ipCP]  -= CP_OH_CO_HP_1;
	c[ipCP][ipCP] -= CP_OH_CO_HP_2;
	bvec[ipCP]     -= bvec_CP_OH_CO_HP;
	
	c[ipOH][ipOH]  -= CP_OH_CO_HP_1;
	c[ipCP][ipOH] -= CP_OH_CO_HP_2;
	bvec[ipOH]     -= bvec_CP_OH_CO_HP;
	
	c[ipOH][ipCO]  += CP_OH_CO_HP_1;
	c[ipCP][ipCO] += CP_OH_CO_HP_2;
	bvec[ipCO]     += bvec_CP_OH_CO_HP;
	
	/* >>refer	molecule	C+	CH	=>	CH+	C	UMIST	*/
		
	c[ipCH][ipCP]  -= CP_CH_CHP_C_1;
	c[ipCP][ipCP]  -= CP_CH_CHP_C_2;
	bvec[ipCP]     -= bvec_CP_CH_CHP_C;
		
	c[ipCH][ipCH]  -= CP_CH_CHP_C_1;
	c[ipCP][ipCH]  -= CP_CH_CHP_C_2;
	bvec[ipCH]     -= bvec_CP_CH_CHP_C;
	
	c[ipCH][ipCHP] += CP_CH_CHP_C_1;
	c[ipCP][ipCHP] += CP_CH_CHP_C_2;
	bvec[ipCHP]    += bvec_CP_CH_CHP_C;
	
	/* >>refer	molecule	C+	SiO	=>	Si+	CO	UMIST	*/
		
	c[ipSIO][ipCP] -= CP_SiO_SiP_CO_1;
	c[ipCP][ipCP]  -= CP_SiO_SiP_CO_2;
	bvec[ipCP]     -= bvec_CP_SiO_SiP_CO;
		
	c[ipSIO][ipSIO] -= CP_SiO_SiP_CO_1;
	c[ipCP][ipSIO]  -= CP_SiO_SiP_CO_2;
	bvec[ipSIO]     -= bvec_CP_SiO_SiP_CO;
	
	c[ipSIO][ipCO]  += CP_SiO_SiP_CO_1;
	c[ipCP][ipCO]   += CP_SiO_SiP_CO_2;
	bvec[ipCO]      += bvec_CP_SiO_SiP_CO;
	
	c[ipSIO][ipSIP]  += CP_SiO_SiP_CO_1;
	c[ipCP][ipSIP]   += CP_SiO_SiP_CO_2;
	bvec[ipSIP]      += bvec_CP_SiO_SiP_CO;
	
	/* >>refer	molecule	C+	CH2	=>	CH2+	C	UMIST	*/
		
	c[ipCH2][ipCP]  -= CP_CH2_CH2P_C_1;
	c[ipCP][ipCP]   -= CP_CH2_CH2P_C_2;
	bvec[ipCP]      -= bvec_CP_CH2_CH2P_C;
		
	c[ipCH2][ipCH2]  -= CP_CH2_CH2P_C_1;
	c[ipCP][ipCH2]   -= CP_CH2_CH2P_C_2;
	bvec[ipCH2]      -= bvec_CP_CH2_CH2P_C;
	
	c[ipCH2][ipCH2P] += CP_CH2_CH2P_C_1;
	c[ipCP][ipCH2P]  += CP_CH2_CH2P_C_2;
	bvec[ipCH2P]     += bvec_CP_CH2_CH2P_C;
	
	/* >>refer	molecule	C+	H2O	=>	HCO+	H	UMIST	*/
		
	c[ipH2O][ipCP]  -= CP_H2O_HCOP_H_1;
	c[ipCP][ipCP]   -= CP_H2O_HCOP_H_2;
	bvec[ipCP]      -= bvec_CP_H2O_HCOP_H;
		
	c[ipH2O][ipH2O]  -= CP_H2O_HCOP_H_1;
	c[ipCP][ipH2O]   -= CP_H2O_HCOP_H_2;
	bvec[ipH2O]      -= bvec_CP_H2O_HCOP_H;
	
	c[ipH2O][ipHCOP] += CP_H2O_HCOP_H_1;
	c[ipCP][ipHCOP]  += CP_H2O_HCOP_H_2;
	bvec[ipHCOP]     += bvec_CP_H2O_HCOP_H;
	
	/* >>refer	molecule	C+	O	=>	CO+	PHOTON	UMIST	*/
		
	c[ipATO][ipCP] -= CP_O_COP_nu_1;
	c[ipCP][ipCP]  -= CP_O_COP_nu_2;
	bvec[ipCP]     -= bvec_CP_O_COP_nu;
		
	c[ipATO][ipCOP] += CP_O_COP_nu_1;
	c[ipCP][ipCOP]  += CP_O_COP_nu_2;
	bvec[ipCOP]     += bvec_CP_O_COP_nu;
	
	/* >>refer	molecule	C+	O2	=>	CO+	O	UMIST	*/
	
	c[ipO2][ipCP]  -= CP_O2_COP_O_1;
	c[ipCP][ipCP]  -= CP_O2_COP_O_2;
	bvec[ipCP]     -= bvec_CP_O2_COP_O;
	
	c[ipO2][ipO2]  -= CP_O2_COP_O_1;
	c[ipCP][ipO2]  -= CP_O2_COP_O_2;
	bvec[ipO2]     -= bvec_CP_O2_COP_O;
	
	c[ipO2][ipCOP] += CP_O2_COP_O_1;
	c[ipCP][ipCOP] += CP_O2_COP_O_2;
	bvec[ipCOP]    += bvec_CP_O2_COP_O;
	
	/* >>refer	molecule	C+	O2	=>	CO	O+	UMIST	*/
		
	c[ipO2][ipCP] -= CP_O2_CO_OP_1;
	c[ipCP][ipCP] -= CP_O2_CO_OP_2;
	bvec[ipCP]    -= bvec_CP_O2_CO_OP;
		
	c[ipO2][ipO2] -= CP_O2_CO_OP_1;
	c[ipCP][ipO2] -= CP_O2_CO_OP_2;
	bvec[ipO2]    -= bvec_CP_O2_CO_OP;
	
	c[ipO2][ipCO] += CP_O2_CO_OP_1;
	c[ipCP][ipCO] += CP_O2_CO_OP_2;
	bvec[ipCO]    += bvec_CP_O2_CO_OP;
	
	c[ipO2][ipOP] += CP_O2_CO_OP_1;
	c[ipCP][ipOP] += CP_O2_CO_OP_2;
	bvec[ipOP]    += bvec_CP_O2_CO_OP;
	
	/* >>refer	molecule	C+	OH	=>	CO+	H	UMIST	*/
		
	c[ipOH][ipCP]  -= CP_OH_COP_H_1;
	c[ipCP][ipCP]  -= CP_OH_COP_H_2;
	bvec[ipCP]     -= bvec_CP_OH_COP_H;
		
	c[ipOH][ipOH]  -= CP_OH_COP_H_1;
	c[ipCP][ipOH]  -= CP_OH_COP_H_2;
	bvec[ipOH]     -= bvec_CP_OH_COP_H;
	
	c[ipOH][ipCOP] += CP_OH_COP_H_1;
	c[ipCP][ipCOP] += CP_OH_COP_H_2;
	bvec[ipCOP]    += bvec_CP_OH_COP_H;
	
	/* >>refer	molecule	O	CH	=>	OH	C	UMIST	*/
		
	c[ipCH][ipCH]  -= O_CH_OH_C_1;
	c[ipATO][ipCH] -= O_CH_OH_C_2;
	bvec[ipCH]     -= bvec_O_CH_OH_C;
	
	c[ipCH][ipOH]  += O_CH_OH_C_1;
	c[ipATO][ipOH] += O_CH_OH_C_2;
	bvec[ipOH]     += bvec_O_CH_OH_C;
	
	/* >>refer	molecule	O	CH	=>	HCO+	e	UMIST	*/
		
	c[ipCH][ipCH]    -= O_CH_HCOP_e_1;
	c[ipATO][ipCH]   -= O_CH_HCOP_e_2;
	bvec[ipCH]       -= bvec_O_CH_HCOP_e;
	
	c[ipCH][ipHCOP]  += O_CH_HCOP_e_1;
	c[ipATO][ipHCOP] += O_CH_HCOP_e_2;
	bvec[ipHCOP]     += bvec_O_CH_HCOP_e;
	
	/* >>refer	molecule	O	CH	=>	CO	H	UMIST	*/
		
	c[ipCH][ipCH]  -= O_CH_CO_H_1;
	c[ipATO][ipCH] -= O_CH_CO_H_2;
	bvec[ipCH]     -= bvec_O_CH_CO_H;
	
	c[ipCH][ipCO]  += O_CH_CO_H_1;
	c[ipATO][ipCO] += O_CH_CO_H_2;
	bvec[ipCO]     += bvec_O_CH_CO_H;
	
	/* >>refer	molecule	O	CH+	=>	CO+	H	UMIST	*/
		
	c[ipCHP][ipCHP] -= O_CHP_COP_H_1;
	c[ipATO][ipCHP] -= O_CHP_COP_H_2;
	bvec[ipCHP]     -= bvec_O_CHP_COP_H;
	
	c[ipCHP][ipCOP] += O_CHP_COP_H_1;
	c[ipATO][ipCOP] += O_CHP_COP_H_2;
	bvec[ipCOP]     += bvec_O_CHP_COP_H;
	
	/* >>refer	molecule	O	CH2	=>	OH	CH	UMIST	*/
	
	c[ipCH2][ipCH2] -= O_CH2_OH_CH_1;
	c[ipATO][ipCH2] -= O_CH2_OH_CH_2;
	bvec[ipCH2]     -= bvec_O_CH2_OH_CH;
	
	c[ipCH2][ipOH]  += O_CH2_OH_CH_1;
	c[ipATO][ipOH]  += O_CH2_OH_CH_2;
	bvec[ipOH]      += bvec_O_CH2_OH_CH;
	
	c[ipCH2][ipCH]  += O_CH2_OH_CH_1;
	c[ipATO][ipCH]  += O_CH2_OH_CH_2;
	bvec[ipCH]      += bvec_O_CH2_OH_CH;
	
	/* >>refer	molecule	O	CH2	=>	CO	H	H	UMIST	*/
	
	c[ipCH2][ipCH2] -= O_CH2_CO_H_H_1;
	c[ipATO][ipCH2] -= O_CH2_CO_H_H_2;
	bvec[ipCH2]     -= bvec_O_CH2_CO_H_H;
	
	c[ipCH2][ipCO]  += O_CH2_CO_H_H_1;
	c[ipATO][ipCO]  += O_CH2_CO_H_H_2;
	bvec[ipCO]      += bvec_O_CH2_CO_H_H;
	
	/* >>refer	molecule	O	CH2	=>	CO	H2	UMIST	*/
		
	c[ipCH2][ipCH2] -= O_CH2_CO_H2_1;
	c[ipATO][ipCH2] -= O_CH2_CO_H2_2;
	bvec[ipCH2]     -= bvec_O_CH2_CO_H2;
	
	c[ipCH2][ipCO]  += O_CH2_CO_H2_1;
	c[ipATO][ipCO]  += O_CH2_CO_H2_2;
	bvec[ipCO]      += bvec_O_CH2_CO_H2;
	
	/* >>refer	molecule	O	CH2+	=>	HCO+	H	UMIST	*/
	
	c[ipCH2P][ipCH2P] -= O_CH2P_HCOP_H_1;
	c[ipATO][ipCH2P]  -= O_CH2P_HCOP_H_2;
	bvec[ipCH2P]      -= bvec_O_CH2P_HCOP_H;
	
	c[ipCH2P][ipHCOP] += O_CH2P_HCOP_H_1;
	c[ipATO][ipHCOP]  += O_CH2P_HCOP_H_2;
	bvec[ipHCOP]      += bvec_O_CH2P_HCOP_H;
	
	/* >>refer	molecule	O	CH3+	=>	HCO+	H2	UMIST	*/
		
	c[ipCH3P][ipCH3P] -= O_CH3P_HCOP_H2_1;
	c[ipATO][ipCH3P]  -= O_CH3P_HCOP_H2_2;
	bvec[ipCH3P]      -= bvec_O_CH3P_HCOP_H2;
	
	c[ipCH3P][ipHCOP] += O_CH3P_HCOP_H2_1;
	c[ipATO][ipHCOP]  += O_CH3P_HCOP_H2_2;
	bvec[ipHCOP]      += bvec_O_CH3P_HCOP_H2;
	
	/* >>refer	molecule	O	CO+	=>	CO	O+	UMIST	*/
		
	c[ipCOP][ipCOP] -= O_COP_CO_OP_1;
	c[ipATO][ipCOP] -= O_COP_CO_OP_2;
	bvec[ipCOP]     -= bvec_O_COP_CO_OP;

	c[ipCOP][ipCO]  += O_COP_CO_OP_1;
	c[ipATO][ipCO]  += O_COP_CO_OP_2;
	bvec[ipCO]      += bvec_O_COP_CO_OP;

	c[ipCOP][ipOP]  += O_COP_CO_OP_1;
	c[ipATO][ipOP]  += O_COP_CO_OP_2;
	bvec[ipOP]      += bvec_O_COP_CO_OP;
	
	/* >>refer	molecule	O	H2O	=>	OH	OH	UMIST	*/
		
	c[ipH2O][ipH2O] -= O_H2O_OH_OH_1;
	c[ipATO][ipH2O] -= O_H2O_OH_OH_2;
	bvec[ipH2O]     -= bvec_O_H2O_OH_OH;
	
	c[ipH2O][ipOH]  += 2*O_H2O_OH_OH_1;
	c[ipATO][ipOH]  += 2*O_H2O_OH_OH_2;
	bvec[ipOH]      += 2*bvec_O_H2O_OH_OH;
	
	/* >>refer	molecule	O	H2O+	=>	O2+	H2	UMIST	*/
		
	c[ipH2OP][ipH2OP] -= O_H2OP_O2P_H2_1;
	c[ipATO][ipH2OP]  -= O_H2OP_O2P_H2_2;
	bvec[ipH2OP]      -= bvec_O_H2OP_O2P_H2;
	
	c[ipH2OP][ipO2P]  += O_H2OP_O2P_H2_1;
	c[ipATO][ipO2P]   += O_H2OP_O2P_H2_2;
	bvec[ipO2P]       += bvec_O_H2OP_O2P_H2;
	
	/* >>refer	molecule	O	O	=>	O2	PHOTON	UMIST	*/
	
	c[ipATO][ipO2] += 0.5*O_O_O2_nu_1;
	c[ipATO][ipO2] += 0.5*O_O_O2_nu_2;
	bvec[ipO2]     += 0.5*bvec_O_O_O2_nu;
	
	/* >>refer	molecule	O	OH	=>	O2	H	UMIST	*/
		
	c[ipOH][ipOH]    -= O_OH_O2_H_1;
	c[ipATO][ipOH]   -= O_OH_O2_H_2;
	bvec[ipOH]       -= bvec_O_OH_O2_H;
	
	c[ipOH][ipO2]    += O_OH_O2_H_1;
	c[ipATO][ipO2]   += O_OH_O2_H_2;
	bvec[ipO2]       += bvec_O_OH_O2_H;
	
	/* >>refer	molecule	O	OH+	=>	O2+	H	UMIST	*/
		
	c[ipOHP][ipOHP] -= O_OHP_O2P_H_1;
	c[ipATO][ipOHP] -= O_OHP_O2P_H_2;
	bvec[ipOHP]     -= bvec_O_OHP_O2P_H;
	
	c[ipOHP][ipO2P] += O_OHP_O2P_H_1;
	c[ipATO][ipO2P] += O_OHP_O2P_H_2;
	bvec[ipO2P]     += bvec_O_OHP_O2P_H;
	
	/* >>refer	molecule	O	Si	=>	SiO	PHOTON	UMIST	*/
		
	c[ipATSI][ipSIO] += O_Si_SiO_nu_1;
	c[ipATO][ipSIO]   += O_Si_SiO_nu_2;
	bvec[ipSIO]      += bvec_O_Si_SiO_nu;
	
	/* >>refer	molecule	O	Si+	=>	SiO+	PHOTON	UMIST	*/
			
	c[ipSIP][ipSIP] -= O_SiP_SiOP_nu_1;
	c[ipATO][ipSIP] -= O_SiP_SiOP_nu_2;
	bvec[ipSIP]     -= bvec_O_SiP_SiOP_nu;
			
	c[ipSIP][ipSIOP] += O_SiP_SiOP_nu_1;
	c[ipATO][ipSIOP] += O_SiP_SiOP_nu_2;
	bvec[ipSIOP]     += bvec_O_SiP_SiOP_nu;
	
	/* >>refer	molecule	O	SiH	=>	SiO	H	UMIST	*/
		
	c[ipSIH][ipSIH] -= O_SiH_SiO_H_1;
	c[ipATO][ipSIH] -= O_SiH_SiO_H_2;
	bvec[ipSIH]     -= bvec_O_SiH_SiO_H;
	
	c[ipSIH][ipSIO] += O_SiH_SiO_H_1;
	c[ipATO][ipSIO] += O_SiH_SiO_H_2;
	bvec[ipSIO]     += bvec_O_SiH_SiO_H;
	
	/* >>refer	molecule	O	SiH2+	=>	SiOH+	H	UMIST	*/
			
	c[ipSIH2P][ipSIH2P] -= O_SiH2P_SiOHP_H_1;
	c[ipATO][ipSIH2P]   -= O_SiH2P_SiOHP_H_2;
	bvec[ipSIH2P]       -= bvec_O_SiH2P_SiOHP_H;
	
	c[ipSIH2P][ipHOSIP] += O_SiH2P_SiOHP_H_1;
	c[ipATO][ipHOSIP]   += O_SiH2P_SiOHP_H_2;
	bvec[ipHOSIP]       += bvec_O_SiH2P_SiOHP_H;
	
	/* >>refer	molecule	O	SiO+	=>	O2	Si+	UMIST	*/
			
	c[ipSIOP][ipSIOP] -= O_SiOP_O2_SiP_1;
	c[ipATO][ipSIOP]  -= O_SiOP_O2_SiP_2;
	bvec[ipSIOP]      -= bvec_O_SiOP_O2_SiP;
	
	c[ipSIOP][ipO2]   += O_SiOP_O2_SiP_1;
	c[ipATO][ipO2]    += O_SiOP_O2_SiP_2;
	bvec[ipO2]        += bvec_O_SiOP_O2_SiP;
	
	c[ipSIOP][ipSIP]   += O_SiOP_O2_SiP_1;
	c[ipATO][ipSIP]    += O_SiOP_O2_SiP_2;
	bvec[ipSIP]        += bvec_O_SiOP_O2_SiP;
	
	/* >>refer	molecule	O+	CH	=>	O	CH+	UMIST	*/
		
	
	c[ipCH][ipOP] -= OP_CH_O_CHP_1;
	c[ipOP][ipOP] -= OP_CH_O_CHP_2;
	bvec[ipOP] -= bvec_OP_CH_O_CHP;
	
	c[ipCH][ipCH] -= OP_CH_O_CHP_1;
	c[ipOP][ipCH] -= OP_CH_O_CHP_2;
	bvec[ipCH] -= bvec_OP_CH_O_CHP;
	
	c[ipCH][ipCHP] += OP_CH_O_CHP_1;
	c[ipOP][ipCHP] += OP_CH_O_CHP_2;
	bvec[ipCHP] += bvec_OP_CH_O_CHP;
	
	/* >>refer	molecule	O+	CH	=>	CO+	H	UMIST	*/
		
	
	c[ipCH][ipOP] -= OP_CH_COP_H_1;
	c[ipOP][ipOP] -= OP_CH_COP_H_2;
	bvec[ipOP] -= bvec_OP_CH_COP_H;
	
	c[ipCH][ipCH] -= OP_CH_COP_H_1;
	c[ipOP][ipCH] -= OP_CH_COP_H_2;
	bvec[ipCH] -= bvec_OP_CH_COP_H;
	
	c[ipCH][ipCOP] += OP_CH_COP_H_1;
	c[ipOP][ipCOP] += OP_CH_COP_H_2;
	bvec[ipCOP] += bvec_OP_CH_COP_H;
	
	/* >>refer	molecule	O+	CH2	=>	O	CH2+	UMIST	*/
		
	
	c[ipCH2][ipOP] -= OP_CH2_O_CH2P_1;
	c[ipOP][ipOP] -= OP_CH2_O_CH2P_2;
	bvec[ipOP] -= bvec_OP_CH2_O_CH2P;

	c[ipCH2][ipCH2] -= OP_CH2_O_CH2P_1;
	c[ipOP][ipCH2] -= OP_CH2_O_CH2P_2;
	bvec[ipCH2] -= bvec_OP_CH2_O_CH2P;
	
	c[ipCH2][ipCH2P] += OP_CH2_O_CH2P_1;
	c[ipOP][ipCH2P] += OP_CH2_O_CH2P_2;
	bvec[ipCH2P] += bvec_OP_CH2_O_CH2P;
	
	/* >>refer	molecule	O+	CO	=>	CO+	O	UMIST	*/
		
	
	c[ipCO][ipOP] -= OP_CO_COP_O_1;
	c[ipOP][ipOP] -= OP_CO_COP_O_2;
	bvec[ipOP] -= bvec_OP_CO_COP_O;
	
	c[ipCO][ipCO] -= OP_CO_COP_O_1;
	c[ipOP][ipCO] -= OP_CO_COP_O_2;
	bvec[ipCO] -= bvec_OP_CO_COP_O;
	
	c[ipCO][ipCOP] += OP_CO_COP_O_1;
	c[ipOP][ipCOP] += OP_CO_COP_O_2;
	bvec[ipCOP] += bvec_OP_CO_COP_O;
	
	/* >>refer	molecule	O+	H2O	=>	H2O+	O	UMIST	*/
		
	
	c[ipH2O][ipOP] -= OP_H2O_H2OP_O_1;
	c[ipOP][ipOP] -= OP_H2O_H2OP_O_2;
	bvec[ipOP] -= bvec_OP_H2O_H2OP_O;
	
	c[ipH2O][ipH2O] -= OP_H2O_H2OP_O_1;
	c[ipOP][ipH2O] -= OP_H2O_H2OP_O_2;
	bvec[ipH2O] -= bvec_OP_H2O_H2OP_O;
	
	c[ipH2O][ipH2OP] += OP_H2O_H2OP_O_1;
	c[ipOP][ipH2OP] += OP_H2O_H2OP_O_2;
	bvec[ipH2OP] += bvec_OP_H2O_H2OP_O;
	
	/* >>refer	molecule	O+	O2	=>	O2+	O	UMIST	*/
		
	
	c[ipO2][ipOP] -= OP_O2_O2P_O_1;
	c[ipOP][ipOP] -= OP_O2_O2P_O_2;
	bvec[ipOP] -= bvec_OP_O2_O2P_O;
	
	c[ipO2][ipO2] -= OP_O2_O2P_O_1;
	c[ipOP][ipO2] -= OP_O2_O2P_O_2;
	bvec[ipO2] -= bvec_OP_O2_O2P_O;
	
	c[ipO2][ipO2P] += OP_O2_O2P_O_1;
	c[ipOP][ipO2P] += OP_O2_O2P_O_2;
	bvec[ipO2P] += bvec_OP_O2_O2P_O;
	
	/* >>refer	molecule	O+	OH	=>	O2+	H	UMIST	*/
		
	
	c[ipOH][ipOP] -= OP_OH_O2P_H_1;
	c[ipOP][ipOP] -= OP_OH_O2P_H_2;
	bvec[ipOP] -= bvec_OP_OH_O2P_H;
	
	c[ipOH][ipOH] -= OP_OH_O2P_H_1;
	c[ipOP][ipOH] -= OP_OH_O2P_H_2;
	bvec[ipOH] -= bvec_OP_OH_O2P_H;
	
	
	c[ipOH][ipO2P] += OP_OH_O2P_H_1;
	c[ipOP][ipO2P] += OP_OH_O2P_H_2;
	bvec[ipO2P] += bvec_OP_OH_O2P_H;
	
	/* >>refer	molecule	O+	OH	=>	OH+	O	UMIST	*/
		
	
	c[ipOH][ipOP] -= OP_OH_OHP_O_1;
	c[ipOP][ipOP] -= OP_OH_OHP_O_2;
	bvec[ipOP] -= bvec_OP_OH_OHP_O;
	
	c[ipOH][ipOH] -= OP_OH_OHP_O_1;
	c[ipOP][ipOH] -= OP_OH_OHP_O_2;
	bvec[ipOH] -= bvec_OP_OH_OHP_O;
	
	c[ipOH][ipOHP] += OP_OH_OHP_O_1;
	c[ipOP][ipOHP] += OP_OH_OHP_O_2;
	bvec[ipOHP] += bvec_OP_OH_OHP_O;
	
	/* >>refer	molecule	Si	CH+	=>	Si+	CH	UMIST	*/
		
	
	c[ipCHP][ipCHP] -= Si_CHP_SiP_CH_1;
	c[ipATSI][ipCHP] -= Si_CHP_SiP_CH_2;
	bvec[ipCHP] -= bvec_Si_CHP_SiP_CH;
	
	c[ipCHP][ipCH] += Si_CHP_SiP_CH_1;
	c[ipATSI][ipCH] += Si_CHP_SiP_CH_2;
	bvec[ipCH] += bvec_Si_CHP_SiP_CH;
	
	c[ipCHP][ipSIP] += Si_CHP_SiP_CH_1;
	c[ipATSI][ipSIP] += Si_CHP_SiP_CH_2;
	bvec[ipSIP] += bvec_Si_CHP_SiP_CH;
	
	/* >>refer	molecule	Si	H2O+	=>	Si+	H2O	UMIST	*/
		
	
	c[ipH2OP][ipH2OP] -= Si_H2OP_SiP_H2O_1;
	c[ipATSI][ipH2OP] -= Si_H2OP_SiP_H2O_2;
	bvec[ipH2OP] -= bvec_Si_H2OP_SiP_H2O;
	
	c[ipH2OP][ipSIP] += Si_H2OP_SiP_H2O_1;
	c[ipATSI][ipSIP] += Si_H2OP_SiP_H2O_2;
	bvec[ipSIP] += bvec_Si_H2OP_SiP_H2O;

	c[ipH2OP][ipH2O] += Si_H2OP_SiP_H2O_1;
	c[ipATSI][ipH2O] += Si_H2OP_SiP_H2O_2;
	bvec[ipH2O] += bvec_Si_H2OP_SiP_H2O;
	
	/* >>refer	molecule	Si	OH	=>	SiO	H	UMIST	*/
		
	
	c[ipOH][ipOH] -= Si_OH_SiO_H_1;
	c[ipATSI][ipOH] -= Si_OH_SiO_H_2;
	bvec[ipOH] -= bvec_Si_OH_SiO_H;
	
	c[ipOH][ipSIO] += Si_OH_SiO_H_1;
	c[ipATSI][ipSIO] += Si_OH_SiO_H_2;
	bvec[ipSIO] += bvec_Si_OH_SiO_H;
	
	/* >>refer	molecule	Si	O2+	=>	O2	Si+	UMIST	*/
		
	
	c[ipO2P][ipO2P] -= Si_O2P_O2_SiP_1;
	c[ipATSI][ipO2P] -= Si_O2P_O2_SiP_2;
	bvec[ipO2P] -= bvec_Si_O2P_O2_SiP;
	
	c[ipO2P][ipO2] += Si_O2P_O2_SiP_1;
	c[ipATSI][ipO2] += Si_O2P_O2_SiP_2;
	bvec[ipO2] += bvec_Si_O2P_O2_SiP;
	
	c[ipO2P][ipSIP] += Si_O2P_O2_SiP_1;
	c[ipATSI][ipSIP] += Si_O2P_O2_SiP_2;
	bvec[ipSIP] += bvec_Si_O2P_O2_SiP;
	
	/* >>refer	molecule	Si+	H2O	=>	SiOH+	H	UMIST	*/
		
	
	c[ipH2O][ipSIP] -= SiP_H2O_SiOHP_H_1;
	c[ipSIP][ipSIP] -= SiP_H2O_SiOHP_H_2;
	bvec[ipSIP] -= bvec_SiP_H2O_SiOHP_H;
	
	c[ipH2O][ipH2O] -= SiP_H2O_SiOHP_H_1;
	c[ipSIP][ipH2O] -= SiP_H2O_SiOHP_H_2;
	bvec[ipH2O] -= bvec_SiP_H2O_SiOHP_H;
	
	c[ipH2O][ipHOSIP] += SiP_H2O_SiOHP_H_1;
	c[ipSIP][ipHOSIP] += SiP_H2O_SiOHP_H_2;
	bvec[ipHOSIP] += bvec_SiP_H2O_SiOHP_H;
	
	/* >>refer	molecule	Si+	OH	=>	SiO+	H	UMIST	*/
		
	
	c[ipOH][ipSIP] -= SiP_OH_SiOP_H_1;
	c[ipSIP][ipSIP] -= SiP_OH_SiOP_H_2;
	bvec[ipSIP] -= bvec_SiP_OH_SiOP_H;
	
	c[ipOH][ipOH] -= SiP_OH_SiOP_H_1;
	c[ipSIP][ipOH] -= SiP_OH_SiOP_H_2;
	bvec[ipOH] -= bvec_SiP_OH_SiOP_H;
	
	c[ipOH][ipSIOP] += SiP_OH_SiOP_H_1;
	c[ipSIP][ipSIOP] += SiP_OH_SiOP_H_2;
	bvec[ipSIOP] += bvec_SiP_OH_SiOP_H;
	
	/* >>refer	molecule	Si+	O2	=>	SiO+	O	UMIST	*/
		
	
	c[ipO2][ipSIP] -= SiP_O2_SiOP_O_1; 
	c[ipSIP][ipSIP] -= SiP_O2_SiOP_O_2;
	bvec[ipSIP] -= bvec_SiP_O2_SiOP_O;
	
	c[ipO2][ipO2] -= SiP_O2_SiOP_O_1; 
	c[ipSIP][ipO2] -= SiP_O2_SiOP_O_2;
	bvec[ipO2] -= bvec_SiP_O2_SiOP_O;
	
	c[ipO2][ipSIOP] += SiP_O2_SiOP_O_1; 
	c[ipSIP][ipSIOP] += SiP_O2_SiOP_O_2;
	bvec[ipSIOP] += bvec_SiP_O2_SiOP_O;
	
	/* >>refer	molecule	CH	CO+	=>	HCO+	C	UMIST	*/
		
	
	c[ipCOP][ipCH] -= CH_COP_HCOP_C_1; 
	c[ipCH][ipCH] -= CH_COP_HCOP_C_2;
	bvec[ipCH] -= bvec_CH_COP_HCOP_C;
	
	c[ipCOP][ipCOP] -= CH_COP_HCOP_C_1; 
	c[ipCH][ipCOP] -= CH_COP_HCOP_C_2;
	bvec[ipCOP] -= bvec_CH_COP_HCOP_C;
	
	c[ipCOP][ipHCOP] += CH_COP_HCOP_C_1; 
	c[ipCH][ipHCOP] += CH_COP_HCOP_C_2;
	bvec[ipHCOP] += bvec_CH_COP_HCOP_C;
	
	/* >>refer	molecule	CH	CO+	=>	CO	CH+	UMIST	*/
		
	
	c[ipCOP][ipCH] -= CH_COP_CO_CHP_1; 
	c[ipCH][ipCH] -= CH_COP_CO_CHP_2;
	bvec[ipCH] -= bvec_CH_COP_CO_CHP;
	
	c[ipCOP][ipCOP] -= CH_COP_CO_CHP_1; 
	c[ipCH][ipCOP] -= CH_COP_CO_CHP_2;
	bvec[ipCOP] -= bvec_CH_COP_CO_CHP;
	
	c[ipCOP][ipCO] += CH_COP_CO_CHP_1; 
	c[ipCH][ipCO] += CH_COP_CO_CHP_2;
	bvec[ipCO] += bvec_CH_COP_CO_CHP;
	
	c[ipCOP][ipCHP] += CH_COP_CO_CHP_1; 
	c[ipCH][ipCHP] += CH_COP_CO_CHP_2;
	bvec[ipCHP] += bvec_CH_COP_CO_CHP;
	
	/* >>refer	molecule	CH	H2O+	=>	H2O	CH+	UMIST	*/
		
	
	c[ipH2OP][ipCH] -= CH_H2OP_H2O_CHP_1; 
	c[ipCH][ipCH] -= CH_H2OP_H2O_CHP_2;
	bvec[ipCH] -= bvec_CH_H2OP_H2O_CHP;
	
	c[ipH2OP][ipH2OP] -= CH_H2OP_H2O_CHP_1; 
	c[ipCH][ipH2OP] -= CH_H2OP_H2O_CHP_2;
	bvec[ipH2OP] -= bvec_CH_H2OP_H2O_CHP;
	
	c[ipH2OP][ipH2O] += CH_H2OP_H2O_CHP_1; 
	c[ipCH][ipH2O] += CH_H2OP_H2O_CHP_2;
	bvec[ipH2O] += bvec_CH_H2OP_H2O_CHP;
	
	c[ipH2OP][ipCHP] += CH_H2OP_H2O_CHP_1; 
	c[ipCH][ipCHP] += CH_H2OP_H2O_CHP_2;
	bvec[ipCHP] += bvec_CH_H2OP_H2O_CHP;
	
	/* >>refer	molecule	CH	H2O+	=>	OH	CH2+	UMIST	*/
		
	
	c[ipH2OP][ipCH] -= CH_H2OP_OH_CH2P_1; 
	c[ipCH][ipCH] -= CH_H2OP_OH_CH2P_2;
	bvec[ipCH] -= bvec_CH_H2OP_OH_CH2P;
	
	c[ipH2OP][ipH2OP] -= CH_H2OP_OH_CH2P_1; 
	c[ipCH][ipH2OP] -= CH_H2OP_OH_CH2P_2;
	bvec[ipH2OP] -= bvec_CH_H2OP_OH_CH2P;
	
	c[ipH2OP][ipOH] += CH_H2OP_OH_CH2P_1; 
	c[ipCH][ipOH] += CH_H2OP_OH_CH2P_2;
	bvec[ipOH] += bvec_CH_H2OP_OH_CH2P;
	
	c[ipH2OP][ipCH2P] += CH_H2OP_OH_CH2P_1; 
	c[ipCH][ipCH2P] += CH_H2OP_OH_CH2P_2;
	bvec[ipCH2P] += bvec_CH_H2OP_OH_CH2P;
	
	
	/* >>refer	molecule	CH	H3O+	=>	H2O	CH2+	UMIST	*/
		
	c[ipH3OP][ipCH] -= CH_H3OP_H2O_CH2P_1; 
	c[ipCH][ipCH] -= CH_H3OP_H2O_CH2P_2;
	bvec[ipCH] -= bvec_CH_H3OP_H2O_CH2P;
	
	c[ipH3OP][ipH3OP] -= CH_H3OP_H2O_CH2P_1; 
	c[ipCH][ipH3OP] -= CH_H3OP_H2O_CH2P_2;
	bvec[ipH3OP] -= bvec_CH_H3OP_H2O_CH2P;
	
	c[ipH3OP][ipH2O] += CH_H3OP_H2O_CH2P_1; 
	c[ipCH][ipH2O] += CH_H3OP_H2O_CH2P_2;
	bvec[ipH2O] += bvec_CH_H3OP_H2O_CH2P;
	
	c[ipH3OP][ipCH2P] += CH_H3OP_H2O_CH2P_1; 
	c[ipCH][ipCH2P] += CH_H3OP_H2O_CH2P_2;
	bvec[ipCH2P] += bvec_CH_H3OP_H2O_CH2P;
	
	/* >>refer	molecule	CH	HCO+	=>	CO	CH2+	UMIST	*/
		
	
	c[ipHCOP][ipCH] -= CH_HCOP_CO_CH2P_1; 
	c[ipCH][ipCH] -= CH_HCOP_CO_CH2P_2;
	bvec[ipCH] -= bvec_CH_HCOP_CO_CH2P;
	
	c[ipHCOP][ipHCOP] -= CH_HCOP_CO_CH2P_1; 
	c[ipCH][ipHCOP] -= CH_HCOP_CO_CH2P_2;
	bvec[ipHCOP] -= bvec_CH_HCOP_CO_CH2P;
	
	c[ipHCOP][ipCO] += CH_HCOP_CO_CH2P_1; 
	c[ipCH][ipCO] += CH_HCOP_CO_CH2P_2;
	bvec[ipCO] += bvec_CH_HCOP_CO_CH2P;
	
	c[ipHCOP][ipCH2P] += CH_HCOP_CO_CH2P_1; 
	c[ipCH][ipCH2P] += CH_HCOP_CO_CH2P_2;
	bvec[ipCH2P] += bvec_CH_HCOP_CO_CH2P;
	
	/* >>refer	molecule	CH	O2	=>	CO	OH	UMIST	*/
		
	
	c[ipO2][ipCH] -= CH_O2_CO_OH_1; 
	c[ipCH][ipCH] -= CH_O2_CO_OH_2;
	bvec[ipCH] -= bvec_CH_O2_CO_OH;
	
	c[ipO2][ipO2] -= CH_O2_CO_OH_1; 
	c[ipCH][ipO2] -= CH_O2_CO_OH_2;
	bvec[ipO2] -= bvec_CH_O2_CO_OH;
	
	c[ipO2][ipCO] += CH_O2_CO_OH_1; 
	c[ipCH][ipCO] += CH_O2_CO_OH_2;
	bvec[ipCO] += bvec_CH_O2_CO_OH;
	
	c[ipO2][ipOH] += CH_O2_CO_OH_1; 
	c[ipCH][ipOH] += CH_O2_CO_OH_2;
	bvec[ipOH] += bvec_CH_O2_CO_OH;
	
	/* >>refer	molecule	CH	O2+	=>	O2	CH+	UMIST	*/
		
	
	c[ipO2P][ipCH] -= CH_O2P_O2_CHP_1; 
	c[ipCH][ipCH] -= CH_O2P_O2_CHP_2;
	bvec[ipCH] -= bvec_CH_O2P_O2_CHP;
	
	c[ipO2P][ipO2P] -= CH_O2P_O2_CHP_1; 
	c[ipCH][ipO2P] -= CH_O2P_O2_CHP_2;
	bvec[ipO2P] -= bvec_CH_O2P_O2_CHP;
	
	c[ipO2P][ipO2] += CH_O2P_O2_CHP_1; 
	c[ipCH][ipO2] += CH_O2P_O2_CHP_2;
	bvec[ipO2] += bvec_CH_O2P_O2_CHP;
	
	c[ipO2P][ipCHP] += CH_O2P_O2_CHP_1; 
	c[ipCH][ipCHP] += CH_O2P_O2_CHP_2;
	bvec[ipCHP] += bvec_CH_O2P_O2_CHP;
	
	/* >>refer	molecule	CH	O2+	=>	HCO+	O	UMIST	*/
		
	
	c[ipO2P][ipCH] -= CH_O2P_HCOP_O_1; 
	c[ipCH][ipCH] -= CH_O2P_HCOP_O_2;
	bvec[ipCH] -= bvec_CH_O2P_HCOP_O;
	
	c[ipO2P][ipO2P] -= CH_O2P_HCOP_O_1; 
	c[ipCH][ipO2P] -= CH_O2P_HCOP_O_2;
	bvec[ipO2P] -= bvec_CH_O2P_HCOP_O;
	
	c[ipO2P][ipHCOP] += CH_O2P_HCOP_O_1; 
	c[ipCH][ipHCOP] += CH_O2P_HCOP_O_2;
	bvec[ipHCOP] += bvec_CH_O2P_HCOP_O;
	
	/* >>refer	molecule	CH	OH+	=>	OH	CH+	UMIST	*/
		
	
	c[ipOHP][ipCH] -= CH_OHP_OH_CHP_1; 
	c[ipCH][ipCH] -= CH_OHP_OH_CHP_2;
	bvec[ipCH] -= bvec_CH_OHP_OH_CHP;
	
	c[ipOHP][ipOHP] -= CH_OHP_OH_CHP_1; 
	c[ipCH][ipOHP] -= CH_OHP_OH_CHP_2;
	bvec[ipOHP] -= bvec_CH_OHP_OH_CHP;
	
	c[ipOHP][ipOH] += CH_OHP_OH_CHP_1; 
	c[ipCH][ipOH] += CH_OHP_OH_CHP_2;
	bvec[ipOH] += bvec_CH_OHP_OH_CHP;
	
	c[ipOHP][ipCHP] += CH_OHP_OH_CHP_1; 
	c[ipCH][ipCHP] += CH_OHP_OH_CHP_2;
	bvec[ipCHP] += bvec_CH_OHP_OH_CHP;
	
	/* >>refer	molecule	CH	OH+	=>	O	CH2+	UMIST	*/
		
	
	c[ipOHP][ipCH] -= CH_OHP_O_CH2P_1; 
	c[ipCH][ipCH] -= CH_OHP_O_CH2P_2;
	bvec[ipCH] -= bvec_CH_OHP_O_CH2P;
	
	c[ipOHP][ipOHP] -= CH_OHP_O_CH2P_1; 
	c[ipCH][ipOHP] -= CH_OHP_O_CH2P_2;
	bvec[ipOHP] -= bvec_CH_OHP_O_CH2P;
	
	c[ipOHP][ipCH2P] += CH_OHP_O_CH2P_1; 
	c[ipCH][ipCH2P] += CH_OHP_O_CH2P_2;
	bvec[ipCH2P] += bvec_CH_OHP_O_CH2P;
	
	/* >>refer	molecule	CH	SiO+	=>	HCO+	Si	UMIST	*/
		
	
	c[ipSIOP][ipCH] -= CH_SiOP_HCOP_Si_1; 
	c[ipCH][ipCH] -= CH_SiOP_HCOP_Si_2;
	bvec[ipCH] -= bvec_CH_SiOP_HCOP_Si;
	
	c[ipSIOP][ipSIOP] -= CH_SiOP_HCOP_Si_1; 
	c[ipCH][ipSIOP] -= CH_SiOP_HCOP_Si_2;
	bvec[ipSIOP] -= bvec_CH_SiOP_HCOP_Si;
	
	c[ipSIOP][ipHCOP] += CH_SiOP_HCOP_Si_1; 
	c[ipCH][ipHCOP] += CH_SiOP_HCOP_Si_2;
	bvec[ipHCOP] += bvec_CH_SiOP_HCOP_Si;
	
	/* >>refer	molecule	CH+	H2O	=>	H3O+	C	UMIST	*/
		
	
	c[ipH2O][ipCHP] -= CHP_H2O_H3OP_C_1; 
	c[ipCHP][ipCHP] -= CHP_H2O_H3OP_C_2;
	bvec[ipCHP] -= bvec_CHP_H2O_H3OP_C;
	
	c[ipH2O][ipH2O] -= CHP_H2O_H3OP_C_1; 
	c[ipCHP][ipH2O] -= CHP_H2O_H3OP_C_2;
	bvec[ipH2O] -= bvec_CHP_H2O_H3OP_C;
	
	c[ipH2O][ipH3OP] += CHP_H2O_H3OP_C_1; 
	c[ipCHP][ipH3OP] += CHP_H2O_H3OP_C_2;
	bvec[ipH3OP] += bvec_CHP_H2O_H3OP_C;
	
	/* >>refer	molecule	CH+	H2O	=>	HCO+	H2	UMIST	*/
		
	
	c[ipH2O][ipCHP] -= CHP_H2O_HCOP_H2_1; 
	c[ipCHP][ipCHP] -= CHP_H2O_HCOP_H2_2;
	bvec[ipCHP] -= bvec_CHP_H2O_HCOP_H2;
	
	c[ipH2O][ipH2O] -= CHP_H2O_HCOP_H2_1; 
	c[ipCHP][ipH2O] -= CHP_H2O_HCOP_H2_2;
	bvec[ipH2O] -= bvec_CHP_H2O_HCOP_H2;
	
	c[ipH2O][ipHCOP] += CHP_H2O_HCOP_H2_1; 
	c[ipCHP][ipHCOP] += CHP_H2O_HCOP_H2_2;
	bvec[ipHCOP] += bvec_CHP_H2O_HCOP_H2;
	
	/* >>refer	molecule	CH+	O2	=>	HCO+	O	UMIST	*/
		
	
	c[ipO2][ipCHP] -= CHP_O2_HCOP_O_1; 
	c[ipCHP][ipCHP] -= CHP_O2_HCOP_O_2;
	bvec[ipCHP] -= bvec_CHP_O2_HCOP_O;
	
	c[ipO2][ipO2] -= CHP_O2_HCOP_O_1; 
	c[ipCHP][ipO2] -= CHP_O2_HCOP_O_2;
	bvec[ipO2] -= bvec_CHP_O2_HCOP_O;
	
	c[ipO2][ipHCOP] += CHP_O2_HCOP_O_1; 
	c[ipCHP][ipHCOP] += CHP_O2_HCOP_O_2;
	bvec[ipHCOP] += bvec_CHP_O2_HCOP_O;


	/* >>refer	molecule	CH+	OH	=>	CO+	H2	UMIST	*/
		
	
	c[ipOH][ipCHP] -= CHP_OH_COP_H2_1; 
	c[ipCHP][ipCHP] -= CHP_OH_COP_H2_2;
	bvec[ipCHP] -= bvec_CHP_OH_COP_H2;
	
	c[ipOH][ipOH] -= CHP_OH_COP_H2_1; 
	c[ipCHP][ipOH] -= CHP_OH_COP_H2_2;
	bvec[ipOH] -= bvec_CHP_OH_COP_H2;
	
	c[ipOH][ipCOP] += CHP_OH_COP_H2_1; 
	c[ipCHP][ipCOP] += CHP_OH_COP_H2_2;
	bvec[ipCOP] += bvec_CHP_OH_COP_H2;

	
	/* >>refer	molecule	CH+	O2	=>	CO+	OH	UMIST	*/
		
	
	c[ipO2][ipCHP] -= CHP_O2_COP_OH_1; 
	c[ipCHP][ipCHP] -= CHP_O2_COP_OH_2;
	bvec[ipCHP] -= bvec_CHP_O2_COP_OH;
	
	c[ipO2][ipO2] -= CHP_O2_COP_OH_1; 
	c[ipCHP][ipO2] -= CHP_O2_COP_OH_2;
	bvec[ipO2] -= bvec_CHP_O2_COP_OH;
	
	c[ipO2][ipCOP] += CHP_O2_COP_OH_1; 
	c[ipCHP][ipCOP] += CHP_O2_COP_OH_2;
	bvec[ipCOP] += bvec_CHP_O2_COP_OH;
	
	c[ipO2][ipOH] += CHP_O2_COP_OH_1; 
	c[ipCHP][ipOH] += CHP_O2_COP_OH_2;
	bvec[ipOH] += bvec_CHP_O2_COP_OH;
	
	/* >>refer	molecule	CH2	CO+	=>	HCO+	CH	UMIST	*/
		
	
	c[ipCOP][ipCH2] -= CH2_COP_HCOP_CH_1; 
	c[ipCH2][ipCH2] -= CH2_COP_HCOP_CH_2;
	bvec[ipCH2] -= bvec_CH2_COP_HCOP_CH;
	
	c[ipCOP][ipCOP] -= CH2_COP_HCOP_CH_1; 
	c[ipCH2][ipCOP] -= CH2_COP_HCOP_CH_2;
	bvec[ipCOP] -= bvec_CH2_COP_HCOP_CH;
	
	c[ipCOP][ipHCOP] += CH2_COP_HCOP_CH_1; 
	c[ipCH2][ipHCOP] += CH2_COP_HCOP_CH_2;
	bvec[ipHCOP] += bvec_CH2_COP_HCOP_CH;
	
	c[ipCOP][ipCH] += CH2_COP_HCOP_CH_1; 
	c[ipCH2][ipCH] += CH2_COP_HCOP_CH_2;
	bvec[ipCH] += bvec_CH2_COP_HCOP_CH;
	
	/* >>refer	molecule	CH2	CO+	=>	CO	CH2+	UMIST	*/
		
	
	c[ipCOP][ipCH2] -= CH2_COP_CO_CH2P_1; 
	c[ipCH2][ipCH2] -= CH2_COP_CO_CH2P_2;
	bvec[ipCH2] -= bvec_CH2_COP_CO_CH2P;
	
	c[ipCOP][ipCOP] -= CH2_COP_CO_CH2P_1; 
	c[ipCH2][ipCOP] -= CH2_COP_CO_CH2P_2;
	bvec[ipCOP] -= bvec_CH2_COP_CO_CH2P;
	
	c[ipCOP][ipCO] += CH2_COP_CO_CH2P_1; 
	c[ipCH2][ipCO] += CH2_COP_CO_CH2P_2;
	bvec[ipCO] += bvec_CH2_COP_CO_CH2P;
	
	c[ipCOP][ipCH2P] += CH2_COP_CO_CH2P_1; 
	c[ipCH2][ipCH2P] += CH2_COP_CO_CH2P_2;
	bvec[ipCH2P] += bvec_CH2_COP_CO_CH2P;

	/* >>refer	molecule	CH2	H2O+	=>	H2O	CH2+	UMIST	*/
		
	
	c[ipH2OP][ipCH2] -= CH2_H2OP_H2O_CH2P_1; 
	c[ipCH2][ipCH2] -= CH2_H2OP_H2O_CH2P_2;
	bvec[ipCH2] -= bvec_CH2_H2OP_H2O_CH2P;
	
	c[ipH2OP][ipH2OP] -= CH2_H2OP_H2O_CH2P_1; 
	c[ipCH2][ipH2OP] -= CH2_H2OP_H2O_CH2P_2;
	bvec[ipH2OP] -= bvec_CH2_H2OP_H2O_CH2P;
	
	c[ipH2OP][ipH2O] += CH2_H2OP_H2O_CH2P_1; 
	c[ipCH2][ipH2O] += CH2_H2OP_H2O_CH2P_2;
	bvec[ipH2O] += bvec_CH2_H2OP_H2O_CH2P;
	
	c[ipH2OP][ipCH2P] += CH2_H2OP_H2O_CH2P_1; 
	c[ipCH2][ipCH2P] += CH2_H2OP_H2O_CH2P_2;
	bvec[ipCH2P] += bvec_CH2_H2OP_H2O_CH2P;
	
	/* >>refer	molecule	CH2	H2O+	=>	OH	CH3+	UMIST	*/
		
	
	c[ipH2OP][ipCH2] -= CH2_H2OP_OH_CH3P_1; 
	c[ipCH2][ipCH2] -= CH2_H2OP_OH_CH3P_2;
	bvec[ipCH2] -= bvec_CH2_H2OP_OH_CH3P;
	
	c[ipH2OP][ipH2OP] -= CH2_H2OP_OH_CH3P_1; 
	c[ipCH2][ipH2OP] -= CH2_H2OP_OH_CH3P_2;
	bvec[ipH2OP] -= bvec_CH2_H2OP_OH_CH3P;
	
	c[ipH2OP][ipOH] += CH2_H2OP_OH_CH3P_1; 
	c[ipCH2][ipOH] += CH2_H2OP_OH_CH3P_2;
	bvec[ipOH] += bvec_CH2_H2OP_OH_CH3P;
	
	c[ipH2OP][ipCH3P] += CH2_H2OP_OH_CH3P_1; 
	c[ipCH2][ipCH3P] += CH2_H2OP_OH_CH3P_2;
	bvec[ipCH3P] += bvec_CH2_H2OP_OH_CH3P;
	
	/* >>refer	molecule	CH2	H3O+	=>	H2O	CH3+	UMIST	*/
		
	
	c[ipH3OP][ipCH2] -= CH2_H3OP_H2O_CH3P_1; 
	c[ipCH2][ipCH2] -= CH2_H3OP_H2O_CH3P_2;
	bvec[ipCH2] -= bvec_CH2_H3OP_H2O_CH3P;
	
	c[ipH3OP][ipH3OP] -= CH2_H3OP_H2O_CH3P_1; 
	c[ipCH2][ipH3OP] -= CH2_H3OP_H2O_CH3P_2;
	bvec[ipH3OP] -= bvec_CH2_H3OP_H2O_CH3P;
	
	c[ipH3OP][ipH2O] += CH2_H3OP_H2O_CH3P_1; 
	c[ipCH2][ipH2O] += CH2_H3OP_H2O_CH3P_2;
	bvec[ipH2O] += bvec_CH2_H3OP_H2O_CH3P;
	
	c[ipH3OP][ipCH3P] += CH2_H3OP_H2O_CH3P_1; 
	c[ipCH2][ipCH3P] += CH2_H3OP_H2O_CH3P_2;
	bvec[ipCH3P] += bvec_CH2_H3OP_H2O_CH3P;
	
	/* >>refer	molecule	CH2	HCO+	=>	CO	CH3+	UMIST	*/
		
	
	c[ipHCOP][ipCH2] -= CH2_HCOP_CO_CH3P_1; 
	c[ipCH2][ipCH2] -= CH2_HCOP_CO_CH3P_2;
	bvec[ipCH2] -= bvec_CH2_HCOP_CO_CH3P;
	
	c[ipHCOP][ipHCOP] -= CH2_HCOP_CO_CH3P_1; 
	c[ipCH2][ipHCOP] -= CH2_HCOP_CO_CH3P_2;
	bvec[ipHCOP] -= bvec_CH2_HCOP_CO_CH3P;
	
	c[ipHCOP][ipCO] += CH2_HCOP_CO_CH3P_1; 
	c[ipCH2][ipCO] += CH2_HCOP_CO_CH3P_2;
	bvec[ipCO] += bvec_CH2_HCOP_CO_CH3P;
	
	c[ipHCOP][ipCH3P] += CH2_HCOP_CO_CH3P_1; 
	c[ipCH2][ipCH3P] += CH2_HCOP_CO_CH3P_2;
	bvec[ipCH3P] += bvec_CH2_HCOP_CO_CH3P;
	
	/* >>refer	molecule	CH2	O2	=>	CO	H2O	UMIST	*/
		
	
	c[ipO2][ipCH2] -= CH2_O2_CO_H2O_1; 
	c[ipCH2][ipCH2] -= CH2_O2_CO_H2O_2;
	bvec[ipCH2] -= bvec_CH2_O2_CO_H2O;
	
	c[ipO2][ipO2] -= CH2_O2_CO_H2O_1; 
	c[ipCH2][ipO2] -= CH2_O2_CO_H2O_2;
	bvec[ipO2] -= bvec_CH2_O2_CO_H2O;
	
	c[ipO2][ipCO] += CH2_O2_CO_H2O_1; 
	c[ipCH2][ipCO] += CH2_O2_CO_H2O_2;
	bvec[ipCO] += bvec_CH2_O2_CO_H2O;
	
	c[ipO2][ipH2O] += CH2_O2_CO_H2O_1; 
	c[ipCH2][ipH2O] += CH2_O2_CO_H2O_2;
	bvec[ipH2O] += bvec_CH2_O2_CO_H2O;
	
	/* >>refer	molecule	CH2	O2+	=>	O2	CH2+	UMIST	*/
		
	
	c[ipO2P][ipCH2] -= CH2_O2P_O2_CH2P_1; 
	c[ipCH2][ipCH2] -= CH2_O2P_O2_CH2P_2;
	bvec[ipCH2] -= bvec_CH2_O2P_O2_CH2P;
	
	c[ipO2P][ipO2P] -= CH2_O2P_O2_CH2P_1; 
	c[ipCH2][ipO2P] -= CH2_O2P_O2_CH2P_2;
	bvec[ipO2P] -= bvec_CH2_O2P_O2_CH2P;
	
	c[ipO2P][ipO2] += CH2_O2P_O2_CH2P_1; 
	c[ipCH2][ipO2] += CH2_O2P_O2_CH2P_2;
	bvec[ipO2] += bvec_CH2_O2P_O2_CH2P;
	
	c[ipO2P][ipCH2P] += CH2_O2P_O2_CH2P_1; 
	c[ipCH2][ipCH2P] += CH2_O2P_O2_CH2P_2;
	bvec[ipCH2P] += bvec_CH2_O2P_O2_CH2P;
	
	/* >>refer	molecule	CH2	OH	=>	H2O	CH	UMIST	*/
		
	
	c[ipOH][ipCH2] -= CH2_OH_H2O_CH_1; 
	c[ipCH2][ipCH2] -= CH2_OH_H2O_CH_2;
	bvec[ipCH2] -= bvec_CH2_OH_H2O_CH;
	
	
	c[ipOH][ipOH] -= CH2_OH_H2O_CH_1; 
	c[ipCH2][ipOH] -= CH2_OH_H2O_CH_2;
	bvec[ipOH] -= bvec_CH2_OH_H2O_CH;
	
	
	c[ipOH][ipH2O] += CH2_OH_H2O_CH_1; 
	c[ipCH2][ipH2O] += CH2_OH_H2O_CH_2;
	bvec[ipH2O] += bvec_CH2_OH_H2O_CH;
	
	
	c[ipOH][ipCH] += CH2_OH_H2O_CH_1; 
	c[ipCH2][ipCH] += CH2_OH_H2O_CH_2;
	bvec[ipCH] += bvec_CH2_OH_H2O_CH;
	
	
	/* >>refer	molecule	CH2	OH+	=>	OH	CH2+	UMIST	*/
		
	c[ipOHP][ipCH2] -= CH2_OHP_OH_CH2P_1; 
	c[ipCH2][ipCH2] -= CH2_OHP_OH_CH2P_2;
	bvec[ipCH2] -= bvec_CH2_OHP_OH_CH2P;
	
	c[ipOHP][ipOHP] -= CH2_OHP_OH_CH2P_1; 
	c[ipCH2][ipOHP] -= CH2_OHP_OH_CH2P_2;
	bvec[ipOHP] -= bvec_CH2_OHP_OH_CH2P;
	
	c[ipOHP][ipOH] += CH2_OHP_OH_CH2P_1; 
	c[ipCH2][ipOH] += CH2_OHP_OH_CH2P_2;
	bvec[ipOH] += bvec_CH2_OHP_OH_CH2P;
	
	c[ipOHP][ipCH2P] += CH2_OHP_OH_CH2P_1; 
	c[ipCH2][ipCH2P] += CH2_OHP_OH_CH2P_2;
	bvec[ipCH2P] += bvec_CH2_OHP_OH_CH2P;
	
	/* >>refer	molecule	CH2	OH+	=>	O	CH3+	UMIST	*/
		
	
	c[ipOHP][ipCH2] -= CH2_OHP_O_CH3P_1; 
	c[ipCH2][ipCH2] -= CH2_OHP_O_CH3P_2;
	bvec[ipCH2] -= bvec_CH2_OHP_O_CH3P;
	
	c[ipOHP][ipOHP] -= CH2_OHP_O_CH3P_1; 
	c[ipCH2][ipOHP] -= CH2_OHP_O_CH3P_2;
	bvec[ipOHP] -= bvec_CH2_OHP_O_CH3P;
	
	c[ipOHP][ipCH3P] += CH2_OHP_O_CH3P_1; 
	c[ipCH2][ipCH3P] += CH2_OHP_O_CH3P_2;
	bvec[ipCH3P] += bvec_CH2_OHP_O_CH3P;
	
	/* >>refer	molecule	CH2+	O2+	=>	HCO+	OH	UMIST	*/
		
	c[ipO2P][ipCH2P] -= CH2P_O2_HCOP_OH_1; 
	c[ipCH2P][ipCH2P] -= CH2P_O2_HCOP_OH_2;
	bvec[ipCH2P] -= bvec_CH2P_O2_HCOP_OH;
	
	c[ipO2P][ipO2P] -= CH2P_O2_HCOP_OH_1; 
	c[ipCH2P][ipO2P] -= CH2P_O2_HCOP_OH_2;
	bvec[ipO2P] -= bvec_CH2P_O2_HCOP_OH;
	
	c[ipO2P][ipHCOP] += CH2P_O2_HCOP_OH_1; 
	c[ipCH2P][ipHCOP] += CH2P_O2_HCOP_OH_2;
	bvec[ipHCOP] += bvec_CH2P_O2_HCOP_OH;
	
	c[ipO2P][ipOH] += CH2P_O2_HCOP_OH_1; 
	c[ipCH2P][ipOH] += CH2P_O2_HCOP_OH_2;
	bvec[ipOH] += bvec_CH2P_O2_HCOP_OH;
	
	/* >>refer	molecule	CO+	O2	=>	O2+	CO	UMIST	*/
		
	
	c[ipO2][ipCOP] -= COP_O2_O2P_CO_1; 
	c[ipCOP][ipCOP] -= COP_O2_O2P_CO_2;
	bvec[ipCOP] -= bvec_COP_O2_O2P_CO;
	
	c[ipO2][ipO2] -= COP_O2_O2P_CO_1; 
	c[ipCOP][ipO2] -= COP_O2_O2P_CO_2;
	bvec[ipO2] -= bvec_COP_O2_O2P_CO;
	
	c[ipO2][ipO2P] += COP_O2_O2P_CO_1; 
	c[ipCOP][ipO2P] += COP_O2_O2P_CO_2;
	bvec[ipO2P] += bvec_COP_O2_O2P_CO;
	
	c[ipO2][ipCO] += COP_O2_O2P_CO_1; 
	c[ipCOP][ipCO] += COP_O2_O2P_CO_2;
	bvec[ipCO] += bvec_COP_O2_O2P_CO;
	
	/* >>refer	molecule	H2O	CO+	=>	CO	H2O+	UMIST	*/
		
	c[ipCOP][ipH2O] -= H2O_COP_CO_H2OP_1; 
	c[ipH2O][ipH2O] -= H2O_COP_CO_H2OP_2;
	bvec[ipH2O] -= bvec_H2O_COP_CO_H2OP;
	
	c[ipCOP][ipCOP] -= H2O_COP_CO_H2OP_1; 
	c[ipH2O][ipCOP] -= H2O_COP_CO_H2OP_2;
	bvec[ipCOP] -= bvec_H2O_COP_CO_H2OP;
	
	c[ipCOP][ipCO] += H2O_COP_CO_H2OP_1; 
	c[ipH2O][ipCO] += H2O_COP_CO_H2OP_2;
	bvec[ipCO] += bvec_H2O_COP_CO_H2OP;
	
	c[ipCOP][ipH2OP] += H2O_COP_CO_H2OP_1; 
	c[ipH2O][ipH2OP] += H2O_COP_CO_H2OP_2;
	bvec[ipH2OP] += bvec_H2O_COP_CO_H2OP;
	
	/* >>refer	molecule	H2O	CO+	=>	HCO+	OH	UMIST	*/
		
	
	c[ipCOP][ipH2O] -= H2O_COP_HCOP_OH_1; 
	c[ipH2O][ipH2O] -= H2O_COP_HCOP_OH_2;
	bvec[ipH2O] -= bvec_H2O_COP_HCOP_OH;
	
	c[ipCOP][ipCOP] -= H2O_COP_HCOP_OH_1; 
	c[ipH2O][ipCOP] -= H2O_COP_HCOP_OH_2;
	bvec[ipCOP] -= bvec_H2O_COP_HCOP_OH;
	
	c[ipCOP][ipHCOP] += H2O_COP_HCOP_OH_1; 
	c[ipH2O][ipHCOP] += H2O_COP_HCOP_OH_2;
	bvec[ipHCOP] += bvec_H2O_COP_HCOP_OH;
	
	c[ipCOP][ipOH] += H2O_COP_HCOP_OH_1; 
	c[ipH2O][ipOH] += H2O_COP_HCOP_OH_2;
	bvec[ipOH] += bvec_H2O_COP_HCOP_OH;
	
	/* >>refer	molecule	H2O	HCO+	=>	CO	H3O+	UMIST	*/
		
	
	c[ipHCOP][ipH2O] -= H2O_HCOP_CO_H3OP_1; 
	c[ipH2O][ipH2O] -= H2O_HCOP_CO_H3OP_2;
	bvec[ipH2O] -= bvec_H2O_HCOP_CO_H3OP;
	
	c[ipHCOP][ipHCOP] -= H2O_HCOP_CO_H3OP_1; 
	c[ipH2O][ipHCOP] -= H2O_HCOP_CO_H3OP_2;
	bvec[ipHCOP] -= bvec_H2O_HCOP_CO_H3OP;
	
	c[ipHCOP][ipCO] += H2O_HCOP_CO_H3OP_1; 
	c[ipH2O][ipCO] += H2O_HCOP_CO_H3OP_2;
	bvec[ipCO] += bvec_H2O_HCOP_CO_H3OP;
	
	c[ipHCOP][ipH3OP] += H2O_HCOP_CO_H3OP_1; 
	c[ipH2O][ipH3OP] += H2O_HCOP_CO_H3OP_2;
	bvec[ipH3OP] += bvec_H2O_HCOP_CO_H3OP;
	
	
	/* >>refer	molecule	H2O+	CO	=>	HCO+	OH	UMIST	*/
		
	c[ipCO][ipH2OP] -= H2OP_CO_HCOP_OH_1; 
	c[ipH2OP][ipH2OP] -= H2OP_CO_HCOP_OH_2;
	bvec[ipH2OP] -= bvec_H2OP_CO_HCOP_OH;
	
	c[ipCO][ipCO] -= H2OP_CO_HCOP_OH_1; 
	c[ipH2OP][ipCO] -= H2OP_CO_HCOP_OH_2;
	bvec[ipCO] -= bvec_H2OP_CO_HCOP_OH;
	
	c[ipCO][ipHCOP] += H2OP_CO_HCOP_OH_1; 
	c[ipH2OP][ipHCOP] += H2OP_CO_HCOP_OH_2;
	bvec[ipHCOP] += bvec_H2OP_CO_HCOP_OH;
	
	c[ipCO][ipOH] += H2OP_CO_HCOP_OH_1; 
	c[ipH2OP][ipOH] += H2OP_CO_HCOP_OH_2;
	bvec[ipOH] += bvec_H2OP_CO_HCOP_OH;
	
	
	/* >>refer	molecule	H2O+	H2O	=>	H3O+	OH	UMIST	*/
		
	c[ipH2O][ipH2OP] -= H2OP_H2O_H3OP_OH_1; 
	c[ipH2OP][ipH2OP] -= H2OP_H2O_H3OP_OH_2;
	bvec[ipH2OP] -= bvec_H2OP_H2O_H3OP_OH;
	
	c[ipH2O][ipH2O] -= H2OP_H2O_H3OP_OH_1; 
	c[ipH2OP][ipH2O] -= H2OP_H2O_H3OP_OH_2;
	bvec[ipH2O] -= bvec_H2OP_H2O_H3OP_OH;
	
	c[ipH2O][ipH3OP] += H2OP_H2O_H3OP_OH_1; 
	c[ipH2OP][ipH3OP] += H2OP_H2O_H3OP_OH_2;
	bvec[ipH3OP] += bvec_H2OP_H2O_H3OP_OH;
	
	c[ipH2O][ipOH] += H2OP_H2O_H3OP_OH_1; 
	c[ipH2OP][ipOH] += H2OP_H2O_H3OP_OH_2;
	bvec[ipOH] += bvec_H2OP_H2O_H3OP_OH;
	
	/* >>refer	molecule	H2O+	O2	=>	O2+	H2O	UMIST	*/
		
	
	c[ipO2][ipH2OP] -= H2OP_O2_O2P_H2O_1; 
	c[ipH2OP][ipH2OP] -= H2OP_O2_O2P_H2O_2;
	bvec[ipH2OP] -= bvec_H2OP_O2_O2P_H2O;
	
	c[ipO2][ipO2] -= H2OP_O2_O2P_H2O_1; 
	c[ipH2OP][ipO2] -= H2OP_O2_O2P_H2O_2;
	bvec[ipO2] -= bvec_H2OP_O2_O2P_H2O;
	
	c[ipO2][ipO2P] += H2OP_O2_O2P_H2O_1; 
	c[ipH2OP][ipO2P] += H2OP_O2_O2P_H2O_2;
	bvec[ipO2P] += bvec_H2OP_O2_O2P_H2O;
	
	c[ipO2][ipH2O] += H2OP_O2_O2P_H2O_1; 
	c[ipH2OP][ipH2O] += H2OP_O2_O2P_H2O_2;
	bvec[ipH2O] += bvec_H2OP_O2_O2P_H2O;
	
	/* >>refer	molecule	H3O+	SiH	=>	SiH2+	H2O	UMIST	*/
		
	
	c[ipSIH][ipH3OP] -= H3OP_SiH_SiH2P_H2O_1; 
	c[ipH3OP][ipH3OP] -= H3OP_SiH_SiH2P_H2O_2;
	bvec[ipH3OP] -= bvec_H3OP_SiH_SiH2P_H2O;
	
	c[ipSIH][ipSIH] -= H3OP_SiH_SiH2P_H2O_1; 
	c[ipH3OP][ipSIH] -= H3OP_SiH_SiH2P_H2O_2;
	bvec[ipSIH] -= bvec_H3OP_SiH_SiH2P_H2O;
	
	c[ipSIH][ipSIH2P] += H3OP_SiH_SiH2P_H2O_1; 
	c[ipH3OP][ipSIH2P] += H3OP_SiH_SiH2P_H2O_2;
	bvec[ipSIH2P] += bvec_H3OP_SiH_SiH2P_H2O;
	
	c[ipSIH][ipH2O] += H3OP_SiH_SiH2P_H2O_1; 
	c[ipH3OP][ipH2O] += H3OP_SiH_SiH2P_H2O_2;
	bvec[ipH2O] += bvec_H3OP_SiH_SiH2P_H2O;
	
	/* >>refer	molecule	H3O+	SiO	=>	SiOH+	H2O	UMIST	*/
		
	
	c[ipSIO][ipH3OP] -= H3OP_SiO_SiOHP_H2O_1; 
	c[ipH3OP][ipH3OP] -= H3OP_SiO_SiOHP_H2O_2;
	bvec[ipH3OP] -= bvec_H3OP_SiO_SiOHP_H2O;
	
	c[ipSIO][ipSIO] -= H3OP_SiO_SiOHP_H2O_1; 
	c[ipH3OP][ipSIO] -= H3OP_SiO_SiOHP_H2O_2;
	bvec[ipSIO] -= bvec_H3OP_SiO_SiOHP_H2O;
	
	c[ipSIO][ipHOSIP] += H3OP_SiO_SiOHP_H2O_1; 
	c[ipH3OP][ipHOSIP] += H3OP_SiO_SiOHP_H2O_2;
	bvec[ipHOSIP] += bvec_H3OP_SiO_SiOHP_H2O;
	
	c[ipSIO][ipH2O] += H3OP_SiO_SiOHP_H2O_1; 
	c[ipH3OP][ipH2O] += H3OP_SiO_SiOHP_H2O_2;
	bvec[ipH2O] += bvec_H3OP_SiO_SiOHP_H2O;
	
	/* >>refer	molecule	HCO+	SiH	=>	SiH2+	CO	UMIST	*/
		
	
	c[ipSIH][ipHCOP] -= HCOP_SiH_SiH2P_CO_1; 
	c[ipHCOP][ipHCOP] -= HCOP_SiH_SiH2P_CO_2;
	bvec[ipHCOP] -= bvec_HCOP_SiH_SiH2P_CO;
	
	c[ipSIH][ipSIH] -= HCOP_SiH_SiH2P_CO_1; 
	c[ipHCOP][ipSIH] -= HCOP_SiH_SiH2P_CO_2;
	bvec[ipSIH] -= bvec_HCOP_SiH_SiH2P_CO;
	
	c[ipSIH][ipSIH2P] += HCOP_SiH_SiH2P_CO_1; 
	c[ipHCOP][ipSIH2P] += HCOP_SiH_SiH2P_CO_2;
	bvec[ipSIH2P] += bvec_HCOP_SiH_SiH2P_CO;
	
	c[ipSIH][ipCO] += HCOP_SiH_SiH2P_CO_1; 
	c[ipHCOP][ipCO] += HCOP_SiH_SiH2P_CO_2;
	bvec[ipCO] += bvec_HCOP_SiH_SiH2P_CO;
	
	/* >>refer	molecule	HCO+	SiO	=>	SiOH+	CO	UMIST	*/
		
	
	c[ipSIO][ipHCOP] -= HCOP_SiO_SiOHP_CO_1; 
	c[ipHCOP][ipHCOP] -= HCOP_SiO_SiOHP_CO_2;
	bvec[ipHCOP] -= bvec_HCOP_SiO_SiOHP_CO;
	
	c[ipSIO][ipSIO] -= HCOP_SiO_SiOHP_CO_1; 
	c[ipHCOP][ipSIO] -= HCOP_SiO_SiOHP_CO_2;
	bvec[ipSIO] -= bvec_HCOP_SiO_SiOHP_CO;
	
	c[ipSIO][ipHOSIP] += HCOP_SiO_SiOHP_CO_1; 
	c[ipHCOP][ipHOSIP] += HCOP_SiO_SiOHP_CO_2;
	bvec[ipHOSIP] += bvec_HCOP_SiO_SiOHP_CO;
	
	c[ipSIO][ipCO] += HCOP_SiO_SiOHP_CO_1; 
	c[ipHCOP][ipCO] += HCOP_SiO_SiOHP_CO_2;
	bvec[ipCO] += bvec_HCOP_SiO_SiOHP_CO;
	
	/* >>refer	molecule	OH	CO+	=>	HCO+	O	UMIST	*/
		
	
	c[ipCOP][ipOH] -= OH_COP_HCOP_O_1; 
	c[ipOH][ipOH] -= OH_COP_HCOP_O_2;
	bvec[ipOH] -= bvec_OH_COP_HCOP_O;
	
	c[ipCOP][ipCOP] -= OH_COP_HCOP_O_1; 
	c[ipOH][ipCOP] -= OH_COP_HCOP_O_2;
	bvec[ipCOP] -= bvec_OH_COP_HCOP_O;
	
	c[ipCOP][ipHCOP] += OH_COP_HCOP_O_1; 
	c[ipOH][ipHCOP] += OH_COP_HCOP_O_2;
	bvec[ipHCOP] += bvec_OH_COP_HCOP_O;
	
	/* >>refer	molecule	OH	CO+	=>	CO	OH+	UMIST	*/
		
	
	c[ipCOP][ipOH] -= OH_COP_CO_OHP_1; 
	c[ipOH][ipOH] -= OH_COP_CO_OHP_2;
	bvec[ipOH] -= bvec_OH_COP_CO_OHP;
	
	c[ipCOP][ipCOP] -= OH_COP_CO_OHP_1; 
	c[ipOH][ipCOP] -= OH_COP_CO_OHP_2;
	bvec[ipCOP] -= bvec_OH_COP_CO_OHP;
	
	c[ipCOP][ipCO] += OH_COP_CO_OHP_1; 
	c[ipOH][ipCO] += OH_COP_CO_OHP_2;
	bvec[ipCO] += bvec_OH_COP_CO_OHP;
	
	c[ipCOP][ipOHP] += OH_COP_CO_OHP_1; 
	c[ipOH][ipOHP] += OH_COP_CO_OHP_2;
	bvec[ipOHP] += bvec_OH_COP_CO_OHP;
	
	/* >>refer	molecule	OH	H2O+	=>	H3O+	O	UMIST	*/
		
	
	c[ipH2OP][ipOH] -= OH_H2OP_H3OP_O_1; 
	c[ipOH][ipOH] -= OH_H2OP_H3OP_O_2;
	bvec[ipOH] -= bvec_OH_H2OP_H3OP_O;
	
	c[ipH2OP][ipH2OP] -= OH_H2OP_H3OP_O_1; 
	c[ipOH][ipH2OP] -= OH_H2OP_H3OP_O_2;
	bvec[ipH2OP] -= bvec_OH_H2OP_H3OP_O;
	
	c[ipH2OP][ipH3OP] += OH_H2OP_H3OP_O_1; 
	c[ipOH][ipH3OP] += OH_H2OP_H3OP_O_2;
	bvec[ipH3OP] += bvec_OH_H2OP_H3OP_O;
	
	/* >>refer	molecule	OH	HCO+	=>	CO	H2O+	UMIST	*/
		
	
	c[ipHCOP][ipOH] -= OH_HCOP_CO_H2OP_1; 
	c[ipOH][ipOH] -= OH_HCOP_CO_H2OP_2;
	bvec[ipOH] -= bvec_OH_HCOP_CO_H2OP;
	
	c[ipHCOP][ipHCOP] -= OH_HCOP_CO_H2OP_1; 
	c[ipOH][ipHCOP] -= OH_HCOP_CO_H2OP_2;
	bvec[ipHCOP] -= bvec_OH_HCOP_CO_H2OP;
	
	c[ipHCOP][ipCO] += OH_HCOP_CO_H2OP_1; 
	c[ipOH][ipCO] += OH_HCOP_CO_H2OP_2;
	bvec[ipCO] += bvec_OH_HCOP_CO_H2OP;
	
	c[ipHCOP][ipH2OP] += OH_HCOP_CO_H2OP_1; 
	c[ipOH][ipH2OP] += OH_HCOP_CO_H2OP_2;
	bvec[ipH2OP] += bvec_OH_HCOP_CO_H2OP;
	
	/* >>refer	molecule	OH	OH	=>	H2O	H	UMIST	*/
		
	
	c[ipOH][ipOH] -= OH_OH_H2O_O_1; 
	c[ipOH][ipOH] -= OH_OH_H2O_O_2;
	bvec[ipOH] -= bvec_OH_OH_H2O_O;
	
	c[ipOH][ipH2O] += 0.5*OH_OH_H2O_O_1; 
	c[ipOH][ipH2O] += 0.5*OH_OH_H2O_O_2;
	bvec[ipH2O] += 0.5*bvec_OH_OH_H2O_O;
	
	/* >>refer	molecule	OH+	CO	=>	HCO+	O	UMIST	*/
		
	
	c[ipCO][ipOHP] -= OHP_CO_HCOP_O_1; 
	c[ipOHP][ipOHP] -= OHP_CO_HCOP_O_2;
	bvec[ipOHP] -= bvec_OHP_CO_HCOP_O;
	
	c[ipCO][ipCO] -= OHP_CO_HCOP_O_1; 
	c[ipOHP][ipCO] -= OHP_CO_HCOP_O_2;
	bvec[ipCO] -= bvec_OHP_CO_HCOP_O;
	
	c[ipCO][ipHCOP] += OHP_CO_HCOP_O_1; 
	c[ipOHP][ipHCOP] += OHP_CO_HCOP_O_2;
	bvec[ipHCOP] += bvec_OHP_CO_HCOP_O;
	
	/* >>refer	molecule	OH+	H2O	=>	H3O+	O	UMIST	*/
		
	
	c[ipH2O][ipOHP] -= OHP_H2O_H3OP_O_1; 
	c[ipOHP][ipOHP] -= OHP_H2O_H3OP_O_2;
	bvec[ipOHP] -= bvec_OHP_H2O_H3OP_O;
	
	c[ipH2O][ipH2O] -= OHP_H2O_H3OP_O_1; 
	c[ipOHP][ipH2O] -= OHP_H2O_H3OP_O_2;
	bvec[ipH2O] -= bvec_OHP_H2O_H3OP_O;
	
	c[ipH2O][ipH3OP] += OHP_H2O_H3OP_O_1; 
	c[ipOHP][ipH3OP] += OHP_H2O_H3OP_O_2;
	bvec[ipH3OP] += bvec_OHP_H2O_H3OP_O;
	
	/* >>refer	molecule	OH+	H2O	=>	H2O+	OH	UMIST	*/
		
	
	c[ipH2O][ipOHP] -= OHP_H2O_H2OP_OH_1; 
	c[ipOHP][ipOHP] -= OHP_H2O_H2OP_OH_2;
	bvec[ipOHP] -= bvec_OHP_H2O_H2OP_OH;
	
	c[ipH2O][ipH2O] -= OHP_H2O_H2OP_OH_1; 
	c[ipOHP][ipH2O] -= OHP_H2O_H2OP_OH_2;
	bvec[ipH2O] -= bvec_OHP_H2O_H2OP_OH;
	
	c[ipH2O][ipH2OP] += OHP_H2O_H2OP_OH_1; 
	c[ipOHP][ipH2OP] += OHP_H2O_H2OP_OH_2;
	bvec[ipH2OP] += bvec_OHP_H2O_H2OP_OH;
	
	c[ipH2O][ipOH] += OHP_H2O_H2OP_OH_1; 
	c[ipOHP][ipOH] += OHP_H2O_H2OP_OH_2;
	bvec[ipOH] += bvec_OHP_H2O_H2OP_OH;
	
	/* >>refer	molecule	OH+	O2	=>	O2+	OH	UMIST	*/
		
	
	c[ipO2][ipOHP] -= OHP_O2_O2P_OH_1; 
	c[ipOHP][ipOHP] -= OHP_O2_O2P_OH_2;
	bvec[ipOHP] -= bvec_OHP_O2_O2P_OH;
	
	c[ipO2][ipO2] -= OHP_O2_O2P_OH_1; 
	c[ipOHP][ipO2] -= OHP_O2_O2P_OH_2;
	bvec[ipO2] -= bvec_OHP_O2_O2P_OH;
	
	c[ipO2][ipO2P] += OHP_O2_O2P_OH_1; 
	c[ipOHP][ipO2P] += OHP_O2_O2P_OH_2;
	bvec[ipO2P] += bvec_OHP_O2_O2P_OH;
	
	c[ipO2][ipOH] += OHP_O2_O2P_OH_1; 
	c[ipOHP][ipOH] += OHP_O2_O2P_OH_2;
	bvec[ipOH] += bvec_OHP_O2_O2P_OH;
	
	/* >>refer	molecule	OH+	OH	=>	H2O+	O	UMIST	*/
		
	
	c[ipOH][ipOHP] -= OHP_OH_H2OP_O_1; 
	c[ipOHP][ipOHP] -= OHP_OH_H2OP_O_2;
	bvec[ipOHP] -= bvec_OHP_OH_H2OP_O;
	
	c[ipOH][ipOH] -= OHP_OH_H2OP_O_1; 
	c[ipOHP][ipOH] -= OHP_OH_H2OP_O_2;
	bvec[ipOH] -= bvec_OHP_OH_H2OP_O;
	
	c[ipOH][ipH2OP] += OHP_OH_H2OP_O_1; 
	c[ipOHP][ipH2OP] += OHP_OH_H2OP_O_2;
	bvec[ipH2OP] += bvec_OHP_OH_H2OP_O;
	
	/* >>refer	molecule	OH+	SiH	=>	SiH2+	O	UMIST	*/
		
	
	c[ipSIH][ipOHP] -= OHP_SiH_SiH2P_O_1; 
	c[ipOHP][ipOHP] -= OHP_SiH_SiH2P_O_2;
	bvec[ipOHP] -= bvec_OHP_SiH_SiH2P_O;
	
	c[ipSIH][ipSIH] -= OHP_SiH_SiH2P_O_1; 
	c[ipOHP][ipSIH] -= OHP_SiH_SiH2P_O_2;
	bvec[ipSIH] -= bvec_OHP_SiH_SiH2P_O;
	
	c[ipSIH][ipSIH2P] += OHP_SiH_SiH2P_O_1; 
	c[ipOHP][ipSIH2P] += OHP_SiH_SiH2P_O_2;
	bvec[ipSIH2P] += bvec_OHP_SiH_SiH2P_O;
	
	/* >>refer	molecule	OH+	SiO	=>	SiOH+	O	UMIST	*/
		
	
	c[ipSIO][ipOHP] -= OHP_SiO_SiOHP_O_1; 
	c[ipOHP][ipOHP] -= OHP_SiO_SiOHP_O_2;
	bvec[ipOHP] -= bvec_OHP_SiO_SiOHP_O;
	
	c[ipSIO][ipSIO] -= OHP_SiO_SiOHP_O_1; 
	c[ipOHP][ipSIO] -= OHP_SiO_SiOHP_O_2;
	bvec[ipSIO] -= bvec_OHP_SiO_SiOHP_O;
	
	c[ipSIO][ipHOSIP] += OHP_SiO_SiOHP_O_1; 
	c[ipOHP][ipHOSIP] += OHP_SiO_SiOHP_O_2;
	bvec[ipHOSIP] += bvec_OHP_SiO_SiOHP_O;


	/* new coupled reactions involving CH3, CH4, CH4+, and CH5+ */

	/* >>refer molecule   C CH5P  =>  CH4 CHP   UMIST    */
	
	
	c[ipATC][ipCH5P] -= C_CH5P_CH4_CHP_1;
	c[ipCH5P][ipCH5P] -= C_CH5P_CH4_CHP_2;
	bvec[ipCH5P] -= bvec_C_CH5P_CH4_CHP;
	
	c[ipATC][ipCH4] += C_CH5P_CH4_CHP_1;
	c[ipCH5P][ipCH4] += C_CH5P_CH4_CHP_2;
	bvec[ipCH4] += bvec_C_CH5P_CH4_CHP;
	
	c[ipATC][ipCHP] += C_CH5P_CH4_CHP_1;
	c[ipCH5P][ipCHP] += C_CH5P_CH4_CHP_2;
	bvec[ipCHP] += bvec_C_CH5P_CH4_CHP;
	
	/* >>refer molecule   O CH4  =>  OH CH3   UMIST    */
	
	
	c[ipATO][ipCH4] -= O_CH4_OH_CH3_1;
	c[ipCH4][ipCH4] -= O_CH4_OH_CH3_2;
	bvec[ipCH4] -= bvec_O_CH4_OH_CH3;
	
	c[ipATO][ipOH] += O_CH4_OH_CH3_1;
	c[ipCH4][ipOH] += O_CH4_OH_CH3_2;
	bvec[ipOH] += bvec_O_CH4_OH_CH3;
	
	c[ipATO][ipCH3] += O_CH4_OH_CH3_1;
	c[ipCH4][ipCH3] += O_CH4_OH_CH3_2;
	bvec[ipCH3] += bvec_O_CH4_OH_CH3;
	
	
	/* >>refer molecule   O CH4P  =>  OH CH3P   UMIST    */
	
	
	c[ipATO][ipCH4P] -= O_CH4P_OH_CH3P_1;
	c[ipCH4P][ipCH4P] -= O_CH4P_OH_CH3P_2;
	bvec[ipCH4P] -= bvec_O_CH4P_OH_CH3P;
	
	c[ipATO][ipOH] += O_CH4P_OH_CH3P_1;
	c[ipCH4P][ipOH] += O_CH4P_OH_CH3P_2;
	bvec[ipOH] += bvec_O_CH4P_OH_CH3P;
	
	c[ipATO][ipCH3P] += O_CH4P_OH_CH3P_1;
	c[ipCH4P][ipCH3P] += O_CH4P_OH_CH3P_2;
	bvec[ipCH3P] += bvec_O_CH4P_OH_CH3P;
	
			
	/* >>refer molecule   O CH5P  =>  H3OP CH2   UMIST    */
	
	
	c[ipATO][ipCH5P] -= O_CH5P_H3OP_CH2_1;
	c[ipCH5P][ipCH5P] -= O_CH5P_H3OP_CH2_2;
	bvec[ipCH5P] -= bvec_O_CH5P_H3OP_CH2;
	
	c[ipATO][ipH3OP] += O_CH5P_H3OP_CH2_1;
	c[ipCH5P][ipH3OP] += O_CH5P_H3OP_CH2_2;
	bvec[ipH3OP] += bvec_O_CH5P_H3OP_CH2;
	
	c[ipATO][ipCH2] += O_CH5P_H3OP_CH2_1;
	c[ipCH5P][ipCH2] += O_CH5P_H3OP_CH2_2;
	bvec[ipCH2] += bvec_O_CH5P_H3OP_CH2;
	
	
	/* >>refer molecule   OP CH4  =>  OH CH3P   UMIST    */
	
	c[ipOP][ipOP] -= OP_CH4_OH_CH3P_1;
	c[ipCH4][ipOP] -= OP_CH4_OH_CH3P_2;
	bvec[ipOP] -= bvec_OP_CH4_OH_CH3P;
	
	c[ipOP][ipCH4] -= OP_CH4_OH_CH3P_1;
	c[ipCH4][ipCH4] -= OP_CH4_OH_CH3P_2;
	bvec[ipCH4] -= bvec_OP_CH4_OH_CH3P;

	c[ipOP][ipOH] += OP_CH4_OH_CH3P_1;
	c[ipCH4][ipOH] += OP_CH4_OH_CH3P_2;
	bvec[ipOH] += bvec_OP_CH4_OH_CH3P;
	
	c[ipOP][ipCH3P] += OP_CH4_OH_CH3P_1;
	c[ipCH4][ipCH3P] += OP_CH4_OH_CH3P_2;
	bvec[ipCH3P] += bvec_OP_CH4_OH_CH3P;
	
	
	/* >>refer molecule   OP CH4  =>  CH4P O   UMIST    */
	
	c[ipOP][ipOP] -= OP_CH4_CH4P_O_1;
	c[ipCH4][ipOP] -= OP_CH4_CH4P_O_2;
	bvec[ipOP] -= bvec_OP_CH4_CH4P_O;
	
	c[ipOP][ipCH4] -= OP_CH4_CH4P_O_1;
	c[ipCH4][ipCH4] -= OP_CH4_CH4P_O_2;
	bvec[ipCH4] -= bvec_OP_CH4_CH4P_O;
	
	c[ipOP][ipCH4P] += OP_CH4_CH4P_O_1;
	c[ipCH4][ipCH4P] += OP_CH4_CH4P_O_2;
	bvec[ipCH4P] += bvec_OP_CH4_CH4P_O;
	
	
	/* >>refer molecule   CH4 CH  =>  CH3 CH2   UMIST    */
	
	c[ipCH4][ipCH4] -= CH4_CH_CH3_CH2_1;
	c[ipCH][ipCH4] -= CH4_CH_CH3_CH2_2;
	bvec[ipCH4] -= bvec_CH4_CH_CH3_CH2;
	
	c[ipCH4][ipCH] -= CH4_CH_CH3_CH2_1;
	c[ipCH][ipCH] -= CH4_CH_CH3_CH2_2;
	bvec[ipCH] -= bvec_CH4_CH_CH3_CH2;
	
	c[ipCH4][ipCH3] += CH4_CH_CH3_CH2_1;
	c[ipCH][ipCH3] += CH4_CH_CH3_CH2_2;
	bvec[ipCH3] += bvec_CH4_CH_CH3_CH2;
	
	c[ipCH4][ipCH2] += CH4_CH_CH3_CH2_1;
	c[ipCH][ipCH2] += CH4_CH_CH3_CH2_2;
	bvec[ipCH2] += bvec_CH4_CH_CH3_CH2;
	
	
	/* >>refer molecule   CH5P CH  =>  CH4 CH2P   UMIST    */

	c[ipCH5P][ipCH5P] -= CH5P_CH_CH4_CH2P_1;
	c[ipCH][ipCH5P] -= CH5P_CH_CH4_CH2P_2;
	bvec[ipCH5P] -= bvec_CH5P_CH_CH4_CH2P;
	
	c[ipCH5P][ipCH] -= CH5P_CH_CH4_CH2P_1;
	c[ipCH][ipCH] -= CH5P_CH_CH4_CH2P_2;
	bvec[ipCH] -= bvec_CH5P_CH_CH4_CH2P;
	
	c[ipCH5P][ipCH4] += CH5P_CH_CH4_CH2P_1;
	c[ipCH][ipCH4] += CH5P_CH_CH4_CH2P_2;
	bvec[ipCH4] += bvec_CH5P_CH_CH4_CH2P;
	
	c[ipCH5P][ipCH2P] += CH5P_CH_CH4_CH2P_1;
	c[ipCH][ipCH2P] += CH5P_CH_CH4_CH2P_2;
	bvec[ipCH2P] += bvec_CH5P_CH_CH4_CH2P;
	
	
	/* >>refer molecule   CH2 CH2  =>  CH3 CH   UMIST    */
	
	c[ipCH2][ipCH2] -= CH2_CH2_CH3_CH_1;
	c[ipCH2][ipCH2] -= CH2_CH2_CH3_CH_2;
	bvec[ipCH2] -= bvec_CH2_CH2_CH3_CH;
	
	c[ipCH2][ipCH3] += 0.5*CH2_CH2_CH3_CH_1;
	c[ipCH2][ipCH3] += 0.5*CH2_CH2_CH3_CH_2;
	bvec[ipCH3] += 0.5*bvec_CH2_CH2_CH3_CH;
	
	c[ipCH2][ipCH] += 0.5*CH2_CH2_CH3_CH_1;
	c[ipCH2][ipCH] += 0.5*CH2_CH2_CH3_CH_2;
	bvec[ipCH] += 0.5*bvec_CH2_CH2_CH3_CH;
	
	
	/* >>refer molecule   CH4 CH2  =>  CH3 CH3   UMIST    */
	
	c[ipCH4][ipCH4] -= CH4_CH2_CH3_CH3_1;
	c[ipCH2][ipCH4] -= CH4_CH2_CH3_CH3_2;
	bvec[ipCH4] -= bvec_CH4_CH2_CH3_CH3;
	
	c[ipCH4][ipCH2] -= CH4_CH2_CH3_CH3_1;
	c[ipCH2][ipCH2] -= CH4_CH2_CH3_CH3_2;
	bvec[ipCH2] -= bvec_CH4_CH2_CH3_CH3;
	
	c[ipCH4][ipCH3] += CH4_CH2_CH3_CH3_1;
	c[ipCH2][ipCH3] += CH4_CH2_CH3_CH3_2;
	bvec[ipCH3] += bvec_CH4_CH2_CH3_CH3;
	
	c[ipCH4][ipCH3] += CH4_CH2_CH3_CH3_1;
	c[ipCH2][ipCH3] += CH4_CH2_CH3_CH3_2;
	bvec[ipCH3] += bvec_CH4_CH2_CH3_CH3;
	
	
	/* >>refer molecule   OH CH2  =>  O CH3   UMIST    */
	
	c[ipOH][ipOH] -= OH_CH2_O_CH3_1;	
	c[ipCH2][ipOH] -= OH_CH2_O_CH3_2;
	bvec[ipOH] -= bvec_OH_CH2_O_CH3;
	
	c[ipOH][ipCH2] -= OH_CH2_O_CH3_1;
	c[ipCH2][ipCH2] -= OH_CH2_O_CH3_2;
	bvec[ipCH2] -= bvec_OH_CH2_O_CH3;
	
	c[ipOH][ipCH3] += OH_CH2_O_CH3_1;
	c[ipCH2][ipCH3] += OH_CH2_O_CH3_2;
	bvec[ipCH3] += bvec_OH_CH2_O_CH3;
	
	
	/* >>refer molecule   CH5P CH2  =>  CH4 CH3P   UMIST    */
	
	c[ipCH5P][ipCH5P] -= CH5P_CH2_CH4_CH3P_1;
	c[ipCH2][ipCH5P] -= CH5P_CH2_CH4_CH3P_2;
	bvec[ipCH5P] -= bvec_CH5P_CH2_CH4_CH3P;
	
	c[ipCH5P][ipCH2] -= CH5P_CH2_CH4_CH3P_1;
	c[ipCH2][ipCH2] -= CH5P_CH2_CH4_CH3P_2;
	bvec[ipCH2] -= bvec_CH5P_CH2_CH4_CH3P;
	
	c[ipCH5P][ipCH4] += CH5P_CH2_CH4_CH3P_1;
	c[ipCH2][ipCH4] += CH5P_CH2_CH4_CH3P_2;
	bvec[ipCH4] += bvec_CH5P_CH2_CH4_CH3P;
	
	c[ipCH5P][ipCH3P] += CH5P_CH2_CH4_CH3P_1;
	c[ipCH2][ipCH3P] += CH5P_CH2_CH4_CH3P_2;
	bvec[ipCH3P] += bvec_CH5P_CH2_CH4_CH3P;
	
	
	/* >>refer molecule   OH CH3  =>  CH4 O   UMIST    */
	
	c[ipOH][ipOH] -= OH_CH3_CH4_O_1;
	c[ipCH3][ipOH] -= OH_CH3_CH4_O_2;
	bvec[ipOH] -= bvec_OH_CH3_CH4_O;
	
	c[ipOH][ipCH3] -= OH_CH3_CH4_O_1;
	c[ipCH3][ipCH3] -= OH_CH3_CH4_O_2;
	bvec[ipCH3] -= bvec_OH_CH3_CH4_O;
	
	c[ipOH][ipCH4] += OH_CH3_CH4_O_1;
	c[ipCH3][ipCH4] += OH_CH3_CH4_O_2;
	bvec[ipCH4] += bvec_OH_CH3_CH4_O;
	
	
	/* >>refer molecule   OH CH3  =>  H2O CH2   UMIST    */
	
	c[ipOH][ipOH] -= OH_CH3_H2O_CH2_1;
	c[ipCH3][ipOH] -= OH_CH3_H2O_CH2_2;
	bvec[ipOH] -= bvec_OH_CH3_H2O_CH2;

	c[ipOH][ipCH3] -= OH_CH3_H2O_CH2_1;
	c[ipCH3][ipCH3] -= OH_CH3_H2O_CH2_2;
	bvec[ipCH3] -= bvec_OH_CH3_H2O_CH2;
	
	c[ipOH][ipH2O] += OH_CH3_H2O_CH2_1;
	c[ipCH3][ipH2O] += OH_CH3_H2O_CH2_2;
	bvec[ipH2O] += bvec_OH_CH3_H2O_CH2;
	
	c[ipOH][ipCH2] += OH_CH3_H2O_CH2_1;
	c[ipCH3][ipCH2] += OH_CH3_H2O_CH2_2;
	bvec[ipCH2] += bvec_OH_CH3_H2O_CH2;
	
	
	/* >>refer molecule   H2O CH3  =>  OH CH4   UMIST    */
	
	c[ipH2O][ipH2O] -= H2O_CH3_OH_CH4_1;
	c[ipCH3][ipH2O] -= H2O_CH3_OH_CH4_2;
	bvec[ipH2O] -= bvec_H2O_CH3_OH_CH4;
	
	c[ipH2O][ipCH3] -= H2O_CH3_OH_CH4_1;
	c[ipCH3][ipCH3] -= H2O_CH3_OH_CH4_2;
	bvec[ipCH3] -= bvec_H2O_CH3_OH_CH4;
	
	c[ipH2O][ipOH] += H2O_CH3_OH_CH4_1;
	c[ipCH3][ipOH] += H2O_CH3_OH_CH4_2;
	bvec[ipOH] += bvec_H2O_CH3_OH_CH4;
	
	c[ipH2O][ipCH4] += H2O_CH3_OH_CH4_1;
	c[ipCH3][ipCH4] += H2O_CH3_OH_CH4_2;
	bvec[ipCH4] += bvec_H2O_CH3_OH_CH4;


	/* >>refer molecule   CH3 CH3  =>  CH4 CH2   UMIST    */
	
	c[ipCH3][ipCH3] -= CH3_CH3_CH4_CH2_1;
	c[ipCH3][ipCH3] -= CH3_CH3_CH4_CH2_2;
	bvec[ipCH3] -= bvec_CH3_CH3_CH4_CH2;
	
	c[ipCH3][ipCH4] += 0.5*CH3_CH3_CH4_CH2_1;
	c[ipCH3][ipCH4] += 0.5*CH3_CH3_CH4_CH2_2;
	bvec[ipCH4] += 0.5*bvec_CH3_CH3_CH4_CH2;
	
	c[ipCH3][ipCH2] += 0.5*CH3_CH3_CH4_CH2_1;
	c[ipCH3][ipCH2] += 0.5*CH3_CH3_CH4_CH2_2;
	bvec[ipCH2] += 0.5*bvec_CH3_CH3_CH4_CH2;
	
	
	/* >>refer molecule   OH CH4  =>  H2O CH3   UMIST    */

	c[ipOH][ipOH] -= OH_CH4_H2O_CH3_1;
	c[ipCH4][ipOH] -= OH_CH4_H2O_CH3_2;
	bvec[ipOH] -= bvec_OH_CH4_H2O_CH3;
	
	c[ipOH][ipCH4] -= OH_CH4_H2O_CH3_1;
	c[ipCH4][ipCH4] -= OH_CH4_H2O_CH3_2;
	bvec[ipCH4] -= bvec_OH_CH4_H2O_CH3;
	
	c[ipOH][ipH2O] += OH_CH4_H2O_CH3_1;
	c[ipCH4][ipH2O] += OH_CH4_H2O_CH3_2;
	bvec[ipH2O] += bvec_OH_CH4_H2O_CH3;
	
	c[ipOH][ipCH3] += OH_CH4_H2O_CH3_1;
	c[ipCH4][ipCH3] += OH_CH4_H2O_CH3_2;
	bvec[ipCH3] += bvec_OH_CH4_H2O_CH3;
	
	
	/* >>refer molecule   OHP CH4  =>  CH5P O   UMIST    */
	
	c[ipOHP][ipOHP] -= OHP_CH4_CH5P_O_1;
	c[ipCH4][ipOHP] -= OHP_CH4_CH5P_O_2;
	bvec[ipOHP] -= bvec_OHP_CH4_CH5P_O;
	
	c[ipOHP][ipCH4] -= OHP_CH4_CH5P_O_1;
	c[ipCH4][ipCH4] -= OHP_CH4_CH5P_O_2;
	bvec[ipCH4] -= bvec_OHP_CH4_CH5P_O;
	
	c[ipOHP][ipCH5P] += OHP_CH4_CH5P_O_1;
	c[ipCH4][ipCH5P] += OHP_CH4_CH5P_O_2;
	bvec[ipCH5P] += bvec_OHP_CH4_CH5P_O;
	
	
	/* >>refer molecule   OHP CH4  =>  H3OP CH2   UMIST    */
	
	c[ipOHP][ipOHP] -= OHP_CH4_H3OP_CH2_1;
	c[ipCH4][ipOHP] -= OHP_CH4_H3OP_CH2_2;
	bvec[ipOHP] -= bvec_OHP_CH4_H3OP_CH2;
	
	c[ipOHP][ipCH4] -= OHP_CH4_H3OP_CH2_1;
	c[ipCH4][ipCH4] -= OHP_CH4_H3OP_CH2_2;
	bvec[ipCH4] -= bvec_OHP_CH4_H3OP_CH2;
	
	c[ipOHP][ipH3OP] += OHP_CH4_H3OP_CH2_1;
	c[ipCH4][ipH3OP] += OHP_CH4_H3OP_CH2_2;
	bvec[ipH3OP] += bvec_OHP_CH4_H3OP_CH2;
	
	c[ipOHP][ipCH2] += OHP_CH4_H3OP_CH2_1;
	c[ipCH4][ipCH2] += OHP_CH4_H3OP_CH2_2;
	bvec[ipCH2] += bvec_OHP_CH4_H3OP_CH2;
	
	
	/* >>refer molecule   H2OP CH4  =>  H3OP CH3   UMIST    */
	
	c[ipH2OP][ipH2OP] -= H2OP_CH4_H3OP_CH3_1;
	c[ipCH4][ipH2OP] -= H2OP_CH4_H3OP_CH3_2;
	bvec[ipH2OP] -= bvec_H2OP_CH4_H3OP_CH3;
	
	c[ipH2OP][ipCH4] -= H2OP_CH4_H3OP_CH3_1;
	c[ipCH4][ipCH4] -= H2OP_CH4_H3OP_CH3_2;
	bvec[ipCH4] -= bvec_H2OP_CH4_H3OP_CH3;
	
	c[ipH2OP][ipH3OP] += H2OP_CH4_H3OP_CH3_1;
	c[ipCH4][ipH3OP] += H2OP_CH4_H3OP_CH3_2;
	bvec[ipH3OP] += bvec_H2OP_CH4_H3OP_CH3;
	
	c[ipH2OP][ipCH3] += H2OP_CH4_H3OP_CH3_1;
	c[ipCH4][ipCH3] += H2OP_CH4_H3OP_CH3_2;
	bvec[ipCH3] += bvec_H2OP_CH4_H3OP_CH3;
	
	
	/* >>refer molecule   COP CH4  =>  HCOP CH3   UMIST    */
	
	c[ipCOP][ipCOP] -= COP_CH4_HCOP_CH3_1;
	c[ipCH4][ipCOP] -= COP_CH4_HCOP_CH3_2;
	bvec[ipCOP] -= bvec_COP_CH4_HCOP_CH3;
	
	c[ipCOP][ipCH4] -= COP_CH4_HCOP_CH3_1;
	c[ipCH4][ipCH4] -= COP_CH4_HCOP_CH3_2;
	bvec[ipCH4] -= bvec_COP_CH4_HCOP_CH3;
	
	c[ipCOP][ipHCOP] += COP_CH4_HCOP_CH3_1;
	c[ipCH4][ipHCOP] += COP_CH4_HCOP_CH3_2;
	bvec[ipHCOP] += bvec_COP_CH4_HCOP_CH3;
	
	c[ipCOP][ipCH3] += COP_CH4_HCOP_CH3_1;
	c[ipCH4][ipCH3] += COP_CH4_HCOP_CH3_2;
	bvec[ipCH3] += bvec_COP_CH4_HCOP_CH3;
	
	
	/* >>refer molecule   COP CH4  =>  CO CH4P   UMIST    */
	
	c[ipCOP][ipCOP] -= COP_CH4_CO_CH4P_1;
	c[ipCH4][ipCOP] -= COP_CH4_CO_CH4P_2;
	bvec[ipCOP] -= bvec_COP_CH4_CO_CH4P;
	
	c[ipCOP][ipCH4] -= COP_CH4_CO_CH4P_1;
	c[ipCH4][ipCH4] -= COP_CH4_CO_CH4P_2;
	bvec[ipCH4] -= bvec_COP_CH4_CO_CH4P;
	
	c[ipCOP][ipCO] += COP_CH4_CO_CH4P_1;
	c[ipCH4][ipCO] += COP_CH4_CO_CH4P_2;
	bvec[ipCO] += bvec_COP_CH4_CO_CH4P;
	
	c[ipCOP][ipCH4P] += COP_CH4_CO_CH4P_1;
	c[ipCH4][ipCH4P] += COP_CH4_CO_CH4P_2;
	bvec[ipCH4P] += bvec_COP_CH4_CO_CH4P;
	
	
	/* >>refer molecule   CH4 CH4P  =>  CH5P CH3   UMIST    */
	
	c[ipCH4][ipCH4] -= CH4_CH4P_CH5P_CH3_1;
	c[ipCH4P][ipCH4] -= CH4_CH4P_CH5P_CH3_2;
	bvec[ipCH4] -= bvec_CH4_CH4P_CH5P_CH3;
	
	c[ipCH4][ipCH4P] -= CH4_CH4P_CH5P_CH3_1;
	c[ipCH4P][ipCH4P] -= CH4_CH4P_CH5P_CH3_2;
	bvec[ipCH4P] -= bvec_CH4_CH4P_CH5P_CH3;
	
	c[ipCH4][ipCH5P] += CH4_CH4P_CH5P_CH3_1;
	c[ipCH4P][ipCH5P] += CH4_CH4P_CH5P_CH3_2;
	bvec[ipCH5P] += bvec_CH4_CH4P_CH5P_CH3;
	
	c[ipCH4][ipCH3] += CH4_CH4P_CH5P_CH3_1;
	c[ipCH4P][ipCH3] += CH4_CH4P_CH5P_CH3_2;
	bvec[ipCH3] += bvec_CH4_CH4P_CH5P_CH3;
	
	
	/* >>refer molecule   H2O CH4P  =>  H3OP CH3   UMIST    */
	
	c[ipH2O][ipH2O] -= H2O_CH4P_H3OP_CH3_1;
	c[ipCH4P][ipH2O] -= H2O_CH4P_H3OP_CH3_2;
	bvec[ipH2O] -= bvec_H2O_CH4P_H3OP_CH3;
	
	c[ipH2O][ipCH4P] -= H2O_CH4P_H3OP_CH3_1;
	c[ipCH4P][ipCH4P] -= H2O_CH4P_H3OP_CH3_2;
	bvec[ipCH4P] -= bvec_H2O_CH4P_H3OP_CH3;
	
	c[ipH2O][ipH3OP] += H2O_CH4P_H3OP_CH3_1;
	c[ipCH4P][ipH3OP] += H2O_CH4P_H3OP_CH3_2;
	bvec[ipH3OP] += bvec_H2O_CH4P_H3OP_CH3;
	
	c[ipH2O][ipCH3] += H2O_CH4P_H3OP_CH3_1;
	c[ipCH4P][ipCH3] += H2O_CH4P_H3OP_CH3_2;
	bvec[ipCH3] += bvec_H2O_CH4P_H3OP_CH3;
	
	
	/* >>refer molecule   CO CH4P  =>  HCOP CH3   UMIST    */
	
	c[ipCO][ipCO] -= CO_CH4P_HCOP_CH3_1;
	c[ipCH4P][ipCO] -= CO_CH4P_HCOP_CH3_2;
	bvec[ipCO] -= bvec_CO_CH4P_HCOP_CH3;
	
	c[ipCO][ipCH4P] -= CO_CH4P_HCOP_CH3_1;
	c[ipCH4P][ipCH4P] -= CO_CH4P_HCOP_CH3_2;
	bvec[ipCH4P] -= bvec_CO_CH4P_HCOP_CH3;
	
	c[ipCO][ipHCOP] += CO_CH4P_HCOP_CH3_1;
	c[ipCH4P][ipHCOP] += CO_CH4P_HCOP_CH3_2;
	bvec[ipHCOP] += bvec_CO_CH4P_HCOP_CH3;
	
	c[ipCO][ipCH3] += CO_CH4P_HCOP_CH3_1;
	c[ipCH4P][ipCH3] += CO_CH4P_HCOP_CH3_2;
	bvec[ipCH3] += bvec_CO_CH4P_HCOP_CH3;
	
	
	/* >>refer molecule   O2 CH4P  =>  O2P CH4   UMIST    */
	
	c[ipO2][ipO2] -= O2_CH4P_O2P_CH4_1;
	c[ipCH4P][ipO2] -= O2_CH4P_O2P_CH4_2;
	bvec[ipO2] -= bvec_O2_CH4P_O2P_CH4;
	
	c[ipO2][ipCH4P] -= O2_CH4P_O2P_CH4_1;
	c[ipCH4P][ipCH4P] -= O2_CH4P_O2P_CH4_2;
	bvec[ipCH4P] -= bvec_O2_CH4P_O2P_CH4;
	
	c[ipO2][ipO2P] += O2_CH4P_O2P_CH4_1;
	c[ipCH4P][ipO2P] += O2_CH4P_O2P_CH4_2;
	bvec[ipO2P] += bvec_O2_CH4P_O2P_CH4;
	
	c[ipO2][ipCH4] += O2_CH4P_O2P_CH4_1;
	c[ipCH4P][ipCH4] += O2_CH4P_O2P_CH4_2;
	bvec[ipCH4] += bvec_O2_CH4P_O2P_CH4;
	
	/* >>refer molecule   H2O CH5P  =>  H3OP CH4   UMIST    */
	
	c[ipH2O][ipH2O] -= H2O_CH5P_H3OP_CH4_1;
	c[ipCH5P][ipH2O] -= H2O_CH5P_H3OP_CH4_2;
	bvec[ipH2O] -= bvec_H2O_CH5P_H3OP_CH4;
	
	c[ipH2O][ipCH5P] -= H2O_CH5P_H3OP_CH4_1;
	c[ipCH5P][ipCH5P] -= H2O_CH5P_H3OP_CH4_2;
	bvec[ipCH5P] -= bvec_H2O_CH5P_H3OP_CH4;

	c[ipH2O][ipH3OP] += H2O_CH5P_H3OP_CH4_1;
	c[ipCH5P][ipH3OP] += H2O_CH5P_H3OP_CH4_2;
	bvec[ipH3OP] += bvec_H2O_CH5P_H3OP_CH4;
	
	c[ipH2O][ipCH4] += H2O_CH5P_H3OP_CH4_1;
	c[ipCH5P][ipCH4] += H2O_CH5P_H3OP_CH4_2;
	bvec[ipCH4] += bvec_H2O_CH5P_H3OP_CH4;
	
	
	/* >>refer molecule   CO CH5P  =>  HCOP CH4   UMIST    */
	
	c[ipCO][ipCO] -= CO_CH5P_HCOP_CH4_1;
	c[ipCH5P][ipCO] -= CO_CH5P_HCOP_CH4_2;
	bvec[ipCO] -= bvec_CO_CH5P_HCOP_CH4;
	
	c[ipCO][ipCH5P] -= CO_CH5P_HCOP_CH4_1;
	c[ipCH5P][ipCH5P] -= CO_CH5P_HCOP_CH4_2;
	bvec[ipCH5P] -= bvec_CO_CH5P_HCOP_CH4;
	
	c[ipCO][ipHCOP] += CO_CH5P_HCOP_CH4_1;
	c[ipCH5P][ipHCOP] += CO_CH5P_HCOP_CH4_2;
	bvec[ipHCOP] += bvec_CO_CH5P_HCOP_CH4;
	
	c[ipCO][ipCH4] += CO_CH5P_HCOP_CH4_1;
	c[ipCH5P][ipCH4] += CO_CH5P_HCOP_CH4_2;
	bvec[ipCH4] += bvec_CO_CH5P_HCOP_CH4;
	
	
	/* >>refer molecule   CH5P OH  =>  H2OP CH4   UMIST    */
	
	c[ipCH5P][ipCH5P] -= CH5P_OH_H2OP_CH4_1;
	c[ipOH][ipCH5P] -= CH5P_OH_H2OP_CH4_2;
	bvec[ipCH5P] -= bvec_CH5P_OH_H2OP_CH4;
	
	c[ipCH5P][ipOH] -= CH5P_OH_H2OP_CH4_1;
	c[ipOH][ipOH] -= CH5P_OH_H2OP_CH4_2;
	bvec[ipOH] -= bvec_CH5P_OH_H2OP_CH4;
	
	c[ipCH5P][ipH2OP] += CH5P_OH_H2OP_CH4_1;
	c[ipOH][ipH2OP] += CH5P_OH_H2OP_CH4_2;
	bvec[ipH2OP] += bvec_CH5P_OH_H2OP_CH4;
	
	c[ipCH5P][ipCH4] += CH5P_OH_H2OP_CH4_1;
	c[ipOH][ipCH4] += CH5P_OH_H2OP_CH4_2;
	bvec[ipCH4] += bvec_CH5P_OH_H2OP_CH4;


	/* >>refer	molecule	C+ + e => C	 Done internally by Cloudy*/

	/* Recombination of C+ */
	c[ipCP][ipCP] -= (ionbal.RateRecomTot[ipCARBON][0]+gv.GrainChTrRate[ipCARBON][1][0]);

	/* >>refer	molecule	C + hnu => C+	e	 Done internally by Cloudy*/

	/* Photoionization and grain ct ionization of Co */
	c[ipATC][ipCP] += (ionbal.RateIonizTot[ipCARBON][0]+gv.GrainChTrRate[ipCARBON][0][1]);

	/* >>refer	molecule	O+ + e => O	 Done internally by Cloudy*/

	/* Recombination of O+ */
	c[ipOP][ipOP] -= (ionbal.RateRecomTot[ipOXYGEN][0]+gv.GrainChTrRate[ipOXYGEN][1][0]);

	/* >>refer	molecule	O + hnu => O+	e	Done internally by Cloudy*/

	/* Photoionization and grain ct ionization of Oo */
	c[ipATO][ipOP] += (ionbal.RateIonizTot[ipOXYGEN][0]+gv.GrainChTrRate[ipOXYGEN][0][1]);

	/* >>refer	molecule	Si + hnu => Si+	e	Done internally by Cloudy*/

	/* Photoionization of Si */

	c[ipATSI][ipSIP] += (ionbal.RateIonizTot[ipSILICON][0]+gv.GrainChTrRate[ipSILICON][0][1]);

	/* >>refer	molecule	Si+ + e => Si	 Done internally by Cloudy*/

	/* Recombination of Si+ */
	c[ipSIP][ipSIP] -= (ionbal.RateRecomTot[ipSILICON][0]+gv.GrainChTrRate[ipSILICON][1][0]);


	/****************************Add all terms with H2star from TH85*********************/

	
	c[ipCH][ipCH]  -= H2s_CH_C_H2_H; 
	
	c[ipOH][ipOH]  -= H2s_OH_O_H2_H; 
	
	c[ipH2O][ipH2O] -= H2s_H2O_OH_H2_H;
	c[ipH2O][ipOH]  += H2s_H2O_OH_H2_H; 
	
	c[ipO2][ipO2]   -= H2s_O2_O_O_H2;
	
	c[ipCH2][ipCH2]  -= H2s_CH2_CH3_H;  
	c[ipCH2][ipCH3]  += H2s_CH2_CH3_H; 
	
	c[ipCH][ipCH]   -= H2s_CH_CH3_nu;
	c[ipCH][ipCH3]  += H2s_CH_CH3_nu;

	c[ipCH3][ipCH3]  -= H2s_CH3_CH4_H;
	c[ipCH3][ipCH4]  += H2s_CH3_CH4_H;
	
	 
	/* >>refer	molecule	H2* + CH => CH2 + H	 Tielens & Hollenbach 1985, Ap. J. 291, 722 Table 9*/

	/* Formation of CH2 */
	c[ipCH][ipCH2] += h2s_ch_ch2_h;

	/* Destruction of CH */
	c[ipCH][ipCH] -=h2s_ch_ch2_h;

	/* >>refer	molecule	H2* + O => OH + H	 Tielens & Hollenbach 1985, Ap. J. 291, 722 Table 9*/

	/* Formation of OH */
	
	c[ipATO][ipOH] += h2s_o_oh_h;

	/* >>refer	molecule	H2* + OH => H2O + H	 Tielens & Hollenbach 1985, Ap. J. 291, 722 Table 9*/

	/* Formation of H2O */
	/* >>chng 03 sep 12, sec par had been 0.67, was supposed to
	 * be zero - Gargi Shaw */
	c[ipOH][ipH2O] += h2s_o_oh_h;

	/* Destruction of OH */
	c[ipOH][ipOH] -= h2s_oh_h2o_h;

	/* >>refer	molecule	H2* + O2 => 2OH	 Tielens & Hollenbach 1985, Ap. J. 291, 722 Table 9*/

	/* >>chng 03 sep 12, sec par was supposed to be 0, was
	 * 0.67, caught by Gargi Shaw */
	/* Formation of OH */
	c[ipO2][ipOH] += 2*h2s_o2_twooh;

	/* Destruction of O2 */
	c[ipO2][ipO2] -= h2s_o2_twooh;

	/* >>refer	molecule	H2* + C => CH + H	 Tielens & Hollenbach 1985, Ap. J. 291, 722 Table 9*/

	/* Formation of CH */
	c[ipATC][ipCH] += h2s_c_ch_h;

	/* >>refer	molecule	H2* + C+ => CH+ + H	Tielens & Hollenbach 1985, Ap. J. 291, 722 Table 9*/

	/* Formation of CH+ */
	c[ipCP][ipCHP] += h2s_cp_chp_h;

	/* Destruction of C+ */
	c[ipCP][ipCP] -= h2s_cp_chp_h;

	co_e_c_o_e = 0;

	/* inner shell photoionization of CO, assume rates are same as K 1s and 2s
	 * shell of C and O */
	/* >>chng 04 may 26, upper limit should be ns<2, had been ns<2 so picked up
	 * valence shell, which was incorrect */
	for ( ns=0; ns<2; ++ns )
	{
		int ion=0;
		co_e_c_o_e += ionbal.PhotoRate_Shell[ipCARBON][ion][ns][0];
		co_e_c_o_e += ionbal.PhotoRate_Shell[ipOXYGEN][ion][ns][0];
	}
	c[ipCO][ipCO] -= co_e_c_o_e*co.lgUMISTrates;

	

		C_NH_N_CH_1          = hmrate(0.0000000000173,0.5,4000)*co.hevmol[ipATC];
		C_NH_CN_H_1          = hmrate(0.00000000011,0.5,0)*co.hevmol[ipATC];
		C_NH2_HCN_H_1        = hmrate(0.0000000000326,-0.1,-9)*co.hevmol[ipATC];
		C_N2_CN_N_1          = hmrate(0.0000000000869,0,22600)*co.hevmol[ipATC];
		C_NO_CN_O_1          = hmrate(0.000000000048,0,0)*co.hevmol[ipATC];
		C_NO_CO_N_1          = hmrate(0.0000000000465,0,0)*co.hevmol[ipATC];
		C_HS_S_CH_1          = hmrate(0.000000000012,0.58,5880)*co.hevmol[ipATC];
		C_HS_CS_H_1          = hmrate(0.00000000002,0,0)*co.hevmol[ipATC];
		C_OCN_CO_CN_1        = hmrate(0.00000000004,0.5,0)*co.hevmol[ipATC];
		C_NS_S_CN_1          = hmrate(0.00000000002,0.5,0)*co.hevmol[ipATC];
		C_NS_CS_N_1          = hmrate(0.0000000000173,0.5,4000)*co.hevmol[ipATC];
		C_SO_S_CO_1          = hmrate(0.000000000072,0,0)*co.hevmol[ipATC];
		C_SO_CS_O_1          = hmrate(0.00000000017,0,0)*co.hevmol[ipATC];
		C_S2_CS_S_1          = hmrate(0.0000000000173,0.5,0)*co.hevmol[ipATC];
		CH_N_NH_C_1          = hmrate(0.0000000000303,0.65,1207)*co.hevmol[ipCH];
		CH_N_CN_H_1          = hmrate(0.000000000166,-0.09,0)*co.hevmol[ipCH];
		CH_N2_HCN_N_1        = hmrate(0.00000000000056,0.88,10128)*co.hevmol[ipCH];
		CH_NO_HCN_O_1        = hmrate(0.00000000559,0,10814)*co.hevmol[ipCH];
		CH_NO_CN_OH_1        = hmrate(2.32E-26,0,0)*co.hevmol[ipCH];
		CH_NO_OCN_H_1        = hmrate(1.13E-25,0,0)*co.hevmol[ipCH];
		CH_HNO_NO_CH2_1      = hmrate(0.0000000000173,0.5,0)*co.hevmol[ipCH];
		CH_S_HS_C_1          = hmrate(0.0000000000173,0.5,4000)*co.hevmol[ipCH];
		CH_S_CS_H_1          = hmrate(0.0000000000011,0,0)*co.hevmol[ipCH];
		N_NH_N2_H_1          = hmrate(0.0000000000498,0,0)*co.hevmol[ipATN];
		N_CH3_HCN_H_H_1      = hmrate(0.000000000000332,0,0)*co.hevmol[ipATN];
		N_CH3_HCN_H2_1       = hmrate(0.000000000013,0.5,0)*co.hevmol[ipATN];
		N_OH_O_NH_1          = hmrate(0.0000000000188,0.1,10700)*co.hevmol[ipATN];
		N_OH_NO_H_1          = hmrate(0.0000000000532,-0.25,0)*co.hevmol[ipATN];
		N_CN_N2_C_1          = hmrate(0.0000000003,0,0)*co.hevmol[ipATN];
		N_SIH_SIN_H_1        = hmrate(0.00000000005,0.5,0)*co.hevmol[ipATN];
		N_NO_N2_O_1          = hmrate(0.0000000000375,0,26)*co.hevmol[ipATN];
		N_HNO_NO_NH_1        = hmrate(0.00000000000294,0.5,1000)*co.hevmol[ipATN];
		N_HNO_N2O_H_1        = hmrate(0.00000000000143,0.5,1500)*co.hevmol[ipATN];
		N_O2_NO_O_1          = hmrate(0.00000000000226,0.86,3134)*co.hevmol[ipATN];
		N_HS_NS_H_1          = hmrate(0.0000000000173,0.5,0)*co.hevmol[ipATN];
		N_HS_S_NH_1          = hmrate(0.0000000000173,0.5,9060)*co.hevmol[ipATN];
		N_CS_S_CN_1          = hmrate(0.000000000038,0.5,1160)*co.hevmol[ipATN];
		N_NS_S_N2_1          = hmrate(0.0000000000173,0.5,0)*co.hevmol[ipATN];
		N_SO_NS_O_1          = hmrate(0.0000000000468,0.5,8254)*co.hevmol[ipATN];
		N_SO_S_NO_1          = hmrate(0.0000000000173,0.5,750)*co.hevmol[ipATN];
		N_S2_NS_S_1          = hmrate(0.0000000000173,0.5,4000)*co.hevmol[ipATN];
		CH2_CN_HCN_CH_1      = hmrate(0.0000000000053,0,2500)*co.hevmol[ipCH2];
		CH2_NO_HCN_OH_1      = hmrate(0.000000000000832,0,1443)*co.hevmol[ipCH2];
		CH2_HNO_NO_CH3_1     = hmrate(0.0000000000173,0.5,0)*co.hevmol[ipCH2];
		NH_NH_N2_H_H_1       = hmrate(0.00000000116,0,0)*co.hevmol[ipNH];
		NH_NH_N2_H2_1        = hmrate(0.000000000017,0,0)*co.hevmol[ipNH];
		NH_O_OH_N_1          = hmrate(0.0000000000116,0,0)*co.hevmol[ipNH];
		NH_O_NO_H_1          = hmrate(0.000000000116,0,0)*co.hevmol[ipNH];
		NH_OH_HNO_H_1        = hmrate(0.0000000000332,0,0)*co.hevmol[ipNH];
		NH_OH_NH2_O_1        = hmrate(0.00000000000293,0.1,5800)*co.hevmol[ipNH];
		NH_OH_H2O_N_1        = hmrate(0.00000000000311,1.2,0)*co.hevmol[ipNH];
		NH_H2O_OH_NH2_1      = hmrate(0.00000000000183,1.6,14090)*co.hevmol[ipNH];
		NH_CN_HCN_N_1        = hmrate(0.00000000000294,0.5,1000)*co.hevmol[ipNH];
		NH_NO_N2O_H_1        = hmrate(0.000000000116,-1.03,420)*co.hevmol[ipNH];
		NH_NO_N2_O_H_1       = hmrate(0.00000000005,0,0)*co.hevmol[ipNH];
		NH_NO_N2_OH_1        = hmrate(0.0000000000146,-0.58,37)*co.hevmol[ipNH];
		NH_S_HS_N_1          = hmrate(0.0000000000173,0.5,4000)*co.hevmol[ipNH];
		NH_S_NS_H_1          = hmrate(0.0000000000173,0.5,0)*co.hevmol[ipNH];
		NH_NO2_HNO_NO_1      = hmrate(0.00000000000572,0.5,2500)*co.hevmol[ipNH];
		NH_NO2_N2O_OH_1      = hmrate(0.000000000000144,0, 1140)*co.hevmol[ipNH];
		CH3_NH3_CH4_NH2_1    = hmrate(0.0000000000000955,0,4890)*co.hevmol[ipCH3];
		CH3_CN_HCN_CH2_1     = hmrate(0.00000000000921,0.7,1500)*co.hevmol[ipCH3];
		CH3_HNO_NO_CH4_1     = hmrate(0.0000000000144,0.5,0)*co.hevmol[ipCH3];
		O_NH2_OH_NH_1        = hmrate(0.0000000000139,0,40)*co.hevmol[ipATO];
		O_NH2_NO_H2_1        = hmrate(0.0000000000083,0,0)*co.hevmol[ipATO];
		O_NH3_OH_NH2_1       = hmrate(0.0000000000189,0,4003)*co.hevmol[ipATO];
		O_CN_NO_C_1          = hmrate(0.0000000000381,0.5,14545)*co.hevmol[ipATO];
		O_CN_CO_N_1          = hmrate(0.0000000000436,0.46,364)*co.hevmol[ipATO];
		O_HCN_CN_OH_1        = hmrate(0.000000000621,0,12439)*co.hevmol[ipATO];
		O_HCN_CO_NH_1        = hmrate(0.00000000000073,1.14,3742)*co.hevmol[ipATO];
		O_HCN_OCN_H_1        = hmrate(0.00000000000136,1.38,3693)*co.hevmol[ipATO];
		O_N2_NO_N_1          = hmrate(0.000000000251,0,38602)*co.hevmol[ipATO];
		O_NO_O2_N_1          = hmrate(0.0000000000118,0,20413)*co.hevmol[ipATO];
		O_HNO_NO_OH_1        = hmrate(0.00000000006,0,0)*co.hevmol[ipATO];
		O_HNO_O2_NH_1        = hmrate(0.00000000000294,0.5,3500)*co.hevmol[ipATO];
		O_HNO_NO2_H_1        = hmrate(0.00000000000144,0.5,0)*co.hevmol[ipATO];
		O_HS_S_OH_1          = hmrate(0.0000000000174,0.67,956)*co.hevmol[ipATO];
		O_HS_SO_H_1          = hmrate(0.000000000232,0,0)*co.hevmol[ipATO];
		O_OCN_NO_CO_1        = hmrate(0.0000000000943,-0.09,100)*co.hevmol[ipATO];
		O_OCN_O2_CN_1        = hmrate(0.000000000402,-1.43,3501)*co.hevmol[ipATO];
		O_SIN_NO_SI_1        = hmrate(0.000000000025,0.5,0)*co.hevmol[ipATO];
		O_SIN_SIO_N_1        = hmrate(0.0000000000575,0.1,200)*co.hevmol[ipATO];
		O_N2O_NO_NO_1        = hmrate(0.000000000115,0,13400)*co.hevmol[ipATO];
		O_N2O_O2_N2_1        = hmrate(0.000000000166,0,14100)*co.hevmol[ipATO];
		O_CS_S_CO_1          = hmrate(0.000000000248,-0.65,783)*co.hevmol[ipATO];
		O_CS_SO_C_1          = hmrate(0.0000000000468,0.5,28940)*co.hevmol[ipATO];
		O_NS_S_NO_1          = hmrate(0.00000000005,0.5,0)*co.hevmol[ipATO];
		O_NS_SO_N_1          = hmrate(0.0000000000173,0.5,4000)*co.hevmol[ipATO];
		O_SO_S_O2_1          = hmrate(0.00000000000066,0,2760)*co.hevmol[ipATO];
		O_OCS_SO_CO_1        = hmrate(0.000000000016,0,2150)*co.hevmol[ipATO];
		O_S2_SO_S_1          = hmrate(0.0000000000173,0.5,0)*co.hevmol[ipATO];
		NH2_OH_NH3_O_1       = hmrate(0.000000000000208,0.76,262)*co.hevmol[ipNH2];
		NH2_OH_H2O_NH_1      = hmrate(0.0000000000015,0,0)*co.hevmol[ipNH2];
		NH2_NO_N2_OH_H_1     = hmrate(0.00000000000149,0,0)*co.hevmol[ipNH2];
		NH2_NO_N2_H2O_1      = hmrate(0.0000000000427,-2.5,331)*co.hevmol[ipNH2];
		CH4_CN_HCN_CH3_1     = hmrate(0.00000000000314,1.53,504)*co.hevmol[ipCH4];
		OH_NH3_H2O_NH2_1     = hmrate(0.000000000000147,2.05,7)*co.hevmol[ipOH];
		OH_CN_HCN_O_1        = hmrate(0.00000000001,0,1000)*co.hevmol[ipOH];
		OH_CN_OCN_H_1        = hmrate(0.00000000007,0,0)*co.hevmol[ipOH];
		OH_HCN_CN_H2O_1      = hmrate(0.000000000000187,1.5,3887)*co.hevmol[ipOH];
		OH_HCN_CO_NH2_1      = hmrate(0.000000000000107,0,5892)*co.hevmol[ipOH];
		OH_NO_NO2_H_1        = hmrate(0.0000000000052,0,15100)*co.hevmol[ipOH];
		OH_S_HS_O_1          = hmrate(0.000000000066,0,0)*co.hevmol[ipOH];
		OH_S_SO_H_1          = hmrate(0.000000000066,0,0)*co.hevmol[ipOH];
		OH_N2O_HNO_NO_1      = hmrate(1.04E-17,4.33,12623)*co.hevmol[ipOH];
		OH_CS_OCS_H_1        = hmrate(0.0000000000000939,1.12,800)*co.hevmol[ipOH];
		NH3_CN_HCN_NH2_1     = hmrate(0.000000000026,-1.1,0)*co.hevmol[ipNH3];
		CN_NO_N2_CO_1        = hmrate(0.000000000179,0,4040)*co.hevmol[ipCN];
		CN_NO_OCN_N_1        = hmrate(0.000000000162,0,21205)*co.hevmol[ipCN];
		CN_HNO_NO_HCN_1      = hmrate(0.000000000015,0.5,0)*co.hevmol[ipCN];
		CN_O2_NO_CO_1        = hmrate(0.00000000000053,0,0)*co.hevmol[ipCN];
		CN_S_NS_C_1          = hmrate(0.0000000000571,0.5,32010)*co.hevmol[ipCN];
		CN_S_CS_N_1          = hmrate(0.0000000000173,0.5,0)*co.hevmol[ipCN];
		CO_HS_OCS_H_1        = hmrate(0.0000000000000595,1.12,8330)*co.hevmol[ipCO];
		N2_O2_N2O_O_1        = hmrate(0.0000000001,0,55200)*co.hevmol[ipN2];
		NO_NO_O2_N2_1        = hmrate(0.0000000000251,0,30653)*co.hevmol[ipNO];
		NO_NO_N2O_O_1        = hmrate(0.00000000000722,0,33155)*co.hevmol[ipNO];
		NO_HNO_N2O_OH_1      = hmrate(0.0000000000141,0,14890)*co.hevmol[ipNO];
		NO_S_NS_O_1          = hmrate(0.0000000000294,0.5,17465)*co.hevmol[ipNO];
		NO_S_SO_N_1          = hmrate(0.000000000175,0,20200)*co.hevmol[ipNO];
		O2_S_SO_O_1          = hmrate(0.00000000000228,0.52,0)*co.hevmol[ipO2];
		S_SO_S2_O_1          = hmrate(0.0000000000173,0.5,11500)*co.hevmol[ipATS];
		C_NHP_N_CHP_1        = hmrate(0.0000000016,0,0)*co.hevmol[ipATC];
		CP_NH_CNP_H_1        = hmrate(0.00000000078,0,0)*co.hevmol[ipCP];
		CP_NH2_HCNP_H_1      = hmrate(0.0000000011,0,0)*co.hevmol[ipCP];
		C_NH2P_NH_CHP_1      = hmrate(0.0000000012,0,0)*co.hevmol[ipATC];
		CP_NH3_HCNP_H2_1     = hmrate(0.00000000007,0,0)*co.hevmol[ipCP];
		C_NH3P_NH_CH2P_1     = hmrate(0.00000000001,0,0)*co.hevmol[ipATC];
		C_HCNP_CN_CHP_1      = hmrate(0.0000000011,0,0)*co.hevmol[ipATC];
		C_HNOP_NO_CHP_1      = hmrate(0.000000001,0,0)*co.hevmol[ipATC];
		CP_HS_CSP_H_1        = hmrate(0.0000000011,0,0)*co.hevmol[ipCP];
		C_HSP_CSP_H_1        = hmrate(0.00000000099,0,0)*co.hevmol[ipATC];
		CP_OCN_COP_CN_1      = hmrate(0.0000000038,0,0)*co.hevmol[ipCP];
		CP_NS_CSP_N_1        = hmrate(0.00000000076,0,0)*co.hevmol[ipCP];
		CP_H2CS_CS_CH2P_1    = hmrate(0.0000000015,0,0)*co.hevmol[ipCP];
		CP_SO_SP_CO_1        = hmrate(0.00000000026,0,0)*co.hevmol[ipCP];
		CP_SO_S_COP_1        = hmrate(0.00000000026,0,0)*co.hevmol[ipCP];
		CP_SO_CSP_O_1        = hmrate(0.00000000026,0,0)*co.hevmol[ipCP];
		CP_OCS_CSP_CO_1      = hmrate(0.0000000016,0,0)*co.hevmol[ipCP];
		CHP_N_CNP_H_1        = hmrate(0.00000000019,0,0)*co.hevmol[ipCHP];
		CH_NP_CNP_H_1        = hmrate(0.00000000036,0,0)*co.hevmol[ipCH];
		CH_NHP_CH2P_N_1      = hmrate(0.00000000099,0,0)*co.hevmol[ipCH];
		CHP_NH_CNP_H2_1      = hmrate(0.00000000076,0,0)*co.hevmol[ipCHP];
		CHP_NH2_HCNP_H2_1    = hmrate(0.0000000011,0,0)*co.hevmol[ipCHP];
		CH_NH2P_NH_CH2P_1    = hmrate(0.00000000035,0,0)*co.hevmol[ipCH];
		CHP_NH3_NH4P_C_1     = hmrate(0.000000000405,0,0)*co.hevmol[ipCHP];
		CH_NH3P_NH4P_C_1     = hmrate(0.00000000069,0,0)*co.hevmol[ipCH];
		CH_HCNP_CN_CH2P_1    = hmrate(0.00000000063,0,0)*co.hevmol[ipCH];
		CH_HNOP_NO_CH2P_1    = hmrate(0.00000000062,0,0)*co.hevmol[ipCH];
		CHP_S_HSP_C_1        = hmrate(0.00000000047,0,0)*co.hevmol[ipCHP];
		CHP_S_CSP_H_1        = hmrate(0.00000000047,0,0)*co.hevmol[ipCHP];
		CH_SP_CSP_H_1        = hmrate(0.00000000062,0,0)*co.hevmol[ipCH];
		CH_HSP_S_CH2P_1      = hmrate(0.00000000058,0,0)*co.hevmol[ipCH];
		CHP_OCS_HCSP_CO_1    = hmrate(0.00000000105,0,0)*co.hevmol[ipCHP];
		N_CH2P_HCNP_H_1      = hmrate(0.00000000022,0,0)*co.hevmol[ipATN];
		NP_NH_N2P_H_1        = hmrate(0.00000000037,0,0)*co.hevmol[ipNP];
		N_NHP_N2P_H_1        = hmrate(0.0000000013,0,0)*co.hevmol[ipATN];
		NP_CH4_HCNP_H2_H_1   = hmrate(0.000000000056,0,0)*co.hevmol[ipNP];
		N_OHP_NOP_H_1        = hmrate(0.00000000089,0,0)*co.hevmol[ipATN];
		NP_NH3_NH2P_NH_1     = hmrate(0.000000000216,0,0)*co.hevmol[ipNP];
		N_H2OP_HNOP_H_1      = hmrate(0.00000000019,0,0)*co.hevmol[ipATN];
		NP_CO_NOP_C_1        = hmrate(0.000000000145,0,0)*co.hevmol[ipNP];
		NP_NO_N2P_O_1        = hmrate(0.000000000079,0,0)*co.hevmol[ipNP];
		NP_O2_NO_OP_1        = hmrate(0.0000000000366,0,0)*co.hevmol[ipNP];
		NP_O2_NOP_O_1        = hmrate(0.000000000263,0,0)*co.hevmol[ipNP];
		N_O2P_NOP_O_1        = hmrate(0.00000000018,0,0)*co.hevmol[ipATN];
		N_HSP_NSP_H_1        = hmrate(0.00000000074,0,0)*co.hevmol[ipATN];
		N_SIOP_NOP_SI_1      = hmrate(0.00000000009,0,0)*co.hevmol[ipATN];
		N_SIOP_NO_SIP_1      = hmrate(0.00000000021,0,0)*co.hevmol[ipATN];
		N_SOP_NSP_O_1        = hmrate(0.00000000005,0,0)*co.hevmol[ipATN];
		NP_OCS_SP_CO_N_1     = hmrate(0.000000000308,0,0)*co.hevmol[ipNP];
		NP_OCS_CSP_NO_1      = hmrate(0.00000000007,0,0)*co.hevmol[ipNP];
		CH2_NHP_CH3P_N_1     = hmrate(0.0000000014,0,0)*co.hevmol[ipCH2];
		CH2_NH2P_CH3P_NH_1   = hmrate(0.00000000049,0,0)*co.hevmol[ipCH2];
		CH2P_NH3_NH4P_CH_1   = hmrate(0.00000000126,0,0)*co.hevmol[ipCH2P];
		CH2_NH3P_NH2_CH3P_1  = hmrate(0.00000000096,0,0)*co.hevmol[ipCH2];
		CH2_HCNP_CN_CH3P_1   = hmrate(0.00000000087,0,0)*co.hevmol[ipCH2];
		CH2_HNOP_NO_CH3P_1   = hmrate(0.00000000086,0,0)*co.hevmol[ipCH2];
		CH2P_S_HCSP_H_1      = hmrate(0.0000000014,0,0)*co.hevmol[ipCH2P];
		CH2_SP_HCSP_H_1      = hmrate(0.00000000001,0,0)*co.hevmol[ipCH2];
		NHP_NH_NH2P_N_1      = hmrate(0.000000001,0,0)*co.hevmol[ipNHP];
		NHP_O_OHP_N_1        = hmrate(0.000000001,0,0)*co.hevmol[ipNHP];
		NH_OP_NOP_H_1        = hmrate(0.00000000036,0,0)*co.hevmol[ipNH];
		NHP_NH2_NH3P_N_1     = hmrate(0.0000000015,0,0)*co.hevmol[ipNHP];
		NH_NH2P_NH3P_N_1     = hmrate(0.00000000073,0,0)*co.hevmol[ipNH];
		NHP_OH_H2OP_N_1      = hmrate(0.000000001,0,0)*co.hevmol[ipNHP];
		NH_OHP_NH2P_O_1      = hmrate(0.00000000036,0,0)*co.hevmol[ipNH];
		NHP_NH3_NH4P_N_1     = hmrate(0.0000000006,0,0)*co.hevmol[ipNHP];
		NH_NH3P_NH4P_N_1     = hmrate(0.00000000071,0,0)*co.hevmol[ipNH];
		NH_CH5P_CH4_NH2P_1   = hmrate(0.00000000071,0,0)*co.hevmol[ipNH];
		NHP_H2O_NH3P_O_1     = hmrate(0.000000000175,0,0)*co.hevmol[ipNHP];
		NHP_H2O_H3OP_N_1     = hmrate(0.00000000105,0,0)*co.hevmol[ipNHP];
		NHP_H2O_HNOP_H2_1    = hmrate(0.00000000035,0,0)*co.hevmol[ipNHP];
		NH_H2OP_H3OP_N_1     = hmrate(0.00000000071,0,0)*co.hevmol[ipNH];
		NHP_H2O_OH_NH2P_1    = hmrate(0.000000000875,0,0)*co.hevmol[ipNHP];
		NHP_CN_HCNP_N_1      = hmrate(0.0000000016,0,0)*co.hevmol[ipNHP];
		NH_HCNP_CN_NH2P_1    = hmrate(0.00000000065,0,0)*co.hevmol[ipNH];
		NHP_CO_HCOP_N_1      = hmrate(0.000000000441,0,0)*co.hevmol[ipNHP];
		NH_COP_HCOP_N_1      = hmrate(0.00000000032,0,0)*co.hevmol[ipNH];
		NHP_CO_OCNP_H_1      = hmrate(0.000000000539,0,0)*co.hevmol[ipNHP];
		NH_SIP_SINP_H_1      = hmrate(0.000000001,0,0)*co.hevmol[ipNH];
		NH_HCOP_CO_NH2P_1    = hmrate(0.00000000064,0,0)*co.hevmol[ipNH];
		NH_HNOP_NO_NH2P_1    = hmrate(0.00000000063,0,0)*co.hevmol[ipNH];
		NH_O2P_HNOP_O_1      = hmrate(0.00000000032,0,0)*co.hevmol[ipNH];
		NHP_O2_NOP_OH_1      = hmrate(0.000000000205,0,0)*co.hevmol[ipNHP];
		NH_O2P_NO2P_H_1      = hmrate(0.00000000032,0,0)*co.hevmol[ipNH];
		NHP_S_HSP_N_1        = hmrate(0.00000000069,0,0)*co.hevmol[ipNHP];
		NHP_S_NSP_H_1        = hmrate(0.00000000069,0,0)*co.hevmol[ipNHP];
		NH_SP_NSP_H_1        = hmrate(0.00000000063,0,0)*co.hevmol[ipNH];
		CH3P_NH2_CH4NP_H_1   = hmrate(0.000000001,0,0)*co.hevmol[ipCH3P];
		CH3P_NH3_NH4P_CH2_1  = hmrate(0.00000000034,0,0)*co.hevmol[ipCH3P];
		CH3P_S_HCSP_H2_1     = hmrate(0.0000000014,0,0)*co.hevmol[ipCH3P];
		O_NH2P_HNOP_H_1      = hmrate(0.000000000072,0,0)*co.hevmol[ipATO];
		O_NH3P_HNOP_H2_1     = hmrate(0.00000000001,0,0)*co.hevmol[ipATO];
		OP_CN_NOP_C_1        = hmrate(0.000000001,0,0)*co.hevmol[ipOP];
		OP_HCN_COP_NH_1      = hmrate(0.0000000012,0,0)*co.hevmol[ipOP];
		OP_HCN_NOP_CH_1      = hmrate(0.0000000012,0,0)*co.hevmol[ipOP];
		OP_HCN_HCOP_N_1      = hmrate(0.0000000012,0,0)*co.hevmol[ipOP];
		OP_N2_NOP_N_1        = hmrate(0.0000000000012,0,0)*co.hevmol[ipOP];
		O_N2P_NOP_N_1        = hmrate(0.00000000013,0,0)*co.hevmol[ipATO];
		O_HNOP_NO2P_H_1      = hmrate(0.000000000001,0,0)*co.hevmol[ipATO];
		O_HSP_SP_OH_1        = hmrate(0.00000000029,0,0)*co.hevmol[ipATO];
		O_HSP_SOP_H_1        = hmrate(0.00000000029,0,0)*co.hevmol[ipATO];
		O_SINP_SIOP_N_1      = hmrate(0.000000001,0,0)*co.hevmol[ipATO];
		OP_N2O_NOP_NO_1      = hmrate(0.00000000063,0,0)*co.hevmol[ipOP];
		O_CSP_S_COP_1        = hmrate(0.00000000006,0,0)*co.hevmol[ipATO];
		O_HCSP_S_HCOP_1      = hmrate(0.000000000005,0,0)*co.hevmol[ipATO];
		O_HCSP_OCSP_H_1      = hmrate(0.000000000005,0,0)*co.hevmol[ipATO];
		OP_NO2_O2_NOP_1      = hmrate(0.00000000083,0,0)*co.hevmol[ipOP];
		O_NSP_S_NOP_1        = hmrate(0.00000000061,0,0)*co.hevmol[ipATO];
		NH2P_NH2_NH3P_NH_1   = hmrate(0.000000001,0,0)*co.hevmol[ipNH2P];
		NH2_OHP_NH3P_O_1     = hmrate(0.0000000005,0,0)*co.hevmol[ipNH2];
		NH2P_OH_H2OP_NH_1    = hmrate(0.00000000071,0,0)*co.hevmol[ipNH2P];
		NH2P_NH3_NH4P_NH_1   = hmrate(0.00000000161,0,0)*co.hevmol[ipNH2P];
		NH2_NH3P_NH4P_NH_1   = hmrate(0.00000000001,0,0)*co.hevmol[ipNH2];
		NH2_CH5P_NH3P_CH4_1  = hmrate(0.00000000099,0,0)*co.hevmol[ipNH2];
		NH2P_H2O_NH3P_OH_1   = hmrate(0.0000000001,0,0)*co.hevmol[ipNH2P];
		NH2P_H2O_H3OP_NH_1   = hmrate(0.00000000276,0,0)*co.hevmol[ipNH2P];
		NH2_H2OP_NH3P_OH_1   = hmrate(0.00000000049,0,0)*co.hevmol[ipNH2];
		NH2P_H2O_NH4P_O_1    = hmrate(0.000000000145,0,0)*co.hevmol[ipNH2P];
		NH2_H3OP_H2O_NH3P_1  = hmrate(0.00000000097,0,0)*co.hevmol[ipNH2];
		NH2_HCNP_CN_NH3P_1   = hmrate(0.0000000009,0,0)*co.hevmol[ipNH2];
		NH2_COP_HCOP_NH_1    = hmrate(0.00000000045,0,0)*co.hevmol[ipNH2];
		NH2_HCOP_CO_NH3P_1   = hmrate(0.00000000089,0,0)*co.hevmol[ipNH2];
		NH2_HNOP_NO_NH3P_1   = hmrate(0.00000000088,0,0)*co.hevmol[ipNH2];
		NH2P_O2_HNOP_OH_1    = hmrate(0.000000000021,0,0)*co.hevmol[ipNH2P];
		NH2P_S_HSP_NH_1      = hmrate(0.00000000044,0,0)*co.hevmol[ipNH2P];
		CH4P_NH3_NH4P_CH3_1  = hmrate(0.00000000115,0,0)*co.hevmol[ipCH4P];
		CH4_NH3P_NH4P_CH3_1  = hmrate(0.00000000048,0,0)*co.hevmol[ipCH4];
		CH4_N2P_N2_CH2P_H2_1 = hmrate(0.00000000007,0,0)*co.hevmol[ipCH4];
		CH4_N2P_N2_CH3P_H_1  = hmrate(0.00000000093,0,0)*co.hevmol[ipCH4];
		CH4_HNOP_NO_CH5P_1   = hmrate(0.0000000001,0,0)*co.hevmol[ipCH4];
		CH4_SP_HCSP_H2_H_1   = hmrate(0.00000000002,0,0)*co.hevmol[ipCH4];
		CH4_CSP_HCSP_CH3_1   = hmrate(0.0000000005,0,0)*co.hevmol[ipCH4];
		OHP_NH3_NH4P_O_1     = hmrate(0.0000000012,0,0)*co.hevmol[ipOHP];
		OH_NH3P_NH4P_O_1     = hmrate(0.0000000007,0,0)*co.hevmol[ipOH];
		OHP_CN_HCNP_O_1      = hmrate(0.000000001,0,0)*co.hevmol[ipOHP];
		OH_HCNP_CN_H2OP_1    = hmrate(0.00000000063,0,0)*co.hevmol[ipOH];
		OHP_NO_HNOP_O_1      = hmrate(0.000000000611,0,0)*co.hevmol[ipOHP];
		OH_HNOP_NO_H2OP_1    = hmrate(0.00000000062,0,0)*co.hevmol[ipOH];
		OHP_S_HSP_O_1        = hmrate(0.00000000043,0,0)*co.hevmol[ipOHP];
		OHP_S_SOP_H_1        = hmrate(0.00000000043,0,0)*co.hevmol[ipOHP];
		OH_SP_SOP_H_1        = hmrate(0.00000000061,0,0)*co.hevmol[ipOH];
		NH3P_NH3_NH4P_NH2_1  = hmrate(0.0000000022,0,0)*co.hevmol[ipNH3P];
		NH3_CH5P_NH4P_CH4_1  = hmrate(0.0000000025,0,0)*co.hevmol[ipNH3];
		NH3P_H2O_NH4P_OH_1   = hmrate(0.00000000011,0,0)*co.hevmol[ipNH3P];
		NH3_H2OP_NH4P_OH_1   = hmrate(0.000000000945,0,0)*co.hevmol[ipNH3];
		NH3_H3OP_NH4P_H2O_1  = hmrate(0.0000000022,0,0)*co.hevmol[ipNH3];
		NH3_COP_HCOP_NH2_1   = hmrate(0.0000000000412,0,0)*co.hevmol[ipNH3];
		NH3_HCOP_CO_NH4P_1   = hmrate(0.0000000022,0,0)*co.hevmol[ipNH3];
		NH3_HNOP_NO_NH4P_1   = hmrate(0.0000000011,0,0)*co.hevmol[ipNH3];
		NH3_HSP_S_NH4P_1     = hmrate(0.000000000975,0,0)*co.hevmol[ipNH3];
		NH3_HCSP_CS_NH4P_1   = hmrate(0.000000002,0,0)*co.hevmol[ipNH3];
		CH5P_S_HSP_CH4_1     = hmrate(0.0000000013,0,0)*co.hevmol[ipCH5P];
		H2O_CNP_HCNP_OH_1    = hmrate(0.0000000016,0,0)*co.hevmol[ipH2O];
		H2O_CNP_HCOP_NH_1    = hmrate(0.00000000016,0,0)*co.hevmol[ipH2O];
		H2O_HCNP_CN_H3OP_1   = hmrate(0.0000000018,0,0)*co.hevmol[ipH2O];
		H2O_HNOP_NO_H3OP_1   = hmrate(0.0000000023,0,0)*co.hevmol[ipH2O];
		H2OP_S_HSP_OH_1      = hmrate(0.00000000043,0,0)*co.hevmol[ipH2OP];
		H2O_HSP_S_H3OP_1     = hmrate(0.00000000078,0,0)*co.hevmol[ipH2O];
		H3OP_CS_HCSP_H2O_1   = hmrate(0.000000001,0,0)*co.hevmol[ipH3OP];
		CNP_NO_OCNP_N_1      = hmrate(0.00000000019,0,0)*co.hevmol[ipCNP];
		CN_HNOP_NO_HCNP_1    = hmrate(0.00000000087,0,0)*co.hevmol[ipCN];
		CNP_O2_NOP_CO_1      = hmrate(0.000000000086,0,0)*co.hevmol[ipCNP];
		CNP_O2_OCNP_O_1      = hmrate(0.000000000086,0,0)*co.hevmol[ipCNP];
		HCNP_CO_HCOP_CN_1    = hmrate(0.00000000014,0,0)*co.hevmol[ipHCNP];
		HCNP_S_HSP_CN_1      = hmrate(0.00000000057,0,0)*co.hevmol[ipHCNP];
		CO_HNOP_NO_HCOP_1    = hmrate(0.0000000001,0,0)*co.hevmol[ipCO];
		N2P_OCS_SP_N2_CO_1   = hmrate(0.00000000104,0,0)*co.hevmol[ipN2P];
		HCOP_S_HSP_CO_1      = hmrate(0.00000000033,0,0)*co.hevmol[ipHCOP];
		HCOP_CS_HCSP_CO_1    = hmrate(0.0000000012,0,0)*co.hevmol[ipHCOP];
		HNOP_S_HSP_NO_1      = hmrate(0.0000000011,0,0)*co.hevmol[ipHNOP];
		O2_SP_SOP_O_1        = hmrate(0.000000000015,0,0)*co.hevmol[ipO2];
		O2P_S_SOP_O_1        = hmrate(0.00000000054,0,0)*co.hevmol[ipO2P];
		O2_CSP_OCSP_O_1      = hmrate(0.00000000013,0,0)*co.hevmol[ipO2];
		S_SIOP_SO_SIP_1      = hmrate(0.000000001,0,0)*co.hevmol[ipATS];
		CP_NH3_NH3P_C_1      = hmrate(0.000000000506,0,0)*co.hevmol[ipCP];
		C_CNP_CN_CP_1        = hmrate(0.00000000011,0,0)*co.hevmol[ipATC];
		C_N2P_N2_CP_1        = hmrate(0.00000000011,0,0)*co.hevmol[ipATC];
		CP_NO_NOP_C_1        = hmrate(0.00000000052,0,0)*co.hevmol[ipCP];
		CP_SIN_SINP_C_1      = hmrate(0.000000001,0,0)*co.hevmol[ipCP];
		C_CSP_CS_CP_1        = hmrate(0.0000000016,0,0)*co.hevmol[ipATC];
		CP_NS_NSP_C_1        = hmrate(0.00000000076,0,0)*co.hevmol[ipCP];
		CP_SO_SOP_C_1        = hmrate(0.00000000026,0,0)*co.hevmol[ipCP];
		CP_OCS_OCSP_C_1      = hmrate(0.0000000004,0,0)*co.hevmol[ipCP];
		CH_NH2P_NH2_CHP_1    = hmrate(0.00000000035,0,0)*co.hevmol[ipCH];
		CHP_NH3_NH3P_CH_1    = hmrate(0.000000000459,0,0)*co.hevmol[ipCHP];
		CH_CNP_CN_CHP_1      = hmrate(0.00000000064,0,0)*co.hevmol[ipCH];
		CH_N2P_N2_CHP_1      = hmrate(0.00000000063,0,0)*co.hevmol[ipCH];
		CHP_NO_NOP_CH_1      = hmrate(0.00000000076,0,0)*co.hevmol[ipCHP];
		NP_NH_NHP_N_1        = hmrate(0.00000000037,0,0)*co.hevmol[ipNP];
		NP_NH2_NH2P_N_1      = hmrate(0.000000001,0,0)*co.hevmol[ipNP];
		NP_NH3_NH3P_N_1      = hmrate(0.00000000197,0,0)*co.hevmol[ipNP];
		NP_CN_CNP_N_1        = hmrate(0.0000000011,0,0)*co.hevmol[ipNP];
		NP_HCN_HCNP_N_1      = hmrate(0.0000000012,0,0)*co.hevmol[ipNP];
		N_N2P_N2_NP_1        = hmrate(0.00000000001,0,0)*co.hevmol[ipATN];
		NP_NO_NOP_N_1        = hmrate(0.000000000451,0,0)*co.hevmol[ipNP];
		NP_OCS_OCSP_N_1      = hmrate(0.00000000102,0,0)*co.hevmol[ipNP];
		CH2_NH2P_NH2_CH2P_1  = hmrate(0.00000000049,0,0)*co.hevmol[ipCH2];
		CH2_CNP_CN_CH2P_1    = hmrate(0.00000000088,0,0)*co.hevmol[ipCH2];
		CH2_N2P_N2_CH2P_1    = hmrate(0.00000000087,0,0)*co.hevmol[ipCH2];
		CH2P_NO_NOP_CH2_1    = hmrate(0.00000000042,0,0)*co.hevmol[ipCH2P];
		NH_OP_O_NHP_1        = hmrate(0.00000000036,0,0)*co.hevmol[ipNH];
		NH_OHP_OH_NHP_1      = hmrate(0.00000000036,0,0)*co.hevmol[ipNH];
		NHP_NH3_NH3P_NH_1    = hmrate(0.0000000018,0,0)*co.hevmol[ipNHP];
		NHP_H2O_H2OP_NH_1    = hmrate(0.00000000105,0,0)*co.hevmol[ipNHP];
		NH_CNP_CN_NHP_1      = hmrate(0.00000000065,0,0)*co.hevmol[ipNH];
		NH_COP_CO_NHP_1      = hmrate(0.00000000032,0,0)*co.hevmol[ipNH];
		NH_N2P_N2_NHP_1      = hmrate(0.00000000065,0,0)*co.hevmol[ipNH];
		NHP_NO_NOP_NH_1      = hmrate(0.000000000712,0,0)*co.hevmol[ipNHP];
		NHP_O2_O2P_NH_1      = hmrate(0.000000000451,0,0)*co.hevmol[ipNHP];
		NHP_S_SP_NH_1        = hmrate(0.00000000069,0,0)*co.hevmol[ipNHP];
		CH3P_NO_NOP_CH3_1    = hmrate(0.000000001,0,0)*co.hevmol[ipCH3P];
		OP_NH2_NH2P_O_1      = hmrate(0.000000001,0,0)*co.hevmol[ipOP];
		OP_NH3_NH3P_O_1      = hmrate(0.0000000012,0,0)*co.hevmol[ipOP];
		O_CNP_CN_OP_1        = hmrate(0.000000000065,0,0)*co.hevmol[ipATO];
		O_HCNP_HCN_OP_1      = hmrate(0.000000000065,0,0)*co.hevmol[ipATO];
		O_N2P_N2_OP_1        = hmrate(0.00000000001,0,0)*co.hevmol[ipATO];
		OP_NO_NOP_O_1        = hmrate(0.0000000000017,0,0)*co.hevmol[ipOP];
		OP_OCS_OCSP_O_1      = hmrate(0.00000000065,0,0)*co.hevmol[ipOP];
		NH2_OHP_OH_NH2P_1    = hmrate(0.0000000005,0,0)*co.hevmol[ipNH2];
		NH2P_NH3_NH3P_NH2_1  = hmrate(0.00000000069,0,0)*co.hevmol[ipNH2P];
		NH2_H2OP_H2O_NH2P_1  = hmrate(0.00000000049,0,0)*co.hevmol[ipNH2];
		NH2_CNP_CN_NH2P_1    = hmrate(0.00000000091,0,0)*co.hevmol[ipNH2];
		NH2_COP_CO_NH2P_1    = hmrate(0.00000000045,0,0)*co.hevmol[ipNH2];
		NH2_N2P_N2_NH2P_1    = hmrate(0.00000000089,0,0)*co.hevmol[ipNH2];
		NH2P_NO_NOP_NH2_1    = hmrate(0.0000000007,0,0)*co.hevmol[ipNH2P];
		NH2_O2P_O2_NH2P_1    = hmrate(0.00000000087,0,0)*co.hevmol[ipNH2];
		NH2P_S_SP_NH2_1      = hmrate(0.00000000044,0,0)*co.hevmol[ipNH2P];
		CH4P_NH3_NH3P_CH4_1  = hmrate(0.00000000165,0,0)*co.hevmol[ipCH4P];
		CH4P_OCS_OCSP_CH4_1  = hmrate(0.00000000042,0,0)*co.hevmol[ipCH4P];
		OHP_NH3_NH3P_OH_1    = hmrate(0.0000000012,0,0)*co.hevmol[ipOHP];
		OH_CNP_CN_OHP_1      = hmrate(0.00000000064,0,0)*co.hevmol[ipOH];
		OH_N2P_N2_OHP_1      = hmrate(0.00000000063,0,0)*co.hevmol[ipOH];
		OHP_NO_NOP_OH_1      = hmrate(0.000000000359,0,0)*co.hevmol[ipOHP];
		NH3_H2OP_H2O_NH3P_1  = hmrate(0.00000000221,0,0)*co.hevmol[ipNH3];
		NH3_HCNP_HCN_NH3P_1  = hmrate(0.00000000168,0,0)*co.hevmol[ipNH3];
		NH3_COP_CO_NH3P_1    = hmrate(0.00000000202,0,0)*co.hevmol[ipNH3];
		NH3_N2P_N2_NH3P_1    = hmrate(0.0000000019,0,0)*co.hevmol[ipNH3];
		NH3P_SI_SIP_NH3_1    = hmrate(0.0000000019,0,0)*co.hevmol[ipNH3P];
		NH3P_NO_NOP_NH3_1    = hmrate(0.00000000072,0,0)*co.hevmol[ipNH3P];
		NH3_O2P_O2_NH3P_1    = hmrate(0.000000002,0,0)*co.hevmol[ipNH3];
		NH3_SP_S_NH3P_1      = hmrate(0.00000000144,0,0)*co.hevmol[ipNH3];
		NH3_HSP_HS_NH3P_1    = hmrate(0.000000000525,0,0)*co.hevmol[ipNH3];
		NH3_SOP_SO_NH3P_1    = hmrate(0.0000000013,0,0)*co.hevmol[ipNH3];
		H2O_HCNP_HCN_H2OP_1  = hmrate(0.0000000018,0,0)*co.hevmol[ipH2O];
		H2O_N2P_N2_H2OP_1    = hmrate(0.0000000023,0,0)*co.hevmol[ipH2O];
		H2OP_NO_NOP_H2O_1    = hmrate(0.00000000027,0,0)*co.hevmol[ipH2OP];
		CNP_HCN_HCNP_CN_1    = hmrate(0.00000000179,0,0)*co.hevmol[ipCNP];
		CNP_CO_COP_CN_1      = hmrate(0.00000000063,0,0)*co.hevmol[ipCNP];
		CN_N2P_N2_CNP_1      = hmrate(0.0000000001,0,0)*co.hevmol[ipCN];
		CNP_NO_NOP_CN_1      = hmrate(0.00000000057,0,0)*co.hevmol[ipCNP];
		CNP_O2_O2P_CN_1      = hmrate(0.000000000258,0,0)*co.hevmol[ipCNP];
		CNP_S_SP_CN_1        = hmrate(0.0000000011,0,0)*co.hevmol[ipCNP];
		HCN_COP_CO_HCNP_1    = hmrate(0.0000000034,0,0)*co.hevmol[ipHCN];
		HCN_N2P_N2_HCNP_1    = hmrate(0.00000000039,0,0)*co.hevmol[ipHCN];
		HCNP_NO_NOP_HCN_1    = hmrate(0.00000000081,0,0)*co.hevmol[ipHCNP];
		HCNP_O2_O2P_HCN_1    = hmrate(0.00000000032,0,0)*co.hevmol[ipHCNP];
		HCNP_S_SP_HCN_1      = hmrate(0.00000000057,0,0)*co.hevmol[ipHCNP];
		CO_N2P_N2_COP_1      = hmrate(0.000000000074,0,0)*co.hevmol[ipCO];
		COP_NO_NOP_CO_1      = hmrate(0.00000000033,0,0)*co.hevmol[ipCOP];
		N2P_NO_NOP_N2_1      = hmrate(0.00000000044,0,0)*co.hevmol[ipN2P];
		N2P_O2_O2P_N2_1      = hmrate(0.00000000005,0,0)*co.hevmol[ipN2P];
		N2P_S_SP_N2_1        = hmrate(0.0000000011,0,0)*co.hevmol[ipN2P];
		SI_NOP_NO_SIP_1      = hmrate(0.0000000016,0,0)*co.hevmol[ipATSI];
		SI_HSP_HS_SIP_1      = hmrate(0.0000000014,0,0)*co.hevmol[ipATSI];
		SI_CSP_CS_SIP_1      = hmrate(0.00000000015,0,0)*co.hevmol[ipATSI];
		NO_HNOP_HNO_NOP_1    = hmrate(0.0000000007,0,0)*co.hevmol[ipNO];
		NO_O2P_O2_NOP_1      = hmrate(0.00000000045,0,0)*co.hevmol[ipNO];
		NO_SP_S_NOP_1        = hmrate(0.00000000037,0,0)*co.hevmol[ipNO];
		NO_HSP_HS_NOP_1      = hmrate(0.00000000045,0,0)*co.hevmol[ipNO];
		NO_SIOP_SIO_NOP_1    = hmrate(0.00000000072,0,0)*co.hevmol[ipNO];
		NO_S2P_S2_NOP_1      = hmrate(0.00000000051,0,0)*co.hevmol[ipNO];
		O2P_NO2_NO2P_O2_1    = hmrate(0.00000000066,0,0)*co.hevmol[ipO2P];
		S_HSP_HS_SP_1        = hmrate(0.00000000097,0,0)*co.hevmol[ipATS];
		C_N_CN_NU_1          = hmrate(0.00000000000000001,0,0)*co.hevmol[ipATC];
		C_S_CS_NU_1          = hmrate(4.36E-19,0.22,0)*co.hevmol[ipATC];
		CP_S_CSP_NU_1        = hmrate(3.07E-19,0.15,0)*co.hevmol[ipCP];
		NP_N_N2P_NU_1        = hmrate(3.71E-18,0.24,26.1)*co.hevmol[ipNP];
		CO_S_OCS_NU_1        = hmrate(0.000000000000000016,-1.5,0)*co.hevmol[ipCO];
		CH_NP_N_CHP_1        = hmrate(0.00000000036,0,0)*co.hevmol[ipCH];
		CHP_S_SP_CH_1        = hmrate(0.00000000047,0,0)*co.hevmol[ipCHP];
		NP_CH2_CH2P_N_1      = hmrate(0.000000001,0,0)*co.hevmol[ipNP];
		NP_CH4_CH4P_N_1      = hmrate(0.000000000028,0,0)*co.hevmol[ipNP];
		NP_OH_OHP_N_1        = hmrate(0.00000000037,0,0)*co.hevmol[ipNP];
		NP_H2O_H2OP_N_1      = hmrate(0.0000000028,0,0)*co.hevmol[ipNP];
		NP_CO_COP_N_1        = hmrate(0.000000000825,0,0)*co.hevmol[ipNP];
		NP_O2_O2P_N_1        = hmrate(0.000000000311,0,0)*co.hevmol[ipNP];
		OP_O2_O2P_O_1        = hmrate(0.000000000019,0,0)*co.hevmol[ipOP];
		OHP_S_SP_OH_1        = hmrate(0.00000000043,0,0)*co.hevmol[ipOHP];
		H2OP_S_SP_H2O_1      = hmrate(0.00000000043,0,0)*co.hevmol[ipH2OP];
		COP_S_SP_CO_1        = hmrate(0.0000000011,0,0)*co.hevmol[ipCOP];
		SI_SP_S_SIP_1        = hmrate(0.0000000016,0,0)*co.hevmol[ipATSI];
		O2P_S_SP_O2_1        = hmrate(0.00000000054,0,0)*co.hevmol[ipO2P];



		C_NH_N_CH_2        = hmrate(0.0000000000173,0.5,4000)*co.hevmol[ipNH];
		C_NH_CN_H_2          = hmrate(0.00000000011,0.5,0)*co.hevmol[ipNH];
		C_N2_CN_N_2        = hmrate(0.0000000000869,0,22600)*co.hevmol[ipN2];
		C_NO_CN_O_2          = hmrate(0.000000000048,0,0)*co.hevmol[ipNO];
		C_NO_CO_N_2        = hmrate(0.0000000000465,0,0)*co.hevmol[ipNO];
		C_HS_S_CH_2          = hmrate(0.000000000012,0.58,5880)*co.hevmol[ipHS];
		C_HS_CS_H_2          = hmrate(0.00000000002,0,0)*co.hevmol[ipHS];
		C_OCN_CO_CN_2        = hmrate(0.00000000004,0.5,0)*co.hevmol[ipOCN];
		C_NS_S_CN_2          = hmrate(0.00000000002,0.5,0)*co.hevmol[ipNS];
		C_NS_CS_N_2        = hmrate(0.0000000000173,0.5,4000)*co.hevmol[ipNS];
		C_SO_S_CO_2          = hmrate(0.000000000072,0,0)*co.hevmol[ipSO];
		C_SO_CS_O_2          = hmrate(0.00000000017,0,0)*co.hevmol[ipSO];
		C_S2_CS_S_2          = hmrate(0.0000000000173,0.5,0)*co.hevmol[ipS2];
		CH_N_NH_C_2        = hmrate(0.0000000000303,0.65,1207)*co.hevmol[ipATN];
		CH_N_CN_H_2        = hmrate(0.000000000166,-0.09,0)*co.hevmol[ipATN];
		CH_N2_HCN_N_2      = hmrate(0.00000000000056,0.88,10128)*co.hevmol[ipN2];
		CH_NO_HCN_O_2        = hmrate(0.00000000559,0,10814)*co.hevmol[ipNO];
		CH_NO_CN_OH_2        = hmrate(2.32E-26,0,0)*co.hevmol[ipNO];
		CH_NO_OCN_H_2        = hmrate(1.13E-25,0,0)*co.hevmol[ipNO];
		CH_HNO_NO_CH2_2      = hmrate(0.0000000000173,0.5,0)*co.hevmol[ipHNO];
		CH_S_HS_C_2          = hmrate(0.0000000000173,0.5,4000)*co.hevmol[ipATS];
		CH_S_CS_H_2          = hmrate(0.0000000000011,0,0)*co.hevmol[ipATS];
		N_NH_N2_H_2        = hmrate(0.0000000000498,0,0)*co.hevmol[ipNH];
		N_CH3_HCN_H_H_2    = hmrate(0.000000000000332,0,0)*co.hevmol[ipCH3];
		N_CH3_HCN_H2_2     = hmrate(0.000000000013,0.5,0)*co.hevmol[ipCH3];
		N_OH_O_NH_2          = hmrate(0.0000000000188,0.1,10700)*co.hevmol[ipOH];
		N_OH_NO_H_2          = hmrate(0.0000000000532,-0.25,0)*co.hevmol[ipOH];
		N_CN_N2_C_2          = hmrate(0.0000000003,0,0)*co.hevmol[ipCN];
		N_SIH_SIN_H_2        = hmrate(0.00000000005,0.5,0)*co.hevmol[ipSIH];
		N_NO_N2_O_2          = hmrate(0.0000000000375,0,26)*co.hevmol[ipNO];
		N_HNO_NO_NH_2        = hmrate(0.00000000000294,0.5,1000)*co.hevmol[ipHNO];
		N_HNO_N2O_H_2        = hmrate(0.00000000000143,0.5,1500)*co.hevmol[ipHNO];
		N_O2_NO_O_2          = hmrate(0.00000000000226,0.86,3134)*co.hevmol[ipO2];
		N_HS_NS_H_2          = hmrate(0.0000000000173,0.5,0)*co.hevmol[ipHS];
		N_HS_S_NH_2          = hmrate(0.0000000000173,0.5,9060)*co.hevmol[ipHS];
		N_CS_S_CN_2          = hmrate(0.000000000038,0.5,1160)*co.hevmol[ipCS];
		N_NS_S_N2_2          = hmrate(0.0000000000173,0.5,0)*co.hevmol[ipNS];
		N_SO_NS_O_2          = hmrate(0.0000000000468,0.5,8254)*co.hevmol[ipSO];
		N_SO_S_NO_2          = hmrate(0.0000000000173,0.5,750)*co.hevmol[ipSO];
		N_S2_NS_S_2          = hmrate(0.0000000000173,0.5,4000)*co.hevmol[ipS2];
		CH2_CN_HCN_CH_2      = hmrate(0.0000000000053,0,2500)*co.hevmol[ipCN];
		CH2_NO_HCN_OH_2      = hmrate(0.000000000000832,0,1443)*co.hevmol[ipNO];
		CH2_HNO_NO_CH3_2     = hmrate(0.0000000000173,0.5,0)*co.hevmol[ipHNO];
		NH_NH_N2_H_H_2      = hmrate(0.00000000116,0,0)*co.hevmol[ipNH];
		NH_NH_N2_H2_2        = hmrate(0.000000000017,0,0)*co.hevmol[ipNH];
		NH_O_OH_N_2          = hmrate(0.0000000000116,0,0)*co.hevmol[ipATO];
		NH_O_NO_H_2          = hmrate(0.000000000116,0,0)*co.hevmol[ipATO];
		NH_OH_HNO_H_2        = hmrate(0.0000000000332,0,0)*co.hevmol[ipOH];
		NH_OH_NH2_O_2        = hmrate(0.00000000000293,0.1,5800)*co.hevmol[ipOH];
		NH_OH_H2O_N_2        = hmrate(0.00000000000311,1.2,0)*co.hevmol[ipOH];
		NH_H2O_OH_NH2_2      = hmrate(0.00000000000183,1.6,14090)*co.hevmol[ipH2O];
		NH_CN_HCN_N_2        = hmrate(0.00000000000294,0.5,1000)*co.hevmol[ipCN];
		NH_NO_N2O_H_2        = hmrate(0.000000000116,-1.03,420)*co.hevmol[ipNO];
		NH_NO_N2_O_H_2      = hmrate(0.00000000005,0,0)*co.hevmol[ipNO];
		NH_NO_N2_OH_2        = hmrate(0.0000000000146,-0.58,37)*co.hevmol[ipNO];
		NH_S_HS_N_2          = hmrate(0.0000000000173,0.5,4000)*co.hevmol[ipATS];
		NH_S_NS_H_2          = hmrate(0.0000000000173,0.5,0)*co.hevmol[ipATS];
		NH_NO2_HNO_NO_2      = hmrate(0.00000000000572,0.5,2500)*co.hevmol[ipNO2];
		NH_NO2_N2O_OH_2      = hmrate(0.000000000000144,0, 1140)*co.hevmol[ipNO2];
		CH3_NH3_CH4_NH2_2    = hmrate(0.0000000000000955,0,4890)*co.hevmol[ipNH3];
		CH3_CN_HCN_CH2_2     = hmrate(0.00000000000921,0.7,1500)*co.hevmol[ipCN];
		CH3_HNO_NO_CH4_2     = hmrate(0.0000000000144,0.5,0)*co.hevmol[ipHNO];
		O_NH2_OH_NH_2        = hmrate(0.0000000000139,0,40)*co.hevmol[ipNH2];
		O_NH2_NO_H2_2        = hmrate(0.0000000000083,0,0)*co.hevmol[ipNH2];
		O_NH3_OH_NH2_2       = hmrate(0.0000000000189,0,4003)*co.hevmol[ipNH3];
		O_CN_NO_C_2          = hmrate(0.0000000000381,0.5,14545)*co.hevmol[ipCN];
		O_CN_CO_N_2          = hmrate(0.0000000000436,0.46,364)*co.hevmol[ipCN];
		O_HCN_CN_OH_2        = hmrate(0.000000000621,0,12439)*co.hevmol[ipHCN];
		O_HCN_CO_NH_2        = hmrate(0.00000000000073,1.14,3742)*co.hevmol[ipHCN];
		O_HCN_OCN_H_2        = hmrate(0.00000000000136,1.38,3693)*co.hevmol[ipHCN];
		O_N2_NO_N_2          = hmrate(0.000000000251,0,38602)*co.hevmol[ipN2];
		O_NO_O2_N_2          = hmrate(0.0000000000118,0,20413)*co.hevmol[ipNO];
		O_HNO_NO_OH_2        = hmrate(0.00000000006,0,0)*co.hevmol[ipHNO];
		O_HNO_O2_NH_2        = hmrate(0.00000000000294,0.5,3500)*co.hevmol[ipHNO];
		O_HNO_NO2_H_2        = hmrate(0.00000000000144,0.5,0)*co.hevmol[ipHNO];
		O_HS_S_OH_2          = hmrate(0.0000000000174,0.67,956)*co.hevmol[ipHS];
		O_HS_SO_H_2          = hmrate(0.000000000232,0,0)*co.hevmol[ipHS];
		O_OCN_NO_CO_2        = hmrate(0.0000000000943,-0.09,100)*co.hevmol[ipOCN];
		O_OCN_O2_CN_2        = hmrate(0.000000000402,-1.43,3501)*co.hevmol[ipOCN];
		O_SIN_NO_SI_2        = hmrate(0.000000000025,0.5,0)*co.hevmol[ipSIN];
		O_SIN_SIO_N_2        = hmrate(0.0000000000575,0.1,200)*co.hevmol[ipSIN];
		O_N2O_NO_NO_2        = hmrate(0.000000000115,0,13400)*co.hevmol[ipN2O];
		O_N2O_O2_N2_2        = hmrate(0.000000000166,0,14100)*co.hevmol[ipN2O];
		O_CS_S_CO_2          = hmrate(0.000000000248,-0.65,783)*co.hevmol[ipCS];
		O_CS_SO_C_2          = hmrate(0.0000000000468,0.5,28940)*co.hevmol[ipCS];
		O_NS_S_NO_2          = hmrate(0.00000000005,0.5,0)*co.hevmol[ipNS];
		O_NS_SO_N_2          = hmrate(0.0000000000173,0.5,4000)*co.hevmol[ipNS];
		O_SO_S_O2_2          = hmrate(0.00000000000066,0,2760)*co.hevmol[ipSO];
		O_OCS_SO_CO_2        = hmrate(0.000000000016,0,2150)*co.hevmol[ipOCS];
		O_S2_SO_S_2          = hmrate(0.0000000000173,0.5,0)*co.hevmol[ipS2];
		NH2_OH_NH3_O_2       = hmrate(0.000000000000208,0.76,262)*co.hevmol[ipOH];
		NH2_OH_H2O_NH_2      = hmrate(0.0000000000015,0,0)*co.hevmol[ipOH];
		NH2_NO_N2_OH_H_2    = hmrate(0.00000000000149,0,0)*co.hevmol[ipNO];
		NH2_NO_N2_H2O_2      = hmrate(0.0000000000427,-2.5,331)*co.hevmol[ipNO];
		CH4_CN_HCN_CH3_2     = hmrate(0.00000000000314,1.53,504)*co.hevmol[ipCN];
		OH_NH3_H2O_NH2_2     = hmrate(0.000000000000147,2.05,7)*co.hevmol[ipNH3];
		OH_CN_HCN_O_2        = hmrate(0.00000000001,0,1000)*co.hevmol[ipCN];
		OH_CN_OCN_H_2        = hmrate(0.00000000007,0,0)*co.hevmol[ipCN];
		OH_HCN_CN_H2O_2      = hmrate(0.000000000000187,1.5,3887)*co.hevmol[ipHCN];
		OH_HCN_CO_NH2_2      = hmrate(0.000000000000107,0,5892)*co.hevmol[ipHCN];
		OH_NO_NO2_H_2        = hmrate(0.0000000000052,0,15100)*co.hevmol[ipNO];
		OH_S_HS_O_2          = hmrate(0.000000000066,0,0)*co.hevmol[ipATS];
		OH_S_SO_H_2          = hmrate(0.000000000066,0,0)*co.hevmol[ipATS];
		OH_N2O_HNO_NO_2      = hmrate(1.04E-17,4.33,12623)*co.hevmol[ipN2O];
		OH_CS_OCS_H_2        = hmrate(0.0000000000000939,1.12,800)*co.hevmol[ipCS];
		NH3_CN_HCN_NH2_2     = hmrate(0.000000000026,-1.1,0)*co.hevmol[ipCN];
		CN_NO_N2_CO_2        = hmrate(0.000000000179,0,4040)*co.hevmol[ipNO];
		CN_NO_OCN_N_2        = hmrate(0.000000000162,0,21205)*co.hevmol[ipNO];
		CN_HNO_NO_HCN_2      = hmrate(0.000000000015,0.5,0)*co.hevmol[ipHNO];
		CN_O2_NO_CO_2        = hmrate(0.00000000000053,0,0)*co.hevmol[ipO2];
		CN_S_NS_C_2          = hmrate(0.0000000000571,0.5,32010)*co.hevmol[ipATS];
		CN_S_CS_N_2          = hmrate(0.0000000000173,0.5,0)*co.hevmol[ipATS];
		CO_HS_OCS_H_2        = hmrate(0.0000000000000595,1.12,8330)*co.hevmol[ipHS];
		N2_O2_N2O_O_2        = hmrate(0.0000000001,0,55200)*co.hevmol[ipO2];
		NO_NO_O2_N2_2        = hmrate(0.0000000000251,0,30653)*co.hevmol[ipNO];
		NO_NO_N2O_O_2        = hmrate(0.00000000000722,0,33155)*co.hevmol[ipNO];
		NO_HNO_N2O_OH_2      = hmrate(0.0000000000141,0,14890)*co.hevmol[ipHNO];
		NO_S_NS_O_2          = hmrate(0.0000000000294,0.5,17465)*co.hevmol[ipATS];
		NO_S_SO_N_2          = hmrate(0.000000000175,0,20200)*co.hevmol[ipATS];
		O2_S_SO_O_2          = hmrate(0.00000000000228,0.52,0)*co.hevmol[ipATS];
		S_SO_S2_O_2          = hmrate(0.0000000000173,0.5,11500)*co.hevmol[ipSO];
		C_NHP_N_CHP_2        = hmrate(0.0000000016,0,0)*co.hevmol[ipNHP];
		CP_NH_CNP_H_2        = hmrate(0.00000000078,0,0)*co.hevmol[ipNH];
		CP_NH2_HCNP_H_2      = hmrate(0.0000000011,0,0)*co.hevmol[ipNH2];
		C_NH2P_NH_CHP_2      = hmrate(0.0000000012,0,0)*co.hevmol[ipNH2P];
		CP_NH3_HCNP_H2_2     = hmrate(0.00000000007,0,0)*co.hevmol[ipNH3];
		C_NH3P_NH_CH2P_2     = hmrate(0.00000000001,0,0)*co.hevmol[ipNH3P];
		C_HCNP_CN_CHP_2      = hmrate(0.0000000011,0,0)*co.hevmol[ipHCNP];
		C_HNOP_NO_CHP_2      = hmrate(0.000000001,0,0)*co.hevmol[ipHNOP];
		CP_HS_CSP_H_2        = hmrate(0.0000000011,0,0)*co.hevmol[ipHS];
		C_HSP_CSP_H_2        = hmrate(0.00000000099,0,0)*co.hevmol[ipHSP];
		CP_OCN_COP_CN_2      = hmrate(0.0000000038,0,0)*co.hevmol[ipOCN];
		CP_NS_CSP_N_2        = hmrate(0.00000000076,0,0)*co.hevmol[ipNS];
		CP_SO_SP_CO_2        = hmrate(0.00000000026,0,0)*co.hevmol[ipSO];
		CP_SO_S_COP_2        = hmrate(0.00000000026,0,0)*co.hevmol[ipSO];
		CP_SO_CSP_O_2        = hmrate(0.00000000026,0,0)*co.hevmol[ipSO];
		CP_OCS_CSP_CO_2      = hmrate(0.0000000016,0,0)*co.hevmol[ipOCS];
		CHP_N_CNP_H_2        = hmrate(0.00000000019,0,0)*co.hevmol[ipATN];
		CH_NP_N_CHP_2        = hmrate(0.00000000036,0,0)*co.hevmol[ipNP];
		CH_NP_CNP_H_2        = hmrate(0.00000000036,0,0)*co.hevmol[ipNP];
		CH_NHP_CH2P_N_2      = hmrate(0.00000000099,0,0)*co.hevmol[ipNHP];
		CHP_NH_CNP_H2_2      = hmrate(0.00000000076,0,0)*co.hevmol[ipNH];
		CHP_NH2_HCNP_H2_2    = hmrate(0.0000000011,0,0)*co.hevmol[ipNH2];
		CH_NH2P_NH_CH2P_2    = hmrate(0.00000000035,0,0)*co.hevmol[ipNH2P];
		CHP_NH3_NH4P_C_2     = hmrate(0.000000000405,0,0)*co.hevmol[ipNH3];
		CH_NH3P_NH4P_C_2     = hmrate(0.00000000069,0,0)*co.hevmol[ipNH3P];
		CH_HCNP_CN_CH2P_2    = hmrate(0.00000000063,0,0)*co.hevmol[ipHCNP];
		CH_HNOP_NO_CH2P_2    = hmrate(0.00000000062,0,0)*co.hevmol[ipHNOP];
		CHP_S_HSP_C_2        = hmrate(0.00000000047,0,0)*co.hevmol[ipATS];
		CHP_S_CSP_H_2        = hmrate(0.00000000047,0,0)*co.hevmol[ipATS];
		CH_SP_CSP_H_2        = hmrate(0.00000000062,0,0)*co.hevmol[ipSP];
		CH_HSP_S_CH2P_2      = hmrate(0.00000000058,0,0)*co.hevmol[ipHSP];
		CHP_OCS_HCSP_CO_2    = hmrate(0.00000000105,0,0)*co.hevmol[ipOCS];
		N_CH2P_HCNP_H_2      = hmrate(0.00000000022,0,0)*co.hevmol[ipCH2P];
		NP_NH_N2P_H_2        = hmrate(0.00000000037,0,0)*co.hevmol[ipNH];
		N_NHP_N2P_H_2        = hmrate(0.0000000013,0,0)*co.hevmol[ipNHP];
		NP_CH4_HCNP_H2_H_2   = hmrate(0.000000000056,0,0)*co.hevmol[ipCH4];
		N_OHP_NOP_H_2        = hmrate(0.00000000089,0,0)*co.hevmol[ipOHP];
		NP_NH3_NH2P_NH_2     = hmrate(0.000000000216,0,0)*co.hevmol[ipNH3];
		N_H2OP_HNOP_H_2      = hmrate(0.00000000019,0,0)*co.hevmol[ipH2OP];
		NP_CO_NOP_C_2        = hmrate(0.000000000145,0,0)*co.hevmol[ipCO];
		NP_NO_N2P_O_2        = hmrate(0.000000000079,0,0)*co.hevmol[ipNO];
		NP_O2_NO_OP_2        = hmrate(0.0000000000366,0,0)*co.hevmol[ipO2];
		NP_O2_NOP_O_2        = hmrate(0.000000000263,0,0)*co.hevmol[ipO2];
		N_O2P_NOP_O_2        = hmrate(0.00000000018,0,0)*co.hevmol[ipO2P];
		N_HSP_NSP_H_2        = hmrate(0.00000000074,0,0)*co.hevmol[ipHSP];
		N_SIOP_NOP_SI_2      = hmrate(0.00000000009,0,0)*co.hevmol[ipSIOP];
		N_SIOP_NO_SIP_2      = hmrate(0.00000000021,0,0)*co.hevmol[ipSIOP];
		N_SOP_NSP_O_2        = hmrate(0.00000000005,0,0)*co.hevmol[ipSOP];
		NP_OCS_SP_CO_N_2     = hmrate(0.000000000308,0,0)*co.hevmol[ipOCS];
		NP_OCS_CSP_NO_2      = hmrate(0.00000000007,0,0)*co.hevmol[ipOCS];
		CH2_NHP_CH3P_N_2     = hmrate(0.0000000014,0,0)*co.hevmol[ipNHP];
		CH2_NH2P_CH3P_NH_2   = hmrate(0.00000000049,0,0)*co.hevmol[ipNH2P];
		CH2P_NH3_NH4P_CH_2   = hmrate(0.00000000126,0,0)*co.hevmol[ipNH3];
		CH2_NH3P_NH2_CH3P_2  = hmrate(0.00000000096,0,0)*co.hevmol[ipNH3P];
		CH2_HCNP_CN_CH3P_2   = hmrate(0.00000000087,0,0)*co.hevmol[ipHCNP];
		CH2_HNOP_NO_CH3P_2   = hmrate(0.00000000086,0,0)*co.hevmol[ipHNOP];
		CH2P_S_HCSP_H_2      = hmrate(0.0000000014,0,0)*co.hevmol[ipATS];
		CH2_SP_HCSP_H_2      = hmrate(0.00000000001,0,0)*co.hevmol[ipSP];
		NHP_NH_NH2P_N_2      = hmrate(0.000000001,0,0)*co.hevmol[ipNH];
		NHP_O_OHP_N_2        = hmrate(0.000000001,0,0)*co.hevmol[ipATO];
		NH_OP_NOP_H_2        = hmrate(0.00000000036,0,0)*co.hevmol[ipOP];
		NHP_NH2_NH3P_N_2     = hmrate(0.0000000015,0,0)*co.hevmol[ipNH2];
		NH_NH2P_NH3P_N_2     = hmrate(0.00000000073,0,0)*co.hevmol[ipNH2P];
		NHP_OH_H2OP_N_2      = hmrate(0.000000001,0,0)*co.hevmol[ipOH];
		NH_OHP_NH2P_O_2      = hmrate(0.00000000036,0,0)*co.hevmol[ipOHP];
		NHP_NH3_NH4P_N_2     = hmrate(0.0000000006,0,0)*co.hevmol[ipNH3];
		NH_NH3P_NH4P_N_2     = hmrate(0.00000000071,0,0)*co.hevmol[ipNH3P];
		NH_CH5P_CH4_NH2P_2   = hmrate(0.00000000071,0,0)*co.hevmol[ipCH5P];
		NHP_H2O_NH3P_O_2     = hmrate(0.000000000175,0,0)*co.hevmol[ipH2O];
		NHP_H2O_H3OP_N_2     = hmrate(0.00000000105,0,0)*co.hevmol[ipH2O];
		NHP_H2O_HNOP_H2_2    = hmrate(0.00000000035,0,0)*co.hevmol[ipH2O];
		NH_H2OP_H3OP_N_2     = hmrate(0.00000000071,0,0)*co.hevmol[ipH2OP];
		NHP_H2O_OH_NH2P_2    = hmrate(0.000000000875,0,0)*co.hevmol[ipH2O];
		NHP_CN_HCNP_N_2      = hmrate(0.0000000016,0,0)*co.hevmol[ipCN];
		NH_HCNP_CN_NH2P_2    = hmrate(0.00000000065,0,0)*co.hevmol[ipHCNP];
		NHP_CO_HCOP_N_2      = hmrate(0.000000000441,0,0)*co.hevmol[ipCO];
		NH_COP_HCOP_N_2      = hmrate(0.00000000032,0,0)*co.hevmol[ipCOP];
		NHP_CO_OCNP_H_2      = hmrate(0.000000000539,0,0)*co.hevmol[ipCO];
		NH_SIP_SINP_H_2      = hmrate(0.000000001,0,0)*co.hevmol[ipSIP];
		NH_HCOP_CO_NH2P_2    = hmrate(0.00000000064,0,0)*co.hevmol[ipHCOP];
		NH_HNOP_NO_NH2P_2    = hmrate(0.00000000063,0,0)*co.hevmol[ipHNOP];
		NH_O2P_HNOP_O_2      = hmrate(0.00000000032,0,0)*co.hevmol[ipO2P];
		NHP_O2_NOP_OH_2      = hmrate(0.000000000205,0,0)*co.hevmol[ipO2];
		NH_O2P_NO2P_H_2      = hmrate(0.00000000032,0,0)*co.hevmol[ipO2P];
		NHP_S_HSP_N_2        = hmrate(0.00000000069,0,0)*co.hevmol[ipATS];
		NHP_S_NSP_H_2        = hmrate(0.00000000069,0,0)*co.hevmol[ipATS];
		NH_SP_NSP_H_2        = hmrate(0.00000000063,0,0)*co.hevmol[ipSP];
		CH3P_NH2_CH4NP_H_2   = hmrate(0.000000001,0,0)*co.hevmol[ipNH2];
		CH3P_NH3_NH4P_CH2_2  = hmrate(0.00000000034,0,0)*co.hevmol[ipNH3];
		CH3P_S_HCSP_H2_2     = hmrate(0.0000000014,0,0)*co.hevmol[ipATS];
		O_NH2P_HNOP_H_2      = hmrate(0.000000000072,0,0)*co.hevmol[ipNH2P];
		O_NH3P_HNOP_H2_2     = hmrate(0.00000000001,0,0)*co.hevmol[ipNH3P];
		OP_CN_NOP_C_2        = hmrate(0.000000001,0,0)*co.hevmol[ipCN];
		OP_HCN_COP_NH_2      = hmrate(0.0000000012,0,0)*co.hevmol[ipHCN];
		OP_HCN_NOP_CH_2      = hmrate(0.0000000012,0,0)*co.hevmol[ipHCN];
		OP_HCN_HCOP_N_2      = hmrate(0.0000000012,0,0)*co.hevmol[ipHCN];
		OP_N2_NOP_N_2        = hmrate(0.0000000000012,0,0)*co.hevmol[ipN2];
		O_N2P_NOP_N_2        = hmrate(0.00000000013,0,0)*co.hevmol[ipN2P];
		O_HNOP_NO2P_H_2      = hmrate(0.000000000001,0,0)*co.hevmol[ipHNOP];
		O_HSP_SP_OH_2        = hmrate(0.00000000029,0,0)*co.hevmol[ipHSP];
		O_HSP_SOP_H_2        = hmrate(0.00000000029,0,0)*co.hevmol[ipHSP];
		O_SINP_SIOP_N_2      = hmrate(0.000000001,0,0)*co.hevmol[ipSINP];
		OP_N2O_NOP_NO_2      = hmrate(0.00000000063,0,0)*co.hevmol[ipN2O];
		O_CSP_S_COP_2        = hmrate(0.00000000006,0,0)*co.hevmol[ipCSP];
		O_HCSP_S_HCOP_2      = hmrate(0.000000000005,0,0)*co.hevmol[ipHCSP];
		O_HCSP_OCSP_H_2      = hmrate(0.000000000005,0,0)*co.hevmol[ipHCSP];
		OP_NO2_O2_NOP_2      = hmrate(0.00000000083,0,0)*co.hevmol[ipNO2];
		O_NSP_S_NOP_2        = hmrate(0.00000000061,0,0)*co.hevmol[ipNSP];
		NH2P_NH2_NH3P_NH_2   = hmrate(0.000000001,0,0)*co.hevmol[ipNH2];
		NH2_OHP_NH3P_O_2     = hmrate(0.0000000005,0,0)*co.hevmol[ipOHP];
		NH2P_OH_H2OP_NH_2    = hmrate(0.00000000071,0,0)*co.hevmol[ipOH];
		NH2P_NH3_NH4P_NH_2   = hmrate(0.00000000161,0,0)*co.hevmol[ipNH3];
		NH2_NH3P_NH4P_NH_2   = hmrate(0.00000000001,0,0)*co.hevmol[ipNH3P];
		NH2_CH5P_NH3P_CH4_2  = hmrate(0.00000000099,0,0)*co.hevmol[ipCH5P];
		NH2P_H2O_NH3P_OH_2   = hmrate(0.0000000001,0,0)*co.hevmol[ipH2O];
		NH2P_H2O_H3OP_NH_2   = hmrate(0.00000000276,0,0)*co.hevmol[ipH2O];
		NH2_H2OP_NH3P_OH_2   = hmrate(0.00000000049,0,0)*co.hevmol[ipH2OP];
		NH2P_H2O_NH4P_O_2    = hmrate(0.000000000145,0,0)*co.hevmol[ipH2O];
		NH2_H3OP_H2O_NH3P_2  = hmrate(0.00000000097,0,0)*co.hevmol[ipH3OP];
		NH2_HCNP_CN_NH3P_2   = hmrate(0.0000000009,0,0)*co.hevmol[ipHCNP];
		NH2_COP_HCOP_NH_2    = hmrate(0.00000000045,0,0)*co.hevmol[ipCOP];
		NH2_HCOP_CO_NH3P_2   = hmrate(0.00000000089,0,0)*co.hevmol[ipHCOP];
		NH2_HNOP_NO_NH3P_2   = hmrate(0.00000000088,0,0)*co.hevmol[ipHNOP];
		NH2P_O2_HNOP_OH_2    = hmrate(0.000000000021,0,0)*co.hevmol[ipO2];
		NH2P_S_HSP_NH_2      = hmrate(0.00000000044,0,0)*co.hevmol[ipATS];
		CH4P_NH3_NH4P_CH3_2  = hmrate(0.00000000115,0,0)*co.hevmol[ipNH3];
		CH4_NH3P_NH4P_CH3_2  = hmrate(0.00000000048,0,0)*co.hevmol[ipNH3P];
		CH4_N2P_N2_CH2P_H2_2 = hmrate(0.00000000007,0,0)*co.hevmol[ipN2P];
		CH4_N2P_N2_CH3P_H_2  = hmrate(0.00000000093,0,0)*co.hevmol[ipN2P];
		CH4_HNOP_NO_CH5P_2   = hmrate(0.0000000001,0,0)*co.hevmol[ipHNOP];
		CH4_SP_HCSP_H2_H_2   = hmrate(0.00000000002,0,0)*co.hevmol[ipSP];
		CH4_CSP_HCSP_CH3_2   = hmrate(0.0000000005,0,0)*co.hevmol[ipCSP];
		OHP_NH3_NH4P_O_2     = hmrate(0.0000000012,0,0)*co.hevmol[ipNH3];
		OH_NH3P_NH4P_O_2     = hmrate(0.0000000007,0,0)*co.hevmol[ipNH3P];
		OHP_CN_HCNP_O_2      = hmrate(0.000000001,0,0)*co.hevmol[ipCN];
		OH_HCNP_CN_H2OP_2    = hmrate(0.00000000063,0,0)*co.hevmol[ipHCNP];
		OHP_NO_HNOP_O_2      = hmrate(0.000000000611,0,0)*co.hevmol[ipNO];
		OH_HNOP_NO_H2OP_2    = hmrate(0.00000000062,0,0)*co.hevmol[ipHNOP];
		OHP_S_HSP_O_2        = hmrate(0.00000000043,0,0)*co.hevmol[ipATS];
		OHP_S_SOP_H_2        = hmrate(0.00000000043,0,0)*co.hevmol[ipATS];
		OH_SP_SOP_H_2        = hmrate(0.00000000061,0,0)*co.hevmol[ipSP];
		NH3P_NH3_NH4P_NH2_2  = hmrate(0.0000000022,0,0)*co.hevmol[ipNH3];
		NH3_CH5P_NH4P_CH4_2  = hmrate(0.0000000025,0,0)*co.hevmol[ipCH5P];
		NH3P_H2O_NH4P_OH_2   = hmrate(0.00000000011,0,0)*co.hevmol[ipH2O];
		NH3_H2OP_NH4P_OH_2   = hmrate(0.000000000945,0,0)*co.hevmol[ipH2OP];
		NH3_H3OP_NH4P_H2O_2  = hmrate(0.0000000022,0,0)*co.hevmol[ipH3OP];
		NH3_COP_HCOP_NH2_2   = hmrate(0.0000000000412,0,0)*co.hevmol[ipCOP];
		NH3_HCOP_CO_NH4P_2   = hmrate(0.0000000022,0,0)*co.hevmol[ipHCOP];
		NH3_HNOP_NO_NH4P_2   = hmrate(0.0000000011,0,0)*co.hevmol[ipHNOP];
		NH3_HSP_S_NH4P_2     = hmrate(0.000000000975,0,0)*co.hevmol[ipHSP];
		NH3_HCSP_CS_NH4P_2   = hmrate(0.000000002,0,0)*co.hevmol[ipHCSP];
		CH5P_S_HSP_CH4_2     = hmrate(0.0000000013,0,0)*co.hevmol[ipATS];
		H2O_CNP_HCNP_OH_2    = hmrate(0.0000000016,0,0)*co.hevmol[ipCNP];
		H2O_CNP_HCOP_NH_2    = hmrate(0.00000000016,0,0)*co.hevmol[ipCNP];
		H2O_HCNP_CN_H3OP_2   = hmrate(0.0000000018,0,0)*co.hevmol[ipHCNP];
		H2O_HNOP_NO_H3OP_2   = hmrate(0.0000000023,0,0)*co.hevmol[ipHNOP];
		H2OP_S_HSP_OH_2      = hmrate(0.00000000043,0,0)*co.hevmol[ipATS];
		H2O_HSP_S_H3OP_2     = hmrate(0.00000000078,0,0)*co.hevmol[ipHSP];
		H3OP_CS_HCSP_H2O_2   = hmrate(0.000000001,0,0)*co.hevmol[ipCS];
		CNP_NO_OCNP_N_2      = hmrate(0.00000000019,0,0)*co.hevmol[ipNO];
		CN_HNOP_NO_HCNP_2    = hmrate(0.00000000087,0,0)*co.hevmol[ipHNOP];
		CNP_O2_NOP_CO_2      = hmrate(0.000000000086,0,0)*co.hevmol[ipO2];
		CNP_O2_OCNP_O_2      = hmrate(0.000000000086,0,0)*co.hevmol[ipO2];
		HCNP_CO_HCOP_CN_2    = hmrate(0.00000000014,0,0)*co.hevmol[ipCO];
		HCNP_S_HSP_CN_2      = hmrate(0.00000000057,0,0)*co.hevmol[ipATS];
		CO_HNOP_NO_HCOP_2    = hmrate(0.0000000001,0,0)*co.hevmol[ipHNOP];
		N2P_OCS_SP_N2_CO_2   = hmrate(0.00000000104,0,0)*co.hevmol[ipOCS];
		HCOP_S_HSP_CO_2      = hmrate(0.00000000033,0,0)*co.hevmol[ipATS];
		HCOP_CS_HCSP_CO_2    = hmrate(0.0000000012,0,0)*co.hevmol[ipCS];
		HNOP_S_HSP_NO_2      = hmrate(0.0000000011,0,0)*co.hevmol[ipATS];
		O2_SP_SOP_O_2        = hmrate(0.000000000015,0,0)*co.hevmol[ipSP];
		O2P_S_SOP_O_2        = hmrate(0.00000000054,0,0)*co.hevmol[ipATS];
		O2_CSP_OCSP_O_2      = hmrate(0.00000000013,0,0)*co.hevmol[ipCSP];
		S_SIOP_SO_SIP_2      = hmrate(0.000000001,0,0)*co.hevmol[ipSIOP];
		CP_NH3_NH3P_C_2      = hmrate(0.000000000506,0,0)*co.hevmol[ipNH3];
		C_CNP_CN_CP_2        = hmrate(0.00000000011,0,0)*co.hevmol[ipCNP];
		C_N2P_N2_CP_2        = hmrate(0.00000000011,0,0)*co.hevmol[ipN2P];
		CP_NO_NOP_C_2        = hmrate(0.00000000052,0,0)*co.hevmol[ipNO];
		CP_SIN_SINP_C_2      = hmrate(0.000000001,0,0)*co.hevmol[ipSIN];
		C_CSP_CS_CP_2        = hmrate(0.0000000016,0,0)*co.hevmol[ipCSP];
		CP_NS_NSP_C_2        = hmrate(0.00000000076,0,0)*co.hevmol[ipNS];
		CP_SO_SOP_C_2        = hmrate(0.00000000026,0,0)*co.hevmol[ipSO];
		CP_OCS_OCSP_C_2      = hmrate(0.0000000004,0,0)*co.hevmol[ipOCS];
		CH_NH2P_NH2_CHP_2    = hmrate(0.00000000035,0,0)*co.hevmol[ipNH2P];
		CHP_NH3_NH3P_CH_2    = hmrate(0.000000000459,0,0)*co.hevmol[ipNH3];
		CH_CNP_CN_CHP_2      = hmrate(0.00000000064,0,0)*co.hevmol[ipCNP];
		CH_N2P_N2_CHP_2      = hmrate(0.00000000063,0,0)*co.hevmol[ipN2P];
		CHP_NO_NOP_CH_2      = hmrate(0.00000000076,0,0)*co.hevmol[ipNO];
		NP_NH_NHP_N_2        = hmrate(0.00000000037,0,0)*co.hevmol[ipNH];
		NP_NH2_NH2P_N_2      = hmrate(0.000000001,0,0)*co.hevmol[ipNH2];
		NP_NH3_NH3P_N_2      = hmrate(0.00000000197,0,0)*co.hevmol[ipNH3];
		NP_CN_CNP_N_2        = hmrate(0.0000000011,0,0)*co.hevmol[ipCN];
		NP_HCN_HCNP_N_2      = hmrate(0.0000000012,0,0)*co.hevmol[ipHCN];
		N_N2P_N2_NP_2        = hmrate(0.00000000001,0,0)*co.hevmol[ipN2P];
		NP_NO_NOP_N_2        = hmrate(0.000000000451,0,0)*co.hevmol[ipNO];
		NP_OCS_OCSP_N_2      = hmrate(0.00000000102,0,0)*co.hevmol[ipOCS];
		CH2_NH2P_NH2_CH2P_2  = hmrate(0.00000000049,0,0)*co.hevmol[ipNH2P];
		CH2_CNP_CN_CH2P_2    = hmrate(0.00000000088,0,0)*co.hevmol[ipCNP];
		CH2_N2P_N2_CH2P_2    = hmrate(0.00000000087,0,0)*co.hevmol[ipN2P];
		CH2P_NO_NOP_CH2_2    = hmrate(0.00000000042,0,0)*co.hevmol[ipNO];
		NH_OP_O_NHP_2        = hmrate(0.00000000036,0,0)*co.hevmol[ipOP];
		NH_OHP_OH_NHP_2      = hmrate(0.00000000036,0,0)*co.hevmol[ipOHP];
		NHP_NH3_NH3P_NH_2    = hmrate(0.0000000018,0,0)*co.hevmol[ipNH3];
		NHP_H2O_H2OP_NH_2    = hmrate(0.00000000105,0,0)*co.hevmol[ipH2O];
		NH_CNP_CN_NHP_2      = hmrate(0.00000000065,0,0)*co.hevmol[ipCNP];
		NH_COP_CO_NHP_2      = hmrate(0.00000000032,0,0)*co.hevmol[ipCOP];
		NH_N2P_N2_NHP_2      = hmrate(0.00000000065,0,0)*co.hevmol[ipN2P];
		NHP_NO_NOP_NH_2      = hmrate(0.000000000712,0,0)*co.hevmol[ipNO];
		NHP_O2_O2P_NH_2      = hmrate(0.000000000451,0,0)*co.hevmol[ipO2];
		NHP_S_SP_NH_2        = hmrate(0.00000000069,0,0)*co.hevmol[ipATS];
		CH3P_NO_NOP_CH3_2    = hmrate(0.000000001,0,0)*co.hevmol[ipNO];
		OP_NH2_NH2P_O_2      = hmrate(0.000000001,0,0)*co.hevmol[ipNH2];
		OP_NH3_NH3P_O_2      = hmrate(0.0000000012,0,0)*co.hevmol[ipNH3];
		O_CNP_CN_OP_2        = hmrate(0.000000000065,0,0)*co.hevmol[ipCNP];
		O_HCNP_HCN_OP_2      = hmrate(0.000000000065,0,0)*co.hevmol[ipHCNP];
		O_N2P_N2_OP_2        = hmrate(0.00000000001,0,0)*co.hevmol[ipN2P];
		OP_NO_NOP_O_2        = hmrate(0.0000000000017,0,0)*co.hevmol[ipNO];
		OP_OCS_OCSP_O_2      = hmrate(0.00000000065,0,0)*co.hevmol[ipOCS];
		NH2_OHP_OH_NH2P_2    = hmrate(0.0000000005,0,0)*co.hevmol[ipOHP];
		NH2P_NH3_NH3P_NH2_2  = hmrate(0.00000000069,0,0)*co.hevmol[ipNH3];
		NH2_H2OP_H2O_NH2P_2  = hmrate(0.00000000049,0,0)*co.hevmol[ipH2OP];
		NH2_CNP_CN_NH2P_2    = hmrate(0.00000000091,0,0)*co.hevmol[ipCNP];
		NH2_COP_CO_NH2P_2    = hmrate(0.00000000045,0,0)*co.hevmol[ipCOP];
		NH2_N2P_N2_NH2P_2    = hmrate(0.00000000089,0,0)*co.hevmol[ipN2P];
		NH2P_NO_NOP_NH2_2    = hmrate(0.0000000007,0,0)*co.hevmol[ipNO];
		NH2_O2P_O2_NH2P_2    = hmrate(0.00000000087,0,0)*co.hevmol[ipO2P];
		NH2P_S_SP_NH2_2      = hmrate(0.00000000044,0,0)*co.hevmol[ipATS];
		CH4P_NH3_NH3P_CH4_2  = hmrate(0.00000000165,0,0)*co.hevmol[ipNH3];
		CH4P_OCS_OCSP_CH4_2  = hmrate(0.00000000042,0,0)*co.hevmol[ipOCS];
		OHP_NH3_NH3P_OH_2    = hmrate(0.0000000012,0,0)*co.hevmol[ipNH3];
		OH_CNP_CN_OHP_2      = hmrate(0.00000000064,0,0)*co.hevmol[ipCNP];
		OH_N2P_N2_OHP_2      = hmrate(0.00000000063,0,0)*co.hevmol[ipN2P];
		OHP_NO_NOP_OH_2      = hmrate(0.000000000359,0,0)*co.hevmol[ipNO];
		NH3_H2OP_H2O_NH3P_2  = hmrate(0.00000000221,0,0)*co.hevmol[ipH2OP];
		NH3_HCNP_HCN_NH3P_2  = hmrate(0.00000000168,0,0)*co.hevmol[ipHCNP];
		NH3_COP_CO_NH3P_2    = hmrate(0.00000000202,0,0)*co.hevmol[ipCOP];
		NH3_N2P_N2_NH3P_2    = hmrate(0.0000000019,0,0)*co.hevmol[ipN2P];
		NH3P_SI_SIP_NH3_2    = hmrate(0.0000000019,0,0)*co.hevmol[ipATSI];
		NH3P_NO_NOP_NH3_2    = hmrate(0.00000000072,0,0)*co.hevmol[ipNO];
		NH3_O2P_O2_NH3P_2    = hmrate(0.000000002,0,0)*co.hevmol[ipO2P];
		NH3_SP_S_NH3P_2      = hmrate(0.00000000144,0,0)*co.hevmol[ipSP];
		NH3_HSP_HS_NH3P_2    = hmrate(0.000000000525,0,0)*co.hevmol[ipHSP];
		NH3_SOP_SO_NH3P_2    = hmrate(0.0000000013,0,0)*co.hevmol[ipSOP];
		H2O_HCNP_HCN_H2OP_2  = hmrate(0.0000000018,0,0)*co.hevmol[ipHCNP];
		H2O_N2P_N2_H2OP_2    = hmrate(0.0000000023,0,0)*co.hevmol[ipN2P];
		H2OP_NO_NOP_H2O_2    = hmrate(0.00000000027,0,0)*co.hevmol[ipNO];
		CNP_HCN_HCNP_CN_2    = hmrate(0.00000000179,0,0)*co.hevmol[ipHCN];
		CNP_CO_COP_CN_2      = hmrate(0.00000000063,0,0)*co.hevmol[ipCO];
		CN_N2P_N2_CNP_2      = hmrate(0.0000000001,0,0)*co.hevmol[ipN2P];
		CNP_NO_NOP_CN_2      = hmrate(0.00000000057,0,0)*co.hevmol[ipNO];
		CNP_O2_O2P_CN_2      = hmrate(0.000000000258,0,0)*co.hevmol[ipO2];
		CNP_S_SP_CN_2        = hmrate(0.0000000011,0,0)*co.hevmol[ipATS];
		HCN_COP_CO_HCNP_2    = hmrate(0.0000000034,0,0)*co.hevmol[ipCOP];
		HCN_N2P_N2_HCNP_2    = hmrate(0.00000000039,0,0)*co.hevmol[ipN2P];
		HCNP_NO_NOP_HCN_2    = hmrate(0.00000000081,0,0)*co.hevmol[ipNO];
		HCNP_O2_O2P_HCN_2    = hmrate(0.00000000032,0,0)*co.hevmol[ipO2];
		HCNP_S_SP_HCN_2      = hmrate(0.00000000057,0,0)*co.hevmol[ipATS];
		CO_N2P_N2_COP_2      = hmrate(0.000000000074,0,0)*co.hevmol[ipN2P];
		COP_NO_NOP_CO_2      = hmrate(0.00000000033,0,0)*co.hevmol[ipNO];
		N2P_NO_NOP_N2_2      = hmrate(0.00000000044,0,0)*co.hevmol[ipNO];
		N2P_O2_O2P_N2_2      = hmrate(0.00000000005,0,0)*co.hevmol[ipO2];
		N2P_S_SP_N2_2        = hmrate(0.0000000011,0,0)*co.hevmol[ipATS];
		SI_NOP_NO_SIP_2      = hmrate(0.0000000016,0,0)*co.hevmol[ipNOP];
		SI_HSP_HS_SIP_2      = hmrate(0.0000000014,0,0)*co.hevmol[ipHSP];
		SI_CSP_CS_SIP_2      = hmrate(0.00000000015,0,0)*co.hevmol[ipCSP];
		NO_HNOP_HNO_NOP_2    = hmrate(0.0000000007,0,0)*co.hevmol[ipHNOP];
		NO_O2P_O2_NOP_2      = hmrate(0.00000000045,0,0)*co.hevmol[ipO2P];
		NO_SP_S_NOP_2        = hmrate(0.00000000037,0,0)*co.hevmol[ipSP];
		NO_HSP_HS_NOP_2      = hmrate(0.00000000045,0,0)*co.hevmol[ipHSP];
		NO_SIOP_SIO_NOP_2    = hmrate(0.00000000072,0,0)*co.hevmol[ipSIOP];
		NO_S2P_S2_NOP_2      = hmrate(0.00000000051,0,0)*co.hevmol[ipS2P];
		O2P_NO2_NO2P_O2_2    = hmrate(0.00000000066,0,0)*co.hevmol[ipNO2];
		S_HSP_HS_SP_2        = hmrate(0.00000000097,0,0)*co.hevmol[ipHSP];
		C_N_CN_NU_2          = hmrate(0.00000000000000001,0,0)*co.hevmol[ipATN];
		C_S_CS_NU_2          = hmrate(4.36E-19,0.22,0)*co.hevmol[ipATS];
		CP_S_CSP_NU_2        = hmrate(3.07E-19,0.15,0)*co.hevmol[ipATS];
		NP_N_N2P_NU_2        = hmrate(3.71E-18,0.24,26.1)*co.hevmol[ipATN];
		CO_S_OCS_NU_2        = hmrate(0.000000000000000016,-1.5,0)*co.hevmol[ipATS];
		CHP_S_SP_CH_2        = hmrate(0.00000000047,0,0)*co.hevmol[ipATS];
		NP_CH2_CH2P_N_2      = hmrate(0.000000001,0,0)*co.hevmol[ipCH2];
		NP_CH4_CH4P_N_2      = hmrate(0.000000000028,0,0)*co.hevmol[ipCH4];
		NP_OH_OHP_N_2        = hmrate(0.00000000037,0,0)*co.hevmol[ipOH];
		NP_H2O_H2OP_N_2      = hmrate(0.0000000028,0,0)*co.hevmol[ipH2O];
		NP_CO_COP_N_2        = hmrate(0.000000000825,0,0)*co.hevmol[ipCO];
		NP_O2_O2P_N_2        = hmrate(0.000000000311,0,0)*co.hevmol[ipO2];
		OP_O2_O2P_O_2        = hmrate(0.000000000019,0,0)*co.hevmol[ipO2];
		OHP_S_SP_OH_2        = hmrate(0.00000000043,0,0)*co.hevmol[ipATS];
		H2OP_S_SP_H2O_2      = hmrate(0.00000000043,0,0)*co.hevmol[ipATS];
		COP_S_SP_CO_2        = hmrate(0.0000000011,0,0)*co.hevmol[ipATS];
		SI_SP_S_SIP_2        = hmrate(0.0000000016,0,0)*co.hevmol[ipSP];
		O2P_S_SP_O2_2        = hmrate(0.00000000054,0,0)*co.hevmol[ipATS];



		H2_N_NH_H           = hmrate(0.00000000169,0,18095)*hmi.Hmolec[ipMH2g];
		H2_NH_NH2_H         = hmrate(0.0000000000596,0,7782)*hmi.Hmolec[ipMH2g];
		H2_NH2_NH3_H        = hmrate(0.00000000000000205,3.89,1400)*hmi.Hmolec[ipMH2g];
		H2_CN_HCN_H         = hmrate(0.000000000000404,2.87,820)*hmi.Hmolec[ipMH2g];
		HP_HNO_NOP_H2       = hmrate(0.000000004,0,0)*dense.xIonDense[ipHYDROGEN][1];
		HP_HS_SP_H2         = hmrate(0.0000000016,0,0)*dense.xIonDense[ipHYDROGEN][1];
		H_HSP_SP_H2         = hmrate(0.00000000011,0,0)*dense.xIonDense[ipHYDROGEN][0];
		HP_OCS_HSP_CO       = hmrate(0.0000000021,0,0)*dense.xIonDense[ipHYDROGEN][1];
		H2P_N_NHP_H         = hmrate(0.0000000019,0,0)*hmi.Hmolec[ipMH2p];
		H2_NP_NHP_H         = hmrate(0.000000001,0,85)*hmi.Hmolec[ipMH2g];
		H2_NHP_N_H3P        = hmrate(0.000000000225,0,0)*hmi.Hmolec[ipMH2g];
		H2P_NH_NH2P_H       = hmrate(0.00000000076,0,0)*hmi.Hmolec[ipMH2p];
		H2_NHP_NH2P_H       = hmrate(0.00000000128,0,0)*hmi.Hmolec[ipMH2g];
		H2_NH2P_NH3P_H      = hmrate(0.00000000027,0,0)*hmi.Hmolec[ipMH2g];
		H2_NH3P_NH4P_H      = hmrate(0.0000000000002,0,0)*hmi.Hmolec[ipMH2g];
		H2P_CN_HCNP_H       = hmrate(0.0000000012,0,0)*hmi.Hmolec[ipMH2p];
		H2_CNP_HCNP_H       = hmrate(0.000000001,0,0)*hmi.Hmolec[ipMH2g];
		H2P_NO_HNOP_H       = hmrate(0.0000000011,0,0)*hmi.Hmolec[ipMH2p];
		H2_SP_HSP_H         = hmrate(0.00000000011,0,9860)*hmi.Hmolec[ipMH2g];
		H2_CSP_HCSP_H       = hmrate(0.00000000045,0,0)*hmi.Hmolec[ipMH2g];
		H2_NO2P_NOP_H2O     = hmrate(0.00000000015,0,0)*hmi.Hmolec[ipMH2g];
		H3P_NH_NH2P_H2      = hmrate(0.0000000013,0,0)*hmi.Hmolec[ipMH3p];
		H3P_NH2_NH3P_H2     = hmrate(0.0000000018,0,0)*hmi.Hmolec[ipMH3p];
		H3P_NH3_NH4P_H2     = hmrate(0.0000000027,0,0)*hmi.Hmolec[ipMH3p];
		H3P_CN_HCNP_H2      = hmrate(0.000000002,0,0)*hmi.Hmolec[ipMH3p];
		H3P_NO_HNOP_H2      = hmrate(0.0000000011,0,0)*hmi.Hmolec[ipMH3p];
		H3P_S_HSP_H2        = hmrate(0.0000000026,0,0)*hmi.Hmolec[ipMH3p];
		H3P_CS_HCSP_H2      = hmrate(0.0000000029,0,0)*hmi.Hmolec[ipMH3p];
		H3P_NO2_NOP_OH_H2   = hmrate(0.0000000007,0,0)*hmi.Hmolec[ipMH3p];
		HeP_NH_NP_He_H      = hmrate(0.0000000011,0,0)*dense.xIonDense[ipHELIUM][1];
		HeP_NH2_NP_He_H2    = hmrate(0.0000000008,0,0)*dense.xIonDense[ipHELIUM][1];
		HeP_NH2_NHP_He_H    = hmrate(0.0000000008,0,0)*dense.xIonDense[ipHELIUM][1];
		HeP_NH3_NHP_He_H2   = hmrate(0.000000000176,0,0)*dense.xIonDense[ipHELIUM][1];
		HeP_NH3_NH2P_He_H   = hmrate(0.00000000176,0,0)*dense.xIonDense[ipHELIUM][1];
		HeP_CN_N_CP_He      = hmrate(0.00000000088,0,0)*dense.xIonDense[ipHELIUM][1];
		HeP_CN_NP_C_He      = hmrate(0.00000000088,0,0)*dense.xIonDense[ipHELIUM][1];
		HeP_HCN_N_CHP_He    = hmrate(0.000000000651,0,0)*dense.xIonDense[ipHELIUM][1];
		HeP_HCN_NP_CH_He    = hmrate(0.000000000217,0,0)*dense.xIonDense[ipHELIUM][1];
		HeP_HCN_N_CP_He_H   = hmrate(0.000000000775,0,0)*dense.xIonDense[ipHELIUM][1];
		HeP_HCN_CNP_He_H    = hmrate(0.00000000146,0,0)*dense.xIonDense[ipHELIUM][1];
		HeP_N2_NP_N_He      = hmrate(0.00000000096,0,0)*dense.xIonDense[ipHELIUM][1];
		HeP_NO_OP_N_He      = hmrate(0.0000000002,0,0)*dense.xIonDense[ipHELIUM][1];
		HeP_NO_O_NP_He      = hmrate(0.0000000014,0,0)*dense.xIonDense[ipHELIUM][1];
		HeP_HNO_NOP_He_H    = hmrate(0.000000001,0,0)*dense.xIonDense[ipHELIUM][1];
		HeP_HNO_NO_He_HP    = hmrate(0.000000001,0,0)*dense.xIonDense[ipHELIUM][1];
		HeP_HS_SP_He_H      = hmrate(0.0000000017,0,0)*dense.xIonDense[ipHELIUM][1];
		HeP_OCN_CN_OP_He    = hmrate(0.000000003,0,0)*dense.xIonDense[ipHELIUM][1];
		HeP_OCN_CNP_O_He    = hmrate(0.000000003,0,0)*dense.xIonDense[ipHELIUM][1];
		HeP_SIN_SIP_N_He    = hmrate(0.000000002,0,0)*dense.xIonDense[ipHELIUM][1];
		HeP_N2O_N2_OP_He    = hmrate(0.000000000276,0,0)*dense.xIonDense[ipHELIUM][1];
		HeP_N2O_N2P_O_He    = hmrate(0.00000000124,0,0)*dense.xIonDense[ipHELIUM][1];
		HeP_N2O_NO_NP_He    = hmrate(0.0000000003,0,0)*dense.xIonDense[ipHELIUM][1];
		HeP_N2O_NOP_N_He    = hmrate(0.000000000483,0,0)*dense.xIonDense[ipHELIUM][1];
		HeP_CS_SP_C_He      = hmrate(0.0000000013,0,0)*dense.xIonDense[ipHELIUM][1];
		HeP_CS_S_CP_He      = hmrate(0.0000000013,0,0)*dense.xIonDense[ipHELIUM][1];
		HeP_NS_S_NP_He      = hmrate(0.0000000012,0,0)*dense.xIonDense[ipHELIUM][1];
		HeP_NS_SP_N_He      = hmrate(0.0000000012,0,0)*dense.xIonDense[ipHELIUM][1];
		HeP_SO_S_OP_He      = hmrate(0.00000000083,0,0)*dense.xIonDense[ipHELIUM][1];
		HeP_SO_SP_O_He      = hmrate(0.00000000083,0,0)*dense.xIonDense[ipHELIUM][1];
		HeP_OCS_SP_CO_He    = hmrate(0.00000000076,0,0)*dense.xIonDense[ipHELIUM][1];
		HeP_OCS_S_COP_He    = hmrate(0.00000000076,0,0)*dense.xIonDense[ipHELIUM][1];
		HeP_OCS_CSP_O_He    = hmrate(0.00000000076,0,0)*dense.xIonDense[ipHELIUM][1];
		HeP_OCS_CS_OP_He    = hmrate(0.00000000076,0,0)*dense.xIonDense[ipHELIUM][1];
		HeP_S2_SP_S_He      = hmrate(0.000000002,0,0)*dense.xIonDense[ipHELIUM][1];
		HP_NH_NHP_H         = hmrate(0.0000000021,0,0)*dense.xIonDense[ipHYDROGEN][1];
		HP_NH2_NH2P_H       = hmrate(0.0000000029,0,0)*dense.xIonDense[ipHYDROGEN][1];
		HP_NH3_NH3P_H       = hmrate(0.0000000011,0,0)*dense.xIonDense[ipHYDROGEN][1];
		H_CNP_CN_HP         = hmrate(0.00000000019,0,0)*dense.xIonDense[ipHYDROGEN][0];
		HP_HCN_HCNP_H       = hmrate(0.0000000105,-0.13,0)*dense.xIonDense[ipHYDROGEN][1];
		H_HCNP_HCN_HP       = hmrate(0.000000000037,0,0)*dense.xIonDense[ipHYDROGEN][0];
		H_N2P_N2_HP         = hmrate(0.00000000012,0,0)*dense.xIonDense[ipHYDROGEN][0];
		HP_NO_NOP_H         = hmrate(0.0000000029,0,0)*dense.xIonDense[ipHYDROGEN][1];
		HP_HS_HSP_H         = hmrate(0.0000000016,0,0)*dense.xIonDense[ipHYDROGEN][1];
		HP_SIN_SINP_H       = hmrate(0.000000003,0,0)*dense.xIonDense[ipHYDROGEN][1];
		HP_CS_CSP_H         = hmrate(0.0000000049,0,0)*dense.xIonDense[ipHYDROGEN][1];
		HP_NS_NSP_H         = hmrate(0.0000000047,0,0)*dense.xIonDense[ipHYDROGEN][1];
		HP_SO_SOP_H         = hmrate(0.0000000032,0,0)*dense.xIonDense[ipHYDROGEN][1];
		HP_OCS_OCSP_H       = hmrate(0.0000000021,0,0)*dense.xIonDense[ipHYDROGEN][1];
		HP_S2_S2P_H         = hmrate(0.000000003,0,0)*dense.xIonDense[ipHYDROGEN][1];
		H2P_NH_NHP_H2       = hmrate(0.00000000076,0,0)*hmi.Hmolec[ipMH2p];
		H2P_NH2_NH2P_H2     = hmrate(0.0000000021,0,0)*hmi.Hmolec[ipMH2p];
		H2P_NH3_NH3P_H2     = hmrate(0.0000000057,0,0)*hmi.Hmolec[ipMH2p];
		H2P_CN_CNP_H2       = hmrate(0.0000000012,0,0)*hmi.Hmolec[ipMH2p];
		H2P_HCN_HCNP_H2     = hmrate(0.0000000027,0,0)*hmi.Hmolec[ipMH2p];
		H2P_NO_NOP_H2       = hmrate(0.0000000011,0,0)*hmi.Hmolec[ipMH2p];
		HeP_NH3_NH3P_He     = hmrate(0.000000000264,0,0)*dense.xIonDense[ipHELIUM][1];
		HeP_N2_N2P_He       = hmrate(0.00000000064,0,0)*dense.xIonDense[ipHELIUM][1];
		NHP_e_N_H         = hmrate(0.000000043,-0.5,0)*dense.eden;
		NH2P_e_N_H_H      = hmrate(0.000000198,-0.5,0)*dense.eden;
		NH2P_e_NH_H       = hmrate(0.000000102,-0.5,0)*dense.eden;
		NH3P_e_NH_H_H     = hmrate(0.000000155,-0.5,0)*dense.eden;
		NH3P_e_NH2_H      = hmrate(0.000000155,-0.5,0)*dense.eden;
		NH4P_e_NH2_H_H    = hmrate(0.000000286,-0.5,0)*dense.eden;
		NH4P_e_NH2_H2     = hmrate(0.000000137,-0.5,0)*dense.eden;
		NH4P_e_NH3_H      = hmrate(0.000000938,-0.5,0)*dense.eden;
		CNP_e_N_C         = hmrate(0.00000018,-0.5,0)*dense.eden;
		HCNP_e_CN_H       = hmrate(0.0000002,-0.5,0)*dense.eden;
		N2P_e_N_N         = hmrate(0.000000036,-0.42,0)*dense.eden;
		NOP_e_O_N         = hmrate(0.00000043,-0.37,0)*dense.eden;
		HNOP_e_NO_H       = hmrate(0.0000003,-0.5,0)*dense.eden;
		HSP_e_S_H         = hmrate(0.0000002,-0.5,0)*dense.eden;
		OCNP_e_CO_N       = hmrate(0.0000003,-0.5,0)*dense.eden;
		SINP_e_SI_N       = hmrate(0.0000002,-0.5,0)*dense.eden;
		CSP_e_S_C         = hmrate(0.0000002,-0.5,0)*dense.eden;
		HCSP_e_CS_H       = hmrate(0.00000005,-0.75,0)*dense.eden;
		NO2P_e_NO_O       = hmrate(0.0000003,-0.5,0)*dense.eden;
		NSP_e_S_N         = hmrate(0.0000002,-0.5,0)*dense.eden;
		SOP_e_S_O         = hmrate(0.0000002,-0.5,0)*dense.eden;
		OCSP_e_S_CO       = hmrate(0.00000015,-0.5,0)*dense.eden;
		OCSP_e_CS_O       = hmrate(0.00000015,-0.5,0)*dense.eden;
		S2P_e_S_S         = hmrate(0.0000002,-0.5,0)*dense.eden;
		Hminus_N_NH_e       = hmrate(0.000000001,0,0)*hmi.Hmolec[ipMHm];
		Hminus_NH_NH2_e     = hmrate(0.0000000001,0,0)*hmi.Hmolec[ipMHm];
		Hminus_NH2_NH3_e    = hmrate(0.000000001,0,0)*hmi.Hmolec[ipMHm];
		Hminus_CN_HCN_e     = hmrate(0.0000000001,0,0)*hmi.Hmolec[ipMHm];
		Hminus_NH4P_NH3_H2  = hmrate(0.00000023,-0.5,0)*hmi.Hmolec[ipMHm];
		Hminus_NP_N_H       = hmrate(0.00000023,-0.5,0)*hmi.Hmolec[ipMHm];
		
		NH_NU_NHP_e       = hmrate(0.00000000001,0,0)*(hmi.UV_Cont_rel2_Habing_TH85_depth/1.66f);
		NH_NU_N_H         = hmrate(0.0000000005,0,0)*(hmi.UV_Cont_rel2_Habing_TH85_depth/1.66f);
		NH2_NU_NH_H       = hmrate(0.00000000039,0,0)*(hmi.UV_Cont_rel2_Habing_TH85_depth/1.66f);
		NH2_NU_NH2P_e     = hmrate(0.000000000173,0,0)*(hmi.UV_Cont_rel2_Habing_TH85_depth/1.66f);
		NH3_NU_NH3P_e     = hmrate(0.00000000018,0,0)*(hmi.UV_Cont_rel2_Habing_TH85_depth/1.66f);
		NH3_NU_NH_H2      = hmrate(0.00000000033,0,0)*(hmi.UV_Cont_rel2_Habing_TH85_depth/1.66f);
		NH3_NU_NH2_H      = hmrate(0.0000000011,0,0)*(hmi.UV_Cont_rel2_Habing_TH85_depth/1.66f);
		CN_NU_N_C         = hmrate(0.0000000011,0,0)*(hmi.UV_Cont_rel2_Habing_TH85_depth/1.66f);
		HCN_NU_CN_H       = hmrate(0.0000000013,0,0)*(hmi.UV_Cont_rel2_Habing_TH85_depth/1.66f);
		N2_NU_N_N         = hmrate(0.00000000023,0,0)*(hmi.UV_Cont_rel2_Habing_TH85_depth/1.66f);
		NO_NU_O_N         = hmrate(0.00000000043,0,0)*(hmi.UV_Cont_rel2_Habing_TH85_depth/1.66f);
		NO_NU_NOP_e       = hmrate(0.00000000026,0,0)*(hmi.UV_Cont_rel2_Habing_TH85_depth/1.66f);
		HNO_NU_NO_H       = hmrate(0.00000000017,0,0)*(hmi.UV_Cont_rel2_Habing_TH85_depth/1.66f);
		HS_NU_S_H         = hmrate(0.00000000097,0,0)*(hmi.UV_Cont_rel2_Habing_TH85_depth/1.66f);
		HSP_NU_SP_H       = hmrate(0.0000000003,0,0)*(hmi.UV_Cont_rel2_Habing_TH85_depth/1.66f);
		OCN_NU_CN_O       = hmrate(0.00000000001,0,0)*(hmi.UV_Cont_rel2_Habing_TH85_depth/1.66f);
		CS_NU_S_C         = hmrate(0.00000000097,0,0)*(hmi.UV_Cont_rel2_Habing_TH85_depth/1.66f);
		CSP_NU_SP_C       = hmrate(0.0000000002,0,0)*(hmi.UV_Cont_rel2_Habing_TH85_depth/1.66f);
		CS_NU_CSP_e       = hmrate(0.0000000002,0,0)*(hmi.UV_Cont_rel2_Habing_TH85_depth/1.66f);
		NO2_NU_NO_O       = hmrate(0.0000000012,0,0)*(hmi.UV_Cont_rel2_Habing_TH85_depth/1.66f);
		NS_NU_S_N         = hmrate(0.00000000001,0,0)*(hmi.UV_Cont_rel2_Habing_TH85_depth/1.66f);
		SO_NU_S_O         = hmrate(0.0000000037,0,0)*(hmi.UV_Cont_rel2_Habing_TH85_depth/1.66f);
		SO_NU_SOP_e       = hmrate(0.0000000006,0,0)*(hmi.UV_Cont_rel2_Habing_TH85_depth/1.66f);
		OCS_NU_S_CO       = hmrate(0.0000000037,0,0)*(hmi.UV_Cont_rel2_Habing_TH85_depth/1.66f);
		OCS_NU_OCSP_e     = hmrate(0.00000000042,0,0)*(hmi.UV_Cont_rel2_Habing_TH85_depth/1.66f);
	

		NH_CRP_NHP_e      = secondaries.csupra[ipHYDROGEN][0] * 500 * 2;
		NH_CRP_N_H        = secondaries.csupra[ipHYDROGEN][0] * 500 * 2;
		NH2_CRP_NH_H      = secondaries.csupra[ipHYDROGEN][0] * 81 * 2;
		NH2_CRP_NH2P_e    = secondaries.csupra[ipHYDROGEN][0] * 610 * 2;
		NH3_CRP_NH3P_e    = secondaries.csupra[ipHYDROGEN][0] * 543 * 2;
		NH3_CRP_NH_H2     = secondaries.csupra[ipHYDROGEN][0] * 541 * 2;
		NH3_CRP_NH2_H     = secondaries.csupra[ipHYDROGEN][0] * 1325 * 2;
		CN_CRP_N_C        = secondaries.csupra[ipHYDROGEN][0] * 10580 * 2;
		HCN_CRP_CN_H      = secondaries.csupra[ipHYDROGEN][0] * 3114 * 2;
		N2_CRP_N_N        = secondaries.csupra[ipHYDROGEN][0] * 50 * 2;
		NO_CRP_O_N        = secondaries.csupra[ipHYDROGEN][0] * 427 * 2;
		NO_CRP_NOP_e      = secondaries.csupra[ipHYDROGEN][0] * 430 * 2;
		HNO_CRP_NO_H      = secondaries.csupra[ipHYDROGEN][0] * 1000 * 2;
		HS_CRP_S_H        = secondaries.csupra[ipHYDROGEN][0] * 500 * 2;
		OCN_CRP_CN_O      = secondaries.csupra[ipHYDROGEN][0] * 1500 * 2;
		CS_CRP_S_C        = secondaries.csupra[ipHYDROGEN][0] * 500 * 2;
		CS_CRP_CSP_e      = secondaries.csupra[ipHYDROGEN][0] * 500 * 2;
		NO2_CRP_NO_O      = secondaries.csupra[ipHYDROGEN][0] * 1500 * 2;
		NS_CRP_S_N        = secondaries.csupra[ipHYDROGEN][0] * 500 * 2;
		SO_CRP_S_O        = secondaries.csupra[ipHYDROGEN][0] * 500 * 2;
		SO_CRP_SOP_e      = secondaries.csupra[ipHYDROGEN][0] * 500 * 2;
		OCS_CRP_S_CO      = secondaries.csupra[ipHYDROGEN][0] * 5360 * 2;
		OCS_CRP_OCSP_e    = secondaries.csupra[ipHYDROGEN][0] * 1444 * 2;
		

		PRODUCT_C_NH = co.hevmol[ipATC]*co.hevmol[ipNH];
		PRODUCT_C_NH2 = co.hevmol[ipATC]*co.hevmol[ipNH2];
		PRODUCT_C_N2 = co.hevmol[ipATC]*co.hevmol[ipN2];
		PRODUCT_C_NO = co.hevmol[ipATC]*co.hevmol[ipNO];
		PRODUCT_C_HS = co.hevmol[ipATC]*co.hevmol[ipHS];
		PRODUCT_C_OCN = co.hevmol[ipATC]*co.hevmol[ipOCN];
		PRODUCT_C_NS = co.hevmol[ipATC]*co.hevmol[ipNS];
		PRODUCT_C_SO = co.hevmol[ipATC]*co.hevmol[ipSO];
		PRODUCT_C_S2 = co.hevmol[ipATC]*co.hevmol[ipS2];
		PRODUCT_C_NH3P = co.hevmol[ipATC]*co.hevmol[ipNH3P];
		PRODUCT_C_HCNP = co.hevmol[ipATC]*co.hevmol[ipHCNP];
		PRODUCT_C_HNOP = co.hevmol[ipATC]*co.hevmol[ipHNOP];
		PRODUCT_CH_N = co.hevmol[ipCH]*co.hevmol[ipATN];
		PRODUCT_CH_N2 = co.hevmol[ipCH]*co.hevmol[ipN2];
		PRODUCT_CH_NO = co.hevmol[ipCH]*co.hevmol[ipNO];
		PRODUCT_CH_HNO = co.hevmol[ipCH]*co.hevmol[ipHNO];
		PRODUCT_CH_S = co.hevmol[ipCH]*co.hevmol[ipATS];
		PRODUCT_N_NH = co.hevmol[ipATN]*co.hevmol[ipNH];
		PRODUCT_N_CH3 = co.hevmol[ipATN]*co.hevmol[ipCH3];
		PRODUCT_N_OH = co.hevmol[ipATN]*co.hevmol[ipOH];
		PRODUCT_N_CN = co.hevmol[ipATN]*co.hevmol[ipCN];
		PRODUCT_N_SIH = co.hevmol[ipATN]*co.hevmol[ipSIH];
		PRODUCT_N_NO = co.hevmol[ipATN]*co.hevmol[ipNO];
		PRODUCT_N_HNO = co.hevmol[ipATN]*co.hevmol[ipHNO];
		PRODUCT_N_O2 = co.hevmol[ipATN]*co.hevmol[ipO2];
		PRODUCT_N_HS = co.hevmol[ipATN]*co.hevmol[ipHS];
		PRODUCT_N_CS = co.hevmol[ipATN]*co.hevmol[ipCS];
		PRODUCT_N_NS = co.hevmol[ipATN]*co.hevmol[ipNS];
		PRODUCT_N_SO = co.hevmol[ipATN]*co.hevmol[ipSO];
		PRODUCT_N_S2 = co.hevmol[ipATN]*co.hevmol[ipS2];
		PRODUCT_CH2_CN = co.hevmol[ipCH2]*co.hevmol[ipCN];
		PRODUCT_CH2_NO = co.hevmol[ipCH2]*co.hevmol[ipNO];
		PRODUCT_CH2_HNO = co.hevmol[ipCH2]*co.hevmol[ipHNO];
		PRODUCT_CH2_S = co.hevmol[ipCH2]*co.hevmol[ipATS];
		PRODUCT_NH_NH = co.hevmol[ipNH]*co.hevmol[ipNH];
		PRODUCT_NH_O = co.hevmol[ipNH]*co.hevmol[ipATO];
		PRODUCT_NH_OH = co.hevmol[ipNH]*co.hevmol[ipOH];
		PRODUCT_NH_H2O = co.hevmol[ipNH]*co.hevmol[ipH2O];
		PRODUCT_NH_CN = co.hevmol[ipNH]*co.hevmol[ipCN];
		PRODUCT_NH_NO = co.hevmol[ipNH]*co.hevmol[ipNO];
		PRODUCT_NH_S = co.hevmol[ipNH]*co.hevmol[ipATS];
		PRODUCT_NH_NO2 = co.hevmol[ipNH]*co.hevmol[ipNO2];
		PRODUCT_CH3_NH3 = co.hevmol[ipCH3]*co.hevmol[ipNH3];
		PRODUCT_CH3_CN = co.hevmol[ipCH3]*co.hevmol[ipCN];
		PRODUCT_CH3_HNO = co.hevmol[ipCH3]*co.hevmol[ipHNO];
		PRODUCT_O_NH2 = co.hevmol[ipATO]*co.hevmol[ipNH2];
		PRODUCT_O_NH3 = co.hevmol[ipATO]*co.hevmol[ipNH3];
		PRODUCT_O_CN = co.hevmol[ipATO]*co.hevmol[ipCN];
		PRODUCT_O_HCN = co.hevmol[ipATO]*co.hevmol[ipHCN];
		PRODUCT_O_N2 = co.hevmol[ipATO]*co.hevmol[ipN2];
		PRODUCT_O_NO = co.hevmol[ipATO]*co.hevmol[ipNO];
		PRODUCT_O_HNO = co.hevmol[ipATO]*co.hevmol[ipHNO];
		PRODUCT_O_HS = co.hevmol[ipATO]*co.hevmol[ipHS];
		PRODUCT_O_OCN = co.hevmol[ipATO]*co.hevmol[ipOCN];
		PRODUCT_O_SIN = co.hevmol[ipATO]*co.hevmol[ipSIN];
		PRODUCT_O_N2O = co.hevmol[ipATO]*co.hevmol[ipN2O];
		PRODUCT_O_CS = co.hevmol[ipATO]*co.hevmol[ipCS];
		PRODUCT_O_NO2 = co.hevmol[ipATO]*co.hevmol[ipNO2];
		PRODUCT_O_NS = co.hevmol[ipATO]*co.hevmol[ipNS];
		PRODUCT_O_SO = co.hevmol[ipATO]*co.hevmol[ipSO];
		PRODUCT_O_OCS = co.hevmol[ipATO]*co.hevmol[ipOCS];
		PRODUCT_O_S2 = co.hevmol[ipATO]*co.hevmol[ipS2];
		PRODUCT_NH2_OH = co.hevmol[ipNH2]*co.hevmol[ipOH];
		PRODUCT_NH2_NO = co.hevmol[ipNH2]*co.hevmol[ipNO];
		PRODUCT_CH4_CN = co.hevmol[ipCH4]*co.hevmol[ipCN];
		PRODUCT_OH_NH3 = co.hevmol[ipOH]*co.hevmol[ipNH3];
		PRODUCT_OH_CN = co.hevmol[ipOH]*co.hevmol[ipCN];
		PRODUCT_OH_HCN = co.hevmol[ipOH]*co.hevmol[ipHCN];
		PRODUCT_OH_NO = co.hevmol[ipOH]*co.hevmol[ipNO];
		PRODUCT_OH_HNO = co.hevmol[ipOH]*co.hevmol[ipHNO];
		PRODUCT_OH_S = co.hevmol[ipOH]*co.hevmol[ipATS];
		PRODUCT_OH_N2O = co.hevmol[ipOH]*co.hevmol[ipN2O];
		PRODUCT_OH_CS = co.hevmol[ipOH]*co.hevmol[ipCS];
		PRODUCT_NH3_CN = co.hevmol[ipNH3]*co.hevmol[ipCN];
		PRODUCT_CN_NO = co.hevmol[ipCN]*co.hevmol[ipNO];
		PRODUCT_CN_HNO = co.hevmol[ipCN]*co.hevmol[ipHNO];
		PRODUCT_CN_O2 = co.hevmol[ipCN]*co.hevmol[ipO2];
		PRODUCT_CN_S = co.hevmol[ipCN]*co.hevmol[ipATS];
		PRODUCT_CO_HS = co.hevmol[ipCO]*co.hevmol[ipHS];
		PRODUCT_N2_O2 = co.hevmol[ipN2]*co.hevmol[ipO2];
		PRODUCT_NO_NO = co.hevmol[ipNO]*co.hevmol[ipNO];
		PRODUCT_NO_HNO = co.hevmol[ipNO]*co.hevmol[ipHNO];
		PRODUCT_NO_S = co.hevmol[ipNO]*co.hevmol[ipATS];
		PRODUCT_O2_S = co.hevmol[ipO2]*co.hevmol[ipATS];
		PRODUCT_S_SO = co.hevmol[ipATS]*co.hevmol[ipSO];
		PRODUCT_C_NHP = co.hevmol[ipATC]*co.hevmol[ipNHP];
		PRODUCT_CP_NH = co.hevmol[ipCP]*co.hevmol[ipNH];
		PRODUCT_CP_NH2 = co.hevmol[ipCP]*co.hevmol[ipNH2];
		PRODUCT_C_NH2P = co.hevmol[ipATC]*co.hevmol[ipNH2P];
		PRODUCT_CP_NH3 = co.hevmol[ipCP]*co.hevmol[ipNH3];
		PRODUCT_CP_HS = co.hevmol[ipCP]*co.hevmol[ipHS];
		PRODUCT_C_HSP = co.hevmol[ipATC]*co.hevmol[ipHSP];
		PRODUCT_CP_OCN = co.hevmol[ipCP]*co.hevmol[ipOCN];
		PRODUCT_CP_NS = co.hevmol[ipCP]*co.hevmol[ipNS];
		PRODUCT_CP_SO = co.hevmol[ipCP]*co.hevmol[ipSO];
		PRODUCT_CP_OCS = co.hevmol[ipCP]*co.hevmol[ipOCS];
		PRODUCT_CHP_N = co.hevmol[ipCHP]*co.hevmol[ipATN];
		PRODUCT_CH_NP = co.hevmol[ipCH]*co.hevmol[ipNP];
		PRODUCT_CH_NHP = co.hevmol[ipCH]*co.hevmol[ipNHP];
		PRODUCT_CHP_NH = co.hevmol[ipCHP]*co.hevmol[ipNH];
		PRODUCT_CHP_NH2 = co.hevmol[ipCHP]*co.hevmol[ipNH2];
		PRODUCT_CH_NH2P = co.hevmol[ipCH]*co.hevmol[ipNH2P];
		PRODUCT_CHP_NH3 = co.hevmol[ipCHP]*co.hevmol[ipNH3];
		PRODUCT_CH_NH3P = co.hevmol[ipCH]*co.hevmol[ipNH3P];
		PRODUCT_CH_HCNP = co.hevmol[ipCH]*co.hevmol[ipHCNP];
		PRODUCT_CH_HNOP = co.hevmol[ipCH]*co.hevmol[ipHNOP];
		PRODUCT_CHP_S = co.hevmol[ipCHP]*co.hevmol[ipATS];
		PRODUCT_CH_SP = co.hevmol[ipCH]*co.hevmol[ipSP];
		PRODUCT_CH_HSP = co.hevmol[ipCH]*co.hevmol[ipHSP];
		PRODUCT_CHP_OCS = co.hevmol[ipCHP]*co.hevmol[ipOCS];
		PRODUCT_N_CH2P = co.hevmol[ipATN]*co.hevmol[ipCH2P];
		PRODUCT_NP_NH = co.hevmol[ipNP]*co.hevmol[ipNH];
		PRODUCT_N_NHP = co.hevmol[ipATN]*co.hevmol[ipNHP];
		PRODUCT_NP_CH4 = co.hevmol[ipNP]*co.hevmol[ipCH4];
		PRODUCT_N_OHP = co.hevmol[ipATN]*co.hevmol[ipOHP];
		PRODUCT_NP_NH3 = co.hevmol[ipNP]*co.hevmol[ipNH3];
		PRODUCT_N_H2OP = co.hevmol[ipATN]*co.hevmol[ipH2OP];
		PRODUCT_NP_CO = co.hevmol[ipNP]*co.hevmol[ipCO];
		PRODUCT_NP_NO = co.hevmol[ipNP]*co.hevmol[ipNO];
		PRODUCT_NP_O2 = co.hevmol[ipNP]*co.hevmol[ipO2];
		PRODUCT_N_O2P = co.hevmol[ipATN]*co.hevmol[ipO2P];
		PRODUCT_N_HSP = co.hevmol[ipATN]*co.hevmol[ipHSP];
		PRODUCT_N_SIOP = co.hevmol[ipATN]*co.hevmol[ipSIOP];
		PRODUCT_N_SOP = co.hevmol[ipATN]*co.hevmol[ipSOP];
		PRODUCT_NP_OCS = co.hevmol[ipNP]*co.hevmol[ipOCS];
		PRODUCT_CH2_NHP = co.hevmol[ipCH2]*co.hevmol[ipNHP];
		PRODUCT_CH2_NH2P = co.hevmol[ipCH2]*co.hevmol[ipNH2P];
		PRODUCT_CH2P_NH3 = co.hevmol[ipCH2P]*co.hevmol[ipNH3];
		PRODUCT_CH2_NH3P = co.hevmol[ipCH2]*co.hevmol[ipNH3P];
		PRODUCT_CH2_HCNP = co.hevmol[ipCH2]*co.hevmol[ipHCNP];
		PRODUCT_CH2_HNOP = co.hevmol[ipCH2]*co.hevmol[ipHNOP];
		PRODUCT_CH2P_S = co.hevmol[ipCH2P]*co.hevmol[ipATS];
		PRODUCT_CH2_SP = co.hevmol[ipCH2]*co.hevmol[ipSP];
		PRODUCT_NHP_NH = co.hevmol[ipNHP]*co.hevmol[ipNH];
		PRODUCT_NHP_O = co.hevmol[ipNHP]*co.hevmol[ipATO];
		PRODUCT_NH_OP = co.hevmol[ipNH]*co.hevmol[ipOP];
		PRODUCT_NHP_NH2 = co.hevmol[ipNHP]*co.hevmol[ipNH2];
		PRODUCT_NH_NH2P = co.hevmol[ipNH]*co.hevmol[ipNH2P];
		PRODUCT_NHP_OH = co.hevmol[ipNHP]*co.hevmol[ipOH];
		PRODUCT_NH_OHP = co.hevmol[ipNH]*co.hevmol[ipOHP];
		PRODUCT_NHP_NH3 = co.hevmol[ipNHP]*co.hevmol[ipNH3];
		PRODUCT_NH_NH3P = co.hevmol[ipNH]*co.hevmol[ipNH3P];
		PRODUCT_NH_CH5P = co.hevmol[ipNH]*co.hevmol[ipCH5P];
		PRODUCT_NHP_H2O = co.hevmol[ipNHP]*co.hevmol[ipH2O];
		PRODUCT_NH_H2OP = co.hevmol[ipNH]*co.hevmol[ipH2OP];
		PRODUCT_NHP_H2O = co.hevmol[ipNHP]*co.hevmol[ipH2O];
		PRODUCT_NHP_CN = co.hevmol[ipNHP]*co.hevmol[ipCN];
		PRODUCT_NH_HCNP = co.hevmol[ipNH]*co.hevmol[ipHCNP];
		PRODUCT_NH_COP = co.hevmol[ipNH]*co.hevmol[ipCOP];
		PRODUCT_NHP_CO = co.hevmol[ipNHP]*co.hevmol[ipCO];
		PRODUCT_NH_SIP = co.hevmol[ipNH]*co.hevmol[ipSIP];
		PRODUCT_NH_HCOP = co.hevmol[ipNH]*co.hevmol[ipHCOP];
		PRODUCT_NH_HNOP = co.hevmol[ipNH]*co.hevmol[ipHNOP];
		PRODUCT_NHP_O2 = co.hevmol[ipNHP]*co.hevmol[ipO2];
		PRODUCT_NH_O2P = co.hevmol[ipNH]*co.hevmol[ipO2P];
		PRODUCT_NHP_S = co.hevmol[ipNHP]*co.hevmol[ipATS];
		PRODUCT_NH_SP = co.hevmol[ipNH]*co.hevmol[ipSP];
		PRODUCT_CH3P_NH2 = co.hevmol[ipCH3P]*co.hevmol[ipNH2];
		PRODUCT_CH3P_NH3 = co.hevmol[ipCH3P]*co.hevmol[ipNH3];
		PRODUCT_CH3P_S = co.hevmol[ipCH3P]*co.hevmol[ipATS];
		PRODUCT_O_NH2P = co.hevmol[ipATO]*co.hevmol[ipNH2P];
		PRODUCT_O_NH3P = co.hevmol[ipATO]*co.hevmol[ipNH3P];
		PRODUCT_OP_CN = co.hevmol[ipOP]*co.hevmol[ipCN];
		PRODUCT_OP_HCN = co.hevmol[ipOP]*co.hevmol[ipHCN];
		PRODUCT_OP_N2 = co.hevmol[ipOP]*co.hevmol[ipN2];
		PRODUCT_O_N2P = co.hevmol[ipATO]*co.hevmol[ipN2P];
		PRODUCT_O_HNOP = co.hevmol[ipATO]*co.hevmol[ipHNOP];
		PRODUCT_O_HSP = co.hevmol[ipATO]*co.hevmol[ipHSP];
		PRODUCT_O_SINP = co.hevmol[ipATO]*co.hevmol[ipSINP];
		PRODUCT_OP_N2O = co.hevmol[ipOP]*co.hevmol[ipN2O];
		PRODUCT_O_CSP = co.hevmol[ipATO]*co.hevmol[ipCSP];
		PRODUCT_O_HCSP = co.hevmol[ipATO]*co.hevmol[ipHCSP];
		PRODUCT_OP_NO2 = co.hevmol[ipOP]*co.hevmol[ipNO2];
		PRODUCT_O_NSP = co.hevmol[ipATO]*co.hevmol[ipNSP];
		PRODUCT_NH2P_NH2 = co.hevmol[ipNH2P]*co.hevmol[ipNH2];
		PRODUCT_NH2_OHP = co.hevmol[ipNH2]*co.hevmol[ipOHP];
		PRODUCT_NH2P_OH = co.hevmol[ipNH2P]*co.hevmol[ipOH];
		PRODUCT_NH2P_NH3 = co.hevmol[ipNH2P]*co.hevmol[ipNH3];
		PRODUCT_NH2_NH3P = co.hevmol[ipNH2]*co.hevmol[ipNH3P];
		PRODUCT_NH2_CH5P = co.hevmol[ipNH2]*co.hevmol[ipCH5P];
		PRODUCT_NH2P_H2O = co.hevmol[ipNH2P]*co.hevmol[ipH2O];
		PRODUCT_NH2_H2OP = co.hevmol[ipNH2]*co.hevmol[ipH2OP];
		PRODUCT_NH2P_H2O = co.hevmol[ipNH2P]*co.hevmol[ipH2O];
		PRODUCT_NH2_H3OP = co.hevmol[ipNH2]*co.hevmol[ipH3OP];
		PRODUCT_NH2_HCNP = co.hevmol[ipNH2]*co.hevmol[ipHCNP];
		PRODUCT_NH2_COP = co.hevmol[ipNH2]*co.hevmol[ipCOP];
		PRODUCT_NH2_HCOP = co.hevmol[ipNH2]*co.hevmol[ipHCOP];
		PRODUCT_NH2_HNOP = co.hevmol[ipNH2]*co.hevmol[ipHNOP];
		PRODUCT_NH2P_O2 = co.hevmol[ipNH2P]*co.hevmol[ipO2];
		PRODUCT_NH2P_S = co.hevmol[ipNH2P]*co.hevmol[ipATS];
		PRODUCT_CH4P_NH3 = co.hevmol[ipCH4P]*co.hevmol[ipNH3];
		PRODUCT_CH4_NH3P = co.hevmol[ipCH4]*co.hevmol[ipNH3P];
		PRODUCT_CH4_N2P = co.hevmol[ipCH4]*co.hevmol[ipN2P];
		PRODUCT_CH4_HNOP = co.hevmol[ipCH4]*co.hevmol[ipHNOP];
		PRODUCT_CH4_SP = co.hevmol[ipCH4]*co.hevmol[ipSP];
		PRODUCT_CH4_CSP = co.hevmol[ipCH4]*co.hevmol[ipCSP];
		PRODUCT_OHP_NH3 = co.hevmol[ipOHP]*co.hevmol[ipNH3];
		PRODUCT_OH_NH3P = co.hevmol[ipOH]*co.hevmol[ipNH3P];
		PRODUCT_OHP_CN = co.hevmol[ipOHP]*co.hevmol[ipCN];
		PRODUCT_OH_HCNP = co.hevmol[ipOH]*co.hevmol[ipHCNP];
		PRODUCT_OHP_NO = co.hevmol[ipOHP]*co.hevmol[ipNO];
		PRODUCT_OH_HNOP = co.hevmol[ipOH]*co.hevmol[ipHNOP];
		PRODUCT_OHP_S = co.hevmol[ipOHP]*co.hevmol[ipATS];
		PRODUCT_OH_SP = co.hevmol[ipOH]*co.hevmol[ipSP];
		PRODUCT_NH3P_NH3 = co.hevmol[ipNH3P]*co.hevmol[ipNH3];
		PRODUCT_NH3_CH5P = co.hevmol[ipNH3]*co.hevmol[ipCH5P];
		PRODUCT_NH3P_H2O = co.hevmol[ipNH3P]*co.hevmol[ipH2O];
		PRODUCT_NH3_H2OP = co.hevmol[ipNH3]*co.hevmol[ipH2OP];
		PRODUCT_NH3_H3OP = co.hevmol[ipNH3]*co.hevmol[ipH3OP];
		PRODUCT_NH3_COP = co.hevmol[ipNH3]*co.hevmol[ipCOP];
		PRODUCT_NH3_HCOP = co.hevmol[ipNH3]*co.hevmol[ipHCOP];
		PRODUCT_NH3_HNOP = co.hevmol[ipNH3]*co.hevmol[ipHNOP];
		PRODUCT_NH3_HSP = co.hevmol[ipNH3]*co.hevmol[ipHSP];
		PRODUCT_NH3_HCSP = co.hevmol[ipNH3]*co.hevmol[ipHCSP];
		PRODUCT_CH5P_S = co.hevmol[ipCH5P]*co.hevmol[ipATS];
		PRODUCT_H2O_CNP = co.hevmol[ipH2O]*co.hevmol[ipCNP];
		PRODUCT_H2O_HCNP = co.hevmol[ipH2O]*co.hevmol[ipHCNP];
		PRODUCT_H2O_HNOP = co.hevmol[ipH2O]*co.hevmol[ipHNOP];
		PRODUCT_H2OP_S = co.hevmol[ipH2OP]*co.hevmol[ipATS];
		PRODUCT_H2O_HSP = co.hevmol[ipH2O]*co.hevmol[ipHSP];
		PRODUCT_H3OP_CS = co.hevmol[ipH3OP]*co.hevmol[ipCS];
		PRODUCT_CNP_NO = co.hevmol[ipCNP]*co.hevmol[ipNO];
		PRODUCT_CN_HNOP = co.hevmol[ipCN]*co.hevmol[ipHNOP];
		PRODUCT_CNP_O2 = co.hevmol[ipCNP]*co.hevmol[ipO2];
		PRODUCT_HCNP_CO = co.hevmol[ipHCNP]*co.hevmol[ipCO];
		PRODUCT_HCNP_S = co.hevmol[ipHCNP]*co.hevmol[ipATS];
		PRODUCT_CO_HNOP = co.hevmol[ipCO]*co.hevmol[ipHNOP];
		PRODUCT_N2P_OCS = co.hevmol[ipN2P]*co.hevmol[ipOCS];
		PRODUCT_HCOP_S = co.hevmol[ipHCOP]*co.hevmol[ipATS];
		PRODUCT_HCOP_CS = co.hevmol[ipHCOP]*co.hevmol[ipCS];
		PRODUCT_HNOP_S = co.hevmol[ipHNOP]*co.hevmol[ipATS];
		PRODUCT_O2_SP = co.hevmol[ipO2]*co.hevmol[ipSP];
		PRODUCT_O2P_S = co.hevmol[ipO2P]*co.hevmol[ipATS];
		PRODUCT_O2_CSP = co.hevmol[ipO2]*co.hevmol[ipCSP];
		PRODUCT_S_SIOP = co.hevmol[ipATS]*co.hevmol[ipSIOP];
		PRODUCT_CP_NH3 = co.hevmol[ipCP]*co.hevmol[ipNH3];
		PRODUCT_C_CNP = co.hevmol[ipATC]*co.hevmol[ipCNP];
		PRODUCT_C_N2P = co.hevmol[ipATC]*co.hevmol[ipN2P];
		PRODUCT_CP_NO = co.hevmol[ipCP]*co.hevmol[ipNO];
		PRODUCT_CP_SIN = co.hevmol[ipCP]*co.hevmol[ipSIN];
		PRODUCT_C_CSP = co.hevmol[ipATC]*co.hevmol[ipCSP];
		PRODUCT_CP_NS = co.hevmol[ipCP]*co.hevmol[ipNS];
		PRODUCT_CP_SO = co.hevmol[ipCP]*co.hevmol[ipSO];
		PRODUCT_CP_OCS = co.hevmol[ipCP]*co.hevmol[ipOCS];
		PRODUCT_CH_NH2P = co.hevmol[ipCH]*co.hevmol[ipNH2P];
		PRODUCT_CHP_NH3 = co.hevmol[ipCHP]*co.hevmol[ipNH3];
		PRODUCT_CH_CNP = co.hevmol[ipCH]*co.hevmol[ipCNP];
		PRODUCT_CH_N2P = co.hevmol[ipCH]*co.hevmol[ipN2P];
		PRODUCT_CHP_NO = co.hevmol[ipCHP]*co.hevmol[ipNO];
		PRODUCT_NP_NH = co.hevmol[ipNP]*co.hevmol[ipNH];
		PRODUCT_NP_NH2 = co.hevmol[ipNP]*co.hevmol[ipNH2];
		PRODUCT_NP_NH3 = co.hevmol[ipNP]*co.hevmol[ipNH3];
		PRODUCT_NP_CN = co.hevmol[ipNP]*co.hevmol[ipCN];
		PRODUCT_NP_HCN = co.hevmol[ipNP]*co.hevmol[ipHCN];
		PRODUCT_N_N2P = co.hevmol[ipATN]*co.hevmol[ipN2P];
		PRODUCT_NP_NO = co.hevmol[ipNP]*co.hevmol[ipNO];
		PRODUCT_NP_OCS = co.hevmol[ipNP]*co.hevmol[ipOCS];
		PRODUCT_CH2_NH2P = co.hevmol[ipCH2]*co.hevmol[ipNH2P];
		PRODUCT_CH2_CNP = co.hevmol[ipCH2]*co.hevmol[ipCNP];
		PRODUCT_CH2_N2P = co.hevmol[ipCH2]*co.hevmol[ipN2P];
		PRODUCT_CH2P_NO = co.hevmol[ipCH2P]*co.hevmol[ipNO];
		PRODUCT_NH_OP = co.hevmol[ipNH]*co.hevmol[ipOP];
		PRODUCT_NH_OHP = co.hevmol[ipNH]*co.hevmol[ipOHP];
		PRODUCT_NHP_NH3 = co.hevmol[ipNHP]*co.hevmol[ipNH3];
		PRODUCT_NHP_H2O = co.hevmol[ipNHP]*co.hevmol[ipH2O];
		PRODUCT_NH_CNP = co.hevmol[ipNH]*co.hevmol[ipCNP];
		PRODUCT_NH_COP = co.hevmol[ipNH]*co.hevmol[ipCOP];
		PRODUCT_NH_N2P = co.hevmol[ipNH]*co.hevmol[ipN2P];
		PRODUCT_NHP_NO = co.hevmol[ipNHP]*co.hevmol[ipNO];
		PRODUCT_NHP_O2 = co.hevmol[ipNHP]*co.hevmol[ipO2];
		PRODUCT_NHP_S = co.hevmol[ipNHP]*co.hevmol[ipATS];
		PRODUCT_CH3P_NO = co.hevmol[ipCH3P]*co.hevmol[ipNO];
		PRODUCT_OP_NH2 = co.hevmol[ipOP]*co.hevmol[ipNH2];
		PRODUCT_OP_NH3 = co.hevmol[ipOP]*co.hevmol[ipNH3];
		PRODUCT_O_CNP = co.hevmol[ipATO]*co.hevmol[ipCNP];
		PRODUCT_O_HCNP = co.hevmol[ipATO]*co.hevmol[ipHCNP];
		PRODUCT_O_N2P = co.hevmol[ipATO]*co.hevmol[ipN2P];
		PRODUCT_OP_NO = co.hevmol[ipOP]*co.hevmol[ipNO];
		PRODUCT_OP_OCS = co.hevmol[ipOP]*co.hevmol[ipOCS];
		PRODUCT_NH2_OHP = co.hevmol[ipNH2]*co.hevmol[ipOHP];
		PRODUCT_NH2P_NH3 = co.hevmol[ipNH2P]*co.hevmol[ipNH3];
		PRODUCT_NH2_H2OP = co.hevmol[ipNH2]*co.hevmol[ipH2OP];
		PRODUCT_NH2_CNP = co.hevmol[ipNH2]*co.hevmol[ipCNP];
		PRODUCT_NH2_COP = co.hevmol[ipNH2]*co.hevmol[ipCOP];
		PRODUCT_NH2_N2P = co.hevmol[ipNH2]*co.hevmol[ipN2P];
		PRODUCT_NH2P_NO = co.hevmol[ipNH2P]*co.hevmol[ipNO];
		PRODUCT_NH2_O2P = co.hevmol[ipNH2]*co.hevmol[ipO2P];
		PRODUCT_NH2P_S = co.hevmol[ipNH2P]*co.hevmol[ipATS];
		PRODUCT_CH4P_NH3 = co.hevmol[ipCH4P]*co.hevmol[ipNH3];
		PRODUCT_CH4P_OCS = co.hevmol[ipCH4P]*co.hevmol[ipOCS];
		PRODUCT_OHP_NH3 = co.hevmol[ipOHP]*co.hevmol[ipNH3];
		PRODUCT_OH_CNP = co.hevmol[ipOH]*co.hevmol[ipCNP];
		PRODUCT_OH_N2P = co.hevmol[ipOH]*co.hevmol[ipN2P];
		PRODUCT_OHP_NO = co.hevmol[ipOHP]*co.hevmol[ipNO];
		PRODUCT_NH3_H2OP = co.hevmol[ipNH3]*co.hevmol[ipH2OP];
		PRODUCT_NH3_HCNP = co.hevmol[ipNH3]*co.hevmol[ipHCNP];
		PRODUCT_NH3_COP = co.hevmol[ipNH3]*co.hevmol[ipCOP];
		PRODUCT_NH3_N2P = co.hevmol[ipNH3]*co.hevmol[ipN2P];
		PRODUCT_NH3P_SI = co.hevmol[ipNH3P]*co.hevmol[ipATSI];
		PRODUCT_NH3P_NO = co.hevmol[ipNH3P]*co.hevmol[ipNO];
		PRODUCT_NH3_O2P = co.hevmol[ipNH3]*co.hevmol[ipO2P];
		PRODUCT_NH3_SP = co.hevmol[ipNH3]*co.hevmol[ipSP];
		PRODUCT_NH3_HSP = co.hevmol[ipNH3]*co.hevmol[ipHSP];
		PRODUCT_NH3_SOP = co.hevmol[ipNH3]*co.hevmol[ipSOP];
		PRODUCT_H2O_HCNP = co.hevmol[ipH2O]*co.hevmol[ipHCNP];
		PRODUCT_H2O_N2P = co.hevmol[ipH2O]*co.hevmol[ipN2P];
		PRODUCT_H2OP_NO = co.hevmol[ipH2OP]*co.hevmol[ipNO];
		PRODUCT_CNP_HCN = co.hevmol[ipCNP]*co.hevmol[ipHCN];
		PRODUCT_CNP_CO = co.hevmol[ipCNP]*co.hevmol[ipCO];
		PRODUCT_CN_N2P = co.hevmol[ipCN]*co.hevmol[ipN2P];
		PRODUCT_CNP_NO = co.hevmol[ipCNP]*co.hevmol[ipNO];
		PRODUCT_CNP_O2 = co.hevmol[ipCNP]*co.hevmol[ipO2];
		PRODUCT_CNP_S = co.hevmol[ipCNP]*co.hevmol[ipATS];
		PRODUCT_HCN_COP = co.hevmol[ipHCN]*co.hevmol[ipCOP];
		PRODUCT_HCN_N2P = co.hevmol[ipHCN]*co.hevmol[ipN2P];
		PRODUCT_HCNP_NO = co.hevmol[ipHCNP]*co.hevmol[ipNO];
		PRODUCT_HCNP_O2 = co.hevmol[ipHCNP]*co.hevmol[ipO2];
		PRODUCT_HCNP_S = co.hevmol[ipHCNP]*co.hevmol[ipATS];
		PRODUCT_CO_N2P = co.hevmol[ipCO]*co.hevmol[ipN2P];
		PRODUCT_COP_NO = co.hevmol[ipCOP]*co.hevmol[ipNO];
		PRODUCT_N2P_NO = co.hevmol[ipN2P]*co.hevmol[ipNO];
		PRODUCT_N2P_O2 = co.hevmol[ipN2P]*co.hevmol[ipO2];
		PRODUCT_N2P_S = co.hevmol[ipN2P]*co.hevmol[ipATS];
		PRODUCT_SI_NOP = co.hevmol[ipATSI]*co.hevmol[ipNOP];
		PRODUCT_SI_HSP = co.hevmol[ipATSI]*co.hevmol[ipHSP];
		PRODUCT_SI_CSP = co.hevmol[ipATSI]*co.hevmol[ipCSP];
		PRODUCT_NO_HNOP = co.hevmol[ipNO]*co.hevmol[ipHNOP];
		PRODUCT_NO_O2P = co.hevmol[ipNO]*co.hevmol[ipO2P];
		PRODUCT_NO_SP = co.hevmol[ipNO]*co.hevmol[ipSP];
		PRODUCT_NO_HSP = co.hevmol[ipNO]*co.hevmol[ipHSP];
		PRODUCT_NO_SIOP = co.hevmol[ipNO]*co.hevmol[ipSIOP];
		PRODUCT_NO_S2P = co.hevmol[ipNO]*co.hevmol[ipS2P];
		PRODUCT_O2P_NO2 = co.hevmol[ipO2P]*co.hevmol[ipNO2];
		PRODUCT_S_HSP = co.hevmol[ipATS]*co.hevmol[ipHSP];
		PRODUCT_C_N = co.hevmol[ipATC]*co.hevmol[ipATN];
		PRODUCT_C_S = co.hevmol[ipATC]*co.hevmol[ipATS];
		PRODUCT_CP_S = co.hevmol[ipCP]*co.hevmol[ipATS];
		PRODUCT_NP_N = co.hevmol[ipNP]*co.hevmol[ipATN];
		PRODUCT_CO_S = co.hevmol[ipCO]*co.hevmol[ipATS];
		PRODUCT_CHP_S = co.hevmol[ipCHP]*co.hevmol[ipATS];
		PRODUCT_NP_CH2 = co.hevmol[ipNP]*co.hevmol[ipCH2];
		PRODUCT_NP_CH4 = co.hevmol[ipNP]*co.hevmol[ipCH4];
		PRODUCT_NP_OH = co.hevmol[ipNP]*co.hevmol[ipOH];
		PRODUCT_NP_H2O = co.hevmol[ipNP]*co.hevmol[ipH2O];
		PRODUCT_NP_CO = co.hevmol[ipNP]*co.hevmol[ipCO];
		PRODUCT_NP_O2 = co.hevmol[ipNP]*co.hevmol[ipO2];
		PRODUCT_OP_O2 = co.hevmol[ipOP]*co.hevmol[ipO2];
		PRODUCT_OHP_S = co.hevmol[ipOHP]*co.hevmol[ipATS];
		PRODUCT_H2OP_S = co.hevmol[ipH2OP]*co.hevmol[ipATS];
		PRODUCT_COP_S = co.hevmol[ipCOP]*co.hevmol[ipATS];
		PRODUCT_SI_SP = co.hevmol[ipATSI]*co.hevmol[ipSP];
		PRODUCT_O2P_S = co.hevmol[ipO2P]*co.hevmol[ipATS];


		bvec_C_NH_N_CH          = hmrate(0.0000000000173,0.5,4000)*PRODUCT_C_NH;
		bvec_C_NH_CN_H            = hmrate(0.00000000011,0.5,0)*PRODUCT_C_NH;
		bvec_C_NH2_NH_CH          = hmrate(0.000000000000962,0,10517)*PRODUCT_C_NH2;
		bvec_C_N2_CN_N          = hmrate(0.0000000000869,0,22600)*PRODUCT_C_N2;
		bvec_C_NO_CN_O            = hmrate(0.000000000048,0,0)*PRODUCT_C_NO;
		bvec_C_NO_CO_N          = hmrate(0.0000000000465,0,0)*PRODUCT_C_NO;
		bvec_C_HS_S_CH            = hmrate(0.000000000012,0.58,5880)*PRODUCT_C_HS;
		bvec_C_HS_CS_H            = hmrate(0.00000000002,0,0)*PRODUCT_C_HS;
		bvec_C_OCN_CO_CN          = hmrate(0.00000000004,0.5,0)*PRODUCT_C_OCN;
		bvec_C_NS_S_CN            = hmrate(0.00000000002,0.5,0)*PRODUCT_C_NS;
		bvec_C_NS_CS_N          = hmrate(0.0000000000173,0.5,4000)*PRODUCT_C_NS;
		bvec_C_SO_S_CO            = hmrate(0.000000000072,0,0)*PRODUCT_C_SO;
		bvec_C_SO_CS_O            = hmrate(0.00000000017,0,0)*PRODUCT_C_SO;
		bvec_C_S2_CS_S            = hmrate(0.0000000000173,0.5,0)*PRODUCT_C_S2;
		bvec_CH_N_NH_C          = hmrate(0.0000000000303,0.65,1207)*PRODUCT_CH_N;
		bvec_CH_N_CN_H          = hmrate(0.000000000166,-0.09,0)*PRODUCT_CH_N;
		bvec_CH_N2_HCN_N        = hmrate(0.00000000000056,0.88,10128)*PRODUCT_CH_N2;
		bvec_CH_NO_HCN_O          = hmrate(0.00000000559,0,10814)*PRODUCT_CH_NO;
		bvec_CH_NO_CN_OH          = hmrate(2.32E-26,0,0)*PRODUCT_CH_NO;
		bvec_CH_NO_OCN_H          = hmrate(1.13E-25,0,0)*PRODUCT_CH_NO;
		bvec_CH_HNO_NO_CH2        = hmrate(0.0000000000173,0.5,0)*PRODUCT_CH_HNO;
		bvec_CH_S_HS_C          = hmrate(0.0000000000173,0.5,4000)*PRODUCT_CH_S;
		bvec_CH_S_CS_H          = hmrate(0.0000000000011,0,0)*PRODUCT_CH_S;
		bvec_N_NH_N2_H          = hmrate(0.0000000000498,0,0)*PRODUCT_N_NH;
		bvec_N_CH3_HCN_H_H      = hmrate(0.000000000000332,0,0)*PRODUCT_N_CH3;
		bvec_N_CH3_HCN_H2       = hmrate(0.000000000013,0.5,0)*PRODUCT_N_CH3;
		bvec_N_OH_O_NH          = hmrate(0.0000000000188,0.1,10700)*PRODUCT_N_OH;
		bvec_N_OH_NO_H          = hmrate(0.0000000000532,-0.25,0)*PRODUCT_N_OH;
		bvec_N_CN_N2_C          = hmrate(0.0000000003,0,0)*PRODUCT_N_CN;
		bvec_N_SIH_SIN_H          = hmrate(0.00000000005,0.5,0)*PRODUCT_N_SIH;
		bvec_N_NO_N2_O          = hmrate(0.0000000000375,0,26)*PRODUCT_N_NO;
		bvec_N_HNO_NO_NH          = hmrate(0.00000000000294,0.5,1000)*PRODUCT_N_HNO;
		bvec_N_HNO_N2O_H          = hmrate(0.00000000000143,0.5,1500)*PRODUCT_N_HNO;
		bvec_N_O2_NO_O          = hmrate(0.00000000000226,0.86,3134)*PRODUCT_N_O2;
		bvec_N_HS_NS_H          = hmrate(0.0000000000173,0.5,0)*PRODUCT_N_HS;
		bvec_N_HS_S_NH          = hmrate(0.0000000000173,0.5,9060)*PRODUCT_N_HS;
		bvec_N_CS_S_CN          = hmrate(0.000000000038,0.5,1160)*PRODUCT_N_CS;
		bvec_N_NS_S_N2          = hmrate(0.0000000000173,0.5,0)*PRODUCT_N_NS;
		bvec_N_SO_NS_O          = hmrate(0.0000000000468,0.5,8254)*PRODUCT_N_SO;
		bvec_N_SO_S_NO          = hmrate(0.0000000000173,0.5,750)*PRODUCT_N_SO;
		bvec_N_S2_NS_S          = hmrate(0.0000000000173,0.5,4000)*PRODUCT_N_S2;
		bvec_CH2_CN_HCN_CH        = hmrate(0.0000000000053,0,2500)*PRODUCT_CH2_CN;
		bvec_CH2_NO_HCN_OH        = hmrate(0.000000000000832,0,1443)*PRODUCT_CH2_NO;
		bvec_CH2_HNO_NO_CH3       = hmrate(0.0000000000173,0.5,0)*PRODUCT_CH2_HNO;
		bvec_NH_NH_N2_H_H         = hmrate(0.00000000116,0,0)*PRODUCT_NH_NH;
		bvec_NH_NH_N2_H2          = hmrate(0.000000000017,0,0)*PRODUCT_NH_NH;
		bvec_NH_O_OH_N          = hmrate(0.0000000000116,0,0)*PRODUCT_NH_O;
		bvec_NH_O_NO_H          = hmrate(0.000000000116,0,0)*PRODUCT_NH_O;
		bvec_NH_OH_HNO_H          = hmrate(0.0000000000332,0,0)*PRODUCT_NH_OH;
		bvec_NH_OH_NH2_O          = hmrate(0.00000000000293,0.1,5800)*PRODUCT_NH_OH;
		bvec_NH_OH_H2O_N          = hmrate(0.00000000000311,1.2,0)*PRODUCT_NH_OH;
		bvec_NH_H2O_OH_NH2          = hmrate(0.00000000000183,1.6,14090)*PRODUCT_NH_H2O;
		bvec_NH_CN_HCN_N          = hmrate(0.00000000000294,0.5,1000)*PRODUCT_NH_CN;
		bvec_NH_NO_N2O_H          = hmrate(0.000000000116,-1.03,420)*PRODUCT_NH_NO;
		bvec_NH_NO_N2_O_H         = hmrate(0.00000000005,0,0)*PRODUCT_NH_NO;
		bvec_NH_NO_N2_OH          = hmrate(0.0000000000146,-0.58,37)*PRODUCT_NH_NO;
		bvec_NH_S_HS_N          = hmrate(0.0000000000173,0.5,4000)*PRODUCT_NH_S;
		bvec_NH_S_NS_H          = hmrate(0.0000000000173,0.5,0)*PRODUCT_NH_S;
		bvec_NH_NO2_HNO_NO          = hmrate(0.00000000000572,0.5,2500)*PRODUCT_NH_NO2;
		bvec_NH_NO2_N2O_OH          = hmrate(0.000000000000144,0, 1140)*PRODUCT_NH_NO2;
		bvec_CH3_NH3_CH4_NH2          = hmrate(0.0000000000000955,0,4890)*PRODUCT_CH3_NH3;
		bvec_CH3_CN_HCN_CH2          = hmrate(0.00000000000921,0.7,1500)*PRODUCT_CH3_CN;
		bvec_CH3_HNO_NO_CH4          = hmrate(0.0000000000144,0.5,0)*PRODUCT_CH3_HNO;
		bvec_O_NH2_OH_NH          = hmrate(0.0000000000139,0,40)*PRODUCT_O_NH2;
		bvec_O_NH2_NO_H2          = hmrate(0.0000000000083,0,0)*PRODUCT_O_NH2;
		bvec_O_NH3_OH_NH2          = hmrate(0.0000000000189,0,4003)*PRODUCT_O_NH3;
		bvec_O_CN_NO_C          = hmrate(0.0000000000381,0.5,14545)*PRODUCT_O_CN;
		bvec_O_CN_CO_N          = hmrate(0.0000000000436,0.46,364)*PRODUCT_O_CN;
		bvec_O_HCN_CN_OH          = hmrate(0.000000000621,0,12439)*PRODUCT_O_HCN;
		bvec_O_HCN_CO_NH          = hmrate(0.00000000000073,1.14,3742)*PRODUCT_O_HCN;
		bvec_O_HCN_OCN_H          = hmrate(0.00000000000136,1.38,3693)*PRODUCT_O_HCN;
		bvec_O_N2_NO_N          = hmrate(0.000000000251,0,38602)*PRODUCT_O_N2;
		bvec_O_NO_O2_N          = hmrate(0.0000000000118,0,20413)*PRODUCT_O_NO;
		bvec_O_HNO_NO_OH          = hmrate(0.00000000006,0,0)*PRODUCT_O_HNO;
		bvec_O_HNO_O2_NH          = hmrate(0.00000000000294,0.5,3500)*PRODUCT_O_HNO;
		bvec_O_HNO_NO2_H          = hmrate(0.00000000000144,0.5,0)*PRODUCT_O_HNO;
		bvec_O_HS_S_OH          = hmrate(0.0000000000174,0.67,956)*PRODUCT_O_HS;
		bvec_O_HS_SO_H          = hmrate(0.000000000232,0,0)*PRODUCT_O_HS;
		bvec_O_OCN_NO_CO          = hmrate(0.0000000000943,-0.09,100)*PRODUCT_O_OCN;
		bvec_O_OCN_O2_CN          = hmrate(0.000000000402,-1.43,3501)*PRODUCT_O_OCN;
		bvec_O_SIN_NO_SI          = hmrate(0.000000000025,0.5,0)*PRODUCT_O_SIN;
		bvec_O_SIN_SIO_N          = hmrate(0.0000000000575,0.1,200)*PRODUCT_O_SIN;
		bvec_O_N2O_NO_NO          = hmrate(0.000000000115,0,13400)*PRODUCT_O_N2O;
		bvec_O_N2O_O2_N2          = hmrate(0.000000000166,0,14100)*PRODUCT_O_N2O;
		bvec_O_CS_S_CO          = hmrate(0.000000000248,-0.65,783)*PRODUCT_O_CS;
		bvec_O_CS_SO_C          = hmrate(0.0000000000468,0.5,28940)*PRODUCT_O_CS;
		bvec_O_NS_S_NO          = hmrate(0.00000000005,0.5,0)*PRODUCT_O_NS;
		bvec_O_NS_SO_N          = hmrate(0.0000000000173,0.5,4000)*PRODUCT_O_NS;
		bvec_O_SO_S_O2          = hmrate(0.00000000000066,0,2760)*PRODUCT_O_SO;
		bvec_O_OCS_SO_CO          = hmrate(0.000000000016,0,2150)*PRODUCT_O_OCS;
		bvec_O_S2_SO_S          = hmrate(0.0000000000173,0.5,0)*PRODUCT_O_S2;
		bvec_NH2_OH_NH3_O          = hmrate(0.000000000000208,0.76,262)*PRODUCT_NH2_OH;
		bvec_NH2_OH_H2O_NH          = hmrate(0.0000000000015,0,0)*PRODUCT_NH2_OH;
		bvec_NH2_NO_N2_OH_H         = hmrate(0.00000000000149,0,0)*PRODUCT_NH2_NO;
		bvec_NH2_NO_N2_H2O          = hmrate(0.0000000000427,-2.5,331)*PRODUCT_NH2_NO;
		bvec_CH4_CN_HCN_CH3          = hmrate(0.00000000000314,1.53,504)*PRODUCT_CH4_CN;
		bvec_OH_NH3_H2O_NH2          = hmrate(0.000000000000147,2.05,7)*PRODUCT_OH_NH3;
		bvec_OH_CN_HCN_O          = hmrate(0.00000000001,0,1000)*PRODUCT_OH_CN;
		bvec_OH_CN_OCN_H          = hmrate(0.00000000007,0,0)*PRODUCT_OH_CN;
		bvec_OH_HCN_CN_H2O          = hmrate(0.000000000000187,1.5,3887)*PRODUCT_OH_HCN;
		bvec_OH_HCN_CO_NH2          = hmrate(0.000000000000107,0,5892)*PRODUCT_OH_HCN;
		bvec_OH_NO_NO2_H          = hmrate(0.0000000000052,0,15100)*PRODUCT_OH_NO;
		bvec_OH_S_HS_O          = hmrate(0.000000000066,0,0)*PRODUCT_OH_S;
		bvec_OH_S_SO_H          = hmrate(0.000000000066,0,0)*PRODUCT_OH_S;
		bvec_OH_N2O_HNO_NO          = hmrate(1.04E-17,4.33,12623)*PRODUCT_OH_N2O;
		bvec_OH_CS_OCS_H          = hmrate(0.0000000000000939,1.12,800)*PRODUCT_OH_CS;
		bvec_NH3_CN_HCN_NH2          = hmrate(0.000000000026,-1.1,0)*PRODUCT_NH3_CN;
		bvec_CN_NO_N2_CO          = hmrate(0.000000000179,0,4040)*PRODUCT_CN_NO;
		bvec_CN_NO_OCN_N          = hmrate(0.000000000162,0,21205)*PRODUCT_CN_NO;
		bvec_CN_HNO_NO_HCN          = hmrate(0.000000000015,0.5,0)*PRODUCT_CN_HNO;
		bvec_CN_O2_NO_CO          = hmrate(0.00000000000053,0,0)*PRODUCT_CN_O2;
		bvec_CN_S_NS_C          = hmrate(0.0000000000571,0.5,32010)*PRODUCT_CN_S;
		bvec_CN_S_CS_N          = hmrate(0.0000000000173,0.5,0)*PRODUCT_CN_S;
		bvec_CO_HS_OCS_H          = hmrate(0.0000000000000595,1.12,8330)*PRODUCT_CO_HS;
		bvec_N2_O2_N2O_O          = hmrate(0.0000000001,0,55200)*PRODUCT_N2_O2;
		bvec_NO_NO_O2_N2          = hmrate(0.0000000000251,0,30653)*PRODUCT_NO_NO;
		bvec_NO_NO_N2O_O          = hmrate(0.00000000000722,0,33155)*PRODUCT_NO_NO;
		bvec_NO_HNO_N2O_OH          = hmrate(0.0000000000141,0,14890)*PRODUCT_NO_HNO;
		bvec_NO_S_NS_O          = hmrate(0.0000000000294,0.5,17465)*PRODUCT_NO_S;
		bvec_NO_S_SO_N          = hmrate(0.000000000175,0,20200)*PRODUCT_NO_S;
		bvec_O2_S_SO_O          = hmrate(0.00000000000228,0.52,0)*PRODUCT_O2_S;
		bvec_S_SO_S2_O          = hmrate(0.0000000000173,0.5,11500)*PRODUCT_S_SO;
		bvec_C_NHP_N_CHP          = hmrate(0.0000000016,0,0)*PRODUCT_C_NHP;
		bvec_CP_NH_CNP_H          = hmrate(0.00000000078,0,0)*PRODUCT_CP_NH;
		bvec_CP_NH2_HCNP_H          = hmrate(0.0000000011,0,0)*PRODUCT_CP_NH2;
		bvec_C_NH2P_NH_CHP          = hmrate(0.0000000012,0,0)*PRODUCT_C_NH2P;
		bvec_CP_NH3_HCNP_H2          = hmrate(0.00000000007,0,0)*PRODUCT_CP_NH3;
		bvec_C_NH3P_NH_CH2P          = hmrate(0.00000000001,0,0)*PRODUCT_C_NH3P;
		bvec_C_HCNP_CN_CHP          = hmrate(0.0000000011,0,0)*PRODUCT_C_HCNP;
		bvec_C_HNOP_NO_CHP          = hmrate(0.000000001,0,0)*PRODUCT_C_HNOP;
		bvec_CP_HS_CSP_H          = hmrate(0.0000000011,0,0)*PRODUCT_CP_HS;
		bvec_C_HSP_CSP_H          = hmrate(0.00000000099,0,0)*PRODUCT_C_HSP;
		bvec_CP_OCN_COP_CN          = hmrate(0.0000000038,0,0)*PRODUCT_CP_OCN;
		bvec_CP_NS_CSP_N          = hmrate(0.00000000076,0,0)*PRODUCT_CP_NS;
		bvec_CP_SO_SP_CO          = hmrate(0.00000000026,0,0)*PRODUCT_CP_SO;
		bvec_CP_SO_S_COP          = hmrate(0.00000000026,0,0)*PRODUCT_CP_SO;
		bvec_CP_SO_CSP_O          = hmrate(0.00000000026,0,0)*PRODUCT_CP_SO;
		bvec_CP_OCS_CSP_CO          = hmrate(0.0000000016,0,0)*PRODUCT_CP_OCS;
		bvec_CHP_N_CNP_H          = hmrate(0.00000000019,0,0)*PRODUCT_CHP_N;
		bvec_CH_NP_CNP_H          = hmrate(0.00000000036,0,0)*PRODUCT_CH_NP;
		bvec_CH_NHP_CH2P_N          = hmrate(0.00000000099,0,0)*PRODUCT_CH_NHP;
		bvec_CHP_NH_CNP_H2          = hmrate(0.00000000076,0,0)*PRODUCT_CHP_NH;
		bvec_CHP_NH2_HCNP_H2          = hmrate(0.0000000011,0,0)*PRODUCT_CHP_NH2;
		bvec_CH_NH2P_NH_CH2P          = hmrate(0.00000000035,0,0)*PRODUCT_CH_NH2P;
		bvec_CHP_NH3_NH4P_C          = hmrate(0.000000000405,0,0)*PRODUCT_CHP_NH3;
		bvec_CH_NH3P_NH4P_C          = hmrate(0.00000000069,0,0)*PRODUCT_CH_NH3P;
		bvec_CH_HCNP_CN_CH2P          = hmrate(0.00000000063,0,0)*PRODUCT_CH_HCNP;
		bvec_CH_HNOP_NO_CH2P          = hmrate(0.00000000062,0,0)*PRODUCT_CH_HNOP;
		bvec_CHP_S_HSP_C          = hmrate(0.00000000047,0,0)*PRODUCT_CHP_S;
		bvec_CHP_S_CSP_H          = hmrate(0.00000000047,0,0)*PRODUCT_CHP_S;
		bvec_CH_SP_CSP_H          = hmrate(0.00000000062,0,0)*PRODUCT_CH_SP;
		bvec_CH_HSP_S_CH2P          = hmrate(0.00000000058,0,0)*PRODUCT_CH_HSP;
		bvec_CHP_OCS_HCSP_CO          = hmrate(0.00000000105,0,0)*PRODUCT_CHP_OCS;
		bvec_N_CH2P_HCNP_H          = hmrate(0.00000000022,0,0)*PRODUCT_N_CH2P;
		bvec_NP_NH_N2P_H          = hmrate(0.00000000037,0,0)*PRODUCT_NP_NH;
		bvec_N_NHP_N2P_H          = hmrate(0.0000000013,0,0)*PRODUCT_N_NHP;
		bvec_NP_CH4_HCNP_H2_H          = hmrate(0.000000000056,0,0)*PRODUCT_NP_CH4;
		bvec_N_OHP_NOP_H          = hmrate(0.00000000089,0,0)*PRODUCT_N_OHP;
		bvec_NP_NH3_NH2P_NH          = hmrate(0.000000000216,0,0)*PRODUCT_NP_NH3;
		bvec_N_H2OP_HNOP_H          = hmrate(0.00000000019,0,0)*PRODUCT_N_H2OP;
		bvec_NP_CO_NOP_C          = hmrate(0.000000000145,0,0)*PRODUCT_NP_CO;
		bvec_NP_NO_N2P_O          = hmrate(0.000000000079,0,0)*PRODUCT_NP_NO;
		bvec_NP_O2_NO_OP          = hmrate(0.0000000000366,0,0)*PRODUCT_NP_O2;
		bvec_NP_O2_NOP_O          = hmrate(0.000000000263,0,0)*PRODUCT_NP_O2;
		bvec_N_O2P_NOP_O          = hmrate(0.00000000018,0,0)*PRODUCT_N_O2P;
		bvec_N_HSP_NSP_H          = hmrate(0.00000000074,0,0)*PRODUCT_N_HSP;
		bvec_N_SIOP_NOP_SI          = hmrate(0.00000000009,0,0)*PRODUCT_N_SIOP;
		bvec_N_SIOP_NO_SIP          = hmrate(0.00000000021,0,0)*PRODUCT_N_SIOP;
		bvec_N_SOP_NSP_O          = hmrate(0.00000000005,0,0)*PRODUCT_N_SOP;
		bvec_NP_OCS_SP_CO_N          = hmrate(0.000000000308,0,0)*PRODUCT_NP_OCS;
		bvec_NP_OCS_CSP_NO          = hmrate(0.00000000007,0,0)*PRODUCT_NP_OCS;
		bvec_CH2_NHP_CH3P_N          = hmrate(0.0000000014,0,0)*PRODUCT_CH2_NHP;
		bvec_CH2_NH2P_CH3P_NH          = hmrate(0.00000000049,0,0)*PRODUCT_CH2_NH2P;
		bvec_CH2P_NH3_NH4P_CH          = hmrate(0.00000000126,0,0)*PRODUCT_CH2P_NH3;
		bvec_CH2_NH3P_NH2_CH3P          = hmrate(0.00000000096,0,0)*PRODUCT_CH2_NH3P;
		bvec_CH2_HCNP_CN_CH3P          = hmrate(0.00000000087,0,0)*PRODUCT_CH2_HCNP;
		bvec_CH2_HNOP_NO_CH3P          = hmrate(0.00000000086,0,0)*PRODUCT_CH2_HNOP;
		bvec_CH2P_S_HCSP_H          = hmrate(0.0000000014,0,0)*PRODUCT_CH2P_S;
		bvec_CH2_SP_HCSP_H          = hmrate(0.00000000001,0,0)*PRODUCT_CH2_SP;
		bvec_NHP_NH_NH2P_N          = hmrate(0.000000001,0,0)*PRODUCT_NHP_NH;
		bvec_NHP_O_OHP_N          = hmrate(0.000000001,0,0)*PRODUCT_NHP_O;
		bvec_NH_OP_NOP_H          = hmrate(0.00000000036,0,0)*PRODUCT_NH_OP;
		bvec_NHP_NH2_NH3P_N          = hmrate(0.0000000015,0,0)*PRODUCT_NHP_NH2;
		bvec_NH_NH2P_NH3P_N          = hmrate(0.00000000073,0,0)*PRODUCT_NH_NH2P;
		bvec_NHP_OH_H2OP_N          = hmrate(0.000000001,0,0)*PRODUCT_NHP_OH;
		bvec_NH_OHP_NH2P_O          = hmrate(0.00000000036,0,0)*PRODUCT_NH_OHP;
		bvec_NHP_NH3_NH4P_N          = hmrate(0.0000000006,0,0)*PRODUCT_NHP_NH3;
		bvec_NH_NH3P_NH4P_N          = hmrate(0.00000000071,0,0)*PRODUCT_NH_NH3P;
		bvec_NH_CH5P_CH4_NH2P          = hmrate(0.00000000071,0,0)*PRODUCT_NH_CH5P;
		bvec_NHP_H2O_NH3P_O          = hmrate(0.000000000175,0,0)*PRODUCT_NHP_H2O;
		bvec_NHP_H2O_H3OP_N          = hmrate(0.00000000105,0,0)*PRODUCT_NHP_H2O;
		bvec_NHP_H2O_HNOP_H2          = hmrate(0.00000000035,0,0)*PRODUCT_NHP_H2O;
		bvec_NH_H2OP_H3OP_N          = hmrate(0.00000000071,0,0)*PRODUCT_NH_H2OP;
		bvec_NHP_H2O_OH_NH2P          = hmrate(0.000000000875,0,0)*PRODUCT_NHP_H2O;
		bvec_NHP_CN_HCNP_N          = hmrate(0.0000000016,0,0)*PRODUCT_NHP_CN;
		bvec_NH_HCNP_CN_NH2P          = hmrate(0.00000000065,0,0)*PRODUCT_NH_HCNP;
		bvec_NHP_CO_HCOP_N          = hmrate(0.000000000441,0,0)*PRODUCT_NHP_CO;
		bvec_NH_COP_HCOP_N          = hmrate(0.00000000032,0,0)*PRODUCT_NH_COP;
		bvec_NHP_CO_OCNP_H          = hmrate(0.000000000539,0,0)*PRODUCT_NHP_CO;
		bvec_NH_SIP_SINP_H          = hmrate(0.000000001,0,0)*PRODUCT_NH_SIP;
		bvec_NH_HCOP_CO_NH2P          = hmrate(0.00000000064,0,0)*PRODUCT_NH_HCOP;
		bvec_NH_HNOP_NO_NH2P          = hmrate(0.00000000063,0,0)*PRODUCT_NH_HNOP;
		bvec_NH_O2P_HNOP_O          = hmrate(0.00000000032,0,0)*PRODUCT_NH_O2P;
		bvec_NHP_O2_NOP_OH          = hmrate(0.000000000205,0,0)*PRODUCT_NHP_O2;
		bvec_NH_O2P_NO2P_H          = hmrate(0.00000000032,0,0)*PRODUCT_NH_O2P;
		bvec_NHP_S_HSP_N          = hmrate(0.00000000069,0,0)*PRODUCT_NHP_S;
		bvec_NHP_S_NSP_H          = hmrate(0.00000000069,0,0)*PRODUCT_NHP_S;
		bvec_NH_SP_NSP_H          = hmrate(0.00000000063,0,0)*PRODUCT_NH_SP;
		bvec_CH3P_NH2_CH4NP_H          = hmrate(0.000000001,0,0)*PRODUCT_CH3P_NH2;
		bvec_CH3P_NH3_NH4P_CH2          = hmrate(0.00000000034,0,0)*PRODUCT_CH3P_NH3;
		bvec_CH3P_S_HCSP_H2          = hmrate(0.0000000014,0,0)*PRODUCT_CH3P_S;
		bvec_O_NH2P_HNOP_H          = hmrate(0.000000000072,0,0)*PRODUCT_O_NH2P;
		bvec_O_NH3P_HNOP_H2          = hmrate(0.00000000001,0,0)*PRODUCT_O_NH3P;
		bvec_OP_CN_NOP_C          = hmrate(0.000000001,0,0)*PRODUCT_OP_CN;
		bvec_OP_HCN_COP_NH          = hmrate(0.0000000012,0,0)*PRODUCT_OP_HCN;
		bvec_OP_HCN_NOP_CH          = hmrate(0.0000000012,0,0)*PRODUCT_OP_HCN;
		bvec_OP_HCN_HCOP_N          = hmrate(0.0000000012,0,0)*PRODUCT_OP_HCN;
		bvec_OP_N2_NOP_N          = hmrate(0.0000000000012,0,0)*PRODUCT_OP_N2;
		bvec_O_N2P_NOP_N          = hmrate(0.00000000013,0,0)*PRODUCT_O_N2P;
		bvec_O_HNOP_NO2P_H          = hmrate(0.000000000001,0,0)*PRODUCT_O_HNOP;
		bvec_O_HSP_SP_OH          = hmrate(0.00000000029,0,0)*PRODUCT_O_HSP;
		bvec_O_HSP_SOP_H          = hmrate(0.00000000029,0,0)*PRODUCT_O_HSP;
		bvec_O_SINP_SIOP_N          = hmrate(0.000000001,0,0)*PRODUCT_O_SINP;
		bvec_OP_N2O_NOP_NO          = hmrate(0.00000000063,0,0)*PRODUCT_OP_N2O;
		bvec_O_CSP_S_COP          = hmrate(0.00000000006,0,0)*PRODUCT_O_CSP;
		bvec_O_HCSP_S_HCOP          = hmrate(0.000000000005,0,0)*PRODUCT_O_HCSP;
		bvec_O_HCSP_OCSP_H          = hmrate(0.000000000005,0,0)*PRODUCT_O_HCSP;
		bvec_OP_NO2_O2_NOP          = hmrate(0.00000000083,0,0)*PRODUCT_OP_NO2;
		bvec_O_NSP_S_NOP          = hmrate(0.00000000061,0,0)*PRODUCT_O_NSP;
		bvec_NH2P_NH2_NH3P_NH          = hmrate(0.000000001,0,0)*PRODUCT_NH2P_NH2;
		bvec_NH2_OHP_NH3P_O          = hmrate(0.0000000005,0,0)*PRODUCT_NH2_OHP;
		bvec_NH2P_OH_H2OP_NH          = hmrate(0.00000000071,0,0)*PRODUCT_NH2P_OH;
		bvec_NH2P_NH3_NH4P_NH          = hmrate(0.00000000161,0,0)*PRODUCT_NH2P_NH3;
		bvec_NH2_NH3P_NH4P_NH          = hmrate(0.00000000001,0,0)*PRODUCT_NH2_NH3P;
		bvec_NH2_CH5P_NH3P_CH4          = hmrate(0.00000000099,0,0)*PRODUCT_NH2_CH5P;
		bvec_NH2P_H2O_NH3P_OH          = hmrate(0.0000000001,0,0)*PRODUCT_NH2P_H2O;
		bvec_NH2P_H2O_H3OP_NH          = hmrate(0.00000000276,0,0)*PRODUCT_NH2P_H2O;
		bvec_NH2_H2OP_NH3P_OH          = hmrate(0.00000000049,0,0)*PRODUCT_NH2_H2OP;
		bvec_NH2P_H2O_NH4P_O          = hmrate(0.000000000145,0,0)*PRODUCT_NH2P_H2O;
		bvec_NH2_H3OP_H2O_NH3P          = hmrate(0.00000000097,0,0)*PRODUCT_NH2_H3OP;
		bvec_NH2_HCNP_CN_NH3P          = hmrate(0.0000000009,0,0)*PRODUCT_NH2_HCNP;
		bvec_NH2_COP_HCOP_NH          = hmrate(0.00000000045,0,0)*PRODUCT_NH2_COP;
		bvec_NH2_HCOP_CO_NH3P          = hmrate(0.00000000089,0,0)*PRODUCT_NH2_HCOP;
		bvec_NH2_HNOP_NO_NH3P          = hmrate(0.00000000088,0,0)*PRODUCT_NH2_HNOP;
		bvec_NH2P_O2_HNOP_OH          = hmrate(0.000000000021,0,0)*PRODUCT_NH2P_O2;
		bvec_NH2P_S_HSP_NH          = hmrate(0.00000000044,0,0)*PRODUCT_NH2P_S;
		bvec_CH4P_NH3_NH4P_CH3          = hmrate(0.00000000115,0,0)*PRODUCT_CH4P_NH3;
		bvec_CH4_NH3P_NH4P_CH3          = hmrate(0.00000000048,0,0)*PRODUCT_CH4_NH3P;
		bvec_CH4_N2P_N2_CH2P_H2          = hmrate(0.00000000007,0,0)*PRODUCT_CH4_N2P;
		bvec_CH4_N2P_N2_CH3P_H          = hmrate(0.00000000093,0,0)*PRODUCT_CH4_N2P;
		bvec_CH4_HNOP_NO_CH5P          = hmrate(0.0000000001,0,0)*PRODUCT_CH4_HNOP;
		bvec_CH4_SP_HCSP_H2_H          = hmrate(0.00000000002,0,0)*PRODUCT_CH4_SP;
		bvec_CH4_CSP_HCSP_CH3          = hmrate(0.0000000005,0,0)*PRODUCT_CH4_CSP;
		bvec_OHP_NH3_NH4P_O          = hmrate(0.0000000012,0,0)*PRODUCT_OHP_NH3;
		bvec_OH_NH3P_NH4P_O          = hmrate(0.0000000007,0,0)*PRODUCT_OH_NH3P;
		bvec_OHP_CN_HCNP_O          = hmrate(0.000000001,0,0)*PRODUCT_OHP_CN;
		bvec_OH_HCNP_CN_H2OP          = hmrate(0.00000000063,0,0)*PRODUCT_OH_HCNP;
		bvec_OHP_NO_HNOP_O          = hmrate(0.000000000611,0,0)*PRODUCT_OHP_NO;
		bvec_OH_HNOP_NO_H2OP          = hmrate(0.00000000062,0,0)*PRODUCT_OH_HNOP;
		bvec_OHP_S_HSP_O          = hmrate(0.00000000043,0,0)*PRODUCT_OHP_S;
		bvec_OHP_S_SOP_H          = hmrate(0.00000000043,0,0)*PRODUCT_OHP_S;
		bvec_OH_SP_SOP_H          = hmrate(0.00000000061,0,0)*PRODUCT_OH_SP;
		bvec_NH3P_NH3_NH4P_NH2          = hmrate(0.0000000022,0,0)*PRODUCT_NH3P_NH3;
		bvec_NH3_CH5P_NH4P_CH4          = hmrate(0.0000000025,0,0)*PRODUCT_NH3_CH5P;
		bvec_NH3P_H2O_NH4P_OH          = hmrate(0.00000000011,0,0)*PRODUCT_NH3P_H2O;
		bvec_NH3_H2OP_NH4P_OH          = hmrate(0.000000000945,0,0)*PRODUCT_NH3_H2OP;
		bvec_NH3_H3OP_NH4P_H2O          = hmrate(0.0000000022,0,0)*PRODUCT_NH3_H3OP;
		bvec_NH3_COP_HCOP_NH2          = hmrate(0.0000000000412,0,0)*PRODUCT_NH3_COP;
		bvec_NH3_HCOP_CO_NH4P          = hmrate(0.0000000022,0,0)*PRODUCT_NH3_HCOP;
		bvec_NH3_HNOP_NO_NH4P          = hmrate(0.0000000011,0,0)*PRODUCT_NH3_HNOP;
		bvec_NH3_HSP_S_NH4P          = hmrate(0.000000000975,0,0)*PRODUCT_NH3_HSP;
		bvec_NH3_HCSP_CS_NH4P          = hmrate(0.000000002,0,0)*PRODUCT_NH3_HCSP;
		bvec_CH5P_S_HSP_CH4          = hmrate(0.0000000013,0,0)*PRODUCT_CH5P_S;
		bvec_H2O_CNP_HCNP_OH          = hmrate(0.0000000016,0,0)*PRODUCT_H2O_CNP;
		bvec_H2O_CNP_HCOP_NH          = hmrate(0.00000000016,0,0)*PRODUCT_H2O_CNP;
		bvec_H2O_HCNP_CN_H3OP          = hmrate(0.0000000018,0,0)*PRODUCT_H2O_HCNP;
		bvec_H2O_HNOP_NO_H3OP          = hmrate(0.0000000023,0,0)*PRODUCT_H2O_HNOP;
		bvec_H2OP_S_HSP_OH          = hmrate(0.00000000043,0,0)*PRODUCT_H2OP_S;
		bvec_H2O_HSP_S_H3OP          = hmrate(0.00000000078,0,0)*PRODUCT_H2O_HSP;
		bvec_H3OP_CS_HCSP_H2O          = hmrate(0.000000001,0,0)*PRODUCT_H3OP_CS;
		bvec_CNP_NO_OCNP_N          = hmrate(0.00000000019,0,0)*PRODUCT_CNP_NO;
		bvec_CN_HNOP_NO_HCNP          = hmrate(0.00000000087,0,0)*PRODUCT_CN_HNOP;
		bvec_CNP_O2_NOP_CO          = hmrate(0.000000000086,0,0)*PRODUCT_CNP_O2;
		bvec_CNP_O2_OCNP_O          = hmrate(0.000000000086,0,0)*PRODUCT_CNP_O2;
		bvec_HCNP_CO_HCOP_CN          = hmrate(0.00000000014,0,0)*PRODUCT_HCNP_CO;
		bvec_HCNP_S_HSP_CN          = hmrate(0.00000000057,0,0)*PRODUCT_HCNP_S;
		bvec_CO_HNOP_NO_HCOP          = hmrate(0.0000000001,0,0)*PRODUCT_CO_HNOP;
		bvec_N2P_OCS_SP_N2_CO          = hmrate(0.00000000104,0,0)*PRODUCT_N2P_OCS;
		bvec_HCOP_S_HSP_CO          = hmrate(0.00000000033,0,0)*PRODUCT_HCOP_S;
		bvec_HCOP_CS_HCSP_CO          = hmrate(0.0000000012,0,0)*PRODUCT_HCOP_CS;
		bvec_HNOP_S_HSP_NO          = hmrate(0.0000000011,0,0)*PRODUCT_HNOP_S;
		bvec_O2_SP_SOP_O          = hmrate(0.000000000015,0,0)*PRODUCT_O2_SP;
		bvec_O2P_S_SOP_O          = hmrate(0.00000000054,0,0)*PRODUCT_O2P_S;
		bvec_O2_CSP_OCSP_O          = hmrate(0.00000000013,0,0)*PRODUCT_O2_CSP;
		bvec_S_SIOP_SO_SIP          = hmrate(0.000000001,0,0)*PRODUCT_S_SIOP;
		bvec_CP_NH3_NH3P_C          = hmrate(0.000000000506,0,0)*PRODUCT_CP_NH3;
		bvec_C_CNP_CN_CP          = hmrate(0.00000000011,0,0)*PRODUCT_C_CNP;
		bvec_C_N2P_N2_CP          = hmrate(0.00000000011,0,0)*PRODUCT_C_N2P;
		bvec_CP_NO_NOP_C          = hmrate(0.00000000052,0,0)*PRODUCT_CP_NO;
		bvec_CP_SIN_SINP_C          = hmrate(0.000000001,0,0)*PRODUCT_CP_SIN;
		bvec_C_CSP_CS_CP          = hmrate(0.0000000016,0,0)*PRODUCT_C_CSP;
		bvec_CP_NS_NSP_C          = hmrate(0.00000000076,0,0)*PRODUCT_CP_NS;
		bvec_CP_SO_SOP_C          = hmrate(0.00000000026,0,0)*PRODUCT_CP_SO;
		bvec_CP_OCS_OCSP_C          = hmrate(0.0000000004,0,0)*PRODUCT_CP_OCS;
		bvec_CH_NH2P_NH2_CHP          = hmrate(0.00000000035,0,0)*PRODUCT_CH_NH2P;
		bvec_CHP_NH3_NH3P_CH          = hmrate(0.000000000459,0,0)*PRODUCT_CHP_NH3;
		bvec_CH_CNP_CN_CHP          = hmrate(0.00000000064,0,0)*PRODUCT_CH_CNP;
		bvec_CH_N2P_N2_CHP          = hmrate(0.00000000063,0,0)*PRODUCT_CH_N2P;
		bvec_CHP_NO_NOP_CH          = hmrate(0.00000000076,0,0)*PRODUCT_CHP_NO;
		bvec_NP_NH_NHP_N          = hmrate(0.00000000037,0,0)*PRODUCT_NP_NH;
		bvec_NP_NH2_NH2P_N          = hmrate(0.000000001,0,0)*PRODUCT_NP_NH2;
		bvec_NP_NH3_NH3P_N          = hmrate(0.00000000197,0,0)*PRODUCT_NP_NH3;
		bvec_NP_CN_CNP_N          = hmrate(0.0000000011,0,0)*PRODUCT_NP_CN;
		bvec_NP_HCN_HCNP_N          = hmrate(0.0000000012,0,0)*PRODUCT_NP_HCN;
		bvec_N_N2P_N2_NP          = hmrate(0.00000000001,0,0)*PRODUCT_N_N2P;
		bvec_NP_NO_NOP_N          = hmrate(0.000000000451,0,0)*PRODUCT_NP_NO;
		bvec_NP_OCS_OCSP_N          = hmrate(0.00000000102,0,0)*PRODUCT_NP_OCS;
		bvec_CH2_NH2P_NH2_CH2P          = hmrate(0.00000000049,0,0)*PRODUCT_CH2_NH2P;
		bvec_CH2_CNP_CN_CH2P          = hmrate(0.00000000088,0,0)*PRODUCT_CH2_CNP;
		bvec_CH2_N2P_N2_CH2P          = hmrate(0.00000000087,0,0)*PRODUCT_CH2_N2P;
		bvec_CH2P_NO_NOP_CH2          = hmrate(0.00000000042,0,0)*PRODUCT_CH2P_NO;
		bvec_NH_OP_O_NHP          = hmrate(0.00000000036,0,0)*PRODUCT_NH_OP;
		bvec_NH_OHP_OH_NHP          = hmrate(0.00000000036,0,0)*PRODUCT_NH_OHP;
		bvec_NHP_NH3_NH3P_NH          = hmrate(0.0000000018,0,0)*PRODUCT_NHP_NH3;
		bvec_NHP_H2O_H2OP_NH          = hmrate(0.00000000105,0,0)*PRODUCT_NHP_H2O;
		bvec_NH_CNP_CN_NHP          = hmrate(0.00000000065,0,0)*PRODUCT_NH_CNP;
		bvec_NH_COP_CO_NHP          = hmrate(0.00000000032,0,0)*PRODUCT_NH_COP;
		bvec_NH_N2P_N2_NHP          = hmrate(0.00000000065,0,0)*PRODUCT_NH_N2P;
		bvec_NHP_NO_NOP_NH          = hmrate(0.000000000712,0,0)*PRODUCT_NHP_NO;
		bvec_NHP_O2_O2P_NH          = hmrate(0.000000000451,0,0)*PRODUCT_NHP_O2;
		bvec_NHP_S_SP_NH          = hmrate(0.00000000069,0,0)*PRODUCT_NHP_S;
		bvec_CH3P_NO_NOP_CH3          = hmrate(0.000000001,0,0)*PRODUCT_CH3P_NO;
		bvec_OP_NH2_NH2P_O          = hmrate(0.000000001,0,0)*PRODUCT_OP_NH2;
		bvec_OP_NH3_NH3P_O          = hmrate(0.0000000012,0,0)*PRODUCT_OP_NH3;
		bvec_O_CNP_CN_OP          = hmrate(0.000000000065,0,0)*PRODUCT_O_CNP;
		bvec_O_HCNP_HCN_OP          = hmrate(0.000000000065,0,0)*PRODUCT_O_HCNP;
		bvec_O_N2P_N2_OP          = hmrate(0.00000000001,0,0)*PRODUCT_O_N2P;
		bvec_OP_NO_NOP_O          = hmrate(0.0000000000017,0,0)*PRODUCT_OP_NO;
		bvec_OP_OCS_OCSP_O          = hmrate(0.00000000065,0,0)*PRODUCT_OP_OCS;
		bvec_NH2_OHP_OH_NH2P          = hmrate(0.0000000005,0,0)*PRODUCT_NH2_OHP;
		bvec_NH2P_NH3_NH3P_NH2          = hmrate(0.00000000069,0,0)*PRODUCT_NH2P_NH3;
		bvec_NH2_H2OP_H2O_NH2P          = hmrate(0.00000000049,0,0)*PRODUCT_NH2_H2OP;
		bvec_NH2_CNP_CN_NH2P          = hmrate(0.00000000091,0,0)*PRODUCT_NH2_CNP;
		bvec_NH2_COP_CO_NH2P          = hmrate(0.00000000045,0,0)*PRODUCT_NH2_COP;
		bvec_NH2_N2P_N2_NH2P          = hmrate(0.00000000089,0,0)*PRODUCT_NH2_N2P;
		bvec_NH2P_NO_NOP_NH2          = hmrate(0.0000000007,0,0)*PRODUCT_NH2P_NO;
		bvec_NH2_O2P_O2_NH2P          = hmrate(0.00000000087,0,0)*PRODUCT_NH2_O2P;
		bvec_NH2P_S_SP_NH2          = hmrate(0.00000000044,0,0)*PRODUCT_NH2P_S;
		bvec_CH4P_NH3_NH3P_CH4          = hmrate(0.00000000165,0,0)*PRODUCT_CH4P_NH3;
		bvec_CH4P_OCS_OCSP_CH4          = hmrate(0.00000000042,0,0)*PRODUCT_CH4P_OCS;
		bvec_OHP_NH3_NH3P_OH          = hmrate(0.0000000012,0,0)*PRODUCT_OHP_NH3;
		bvec_OH_CNP_CN_OHP          = hmrate(0.00000000064,0,0)*PRODUCT_OH_CNP;
		bvec_OH_N2P_N2_OHP          = hmrate(0.00000000063,0,0)*PRODUCT_OH_N2P;
		bvec_OHP_NO_NOP_OH          = hmrate(0.000000000359,0,0)*PRODUCT_OHP_NO;
		bvec_NH3_H2OP_H2O_NH3P          = hmrate(0.00000000221,0,0)*PRODUCT_NH3_H2OP;
		bvec_NH3_HCNP_HCN_NH3P          = hmrate(0.00000000168,0,0)*PRODUCT_NH3_HCNP;
		bvec_NH3_COP_CO_NH3P          = hmrate(0.00000000202,0,0)*PRODUCT_NH3_COP;
		bvec_NH3_N2P_N2_NH3P          = hmrate(0.0000000019,0,0)*PRODUCT_NH3_N2P;
		bvec_NH3P_SI_SIP_NH3          = hmrate(0.0000000019,0,0)*PRODUCT_NH3P_SI;
		bvec_NH3P_NO_NOP_NH3          = hmrate(0.00000000072,0,0)*PRODUCT_NH3P_NO;
		bvec_NH3_O2P_O2_NH3P          = hmrate(0.000000002,0,0)*PRODUCT_NH3_O2P;
		bvec_NH3_SP_S_NH3P          = hmrate(0.00000000144,0,0)*PRODUCT_NH3_SP;
		bvec_NH3_HSP_HS_NH3P          = hmrate(0.000000000525,0,0)*PRODUCT_NH3_HSP;
		bvec_NH3_SOP_SO_NH3P          = hmrate(0.0000000013,0,0)*PRODUCT_NH3_SOP;
		bvec_H2O_HCNP_HCN_H2OP          = hmrate(0.0000000018,0,0)*PRODUCT_H2O_HCNP;
		bvec_H2O_N2P_N2_H2OP          = hmrate(0.0000000023,0,0)*PRODUCT_H2O_N2P;
		bvec_H2OP_NO_NOP_H2O          = hmrate(0.00000000027,0,0)*PRODUCT_H2OP_NO;
		bvec_CNP_HCN_HCNP_CN          = hmrate(0.00000000179,0,0)*PRODUCT_CNP_HCN;
		bvec_CNP_CO_COP_CN          = hmrate(0.00000000063,0,0)*PRODUCT_CNP_CO;
		bvec_CN_N2P_N2_CNP          = hmrate(0.0000000001,0,0)*PRODUCT_CN_N2P;
		bvec_CNP_NO_NOP_CN          = hmrate(0.00000000057,0,0)*PRODUCT_CNP_NO;
		bvec_CNP_O2_O2P_CN          = hmrate(0.000000000258,0,0)*PRODUCT_CNP_O2;
		bvec_CNP_S_SP_CN          = hmrate(0.0000000011,0,0)*PRODUCT_CNP_S;
		bvec_HCN_COP_CO_HCNP          = hmrate(0.0000000034,0,0)*PRODUCT_HCN_COP;
		bvec_HCN_N2P_N2_HCNP          = hmrate(0.00000000039,0,0)*PRODUCT_HCN_N2P;
		bvec_HCNP_NO_NOP_HCN          = hmrate(0.00000000081,0,0)*PRODUCT_HCNP_NO;
		bvec_HCNP_O2_O2P_HCN          = hmrate(0.00000000032,0,0)*PRODUCT_HCNP_O2;
		bvec_HCNP_S_SP_HCN          = hmrate(0.00000000057,0,0)*PRODUCT_HCNP_S;
		bvec_CO_N2P_N2_COP          = hmrate(0.000000000074,0,0)*PRODUCT_CO_N2P;
		bvec_COP_NO_NOP_CO          = hmrate(0.00000000033,0,0)*PRODUCT_COP_NO;
		bvec_N2P_NO_NOP_N2          = hmrate(0.00000000044,0,0)*PRODUCT_N2P_NO;
		bvec_N2P_O2_O2P_N2          = hmrate(0.00000000005,0,0)*PRODUCT_N2P_O2;
		bvec_N2P_S_SP_N2          = hmrate(0.0000000011,0,0)*PRODUCT_N2P_S;
		bvec_SI_NOP_NO_SIP          = hmrate(0.0000000016,0,0)*PRODUCT_SI_NOP;
		bvec_SI_HSP_HS_SIP          = hmrate(0.0000000014,0,0)*PRODUCT_SI_HSP;
		bvec_SI_CSP_CS_SIP          = hmrate(0.00000000015,0,0)*PRODUCT_SI_CSP;
		bvec_NO_HNOP_HNO_NOP          = hmrate(0.0000000007,0,0)*PRODUCT_NO_HNOP;
		bvec_NO_O2P_O2_NOP          = hmrate(0.00000000045,0,0)*PRODUCT_NO_O2P;
		bvec_NO_SP_S_NOP          = hmrate(0.00000000037,0,0)*PRODUCT_NO_SP;
		bvec_NO_HSP_HS_NOP          = hmrate(0.00000000045,0,0)*PRODUCT_NO_HSP;
		bvec_NO_SIOP_SIO_NOP          = hmrate(0.00000000072,0,0)*PRODUCT_NO_SIOP;
		bvec_NO_S2P_S2_NOP          = hmrate(0.00000000051,0,0)*PRODUCT_NO_S2P;
		bvec_O2P_NO2_NO2P_O2          = hmrate(0.00000000066,0,0)*PRODUCT_O2P_NO2;
		bvec_S_HSP_HS_SP          = hmrate(0.00000000097,0,0)*PRODUCT_S_HSP;
		bvec_C_N_CN_NU          = hmrate(0.00000000000000001,0,0)*PRODUCT_C_N;
		bvec_C_S_CS_NU          = hmrate(4.36E-19,0.22,0)*PRODUCT_C_S;
		bvec_CP_S_CSP_NU          = hmrate(3.07E-19,0.15,0)*PRODUCT_CP_S;
		bvec_NP_N_N2P_NU          = hmrate(3.71E-18,0.24,26.1)*PRODUCT_NP_N;
		bvec_CO_S_OCS_NU          = hmrate(0.000000000000000016,-1.5,0)*PRODUCT_CO_S;
		bvec_CH_NP_N_CHP          = hmrate(0.00000000036,0,0)*PRODUCT_CH_NP;
		bvec_CHP_S_SP_CH          = hmrate(0.00000000047,0,0)*PRODUCT_CHP_S;
		bvec_NP_CH2_CH2P_N          = hmrate(0.000000001,0,0)*PRODUCT_NP_CH2;
		bvec_NP_CH4_CH4P_N          = hmrate(0.000000000028,0,0)*PRODUCT_NP_CH4;
		bvec_NP_OH_OHP_N          = hmrate(0.00000000037,0,0)*PRODUCT_NP_OH;
		bvec_NP_H2O_H2OP_N          = hmrate(0.0000000028,0,0)*PRODUCT_NP_H2O;
		bvec_NP_CO_COP_N          = hmrate(0.000000000825,0,0)*PRODUCT_NP_CO;
		bvec_NP_O2_O2P_N          = hmrate(0.000000000311,0,0)*PRODUCT_NP_O2;
		bvec_OP_O2_O2P_O          = hmrate(0.000000000019,0,0)*PRODUCT_OP_O2;
		bvec_OHP_S_SP_OH          = hmrate(0.00000000043,0,0)*PRODUCT_OHP_S;
		bvec_H2OP_S_SP_H2O          = hmrate(0.00000000043,0,0)*PRODUCT_H2OP_S;
		bvec_COP_S_SP_CO          = hmrate(0.0000000011,0,0)*PRODUCT_COP_S;
		bvec_SI_SP_S_SIP          = hmrate(0.0000000016,0,0)*PRODUCT_SI_SP;
		bvec_O2P_S_SP_O2          = hmrate(0.00000000054,0,0)*PRODUCT_O2P_S;


		/*  >>refer   molecule   H2     +  N     =>   NH    +     H     UMIST  */

			c[ipATN][ipNH]  += H2_N_NH_H;

		/*  >>refer   molecule   H2     +  NH    =>   NH2   +     H	    UMIST  */
			
			c[ipNH][ipNH]  -= H2_NH_NH2_H;
			c[ipNH][ipNH2] += H2_NH_NH2_H;

		/*  >>refer   molecule   H2     +  NH2   =>   NH3   +     H	    UMIST  */

			c[ipNH2][ipNH2] -= H2_NH2_NH3_H;
			c[ipNH2][ipNH3] += H2_NH2_NH3_H;

		/*  >>refer   molecule   H2     +  CN    =>   HCN   +     H	    UMIST  */

			c[ipCN][ipCN]  -= H2_CN_HCN_H;
			c[ipCN][ipHCN] += H2_CN_HCN_H;

		/*  >>refer   molecule   C      +  NH    =>   N     +     CH    UMIST  */

			c[ipNH][ipNH] -= C_NH_N_CH_1;
			c[ipATC][ipNH] -= C_NH_N_CH_2;
			bvec[ipNH] -= bvec_C_NH_N_CH;
			
			c[ipNH][ipCH] += C_NH_N_CH_1;
			c[ipATC][ipCH] += C_NH_N_CH_2;
			bvec[ipCH] += bvec_C_NH_N_CH;

		/*  >>refer   molecule   C      +  NH    =>   CN    +     H	    UMIST  */

			c[ipNH][ipNH] -= C_NH_CN_H_1;
			c[ipATC][ipNH] -= C_NH_CN_H_2;
			bvec[ipNH] -= bvec_C_NH_CN_H;
			
			c[ipNH][ipCN] += C_NH_CN_H_1;
			c[ipATC][ipCN] += C_NH_CN_H_2;
			bvec[ipCN] += bvec_C_NH_CN_H;

		/*  >>refer   molecule   C      +  N2    =>   CN    +     N	    UMIST  */

			c[ipN2][ipN2] -= C_N2_CN_N_1;
			c[ipATC][ipN2] -= C_N2_CN_N_2;
			bvec[ipN2] -= bvec_C_N2_CN_N;
			
			c[ipN2][ipCN] += C_N2_CN_N_1;
			c[ipATC][ipCN] += C_N2_CN_N_2;
			bvec[ipCN] += bvec_C_N2_CN_N;

		/*  >>refer   molecule   C      +  NO    =>   CN    +     O	    UMIST  */

			c[ipNO][ipNO] -= C_NO_CN_O_1;
			c[ipATC][ipNO] -= C_NO_CN_O_2;
			bvec[ipNO] -= bvec_C_NO_CN_O;
			
			c[ipNO][ipCN] += C_NO_CN_O_1;
			c[ipATC][ipCN] += C_NO_CN_O_2;
			bvec[ipCN] += bvec_C_NO_CN_O;

		/*  >>refer   molecule   C      +  NO    =>   CO    +     N	    UMIST  */

			c[ipNO][ipNO] -= C_NO_CO_N_1;
			c[ipATC][ipNO] -= C_NO_CO_N_2;
			bvec[ipNO] -= bvec_C_NO_CO_N;
			
			c[ipNO][ipCO] += C_NO_CO_N_1;
			c[ipATC][ipCO] += C_NO_CO_N_2;
			bvec[ipCO] += bvec_C_NO_CO_N;

		/*  >>refer   molecule   C      +  HS    =>   S     +     CH    UMIST  */

			c[ipHS][ipHS] -= C_HS_S_CH_1;
			c[ipATC][ipHS] -= C_HS_S_CH_2;
			bvec[ipHS] -= bvec_C_HS_S_CH;
			
			c[ipHS][ipCH] += C_HS_S_CH_1;
			c[ipATC][ipCH] += C_HS_S_CH_2;
			bvec[ipCH] += bvec_C_HS_S_CH;

		/*  >>refer   molecule   C      +  HS    =>   CS    +     H	    UMIST  */

			c[ipHS][ipHS] -= C_HS_CS_H_1;
			c[ipATC][ipHS] -= C_HS_CS_H_2;
			bvec[ipHS] -= bvec_C_HS_CS_H;
			
			c[ipHS][ipCS] += C_HS_CS_H_1;
			c[ipATC][ipCS] += C_HS_CS_H_2;
			bvec[ipCS] += bvec_C_HS_CS_H;

		/*  >>refer   molecule   C      +  OCN   =>   CO    +     CN    UMIST  */

			c[ipOCN][ipOCN] -= C_OCN_CO_CN_1;
			c[ipATC][ipOCN] -= C_OCN_CO_CN_2;
			bvec[ipOCN] -= bvec_C_OCN_CO_CN;
			
			c[ipOCN][ipCO] += C_OCN_CO_CN_1;
			c[ipATC][ipCO] += C_OCN_CO_CN_2;
			bvec[ipCO] += bvec_C_OCN_CO_CN;
			
			c[ipOCN][ipCN] += C_OCN_CO_CN_1;
			c[ipATC][ipCN] += C_OCN_CO_CN_2;
			bvec[ipCN] += bvec_C_OCN_CO_CN;

		/*  >>refer   molecule   C      +  NS    =>   S     +     CN    UMIST  */

			c[ipNS][ipNS] -= C_NS_S_CN_1;
			c[ipATC][ipNS] -= C_NS_S_CN_2;
			bvec[ipNS] -= bvec_C_NS_S_CN;
			
			c[ipNS][ipCN] += C_NS_S_CN_1;
			c[ipATC][ipCN] += C_NS_S_CN_2;
			bvec[ipCN] += bvec_C_NS_S_CN;

		/*  >>refer   molecule   C      +  NS    =>   CS    +     N	    UMIST  */

			c[ipNS][ipNS] -= C_NS_CS_N_1;
			c[ipATC][ipNS] -= C_NS_CS_N_2;
			bvec[ipNS] -= bvec_C_NS_CS_N;
			
			c[ipNS][ipCS] += C_NS_CS_N_1;
			c[ipATC][ipCS] += C_NS_CS_N_2;
			bvec[ipCS] += bvec_C_NS_CS_N;

		/*  >>refer   molecule   C      +  SO    =>   S     +     CO    UMIST  */

			c[ipSO][ipSO] -= C_SO_S_CO_1;
			c[ipATC][ipSO] -= C_SO_S_CO_2;
			bvec[ipSO] -= bvec_C_SO_S_CO;
			
			c[ipSO][ipCO] += C_SO_S_CO_1;
			c[ipATC][ipCO] += C_SO_S_CO_2;
			bvec[ipCO] += bvec_C_SO_S_CO;

		/*  >>refer   molecule   C      +  S2    =>   CS    +     S	    UMIST  */

			c[ipS2][ipS2] -= C_S2_CS_S_1;
			c[ipATC][ipS2] -= C_S2_CS_S_2;
			bvec[ipS2] -= bvec_C_S2_CS_S;
			
			c[ipS2][ipCS] += C_S2_CS_S_1;
			c[ipATC][ipCS] += C_S2_CS_S_2;
			bvec[ipCS] += bvec_C_S2_CS_S;

		/*  >>refer   molecule   CH     +  N     =>   NH    +     C	    UMIST  */

			c[ipATN][ipCH] -= CH_N_NH_C_1;
			c[ipCH][ipCH] -= CH_N_NH_C_2;
			bvec[ipCH] -= bvec_CH_N_NH_C;
			
			c[ipATN][ipNH] += CH_N_NH_C_1;
			c[ipCH][ipNH] += CH_N_NH_C_2;
			bvec[ipNH] += bvec_CH_N_NH_C;

		/*  >>refer   molecule   CH     +  N     =>   CN    +     H	    UMIST  */

			c[ipATN][ipCH] -= CH_N_CN_H_1;
			c[ipCH][ipCH] -= CH_N_CN_H_2;
			bvec[ipCH] -= bvec_CH_N_CN_H;
			
			c[ipATN][ipCN] += CH_N_CN_H_1;
			c[ipCH][ipCN] += CH_N_CN_H_2;
			bvec[ipCN] += bvec_CH_N_CN_H;

		/*  >>refer   molecule   CH     +  N2    =>   HCN   +     N	    UMIST  */

			c[ipN2][ipCH] -= CH_N2_HCN_N_1;
			c[ipCH][ipCH] -= CH_N2_HCN_N_2;
			bvec[ipCH] -= bvec_CH_N2_HCN_N;
			
			c[ipN2][ipN2] -= CH_N2_HCN_N_1;
			c[ipCH][ipN2] -= CH_N2_HCN_N_2;
			bvec[ipN2] -= bvec_CH_N2_HCN_N;
			
			c[ipN2][ipHCN] += CH_N2_HCN_N_1;
			c[ipCH][ipHCN] += CH_N2_HCN_N_2;
			bvec[ipHCN] += bvec_CH_N2_HCN_N;

		/*  >>refer   molecule   CH     +  NO    =>   HCN   +     O	    UMIST  */

			c[ipNO][ipCH] -= CH_NO_HCN_O_1;
			c[ipCH][ipCH] -= CH_NO_HCN_O_2;
			bvec[ipCH] -= bvec_CH_NO_HCN_O;
			
			c[ipNO][ipNO] -= CH_NO_HCN_O_1;
			c[ipCH][ipNO] -= CH_NO_HCN_O_2;
			bvec[ipNO] -= bvec_CH_NO_HCN_O;
			
			c[ipNO][ipHCN] += CH_NO_HCN_O_1;
			c[ipCH][ipHCN] += CH_NO_HCN_O_2;
			bvec[ipHCN] += bvec_CH_NO_HCN_O;

		/*  >>refer   molecule   CH     +  NO    =>   CN    +     OH    UMIST  */

			c[ipNO][ipCH] -= CH_NO_CN_OH_1;
			c[ipCH][ipCH] -= CH_NO_CN_OH_2;
			bvec[ipCH] -= bvec_CH_NO_CN_OH;
			
			c[ipNO][ipNO] -= CH_NO_CN_OH_1;
			c[ipCH][ipNO] -= CH_NO_CN_OH_2;
			bvec[ipNO] -= bvec_CH_NO_CN_OH;
			
			c[ipNO][ipCN] += CH_NO_CN_OH_1;
			c[ipCH][ipCN] += CH_NO_CN_OH_2;
			bvec[ipCN] += bvec_CH_NO_CN_OH;
			
			c[ipNO][ipOH] += CH_NO_CN_OH_1;
			c[ipCH][ipOH] += CH_NO_CN_OH_2;
			bvec[ipOH] += bvec_CH_NO_CN_OH;

		/*  >>refer   molecule   CH     +  NO    =>   OCN   +     H	    UMIST  */

			c[ipNO][ipCH] -= CH_NO_OCN_H_1;
			c[ipCH][ipCH] -= CH_NO_OCN_H_2;
			bvec[ipCH] -= bvec_CH_NO_OCN_H;
			
			c[ipNO][ipNO] -= CH_NO_OCN_H_1;
			c[ipCH][ipNO] -= CH_NO_OCN_H_2;
			bvec[ipNO] -= bvec_CH_NO_OCN_H;
			
			c[ipNO][ipOCN] += CH_NO_OCN_H_1;
			c[ipCH][ipOCN] += CH_NO_OCN_H_2;
			bvec[ipOCN] += bvec_CH_NO_OCN_H;

		/*  >>refer   molecule   CH     +  HNO   =>   NO    +     CH2   UMIST  */

			c[ipHNO][ipCH] -= CH_HNO_NO_CH2_1;
			c[ipCH][ipCH] -= CH_HNO_NO_CH2_2;
			bvec[ipCH] -= bvec_CH_HNO_NO_CH2;
			
			c[ipHNO][ipHNO] -= CH_HNO_NO_CH2_1;
			c[ipCH][ipHNO] -= CH_HNO_NO_CH2_2;
			bvec[ipHNO] -= bvec_CH_HNO_NO_CH2;
			
			c[ipHNO][ipNO] += CH_HNO_NO_CH2_1;
			c[ipCH][ipNO] += CH_HNO_NO_CH2_2;
			bvec[ipNO] += bvec_CH_HNO_NO_CH2;
			
			c[ipHNO][ipCH2] += CH_HNO_NO_CH2_1;
			c[ipCH][ipCH2] += CH_HNO_NO_CH2_2;
			bvec[ipCH2] += bvec_CH_HNO_NO_CH2;

		/*  >>refer   molecule   CH     +  S     =>   HS    +     C	    UMIST  */

			c[ipATS][ipCH] -= CH_S_HS_C_1;
			c[ipCH][ipCH] -= CH_S_HS_C_2;
			bvec[ipCH] -= bvec_CH_S_HS_C;
			
			c[ipATS][ipHS] += CH_S_HS_C_1;
			c[ipCH][ipHS] += CH_S_HS_C_2;
			bvec[ipHS] += bvec_CH_S_HS_C;

		/*  >>refer   molecule   CH     +  S     =>   CS    +     H	    UMIST  */

			c[ipATS][ipCH] -= CH_S_CS_H_1;
			c[ipCH][ipCH] -= CH_S_CS_H_2;
			bvec[ipCH] -= bvec_CH_S_CS_H;
			
			c[ipATS][ipCS] += CH_S_CS_H_1;
			c[ipCH][ipCS] += CH_S_CS_H_2;
			bvec[ipCS] += bvec_CH_S_CS_H;

		/*  >>refer   molecule   N      +  NH    =>   N2    +     H	    UMIST  */

			c[ipNH][ipNH] -= N_NH_N2_H_1;
			c[ipATN][ipNH] -= N_NH_N2_H_2;
			bvec[ipNH] -= bvec_N_NH_N2_H;
			
			c[ipNH][ipN2] += N_NH_N2_H_1;
			c[ipATN][ipN2] += N_NH_N2_H_2;
			bvec[ipN2] += bvec_N_NH_N2_H;

		/*  >>refer   molecule   N      +  CH3   =>   HCN   +     H  +  H      UMIST  */

			c[ipCH3][ipCH3] -= N_CH3_HCN_H_H_1;
			c[ipATN][ipCH3] -= N_CH3_HCN_H_H_2;
			bvec[ipCH3] -= bvec_N_CH3_HCN_H_H;
			
			c[ipCH3][ipHCN] += N_CH3_HCN_H_H_1;
			c[ipATN][ipHCN] += N_CH3_HCN_H_H_2;
			bvec[ipHCN] += bvec_N_CH3_HCN_H_H;

		/*  >>refer   molecule   N      +  CH3   =>   HCN   +     H2    UMIST  */

			c[ipCH3][ipCH3] -= N_CH3_HCN_H2_1;
			c[ipATN][ipCH3] -= N_CH3_HCN_H2_2;
			bvec[ipCH3] -= bvec_N_CH3_HCN_H2;
			
			c[ipCH3][ipHCN] += N_CH3_HCN_H2_1;
			c[ipATN][ipHCN] += N_CH3_HCN_H2_2;
			bvec[ipHCN] += bvec_N_CH3_HCN_H2;

		/*  >>refer   molecule   N      +  OH    =>   O     +     NH    UMIST  */

			c[ipOH][ipOH] -= N_OH_O_NH_1;
			c[ipATN][ipOH] -= N_OH_O_NH_2;
			bvec[ipOH] -= bvec_N_OH_O_NH;
			
			c[ipOH][ipNH] += N_OH_O_NH_1;
			c[ipATN][ipNH] += N_OH_O_NH_2;
			bvec[ipNH] += bvec_N_OH_O_NH;

		/*  >>refer   molecule   N      +  OH    =>   NO    +     H	    UMIST  */

			c[ipOH][ipOH] -= N_OH_NO_H_1;
			c[ipATN][ipOH] -= N_OH_NO_H_2;
			bvec[ipOH] -= bvec_N_OH_NO_H;
			
			c[ipOH][ipNO] += N_OH_NO_H_1;
			c[ipATN][ipNO] += N_OH_NO_H_2;
			bvec[ipNO] += bvec_N_OH_NO_H;

		/*  >>refer   molecule   N      +  CN    =>   N2    +     C	    UMIST  */

			c[ipCN][ipCN] -= N_CN_N2_C_1;
			c[ipATN][ipCN] -= N_CN_N2_C_2;
			bvec[ipCN] -= bvec_N_CN_N2_C;
			
			c[ipCN][ipN2] += N_CN_N2_C_1;
			c[ipATN][ipN2] += N_CN_N2_C_2;
			bvec[ipN2] += bvec_N_CN_N2_C;

		/*  >>refer   molecule   N      +  SIH   =>   SIN   +     H	    UMIST  */

			c[ipSIH][ipSIH] -= N_SIH_SIN_H_1;
			c[ipATN][ipSIH] -= N_SIH_SIN_H_2;
			bvec[ipSIH] -= bvec_N_SIH_SIN_H;
			
			c[ipSIH][ipSIN] += N_SIH_SIN_H_1;
			c[ipATN][ipSIN] += N_SIH_SIN_H_2;
			bvec[ipSIN] += bvec_N_SIH_SIN_H;

		/*  >>refer   molecule   N      +  NO    =>   N2    +     O	    UMIST  */

			c[ipNO][ipNO] -= N_NO_N2_O_1;
			c[ipATN][ipNO] -= N_NO_N2_O_2;
			bvec[ipNO] -= bvec_N_NO_N2_O;
			
			c[ipNO][ipN2] += N_NO_N2_O_1;
			c[ipATN][ipN2] += N_NO_N2_O_2;
			bvec[ipN2] += bvec_N_NO_N2_O;

		/*  >>refer   molecule   N      +  HNO   =>   NO    +     NH    UMIST  */

			c[ipHNO][ipHNO] -= N_HNO_NO_NH_1;
			c[ipATN][ipHNO] -= N_HNO_NO_NH_2;
			bvec[ipHNO] -= bvec_N_HNO_NO_NH;
			
			c[ipHNO][ipNO] += N_HNO_NO_NH_1;
			c[ipATN][ipNO] += N_HNO_NO_NH_2;
			bvec[ipNO] += bvec_N_HNO_NO_NH;
			
			c[ipHNO][ipNH] += N_HNO_NO_NH_1;
			c[ipATN][ipNH] += N_HNO_NO_NH_2;
			bvec[ipNH] += bvec_N_HNO_NO_NH;

		/*  >>refer   molecule   N      +  HNO   =>   N2O   +     H	    UMIST  */

			c[ipHNO][ipHNO] -= N_HNO_N2O_H_1;
			c[ipATN][ipHNO] -= N_HNO_N2O_H_2;
			bvec[ipHNO] -= bvec_N_HNO_N2O_H;
			
			c[ipHNO][ipN2O] += N_HNO_N2O_H_1;
			c[ipATN][ipN2O] += N_HNO_N2O_H_2;
			bvec[ipN2O] += bvec_N_HNO_N2O_H;

		/*  >>refer   molecule   N      +  O2    =>   NO    +     O	    UMIST  */

			c[ipO2][ipO2] -= N_O2_NO_O_1;
			c[ipATN][ipO2] -= N_O2_NO_O_2;
			bvec[ipO2] -= bvec_N_O2_NO_O;
			
			c[ipO2][ipNO] += N_O2_NO_O_1;
			c[ipATN][ipNO] += N_O2_NO_O_2;
			bvec[ipNO] += bvec_N_O2_NO_O;

		/*  >>refer   molecule   N      +  HS    =>   NS    +     H     UMIST  */

			c[ipHS][ipHS] -= N_HS_NS_H_1;
			c[ipATN][ipHS] -= N_HS_NS_H_2;
			bvec[ipHS] -= bvec_N_HS_NS_H;
			
			c[ipHS][ipNS] += N_HS_NS_H_1;
			c[ipATN][ipNS] += N_HS_NS_H_2;
			bvec[ipNS] += bvec_N_HS_NS_H;

		/*  >>refer   molecule   N      +  HS    =>   S     +     NH    UMIST  */

			c[ipHS][ipHS] -= N_HS_S_NH_1;
			c[ipATN][ipHS] -= N_HS_S_NH_2;
			bvec[ipHS] -= bvec_N_HS_S_NH;
			
			c[ipHS][ipNH] += N_HS_S_NH_1;
			c[ipATN][ipNH] += N_HS_S_NH_2;
			bvec[ipNH] += bvec_N_HS_S_NH;

		/*  >>refer   molecule   N      +  CS    =>   S     +     CN    UMIST  */

			c[ipCS][ipCS] -= N_CS_S_CN_1;
			c[ipATN][ipCS] -= N_CS_S_CN_2;
			bvec[ipCS] -= bvec_N_CS_S_CN;
			
			c[ipCS][ipCN] += N_CS_S_CN_1;
			c[ipATN][ipCN] += N_CS_S_CN_2;
			bvec[ipCN] += bvec_N_CS_S_CN;

		/*  >>refer   molecule   N      +  NS    =>   S     +     N2    UMIST  */

			c[ipNS][ipNS] -= N_NS_S_N2_1;
			c[ipATN][ipNS] -= N_NS_S_N2_2;
			bvec[ipNS] -= bvec_N_NS_S_N2;
			
			c[ipNS][ipN2] += N_NS_S_N2_1;
			c[ipATN][ipN2] += N_NS_S_N2_2;
			bvec[ipN2] += bvec_N_NS_S_N2;

		/*  >>refer   molecule   N      +  SO    =>   NS    +     O	    UMIST  */

			c[ipSO][ipSO] -= N_SO_NS_O_1;
			c[ipATN][ipSO] -= N_SO_NS_O_2;
			bvec[ipSO] -= bvec_N_SO_NS_O;

			c[ipSO][ipNS] += N_SO_NS_O_1;
			c[ipATN][ipNS] += N_SO_NS_O_2;
			bvec[ipNS] += bvec_N_SO_NS_O;

		/*  >>refer   molecule   N      +  SO    =>   S     +     NO    UMIST  */

			c[ipSO][ipSO] -= N_SO_S_NO_1;
			c[ipATN][ipSO] -= N_SO_S_NO_2;
			bvec[ipSO] -= bvec_N_SO_S_NO;
			
			c[ipSO][ipNO] += N_SO_S_NO_1;
			c[ipATN][ipNO] += N_SO_S_NO_2;
			bvec[ipNO] += bvec_N_SO_S_NO;

		/*  >>refer   molecule   N      +  S2    =>   NS    +     S     UMIST  */

			c[ipS2][ipS2] -= N_S2_NS_S_1;
			c[ipATN][ipS2] -= N_S2_NS_S_2;
			bvec[ipS2] -= bvec_N_S2_NS_S;
			
			c[ipS2][ipNS] += N_S2_NS_S_1;
			c[ipATN][ipNS] += N_S2_NS_S_2;
			bvec[ipNS] += bvec_N_S2_NS_S;

		/*  >>refer   molecule   CH2    +  CN    =>   HCN   +     CH    UMIST  */

			c[ipCN][ipCH2] -= CH2_CN_HCN_CH_1;
			c[ipCH2][ipCH2] -= CH2_CN_HCN_CH_2;
			bvec[ipCH2] -= bvec_CH2_CN_HCN_CH;
			
			c[ipCN][ipCN] -= CH2_CN_HCN_CH_1;
			c[ipCH2][ipCN] -= CH2_CN_HCN_CH_2;
			bvec[ipCN] -= bvec_CH2_CN_HCN_CH;
			
			c[ipCN][ipHCN] += CH2_CN_HCN_CH_1;
			c[ipCH2][ipHCN] += CH2_CN_HCN_CH_2;
			bvec[ipHCN] += bvec_CH2_CN_HCN_CH;
			
			c[ipCN][ipCH] += CH2_CN_HCN_CH_1;
			c[ipCH2][ipCH] += CH2_CN_HCN_CH_2;
			bvec[ipCH] += bvec_CH2_CN_HCN_CH;

		/*  >>refer   molecule   CH2    +  NO    =>   HCN   +     OH    UMIST  */

			c[ipNO][ipCH2] -= CH2_NO_HCN_OH_1;
			c[ipCH2][ipCH2] -= CH2_NO_HCN_OH_2;
			bvec[ipCH2] -= bvec_CH2_NO_HCN_OH;
			
			c[ipNO][ipNO] -= CH2_NO_HCN_OH_1;
			c[ipCH2][ipNO] -= CH2_NO_HCN_OH_2;
			bvec[ipNO] -= bvec_CH2_NO_HCN_OH;
			
			c[ipNO][ipHCN] += CH2_NO_HCN_OH_1;
			c[ipCH2][ipHCN] += CH2_NO_HCN_OH_2;
			bvec[ipHCN] += bvec_CH2_NO_HCN_OH;
			
			c[ipNO][ipOH] += CH2_NO_HCN_OH_1;
			c[ipCH2][ipOH] += CH2_NO_HCN_OH_2;
			bvec[ipOH] += bvec_CH2_NO_HCN_OH;

		/*  >>refer   molecule   CH2    +  HNO   =>   NO    +     CH3   UMIST  */

			c[ipHNO][ipHNO] -= CH2_HNO_NO_CH3_1;
			c[ipCH2][ipHNO] -= CH2_HNO_NO_CH3_2;
			bvec[ipHNO] -= bvec_CH2_HNO_NO_CH3;
			
			c[ipHNO][ipCH2] -= CH2_HNO_NO_CH3_1;
			c[ipCH2][ipCH2] -= CH2_HNO_NO_CH3_2;
			bvec[ipCH2] -= bvec_CH2_HNO_NO_CH3;
			
			c[ipHNO][ipNO] += CH2_HNO_NO_CH3_1;
			c[ipCH2][ipNO] += CH2_HNO_NO_CH3_2;
			bvec[ipNO] += bvec_CH2_HNO_NO_CH3;
			
			c[ipHNO][ipCH3] += CH2_HNO_NO_CH3_1;
			c[ipCH2][ipCH3] += CH2_HNO_NO_CH3_2;
			bvec[ipCH3] += bvec_CH2_HNO_NO_CH3;

		/*  >>refer   molecule   NH     +  NH    =>   N2    +     H  +  H      UMIST  */

			c[ipNH][ipNH] -= NH_NH_N2_H_H_1;
			c[ipNH][ipNH] -= NH_NH_N2_H_H_2;
			bvec[ipNH] -= bvec_NH_NH_N2_H_H;
			
			c[ipNH][ipN2] += 0.5*NH_NH_N2_H_H_1;
			c[ipNH][ipN2] += 0.5*NH_NH_N2_H_H_2;
			bvec[ipN2] += 0.5*bvec_NH_NH_N2_H_H;
			
		/*  >>refer   molecule   NH     +  NH    =>   N2    +     H2    UMIST  */

			c[ipNH][ipNH] -= NH_NH_N2_H2_1;
			c[ipNH][ipNH] -= NH_NH_N2_H2_2;
			bvec[ipNH] -= bvec_NH_NH_N2_H2;
			
			c[ipNH][ipN2] += 0.5*NH_NH_N2_H2_1;
			c[ipNH][ipN2] += 0.5*NH_NH_N2_H2_2;
			bvec[ipN2] += 0.5*bvec_NH_NH_N2_H2;
			
		/*  >>refer   molecule   NH     +  O     =>   OH    +     N     UMIST  */

			c[ipATO][ipNH] -= NH_O_OH_N_1;
			c[ipNH][ipNH] -= NH_O_OH_N_2;
			bvec[ipNH] -= bvec_NH_O_OH_N;
			
			c[ipATO][ipOH] += NH_O_OH_N_1;
			c[ipNH][ipOH] += NH_O_OH_N_2;
			bvec[ipOH] += bvec_NH_O_OH_N;

		/*  >>refer   molecule   NH     +  O     =>   NO    +     H     UMIST  */

			c[ipATO][ipNH] -= NH_O_NO_H_1;
			c[ipNH][ipNH] -= NH_O_NO_H_2;
			bvec[ipNH] -= bvec_NH_O_NO_H;
			
			c[ipATO][ipNO] += NH_O_NO_H_1;
			c[ipNH][ipNO] += NH_O_NO_H_2;
			bvec[ipNO] += bvec_NH_O_NO_H;

		/*  >>refer   molecule   NH     +  OH    =>   HNO   +     H     UMIST  */

			c[ipOH][ipNH] -= NH_OH_HNO_H_1;
			c[ipNH][ipNH] -= NH_OH_HNO_H_2;
			bvec[ipNH] -= bvec_NH_OH_HNO_H;
			
			c[ipOH][ipOH] -= NH_OH_HNO_H_1;
			c[ipNH][ipOH] -= NH_OH_HNO_H_2;
			bvec[ipOH] -= bvec_NH_OH_HNO_H;
			
			c[ipOH][ipHNO] += NH_OH_HNO_H_1;
			c[ipNH][ipHNO] += NH_OH_HNO_H_2;
			bvec[ipHNO] += bvec_NH_OH_HNO_H;

		/*  >>refer   molecule   NH     +  OH    =>   NH2   +     O     UMIST  */

			c[ipOH][ipOH] -= NH_OH_NH2_O_1;
			c[ipNH][ipOH] -= NH_OH_NH2_O_2;
			bvec[ipOH] -= bvec_NH_OH_NH2_O;
			
			c[ipOH][ipNH] -= NH_OH_NH2_O_1;
			c[ipNH][ipNH] -= NH_OH_NH2_O_2;
			bvec[ipNH] -= bvec_NH_OH_NH2_O;
			
			c[ipOH][ipNH2] += NH_OH_NH2_O_1;
			c[ipNH][ipNH2] += NH_OH_NH2_O_2;
			bvec[ipNH2] += bvec_NH_OH_NH2_O;
			
		/*  >>refer   molecule   NH     +  OH    =>   H2O   +     N     UMIST  */

			c[ipOH][ipOH] -= NH_OH_H2O_N_1;
			c[ipNH][ipOH] -= NH_OH_H2O_N_2;
			bvec[ipOH] -= bvec_NH_OH_H2O_N;
			
			c[ipOH][ipNH] -= NH_OH_H2O_N_1;
			c[ipNH][ipNH] -= NH_OH_H2O_N_2;
			bvec[ipNH] -= bvec_NH_OH_H2O_N;
			
			c[ipOH][ipH2O] += NH_OH_H2O_N_1;
			c[ipNH][ipH2O] += NH_OH_H2O_N_2;
			bvec[ipH2O] += bvec_NH_OH_H2O_N;

		/*  >>refer   molecule   NH     +  H2O   =>   OH    +     NH2   UMIST  */

			c[ipH2O][ipNH] -= NH_H2O_OH_NH2_1;
			c[ipNH][ipNH] -= NH_H2O_OH_NH2_2;
			bvec[ipNH] -= bvec_NH_H2O_OH_NH2;
			
			c[ipH2O][ipH2O] -= NH_H2O_OH_NH2_1;
			c[ipNH][ipH2O] -= NH_H2O_OH_NH2_2;
			bvec[ipH2O] -= bvec_NH_H2O_OH_NH2;
			
			c[ipH2O][ipOH] += NH_H2O_OH_NH2_1;
			c[ipNH][ipOH] += NH_H2O_OH_NH2_2;
			bvec[ipOH] += bvec_NH_H2O_OH_NH2;
			
			c[ipH2O][ipNH2] += NH_H2O_OH_NH2_1;
			c[ipNH][ipNH2] += NH_H2O_OH_NH2_2;
			bvec[ipNH2] += bvec_NH_H2O_OH_NH2;

		/*  >>refer   molecule   NH     +  CN    =>   HCN   +     N     UMIST  */

			c[ipCN][ipNH] -= NH_CN_HCN_N_1;
			c[ipNH][ipNH] -= NH_CN_HCN_N_2;
			bvec[ipNH] -= bvec_NH_CN_HCN_N;
			
			c[ipCN][ipCN] -= NH_CN_HCN_N_1;
			c[ipNH][ipCN] -= NH_CN_HCN_N_2;
			bvec[ipCN] -= bvec_NH_CN_HCN_N;
			
			c[ipCN][ipHCN] += NH_CN_HCN_N_1;
			c[ipNH][ipHCN] += NH_CN_HCN_N_2;
			bvec[ipHCN] += bvec_NH_CN_HCN_N;
			
		/*  >>refer   molecule   NH     +  NO    =>   N2O   +     H     UMIST  */

			c[ipNO][ipNH] -= NH_NO_N2O_H_1;
			c[ipNH][ipNH] -= NH_NO_N2O_H_2;
			bvec[ipNH] -= bvec_NH_NO_N2O_H;
			
			c[ipNO][ipNO] -= NH_NO_N2O_H_1;
			c[ipNH][ipNO] -= NH_NO_N2O_H_2;
			bvec[ipNO] -= bvec_NH_NO_N2O_H;
			
			c[ipNO][ipN2O] += NH_NO_N2O_H_1;
			c[ipNH][ipN2O] += NH_NO_N2O_H_2;
			bvec[ipN2O] += bvec_NH_NO_N2O_H;

		/*  >>refer   molecule   NH     +  NO    =>   N2    +     O  +  H      UMIST  */

			c[ipNO][ipNH] -= NH_NO_N2_O_H_1;
			c[ipNH][ipNH] -= NH_NO_N2_O_H_2;
			bvec[ipNH] -= bvec_NH_NO_N2_O_H;
			
			c[ipNO][ipNO] -= NH_NO_N2_O_H_1;
			c[ipNH][ipNO] -= NH_NO_N2_O_H_2;
			bvec[ipNO] -= bvec_NH_NO_N2_O_H;
			
			c[ipNO][ipN2] += NH_NO_N2_O_H_1;
			c[ipNH][ipN2] += NH_NO_N2_O_H_2;
			bvec[ipN2] += bvec_NH_NO_N2_O_H;

		/*  >>refer   molecule   NH     +  NO    =>   N2    +     OH    UMIST  */

			c[ipNO][ipNH] -= NH_NO_N2_OH_1;
			c[ipNH][ipNH] -= NH_NO_N2_OH_2;
			bvec[ipNH] -= bvec_NH_NO_N2_OH;
			
			c[ipNO][ipNO] -= NH_NO_N2_OH_1;
			c[ipNH][ipNO] -= NH_NO_N2_OH_2;
			bvec[ipNO] -= bvec_NH_NO_N2_OH;
			
			c[ipNO][ipN2] += NH_NO_N2_OH_1;
			c[ipNH][ipN2] += NH_NO_N2_OH_2;
			bvec[ipN2] += bvec_NH_NO_N2_OH;
			
			c[ipNO][ipOH] += NH_NO_N2_OH_1;
			c[ipNH][ipOH] += NH_NO_N2_OH_2;
			bvec[ipOH] += bvec_NH_NO_N2_OH;

		/*  >>refer   molecule   NH     +  S     =>   HS    +     N     UMIST  */

			c[ipATS][ipNH] -= NH_S_HS_N_1;
			c[ipNH][ipNH] -= NH_S_HS_N_2;
			bvec[ipNH] -= bvec_NH_S_HS_N;
			
			c[ipATS][ipHS] += NH_S_HS_N_1;
			c[ipNH][ipHS] += NH_S_HS_N_2;
			bvec[ipHS] += bvec_NH_S_HS_N;

		/*  >>refer   molecule   NH     +  S     =>   NS    +     H     UMIST  */

			c[ipATS][ipNH] -= NH_S_NS_H_1;
			c[ipNH][ipNH] -= NH_S_NS_H_2;
			bvec[ipNH] -= bvec_NH_S_NS_H;
			
			c[ipATS][ipNS] += NH_S_NS_H_1;
			c[ipNH][ipNS] += NH_S_NS_H_2;
			bvec[ipNS] += bvec_NH_S_NS_H;

		/*  >>refer   molecule   NH     +  NO2   =>   HNO   +     NO    UMIST  */

			c[ipNO2][ipNH] -= NH_NO2_HNO_NO_1;
			c[ipNH][ipNH] -= NH_NO2_HNO_NO_2;
			bvec[ipNH] -= bvec_NH_NO2_HNO_NO;
			
			c[ipNO2][ipNO2] -= NH_NO2_HNO_NO_1;
			c[ipNH][ipNO2] -= NH_NO2_HNO_NO_2;
			bvec[ipNO2] -= bvec_NH_NO2_HNO_NO;
			
			c[ipNO2][ipHNO] += NH_NO2_HNO_NO_1;
			c[ipNH][ipHNO] += NH_NO2_HNO_NO_2;
			bvec[ipHNO] += bvec_NH_NO2_HNO_NO;
			
			c[ipNO2][ipNO] += NH_NO2_HNO_NO_1;
			c[ipNH][ipNO] += NH_NO2_HNO_NO_2;
			bvec[ipNO] += bvec_NH_NO2_HNO_NO;

		/*  >>refer   molecule   NH     +  NO2   =>   N2O   +     OH    UMIST  */

			c[ipNO2][ipNH] -= NH_NO2_N2O_OH_1;
			c[ipNH][ipNH] -= NH_NO2_N2O_OH_2;
			bvec[ipNH] -= bvec_NH_NO2_N2O_OH;
			
			c[ipNO2][ipNO2] -= NH_NO2_N2O_OH_1;
			c[ipNH][ipNO2] -= NH_NO2_N2O_OH_2;
			bvec[ipNO2] -= bvec_NH_NO2_N2O_OH;
			
			c[ipNO2][ipN2O] += NH_NO2_N2O_OH_1;
			c[ipNH][ipN2O] += NH_NO2_N2O_OH_2;
			bvec[ipN2O] += bvec_NH_NO2_N2O_OH;
			
			c[ipNO2][ipOH] += NH_NO2_N2O_OH_1;
			c[ipNH][ipOH] += NH_NO2_N2O_OH_2;
			bvec[ipOH] += bvec_NH_NO2_N2O_OH;

		/*  >>refer   molecule   CH3    +  NH3   =>   CH4   +     NH2   UMIST  */

			c[ipNH3][ipCH3] -= CH3_NH3_CH4_NH2_1;
			c[ipCH3][ipCH3] -= CH3_NH3_CH4_NH2_2;
			bvec[ipCH3] -= bvec_CH3_NH3_CH4_NH2;
			
			c[ipNH3][ipNH3] -= CH3_NH3_CH4_NH2_1;
			c[ipCH3][ipNH3] -= CH3_NH3_CH4_NH2_2;
			bvec[ipNH3] -= bvec_CH3_NH3_CH4_NH2;
			
			c[ipNH3][ipCH4] += CH3_NH3_CH4_NH2_1;
			c[ipCH3][ipCH4] += CH3_NH3_CH4_NH2_2;
			bvec[ipCH4] += bvec_CH3_NH3_CH4_NH2;
			
			c[ipNH3][ipNH2] += CH3_NH3_CH4_NH2_1;
			c[ipCH3][ipNH2] += CH3_NH3_CH4_NH2_2;
			bvec[ipNH2] += bvec_CH3_NH3_CH4_NH2;

		/*  >>refer   molecule   CH3    +  CN    =>   HCN   +     CH2   UMIST  */

			c[ipCN][ipCH3] -= CH3_CN_HCN_CH2_1;
			c[ipCH3][ipCH3] -= CH3_CN_HCN_CH2_2;
			bvec[ipCH3] -= bvec_CH3_CN_HCN_CH2;
			
			c[ipCN][ipCN] -= CH3_CN_HCN_CH2_1;
			c[ipCH3][ipCN] -= CH3_CN_HCN_CH2_2;
			bvec[ipCN] -= bvec_CH3_CN_HCN_CH2;
			
			c[ipCN][ipCH2] += CH3_CN_HCN_CH2_1;
			c[ipCH3][ipCH2] += CH3_CN_HCN_CH2_2;
			bvec[ipCH2] += bvec_CH3_CN_HCN_CH2;
			
			c[ipCN][ipHCN] += CH3_CN_HCN_CH2_1;
			c[ipCH3][ipHCN] += CH3_CN_HCN_CH2_2;
			bvec[ipHCN] += bvec_CH3_CN_HCN_CH2;

		/*  >>refer   molecule   CH3    +  HNO   =>   NO    +     CH4   UMIST  */

			c[ipHNO][ipCH3] -= CH3_HNO_NO_CH4_1;
			c[ipCH3][ipCH3] -= CH3_HNO_NO_CH4_2;
			bvec[ipCH3] -= bvec_CH3_HNO_NO_CH4;
			
			c[ipHNO][ipHNO] -= CH3_HNO_NO_CH4_1;
			c[ipCH3][ipHNO] -= CH3_HNO_NO_CH4_2;
			bvec[ipHNO] -= bvec_CH3_HNO_NO_CH4;
			
			c[ipHNO][ipNO] += CH3_HNO_NO_CH4_1;
			c[ipCH3][ipNO] += CH3_HNO_NO_CH4_2;
			bvec[ipNO] += bvec_CH3_HNO_NO_CH4;
			
			c[ipHNO][ipCH4] += CH3_HNO_NO_CH4_1;
			c[ipCH3][ipCH4] += CH3_HNO_NO_CH4_2;
			bvec[ipCH4] += bvec_CH3_HNO_NO_CH4;

		/*  >>refer   molecule   O      +  NH2   =>   OH    +     NH    UMIST  */

			c[ipNH2][ipNH2] -= O_NH2_OH_NH_1;
			c[ipATO][ipNH2] -= O_NH2_OH_NH_2;
			bvec[ipNH2] -= bvec_O_NH2_OH_NH;
			
			c[ipNH2][ipOH] += O_NH2_OH_NH_1;
			c[ipATO][ipOH] += O_NH2_OH_NH_2;
			bvec[ipOH] += bvec_O_NH2_OH_NH;
			
			c[ipNH2][ipNH] += O_NH2_OH_NH_1;
			c[ipATO][ipNH] += O_NH2_OH_NH_2;
			bvec[ipNH] += bvec_O_NH2_OH_NH;

		/*  >>refer   molecule   O      +  NH2   =>   NO    +     H2    UMIST  */
			
			c[ipNH2][ipNH2] -= O_NH2_NO_H2_1;
			c[ipATO][ipNH2] -= O_NH2_NO_H2_2;
			bvec[ipNH2] -= bvec_O_NH2_NO_H2;
			
			c[ipNH2][ipNO] += O_NH2_NO_H2_1;
			c[ipATO][ipNO] += O_NH2_NO_H2_2;
			bvec[ipNO] += bvec_O_NH2_NO_H2;
			
		/*  >>refer   molecule   O      +  NH3   =>   OH    +     NH2   UMIST  */

			c[ipNH3][ipNH3] -= O_NH3_OH_NH2_1;
			c[ipATO][ipNH3] -= O_NH3_OH_NH2_2;
			bvec[ipNH3] -= bvec_O_NH3_OH_NH2;
			
			c[ipNH3][ipOH] += O_NH3_OH_NH2_1;
			c[ipATO][ipOH] += O_NH3_OH_NH2_2;
			bvec[ipOH] += bvec_O_NH3_OH_NH2;
			
			c[ipNH3][ipNH2] += O_NH3_OH_NH2_1;
			c[ipATO][ipNH2] += O_NH3_OH_NH2_2;
			bvec[ipNH2] += bvec_O_NH3_OH_NH2;

		/*  >>refer   molecule   O      +  CN    =>   NO    +     C     UMIST  */
			
			c[ipCN][ipCN] -= O_CN_NO_C_1;
			c[ipATO][ipCN] -= O_CN_NO_C_2;
			bvec[ipCN] -= bvec_O_CN_NO_C;
			
			c[ipCN][ipNO] += O_CN_NO_C_1;
			c[ipATO][ipNO] += O_CN_NO_C_2;
			bvec[ipNO] += bvec_O_CN_NO_C;

		/*  >>refer   molecule   O      +  CN    =>   CO    +     N     UMIST  */

			c[ipCN][ipCN] -= O_CN_CO_N_1;
			c[ipATO][ipCN] -= O_CN_CO_N_2;
			bvec[ipCN] -= bvec_O_CN_CO_N;
			
			c[ipCN][ipCO] += O_CN_CO_N_1;
			c[ipATO][ipCO] += O_CN_CO_N_2;
			bvec[ipCO] += bvec_O_CN_CO_N;

		/*  >>refer   molecule   O      +  HCN   =>   CN    +     OH    UMIST  */

			c[ipHCN][ipHCN] -= O_HCN_CN_OH_1;
			c[ipATO][ipHCN] -= O_HCN_CN_OH_2;
			bvec[ipHCN] -= bvec_O_HCN_CN_OH;
			
			c[ipHCN][ipCN] += O_HCN_CN_OH_1;
			c[ipATO][ipCN] += O_HCN_CN_OH_2;
			bvec[ipCN] += bvec_O_HCN_CN_OH;
			
			c[ipHCN][ipOH] += O_HCN_CN_OH_1;
			c[ipATO][ipOH] += O_HCN_CN_OH_2;
			bvec[ipOH] += bvec_O_HCN_CN_OH;

		/*  >>refer   molecule   O      +  HCN   =>   CO    +     NH    UMIST  */

			c[ipHCN][ipHCN] -= O_HCN_CO_NH_1;
			c[ipATO][ipHCN] -= O_HCN_CO_NH_2;
			bvec[ipHCN] -= bvec_O_HCN_CO_NH;
			
			c[ipHCN][ipCO] += O_HCN_CO_NH_1;
			c[ipATO][ipCO] += O_HCN_CO_NH_2;
			bvec[ipCO] += bvec_O_HCN_CO_NH;
			
			c[ipHCN][ipNH] += O_HCN_CO_NH_1;
			c[ipATO][ipNH] += O_HCN_CO_NH_2;
			bvec[ipNH] += bvec_O_HCN_CO_NH;

		/*  >>refer   molecule   O      +  HCN   =>   OCN   +     H     UMIST  */
			
			c[ipHCN][ipHCN] -= O_HCN_OCN_H_1;
			c[ipATO][ipHCN] -= O_HCN_OCN_H_2;
			bvec[ipHCN] -= bvec_O_HCN_OCN_H;
			
			c[ipHCN][ipOCN] += O_HCN_OCN_H_1;
			c[ipATO][ipOCN] += O_HCN_OCN_H_2;
			bvec[ipOCN] += bvec_O_HCN_OCN_H;

		/*  >>refer   molecule   O      +  N2    =>   NO    +     N     UMIST  */

			c[ipN2][ipN2] -= O_N2_NO_N_1;
			c[ipATO][ipN2] -= O_N2_NO_N_2;
			bvec[ipN2] -= bvec_O_N2_NO_N;
			
			c[ipN2][ipNO] += O_N2_NO_N_1;
			c[ipATO][ipNO] += O_N2_NO_N_2;
			bvec[ipNO] += bvec_O_N2_NO_N;

		/*  >>refer   molecule   O      +  NO    =>   O2    +     N     UMIST  */

			c[ipNO][ipNO] -= O_NO_O2_N_1;
			c[ipATO][ipNO] -= O_NO_O2_N_2;
			bvec[ipNO] -= bvec_O_NO_O2_N;
			
			c[ipNO][ipO2] += O_NO_O2_N_1;
			c[ipATO][ipO2] += O_NO_O2_N_2;
			bvec[ipO2] += bvec_O_NO_O2_N;

		/*  >>refer   molecule   O      +  HNO   =>   NO    +     OH    UMIST  */
			
			c[ipHNO][ipHNO] -= O_HNO_NO_OH_1;
			c[ipATO][ipHNO] -= O_HNO_NO_OH_2;
			bvec[ipHNO] -= bvec_O_HNO_NO_OH;
			
			c[ipHNO][ipNO] += O_HNO_NO_OH_1;
			c[ipATO][ipNO] += O_HNO_NO_OH_2;
			bvec[ipNO] += bvec_O_HNO_NO_OH;
			
			c[ipHNO][ipOH] += O_HNO_NO_OH_1;
			c[ipATO][ipOH] += O_HNO_NO_OH_2;
			bvec[ipOH] += bvec_O_HNO_NO_OH;

		/*  >>refer   molecule   O      +  HNO   =>   O2    +     NH    UMIST  */
			
			c[ipHNO][ipHNO] -= O_HNO_O2_NH_1;
			c[ipATO][ipHNO] -= O_HNO_O2_NH_2;
			bvec[ipHNO] -= bvec_O_HNO_O2_NH;
			
			c[ipHNO][ipO2] += O_HNO_O2_NH_1;
			c[ipATO][ipO2] += O_HNO_O2_NH_2;
			bvec[ipO2] += bvec_O_HNO_O2_NH;
			
			c[ipHNO][ipNH] += O_HNO_O2_NH_1;
			c[ipATO][ipNH] += O_HNO_O2_NH_2;
			bvec[ipNH] += bvec_O_HNO_O2_NH;

		/*  >>refer   molecule   O      +  HNO   =>   NO2   +     H     UMIST  */
			
			c[ipHNO][ipHNO] -= O_HNO_NO2_H_1;
			c[ipATO][ipHNO] -= O_HNO_NO2_H_2;
			bvec[ipHNO] -= bvec_O_HNO_NO2_H;
			
			c[ipHNO][ipNO2] += O_HNO_NO2_H_1;
			c[ipATO][ipNO2] += O_HNO_NO2_H_2;
			bvec[ipNO2] += bvec_O_HNO_NO2_H;

		/*  >>refer   molecule   O      +  HS    =>   S     +     OH    UMIST  */

			c[ipHS][ipHS] -= O_HS_S_OH_1;
			c[ipATO][ipHS] -= O_HS_S_OH_2;
			bvec[ipHS] -= bvec_O_HS_S_OH;
			
			c[ipHS][ipOH] += O_HS_S_OH_1;
			c[ipATO][ipOH] += O_HS_S_OH_2;
			bvec[ipOH] += bvec_O_HS_S_OH;

		/*  >>refer   molecule   O      +  HS    =>   SO    +     H     UMIST  */
			
			c[ipHS][ipHS] -= O_HS_SO_H_1;
			c[ipATO][ipHS] -= O_HS_SO_H_2;
			bvec[ipHS] -= bvec_O_HS_SO_H;
			
			c[ipHS][ipSO] += O_HS_SO_H_1;
			c[ipATO][ipSO] += O_HS_SO_H_2;
			bvec[ipSO] += bvec_O_HS_SO_H;

		/*  >>refer   molecule   O      +  OCN   =>   NO    +     CO    UMIST  */
			
			c[ipOCN][ipOCN] -= O_OCN_NO_CO_1;
			c[ipATO][ipOCN] -= O_OCN_NO_CO_2;
			bvec[ipOCN] -= bvec_O_OCN_NO_CO;
			
			c[ipOCN][ipNO] += O_OCN_NO_CO_1;
			c[ipATO][ipNO] += O_OCN_NO_CO_2;
			bvec[ipNO] += bvec_O_OCN_NO_CO;
			
			c[ipOCN][ipCO] += O_OCN_NO_CO_1;
			c[ipATO][ipCO] += O_OCN_NO_CO_2;
			bvec[ipCO] += bvec_O_OCN_NO_CO;

		/*  >>refer   molecule   O      +  OCN   =>   O2    +     CN    UMIST  */
			
			c[ipOCN][ipOCN] -= O_OCN_O2_CN_1;
			c[ipATO][ipOCN] -= O_OCN_O2_CN_2;
			bvec[ipOCN] -= bvec_O_OCN_O2_CN;
			
			c[ipOCN][ipO2] += O_OCN_O2_CN_1;
			c[ipATO][ipO2] += O_OCN_O2_CN_2;
			bvec[ipO2] += bvec_O_OCN_O2_CN;
			
			c[ipOCN][ipCN] += O_OCN_O2_CN_1;
			c[ipATO][ipCN] += O_OCN_O2_CN_2;
			bvec[ipCN] += bvec_O_OCN_O2_CN;

		/*  >>refer   molecule   O      +  SIN   =>   NO    +     SI    UMIST  */

			c[ipSIN][ipSIN] -= O_SIN_NO_SI_1;
			c[ipATO][ipSIN] -= O_SIN_NO_SI_2;
			bvec[ipSIN] -= bvec_O_SIN_NO_SI;
			
			c[ipSIN][ipNO] += O_SIN_NO_SI_1;
			c[ipATO][ipNO] += O_SIN_NO_SI_2;
			bvec[ipNO] += bvec_O_SIN_NO_SI;
			
		/*  >>refer   molecule   O      +  SIN   =>   SIO   +     N     UMIST  */

			c[ipSIN][ipSIN] -= O_SIN_SIO_N_1;
			c[ipATO][ipSIN] -= O_SIN_SIO_N_2;
			bvec[ipSIN] -= bvec_O_SIN_SIO_N;
			
			c[ipSIN][ipSIO] += O_SIN_SIO_N_1;
			c[ipATO][ipSIO] += O_SIN_SIO_N_2;
			bvec[ipSIO] += bvec_O_SIN_SIO_N;

		/*  >>refer   molecule   O      +  N2O   =>   NO    +     NO    UMIST  */

			c[ipN2O][ipN2O] -= O_N2O_NO_NO_1;
			c[ipATO][ipN2O] -= O_N2O_NO_NO_2;
			bvec[ipN2O] -= bvec_O_N2O_NO_NO;
			
			c[ipN2O][ipNO] += O_N2O_NO_NO_1;
			c[ipATO][ipNO] += O_N2O_NO_NO_2;
			bvec[ipNO] += bvec_O_N2O_NO_NO;
			
			c[ipN2O][ipNO] += O_N2O_NO_NO_1;
			c[ipATO][ipNO] += O_N2O_NO_NO_2;
			bvec[ipNO] += bvec_O_N2O_NO_NO;

		/*  >>refer   molecule   O      +  N2O   =>   O2    +     N2    UMIST  */

			c[ipN2O][ipN2O] -= O_N2O_O2_N2_1;
			c[ipATO][ipN2O] -= O_N2O_O2_N2_2;
			bvec[ipN2O] -= bvec_O_N2O_O2_N2;
			
			c[ipN2O][ipO2] += O_N2O_O2_N2_1;
			c[ipATO][ipO2] += O_N2O_O2_N2_2;
			bvec[ipO2] += bvec_O_N2O_O2_N2;
			
			c[ipN2O][ipN2] += O_N2O_O2_N2_1;
			c[ipATO][ipN2] += O_N2O_O2_N2_2;
			bvec[ipN2] += bvec_O_N2O_O2_N2;

		/*  >>refer   molecule   O      +  CS    =>   S     +     CO    UMIST  */

			c[ipCS][ipCS] -= O_CS_S_CO_1;
			c[ipATO][ipCS] -= O_CS_S_CO_2;
			bvec[ipCS] -= bvec_O_CS_S_CO;
			
			c[ipCS][ipCO] += O_CS_S_CO_1;
			c[ipATO][ipCO] += O_CS_S_CO_2;
			bvec[ipCO] += bvec_O_CS_S_CO;

		/*  >>refer   molecule   O      +  CS    =>   SO    +     C     UMIST  */

			c[ipCS][ipCS] -= O_CS_SO_C_1;
			c[ipATO][ipCS] -= O_CS_SO_C_2;
			bvec[ipCS] -= bvec_O_CS_SO_C;
			
			c[ipCS][ipSO] += O_CS_SO_C_1;
			c[ipATO][ipSO] += O_CS_SO_C_2;
			bvec[ipSO] += bvec_O_CS_SO_C;

		/*  >>refer   molecule   O      +  NS    =>   S     +     NO    UMIST  */

			c[ipNS][ipNS] -= O_NS_S_NO_1;
			c[ipATO][ipNS] -= O_NS_S_NO_2;
			bvec[ipNS] -= bvec_O_NS_S_NO;
			
			c[ipNS][ipNO] += O_NS_S_NO_1;
			c[ipATO][ipNO] += O_NS_S_NO_2;
			bvec[ipNO] += bvec_O_NS_S_NO;

		/*  >>refer   molecule   O      +  NS    =>   SO    +     N     UMIST  */

			c[ipNS][ipNS] -= O_NS_SO_N_1;
			c[ipATO][ipNS] -= O_NS_SO_N_2;
			bvec[ipNS] -= bvec_O_NS_SO_N;
			
			c[ipNS][ipSO] += O_NS_SO_N_1;
			c[ipATO][ipSO] += O_NS_SO_N_2;
			bvec[ipSO] += bvec_O_NS_SO_N;

		/*  >>refer   molecule   O      +  SO    =>   S     +     O2    UMIST  */

			c[ipSO][ipSO] -= O_SO_S_O2_1;
			c[ipATO][ipSO] -= O_SO_S_O2_2;
			bvec[ipSO] -= bvec_O_SO_S_O2;
			
			c[ipSO][ipO2] += O_SO_S_O2_1;
			c[ipATO][ipO2] += O_SO_S_O2_2;
			bvec[ipO2] += bvec_O_SO_S_O2;

		/*  >>refer   molecule   O      +  OCS   =>   SO    +     CO    UMIST  */

			c[ipOCS][ipOCS] -= O_OCS_SO_CO_1;
			c[ipATO][ipOCS] -= O_OCS_SO_CO_2;
			bvec[ipOCS] -= bvec_O_OCS_SO_CO;
			
			c[ipOCS][ipSO] += O_OCS_SO_CO_1;
			c[ipATO][ipSO] += O_OCS_SO_CO_2;
			bvec[ipSO] += bvec_O_OCS_SO_CO;
			
			c[ipOCS][ipCO] += O_OCS_SO_CO_1;
			c[ipATO][ipCO] += O_OCS_SO_CO_2;
			bvec[ipCO] += bvec_O_OCS_SO_CO;

		/*  >>refer   molecule   O      +  S2    =>   SO    +     S     UMIST  */

			c[ipS2][ipS2] -= O_S2_SO_S_1;
			c[ipATO][ipS2] -= O_S2_SO_S_2;
			bvec[ipS2] -= bvec_O_S2_SO_S;
			
			c[ipS2][ipSO] += O_S2_SO_S_1;
			c[ipATO][ipSO] += O_S2_SO_S_2;
			bvec[ipSO] += bvec_O_S2_SO_S;

		/*  >>refer   molecule   NH2    +  OH    =>   NH3   +     O     UMIST  */
			
			c[ipOH][ipNH2] -= NH2_OH_NH3_O_1;
			c[ipNH2][ipNH2] -= NH2_OH_NH3_O_2;
			bvec[ipNH2] -= bvec_NH2_OH_NH3_O;

			c[ipOH][ipOH] -= NH2_OH_NH3_O_1;
			c[ipNH2][ipOH] -= NH2_OH_NH3_O_2;
			bvec[ipOH] -= bvec_NH2_OH_NH3_O;
			
			c[ipOH][ipNH3] += NH2_OH_NH3_O_1;
			c[ipNH2][ipNH3] += NH2_OH_NH3_O_2;
			bvec[ipNH3] += bvec_NH2_OH_NH3_O;

		/*  >>refer   molecule   NH2    +  OH    =>   H2O   +     NH    UMIST  */
			
			c[ipOH][ipNH2] -= NH2_OH_H2O_NH_1;
			c[ipNH2][ipNH2] -= NH2_OH_H2O_NH_2;
			bvec[ipNH2] -= bvec_NH2_OH_H2O_NH;
			
			c[ipOH][ipOH] -= NH2_OH_H2O_NH_1;
			c[ipNH2][ipOH] -= NH2_OH_H2O_NH_2;
			bvec[ipOH] -= bvec_NH2_OH_H2O_NH;
			
			c[ipOH][ipH2O] += NH2_OH_H2O_NH_1;
			c[ipNH2][ipH2O] += NH2_OH_H2O_NH_2;
			bvec[ipH2O] += bvec_NH2_OH_H2O_NH;
			
			c[ipOH][ipNH] += NH2_OH_H2O_NH_1;
			c[ipNH2][ipNH] += NH2_OH_H2O_NH_2;
			bvec[ipNH] += bvec_NH2_OH_H2O_NH;

		/*  >>refer   molecule   NH2    +  NO    =>   N2    +     OH +  H      UMIST  */

			c[ipNO][ipNH2] -= NH2_NO_N2_OH_H_1;
			c[ipNH2][ipNH2] -= NH2_NO_N2_OH_H_2;
			bvec[ipNH2] -= bvec_NH2_NO_N2_OH_H;
			
			c[ipNO][ipNO] -= NH2_NO_N2_OH_H_1;
			c[ipNH2][ipNO] -= NH2_NO_N2_OH_H_2;
			bvec[ipNO] -= bvec_NH2_NO_N2_OH_H;
			
			c[ipNO][ipN2] += NH2_NO_N2_OH_H_1;
			c[ipNH2][ipN2] += NH2_NO_N2_OH_H_2;
			bvec[ipN2] += bvec_NH2_NO_N2_OH_H;
			
			c[ipNO][ipOH] += NH2_NO_N2_OH_H_1;
			c[ipNH2][ipOH] += NH2_NO_N2_OH_H_2;
			bvec[ipOH] += bvec_NH2_NO_N2_OH_H;

		/*  >>refer   molecule   NH2    +  NO    =>   N2    +     H2O   UMIST  */

			c[ipNO][ipNH2] -= NH2_NO_N2_H2O_1;
			c[ipNH2][ipNH2] -= NH2_NO_N2_H2O_2;
			bvec[ipNH2] -= bvec_NH2_NO_N2_H2O;
			
			c[ipNO][ipNO] -= NH2_NO_N2_H2O_1;
			c[ipNH2][ipNO] -= NH2_NO_N2_H2O_2;
			bvec[ipNO] -= bvec_NH2_NO_N2_H2O;
			
			c[ipNO][ipN2] += NH2_NO_N2_H2O_1;
			c[ipNH2][ipN2] += NH2_NO_N2_H2O_2;
			bvec[ipN2] += bvec_NH2_NO_N2_H2O;
			
			c[ipNO][ipH2O] += NH2_NO_N2_H2O_1;
			c[ipNH2][ipH2O] += NH2_NO_N2_H2O_2;
			bvec[ipH2O] += bvec_NH2_NO_N2_H2O;

		/*  >>refer   molecule   CH4    +  CN    =>   HCN   +     CH3   UMIST  */

			c[ipCN][ipCH4] -= CH4_CN_HCN_CH3_1;
			c[ipCH4][ipCH4] -= CH4_CN_HCN_CH3_2;
			bvec[ipCH4] -= bvec_CH4_CN_HCN_CH3;
			
			c[ipCN][ipCN] -= CH4_CN_HCN_CH3_1;
			c[ipCH4][ipCN] -= CH4_CN_HCN_CH3_2;
			bvec[ipCN] -= bvec_CH4_CN_HCN_CH3;
			
			c[ipCN][ipHCN] += CH4_CN_HCN_CH3_1;
			c[ipCH4][ipHCN] += CH4_CN_HCN_CH3_2;
			bvec[ipHCN] += bvec_CH4_CN_HCN_CH3;
			
			c[ipCN][ipCH3] += CH4_CN_HCN_CH3_1;
			c[ipCH4][ipCH3] += CH4_CN_HCN_CH3_2;
			bvec[ipCH3] += bvec_CH4_CN_HCN_CH3;

		/*  >>refer   molecule   OH     +  NH3   =>   H2O   +     NH2   UMIST  */

			c[ipNH3][ipOH] -= OH_NH3_H2O_NH2_1;
			c[ipOH][ipOH] -= OH_NH3_H2O_NH2_2;
			bvec[ipOH] -= bvec_OH_NH3_H2O_NH2;
			
			c[ipNH3][ipNH3] -= OH_NH3_H2O_NH2_1;
			c[ipOH][ipNH3] -= OH_NH3_H2O_NH2_2;
			bvec[ipNH3] -= bvec_OH_NH3_H2O_NH2;
			
			c[ipNH3][ipH2O] += OH_NH3_H2O_NH2_1;
			c[ipOH][ipH2O] += OH_NH3_H2O_NH2_2;
			bvec[ipH2O] += bvec_OH_NH3_H2O_NH2;
			
			c[ipNH3][ipNH2] += OH_NH3_H2O_NH2_1;
			c[ipOH][ipNH2] += OH_NH3_H2O_NH2_2;
			bvec[ipNH2] += bvec_OH_NH3_H2O_NH2;

		/*  >>refer   molecule   OH     +  CN    =>   HCN   +     O     UMIST  */

			c[ipCN][ipOH] -= OH_CN_HCN_O_1;
			c[ipOH][ipOH] -= OH_CN_HCN_O_2;
			bvec[ipOH] -= bvec_OH_CN_HCN_O;
			
			c[ipCN][ipCN] -= OH_CN_HCN_O_1;
			c[ipOH][ipCN] -= OH_CN_HCN_O_2;
			bvec[ipCN] -= bvec_OH_CN_HCN_O;
			
			c[ipCN][ipHCN] += OH_CN_HCN_O_1;
			c[ipOH][ipHCN] += OH_CN_HCN_O_2;
			bvec[ipHCN] += bvec_OH_CN_HCN_O;
			
		/*  >>refer   molecule   OH     +  CN    =>   OCN   +     H     UMIST  */

			c[ipCN][ipOH] -= OH_CN_OCN_H_1;
			c[ipOH][ipOH] -= OH_CN_OCN_H_2;
			bvec[ipOH] -= bvec_OH_CN_OCN_H;
			
			c[ipCN][ipCN] -= OH_CN_OCN_H_1;
			c[ipOH][ipCN] -= OH_CN_OCN_H_2;
			bvec[ipCN] -= bvec_OH_CN_OCN_H;
			
			c[ipCN][ipOCN] += OH_CN_OCN_H_1;
			c[ipOH][ipOCN] += OH_CN_OCN_H_2;
			bvec[ipOCN] += bvec_OH_CN_OCN_H;

		/*  >>refer   molecule   OH     +  HCN   =>   CN    +     H2O   UMIST  */

			c[ipHCN][ipOH] -= OH_HCN_CN_H2O_1;
			c[ipOH][ipOH] -= OH_HCN_CN_H2O_2;
			bvec[ipOH] -= bvec_OH_HCN_CN_H2O;
			
			c[ipHCN][ipHCN] -= OH_HCN_CN_H2O_1;
			c[ipOH][ipHCN] -= OH_HCN_CN_H2O_2;
			bvec[ipHCN] -= bvec_OH_HCN_CN_H2O;
			
			c[ipHCN][ipCN] += OH_HCN_CN_H2O_1;
			c[ipOH][ipCN] += OH_HCN_CN_H2O_2;
			bvec[ipCN] += bvec_OH_HCN_CN_H2O;
			
			c[ipHCN][ipH2O] += OH_HCN_CN_H2O_1;
			c[ipOH][ipH2O] += OH_HCN_CN_H2O_2;
			bvec[ipH2O] += bvec_OH_HCN_CN_H2O;

		/*  >>refer   molecule   OH     +  HCN   =>   CO    +     NH2   UMIST  */

			c[ipHCN][ipOH] -= OH_HCN_CO_NH2_1;
			c[ipOH][ipOH] -= OH_HCN_CO_NH2_2;
			bvec[ipOH] -= bvec_OH_HCN_CO_NH2;
			
			c[ipHCN][ipHCN] -= OH_HCN_CO_NH2_1;
			c[ipOH][ipHCN] -= OH_HCN_CO_NH2_2;
			bvec[ipHCN] -= bvec_OH_HCN_CO_NH2;
			
			c[ipHCN][ipCO] += OH_HCN_CO_NH2_1;
			c[ipOH][ipCO] += OH_HCN_CO_NH2_2;
			bvec[ipCO] += bvec_OH_HCN_CO_NH2;
			
			c[ipHCN][ipNH2] += OH_HCN_CO_NH2_1;
			c[ipOH][ipNH2] += OH_HCN_CO_NH2_2;
			bvec[ipNH2] += bvec_OH_HCN_CO_NH2;

		/*  >>refer   molecule   OH     +  NO    =>   NO2   +     H     UMIST  */

			c[ipNO][ipOH] -= OH_NO_NO2_H_1;
			c[ipOH][ipOH] -= OH_NO_NO2_H_2;
			bvec[ipOH] -= bvec_OH_NO_NO2_H;
			
			c[ipNO][ipNO] -= OH_NO_NO2_H_1;
			c[ipOH][ipNO] -= OH_NO_NO2_H_2;
			bvec[ipNO] -= bvec_OH_NO_NO2_H;
			
			c[ipNO][ipNO2] += OH_NO_NO2_H_1;
			c[ipOH][ipNO2] += OH_NO_NO2_H_2;
			bvec[ipNO2] += bvec_OH_NO_NO2_H;
			
		/*  >>refer   molecule   OH     +  S     =>   HS    +     O     UMIST  */

			c[ipATS][ipOH] -= OH_S_HS_O_1;
			c[ipOH][ipOH] -= OH_S_HS_O_2;
			bvec[ipOH] -= bvec_OH_S_HS_O;
			
			c[ipATS][ipHS] += OH_S_HS_O_1;
			c[ipOH][ipHS] += OH_S_HS_O_2;
			bvec[ipHS] += bvec_OH_S_HS_O;

		/*  >>refer   molecule   OH     +  S     =>   SO    +     H     UMIST  */

			c[ipATS][ipOH] -= OH_S_SO_H_1;
			c[ipOH][ipOH] -= OH_S_SO_H_2;
			bvec[ipOH] -= bvec_OH_S_SO_H;
			
			c[ipATS][ipSO] += OH_S_SO_H_1;
			c[ipOH][ipSO] += OH_S_SO_H_2;
			bvec[ipSO] += bvec_OH_S_SO_H;

		/*  >>refer   molecule   OH     +  N2O   =>   HNO   +     NO    UMIST  */

			c[ipN2O][ipOH] -= OH_N2O_HNO_NO_1;
			c[ipOH][ipOH] -= OH_N2O_HNO_NO_2;
			bvec[ipOH] -= bvec_OH_N2O_HNO_NO;
			
			c[ipN2O][ipN2O] -= OH_N2O_HNO_NO_1;
			c[ipOH][ipN2O] -= OH_N2O_HNO_NO_2;
			bvec[ipN2O] -= bvec_OH_N2O_HNO_NO;
			
			c[ipN2O][ipHNO] += OH_N2O_HNO_NO_1;
			c[ipOH][ipHNO] += OH_N2O_HNO_NO_2;
			bvec[ipHNO] += bvec_OH_N2O_HNO_NO;
			
			c[ipN2O][ipNO] += OH_N2O_HNO_NO_1;
			c[ipOH][ipNO] += OH_N2O_HNO_NO_2;
			bvec[ipNO] += bvec_OH_N2O_HNO_NO;

		/*  >>refer   molecule   OH     +  CS    =>   OCS   +     H     UMIST  */
			
			c[ipCS][ipOH] -= OH_CS_OCS_H_1;
			c[ipOH][ipOH] -= OH_CS_OCS_H_2;
			bvec[ipOH] -= bvec_OH_CS_OCS_H;

			c[ipCS][ipCS] -= OH_CS_OCS_H_1;
			c[ipOH][ipCS] -= OH_CS_OCS_H_2;
			bvec[ipCS] -= bvec_OH_CS_OCS_H;
			
			c[ipCS][ipOCS] += OH_CS_OCS_H_1;
			c[ipOH][ipOCS] += OH_CS_OCS_H_2;
			bvec[ipOCS] += bvec_OH_CS_OCS_H;
			
		/*  >>refer   molecule   NH3    +  CN    =>   HCN   +     NH2   UMIST  */

			c[ipCN][ipNH3] -= NH3_CN_HCN_NH2_1;
			c[ipNH3][ipNH3] -= NH3_CN_HCN_NH2_2;
			bvec[ipNH3] -= bvec_NH3_CN_HCN_NH2;
			
			c[ipCN][ipCN] -= NH3_CN_HCN_NH2_1;
			c[ipNH3][ipCN] -= NH3_CN_HCN_NH2_2;
			bvec[ipCN] -= bvec_NH3_CN_HCN_NH2;
			
			c[ipCN][ipHCN] += NH3_CN_HCN_NH2_1;
			c[ipNH3][ipHCN] += NH3_CN_HCN_NH2_2;
			bvec[ipHCN] += bvec_NH3_CN_HCN_NH2;
			
			c[ipCN][ipNH2] += NH3_CN_HCN_NH2_1;
			c[ipNH3][ipNH2] += NH3_CN_HCN_NH2_2;
			bvec[ipNH2] += bvec_NH3_CN_HCN_NH2;

		/*  >>refer   molecule   CN     +  NO    =>   N2    +     CO    UMIST  */

			c[ipNO][ipCN] -= CN_NO_N2_CO_1;
			c[ipCN][ipCN] -= CN_NO_N2_CO_2;
			bvec[ipCN] -= bvec_CN_NO_N2_CO;
			
			c[ipNO][ipNO] -= CN_NO_N2_CO_1;
			c[ipCN][ipNO] -= CN_NO_N2_CO_2;
			bvec[ipNO] -= bvec_CN_NO_N2_CO;
			
			c[ipNO][ipN2] += CN_NO_N2_CO_1;
			c[ipCN][ipN2] += CN_NO_N2_CO_2;
			bvec[ipN2] += bvec_CN_NO_N2_CO;
			
			c[ipNO][ipCO] += CN_NO_N2_CO_1;
			c[ipCN][ipCO] += CN_NO_N2_CO_2;
			bvec[ipCO] += bvec_CN_NO_N2_CO;

		/*  >>refer   molecule   CN     +  NO    =>   OCN   +     N     UMIST  */

			c[ipNO][ipCN] -= CN_NO_OCN_N_1;
			c[ipCN][ipCN] -= CN_NO_OCN_N_2;
			bvec[ipCN] -= bvec_CN_NO_OCN_N;
			
			c[ipNO][ipNO] -= CN_NO_OCN_N_1;
			c[ipCN][ipNO] -= CN_NO_OCN_N_2;
			bvec[ipNO] -= bvec_CN_NO_OCN_N;
			
			c[ipNO][ipOCN] += CN_NO_OCN_N_1;
			c[ipCN][ipOCN] += CN_NO_OCN_N_2;
			bvec[ipOCN] += bvec_CN_NO_OCN_N;
			
		/*  >>refer   molecule   CN     +  HNO   =>   NO    +     HCN   UMIST  */

			c[ipHNO][ipCN] -= CN_HNO_NO_HCN_1;
			c[ipCN][ipCN] -= CN_HNO_NO_HCN_2;
			bvec[ipCN] -= bvec_CN_HNO_NO_HCN;
			
			c[ipHNO][ipHNO] -= CN_HNO_NO_HCN_1;
			c[ipCN][ipHNO] -= CN_HNO_NO_HCN_2;
			bvec[ipHNO] -= bvec_CN_HNO_NO_HCN;
			
			c[ipHNO][ipNO] += CN_HNO_NO_HCN_1;
			c[ipCN][ipNO] += CN_HNO_NO_HCN_2;
			bvec[ipNO] += bvec_CN_HNO_NO_HCN;
			
			c[ipHNO][ipHCN] += CN_HNO_NO_HCN_1;
			c[ipCN][ipHCN] += CN_HNO_NO_HCN_2;
			bvec[ipHCN] += bvec_CN_HNO_NO_HCN;

		/*  >>refer   molecule   CN     +  O2    =>   NO    +     CO    UMIST  */

			c[ipO2][ipCN] -= CN_O2_NO_CO_1;
			c[ipCN][ipCN] -= CN_O2_NO_CO_2;
			bvec[ipCN] -= bvec_CN_O2_NO_CO;
			
			c[ipO2][ipO2] -= CN_O2_NO_CO_1;
			c[ipCN][ipO2] -= CN_O2_NO_CO_2;
			bvec[ipO2] -= bvec_CN_O2_NO_CO;
			
			c[ipO2][ipNO] += CN_O2_NO_CO_1;
			c[ipCN][ipNO] += CN_O2_NO_CO_2;
			bvec[ipNO] += bvec_CN_O2_NO_CO;
			
			c[ipO2][ipCO] += CN_O2_NO_CO_1;
			c[ipCN][ipCO] += CN_O2_NO_CO_2;
			bvec[ipCO] += bvec_CN_O2_NO_CO;

		/*  >>refer   molecule   CN     +  S     =>   NS    +     C     UMIST  */

			c[ipATS][ipCN] -= CN_S_NS_C_1;
			c[ipCN][ipCN] -= CN_S_NS_C_2;
			bvec[ipCN] -= bvec_CN_S_NS_C;
			
			c[ipATS][ipNS] += CN_S_NS_C_1;
			c[ipCN][ipNS] += CN_S_NS_C_2;
			bvec[ipNS] += bvec_CN_S_NS_C;
			
		/*  >>refer   molecule   CN     +  S     =>   CS    +     N     UMIST  */

			c[ipATS][ipCN] -= CN_S_CS_N_1;
			c[ipCN][ipCN] -= CN_S_CS_N_2;
			bvec[ipCN] -= bvec_CN_S_CS_N;
			
			c[ipATS][ipCS] += CN_S_CS_N_1;
			c[ipCN][ipCS] += CN_S_CS_N_2;
			bvec[ipCS] += bvec_CN_S_CS_N;

		/*  >>refer   molecule   CO     +  HS    =>   OCS   +     H     UMIST  */

			c[ipHS][ipCO] -= CO_HS_OCS_H_1;
			c[ipCO][ipCO] -= CO_HS_OCS_H_2;
			bvec[ipCO] -= bvec_CO_HS_OCS_H;
			
			c[ipHS][ipHS] -= CO_HS_OCS_H_1;
			c[ipCO][ipHS] -= CO_HS_OCS_H_2;
			bvec[ipHS] -= bvec_CO_HS_OCS_H;
			
			c[ipHS][ipOCS] += CO_HS_OCS_H_1;
			c[ipCO][ipOCS] += CO_HS_OCS_H_2;
			bvec[ipOCS] += bvec_CO_HS_OCS_H;
			
		/*  >>refer   molecule   N2     +  O2    =>   N2O   +     O     UMIST  */

			c[ipO2][ipN2] -= N2_O2_N2O_O_1;
			c[ipN2][ipN2] -= N2_O2_N2O_O_2;
			bvec[ipN2] -= bvec_N2_O2_N2O_O;
			
			c[ipO2][ipO2] -= N2_O2_N2O_O_1;
			c[ipN2][ipO2] -= N2_O2_N2O_O_2;
			bvec[ipO2] -= bvec_N2_O2_N2O_O;
			
			c[ipO2][ipN2O] += N2_O2_N2O_O_1;
			c[ipN2][ipN2O] += N2_O2_N2O_O_2;
			bvec[ipN2O] += bvec_N2_O2_N2O_O;
			
		/*  >>refer   molecule   NO     +  NO    =>   O2    +     N2    UMIST  */

			c[ipNO][ipNO] -= NO_NO_O2_N2_1;
			c[ipNO][ipNO] -= NO_NO_O2_N2_2;
			bvec[ipNO] -= bvec_NO_NO_O2_N2;
			
			c[ipNO][ipO2] += 0.5*NO_NO_O2_N2_1;
			c[ipNO][ipO2] += 0.5*NO_NO_O2_N2_2;
			bvec[ipO2] += 0.5*bvec_NO_NO_O2_N2;
			
			c[ipNO][ipN2] += 0.5*NO_NO_O2_N2_1;
			c[ipNO][ipN2] += 0.5*NO_NO_O2_N2_2;
			bvec[ipN2] += 0.5*bvec_NO_NO_O2_N2;

		/*  >>refer   molecule   NO     +  NO    =>   N2O   +     O     UMIST  */

			c[ipNO][ipNO] -= NO_NO_N2O_O_1;
			c[ipNO][ipNO] -= NO_NO_N2O_O_2;
			bvec[ipNO] -= bvec_NO_NO_N2O_O;
			
			c[ipNO][ipN2O] += 0.5*NO_NO_N2O_O_1;
			c[ipNO][ipN2O] += 0.5*NO_NO_N2O_O_2;
			bvec[ipN2O] += 0.5*bvec_NO_NO_N2O_O;
			
		/*  >>refer   molecule   NO     +  HNO   =>   N2O   +     OH    UMIST  */

			c[ipHNO][ipNO] -= NO_HNO_N2O_OH_1;
			c[ipNO][ipNO] -= NO_HNO_N2O_OH_2;
			bvec[ipNO] -= bvec_NO_HNO_N2O_OH;
			
			c[ipHNO][ipHNO] -= NO_HNO_N2O_OH_1;
			c[ipNO][ipHNO] -= NO_HNO_N2O_OH_2;
			bvec[ipHNO] -= bvec_NO_HNO_N2O_OH;
			
			c[ipHNO][ipN2O] += NO_HNO_N2O_OH_1;
			c[ipNO][ipN2O] += NO_HNO_N2O_OH_2;
			bvec[ipN2O] += bvec_NO_HNO_N2O_OH;
			
			c[ipHNO][ipOH] += NO_HNO_N2O_OH_1;
			c[ipNO][ipOH] += NO_HNO_N2O_OH_2;
			bvec[ipOH] += bvec_NO_HNO_N2O_OH;

		/*  >>refer   molecule   NO     +  S     =>   NS    +     O     UMIST  */

			c[ipATS][ipNO] -= NO_S_NS_O_1;
			c[ipNO][ipNO] -= NO_S_NS_O_2;
			bvec[ipNO] -= bvec_NO_S_NS_O;
			
			c[ipATS][ipNS] += NO_S_NS_O_1;
			c[ipNO][ipNS] += NO_S_NS_O_2;
			bvec[ipNS] += bvec_NO_S_NS_O;
			
		/*  >>refer   molecule   NO     +  S     =>   SO    +     N     UMIST  */

			c[ipATS][ipNO] -= NO_S_SO_N_1;
			c[ipNO][ipNO] -= NO_S_SO_N_2;
			bvec[ipNO] -= bvec_NO_S_SO_N;
			
			c[ipATS][ipSO] += NO_S_SO_N_1;
			c[ipNO][ipSO] += NO_S_SO_N_2;
			bvec[ipSO] += bvec_NO_S_SO_N;
			
		/*  >>refer   molecule   O2     +  S     =>   SO    +     O     UMIST  */

			c[ipATS][ipO2] -= O2_S_SO_O_1;
			c[ipO2][ipO2] -= O2_S_SO_O_2;
			bvec[ipO2] -= bvec_O2_S_SO_O;
			
			c[ipATS][ipSO] += O2_S_SO_O_1;
			c[ipO2][ipSO] += O2_S_SO_O_2;
			bvec[ipSO] += bvec_O2_S_SO_O;
			
		/*  >>refer   molecule   S      +  SO    =>   S2    +     O     UMIST  */
			
			c[ipSO][ipSO] -= S_SO_S2_O_1;
			c[ipATS][ipSO] -= S_SO_S2_O_2;
			bvec[ipSO] -= bvec_S_SO_S2_O;
			
			c[ipSO][ipS2] += S_SO_S2_O_1;
			c[ipATS][ipS2] += S_SO_S2_O_2;
			bvec[ipS2] += bvec_S_SO_S2_O;
			
		/*  >>refer   molecule   H+     +  HNO   =>   NO+   +     H2    UMIST  */

			c[ipHNO][ipHNO] -= HP_HNO_NOP_H2;
			c[ipHNO][ipNOP] += HP_HNO_NOP_H2;

		/*  >>refer   molecule   H+     +  HS    =>   S+    +     H2    UMIST  */

			c[ipHS][ipHS] -= HP_HS_SP_H2;
			c[ipHS][ipSP] += HP_HS_SP_H2;

		/*  >>refer   molecule   H      +  HS+   =>   S+    +     H2    UMIST  */

			c[ipHSP][ipHSP] -= H_HSP_SP_H2;
			c[ipHSP][ipSP] += H_HSP_SP_H2;

		/*  >>refer   molecule   H+     +  OCS   =>   HS+   +     CO    UMIST  */

			c[ipOCS][ipOCS] -= HP_OCS_HSP_CO;
			c[ipOCS][ipHSP] += HP_OCS_HSP_CO;
			c[ipOCS][ipCO] += HP_OCS_HSP_CO;

		/*  >>refer   molecule   H2+    +  N     =>   NH+   +     H     UMIST  */

			c[ipATN][ipNHP] += H2P_N_NHP_H;

		/*  >>refer   molecule   H2     +  N+    =>   NH+   +     H     UMIST  */

			c[ipNP][ipNP] -= H2_NP_NHP_H;
			c[ipNP][ipNHP] += H2_NP_NHP_H;

		/*  >>refer   molecule   H2     +  NH+   =>   N     +     H3+   UMIST  */

			c[ipNHP][ipNHP] -= H2_NHP_N_H3P;

		/*  >>refer   molecule   H2+    +  NH    =>   NH2+  +     H     UMIST  */

			c[ipNH][ipNH] -= H2P_NH_NH2P_H;
			c[ipNH][ipNH2P] += H2P_NH_NH2P_H;

		/*  >>refer   molecule   H2     +  NH+   =>   NH2+  +     H     UMIST  */

			c[ipNHP][ipNHP] -= H2_NHP_NH2P_H;
			c[ipNHP][ipNH2P] += H2_NHP_NH2P_H;

		/*  >>refer   molecule   H2     +  NH2+  =>   NH3+  +     H     UMIST  */

			c[ipNH2P][ipNH2P] -= H2_NH2P_NH3P_H;
			c[ipNH2P][ipNH3P] += H2_NH2P_NH3P_H;

		/*  >>refer   molecule   H2     +  NH3+  =>   NH4+  +     H     UMIST  */

			c[ipNH3P][ipNH3P] -= H2_NH3P_NH4P_H;
			c[ipNH3P][ipNH4P] += H2_NH3P_NH4P_H;

		/*  >>refer   molecule   H2+    +  CN    =>   HCN+  +     H     UMIST  */

			c[ipCN][ipCN] -= H2P_CN_HCNP_H;
			c[ipCN][ipHCNP] += H2P_CN_HCNP_H;

		/*  >>refer   molecule   H2     +  CN+   =>   HCN+  +     H     UMIST  */

			c[ipCNP][ipCNP] -= H2_CNP_HCNP_H;
			c[ipCNP][ipHCNP] += H2_CNP_HCNP_H;

		/*  >>refer   molecule   H2+    +  NO    =>   HNO+  +     H     UMIST  */

			c[ipNO][ipNO] -= H2P_NO_HNOP_H;
			c[ipNO][ipHNOP] += H2P_NO_HNOP_H;

		/*  >>refer   molecule   H2     +  S+    =>   HS+   +     H     UMIST  */

			c[ipSP][ipSP] -= H2_SP_HSP_H;
			c[ipSP][ipHSP] += H2_SP_HSP_H;

		/*  >>refer   molecule   H2     +  CS+   =>   HCS+  +     H     UMIST  */

			c[ipCSP][ipCSP] -= H2_CSP_HCSP_H;
			c[ipCSP][ipHCSP] += H2_CSP_HCSP_H;

		/*  >>refer   molecule   H2     +  NO2+  =>   NO+   +     H2O   UMIST  */

			c[ipNO2P][ipNO2P] -= H2_NO2P_NOP_H2O;
			c[ipNO2P][ipNOP] += H2_NO2P_NOP_H2O;
			c[ipNO2P][ipH2O] += H2_NO2P_NOP_H2O;

		/*  >>refer   molecule   H3+    +  NH    =>   NH2+  +     H2    UMIST  */

			c[ipNH][ipNH] -= H3P_NH_NH2P_H2;
			c[ipNH][ipNH2P] += H3P_NH_NH2P_H2;

		/*  >>refer   molecule   H3+    +  NH2   =>   NH3+  +     H2    UMIST  */

			c[ipNH2][ipNH2] -= H3P_NH2_NH3P_H2;
			c[ipNH2][ipNH3P] += H3P_NH2_NH3P_H2;

		/*  >>refer   molecule   H3+    +  NH3   =>   NH4+  +     H2    UMIST  */

			c[ipNH3][ipNH3] -= H3P_NH3_NH4P_H2;
			c[ipNH3][ipNH4P] += H3P_NH3_NH4P_H2;

		/*  >>refer   molecule   H3+    +  CN    =>   HCN+  +     H2    UMIST  */

			c[ipCN][ipCN] -= H3P_CN_HCNP_H2;
			c[ipCN][ipHCNP] += H3P_CN_HCNP_H2;

		/*  >>refer   molecule   H3+    +  NO    =>   HNO+  +     H2    UMIST  */

			c[ipNO][ipNO] -= H3P_NO_HNOP_H2;
			c[ipNO][ipHNOP] += H3P_NO_HNOP_H2;

		/*  >>refer   molecule   H3+    +  S     =>   HS+   +     H2    UMIST  */

			c[ipATS][ipHSP] += H3P_S_HSP_H2;

		/*  >>refer   molecule   H3+    +  CS    =>   HCS+  +     H2    UMIST  */

			c[ipCS][ipCS] -= H3P_CS_HCSP_H2;
			c[ipCS][ipHCSP] += H3P_CS_HCSP_H2;

		/*  >>refer   molecule   H3+    +  NO2   =>   NO+   +     OH +  H2     UMIST  */

			c[ipNO2][ipNO2] -= H3P_NO2_NOP_OH_H2;
			c[ipNO2][ipNOP] += H3P_NO2_NOP_OH_H2;

		/*  >>refer   molecule   He+    +  NH    =>   N+    +     He +  H      UMIST  */

			c[ipNH][ipNH] -= HeP_NH_NP_He_H;
			c[ipNH][ipNP] += HeP_NH_NP_He_H;

		/*  >>refer   molecule   He+    +  NH2   =>   N+    +     He +  H2     UMIST  */

			c[ipNH2][ipNH2] -= HeP_NH2_NP_He_H2;
			c[ipNH2][ipNP] += HeP_NH2_NP_He_H2;

		/*  >>refer   molecule   He+    +  NH2   =>   NH+   +     He +  H      UMIST  */

			c[ipNH2][ipNH2] -= HeP_NH2_NHP_He_H;
			c[ipNH2][ipNHP] += HeP_NH2_NHP_He_H;

		/*  >>refer   molecule   He+    +  NH3   =>   NH+   +     He +  H2     UMIST  */

			c[ipNH3][ipNH3] -= HeP_NH3_NHP_He_H2;
			c[ipNH3][ipNHP] += HeP_NH3_NHP_He_H2;

		/*  >>refer   molecule   He+    +  NH3   =>   NH2+  +     He +  H      UMIST  */

			c[ipNH3][ipNH3] -= HeP_NH3_NH2P_He_H;
			c[ipNH3][ipNH2P] += HeP_NH3_NH2P_He_H;

		/*  >>refer   molecule   He+    +  CN    =>   N     +     C+ +  He     UMIST  */

			c[ipCN][ipCN] -= HeP_CN_N_CP_He;
			c[ipCN][ipCP] += HeP_CN_N_CP_He;

		/*  >>refer   molecule   He+    +  CN    =>   N+    +     C  +  He     UMIST  */

			c[ipCN][ipCN] -= HeP_CN_NP_C_He;
			c[ipCN][ipNP] += HeP_CN_NP_C_He;

		/*  >>refer   molecule   He+    +  HCN   =>   N     +     CH+ +  He     UMIST  */

			c[ipHCN][ipHCN] -= HeP_HCN_N_CHP_He;
			c[ipHCN][ipCHP] += HeP_HCN_N_CHP_He;

		/*  >>refer   molecule   He+    +  HCN   =>   N+    +     CH +  He     UMIST  */

			c[ipHCN][ipHCN] -= HeP_HCN_NP_CH_He;
			c[ipHCN][ipNP] += HeP_HCN_NP_CH_He;
			c[ipHCN][ipCH] += HeP_HCN_NP_CH_He;

		/*  >>refer   molecule   He+    +  HCN   =>   N     +     C+ +  He +  H       UMIST  */

			c[ipHCN][ipHCN] -= HeP_HCN_N_CP_He_H;
			c[ipHCN][ipCP] += HeP_HCN_N_CP_He_H;

		/*  >>refer   molecule   He+    +  HCN   =>   CN+   +     He +  H      UMIST  */

			c[ipHCN][ipHCN] -= HeP_HCN_CNP_He_H;
			c[ipHCN][ipCNP]  += HeP_HCN_CNP_He_H;

		/*  >>refer   molecule   He+    +  N2    =>   N+    +     N  +  He     UMIST  */

			c[ipN2][ipN2] -= HeP_N2_NP_N_He;
			c[ipN2][ipNP] += HeP_N2_NP_N_He;

		/*  >>refer   molecule   He+    +  NO    =>   O+    +     N  +  He     UMIST  */

			c[ipNO][ipNO] -= HeP_NO_OP_N_He;
			c[ipNO][ipOP] += HeP_NO_OP_N_He;

		/*  >>refer   molecule   He+    +  NO    =>   O     +     N+ +  He     UMIST  */

			c[ipNO][ipNO] -= HeP_NO_O_NP_He;
			c[ipNO][ipNP] += HeP_NO_O_NP_He;

		/*  >>refer   molecule   He+    +  HNO   =>   NO+   +     He +  H      UMIST  */

			c[ipHNO][ipHNO] -= HeP_HNO_NOP_He_H;
			c[ipHNO][ipNOP] += HeP_HNO_NOP_He_H;

		/*  >>refer   molecule   He+    +  HNO   =>   NO    +     He +  H+     UMIST  */

			c[ipHNO][ipHNO] -= HeP_HNO_NO_He_HP;
			c[ipHNO][ipNO] += HeP_HNO_NO_He_HP;

		/*  >>refer   molecule   He+    +  HS    =>   S+    +     He +  H      UMIST  */

			c[ipHS][ipHS] -= HeP_HS_SP_He_H;
			c[ipHS][ipSP] += HeP_HS_SP_He_H;

		/*  >>refer   molecule   He+    +  OCN   =>   CN    +     O+ +  He     UMIST  */

			c[ipOCN][ipOCN] -= HeP_OCN_CN_OP_He;
			c[ipOCN][ipCN] += HeP_OCN_CN_OP_He;
			c[ipOCN][ipOP] += HeP_OCN_CN_OP_He;

		/*  >>refer   molecule   He+    +  OCN   =>   CN+   +     O  +  He     UMIST  */

			c[ipOCN][ipOCN] -= HeP_OCN_CNP_O_He;
			c[ipOCN][ipCNP] += HeP_OCN_CNP_O_He;

		/*  >>refer   molecule   He+    +  SIN   =>   SI+   +     N  +  He     UMIST  */

			c[ipSIN][ipSIN] -= HeP_SIN_SIP_N_He;
			c[ipSIN][ipSIP] += HeP_SIN_SIP_N_He;

		/*  >>refer   molecule   He+    +  N2O   =>   N2    +     O+ +  He     UMIST  */

			c[ipN2O][ipN2O] -= HeP_N2O_N2_OP_He;
			c[ipN2O][ipN2] += HeP_N2O_N2_OP_He;
			c[ipN2O][ipOP] += HeP_N2O_N2_OP_He;

		/*  >>refer   molecule   He+    +  N2O   =>   N2+   +     O  +  He     UMIST  */

			c[ipN2O][ipN2O] -= HeP_N2O_N2P_O_He;
			c[ipN2O][ipN2P] += HeP_N2O_N2P_O_He;

		/*  >>refer   molecule   He+    +  N2O   =>   NO    +     N+ +  He     UMIST  */

			c[ipN2O][ipN2O] -= HeP_N2O_NO_NP_He;
			c[ipN2O][ipNO] += HeP_N2O_NO_NP_He;
			c[ipN2O][ipNP] += HeP_N2O_NO_NP_He;

		/*  >>refer   molecule   He+    +  N2O   =>   NO+   +     N  +  He     UMIST  */

			c[ipN2O][ipN2O] -= HeP_N2O_NOP_N_He;
			c[ipN2O][ipNOP] += HeP_N2O_NOP_N_He;

		/*  >>refer   molecule   He+    +  CS    =>   S+    +     C  +  He     UMIST  */

			c[ipCS][ipCS] -= HeP_CS_SP_C_He;
			c[ipCS][ipSP] += HeP_CS_SP_C_He;

		/*  >>refer   molecule   He+    +  CS    =>   S     +     C+ +  He     UMIST  */

			c[ipCS][ipCS] -= HeP_CS_S_CP_He;
			c[ipCS][ipCP] += HeP_CS_S_CP_He;

		/*  >>refer   molecule   He+    +  NS    =>   S     +     N+ +  He     UMIST  */

			c[ipNS][ipNS] -= HeP_NS_S_NP_He;
			c[ipNS][ipNP] += HeP_NS_S_NP_He;

		/*  >>refer   molecule   He+    +  NS    =>   S+    +     N  +  He     UMIST  */

			c[ipNS][ipNS] -= HeP_NS_SP_N_He;
			c[ipNS][ipSP] += HeP_NS_SP_N_He;

		/*  >>refer   molecule   He+    +  SO    =>   S     +     O+ +  He     UMIST  */

			c[ipSO][ipSO] -= HeP_SO_S_OP_He;
			c[ipSO][ipOP] += HeP_SO_S_OP_He;

		/*  >>refer   molecule   He+    +  SO    =>   S+    +     O  +  He     UMIST  */

			c[ipSO][ipSO] -= HeP_SO_SP_O_He;
			c[ipSO][ipSP] += HeP_SO_SP_O_He;

		/*  >>refer   molecule   He+    +  OCS   =>   S+    +     CO +  He     UMIST  */

			c[ipOCS][ipOCS] -= HeP_OCS_SP_CO_He;
			c[ipOCS][ipSP] += HeP_OCS_SP_CO_He;
			c[ipOCS][ipCO] += HeP_OCS_SP_CO_He;

		/*  >>refer   molecule   He+    +  OCS   =>   S     +     CO+ +  He     UMIST  */

			c[ipOCS][ipOCS] -= HeP_OCS_S_COP_He;
			c[ipOCS][ipCOP] += HeP_OCS_S_COP_He;

		/*  >>refer   molecule   He+    +  OCS   =>   CS+   +     O  +  He     UMIST  */

			c[ipOCS][ipOCS] -= HeP_OCS_CSP_O_He;
			c[ipOCS][ipCSP] += HeP_OCS_CSP_O_He;

		/*  >>refer   molecule   He+    +  OCS   =>   CS    +     O+ +  He     UMIST  */

			c[ipOCS][ipOCS] -= HeP_OCS_CS_OP_He;
			c[ipOCS][ipCS] += HeP_OCS_CS_OP_He;
			c[ipOCS][ipOP] += HeP_OCS_CS_OP_He;

		/*  >>refer   molecule   He+    +  S2    =>   S+    +     S  +  He     UMIST  */

			c[ipS2][ipS2] -= HeP_S2_SP_S_He;
			c[ipS2][ipSP] += HeP_S2_SP_S_He;

		/*  >>refer   molecule   C      +  NH+   =>   N     +     CH+   UMIST  */
			
			c[ipNHP][ipNHP] -= C_NHP_N_CHP_1;
			c[ipATC][ipNHP] -= C_NHP_N_CHP_2;
			bvec[ipNHP] -= bvec_C_NHP_N_CHP;
			
			c[ipNHP][ipCHP] += C_NHP_N_CHP_1;
			c[ipATC][ipCHP] += C_NHP_N_CHP_2;
			bvec[ipCHP] += bvec_C_NHP_N_CHP;

		/*  >>refer   molecule   C+     +  NH    =>   CN+   +     H     UMIST  */

			c[ipNH][ipCP] -= CP_NH_CNP_H_1;
			c[ipCP][ipCP] -= CP_NH_CNP_H_2;
			bvec[ipCP] -= bvec_CP_NH_CNP_H;
			
			c[ipNH][ipNH] -= CP_NH_CNP_H_1;
			c[ipCP][ipNH] -= CP_NH_CNP_H_2;
			bvec[ipNH] -= bvec_CP_NH_CNP_H;
			
			c[ipNH][ipCNP] += CP_NH_CNP_H_1;
			c[ipCP][ipCNP] += CP_NH_CNP_H_2;
			bvec[ipCNP] += bvec_CP_NH_CNP_H;

		/*  >>refer   molecule   C+     +  NH2   =>   HCN+  +     H     UMIST  */

			c[ipNH2][ipCP] -= CP_NH2_HCNP_H_1;
			c[ipCP][ipCP] -= CP_NH2_HCNP_H_2;
			bvec[ipCP] -= bvec_CP_NH2_HCNP_H;
			
			c[ipNH2][ipNH2] -= CP_NH2_HCNP_H_1;
			c[ipCP][ipNH2] -= CP_NH2_HCNP_H_2;
			bvec[ipNH2] -= bvec_CP_NH2_HCNP_H;
			
			c[ipNH2][ipHCNP] += CP_NH2_HCNP_H_1;
			c[ipCP][ipHCNP] += CP_NH2_HCNP_H_2;
			bvec[ipHCNP] += bvec_CP_NH2_HCNP_H;

		/*  >>refer   molecule   C      +  NH2+  =>   NH    +     CH+   UMIST  */

			c[ipNH2P][ipNH2P] -= C_NH2P_NH_CHP_1;
			c[ipATC][ipNH2P] -= C_NH2P_NH_CHP_2;
			bvec[ipNH2P] -= bvec_C_NH2P_NH_CHP;
			
			c[ipNH2P][ipNH] += C_NH2P_NH_CHP_1;
			c[ipATC][ipNH] += C_NH2P_NH_CHP_2;
			bvec[ipNH] += bvec_C_NH2P_NH_CHP;
			
			c[ipNH2P][ipCHP] += C_NH2P_NH_CHP_1;
			c[ipATC][ipCHP] += C_NH2P_NH_CHP_2;
			bvec[ipCHP] += bvec_C_NH2P_NH_CHP;

		/*  >>refer   molecule   C+     +  NH3   =>   HCN+  +     H2    UMIST  */

			c[ipNH3][ipCP] -= CP_NH3_HCNP_H2_1;
			c[ipCP][ipCP] -= CP_NH3_HCNP_H2_2;
			bvec[ipCP] -= bvec_CP_NH3_HCNP_H2;
			
			c[ipNH3][ipNH3] -= CP_NH3_HCNP_H2_1;
			c[ipCP][ipNH3] -= CP_NH3_HCNP_H2_2;
			bvec[ipNH3] -= bvec_CP_NH3_HCNP_H2;
			
			c[ipNH3][ipHCNP] += CP_NH3_HCNP_H2_1;
			c[ipCP][ipHCNP] += CP_NH3_HCNP_H2_2;
			bvec[ipHCNP] += bvec_CP_NH3_HCNP_H2;

		/*  >>refer   molecule   C      +  NH3+  =>   NH    +     CH2+  UMIST  */

			c[ipNH3P][ipNH3P] -= C_NH3P_NH_CH2P_1;
			c[ipATC][ipNH3P] -= C_NH3P_NH_CH2P_2;
			bvec[ipNH3P] -= bvec_C_NH3P_NH_CH2P;
			
			c[ipNH3P][ipNH] += C_NH3P_NH_CH2P_1;
			c[ipATC][ipNH] += C_NH3P_NH_CH2P_2;
			bvec[ipNH] += bvec_C_NH3P_NH_CH2P;
			
			c[ipNH3P][ipCH2P] += C_NH3P_NH_CH2P_1;
			c[ipATC][ipCH2P] += C_NH3P_NH_CH2P_2;
			bvec[ipCH2P] += bvec_C_NH3P_NH_CH2P;

		/*  >>refer   molecule   C      +  HCN+  =>   CN    +     CH+   UMIST  */

			c[ipHCNP][ipHCNP] -= C_HCNP_CN_CHP_1;
			c[ipATC][ipHCNP] -= C_HCNP_CN_CHP_2;
			bvec[ipHCNP] -= bvec_C_HCNP_CN_CHP;
			
			c[ipHCNP][ipCN] += C_HCNP_CN_CHP_1;
			c[ipATC][ipCN] += C_HCNP_CN_CHP_2;
			bvec[ipCN] += bvec_C_HCNP_CN_CHP;
			
			c[ipHCNP][ipCHP] += C_HCNP_CN_CHP_1;
			c[ipATC][ipCHP] += C_HCNP_CN_CHP_2;
			bvec[ipCHP] += bvec_C_HCNP_CN_CHP;

		/*  >>refer   molecule   C      +  HNO+  =>   NO    +     CH+   UMIST  */

			c[ipHNOP][ipHNOP] -= C_HNOP_NO_CHP_1;
			c[ipATC][ipHNOP] -= C_HNOP_NO_CHP_2;
			bvec[ipHNOP] -= bvec_C_HNOP_NO_CHP;
			
			c[ipHNOP][ipNO] += C_HNOP_NO_CHP_1;
			c[ipATC][ipNO] += C_HNOP_NO_CHP_2;
			bvec[ipNO] += bvec_C_HNOP_NO_CHP;
			
			c[ipHNOP][ipCHP] += C_HNOP_NO_CHP_1;
			c[ipATC][ipCHP] += C_HNOP_NO_CHP_2;
			bvec[ipCHP] += bvec_C_HNOP_NO_CHP;

		/*  >>refer   molecule   C+     +  HS    =>   CS+   +     H     UMIST  */

			c[ipHS][ipCP] -= CP_HS_CSP_H_1;
			c[ipCP][ipCP] -= CP_HS_CSP_H_2;
			bvec[ipCP] -= bvec_CP_HS_CSP_H;
			
			c[ipHS][ipHS] -= CP_HS_CSP_H_1;
			c[ipCP][ipHS] -= CP_HS_CSP_H_2;
			bvec[ipHS] -= bvec_CP_HS_CSP_H;
			
			c[ipHS][ipCSP] += CP_HS_CSP_H_1;
			c[ipCP][ipCSP] += CP_HS_CSP_H_2;
			bvec[ipCSP] += bvec_CP_HS_CSP_H;

		/*  >>refer   molecule   C      +  HS+   =>   CS+   +     H     UMIST  */

			c[ipHSP][ipHSP] -= C_HSP_CSP_H_1;
			c[ipATC][ipHSP] -= C_HSP_CSP_H_2;
			bvec[ipHSP] -= bvec_C_HSP_CSP_H;
			
			c[ipHSP][ipCSP] += C_HSP_CSP_H_1;
			c[ipATC][ipCSP] += C_HSP_CSP_H_2;
			bvec[ipCSP] += bvec_C_HSP_CSP_H;

		/*  >>refer   molecule   C+     +  OCN   =>   CO+   +     CN    UMIST  */

			c[ipOCN][ipCP] -= CP_OCN_COP_CN_1;
			c[ipCP][ipCP] -= CP_OCN_COP_CN_2;
			bvec[ipCP] -= bvec_CP_OCN_COP_CN;
			
			c[ipOCN][ipOCN] -= CP_OCN_COP_CN_1;
			c[ipCP][ipOCN] -= CP_OCN_COP_CN_2;
			bvec[ipOCN] -= bvec_CP_OCN_COP_CN;
			
			c[ipOCN][ipCOP] += CP_OCN_COP_CN_1;
			c[ipCP][ipCOP] += CP_OCN_COP_CN_2;
			bvec[ipCOP] += bvec_CP_OCN_COP_CN;
			
			c[ipOCN][ipCN] += CP_OCN_COP_CN_1;
			c[ipCP][ipCN] += CP_OCN_COP_CN_2;
			bvec[ipCN] += bvec_CP_OCN_COP_CN;

		/*  >>refer   molecule   C+     +  NS    =>   CS+   +     N     UMIST  */

			c[ipNS][ipCP] -= CP_NS_CSP_N_1;
			c[ipCP][ipCP] -= CP_NS_CSP_N_2;
			bvec[ipCP] -= bvec_CP_NS_CSP_N;
			
			c[ipNS][ipNS] -= CP_NS_CSP_N_1;
			c[ipCP][ipNS] -= CP_NS_CSP_N_2;
			bvec[ipNS] -= bvec_CP_NS_CSP_N;
			
			c[ipNS][ipCSP] += CP_NS_CSP_N_1;
			c[ipCP][ipCSP] += CP_NS_CSP_N_2;
			bvec[ipCSP] += bvec_CP_NS_CSP_N;

		/*  >>refer   molecule   C+     +  SO    =>   S+    +     CO    UMIST  */

			c[ipSO][ipCP] -= CP_SO_SP_CO_1;
			c[ipCP][ipCP] -= CP_SO_SP_CO_2;
			bvec[ipCP] -= bvec_CP_SO_SP_CO;
			
			c[ipSO][ipSO] -= CP_SO_SP_CO_1;
			c[ipCP][ipSO] -= CP_SO_SP_CO_2;
			bvec[ipSO] -= bvec_CP_SO_SP_CO;
			
			c[ipSO][ipSP] += CP_SO_SP_CO_1;
			c[ipCP][ipSP] += CP_SO_SP_CO_2;
			bvec[ipSP] += bvec_CP_SO_SP_CO;
			
			c[ipSO][ipCO] += CP_SO_SP_CO_1;
			c[ipCP][ipCO] += CP_SO_SP_CO_2;
			bvec[ipCO] += bvec_CP_SO_SP_CO;

		/*  >>refer   molecule   C+     +  SO    =>   S     +     CO+   UMIST  */

			c[ipSO][ipCP] -= CP_SO_S_COP_1;
			c[ipCP][ipCP] -= CP_SO_S_COP_2;
			bvec[ipCP] -= bvec_CP_SO_S_COP;
			
			c[ipSO][ipSO] -= CP_SO_S_COP_1;
			c[ipCP][ipSO] -= CP_SO_S_COP_2;
			bvec[ipSO] -= bvec_CP_SO_S_COP;
			
			c[ipSO][ipCOP] += CP_SO_S_COP_1;
			c[ipCP][ipCOP] += CP_SO_S_COP_2;
			bvec[ipCOP] += bvec_CP_SO_S_COP;

		/*  >>refer   molecule   C+     +  SO    =>   CS+   +     O     UMIST  */

			c[ipSO][ipCP] -= CP_SO_CSP_O_1;
			c[ipCP][ipCP] -= CP_SO_CSP_O_2;
			bvec[ipCP] -= bvec_CP_SO_CSP_O;
			
			c[ipSO][ipSO] -= CP_SO_CSP_O_1;
			c[ipCP][ipSO] -= CP_SO_CSP_O_2;
			bvec[ipSO] -= bvec_CP_SO_CSP_O;
			
			c[ipSO][ipCSP] += CP_SO_CSP_O_1;
			c[ipCP][ipCSP] += CP_SO_CSP_O_2;
			bvec[ipCSP] += bvec_CP_SO_CSP_O;
			
		/*  >>refer   molecule   C+     +  OCS   =>   CS+   +     CO    UMIST  */

			c[ipOCS][ipCP] -= CP_OCS_CSP_CO_1;
			c[ipCP][ipCP] -= CP_OCS_CSP_CO_2;
			bvec[ipCP] -= bvec_CP_OCS_CSP_CO;
			
			c[ipOCS][ipOCS] -= CP_OCS_CSP_CO_1;
			c[ipCP][ipOCS] -= CP_OCS_CSP_CO_2;
			bvec[ipOCS] -= bvec_CP_OCS_CSP_CO;
			
			c[ipOCS][ipCSP] += CP_OCS_CSP_CO_1;
			c[ipCP][ipCSP] += CP_OCS_CSP_CO_2;
			bvec[ipCSP] += bvec_CP_OCS_CSP_CO;
			
			c[ipOCS][ipCO] += CP_OCS_CSP_CO_1;
			c[ipCP][ipCO] += CP_OCS_CSP_CO_2;
			bvec[ipCO] += bvec_CP_OCS_CSP_CO;

		/*  >>refer   molecule   CH+    +  N     =>   CN+   +     H     UMIST  */

			c[ipATN][ipCHP] -= CHP_N_CNP_H_1;
			c[ipCHP][ipCHP] -= CHP_N_CNP_H_2;
			bvec[ipCHP] -= bvec_CHP_N_CNP_H;
			
			c[ipATN][ipCNP] += CHP_N_CNP_H_1;
			c[ipCHP][ipCNP] += CHP_N_CNP_H_2;
			bvec[ipCNP] += bvec_CHP_N_CNP_H;

		/*  >>refer   molecule   CH     +  N+    =>   CN+   +     H     UMIST  */

			c[ipNP][ipCH] -= CH_NP_CNP_H_1;
			c[ipCH][ipCH] -= CH_NP_CNP_H_2;
			bvec[ipCH] -= bvec_CH_NP_CNP_H;
			
			c[ipNP][ipNP] -= CH_NP_CNP_H_1;
			c[ipCH][ipNP] -= CH_NP_CNP_H_2;
			bvec[ipNP] -= bvec_CH_NP_CNP_H;
			
			c[ipNP][ipCNP] += CH_NP_CNP_H_1;
			c[ipCH][ipCNP] += CH_NP_CNP_H_2;
			bvec[ipCNP] += bvec_CH_NP_CNP_H;
			
		/*  >>refer   molecule   CH     +  NH+   =>   CH2+  +     N     UMIST  */

			c[ipNHP][ipCH] -= CH_NHP_CH2P_N_1;
			c[ipCH][ipCH] -= CH_NHP_CH2P_N_2;
			bvec[ipCH] -= bvec_CH_NHP_CH2P_N;
			
			c[ipNHP][ipNHP] -= CH_NHP_CH2P_N_1;
			c[ipCH][ipNHP] -= CH_NHP_CH2P_N_2;
			bvec[ipNHP] -= bvec_CH_NHP_CH2P_N;
			
			c[ipNHP][ipCH2P] += CH_NHP_CH2P_N_1;
			c[ipCH][ipCH2P] += CH_NHP_CH2P_N_2;
			bvec[ipCH2P] += bvec_CH_NHP_CH2P_N;
			
		/*  >>refer   molecule   CH+    +  NH    =>   CN+   +     H2    UMIST  */

			c[ipNH][ipCHP] -= CHP_NH_CNP_H2_1;
			c[ipCHP][ipCHP] -= CHP_NH_CNP_H2_2;
			bvec[ipCHP] -= bvec_CHP_NH_CNP_H2;
			
			c[ipNH][ipNH] -= CHP_NH_CNP_H2_1;
			c[ipCHP][ipNH] -= CHP_NH_CNP_H2_2;
			bvec[ipNH] -= bvec_CHP_NH_CNP_H2;
			
			c[ipNH][ipCNP] += CHP_NH_CNP_H2_1;
			c[ipCHP][ipCNP] += CHP_NH_CNP_H2_2;
			bvec[ipCNP] += bvec_CHP_NH_CNP_H2;
			
		/*  >>refer   molecule   CH+    +  NH2   =>   HCN+  +     H2    UMIST  */

			c[ipNH2][ipCHP] -= CHP_NH2_HCNP_H2_1;
			c[ipCHP][ipCHP] -= CHP_NH2_HCNP_H2_2;
			bvec[ipCHP] -= bvec_CHP_NH2_HCNP_H2;
			
			c[ipNH2][ipNH2] -= CHP_NH2_HCNP_H2_1;
			c[ipCHP][ipNH2] -= CHP_NH2_HCNP_H2_2;
			bvec[ipNH2] -= bvec_CHP_NH2_HCNP_H2;
			
			c[ipNH2][ipHCNP] += CHP_NH2_HCNP_H2_1;
			c[ipCHP][ipHCNP] += CHP_NH2_HCNP_H2_2;
			bvec[ipHCNP] += bvec_CHP_NH2_HCNP_H2;

		/*  >>refer   molecule   CH     +  NH2+  =>   NH    +     CH2+  UMIST  */

			c[ipNH2P][ipCH] -= CH_NH2P_NH_CH2P_1;
			c[ipCH][ipCH] -= CH_NH2P_NH_CH2P_2;
			bvec[ipCH] -= bvec_CH_NH2P_NH_CH2P;
			
			c[ipNH2P][ipNH2P] -= CH_NH2P_NH_CH2P_1;
			c[ipCH][ipNH2P] -= CH_NH2P_NH_CH2P_2;
			bvec[ipNH2P] -= bvec_CH_NH2P_NH_CH2P;
			
			c[ipNH2P][ipNH] += CH_NH2P_NH_CH2P_1;
			c[ipCH][ipNH] += CH_NH2P_NH_CH2P_2;
			bvec[ipNH] += bvec_CH_NH2P_NH_CH2P;
			
			c[ipNH2P][ipCH2P] += CH_NH2P_NH_CH2P_1;
			c[ipCH][ipCH2P] += CH_NH2P_NH_CH2P_2;
			bvec[ipCH2P] += bvec_CH_NH2P_NH_CH2P;

		/*  >>refer   molecule   CH+    +  NH3   =>   NH4+  +     C     UMIST  */

			c[ipNH3][ipCHP] -= CHP_NH3_NH4P_C_1;
			c[ipCHP][ipCHP] -= CHP_NH3_NH4P_C_2;
			bvec[ipCHP] -= bvec_CHP_NH3_NH4P_C;
			
			c[ipNH3][ipNH3] -= CHP_NH3_NH4P_C_1;
			c[ipCHP][ipNH3] -= CHP_NH3_NH4P_C_2;
			bvec[ipNH3] -= bvec_CHP_NH3_NH4P_C;
			
			c[ipNH3][ipNH4P] += CHP_NH3_NH4P_C_1;
			c[ipCHP][ipNH4P] += CHP_NH3_NH4P_C_2;
			bvec[ipNH4P] += bvec_CHP_NH3_NH4P_C;

		/*  >>refer   molecule   CH     +  NH3+  =>   NH4+  +     C     UMIST  */

			c[ipNH3P][ipCH] -= CH_NH3P_NH4P_C_1;
			c[ipCH][ipCH] -= CH_NH3P_NH4P_C_2;
			bvec[ipCH] -= bvec_CH_NH3P_NH4P_C;
			
			c[ipNH3P][ipNH3P] -= CH_NH3P_NH4P_C_1;
			c[ipCH][ipNH3P] -= CH_NH3P_NH4P_C_2;
			bvec[ipNH3P] -= bvec_CH_NH3P_NH4P_C;
			
			c[ipNH3P][ipNH4P] += CH_NH3P_NH4P_C_1;
			c[ipCH][ipNH4P] += CH_NH3P_NH4P_C_2;
			bvec[ipNH4P] += bvec_CH_NH3P_NH4P_C;

		/*  >>refer   molecule   CH     +  HCN+  =>   CN    +     CH2+  UMIST  */

			c[ipHCNP][ipCH] -= CH_HCNP_CN_CH2P_1;
			c[ipCH][ipCH] -= CH_HCNP_CN_CH2P_2;
			bvec[ipCH] -= bvec_CH_HCNP_CN_CH2P;
			
			c[ipHCNP][ipHCNP] -= CH_HCNP_CN_CH2P_1;
			c[ipCH][ipHCNP] -= CH_HCNP_CN_CH2P_2;
			bvec[ipHCNP] -= bvec_CH_HCNP_CN_CH2P;
			
			c[ipHCNP][ipCN] += CH_HCNP_CN_CH2P_1;
			c[ipCH][ipCN] += CH_HCNP_CN_CH2P_2;
			bvec[ipCN] += bvec_CH_HCNP_CN_CH2P;
			
			c[ipHCNP][ipCH2P] += CH_HCNP_CN_CH2P_1;
			c[ipCH][ipCH2P] += CH_HCNP_CN_CH2P_2;
			bvec[ipCH2P] += bvec_CH_HCNP_CN_CH2P;

		/*  >>refer   molecule   CH     +  HNO+  =>   NO    +     CH2+  UMIST  */

			c[ipHNOP][ipCH] -= CH_HNOP_NO_CH2P_1;
			c[ipCH][ipCH] -= CH_HNOP_NO_CH2P_2;
			bvec[ipCH] -= bvec_CH_HNOP_NO_CH2P;
			
			c[ipHNOP][ipHNOP] -= CH_HNOP_NO_CH2P_1;
			c[ipCH][ipHNOP] -= CH_HNOP_NO_CH2P_2;
			bvec[ipHNOP] -= bvec_CH_HNOP_NO_CH2P;
			
			c[ipHNOP][ipNO] += CH_HNOP_NO_CH2P_1;
			c[ipCH][ipNO] += CH_HNOP_NO_CH2P_2;
			bvec[ipNO] += bvec_CH_HNOP_NO_CH2P;
			
			c[ipHNOP][ipCH2P] += CH_HNOP_NO_CH2P_1;
			c[ipCH][ipCH2P] += CH_HNOP_NO_CH2P_2;
			bvec[ipCH2P] += bvec_CH_HNOP_NO_CH2P;

		/*  >>refer   molecule   CH+    +  S     =>   HS+   +     C     UMIST  */
			
			c[ipATS][ipCHP] -= CHP_S_HSP_C_1;
			c[ipCHP][ipCHP] -= CHP_S_HSP_C_2;
			bvec[ipCHP] -= bvec_CHP_S_HSP_C;
			
			c[ipATS][ipHSP] += CHP_S_HSP_C_1;
			c[ipCHP][ipHSP] += CHP_S_HSP_C_2;
			bvec[ipHSP] += bvec_CHP_S_HSP_C;

		/*  >>refer   molecule   CH+    +  S     =>   CS+   +     H     UMIST  */
			
			c[ipATS][ipCHP] -= CHP_S_CSP_H_1;
			c[ipCHP][ipCHP] -= CHP_S_CSP_H_2;
			bvec[ipCHP] -= bvec_CHP_S_CSP_H;
			
			c[ipATS][ipCSP] += CHP_S_CSP_H_1;
			c[ipCHP][ipCSP] += CHP_S_CSP_H_2;
			bvec[ipCSP] += bvec_CHP_S_CSP_H;

		/*  >>refer   molecule   CH     +  S+    =>   CS+   +     H     UMIST  */

			c[ipSP][ipCH] -= CH_SP_CSP_H_1;
			c[ipCH][ipCH] -= CH_SP_CSP_H_2;
			bvec[ipCH] -= bvec_CH_SP_CSP_H;
			
			c[ipSP][ipSP] -= CH_SP_CSP_H_1;
			c[ipCH][ipSP] -= CH_SP_CSP_H_2;
			bvec[ipSP] -= bvec_CH_SP_CSP_H;
			
			c[ipSP][ipCSP] += CH_SP_CSP_H_1;
			c[ipCH][ipCSP] += CH_SP_CSP_H_2;
			bvec[ipCSP] += bvec_CH_SP_CSP_H;

		/*  >>refer   molecule   CH     +  HS+   =>   S     +     CH2+  UMIST  */

			c[ipHSP][ipCH] -= CH_HSP_S_CH2P_1;
			c[ipCH][ipCH] -= CH_HSP_S_CH2P_2;
			bvec[ipCH] -= bvec_CH_HSP_S_CH2P;
			
			c[ipHSP][ipHSP] -= CH_HSP_S_CH2P_1;
			c[ipCH][ipHSP] -= CH_HSP_S_CH2P_2;
			bvec[ipHSP] -= bvec_CH_HSP_S_CH2P;
			
			c[ipHSP][ipCH2P] += CH_HSP_S_CH2P_1;
			c[ipCH][ipCH2P] += CH_HSP_S_CH2P_2;
			bvec[ipCH2P] += bvec_CH_HSP_S_CH2P;

		/*  >>refer   molecule   CH+    +  OCS   =>   HCS+  +     CO    UMIST  */

			c[ipOCS][ipCHP] -= CHP_OCS_HCSP_CO_1;
			c[ipCHP][ipCHP] -= CHP_OCS_HCSP_CO_2;
			bvec[ipCHP] -= bvec_CHP_OCS_HCSP_CO;
			
			c[ipOCS][ipOCS] -= CHP_OCS_HCSP_CO_1;
			c[ipCHP][ipOCS] -= CHP_OCS_HCSP_CO_2;
			bvec[ipOCS] -= bvec_CHP_OCS_HCSP_CO;
			
			c[ipOCS][ipHCSP] += CHP_OCS_HCSP_CO_1;
			c[ipCHP][ipHCSP] += CHP_OCS_HCSP_CO_2;
			bvec[ipHCSP] += bvec_CHP_OCS_HCSP_CO;
			
			c[ipOCS][ipCO] += CHP_OCS_HCSP_CO_1;
			c[ipCHP][ipCO] += CHP_OCS_HCSP_CO_2;
			bvec[ipCO] += bvec_CHP_OCS_HCSP_CO;

		/*  >>refer   molecule   N      +  CH2+  =>   HCN+  +     H     UMIST  */

			c[ipCH2P][ipCH2P] -= N_CH2P_HCNP_H_1;
			c[ipATN][ipCH2P] -= N_CH2P_HCNP_H_2;
			bvec[ipCH2P] -= bvec_N_CH2P_HCNP_H;
			
			c[ipCH2P][ipHCNP] += N_CH2P_HCNP_H_1;
			c[ipATN][ipHCNP] += N_CH2P_HCNP_H_2;
			bvec[ipHCNP] += bvec_N_CH2P_HCNP_H;

		/*  >>refer   molecule   N+     +  NH    =>   N2+   +     H     UMIST  */

			c[ipNH][ipNP] -= NP_NH_N2P_H_1;
			c[ipNP][ipNP] -= NP_NH_N2P_H_2;
			bvec[ipNP] -= bvec_NP_NH_N2P_H;
			
			c[ipNH][ipNH] -= NP_NH_N2P_H_1;
			c[ipNP][ipNH] -= NP_NH_N2P_H_2;
			bvec[ipNH] -= bvec_NP_NH_N2P_H;
			
			c[ipNH][ipN2P] += NP_NH_N2P_H_1;
			c[ipNP][ipN2P] += NP_NH_N2P_H_2;
			bvec[ipN2P] += bvec_NP_NH_N2P_H;
			
		/*  >>refer   molecule   N      +  NH+   =>   N2+   +     H     UMIST  */

			c[ipNHP][ipNHP] -= N_NHP_N2P_H_1;
			c[ipATN][ipNHP] -= N_NHP_N2P_H_2;
			bvec[ipNHP] -= bvec_N_NHP_N2P_H;
			
			c[ipNHP][ipN2P] += N_NHP_N2P_H_1;
			c[ipATN][ipN2P] += N_NHP_N2P_H_2;
			bvec[ipN2P] += bvec_N_NHP_N2P_H;

		/*  >>refer   molecule   N+     +  CH4   =>   HCN+  +     H2 +  H      UMIST  */

			c[ipCH4][ipNP] -= NP_CH4_HCNP_H2_H_1;
			c[ipNP][ipNP] -= NP_CH4_HCNP_H2_H_2;
			bvec[ipNP] -= bvec_NP_CH4_HCNP_H2_H;
			
			c[ipCH4][ipCH4] -= NP_CH4_HCNP_H2_H_1;
			c[ipNP][ipCH4] -= NP_CH4_HCNP_H2_H_2;
			bvec[ipCH4] -= bvec_NP_CH4_HCNP_H2_H;
			
			c[ipCH4][ipHCNP] += NP_CH4_HCNP_H2_H_1;
			c[ipNP][ipHCNP] += NP_CH4_HCNP_H2_H_2;
			bvec[ipHCNP] += bvec_NP_CH4_HCNP_H2_H;
			
		/*  >>refer   molecule   N      +  OH+   =>   NO+   +     H     UMIST  */

			c[ipOHP][ipOHP] -= N_OHP_NOP_H_1;
			c[ipATN][ipOHP] -= N_OHP_NOP_H_2;
			bvec[ipOHP] -= bvec_N_OHP_NOP_H;
			
			c[ipOHP][ipNOP] += N_OHP_NOP_H_1;
			c[ipATN][ipNOP] += N_OHP_NOP_H_2;
			bvec[ipNOP] += bvec_N_OHP_NOP_H;

		/*  >>refer   molecule   N+     +  NH3   =>   NH2+  +     NH    UMIST  */

			c[ipNH3][ipNP] -= NP_NH3_NH2P_NH_1;
			c[ipNP][ipNP] -= NP_NH3_NH2P_NH_2;
			bvec[ipNP] -= bvec_NP_NH3_NH2P_NH;
			
			c[ipNH3][ipNH3] -= NP_NH3_NH2P_NH_1;
			c[ipNP][ipNH3] -= NP_NH3_NH2P_NH_2;
			bvec[ipNH3] -= bvec_NP_NH3_NH2P_NH;
			
			c[ipNH3][ipNH2P] += NP_NH3_NH2P_NH_1;
			c[ipNP][ipNH2P] += NP_NH3_NH2P_NH_2;
			bvec[ipNH2P] += bvec_NP_NH3_NH2P_NH;
			
			c[ipNH3][ipNH] += NP_NH3_NH2P_NH_1;
			c[ipNP][ipNH] += NP_NH3_NH2P_NH_2;
			bvec[ipNH] += bvec_NP_NH3_NH2P_NH;

		/*  >>refer   molecule   N      +  H2O+  =>   HNO+  +     H     UMIST  */

			c[ipH2OP][ipH2OP] -= N_H2OP_HNOP_H_1;
			c[ipATN][ipH2OP] -= N_H2OP_HNOP_H_2;
			bvec[ipH2OP] -= bvec_N_H2OP_HNOP_H;
			
			c[ipH2OP][ipHNOP] += N_H2OP_HNOP_H_1;
			c[ipATN][ipHNOP] += N_H2OP_HNOP_H_2;
			bvec[ipHNOP] += bvec_N_H2OP_HNOP_H;

		/*  >>refer   molecule   N+     +  CO    =>   NO+   +     C     UMIST  */

			c[ipCO][ipNP] -= NP_CO_NOP_C_1;
			c[ipNP][ipNP] -= NP_CO_NOP_C_2;
			bvec[ipNP] -= bvec_NP_CO_NOP_C;
			
			c[ipCO][ipCO] -= NP_CO_NOP_C_1;
			c[ipNP][ipCO] -= NP_CO_NOP_C_2;
			bvec[ipCO] -= bvec_NP_CO_NOP_C;
			
			c[ipCO][ipNOP] += NP_CO_NOP_C_1;
			c[ipNP][ipNOP] += NP_CO_NOP_C_2;
			bvec[ipNOP] += bvec_NP_CO_NOP_C;
			
		/*  >>refer   molecule   N+     +  NO    =>   N2+   +     O     UMIST  */

			c[ipNO][ipNP] -= NP_NO_N2P_O_1;
			c[ipNP][ipNP] -= NP_NO_N2P_O_2;
			bvec[ipNP] -= bvec_NP_NO_N2P_O;
			
			c[ipNO][ipNO] -= NP_NO_N2P_O_1;
			c[ipNP][ipNO] -= NP_NO_N2P_O_2;
			bvec[ipNO] -= bvec_NP_NO_N2P_O;
			
			c[ipNO][ipN2P] += NP_NO_N2P_O_1;
			c[ipNP][ipN2P] += NP_NO_N2P_O_2;
			bvec[ipN2P] += bvec_NP_NO_N2P_O;
			
		/*  >>refer   molecule   N+     +  O2    =>   NO    +     O+    UMIST  */

			c[ipO2][ipNP] -= NP_O2_NO_OP_1;
			c[ipNP][ipNP] -= NP_O2_NO_OP_2;
			bvec[ipNP] -= bvec_NP_O2_NO_OP;
			
			c[ipO2][ipO2] -= NP_O2_NO_OP_1;
			c[ipNP][ipO2] -= NP_O2_NO_OP_2;
			bvec[ipO2] -= bvec_NP_O2_NO_OP;
			
			c[ipO2][ipNO] += NP_O2_NO_OP_1;
			c[ipNP][ipNO] += NP_O2_NO_OP_2;
			bvec[ipNO] += bvec_NP_O2_NO_OP;
			
			c[ipO2][ipOP] += NP_O2_NO_OP_1;
			c[ipNP][ipOP] += NP_O2_NO_OP_2;
			bvec[ipOP] += bvec_NP_O2_NO_OP;

		/*  >>refer   molecule   N+     +  O2    =>   NO+   +     O     UMIST  */

			c[ipO2][ipNP] -= NP_O2_NOP_O_1;
			c[ipNP][ipNP] -= NP_O2_NOP_O_2;
			bvec[ipNP] -= bvec_NP_O2_NOP_O;
			
			c[ipO2][ipO2] -= NP_O2_NOP_O_1;
			c[ipNP][ipO2] -= NP_O2_NOP_O_2;
			bvec[ipO2] -= bvec_NP_O2_NOP_O;
			
			c[ipO2][ipNOP] += NP_O2_NOP_O_1;
			c[ipNP][ipNOP] += NP_O2_NOP_O_2;
			bvec[ipNOP] += bvec_NP_O2_NOP_O;

		/*  >>refer   molecule   N      +  O2+   =>   NO+   +     O     UMIST  */

			c[ipO2P][ipO2P] -= N_O2P_NOP_O_1;
			c[ipATN][ipO2P] -= N_O2P_NOP_O_2;
			bvec[ipO2P] -= bvec_N_O2P_NOP_O;
			
			c[ipO2P][ipNOP] += N_O2P_NOP_O_1;
			c[ipATN][ipNOP] += N_O2P_NOP_O_2;
			bvec[ipNOP] += bvec_N_O2P_NOP_O;

		/*  >>refer   molecule   N      +  HS+   =>   NS+   +     H     UMIST  */

			c[ipHSP][ipHSP] -= N_HSP_NSP_H_1;
			c[ipATN][ipHSP] -= N_HSP_NSP_H_2;
			bvec[ipHSP] -= bvec_N_HSP_NSP_H;
			
			c[ipHSP][ipNSP] += N_HSP_NSP_H_1;
			c[ipATN][ipNSP] += N_HSP_NSP_H_2;
			bvec[ipNSP] += bvec_N_HSP_NSP_H;

		/*  >>refer   molecule   N      +  SIO+  =>   NO+   +     SI    UMIST  */

			c[ipSIOP][ipSIOP] -= N_SIOP_NOP_SI_1;
			c[ipATN][ipSIOP] -= N_SIOP_NOP_SI_2;
			bvec[ipSIOP] -= bvec_N_SIOP_NOP_SI;
			
			c[ipSIOP][ipNOP] += N_SIOP_NOP_SI_1;
			c[ipATN][ipNOP] += N_SIOP_NOP_SI_2;
			bvec[ipNOP] += bvec_N_SIOP_NOP_SI;

		/*  >>refer   molecule   N      +  SIO+  =>   NO    +     SI+   UMIST  */

			c[ipSIOP][ipSIOP] -= N_SIOP_NO_SIP_1;
			c[ipATN][ipSIOP] -= N_SIOP_NO_SIP_2;
			bvec[ipSIOP] -= bvec_N_SIOP_NO_SIP;
			
			c[ipSIOP][ipNO] += N_SIOP_NO_SIP_1;
			c[ipATN][ipNO] += N_SIOP_NO_SIP_2;
			bvec[ipNO] += bvec_N_SIOP_NO_SIP;
			
			c[ipSIOP][ipSIP] += N_SIOP_NO_SIP_1;
			c[ipATN][ipSIP] += N_SIOP_NO_SIP_2;
			bvec[ipSIP] += bvec_N_SIOP_NO_SIP;

		/*  >>refer   molecule   N      +  SO+   =>   NS+   +     O     UMIST  */

			c[ipSOP][ipSOP] -= N_SOP_NSP_O_1;
			c[ipATN][ipSOP] -= N_SOP_NSP_O_2;
			bvec[ipSOP] -= bvec_N_SOP_NSP_O;
			
			c[ipSOP][ipNSP] += N_SOP_NSP_O_1;
			c[ipATN][ipNSP] += N_SOP_NSP_O_2;
			bvec[ipNSP] += bvec_N_SOP_NSP_O;

		/*  >>refer   molecule   N+     +  OCS   =>   S+    +     CO +  N      UMIST  */

			c[ipOCS][ipNP] -= NP_OCS_SP_CO_N_1;
			c[ipNP][ipNP] -= NP_OCS_SP_CO_N_2;
			bvec[ipNP] -= bvec_NP_OCS_SP_CO_N;
			
			c[ipOCS][ipOCS] -= NP_OCS_SP_CO_N_1;
			c[ipNP][ipOCS] -= NP_OCS_SP_CO_N_2;
			bvec[ipOCS] -= bvec_NP_OCS_SP_CO_N;
			
			c[ipOCS][ipSP] += NP_OCS_SP_CO_N_1;
			c[ipNP][ipSP] += NP_OCS_SP_CO_N_2;
			bvec[ipSP] += bvec_NP_OCS_SP_CO_N;
			
			c[ipOCS][ipCO] += NP_OCS_SP_CO_N_1;
			c[ipNP][ipCO] += NP_OCS_SP_CO_N_2;
			bvec[ipCO] += bvec_NP_OCS_SP_CO_N;

		/*  >>refer   molecule   N+     +  OCS   =>   CS+   +     NO    UMIST  */

			c[ipOCS][ipNP] -= NP_OCS_CSP_NO_1;
			c[ipNP][ipNP] -= NP_OCS_CSP_NO_2;
			bvec[ipNP] -= bvec_NP_OCS_CSP_NO;
			
			c[ipOCS][ipOCS] -= NP_OCS_CSP_NO_1;
			c[ipNP][ipOCS] -= NP_OCS_CSP_NO_2;
			bvec[ipOCS] -= bvec_NP_OCS_CSP_NO;
			
			c[ipOCS][ipCSP] += NP_OCS_CSP_NO_1;
			c[ipNP][ipCSP] += NP_OCS_CSP_NO_2;
			bvec[ipCSP] += bvec_NP_OCS_CSP_NO;
			
			c[ipOCS][ipNO] += NP_OCS_CSP_NO_1;
			c[ipNP][ipNO] += NP_OCS_CSP_NO_2;
			bvec[ipNO] += bvec_NP_OCS_CSP_NO;

		/*  >>refer   molecule   CH2    +  NH+   =>   CH3+  +     N     UMIST  */

			c[ipNHP][ipCH2] -= CH2_NHP_CH3P_N_1;
			c[ipCH2][ipCH2] -= CH2_NHP_CH3P_N_2;
			bvec[ipCH2] -= bvec_CH2_NHP_CH3P_N;
			
			c[ipNHP][ipNHP] -= CH2_NHP_CH3P_N_1;
			c[ipCH2][ipNHP] -= CH2_NHP_CH3P_N_2;
			bvec[ipNHP] -= bvec_CH2_NHP_CH3P_N;
			
			c[ipNHP][ipCH3P] += CH2_NHP_CH3P_N_1;
			c[ipCH2][ipCH3P] += CH2_NHP_CH3P_N_2;
			bvec[ipCH3P] += bvec_CH2_NHP_CH3P_N;

		/*  >>refer   molecule   CH2    +  NH2+  =>   CH3+  +     NH    UMIST  */

			c[ipNH2P][ipCH2] -= CH2_NH2P_CH3P_NH_1;
			c[ipCH2][ipCH2] -= CH2_NH2P_CH3P_NH_2;
			bvec[ipCH2] -= bvec_CH2_NH2P_CH3P_NH;
			
			c[ipNH2P][ipNH2P] -= CH2_NH2P_CH3P_NH_1;
			c[ipCH2][ipNH2P] -= CH2_NH2P_CH3P_NH_2;
			bvec[ipNH2P] -= bvec_CH2_NH2P_CH3P_NH;
			
			c[ipNH2P][ipCH3P] += CH2_NH2P_CH3P_NH_1;
			c[ipCH2][ipCH3P] += CH2_NH2P_CH3P_NH_2;
			bvec[ipCH3P] += bvec_CH2_NH2P_CH3P_NH;
			
			c[ipNH2P][ipNH] += CH2_NH2P_CH3P_NH_1;
			c[ipCH2][ipNH] += CH2_NH2P_CH3P_NH_2;
			bvec[ipNH] += bvec_CH2_NH2P_CH3P_NH;

		/*  >>refer   molecule   CH2+   +  NH3   =>   NH4+  +     CH    UMIST  */

			c[ipNH3][ipCH2P] -= CH2P_NH3_NH4P_CH_1;
			c[ipCH2P][ipCH2P] -= CH2P_NH3_NH4P_CH_2;
			bvec[ipCH2P] -= bvec_CH2P_NH3_NH4P_CH;
			
			c[ipNH3][ipNH3] -= CH2P_NH3_NH4P_CH_1;
			c[ipCH2P][ipNH3] -= CH2P_NH3_NH4P_CH_2;
			bvec[ipNH3] -= bvec_CH2P_NH3_NH4P_CH;
			
			c[ipNH3][ipNH4P] += CH2P_NH3_NH4P_CH_1;
			c[ipCH2P][ipNH4P] += CH2P_NH3_NH4P_CH_2;
			bvec[ipNH4P] += bvec_CH2P_NH3_NH4P_CH;
			
			c[ipNH3][ipCH] += CH2P_NH3_NH4P_CH_1;
			c[ipCH2P][ipCH] += CH2P_NH3_NH4P_CH_2;
			bvec[ipCH] += bvec_CH2P_NH3_NH4P_CH;

		/*  >>refer   molecule   CH2    +  NH3+  =>   NH2   +     CH3+  UMIST  */

			c[ipNH3P][ipCH2] -= CH2_NH3P_NH2_CH3P_1;
			c[ipCH2][ipCH2] -= CH2_NH3P_NH2_CH3P_2;
			bvec[ipCH2] -= bvec_CH2_NH3P_NH2_CH3P;
			
			c[ipNH3P][ipNH3P] -= CH2_NH3P_NH2_CH3P_1;
			c[ipCH2][ipNH3P] -= CH2_NH3P_NH2_CH3P_2;
			bvec[ipNH3P] -= bvec_CH2_NH3P_NH2_CH3P;
			
			c[ipNH3P][ipNH2] += CH2_NH3P_NH2_CH3P_1;
			c[ipCH2][ipNH2] += CH2_NH3P_NH2_CH3P_2;
			bvec[ipNH2] += bvec_CH2_NH3P_NH2_CH3P;
			
			c[ipNH3P][ipCH3P] += CH2_NH3P_NH2_CH3P_1;
			c[ipCH2][ipCH3P] += CH2_NH3P_NH2_CH3P_2;
			bvec[ipCH3P] += bvec_CH2_NH3P_NH2_CH3P;

		/*  >>refer   molecule   CH2    +  HCN+  =>   CN    +     CH3+  UMIST  */

			c[ipHCNP][ipCH2] -= CH2_HCNP_CN_CH3P_1;
			c[ipCH2][ipCH2] -= CH2_HCNP_CN_CH3P_2;
			bvec[ipCH2] -= bvec_CH2_HCNP_CN_CH3P;
			
			c[ipHCNP][ipHCNP] -= CH2_HCNP_CN_CH3P_1;
			c[ipCH2][ipHCNP] -= CH2_HCNP_CN_CH3P_2;
			bvec[ipHCNP] -= bvec_CH2_HCNP_CN_CH3P;
			
			c[ipHCNP][ipCN] += CH2_HCNP_CN_CH3P_1;
			c[ipCH2][ipCN] += CH2_HCNP_CN_CH3P_2;
			bvec[ipCN] += bvec_CH2_HCNP_CN_CH3P;
			
			c[ipHCNP][ipCH3P] += CH2_HCNP_CN_CH3P_1;
			c[ipCH2][ipCH3P] += CH2_HCNP_CN_CH3P_2;
			bvec[ipCH3P] += bvec_CH2_HCNP_CN_CH3P;

		/*  >>refer   molecule   CH2    +  HNO+  =>   NO    +     CH3+  UMIST  */

			c[ipHNOP][ipCH2] -= CH2_HNOP_NO_CH3P_1;
			c[ipCH2][ipCH2] -= CH2_HNOP_NO_CH3P_2;
			bvec[ipCH2] -= bvec_CH2_HNOP_NO_CH3P;
			
			c[ipHNOP][ipHNOP] -= CH2_HNOP_NO_CH3P_1;
			c[ipCH2][ipHNOP] -= CH2_HNOP_NO_CH3P_2;
			bvec[ipHNOP] -= bvec_CH2_HNOP_NO_CH3P;
			
			c[ipHNOP][ipNO] += CH2_HNOP_NO_CH3P_1;
			c[ipCH2][ipNO] += CH2_HNOP_NO_CH3P_2;
			bvec[ipNO] += bvec_CH2_HNOP_NO_CH3P;
			
			c[ipHNOP][ipCH3P] += CH2_HNOP_NO_CH3P_1;
			c[ipCH2][ipCH3P] += CH2_HNOP_NO_CH3P_2;
			bvec[ipCH3P] += bvec_CH2_HNOP_NO_CH3P;

		/*  >>refer   molecule   CH2+   +  S     =>   HCS+  +     H     UMIST  */

			c[ipATS][ipCH2P] -= CH2P_S_HCSP_H_1;
			c[ipCH2P][ipCH2P] -= CH2P_S_HCSP_H_2;
			bvec[ipCH2P] -= bvec_CH2P_S_HCSP_H;
			
			c[ipATS][ipHCSP] += CH2P_S_HCSP_H_1;
			c[ipCH2P][ipHCSP] += CH2P_S_HCSP_H_2;
			bvec[ipHCSP] += bvec_CH2P_S_HCSP_H;

		/*  >>refer   molecule   CH2    +  S+    =>   HCS+  +     H     UMIST  */

			c[ipSP][ipCH2] -= CH2_SP_HCSP_H_1;
			c[ipCH2][ipCH2] -= CH2_SP_HCSP_H_2;
			bvec[ipCH2] -= bvec_CH2_SP_HCSP_H;
			
			c[ipSP][ipSP] -= CH2_SP_HCSP_H_1;
			c[ipCH2][ipSP] -= CH2_SP_HCSP_H_2;
			bvec[ipSP] -= bvec_CH2_SP_HCSP_H;
			
			c[ipSP][ipHCSP] += CH2_SP_HCSP_H_1;
			c[ipCH2][ipHCSP] += CH2_SP_HCSP_H_2;
			bvec[ipHCSP] += bvec_CH2_SP_HCSP_H;
			
		/*  >>refer   molecule   NH+    +  NH    =>   NH2+  +     N     UMIST  */

			c[ipNH][ipNHP] -= NHP_NH_NH2P_N_1;
			c[ipNHP][ipNHP] -= NHP_NH_NH2P_N_2;
			bvec[ipNHP] -= bvec_NHP_NH_NH2P_N;
			
			c[ipNH][ipNH] -= NHP_NH_NH2P_N_1;
			c[ipNHP][ipNH] -= NHP_NH_NH2P_N_2;
			bvec[ipNH] -= bvec_NHP_NH_NH2P_N;
			
			c[ipNH][ipNH2P] += NHP_NH_NH2P_N_1;
			c[ipNHP][ipNH2P] += NHP_NH_NH2P_N_2;
			bvec[ipNH2P] += bvec_NHP_NH_NH2P_N;
			
		/*  >>refer   molecule   NH+    +  O     =>   OH+   +     N     UMIST  */

			c[ipATO][ipNHP] -= NHP_O_OHP_N_1;
			c[ipNHP][ipNHP] -= NHP_O_OHP_N_2;
			bvec[ipNHP] -= bvec_NHP_O_OHP_N;
			
			c[ipATO][ipOHP] += NHP_O_OHP_N_1;
			c[ipNHP][ipOHP] += NHP_O_OHP_N_2;
			bvec[ipOHP] += bvec_NHP_O_OHP_N;

		/*  >>refer   molecule   NH     +  O+    =>   NO+   +     H     UMIST  */

			c[ipOP][ipNH] -= NH_OP_NOP_H_1;
			c[ipNH][ipNH] -= NH_OP_NOP_H_2;
			bvec[ipNH] -= bvec_NH_OP_NOP_H;
			
			c[ipOP][ipOP] -= NH_OP_NOP_H_1;
			c[ipNH][ipOP] -= NH_OP_NOP_H_2;
			bvec[ipOP] -= bvec_NH_OP_NOP_H;
			
			c[ipOP][ipNOP] += NH_OP_NOP_H_1;
			c[ipNH][ipNOP] += NH_OP_NOP_H_2;
			bvec[ipNOP] += bvec_NH_OP_NOP_H;

		/*  >>refer   molecule   NH+    +  NH2   =>   NH3+  +     N     UMIST  */

			c[ipNH2][ipNHP] -= NHP_NH2_NH3P_N_1;
			c[ipNHP][ipNHP] -= NHP_NH2_NH3P_N_2;
			bvec[ipNHP] -= bvec_NHP_NH2_NH3P_N;
			
			c[ipNH2][ipNH2] -= NHP_NH2_NH3P_N_1;
			c[ipNHP][ipNH2] -= NHP_NH2_NH3P_N_2;
			bvec[ipNH2] -= bvec_NHP_NH2_NH3P_N;
			
			c[ipNH2][ipNH3P] += NHP_NH2_NH3P_N_1;
			c[ipNHP][ipNH3P] += NHP_NH2_NH3P_N_2;
			bvec[ipNH3P] += bvec_NHP_NH2_NH3P_N;
			
		/*  >>refer   molecule   NH     +  NH2+  =>   NH3+  +     N     UMIST  */

			c[ipNH2P][ipNH] -= NH_NH2P_NH3P_N_1;
			c[ipNH][ipNH] -= NH_NH2P_NH3P_N_2;
			bvec[ipNH] -= bvec_NH_NH2P_NH3P_N;
			
			c[ipNH2P][ipNH2P] -= NH_NH2P_NH3P_N_1;
			c[ipNH][ipNH2P] -= NH_NH2P_NH3P_N_2;
			bvec[ipNH2P] -= bvec_NH_NH2P_NH3P_N;
			
			c[ipNH2P][ipNH3P] += NH_NH2P_NH3P_N_1;
			c[ipNH][ipNH3P] += NH_NH2P_NH3P_N_2;
			bvec[ipNH3P] += bvec_NH_NH2P_NH3P_N;
			
		/*  >>refer   molecule   NH+    +  OH    =>   H2O+  +     N     UMIST  */
			
			c[ipOH][ipNHP] -= NHP_OH_H2OP_N_1;
			c[ipNHP][ipNHP] -= NHP_OH_H2OP_N_2;
			bvec[ipNHP] -= bvec_NHP_OH_H2OP_N;

			c[ipOH][ipOH] -= NHP_OH_H2OP_N_1;
			c[ipNHP][ipOH] -= NHP_OH_H2OP_N_2;
			bvec[ipOH] -= bvec_NHP_OH_H2OP_N;
			
			c[ipOH][ipH2OP] += NHP_OH_H2OP_N_1;
			c[ipNHP][ipH2OP] += NHP_OH_H2OP_N_2;
			bvec[ipH2OP] += bvec_NHP_OH_H2OP_N;
			
		/*  >>refer   molecule   NH     +  OH+   =>   NH2+  +     O     UMIST  */

			c[ipOHP][ipNH] -= NH_OHP_NH2P_O_1;
			c[ipNH][ipNH] -= NH_OHP_NH2P_O_2;
			bvec[ipNH] -= bvec_NH_OHP_NH2P_O;
			
			c[ipOHP][ipOHP] -= NH_OHP_NH2P_O_1;
			c[ipNH][ipOHP] -= NH_OHP_NH2P_O_2;
			bvec[ipOHP] -= bvec_NH_OHP_NH2P_O;
			
			c[ipOHP][ipNH2P] += NH_OHP_NH2P_O_1;
			c[ipNH][ipNH2P] += NH_OHP_NH2P_O_2;
			bvec[ipNH2P] += bvec_NH_OHP_NH2P_O;
			
		/*  >>refer   molecule   NH+    +  NH3   =>   NH4+  +     N     UMIST  */

			c[ipNH3][ipNHP] -= NHP_NH3_NH4P_N_1;
			c[ipNHP][ipNHP] -= NHP_NH3_NH4P_N_2;
			bvec[ipNHP] -= bvec_NHP_NH3_NH4P_N;
			
			c[ipNH3][ipNH3] -= NHP_NH3_NH4P_N_1;
			c[ipNHP][ipNH3] -= NHP_NH3_NH4P_N_2;
			bvec[ipNH3] -= bvec_NHP_NH3_NH4P_N;
			
			c[ipNH3][ipNH4P] += NHP_NH3_NH4P_N_1;
			c[ipNHP][ipNH4P] += NHP_NH3_NH4P_N_2;
			bvec[ipNH4P] += bvec_NHP_NH3_NH4P_N;
			
		/*  >>refer   molecule   NH     +  NH3+  =>   NH4+  +     N     UMIST  */

			c[ipNH3P][ipNH] -= NH_NH3P_NH4P_N_1;
			c[ipNH][ipNH] -= NH_NH3P_NH4P_N_2;
			bvec[ipNH] -= bvec_NH_NH3P_NH4P_N;
			
			c[ipNH3P][ipNH3P] -= NH_NH3P_NH4P_N_1;
			c[ipNH][ipNH3P] -= NH_NH3P_NH4P_N_2;
			bvec[ipNH3P] -= bvec_NH_NH3P_NH4P_N;
			
			c[ipNH3P][ipNH4P] += NH_NH3P_NH4P_N_1;
			c[ipNH][ipNH4P] += NH_NH3P_NH4P_N_2;
			bvec[ipNH4P] += bvec_NH_NH3P_NH4P_N;

		/*  >>refer   molecule   NH     +  CH5+  =>   CH4   +     NH2+  UMIST  */

			c[ipCH5P][ipNH] -= NH_CH5P_CH4_NH2P_1;
			c[ipNH][ipNH] -= NH_CH5P_CH4_NH2P_2;
			bvec[ipNH] -= bvec_NH_CH5P_CH4_NH2P;
			
			c[ipCH5P][ipCH5P] -= NH_CH5P_CH4_NH2P_1;
			c[ipNH][ipCH5P] -= NH_CH5P_CH4_NH2P_2;
			bvec[ipCH5P] -= bvec_NH_CH5P_CH4_NH2P;
			
			c[ipCH5P][ipCH4] += NH_CH5P_CH4_NH2P_1;
			c[ipNH][ipCH4] += NH_CH5P_CH4_NH2P_2;
			bvec[ipCH4] += bvec_NH_CH5P_CH4_NH2P;
			
			c[ipCH5P][ipNH2P] += NH_CH5P_CH4_NH2P_1;
			c[ipNH][ipNH2P] += NH_CH5P_CH4_NH2P_2;
			bvec[ipNH2P] += bvec_NH_CH5P_CH4_NH2P;

		/*  >>refer   molecule   NH+    +  H2O   =>   NH3+  +     O     UMIST  */

			c[ipH2O][ipNHP] -= NHP_H2O_NH3P_O_1;
			c[ipNHP][ipNHP] -= NHP_H2O_NH3P_O_2;
			bvec[ipNHP] -= bvec_NHP_H2O_NH3P_O;
			
			c[ipH2O][ipH2O] -= NHP_H2O_NH3P_O_1;
			c[ipNHP][ipH2O] -= NHP_H2O_NH3P_O_2;
			bvec[ipH2O] -= bvec_NHP_H2O_NH3P_O;
			
			c[ipH2O][ipNH3P] += NHP_H2O_NH3P_O_1;
			c[ipNHP][ipNH3P] += NHP_H2O_NH3P_O_2;
			bvec[ipNH3P] += bvec_NHP_H2O_NH3P_O;		

		/*  >>refer   molecule   NH+    +  H2O   =>   H3O+  +     N     UMIST  */

			c[ipH2O][ipNHP] -= NHP_H2O_H3OP_N_1;
			c[ipNHP][ipNHP] -= NHP_H2O_H3OP_N_2;
			bvec[ipNHP] -= bvec_NHP_H2O_H3OP_N;
			
			c[ipH2O][ipH2O] -= NHP_H2O_H3OP_N_1;
			c[ipNHP][ipH2O] -= NHP_H2O_H3OP_N_2;
			bvec[ipH2O] -= bvec_NHP_H2O_H3OP_N;
			
			c[ipH2O][ipH3OP] += NHP_H2O_H3OP_N_1;
			c[ipNHP][ipH3OP] += NHP_H2O_H3OP_N_2;
			bvec[ipH3OP] += bvec_NHP_H2O_H3OP_N;

		/*  >>refer   molecule   NH+    +  H2O   =>   HNO+  +     H2    UMIST  */

			c[ipH2O][ipNHP] -= NHP_H2O_HNOP_H2_1;
			c[ipNHP][ipNHP] -= NHP_H2O_HNOP_H2_2;
			bvec[ipNHP] -= bvec_NHP_H2O_HNOP_H2;
			
			c[ipH2O][ipH2O] -= NHP_H2O_HNOP_H2_1;
			c[ipNHP][ipH2O] -= NHP_H2O_HNOP_H2_2;
			bvec[ipH2O] -= bvec_NHP_H2O_HNOP_H2;
			
			c[ipH2O][ipHNOP] += NHP_H2O_HNOP_H2_1;
			c[ipNHP][ipHNOP] += NHP_H2O_HNOP_H2_2;
			bvec[ipHNOP] += bvec_NHP_H2O_HNOP_H2;
			
		/*  >>refer   molecule   NH     +  H2O+  =>   H3O+  +     N     UMIST  */

			c[ipH2OP][ipNH] -= NH_H2OP_H3OP_N_1;
			c[ipNH][ipNH] -= NH_H2OP_H3OP_N_2;
			bvec[ipNH] -= bvec_NH_H2OP_H3OP_N;
			
			c[ipH2OP][ipH2OP] -= NH_H2OP_H3OP_N_1;
			c[ipNH][ipH2OP] -= NH_H2OP_H3OP_N_2;
			bvec[ipH2OP] -= bvec_NH_H2OP_H3OP_N;
			
			c[ipH2OP][ipH3OP] += NH_H2OP_H3OP_N_1;
			c[ipNH][ipH3OP] += NH_H2OP_H3OP_N_2;
			bvec[ipH3OP] += bvec_NH_H2OP_H3OP_N;

		/*  >>refer   molecule   NH+    +  H2O   =>   OH    +     NH2+  UMIST  */

			c[ipH2O][ipNHP] -= NHP_H2O_OH_NH2P_1;
			c[ipNHP][ipNHP] -= NHP_H2O_OH_NH2P_2;
			bvec[ipNHP] -= bvec_NHP_H2O_OH_NH2P;
			
			c[ipH2O][ipH2O] -= NHP_H2O_OH_NH2P_1;
			c[ipNHP][ipH2O] -= NHP_H2O_OH_NH2P_2;
			bvec[ipH2O] -= bvec_NHP_H2O_OH_NH2P;
			
			c[ipH2O][ipOH] += NHP_H2O_OH_NH2P_1;
			c[ipNHP][ipOH] += NHP_H2O_OH_NH2P_2;
			bvec[ipOH] += bvec_NHP_H2O_OH_NH2P;
			
			c[ipH2O][ipNH2P] += NHP_H2O_OH_NH2P_1;
			c[ipNHP][ipNH2P] += NHP_H2O_OH_NH2P_2;
			bvec[ipNH2P] += bvec_NHP_H2O_OH_NH2P;

		/*  >>refer   molecule   NH+    +  CN    =>   HCN+  +     N     UMIST  */

			c[ipCN][ipCN] -= NHP_CN_HCNP_N_1;
			c[ipNHP][ipCN] -= NHP_CN_HCNP_N_2;
			bvec[ipCN] -= bvec_NHP_CN_HCNP_N;
			
			c[ipCN][ipNHP] -= NHP_CN_HCNP_N_1;
			c[ipNHP][ipNHP] -= NHP_CN_HCNP_N_2;
			bvec[ipNHP] -= bvec_NHP_CN_HCNP_N;
			
			c[ipCN][ipHCNP] += NHP_CN_HCNP_N_1;
			c[ipNHP][ipHCNP] += NHP_CN_HCNP_N_2;
			bvec[ipHCNP] += bvec_NHP_CN_HCNP_N;
			
		/*  >>refer   molecule   NH     +  HCN+  =>   CN    +     NH2+  UMIST  */

			c[ipHCNP][ipNH] -= NH_HCNP_CN_NH2P_1;
			c[ipNH][ipNH] -= NH_HCNP_CN_NH2P_2;
			bvec[ipNH] -= bvec_NH_HCNP_CN_NH2P;
			
			c[ipHCNP][ipHCNP] -= NH_HCNP_CN_NH2P_1;
			c[ipNH][ipHCNP] -= NH_HCNP_CN_NH2P_2;
			bvec[ipHCNP] -= bvec_NH_HCNP_CN_NH2P;
			
			c[ipHCNP][ipCN] += NH_HCNP_CN_NH2P_1;
			c[ipNH][ipCN] += NH_HCNP_CN_NH2P_2;
			bvec[ipCN] += bvec_NH_HCNP_CN_NH2P;
			
			c[ipHCNP][ipNH2P] += NH_HCNP_CN_NH2P_1;
			c[ipNH][ipNH2P] += NH_HCNP_CN_NH2P_2;
			bvec[ipNH2P] += bvec_NH_HCNP_CN_NH2P;

		/*  >>refer   molecule   NH+    +  CO    =>   HCO+  +     N     UMIST  */

			c[ipCO][ipNHP] -= NHP_CO_HCOP_N_1;
			c[ipNHP][ipNHP] -= NHP_CO_HCOP_N_2;
			bvec[ipNHP] -= bvec_NHP_CO_HCOP_N;
			
			c[ipCO][ipCO] -= NHP_CO_HCOP_N_1;
			c[ipNHP][ipCO] -= NHP_CO_HCOP_N_2;
			bvec[ipCO] -= bvec_NHP_CO_HCOP_N;
			
			c[ipCO][ipHCOP] += NHP_CO_HCOP_N_1;
			c[ipNHP][ipHCOP] += NHP_CO_HCOP_N_2;
			bvec[ipHCOP] += bvec_NHP_CO_HCOP_N;
			
		/*  >>refer   molecule   NH     +  CO+   =>   HCO+  +     N     UMIST  */

			c[ipCOP][ipNH] -= NH_COP_HCOP_N_1;
			c[ipNH][ipNH] -= NH_COP_HCOP_N_2;
			bvec[ipNH] -= bvec_NH_COP_HCOP_N;
			
			c[ipCOP][ipCOP] -= NH_COP_HCOP_N_1;
			c[ipNH][ipCOP] -= NH_COP_HCOP_N_2;
			bvec[ipCOP] -= bvec_NH_COP_HCOP_N;
			
			c[ipCOP][ipHCOP] += NH_COP_HCOP_N_1;
			c[ipNH][ipHCOP] += NH_COP_HCOP_N_2;
			bvec[ipHCOP] += bvec_NH_COP_HCOP_N;
			
		/*  >>refer   molecule   NH+    +  CO    =>   OCN+  +     H     UMIST  */

			c[ipCO][ipNHP] -= NHP_CO_OCNP_H_1;
			c[ipNHP][ipNHP] -= NHP_CO_OCNP_H_2;
			bvec[ipNHP] -= bvec_NHP_CO_OCNP_H;
			
			c[ipCO][ipCO] -= NHP_CO_OCNP_H_1;
			c[ipNHP][ipCO] -= NHP_CO_OCNP_H_2;
			bvec[ipCO] -= bvec_NHP_CO_OCNP_H;
			
			c[ipCO][ipOCNP] += NHP_CO_OCNP_H_1;
			c[ipNHP][ipOCNP] += NHP_CO_OCNP_H_2;
			bvec[ipOCNP] += bvec_NHP_CO_OCNP_H;

		/*  >>refer   molecule   NH     +  SI+   =>   SIN+  +     H     UMIST  */

			c[ipSIP][ipNH] -= NH_SIP_SINP_H_1;
			c[ipNH][ipNH] -= NH_SIP_SINP_H_2;
			bvec[ipNH] -= bvec_NH_SIP_SINP_H;
			
			c[ipSIP][ipSIP] -= NH_SIP_SINP_H_1;
			c[ipNH][ipSIP] -= NH_SIP_SINP_H_2;
			bvec[ipSIP] -= bvec_NH_SIP_SINP_H;
			
			c[ipSIP][ipSINP] += NH_SIP_SINP_H_1;
			c[ipNH][ipSINP] += NH_SIP_SINP_H_2;
			bvec[ipSINP] += bvec_NH_SIP_SINP_H;
			
		/*  >>refer   molecule   NH     +  HCO+  =>   CO    +     NH2+  UMIST  */

			c[ipHCOP][ipNH] -= NH_HCOP_CO_NH2P_1;
			c[ipNH][ipNH] -= NH_HCOP_CO_NH2P_2;
			bvec[ipNH] -= bvec_NH_HCOP_CO_NH2P;
			
			c[ipHCOP][ipHCOP] -= NH_HCOP_CO_NH2P_1;
			c[ipNH][ipHCOP] -= NH_HCOP_CO_NH2P_2;
			bvec[ipHCOP] -= bvec_NH_HCOP_CO_NH2P;
			
			c[ipHCOP][ipCO] += NH_HCOP_CO_NH2P_1;
			c[ipNH][ipCO] += NH_HCOP_CO_NH2P_2;
			bvec[ipCO] += bvec_NH_HCOP_CO_NH2P;
			
			c[ipHCOP][ipNH2P] += NH_HCOP_CO_NH2P_1;
			c[ipNH][ipNH2P] += NH_HCOP_CO_NH2P_2;
			bvec[ipNH2P] += bvec_NH_HCOP_CO_NH2P;

		/*  >>refer   molecule   NH     +  HNO+  =>   NO    +     NH2+  UMIST  */

			c[ipHNOP][ipNH] -= NH_HNOP_NO_NH2P_1;
			c[ipNH][ipNH] -= NH_HNOP_NO_NH2P_2;
			bvec[ipNH] -= bvec_NH_HNOP_NO_NH2P;
			
			c[ipHNOP][ipHNOP] -= NH_HNOP_NO_NH2P_1;
			c[ipNH][ipHNOP] -= NH_HNOP_NO_NH2P_2;
			bvec[ipHNOP] -= bvec_NH_HNOP_NO_NH2P;
			
			c[ipHNOP][ipNO] += NH_HNOP_NO_NH2P_1;
			c[ipNH][ipNO] += NH_HNOP_NO_NH2P_2;
			bvec[ipNO] += bvec_NH_HNOP_NO_NH2P;
			
			c[ipHNOP][ipNH2P] += NH_HNOP_NO_NH2P_1;
			c[ipNH][ipNH2P] += NH_HNOP_NO_NH2P_2;
			bvec[ipNH2P] += bvec_NH_HNOP_NO_NH2P;

		/*  >>refer   molecule   NH     +  O2+   =>   HNO+  +     O     UMIST  */
			
			c[ipO2P][ipO2P] -= NH_O2P_HNOP_O_1;
			c[ipNH][ipO2P] -= NH_O2P_HNOP_O_2;
			bvec[ipO2P] -= bvec_NH_O2P_HNOP_O;

			c[ipO2P][ipNH] -= NH_O2P_HNOP_O_1;
			c[ipNH][ipNH] -= NH_O2P_HNOP_O_2;
			bvec[ipNH] -= bvec_NH_O2P_HNOP_O;
			
			c[ipO2P][ipHNOP] += NH_O2P_HNOP_O_1;
			c[ipNH][ipHNOP] += NH_O2P_HNOP_O_2;
			bvec[ipHNOP] += bvec_NH_O2P_HNOP_O;
			
		/*  >>refer   molecule   NH+    +  O2    =>   NO+   +     OH    UMIST  */

			c[ipO2][ipNHP] -= NHP_O2_NOP_OH_1;
			c[ipNHP][ipNHP] -= NHP_O2_NOP_OH_2;
			bvec[ipNHP] -= bvec_NHP_O2_NOP_OH;
			
			c[ipO2][ipO2] -= NHP_O2_NOP_OH_1;
			c[ipNHP][ipO2] -= NHP_O2_NOP_OH_2;
			bvec[ipO2] -= bvec_NHP_O2_NOP_OH;
			
			c[ipO2][ipNOP] += NHP_O2_NOP_OH_1;
			c[ipNHP][ipNOP] += NHP_O2_NOP_OH_2;
			bvec[ipNOP] += bvec_NHP_O2_NOP_OH;
			
			c[ipO2][ipOH] += NHP_O2_NOP_OH_1;
			c[ipNHP][ipOH] += NHP_O2_NOP_OH_2;
			bvec[ipOH] += bvec_NHP_O2_NOP_OH;

		/*  >>refer   molecule   NH     +  O2+   =>   NO2+  +     H     UMIST  */

			c[ipO2P][ipNH] -= NH_O2P_NO2P_H_1;
			c[ipNH][ipNH] -= NH_O2P_NO2P_H_2;
			bvec[ipNH] -= bvec_NH_O2P_NO2P_H;
			
			c[ipO2P][ipO2P] -= NH_O2P_NO2P_H_1;
			c[ipNH][ipO2P] -= NH_O2P_NO2P_H_2;
			bvec[ipO2P] -= bvec_NH_O2P_NO2P_H;
			
			c[ipO2P][ipNO2P] += NH_O2P_NO2P_H_1;
			c[ipNH][ipNO2P] += NH_O2P_NO2P_H_2;
			bvec[ipNO2P] += bvec_NH_O2P_NO2P_H;
			
		/*  >>refer   molecule   NH+    +  S     =>   HS+   +     N     UMIST  */

			c[ipATS][ipNHP] -= NHP_S_HSP_N_1;
			c[ipNHP][ipNHP] -= NHP_S_HSP_N_2;
			bvec[ipNHP] -= bvec_NHP_S_HSP_N;
			
			c[ipATS][ipHSP] += NHP_S_HSP_N_1;
			c[ipNHP][ipHSP] += NHP_S_HSP_N_2;
			bvec[ipHSP] += bvec_NHP_S_HSP_N;
			
		/*  >>refer   molecule   NH+    +  S     =>   NS+   +     H     UMIST  */

			c[ipATS][ipNHP] -= NHP_S_NSP_H_1;
			c[ipNHP][ipNHP] -= NHP_S_NSP_H_2;
			bvec[ipNHP] -= bvec_NHP_S_NSP_H;
			
			c[ipATS][ipNSP] += NHP_S_NSP_H_1;
			c[ipNHP][ipNSP] += NHP_S_NSP_H_2;
			bvec[ipNSP] += bvec_NHP_S_NSP_H;

		/*  >>refer   molecule   NH     +  S+    =>   NS+   +     H     UMIST  */

			c[ipSP][ipNH] -= NH_SP_NSP_H_1;
			c[ipNH][ipNH] -= NH_SP_NSP_H_2;
			bvec[ipNH] -= bvec_NH_SP_NSP_H;
			
			c[ipSP][ipSP] -= NH_SP_NSP_H_1;
			c[ipNH][ipSP] -= NH_SP_NSP_H_2;
			bvec[ipSP] -= bvec_NH_SP_NSP_H;
			
			c[ipSP][ipNSP] += NH_SP_NSP_H_1;
			c[ipNH][ipNSP] += NH_SP_NSP_H_2;
			bvec[ipNSP] += bvec_NH_SP_NSP_H;

		/*  >>refer   molecule   CH3+   +  NH3   =>   NH4+  +     CH2   UMIST  */

			c[ipNH3][ipCH3P] -= CH3P_NH3_NH4P_CH2_1;
			c[ipCH3P][ipCH3P] -= CH3P_NH3_NH4P_CH2_2;
			bvec[ipCH3P] -= bvec_CH3P_NH3_NH4P_CH2;
			
			c[ipNH3][ipNH3] -= CH3P_NH3_NH4P_CH2_1;
			c[ipCH3P][ipNH3] -= CH3P_NH3_NH4P_CH2_2;
			bvec[ipNH3] -= bvec_CH3P_NH3_NH4P_CH2;
			
			c[ipNH3][ipNH4P] += CH3P_NH3_NH4P_CH2_1;
			c[ipCH3P][ipNH4P] += CH3P_NH3_NH4P_CH2_2;
			bvec[ipNH4P] += bvec_CH3P_NH3_NH4P_CH2;
			
			c[ipNH3][ipCH2] += CH3P_NH3_NH4P_CH2_1;
			c[ipCH3P][ipCH2] += CH3P_NH3_NH4P_CH2_2;
			bvec[ipCH2] += bvec_CH3P_NH3_NH4P_CH2;

		/*  >>refer   molecule   CH3+   +  S     =>   HCS+  +     H2    UMIST  */

			c[ipATS][ipCH3P] -= CH3P_S_HCSP_H2_1;
			c[ipCH3P][ipCH3P] -= CH3P_S_HCSP_H2_2;
			bvec[ipCH3P] -= bvec_CH3P_S_HCSP_H2;
			
			c[ipATS][ipHCSP] += CH3P_S_HCSP_H2_1;
			c[ipCH3P][ipHCSP] += CH3P_S_HCSP_H2_2;
			bvec[ipHCSP] += bvec_CH3P_S_HCSP_H2;

		/*  >>refer   molecule   O      +  NH2+  =>   HNO+  +     H     UMIST  */

			c[ipNH2P][ipNH2P] -= O_NH2P_HNOP_H_1;
			c[ipATO][ipNH2P] -= O_NH2P_HNOP_H_2;
			bvec[ipNH2P] -= bvec_O_NH2P_HNOP_H;
			
			c[ipNH2P][ipHNOP] += O_NH2P_HNOP_H_1;
			c[ipATO][ipHNOP] += O_NH2P_HNOP_H_2;
			bvec[ipHNOP] += bvec_O_NH2P_HNOP_H;

		/*  >>refer   molecule   O      +  NH3+  =>   HNO+  +     H2    UMIST  */

			c[ipNH3P][ipNH3P] -= O_NH3P_HNOP_H2_1;
			c[ipATO][ipNH3P] -= O_NH3P_HNOP_H2_2;
			bvec[ipNH3P] -= bvec_O_NH3P_HNOP_H2;
			
			c[ipNH3P][ipHNOP] += O_NH3P_HNOP_H2_1;
			c[ipATO][ipHNOP] += O_NH3P_HNOP_H2_2;
			bvec[ipHNOP] += bvec_O_NH3P_HNOP_H2;

		/*  >>refer   molecule   O+     +  CN    =>   NO+   +     C     UMIST  */

			c[ipCN][ipOP] -= OP_CN_NOP_C_1;
			c[ipOP][ipOP] -= OP_CN_NOP_C_2;
			bvec[ipOP] -= bvec_OP_CN_NOP_C;
			
			c[ipCN][ipCN] -= OP_CN_NOP_C_1;
			c[ipOP][ipCN] -= OP_CN_NOP_C_2;
			bvec[ipCN] -= bvec_OP_CN_NOP_C;
			
			c[ipCN][ipNOP] += OP_CN_NOP_C_1;
			c[ipOP][ipNOP] += OP_CN_NOP_C_2;
			bvec[ipNOP] += bvec_OP_CN_NOP_C;

		/*  >>refer   molecule   O+     +  HCN   =>   CO+   +     NH    UMIST  */

			c[ipHCN][ipOP] -= OP_HCN_COP_NH_1;
			c[ipOP][ipOP] -= OP_HCN_COP_NH_2;
			bvec[ipOP] -= bvec_OP_HCN_COP_NH;
			
			c[ipHCN][ipHCN] -= OP_HCN_COP_NH_1;
			c[ipOP][ipHCN] -= OP_HCN_COP_NH_2;
			bvec[ipHCN] -= bvec_OP_HCN_COP_NH;
			
			c[ipHCN][ipCOP] += OP_HCN_COP_NH_1;
			c[ipOP][ipCOP] += OP_HCN_COP_NH_2;
			bvec[ipCOP] += bvec_OP_HCN_COP_NH;
			
			c[ipHCN][ipNH] += OP_HCN_COP_NH_1;
			c[ipOP][ipNH] += OP_HCN_COP_NH_2;
			bvec[ipNH] += bvec_OP_HCN_COP_NH;

		/*  >>refer   molecule   O+     +  HCN   =>   NO+   +     CH    UMIST  */

			c[ipHCN][ipOP] -= OP_HCN_NOP_CH_1;
			c[ipOP][ipOP] -= OP_HCN_NOP_CH_2;
			bvec[ipOP] -= bvec_OP_HCN_NOP_CH;
			
			c[ipHCN][ipHCN] -= OP_HCN_NOP_CH_1;
			c[ipOP][ipHCN] -= OP_HCN_NOP_CH_2;
			bvec[ipHCN] -= bvec_OP_HCN_NOP_CH;
			
			c[ipHCN][ipNOP] += OP_HCN_NOP_CH_1;
			c[ipOP][ipNOP] += OP_HCN_NOP_CH_2;
			bvec[ipNOP] += bvec_OP_HCN_NOP_CH;
			
			c[ipHCN][ipCH] += OP_HCN_NOP_CH_1;
			c[ipOP][ipCH] += OP_HCN_NOP_CH_2;
			bvec[ipCH] += bvec_OP_HCN_NOP_CH;

		/*  >>refer   molecule   O+     +  HCN   =>   HCO+  +     N     UMIST  */

			c[ipHCN][ipOP] -= OP_HCN_HCOP_N_1;
			c[ipOP][ipOP] -= OP_HCN_HCOP_N_2;
			bvec[ipOP] -= bvec_OP_HCN_HCOP_N;
			
			c[ipHCN][ipHCN] -= OP_HCN_HCOP_N_1;
			c[ipOP][ipHCN] -= OP_HCN_HCOP_N_2;
			bvec[ipHCN] -= bvec_OP_HCN_HCOP_N;
			
			c[ipHCN][ipHCOP] += OP_HCN_HCOP_N_1;
			c[ipOP][ipHCOP] += OP_HCN_HCOP_N_2;
			bvec[ipHCOP] += bvec_OP_HCN_HCOP_N;

		/*  >>refer   molecule   O+     +  N2    =>   NO+   +     N     UMIST  */

			c[ipN2][ipOP] -= OP_N2_NOP_N_1;
			c[ipOP][ipOP] -= OP_N2_NOP_N_2;
			bvec[ipOP] -= bvec_OP_N2_NOP_N;
			
			c[ipN2][ipN2] -= OP_N2_NOP_N_1;
			c[ipOP][ipN2] -= OP_N2_NOP_N_2;
			bvec[ipN2] -= bvec_OP_N2_NOP_N;
			
			c[ipN2][ipNOP] += OP_N2_NOP_N_1;
			c[ipOP][ipNOP] += OP_N2_NOP_N_2;
			bvec[ipNOP] += bvec_OP_N2_NOP_N;
			
		/*  >>refer   molecule   O      +  N2+   =>   NO+   +     N     UMIST  */

			c[ipN2P][ipN2P] -= O_N2P_NOP_N_1;
			c[ipATO][ipN2P] -= O_N2P_NOP_N_2;
			bvec[ipN2P] -= bvec_O_N2P_NOP_N;
			
			c[ipN2P][ipNOP] += O_N2P_NOP_N_1;
			c[ipATO][ipNOP] += O_N2P_NOP_N_2;
			bvec[ipNOP] += bvec_O_N2P_NOP_N;

		/*  >>refer   molecule   O      +  HNO+  =>   NO2+  +     H     UMIST  */

			c[ipHNOP][ipHNOP] -= O_HNOP_NO2P_H_1;
			c[ipATO][ipHNOP] -= O_HNOP_NO2P_H_2;
			bvec[ipHNOP] -= bvec_O_HNOP_NO2P_H;
			
			c[ipHNOP][ipNO2P] += O_HNOP_NO2P_H_1;
			c[ipATO][ipNO2P] += O_HNOP_NO2P_H_2;
			bvec[ipNO2P] += bvec_O_HNOP_NO2P_H;

		/*  >>refer   molecule   O      +  HS+   =>   S+    +     OH    UMIST  */

			c[ipHSP][ipHSP] -= O_HSP_SP_OH_1;
			c[ipATO][ipHSP] -= O_HSP_SP_OH_2;
			bvec[ipHSP] -= bvec_O_HSP_SP_OH;
			
			c[ipHSP][ipSP] += O_HSP_SP_OH_1;
			c[ipATO][ipSP] += O_HSP_SP_OH_2;
			bvec[ipSP] += bvec_O_HSP_SP_OH;
			
			c[ipHSP][ipOH] += O_HSP_SP_OH_1;
			c[ipATO][ipOH] += O_HSP_SP_OH_2;
			bvec[ipOH] += bvec_O_HSP_SP_OH;

		/*  >>refer   molecule   O      +  HS+   =>   SO+   +     H     UMIST  */

			c[ipHSP][ipHSP] -= O_HSP_SOP_H_1;
			c[ipATO][ipHSP] -= O_HSP_SOP_H_2;
			bvec[ipHSP] -= bvec_O_HSP_SOP_H;
			
			c[ipHSP][ipSOP] += O_HSP_SOP_H_1;
			c[ipATO][ipSOP] += O_HSP_SOP_H_2;
			bvec[ipSOP] += bvec_O_HSP_SOP_H;

		/*  >>refer   molecule   O      +  SIN+  =>   SIO+  +     N     UMIST  */

			c[ipSINP][ipSINP] -= O_SINP_SIOP_N_1;
			c[ipATO][ipSINP] -= O_SINP_SIOP_N_2;
			bvec[ipSINP] -= bvec_O_SINP_SIOP_N;
			
			c[ipSINP][ipSIOP] += O_SINP_SIOP_N_1;
			c[ipATO][ipSIOP] += O_SINP_SIOP_N_2;
			bvec[ipSIOP] += bvec_O_SINP_SIOP_N;

		/*  >>refer   molecule   O+     +  N2O   =>   NO+   +     NO    UMIST  */

			c[ipN2O][ipOP] -= OP_N2O_NOP_NO_1;
			c[ipOP][ipOP] -= OP_N2O_NOP_NO_2;
			bvec[ipOP] -= bvec_OP_N2O_NOP_NO;
			
			c[ipN2O][ipN2O] -= OP_N2O_NOP_NO_1;
			c[ipOP][ipN2O] -= OP_N2O_NOP_NO_2;
			bvec[ipN2O] -= bvec_OP_N2O_NOP_NO;
			
			c[ipN2O][ipNOP] += OP_N2O_NOP_NO_1;
			c[ipOP][ipNOP] += OP_N2O_NOP_NO_2;
			bvec[ipNOP] += bvec_OP_N2O_NOP_NO;
			
			c[ipN2O][ipNO] += OP_N2O_NOP_NO_1;
			c[ipOP][ipNO] += OP_N2O_NOP_NO_2;
			bvec[ipNO] += bvec_OP_N2O_NOP_NO;

		/*  >>refer   molecule   O      +  CS+   =>   S     +     CO+   UMIST  */

			c[ipCSP][ipCSP] -= O_CSP_S_COP_1;
			c[ipATO][ipCSP] -= O_CSP_S_COP_2;
			bvec[ipCSP] -= bvec_O_CSP_S_COP;
			
			c[ipCSP][ipCOP] += O_CSP_S_COP_1;
			c[ipATO][ipCOP] += O_CSP_S_COP_2;
			bvec[ipCOP] += bvec_O_CSP_S_COP;

		/*  >>refer   molecule   O      +  HCS+  =>   S     +     HCO+  UMIST  */

			c[ipHCSP][ipHCSP] -= O_HCSP_S_HCOP_1;
			c[ipATO][ipHCSP] -= O_HCSP_S_HCOP_2;
			bvec[ipHCSP] -= bvec_O_HCSP_S_HCOP;
			
			c[ipHCSP][ipHCOP] += O_HCSP_S_HCOP_1;
			c[ipATO][ipHCOP] += O_HCSP_S_HCOP_2;
			bvec[ipHCOP] += bvec_O_HCSP_S_HCOP;

		/*  >>refer   molecule   O      +  HCS+  =>   OCS+  +     H     UMIST  */

			c[ipHCSP][ipHCSP] -= O_HCSP_OCSP_H_1;
			c[ipATO][ipHCSP] -= O_HCSP_OCSP_H_2;
			bvec[ipHCSP] -= bvec_O_HCSP_OCSP_H;
			
			c[ipHCSP][ipOCSP] += O_HCSP_OCSP_H_1;
			c[ipATO][ipOCSP] += O_HCSP_OCSP_H_2;
			bvec[ipOCSP] += bvec_O_HCSP_OCSP_H;

		/*  >>refer   molecule   O+     +  NO2   =>   O2    +     NO+   UMIST  */

			c[ipNO2][ipOP] -= OP_NO2_O2_NOP_1;
			c[ipOP][ipOP] -= OP_NO2_O2_NOP_2;
			bvec[ipOP] -= bvec_OP_NO2_O2_NOP;
			
			c[ipNO2][ipNO2] -= OP_NO2_O2_NOP_1;
			c[ipOP][ipNO2] -= OP_NO2_O2_NOP_2;
			bvec[ipNO2] -= bvec_OP_NO2_O2_NOP;
			
			c[ipNO2][ipO2] += OP_NO2_O2_NOP_1;
			c[ipOP][ipO2] += OP_NO2_O2_NOP_2;
			bvec[ipO2] += bvec_OP_NO2_O2_NOP;
			
			c[ipNO2][ipNOP] += OP_NO2_O2_NOP_1;
			c[ipOP][ipNOP] += OP_NO2_O2_NOP_2;
			bvec[ipNOP] += bvec_OP_NO2_O2_NOP;

		/*  >>refer   molecule   O      +  NS+   =>   S     +     NO+   UMIST  */

			c[ipNSP][ipNSP] -= O_NSP_S_NOP_1;
			c[ipATO][ipNSP] -= O_NSP_S_NOP_2;
			bvec[ipNSP] -= bvec_O_NSP_S_NOP;
			
			c[ipNSP][ipNOP] += O_NSP_S_NOP_1;
			c[ipATO][ipNOP] += O_NSP_S_NOP_2;
			bvec[ipNOP] += bvec_O_NSP_S_NOP;

		/*  >>refer   molecule   NH2+   +  NH2   =>   NH3+  +     NH    UMIST  */

			c[ipNH2][ipNH2P] -= NH2P_NH2_NH3P_NH_1;
			c[ipNH2P][ipNH2P] -= NH2P_NH2_NH3P_NH_2;
			bvec[ipNH2P] -= bvec_NH2P_NH2_NH3P_NH;
			
			c[ipNH2][ipNH2] -= NH2P_NH2_NH3P_NH_1;
			c[ipNH2P][ipNH2] -= NH2P_NH2_NH3P_NH_2;
			bvec[ipNH2] -= bvec_NH2P_NH2_NH3P_NH;
			
			c[ipNH2][ipNH3P] += NH2P_NH2_NH3P_NH_1;
			c[ipNH2P][ipNH3P] += NH2P_NH2_NH3P_NH_2;
			bvec[ipNH3P] += bvec_NH2P_NH2_NH3P_NH;
			
			c[ipNH2][ipNH] += NH2P_NH2_NH3P_NH_1;
			c[ipNH2P][ipNH] += NH2P_NH2_NH3P_NH_2;
			bvec[ipNH] += bvec_NH2P_NH2_NH3P_NH;

		/*  >>refer   molecule   NH2    +  OH+   =>   NH3+  +     O     UMIST  */

			c[ipOHP][ipNH2] -= NH2_OHP_NH3P_O_1;
			c[ipNH2][ipNH2] -= NH2_OHP_NH3P_O_2;
			bvec[ipNH2] -= bvec_NH2_OHP_NH3P_O;
			
			c[ipOHP][ipOHP] -= NH2_OHP_NH3P_O_1;
			c[ipNH2][ipOHP] -= NH2_OHP_NH3P_O_2;
			bvec[ipOHP] -= bvec_NH2_OHP_NH3P_O;
			
			c[ipOHP][ipNH3P] += NH2_OHP_NH3P_O_1;
			c[ipNH2][ipNH3P] += NH2_OHP_NH3P_O_2;
			bvec[ipNH3P] += bvec_NH2_OHP_NH3P_O;

		/*  >>refer   molecule   NH2+   +  OH    =>   H2O+  +     NH    UMIST  */

			c[ipOH][ipNH2P] -= NH2P_OH_H2OP_NH_1;
			c[ipNH2P][ipNH2P] -= NH2P_OH_H2OP_NH_2;
			bvec[ipNH2P] -= bvec_NH2P_OH_H2OP_NH;
			
			c[ipOH][ipOH] -= NH2P_OH_H2OP_NH_1;
			c[ipNH2P][ipOH] -= NH2P_OH_H2OP_NH_2;
			bvec[ipOH] -= bvec_NH2P_OH_H2OP_NH;
						
			c[ipOH][ipH2OP] += NH2P_OH_H2OP_NH_1;
			c[ipNH2P][ipH2OP] += NH2P_OH_H2OP_NH_2;
			bvec[ipH2OP] += bvec_NH2P_OH_H2OP_NH;
			
			c[ipOH][ipNH] += NH2P_OH_H2OP_NH_1;
			c[ipNH2P][ipNH] += NH2P_OH_H2OP_NH_2;
			bvec[ipNH] += bvec_NH2P_OH_H2OP_NH;

		/*  >>refer   molecule   NH2+   +  NH3   =>   NH4+  +     NH    UMIST  */

			c[ipNH3][ipNH2P] -= NH2P_NH3_NH4P_NH_1;
			c[ipNH2P][ipNH2P] -= NH2P_NH3_NH4P_NH_2;
			bvec[ipNH2P] -= bvec_NH2P_NH3_NH4P_NH;
			
			c[ipNH3][ipNH3] -= NH2P_NH3_NH4P_NH_1;
			c[ipNH2P][ipNH3] -= NH2P_NH3_NH4P_NH_2;
			bvec[ipNH3] -= bvec_NH2P_NH3_NH4P_NH;
			
			c[ipNH3][ipNH4P] += NH2P_NH3_NH4P_NH_1;
			c[ipNH2P][ipNH4P] += NH2P_NH3_NH4P_NH_2;
			bvec[ipNH4P] += bvec_NH2P_NH3_NH4P_NH;
			
			c[ipNH3][ipNH] += NH2P_NH3_NH4P_NH_1;
			c[ipNH2P][ipNH] += NH2P_NH3_NH4P_NH_2;
			bvec[ipNH] += bvec_NH2P_NH3_NH4P_NH;

		/*  >>refer   molecule   NH2    +  NH3+  =>   NH4+  +     NH    UMIST  */

			c[ipNH3P][ipNH2] -= NH2_NH3P_NH4P_NH_1;
			c[ipNH2][ipNH2] -= NH2_NH3P_NH4P_NH_2;
			bvec[ipNH2] -= bvec_NH2_NH3P_NH4P_NH;
			
			c[ipNH3P][ipNH3P] -= NH2_NH3P_NH4P_NH_1;
			c[ipNH2][ipNH3P] -= NH2_NH3P_NH4P_NH_2;
			bvec[ipNH3P] -= bvec_NH2_NH3P_NH4P_NH;
			
			c[ipNH3P][ipNH4P] += NH2_NH3P_NH4P_NH_1;
			c[ipNH2][ipNH4P] += NH2_NH3P_NH4P_NH_2;
			bvec[ipNH4P] += bvec_NH2_NH3P_NH4P_NH;
			
			c[ipNH3P][ipNH] += NH2_NH3P_NH4P_NH_1;
			c[ipNH2][ipNH] += NH2_NH3P_NH4P_NH_2;
			bvec[ipNH] += bvec_NH2_NH3P_NH4P_NH;

		/*  >>refer   molecule   NH2    +  CH5+  =>   NH3+  +     CH4   UMIST  */

			c[ipCH5P][ipNH2] -= NH2_CH5P_NH3P_CH4_1;
			c[ipNH2][ipNH2] -= NH2_CH5P_NH3P_CH4_2;
			bvec[ipNH2] -= bvec_NH2_CH5P_NH3P_CH4;
			
			c[ipCH5P][ipCH5P] -= NH2_CH5P_NH3P_CH4_1;
			c[ipNH2][ipCH5P] -= NH2_CH5P_NH3P_CH4_2;
			bvec[ipCH5P] -= bvec_NH2_CH5P_NH3P_CH4;
			
			c[ipCH5P][ipNH3P] += NH2_CH5P_NH3P_CH4_1;
			c[ipNH2][ipNH3P] += NH2_CH5P_NH3P_CH4_2;
			bvec[ipNH3P] += bvec_NH2_CH5P_NH3P_CH4;
			
			c[ipCH5P][ipCH4] += NH2_CH5P_NH3P_CH4_1;
			c[ipNH2][ipCH4] += NH2_CH5P_NH3P_CH4_2;
			bvec[ipCH4] += bvec_NH2_CH5P_NH3P_CH4;

		/*  >>refer   molecule   NH2+   +  H2O   =>   NH3+  +     OH    UMIST  */

			c[ipH2O][ipNH2P] -= NH2P_H2O_NH3P_OH_1;
			c[ipNH2P][ipNH2P] -= NH2P_H2O_NH3P_OH_2;
			bvec[ipNH2P] -= bvec_NH2P_H2O_NH3P_OH;
			
			c[ipH2O][ipH2O] -= NH2P_H2O_NH3P_OH_1;
			c[ipNH2P][ipH2O] -= NH2P_H2O_NH3P_OH_2;
			bvec[ipH2O] -= bvec_NH2P_H2O_NH3P_OH;
			
			c[ipH2O][ipNH3P] += NH2P_H2O_NH3P_OH_1;
			c[ipNH2P][ipNH3P] += NH2P_H2O_NH3P_OH_2;
			bvec[ipNH3P] += bvec_NH2P_H2O_NH3P_OH;
			
			c[ipH2O][ipOH] += NH2P_H2O_NH3P_OH_1;
			c[ipNH2P][ipOH] += NH2P_H2O_NH3P_OH_2;
			bvec[ipOH] += bvec_NH2P_H2O_NH3P_OH;

		/*  >>refer   molecule   NH2+   +  H2O   =>   H3O+  +     NH    UMIST  */

			c[ipH2O][ipNH2P] -= NH2P_H2O_H3OP_NH_1;
			c[ipNH2P][ipNH2P] -= NH2P_H2O_H3OP_NH_2;
			bvec[ipNH2P] -= bvec_NH2P_H2O_H3OP_NH;
			
			c[ipH2O][ipH2O] -= NH2P_H2O_H3OP_NH_1;
			c[ipNH2P][ipH2O] -= NH2P_H2O_H3OP_NH_2;
			bvec[ipH2O] -= bvec_NH2P_H2O_H3OP_NH;
			
			c[ipH2O][ipH3OP] += NH2P_H2O_H3OP_NH_1;
			c[ipNH2P][ipH3OP] += NH2P_H2O_H3OP_NH_2;
			bvec[ipH3OP] += bvec_NH2P_H2O_H3OP_NH;
			
			c[ipH2O][ipNH] += NH2P_H2O_H3OP_NH_1;
			c[ipNH2P][ipNH] += NH2P_H2O_H3OP_NH_2;
			bvec[ipNH] += bvec_NH2P_H2O_H3OP_NH;

		/*  >>refer   molecule   NH2    +  H2O+  =>   NH3+  +     OH    UMIST  */

			c[ipH2OP][ipNH2] -= NH2_H2OP_NH3P_OH_1;
			c[ipNH2][ipNH2] -= NH2_H2OP_NH3P_OH_2;
			bvec[ipNH2] -= bvec_NH2_H2OP_NH3P_OH;
			
			c[ipH2OP][ipH2OP] -= NH2_H2OP_NH3P_OH_1;
			c[ipNH2][ipH2OP] -= NH2_H2OP_NH3P_OH_2;
			bvec[ipH2OP] -= bvec_NH2_H2OP_NH3P_OH;
			
			c[ipH2OP][ipNH3P] += NH2_H2OP_NH3P_OH_1;
			c[ipNH2][ipNH3P] += NH2_H2OP_NH3P_OH_2;
			bvec[ipNH3P] += bvec_NH2_H2OP_NH3P_OH;
			
			c[ipH2OP][ipOH] += NH2_H2OP_NH3P_OH_1;
			c[ipNH2][ipOH] += NH2_H2OP_NH3P_OH_2;
			bvec[ipOH] += bvec_NH2_H2OP_NH3P_OH;

		/*  >>refer   molecule   NH2+   +  H2O   =>   NH4+  +     O     UMIST  */

			c[ipH2O][ipNH2P] -= NH2P_H2O_NH4P_O_1;
			c[ipNH2P][ipNH2P] -= NH2P_H2O_NH4P_O_2;
			bvec[ipNH2P] -= bvec_NH2P_H2O_NH4P_O;
			
			c[ipH2O][ipH2O] -= NH2P_H2O_NH4P_O_1;
			c[ipNH2P][ipH2O] -= NH2P_H2O_NH4P_O_2;
			bvec[ipH2O] -= bvec_NH2P_H2O_NH4P_O;
			
			c[ipH2O][ipNH4P] += NH2P_H2O_NH4P_O_1;
			c[ipNH2P][ipNH4P] += NH2P_H2O_NH4P_O_2;
			bvec[ipNH4P] += bvec_NH2P_H2O_NH4P_O;
			
		/*  >>refer   molecule   NH2    +  H3O+  =>   H2O   +     NH3+  UMIST  */

			c[ipH3OP][ipNH2] -= NH2_H3OP_H2O_NH3P_1;
			c[ipNH2][ipNH2] -= NH2_H3OP_H2O_NH3P_2;
			bvec[ipNH2] -= bvec_NH2_H3OP_H2O_NH3P;
			
			c[ipH3OP][ipH3OP] -= NH2_H3OP_H2O_NH3P_1;
			c[ipNH2][ipH3OP] -= NH2_H3OP_H2O_NH3P_2;
			bvec[ipH3OP] -= bvec_NH2_H3OP_H2O_NH3P;
			
			c[ipH3OP][ipH2O] += NH2_H3OP_H2O_NH3P_1;
			c[ipNH2][ipH2O] += NH2_H3OP_H2O_NH3P_2;
			bvec[ipH2O] += bvec_NH2_H3OP_H2O_NH3P;
			
			c[ipH3OP][ipNH3P] += NH2_H3OP_H2O_NH3P_1;
			c[ipNH2][ipNH3P] += NH2_H3OP_H2O_NH3P_2;
			bvec[ipNH3P] += bvec_NH2_H3OP_H2O_NH3P;

		/*  >>refer   molecule   NH2    +  HCN+  =>   CN    +     NH3+  UMIST  */

			c[ipHCNP][ipNH2] -= NH2_HCNP_CN_NH3P_1;
			c[ipNH2][ipNH2] -= NH2_HCNP_CN_NH3P_2;
			bvec[ipNH2] -= bvec_NH2_HCNP_CN_NH3P;
			
			c[ipHCNP][ipHCNP] -= NH2_HCNP_CN_NH3P_1;
			c[ipNH2][ipHCNP] -= NH2_HCNP_CN_NH3P_2;
			bvec[ipHCNP] -= bvec_NH2_HCNP_CN_NH3P;
			
			c[ipHCNP][ipCN] += NH2_HCNP_CN_NH3P_1;
			c[ipNH2][ipCN] += NH2_HCNP_CN_NH3P_2;
			bvec[ipCN] += bvec_NH2_HCNP_CN_NH3P;
			
			c[ipHCNP][ipNH3P] += NH2_HCNP_CN_NH3P_1;
			c[ipNH2][ipNH3P] += NH2_HCNP_CN_NH3P_2;
			bvec[ipNH3P] += bvec_NH2_HCNP_CN_NH3P;

		/*  >>refer   molecule   NH2    +  CO+   =>   HCO+  +     NH    UMIST  */

			c[ipCOP][ipNH2] -= NH2_COP_HCOP_NH_1;
			c[ipNH2][ipNH2] -= NH2_COP_HCOP_NH_2;
			bvec[ipNH2] -= bvec_NH2_COP_HCOP_NH;
			
			c[ipCOP][ipCOP] -= NH2_COP_HCOP_NH_1;
			c[ipNH2][ipCOP] -= NH2_COP_HCOP_NH_2;
			bvec[ipCOP] -= bvec_NH2_COP_HCOP_NH;
			
			c[ipCOP][ipHCOP] += NH2_COP_HCOP_NH_1;
			c[ipNH2][ipHCOP] += NH2_COP_HCOP_NH_2;
			bvec[ipHCOP] += bvec_NH2_COP_HCOP_NH;
			
			c[ipCOP][ipNH] += NH2_COP_HCOP_NH_1;
			c[ipNH2][ipNH] += NH2_COP_HCOP_NH_2;
			bvec[ipNH] += bvec_NH2_COP_HCOP_NH;

		/*  >>refer   molecule   NH2    +  HCO+  =>   CO    +     NH3+  UMIST  */

			c[ipHCOP][ipNH2] -= NH2_HCOP_CO_NH3P_1;
			c[ipNH2][ipNH2] -= NH2_HCOP_CO_NH3P_2;
			bvec[ipNH2] -= bvec_NH2_HCOP_CO_NH3P;
			
			c[ipHCOP][ipHCOP] -= NH2_HCOP_CO_NH3P_1;
			c[ipNH2][ipHCOP] -= NH2_HCOP_CO_NH3P_2;
			bvec[ipHCOP] -= bvec_NH2_HCOP_CO_NH3P;
			
			c[ipHCOP][ipCO] += NH2_HCOP_CO_NH3P_1;
			c[ipNH2][ipCO] += NH2_HCOP_CO_NH3P_2;
			bvec[ipCO] += bvec_NH2_HCOP_CO_NH3P;
			
			c[ipHCOP][ipNH3P] += NH2_HCOP_CO_NH3P_1;
			c[ipNH2][ipNH3P] += NH2_HCOP_CO_NH3P_2;
			bvec[ipNH3P] += bvec_NH2_HCOP_CO_NH3P;

		/*  >>refer   molecule   NH2    +  HNO+  =>   NO    +     NH3+  UMIST  */

			c[ipHNOP][ipNH2] -= NH2_HNOP_NO_NH3P_1;
			c[ipNH2][ipNH2] -= NH2_HNOP_NO_NH3P_2;
			bvec[ipNH2] -= bvec_NH2_HNOP_NO_NH3P;
			
			c[ipHNOP][ipHNOP] -= NH2_HNOP_NO_NH3P_1;
			c[ipNH2][ipHNOP] -= NH2_HNOP_NO_NH3P_2;
			bvec[ipHNOP] -= bvec_NH2_HNOP_NO_NH3P;
			
			c[ipHNOP][ipNO] += NH2_HNOP_NO_NH3P_1;
			c[ipNH2][ipNO] += NH2_HNOP_NO_NH3P_2;
			bvec[ipNO] += bvec_NH2_HNOP_NO_NH3P;
			
			c[ipHNOP][ipNH3P] += NH2_HNOP_NO_NH3P_1;
			c[ipNH2][ipNH3P] += NH2_HNOP_NO_NH3P_2;
			bvec[ipNH3P] += bvec_NH2_HNOP_NO_NH3P;

		/*  >>refer   molecule   NH2+   +  O2    =>   HNO+  +     OH    UMIST  */

			c[ipO2][ipNH2P] -= NH2P_O2_HNOP_OH_1;
			c[ipNH2P][ipNH2P] -= NH2P_O2_HNOP_OH_2;
			bvec[ipNH2P] -= bvec_NH2P_O2_HNOP_OH;
			
			c[ipO2][ipO2] -= NH2P_O2_HNOP_OH_1;
			c[ipNH2P][ipO2] -= NH2P_O2_HNOP_OH_2;
			bvec[ipO2] -= bvec_NH2P_O2_HNOP_OH;
			
			c[ipO2][ipHNOP] += NH2P_O2_HNOP_OH_1;
			c[ipNH2P][ipHNOP] += NH2P_O2_HNOP_OH_2;
			bvec[ipHNOP] += bvec_NH2P_O2_HNOP_OH;
			
			c[ipO2][ipOH] += NH2P_O2_HNOP_OH_1;
			c[ipNH2P][ipOH] += NH2P_O2_HNOP_OH_2;
			bvec[ipOH] += bvec_NH2P_O2_HNOP_OH;

		/*  >>refer   molecule   NH2+   +  S     =>   HS+   +     NH    UMIST  */

			c[ipATS][ipNH2P] -= NH2P_S_HSP_NH_1;
			c[ipNH2P][ipNH2P] -= NH2P_S_HSP_NH_2;
			bvec[ipNH2P] -= bvec_NH2P_S_HSP_NH;
			
			c[ipATS][ipHSP] += NH2P_S_HSP_NH_1;
			c[ipNH2P][ipHSP] += NH2P_S_HSP_NH_2;
			bvec[ipHSP] += bvec_NH2P_S_HSP_NH;
			
			c[ipATS][ipNH] += NH2P_S_HSP_NH_1;
			c[ipNH2P][ipNH] += NH2P_S_HSP_NH_2;
			bvec[ipNH] += bvec_NH2P_S_HSP_NH;

		/*  >>refer   molecule   CH4+   +  NH3   =>   NH4+  +     CH3   UMIST  */

			c[ipNH3][ipCH4P] -= CH4P_NH3_NH4P_CH3_1;
			c[ipCH4P][ipCH4P] -= CH4P_NH3_NH4P_CH3_2;
			bvec[ipCH4P] -= bvec_CH4P_NH3_NH4P_CH3;
			
			c[ipNH3][ipNH3] -= CH4P_NH3_NH4P_CH3_1;
			c[ipCH4P][ipNH3] -= CH4P_NH3_NH4P_CH3_2;
			bvec[ipNH3] -= bvec_CH4P_NH3_NH4P_CH3;
			
			c[ipNH3][ipNH4P] += CH4P_NH3_NH4P_CH3_1;
			c[ipCH4P][ipNH4P] += CH4P_NH3_NH4P_CH3_2;
			bvec[ipNH4P] += bvec_CH4P_NH3_NH4P_CH3;
			
			c[ipNH3][ipCH3] += CH4P_NH3_NH4P_CH3_1;
			c[ipCH4P][ipCH3] += CH4P_NH3_NH4P_CH3_2;
			bvec[ipCH3] += bvec_CH4P_NH3_NH4P_CH3;

		/*  >>refer   molecule   CH4    +  NH3+  =>   NH4+  +     CH3   UMIST  */

			c[ipNH3P][ipCH4] -= CH4_NH3P_NH4P_CH3_1;
			c[ipCH4][ipCH4] -= CH4_NH3P_NH4P_CH3_2;
			bvec[ipCH4] -= bvec_CH4_NH3P_NH4P_CH3;
			
			c[ipNH3P][ipNH3P] -= CH4_NH3P_NH4P_CH3_1;
			c[ipCH4][ipNH3P] -= CH4_NH3P_NH4P_CH3_2;
			bvec[ipNH3P] -= bvec_CH4_NH3P_NH4P_CH3;
			
			c[ipNH3P][ipNH4P] += CH4_NH3P_NH4P_CH3_1;
			c[ipCH4][ipNH4P] += CH4_NH3P_NH4P_CH3_2;
			bvec[ipNH4P] += bvec_CH4_NH3P_NH4P_CH3;
			
			c[ipNH3P][ipCH3] += CH4_NH3P_NH4P_CH3_1;
			c[ipCH4][ipCH3] += CH4_NH3P_NH4P_CH3_2;
			bvec[ipCH3] += bvec_CH4_NH3P_NH4P_CH3;

		/*  >>refer   molecule   CH4    +  N2+   =>   N2    +     CH2+ + H2    UMIST  */

			c[ipN2P][ipCH4] -= CH4_N2P_N2_CH2P_H2_1;
			c[ipCH4][ipCH4] -= CH4_N2P_N2_CH2P_H2_2;
			bvec[ipCH4] -= bvec_CH4_N2P_N2_CH2P_H2;
			
			c[ipN2P][ipN2P] -= CH4_N2P_N2_CH2P_H2_1;
			c[ipCH4][ipN2P] -= CH4_N2P_N2_CH2P_H2_2;
			bvec[ipN2P] -= bvec_CH4_N2P_N2_CH2P_H2;
			
			c[ipN2P][ipN2] += CH4_N2P_N2_CH2P_H2_1;
			c[ipCH4][ipN2] += CH4_N2P_N2_CH2P_H2_2;
			bvec[ipN2] += bvec_CH4_N2P_N2_CH2P_H2;
			
			c[ipN2P][ipCH2P] += CH4_N2P_N2_CH2P_H2_1;
			c[ipCH4][ipCH2P] += CH4_N2P_N2_CH2P_H2_2;
			bvec[ipCH2P] += bvec_CH4_N2P_N2_CH2P_H2;

		/*  >>refer   molecule   CH4    +  N2+   =>   N2    +     CH3+ + H     UMIST  */

			c[ipN2P][ipCH4] -= CH4_N2P_N2_CH3P_H_1;
			c[ipCH4][ipCH4] -= CH4_N2P_N2_CH3P_H_2;
			bvec[ipCH4] -= bvec_CH4_N2P_N2_CH3P_H;
			
			c[ipN2P][ipN2P] -= CH4_N2P_N2_CH3P_H_1;
			c[ipCH4][ipN2P] -= CH4_N2P_N2_CH3P_H_2;
			bvec[ipN2P] -= bvec_CH4_N2P_N2_CH3P_H;
			
			c[ipN2P][ipN2] += CH4_N2P_N2_CH3P_H_1;
			c[ipCH4][ipN2] += CH4_N2P_N2_CH3P_H_2;
			bvec[ipN2] += bvec_CH4_N2P_N2_CH3P_H;
			
			c[ipN2P][ipCH3P] += CH4_N2P_N2_CH3P_H_1;
			c[ipCH4][ipCH3P] += CH4_N2P_N2_CH3P_H_2;
			bvec[ipCH3P] += bvec_CH4_N2P_N2_CH3P_H;

		/*  >>refer   molecule   CH4    +  HNO+  =>   NO    +     CH5+  UMIST  */

			c[ipHNOP][ipCH4] -= CH4_HNOP_NO_CH5P_1;
			c[ipCH4][ipCH4] -= CH4_HNOP_NO_CH5P_2;
			bvec[ipCH4] -= bvec_CH4_HNOP_NO_CH5P;
			
			c[ipHNOP][ipHNOP] -= CH4_HNOP_NO_CH5P_1;
			c[ipCH4][ipHNOP] -= CH4_HNOP_NO_CH5P_2;
			bvec[ipHNOP] -= bvec_CH4_HNOP_NO_CH5P;
			
			c[ipHNOP][ipNO] += CH4_HNOP_NO_CH5P_1;
			c[ipCH4][ipNO] += CH4_HNOP_NO_CH5P_2;
			bvec[ipNO] += bvec_CH4_HNOP_NO_CH5P;
			
			c[ipHNOP][ipCH5P] += CH4_HNOP_NO_CH5P_1;
			c[ipCH4][ipCH5P] += CH4_HNOP_NO_CH5P_2;
			bvec[ipCH5P] += bvec_CH4_HNOP_NO_CH5P;

		/*  >>refer   molecule   CH4    +  S+    =>   HCS+  +     H2   + H     UMIST  */

			c[ipSP][ipCH4] -= CH4_SP_HCSP_H2_H_1;
			c[ipCH4][ipCH4] -= CH4_SP_HCSP_H2_H_2;
			bvec[ipCH4] -= bvec_CH4_SP_HCSP_H2_H;
			
			c[ipSP][ipSP] -= CH4_SP_HCSP_H2_H_1;
			c[ipCH4][ipSP] -= CH4_SP_HCSP_H2_H_2;
			bvec[ipSP] -= bvec_CH4_SP_HCSP_H2_H;
			
			c[ipSP][ipHCSP] += CH4_SP_HCSP_H2_H_1;
			c[ipCH4][ipHCSP] += CH4_SP_HCSP_H2_H_2;
			bvec[ipHCSP] += bvec_CH4_SP_HCSP_H2_H;
			
		/*  >>refer   molecule   CH4    +  CS+   =>   HCS+  +     CH3   UMIST  */

			c[ipCSP][ipCH4] -= CH4_CSP_HCSP_CH3_1;
			c[ipCH4][ipCH4] -= CH4_CSP_HCSP_CH3_2;
			bvec[ipCH4] -= bvec_CH4_CSP_HCSP_CH3;
			
			c[ipCSP][ipCSP] -= CH4_CSP_HCSP_CH3_1;
			c[ipCH4][ipCSP] -= CH4_CSP_HCSP_CH3_2;
			bvec[ipCSP] -= bvec_CH4_CSP_HCSP_CH3;
			
			c[ipCSP][ipHCSP] += CH4_CSP_HCSP_CH3_1;
			c[ipCH4][ipHCSP] += CH4_CSP_HCSP_CH3_2;
			bvec[ipHCSP] += bvec_CH4_CSP_HCSP_CH3;
			
			c[ipCSP][ipCH3] += CH4_CSP_HCSP_CH3_1;
			c[ipCH4][ipCH3] += CH4_CSP_HCSP_CH3_2;
			bvec[ipCH3] += bvec_CH4_CSP_HCSP_CH3;

		/*  >>refer   molecule   OH+    +  NH3   =>   NH4+  +     O     UMIST  */

			c[ipNH3][ipOHP] -= OHP_NH3_NH4P_O_1;
			c[ipOHP][ipOHP] -= OHP_NH3_NH4P_O_2;
			bvec[ipOHP] -= bvec_OHP_NH3_NH4P_O;
			
			c[ipNH3][ipNH3] -= OHP_NH3_NH4P_O_1;
			c[ipOHP][ipNH3] -= OHP_NH3_NH4P_O_2;
			bvec[ipNH3] -= bvec_OHP_NH3_NH4P_O;
			
			c[ipNH3][ipNH4P] += OHP_NH3_NH4P_O_1;
			c[ipOHP][ipNH4P] += OHP_NH3_NH4P_O_2;
			bvec[ipNH4P] += bvec_OHP_NH3_NH4P_O;
			
		/*  >>refer   molecule   OH     +  NH3+  =>   NH4+  +     O     UMIST  */

			c[ipNH3P][ipOH] -= OH_NH3P_NH4P_O_1;
			c[ipOH][ipOH] -= OH_NH3P_NH4P_O_2;
			bvec[ipOH] -= bvec_OH_NH3P_NH4P_O;
			
			c[ipNH3P][ipNH3P] -= OH_NH3P_NH4P_O_1;
			c[ipOH][ipNH3P] -= OH_NH3P_NH4P_O_2;
			bvec[ipNH3P] -= bvec_OH_NH3P_NH4P_O;
			
			c[ipNH3P][ipNH4P] += OH_NH3P_NH4P_O_1;
			c[ipOH][ipNH4P] += OH_NH3P_NH4P_O_2;
			bvec[ipNH4P] += bvec_OH_NH3P_NH4P_O;

		/*  >>refer   molecule   OH+    +  CN    =>   HCN+  +     O     UMIST  */

			c[ipCN][ipOHP] -= OHP_CN_HCNP_O_1;
			c[ipOHP][ipOHP] -= OHP_CN_HCNP_O_2;
			bvec[ipOHP] -= bvec_OHP_CN_HCNP_O;
			
			c[ipCN][ipCN] -= OHP_CN_HCNP_O_1;
			c[ipOHP][ipCN] -= OHP_CN_HCNP_O_2;
			bvec[ipCN] -= bvec_OHP_CN_HCNP_O;
			
			c[ipCN][ipHCNP] += OHP_CN_HCNP_O_1;
			c[ipOHP][ipHCNP] += OHP_CN_HCNP_O_2;
			bvec[ipHCNP] += bvec_OHP_CN_HCNP_O;

		/*  >>refer   molecule   OH     +  HCN+  =>   CN    +     H2O+  UMIST  */

			c[ipHCNP][ipOH] -= OH_HCNP_CN_H2OP_1;
			c[ipOH][ipOH] -= OH_HCNP_CN_H2OP_2;
			bvec[ipOH] -= bvec_OH_HCNP_CN_H2OP;
			
			c[ipHCNP][ipHCNP] -= OH_HCNP_CN_H2OP_1;
			c[ipOH][ipHCNP] -= OH_HCNP_CN_H2OP_2;
			bvec[ipHCNP] -= bvec_OH_HCNP_CN_H2OP;
			
			c[ipHCNP][ipCN] += OH_HCNP_CN_H2OP_1;
			c[ipOH][ipCN] += OH_HCNP_CN_H2OP_2;
			bvec[ipCN] += bvec_OH_HCNP_CN_H2OP;
			
			c[ipHCNP][ipH2OP] += OH_HCNP_CN_H2OP_1;
			c[ipOH][ipH2OP] += OH_HCNP_CN_H2OP_2;
			bvec[ipH2OP] += bvec_OH_HCNP_CN_H2OP;

		/*  >>refer   molecule   OH+    +  NO    =>   HNO+  +     O     UMIST  */

			c[ipNO][ipOHP] -= OHP_NO_HNOP_O_1;
			c[ipOHP][ipOHP] -= OHP_NO_HNOP_O_2;
			bvec[ipOHP] -= bvec_OHP_NO_HNOP_O;
			
			c[ipNO][ipNO] -= OHP_NO_HNOP_O_1;
			c[ipOHP][ipNO] -= OHP_NO_HNOP_O_2;
			bvec[ipNO] -= bvec_OHP_NO_HNOP_O;
			
			c[ipNO][ipHNOP] += OHP_NO_HNOP_O_1;
			c[ipOHP][ipHNOP] += OHP_NO_HNOP_O_2;
			bvec[ipHNOP] += bvec_OHP_NO_HNOP_O;
			
		/*  >>refer   molecule   OH     +  HNO+  =>   NO    +     H2O+  UMIST  */

			c[ipHNOP][ipOH] -= OH_HNOP_NO_H2OP_1;
			c[ipOH][ipOH] -= OH_HNOP_NO_H2OP_2;
			bvec[ipOH] -= bvec_OH_HNOP_NO_H2OP;
			
			c[ipHNOP][ipHNOP] -= OH_HNOP_NO_H2OP_1;
			c[ipOH][ipHNOP] -= OH_HNOP_NO_H2OP_2;
			bvec[ipHNOP] -= bvec_OH_HNOP_NO_H2OP;
			
			c[ipHNOP][ipNO] += OH_HNOP_NO_H2OP_1;
			c[ipOH][ipNO] += OH_HNOP_NO_H2OP_2;
			bvec[ipNO] += bvec_OH_HNOP_NO_H2OP;
			
			c[ipHNOP][ipH2OP] += OH_HNOP_NO_H2OP_1;
			c[ipOH][ipH2OP] += OH_HNOP_NO_H2OP_2;
			bvec[ipH2OP] += bvec_OH_HNOP_NO_H2OP;

		/*  >>refer   molecule   OH+    +  S     =>   HS+   +     O     UMIST  */

			c[ipATS][ipOHP] -= OHP_S_HSP_O_1;
			c[ipOHP][ipOHP] -= OHP_S_HSP_O_2;
			bvec[ipOHP] -= bvec_OHP_S_HSP_O;
			
			c[ipATS][ipHSP] += OHP_S_HSP_O_1;
			c[ipOHP][ipHSP] += OHP_S_HSP_O_2;
			bvec[ipHSP] += bvec_OHP_S_HSP_O;

		/*  >>refer   molecule   OH+    +  S     =>   SO+   +     H     UMIST  */

			c[ipATS][ipOHP] -= OHP_S_SOP_H_1;
			c[ipOHP][ipOHP] -= OHP_S_SOP_H_2;
			bvec[ipOHP] -= bvec_OHP_S_SOP_H;
			
			c[ipATS][ipSOP] += OHP_S_SOP_H_1;
			c[ipOHP][ipSOP] += OHP_S_SOP_H_2;
			bvec[ipSOP] += bvec_OHP_S_SOP_H;

		/*  >>refer   molecule   OH     +  S+    =>   SO+   +     H     UMIST  */

			c[ipSP][ipOH] -= OH_SP_SOP_H_1;
			c[ipOH][ipOH] -= OH_SP_SOP_H_2;
			bvec[ipOH] -= bvec_OH_SP_SOP_H;
			
			c[ipSP][ipSP] -= OH_SP_SOP_H_1;
			c[ipOH][ipSP] -= OH_SP_SOP_H_2;
			bvec[ipSP] -= bvec_OH_SP_SOP_H;
			
			c[ipSP][ipSOP] += OH_SP_SOP_H_1;
			c[ipOH][ipSOP] += OH_SP_SOP_H_2;
			bvec[ipSOP] += bvec_OH_SP_SOP_H;
			
		/*  >>refer   molecule   NH3+   +  NH3   =>   NH4+  +     NH2   UMIST  */

			c[ipNH3][ipNH3P] -= NH3P_NH3_NH4P_NH2_1;
			c[ipNH3P][ipNH3P] -= NH3P_NH3_NH4P_NH2_2;
			bvec[ipNH3P] -= bvec_NH3P_NH3_NH4P_NH2;
			
			c[ipNH3][ipNH3] -= NH3P_NH3_NH4P_NH2_1;
			c[ipNH3P][ipNH3] -= NH3P_NH3_NH4P_NH2_2;
			bvec[ipNH3] -= bvec_NH3P_NH3_NH4P_NH2;
			
			c[ipNH3][ipNH4P] += NH3P_NH3_NH4P_NH2_1;
			c[ipNH3P][ipNH4P] += NH3P_NH3_NH4P_NH2_2;
			bvec[ipNH4P] += bvec_NH3P_NH3_NH4P_NH2;
			
			c[ipNH3][ipNH2] += NH3P_NH3_NH4P_NH2_1;
			c[ipNH3P][ipNH2] += NH3P_NH3_NH4P_NH2_2;
			bvec[ipNH2] += bvec_NH3P_NH3_NH4P_NH2;

		/*  >>refer   molecule   NH3    +  CH5+  =>   NH4+  +     CH4   UMIST  */

			c[ipCH5P][ipNH3] -= NH3_CH5P_NH4P_CH4_1;
			c[ipNH3][ipNH3] -= NH3_CH5P_NH4P_CH4_2;
			bvec[ipNH3] -= bvec_NH3_CH5P_NH4P_CH4;
			
			c[ipCH5P][ipCH5P] -= NH3_CH5P_NH4P_CH4_1;
			c[ipNH3][ipCH5P] -= NH3_CH5P_NH4P_CH4_2;
			bvec[ipCH5P] -= bvec_NH3_CH5P_NH4P_CH4;
			
			c[ipCH5P][ipNH4P] += NH3_CH5P_NH4P_CH4_1;
			c[ipNH3][ipNH4P] += NH3_CH5P_NH4P_CH4_2;
			bvec[ipNH4P] += bvec_NH3_CH5P_NH4P_CH4;
			
			c[ipCH5P][ipCH4] += NH3_CH5P_NH4P_CH4_1;
			c[ipNH3][ipCH4] += NH3_CH5P_NH4P_CH4_2;
			bvec[ipCH4] += bvec_NH3_CH5P_NH4P_CH4;

		/*  >>refer   molecule   NH3+   +  H2O   =>   NH4+  +     OH    UMIST  */

			c[ipH2O][ipNH3P] -= NH3P_H2O_NH4P_OH_1;
			c[ipNH3P][ipNH3P] -= NH3P_H2O_NH4P_OH_2;
			bvec[ipNH3P] -= bvec_NH3P_H2O_NH4P_OH;
			
			c[ipH2O][ipH2O] -= NH3P_H2O_NH4P_OH_1;
			c[ipNH3P][ipH2O] -= NH3P_H2O_NH4P_OH_2;
			bvec[ipH2O] -= bvec_NH3P_H2O_NH4P_OH;
			
			c[ipH2O][ipNH4P] += NH3P_H2O_NH4P_OH_1;
			c[ipNH3P][ipNH4P] += NH3P_H2O_NH4P_OH_2;
			bvec[ipNH4P] += bvec_NH3P_H2O_NH4P_OH;
			
			c[ipH2O][ipOH] += NH3P_H2O_NH4P_OH_1;
			c[ipNH3P][ipOH] += NH3P_H2O_NH4P_OH_2;
			bvec[ipOH] += bvec_NH3P_H2O_NH4P_OH;

		/*  >>refer   molecule   NH3    +  H2O+  =>   NH4+  +     OH    UMIST  */

			c[ipH2OP][ipNH3] -= NH3_H2OP_NH4P_OH_1;
			c[ipNH3][ipNH3] -= NH3_H2OP_NH4P_OH_2;
			bvec[ipNH3] -= bvec_NH3_H2OP_NH4P_OH;
			
			c[ipH2OP][ipH2OP] -= NH3_H2OP_NH4P_OH_1;
			c[ipNH3][ipH2OP] -= NH3_H2OP_NH4P_OH_2;
			bvec[ipH2OP] -= bvec_NH3_H2OP_NH4P_OH;
			
			c[ipH2OP][ipNH4P] += NH3_H2OP_NH4P_OH_1;
			c[ipNH3][ipNH4P] += NH3_H2OP_NH4P_OH_2;
			bvec[ipNH4P] += bvec_NH3_H2OP_NH4P_OH;
			
			c[ipH2OP][ipOH] += NH3_H2OP_NH4P_OH_1;
			c[ipNH3][ipOH] += NH3_H2OP_NH4P_OH_2;
			bvec[ipOH] += bvec_NH3_H2OP_NH4P_OH;

		/*  >>refer   molecule   NH3    +  H3O+  =>   NH4+  +     H2O   UMIST  */

			c[ipH3OP][ipNH3] -= NH3_H3OP_NH4P_H2O_1;
			c[ipNH3][ipNH3] -= NH3_H3OP_NH4P_H2O_2;
			bvec[ipNH3] -= bvec_NH3_H3OP_NH4P_H2O;
			
			c[ipH3OP][ipH3OP] -= NH3_H3OP_NH4P_H2O_1;
			c[ipNH3][ipH3OP] -= NH3_H3OP_NH4P_H2O_2;
			bvec[ipH3OP] -= bvec_NH3_H3OP_NH4P_H2O;
			
			c[ipH3OP][ipNH4P] += NH3_H3OP_NH4P_H2O_1;
			c[ipNH3][ipNH4P] += NH3_H3OP_NH4P_H2O_2;
			bvec[ipNH4P] += bvec_NH3_H3OP_NH4P_H2O;
			
			c[ipH3OP][ipH2O] += NH3_H3OP_NH4P_H2O_1;
			c[ipNH3][ipH2O] += NH3_H3OP_NH4P_H2O_2;
			bvec[ipH2O] += bvec_NH3_H3OP_NH4P_H2O;

		/*  >>refer   molecule   NH3    +  CO+   =>   HCO+  +     NH2   UMIST  */

			c[ipCOP][ipNH3] -= NH3_COP_HCOP_NH2_1;
			c[ipNH3][ipNH3] -= NH3_COP_HCOP_NH2_2;
			bvec[ipNH3] -= bvec_NH3_COP_HCOP_NH2;
			
			c[ipCOP][ipCOP] -= NH3_COP_HCOP_NH2_1;
			c[ipNH3][ipCOP] -= NH3_COP_HCOP_NH2_2;
			bvec[ipCOP] -= bvec_NH3_COP_HCOP_NH2;
			
			c[ipCOP][ipHCOP] += NH3_COP_HCOP_NH2_1;
			c[ipNH3][ipHCOP] += NH3_COP_HCOP_NH2_2;
			bvec[ipHCOP] += bvec_NH3_COP_HCOP_NH2;
			
			c[ipCOP][ipNH2] += NH3_COP_HCOP_NH2_1;
			c[ipNH3][ipNH2] += NH3_COP_HCOP_NH2_2;
			bvec[ipNH2] += bvec_NH3_COP_HCOP_NH2;

		/*  >>refer   molecule   NH3    +  HCO+  =>   CO    +     NH4+  UMIST  */

			c[ipHCOP][ipNH3] -= NH3_HCOP_CO_NH4P_1;
			c[ipNH3][ipNH3] -= NH3_HCOP_CO_NH4P_2;
			bvec[ipNH3] -= bvec_NH3_HCOP_CO_NH4P;
			
			c[ipHCOP][ipHCOP] -= NH3_HCOP_CO_NH4P_1;
			c[ipNH3][ipHCOP] -= NH3_HCOP_CO_NH4P_2;
			bvec[ipHCOP] -= bvec_NH3_HCOP_CO_NH4P;
			
			c[ipHCOP][ipCO] += NH3_HCOP_CO_NH4P_1;
			c[ipNH3][ipCO] += NH3_HCOP_CO_NH4P_2;
			bvec[ipCO] += bvec_NH3_HCOP_CO_NH4P;
			
			c[ipHCOP][ipNH4P] += NH3_HCOP_CO_NH4P_1;
			c[ipNH3][ipNH4P] += NH3_HCOP_CO_NH4P_2;
			bvec[ipNH4P] += bvec_NH3_HCOP_CO_NH4P;

		/*  >>refer   molecule   NH3    +  HNO+  =>   NO    +     NH4+  UMIST  */

			c[ipHNOP][ipNH3] -= NH3_HNOP_NO_NH4P_1;
			c[ipNH3][ipNH3] -= NH3_HNOP_NO_NH4P_2;
			bvec[ipNH3] -= bvec_NH3_HNOP_NO_NH4P;
			
			c[ipHNOP][ipHNOP] -= NH3_HNOP_NO_NH4P_1;
			c[ipNH3][ipHNOP] -= NH3_HNOP_NO_NH4P_2;
			bvec[ipHNOP] -= bvec_NH3_HNOP_NO_NH4P;
			
			c[ipHNOP][ipNO] += NH3_HNOP_NO_NH4P_1;
			c[ipNH3][ipNO] += NH3_HNOP_NO_NH4P_2;
			bvec[ipNO] += bvec_NH3_HNOP_NO_NH4P;
			
			c[ipHNOP][ipNH4P] += NH3_HNOP_NO_NH4P_1;
			c[ipNH3][ipNH4P] += NH3_HNOP_NO_NH4P_2;
			bvec[ipNH4P] += bvec_NH3_HNOP_NO_NH4P;

		/*  >>refer   molecule   NH3    +  HS+   =>   S     +     NH4+  UMIST  */

			c[ipHSP][ipNH3] -= NH3_HSP_S_NH4P_1;
			c[ipNH3][ipNH3] -= NH3_HSP_S_NH4P_2;
			bvec[ipNH3] -= bvec_NH3_HSP_S_NH4P;
			
			c[ipHSP][ipHSP] -= NH3_HSP_S_NH4P_1;
			c[ipNH3][ipHSP] -= NH3_HSP_S_NH4P_2;
			bvec[ipHSP] -= bvec_NH3_HSP_S_NH4P;
			
			c[ipHSP][ipNH4P] += NH3_HSP_S_NH4P_1;
			c[ipNH3][ipNH4P] += NH3_HSP_S_NH4P_2;
			bvec[ipNH4P] += bvec_NH3_HSP_S_NH4P;

		/*  >>refer   molecule   NH3    +  HCS+  =>   CS    +     NH4+  UMIST  */

			c[ipHCSP][ipNH3] -= NH3_HCSP_CS_NH4P_1;
			c[ipNH3][ipNH3] -= NH3_HCSP_CS_NH4P_2;
			bvec[ipNH3] -= bvec_NH3_HCSP_CS_NH4P;
			
			c[ipHCSP][ipHCSP] -= NH3_HCSP_CS_NH4P_1;
			c[ipNH3][ipHCSP] -= NH3_HCSP_CS_NH4P_2;
			bvec[ipHCSP] -= bvec_NH3_HCSP_CS_NH4P;
			
			c[ipHCSP][ipCS] += NH3_HCSP_CS_NH4P_1;
			c[ipNH3][ipCS] += NH3_HCSP_CS_NH4P_2;
			bvec[ipCS] += bvec_NH3_HCSP_CS_NH4P;
			
			c[ipHCSP][ipNH4P] += NH3_HCSP_CS_NH4P_1;
			c[ipNH3][ipNH4P] += NH3_HCSP_CS_NH4P_2;
			bvec[ipNH4P] += bvec_NH3_HCSP_CS_NH4P;

		/*  >>refer   molecule   CH5+   +  S     =>   HS+   +     CH4   UMIST  */

			c[ipATS][ipCH5P] -= CH5P_S_HSP_CH4_1;
			c[ipCH5P][ipCH5P] -= CH5P_S_HSP_CH4_2;
			bvec[ipCH5P] -= bvec_CH5P_S_HSP_CH4;
			
			c[ipATS][ipHSP] += CH5P_S_HSP_CH4_1;
			c[ipCH5P][ipHSP] += CH5P_S_HSP_CH4_2;
			bvec[ipHSP] += bvec_CH5P_S_HSP_CH4;
			
			c[ipATS][ipCH4] += CH5P_S_HSP_CH4_1;
			c[ipCH5P][ipCH4] += CH5P_S_HSP_CH4_2;
			bvec[ipCH4] += bvec_CH5P_S_HSP_CH4;

		/*  >>refer   molecule   H2O    +  CN+   =>   HCN+  +     OH    UMIST  */

			c[ipCNP][ipH2O] -= H2O_CNP_HCNP_OH_1;
			c[ipH2O][ipH2O] -= H2O_CNP_HCNP_OH_2;
			bvec[ipH2O] -= bvec_H2O_CNP_HCNP_OH;
			
			c[ipCNP][ipCNP] -= H2O_CNP_HCNP_OH_1;
			c[ipH2O][ipCNP] -= H2O_CNP_HCNP_OH_2;
			bvec[ipCNP] -= bvec_H2O_CNP_HCNP_OH;
			
			c[ipCNP][ipHCNP] += H2O_CNP_HCNP_OH_1;
			c[ipH2O][ipHCNP] += H2O_CNP_HCNP_OH_2;
			bvec[ipHCNP] += bvec_H2O_CNP_HCNP_OH;
			
			c[ipCNP][ipOH] += H2O_CNP_HCNP_OH_1;
			c[ipH2O][ipOH] += H2O_CNP_HCNP_OH_2;
			bvec[ipOH] += bvec_H2O_CNP_HCNP_OH;

		/*  >>refer   molecule   H2O    +  CN+   =>   HCO+  +     NH    UMIST  */

			c[ipCNP][ipH2O] -= H2O_CNP_HCOP_NH_1;
			c[ipH2O][ipH2O] -= H2O_CNP_HCOP_NH_2;
			bvec[ipH2O] -= bvec_H2O_CNP_HCOP_NH;
			
			c[ipCNP][ipCNP] -= H2O_CNP_HCOP_NH_1;
			c[ipH2O][ipCNP] -= H2O_CNP_HCOP_NH_2;
			bvec[ipCNP] -= bvec_H2O_CNP_HCOP_NH;
			
			c[ipCNP][ipHCOP] += H2O_CNP_HCOP_NH_1;
			c[ipH2O][ipHCOP] += H2O_CNP_HCOP_NH_2;
			bvec[ipHCOP] += bvec_H2O_CNP_HCOP_NH;
			
			c[ipCNP][ipNH] += H2O_CNP_HCOP_NH_1;
			c[ipH2O][ipNH] += H2O_CNP_HCOP_NH_2;
			bvec[ipNH] += bvec_H2O_CNP_HCOP_NH;

		/*  >>refer   molecule   H2O    +  HCN+  =>   CN    +     H3O+  UMIST  */

			c[ipHCNP][ipH2O] -= H2O_HCNP_CN_H3OP_1;
			c[ipH2O][ipH2O] -= H2O_HCNP_CN_H3OP_2;
			bvec[ipH2O] -= bvec_H2O_HCNP_CN_H3OP;
			
			c[ipHCNP][ipHCNP] -= H2O_HCNP_CN_H3OP_1;
			c[ipH2O][ipHCNP] -= H2O_HCNP_CN_H3OP_2;
			bvec[ipHCNP] -= bvec_H2O_HCNP_CN_H3OP;
			
			c[ipHCNP][ipCN] += H2O_HCNP_CN_H3OP_1;
			c[ipH2O][ipCN] += H2O_HCNP_CN_H3OP_2;
			bvec[ipCN] += bvec_H2O_HCNP_CN_H3OP;
			
			c[ipHCNP][ipH3OP] += H2O_HCNP_CN_H3OP_1;
			c[ipH2O][ipH3OP] += H2O_HCNP_CN_H3OP_2;
			bvec[ipH3OP] += bvec_H2O_HCNP_CN_H3OP;

		/*  >>refer   molecule   H2O    +  HNO+  =>   NO    +     H3O+  UMIST  */

			c[ipHNOP][ipH2O] -= H2O_HNOP_NO_H3OP_1;
			c[ipH2O][ipH2O] -= H2O_HNOP_NO_H3OP_2;
			bvec[ipH2O] -= bvec_H2O_HNOP_NO_H3OP;
			
			c[ipHNOP][ipHNOP] -= H2O_HNOP_NO_H3OP_1;
			c[ipH2O][ipHNOP] -= H2O_HNOP_NO_H3OP_2;
			bvec[ipHNOP] -= bvec_H2O_HNOP_NO_H3OP;
			
			c[ipHNOP][ipNO] += H2O_HNOP_NO_H3OP_1;
			c[ipH2O][ipNO] += H2O_HNOP_NO_H3OP_2;
			bvec[ipNO] += bvec_H2O_HNOP_NO_H3OP;
			
			c[ipHNOP][ipH3OP] += H2O_HNOP_NO_H3OP_1;
			c[ipH2O][ipH3OP] += H2O_HNOP_NO_H3OP_2;
			bvec[ipH3OP] += bvec_H2O_HNOP_NO_H3OP;

		/*  >>refer   molecule   H2O+   +  S     =>   HS+   +     OH    UMIST  */

			c[ipATS][ipH2OP] -= H2OP_S_HSP_OH_1;
			c[ipH2OP][ipH2OP] -= H2OP_S_HSP_OH_2;
			bvec[ipH2OP] -= bvec_H2OP_S_HSP_OH;
			
			c[ipATS][ipHSP] += H2OP_S_HSP_OH_1;
			c[ipH2OP][ipHSP] += H2OP_S_HSP_OH_2;
			bvec[ipHSP] += bvec_H2OP_S_HSP_OH;
			
			c[ipATS][ipOH] += H2OP_S_HSP_OH_1;
			c[ipH2OP][ipOH] += H2OP_S_HSP_OH_2;
			bvec[ipOH] += bvec_H2OP_S_HSP_OH;

		/*  >>refer   molecule   H2O    +  HS+   =>   S     +     H3O+  UMIST  */

			c[ipHSP][ipH2O] -= H2O_HSP_S_H3OP_1;
			c[ipH2O][ipH2O] -= H2O_HSP_S_H3OP_2;
			bvec[ipH2O] -= bvec_H2O_HSP_S_H3OP;
			
			c[ipHSP][ipHSP] -= H2O_HSP_S_H3OP_1;
			c[ipH2O][ipHSP] -= H2O_HSP_S_H3OP_2;
			bvec[ipHSP] -= bvec_H2O_HSP_S_H3OP;
			
			c[ipHSP][ipH3OP] += H2O_HSP_S_H3OP_1;
			c[ipH2O][ipH3OP] += H2O_HSP_S_H3OP_2;
			bvec[ipH3OP] += bvec_H2O_HSP_S_H3OP;
			
		/*  >>refer   molecule   H3O+   +  CS    =>   HCS+  +     H2O   UMIST  */

			c[ipCS][ipH3OP] -= H3OP_CS_HCSP_H2O_1;
			c[ipH3OP][ipH3OP] -= H3OP_CS_HCSP_H2O_2;
			bvec[ipH3OP] -= bvec_H3OP_CS_HCSP_H2O;
			
			c[ipCS][ipCS] -= H3OP_CS_HCSP_H2O_1;
			c[ipH3OP][ipCS] -= H3OP_CS_HCSP_H2O_2;
			bvec[ipCS] -= bvec_H3OP_CS_HCSP_H2O;
			
			c[ipCS][ipHCSP] += H3OP_CS_HCSP_H2O_1;
			c[ipH3OP][ipHCSP] += H3OP_CS_HCSP_H2O_2;
			bvec[ipHCSP] += bvec_H3OP_CS_HCSP_H2O;
			
			c[ipCS][ipH2O] += H3OP_CS_HCSP_H2O_1;
			c[ipH3OP][ipH2O] += H3OP_CS_HCSP_H2O_2;
			bvec[ipH2O] += bvec_H3OP_CS_HCSP_H2O;

		/*  >>refer   molecule   CN+    +  NO    =>   OCN+  +     N     UMIST  */

			c[ipNO][ipCNP] -= CNP_NO_OCNP_N_1;
			c[ipCNP][ipCNP] -= CNP_NO_OCNP_N_2;
			bvec[ipCNP] -= bvec_CNP_NO_OCNP_N;
			
			c[ipNO][ipNO] -= CNP_NO_OCNP_N_1;
			c[ipCNP][ipNO] -= CNP_NO_OCNP_N_2;
			bvec[ipNO] -= bvec_CNP_NO_OCNP_N;
			
			c[ipNO][ipOCNP] += CNP_NO_OCNP_N_1;
			c[ipCNP][ipOCNP] += CNP_NO_OCNP_N_2;
			bvec[ipOCNP] += bvec_CNP_NO_OCNP_N;

		/*  >>refer   molecule   CN     +  HNO+  =>   NO    +     HCN+  UMIST  */

			c[ipHNOP][ipCN] -= CN_HNOP_NO_HCNP_1;
			c[ipCN][ipCN] -= CN_HNOP_NO_HCNP_2;
			bvec[ipCN] -= bvec_CN_HNOP_NO_HCNP;
			
			c[ipHNOP][ipHNOP] -= CN_HNOP_NO_HCNP_1;
			c[ipCN][ipHNOP] -= CN_HNOP_NO_HCNP_2;
			bvec[ipHNOP] -= bvec_CN_HNOP_NO_HCNP;
			
			c[ipHNOP][ipNO] += CN_HNOP_NO_HCNP_1;
			c[ipCN][ipNO] += CN_HNOP_NO_HCNP_2;
			bvec[ipNO] += bvec_CN_HNOP_NO_HCNP;
			
			c[ipHNOP][ipHCNP] += CN_HNOP_NO_HCNP_1;
			c[ipCN][ipHCNP] += CN_HNOP_NO_HCNP_2;
			bvec[ipHCNP] += bvec_CN_HNOP_NO_HCNP;

		/*  >>refer   molecule   CN+    +  O2    =>   NO+   +     CO    UMIST  */

			c[ipO2][ipCNP] -= CNP_O2_NOP_CO_1;
			c[ipCNP][ipCNP] -= CNP_O2_NOP_CO_2;
			bvec[ipCNP] -= bvec_CNP_O2_NOP_CO;
			
			c[ipO2][ipO2] -= CNP_O2_NOP_CO_1;
			c[ipCNP][ipO2] -= CNP_O2_NOP_CO_2;
			bvec[ipO2] -= bvec_CNP_O2_NOP_CO;
			
			c[ipO2][ipNOP] += CNP_O2_NOP_CO_1;
			c[ipCNP][ipNOP] += CNP_O2_NOP_CO_2;
			bvec[ipNOP] += bvec_CNP_O2_NOP_CO;
			
			c[ipO2][ipCO] += CNP_O2_NOP_CO_1;
			c[ipCNP][ipCO] += CNP_O2_NOP_CO_2;
			bvec[ipCO] += bvec_CNP_O2_NOP_CO;

		/*  >>refer   molecule   CN+    +  O2    =>   OCN+  +     O     UMIST  */

			c[ipO2][ipCNP] -= CNP_O2_OCNP_O_1;
			c[ipCNP][ipCNP] -= CNP_O2_OCNP_O_2;
			bvec[ipCNP] -= bvec_CNP_O2_OCNP_O;
			
			c[ipO2][ipO2] -= CNP_O2_OCNP_O_1;
			c[ipCNP][ipO2] -= CNP_O2_OCNP_O_2;
			bvec[ipO2] -= bvec_CNP_O2_OCNP_O;
			
			c[ipO2][ipOCNP] += CNP_O2_OCNP_O_1;
			c[ipCNP][ipOCNP] += CNP_O2_OCNP_O_2;
			bvec[ipOCNP] += bvec_CNP_O2_OCNP_O;
			
		/*  >>refer   molecule   HCN+   +  CO    =>   HCO+  +     CN    UMIST  */

			c[ipCO][ipHCNP] -= HCNP_CO_HCOP_CN_1;
			c[ipHCNP][ipHCNP] -= HCNP_CO_HCOP_CN_2;
			bvec[ipHCNP] -= bvec_HCNP_CO_HCOP_CN;
			
			c[ipCO][ipCO] -= HCNP_CO_HCOP_CN_1;
			c[ipHCNP][ipCO] -= HCNP_CO_HCOP_CN_2;
			bvec[ipCO] -= bvec_HCNP_CO_HCOP_CN;
			
			c[ipCO][ipHCOP] += HCNP_CO_HCOP_CN_1;
			c[ipHCNP][ipHCOP] += HCNP_CO_HCOP_CN_2;
			bvec[ipHCOP] += bvec_HCNP_CO_HCOP_CN;
			
			c[ipCO][ipCN] += HCNP_CO_HCOP_CN_1;
			c[ipHCNP][ipCN] += HCNP_CO_HCOP_CN_2;
			bvec[ipCN] += bvec_HCNP_CO_HCOP_CN;

		/*  >>refer   molecule   HCN+   +  S     =>   HS+   +     CN    UMIST  */

			c[ipATS][ipHCNP] -= HCNP_S_HSP_CN_1;
			c[ipHCNP][ipHCNP] -= HCNP_S_HSP_CN_2;
			bvec[ipHCNP] -= bvec_HCNP_S_HSP_CN;
			
			c[ipATS][ipHSP] += HCNP_S_HSP_CN_1;
			c[ipHCNP][ipHSP] += HCNP_S_HSP_CN_2;
			bvec[ipHSP] += bvec_HCNP_S_HSP_CN;
			
			c[ipATS][ipCN] += HCNP_S_HSP_CN_1;
			c[ipHCNP][ipCN] += HCNP_S_HSP_CN_2;
			bvec[ipCN] += bvec_HCNP_S_HSP_CN;

		/*  >>refer   molecule   CO     +  HNO+  =>   NO    +     HCO+  UMIST  */

			c[ipHNOP][ipCO] -= CO_HNOP_NO_HCOP_1;
			c[ipCO][ipCO] -= CO_HNOP_NO_HCOP_2;
			bvec[ipCO] -= bvec_CO_HNOP_NO_HCOP;
			
			c[ipHNOP][ipHNOP] -= CO_HNOP_NO_HCOP_1;
			c[ipCO][ipHNOP] -= CO_HNOP_NO_HCOP_2;
			bvec[ipHNOP] -= bvec_CO_HNOP_NO_HCOP;
			
			c[ipHNOP][ipNO] += CO_HNOP_NO_HCOP_1;
			c[ipCO][ipNO] += CO_HNOP_NO_HCOP_2;
			bvec[ipNO] += bvec_CO_HNOP_NO_HCOP;
			
			c[ipHNOP][ipHCOP] += CO_HNOP_NO_HCOP_1;
			c[ipCO][ipHCOP] += CO_HNOP_NO_HCOP_2;
			bvec[ipHCOP] += bvec_CO_HNOP_NO_HCOP;

		/*  >>refer   molecule   N2+    +  OCS   =>   S+    +     N2  + CO     UMIST  */

			c[ipOCS][ipN2P] -= N2P_OCS_SP_N2_CO_1;
			c[ipN2P][ipN2P] -= N2P_OCS_SP_N2_CO_2;
			bvec[ipN2P] -= bvec_N2P_OCS_SP_N2_CO;
			
			c[ipOCS][ipOCS] -= N2P_OCS_SP_N2_CO_1;
			c[ipN2P][ipOCS] -= N2P_OCS_SP_N2_CO_2;
			bvec[ipOCS] -= bvec_N2P_OCS_SP_N2_CO;
			
			c[ipOCS][ipSP] += N2P_OCS_SP_N2_CO_1;
			c[ipN2P][ipSP] += N2P_OCS_SP_N2_CO_2;
			bvec[ipSP] += bvec_N2P_OCS_SP_N2_CO;
			
			c[ipOCS][ipN2] += N2P_OCS_SP_N2_CO_1;
			c[ipN2P][ipN2] += N2P_OCS_SP_N2_CO_2;
			bvec[ipN2] += bvec_N2P_OCS_SP_N2_CO;

			c[ipOCS][ipCO] += N2P_OCS_SP_N2_CO_1;
			c[ipN2P][ipCO] += N2P_OCS_SP_N2_CO_2;
			bvec[ipCO] += bvec_N2P_OCS_SP_N2_CO;

		/*  >>refer   molecule   HCO+   +  S     =>   HS+   +     CO    UMIST  */

			c[ipATS][ipHCOP] -= HCOP_S_HSP_CO_1;
			c[ipHCOP][ipHCOP] -= HCOP_S_HSP_CO_2;
			bvec[ipHCOP] -= bvec_HCOP_S_HSP_CO;
			
			c[ipATS][ipHSP] += HCOP_S_HSP_CO_1;
			c[ipHCOP][ipHSP] += HCOP_S_HSP_CO_2;
			bvec[ipHSP] += bvec_HCOP_S_HSP_CO;
			
			c[ipATS][ipCO] += HCOP_S_HSP_CO_1;
			c[ipHCOP][ipCO] += HCOP_S_HSP_CO_2;
			bvec[ipCO] += bvec_HCOP_S_HSP_CO;

		/*  >>refer   molecule   HCO+   +  CS    =>   HCS+  +     CO    UMIST  */

			c[ipCS][ipHCOP] -= HCOP_CS_HCSP_CO_1;
			c[ipHCOP][ipHCOP] -= HCOP_CS_HCSP_CO_2;
			bvec[ipHCOP] -= bvec_HCOP_CS_HCSP_CO;
			
			c[ipCS][ipCS] -= HCOP_CS_HCSP_CO_1;
			c[ipHCOP][ipCS] -= HCOP_CS_HCSP_CO_2;
			bvec[ipCS] -= bvec_HCOP_CS_HCSP_CO;
			
			c[ipCS][ipHCSP] += HCOP_CS_HCSP_CO_1;
			c[ipHCOP][ipHCSP] += HCOP_CS_HCSP_CO_2;
			bvec[ipHCSP] += bvec_HCOP_CS_HCSP_CO;
			
			c[ipCS][ipCO] += HCOP_CS_HCSP_CO_1;
			c[ipHCOP][ipCO] += HCOP_CS_HCSP_CO_2;
			bvec[ipCO] += bvec_HCOP_CS_HCSP_CO;

		/*  >>refer   molecule   HNO+   +  S     =>   HS+   +     NO    UMIST  */
			
			c[ipATS][ipHNOP] -= HNOP_S_HSP_NO_1;
			c[ipHNOP][ipHNOP] -= HNOP_S_HSP_NO_2;
			bvec[ipHNOP] -= bvec_HNOP_S_HSP_NO;
			
			c[ipATS][ipHSP] += HNOP_S_HSP_NO_1;
			c[ipHNOP][ipHSP] += HNOP_S_HSP_NO_2;
			bvec[ipHSP] += bvec_HNOP_S_HSP_NO;
			
			c[ipATS][ipNO] += HNOP_S_HSP_NO_1;
			c[ipHNOP][ipNO] += HNOP_S_HSP_NO_2;
			bvec[ipNO] += bvec_HNOP_S_HSP_NO;

		/*  >>refer   molecule   O2     +  S+    =>   SO+   +     O     UMIST  */

			c[ipSP][ipO2] -= O2_SP_SOP_O_1;
			c[ipO2][ipO2] -= O2_SP_SOP_O_2;
			bvec[ipO2] -= bvec_O2_SP_SOP_O;
			
			c[ipSP][ipSP] -= O2_SP_SOP_O_1;
			c[ipO2][ipSP] -= O2_SP_SOP_O_2;
			bvec[ipSP] -= bvec_O2_SP_SOP_O;
			
			c[ipSP][ipSOP] += O2_SP_SOP_O_1;
			c[ipO2][ipSOP] += O2_SP_SOP_O_2;
			bvec[ipSOP] += bvec_O2_SP_SOP_O;

		/*  >>refer   molecule   O2+    +  S     =>   SO+   +     O     UMIST  */

			c[ipATS][ipO2P] -= O2P_S_SOP_O_1;
			c[ipO2P][ipO2P] -= O2P_S_SOP_O_2;
			bvec[ipO2P] -= bvec_O2P_S_SOP_O;
			
			c[ipATS][ipSOP] += O2P_S_SOP_O_1;
			c[ipO2P][ipSOP] += O2P_S_SOP_O_2;
			bvec[ipSOP] += bvec_O2P_S_SOP_O;

		/*  >>refer   molecule   O2     +  CS+   =>   OCS+  +     O     UMIST  */

			c[ipCSP][ipO2] -= O2_CSP_OCSP_O_1;
			c[ipO2][ipO2] -= O2_CSP_OCSP_O_2;
			bvec[ipO2] -= bvec_O2_CSP_OCSP_O;
			
			c[ipCSP][ipCSP] -= O2_CSP_OCSP_O_1;
			c[ipO2][ipCSP] -= O2_CSP_OCSP_O_2;
			bvec[ipCSP] -= bvec_O2_CSP_OCSP_O;
			
			c[ipCSP][ipOCSP] += O2_CSP_OCSP_O_1;
			c[ipO2][ipOCSP] += O2_CSP_OCSP_O_2;
			bvec[ipOCSP] += bvec_O2_CSP_OCSP_O;
			
		/*  >>refer   molecule   S      +  SIO+  =>   SO    +     SI+   UMIST  */
			
			c[ipSIOP][ipSIOP] -= S_SIOP_SO_SIP_1;
			c[ipATS][ipSIOP] -= S_SIOP_SO_SIP_2;
			bvec[ipSIOP] -= bvec_S_SIOP_SO_SIP;
			
			c[ipSIOP][ipSO] += S_SIOP_SO_SIP_1;
			c[ipATS][ipSO] += S_SIOP_SO_SIP_2;
			bvec[ipSO] += bvec_S_SIOP_SO_SIP;
			
			c[ipSIOP][ipSIP] += S_SIOP_SO_SIP_1;
			c[ipATS][ipSIP] += S_SIOP_SO_SIP_2;
			bvec[ipSIP] += bvec_S_SIOP_SO_SIP;

		/*  >>refer   molecule   H+     +  NH    =>   NH+   +     H     UMIST  */

			c[ipNH][ipNH] -= HP_NH_NHP_H;
			c[ipNH][ipNHP] += HP_NH_NHP_H;

		/*  >>refer   molecule   H+     +  NH2   =>   NH2+  +     H     UMIST  */

			c[ipNH2][ipNH2] -= HP_NH2_NH2P_H;
			c[ipNH2][ipNH2P] += HP_NH2_NH2P_H;

		/*  >>refer   molecule   H+     +  NH3   =>   NH3+  +     H     UMIST  */

			c[ipNH3][ipNH3] -= HP_NH3_NH3P_H;
			c[ipNH3][ipNH3P] += HP_NH3_NH3P_H;

		/*  >>refer   molecule   H      +  CN+   =>   CN    +     H+    UMIST  */

			c[ipCNP][ipCNP] -= H_CNP_CN_HP;
			c[ipCNP][ipCN] += H_CNP_CN_HP;

		/*  >>refer   molecule   H+     +  HCN   =>   HCN+  +     H     UMIST  */

			c[ipHCN][ipHCN] -= HP_HCN_HCNP_H;
			c[ipHCN][ipHCNP] += HP_HCN_HCNP_H;

		/*  >>refer   molecule   H      +  HCN+  =>   HCN   +     H+    UMIST  */

			c[ipHCNP][ipHCNP] -= H_HCNP_HCN_HP;
			c[ipHCNP][ipHCN] += H_HCNP_HCN_HP;

		/*  >>refer   molecule   H      +  N2+   =>   N2    +     H+    UMIST  */

			c[ipN2P][ipN2P] -= H_N2P_N2_HP;
			c[ipN2P][ipN2] += H_N2P_N2_HP;

		/*  >>refer   molecule   H+     +  NO    =>   NO+   +     H     UMIST  */

			c[ipNO][ipNO] -= HP_NO_NOP_H;
			c[ipNO][ipNOP] += HP_NO_NOP_H;

		/*  >>refer   molecule   H+     +  HS    =>   HS+   +     H     UMIST  */

			c[ipHS][ipHS] -= HP_HS_HSP_H;
			c[ipHS][ipHSP] += HP_HS_HSP_H;

		/*  >>refer   molecule   H+     +  SIN   =>   SIN+  +     H     UMIST  */

			c[ipSIN][ipSIN] -= HP_SIN_SINP_H;
			c[ipSIN][ipSINP] += HP_SIN_SINP_H;

		/*  >>refer   molecule   H+     +  CS    =>   CS+   +     H     UMIST  */

			c[ipCS][ipCS] -= HP_CS_CSP_H;
			c[ipCS][ipCSP] += HP_CS_CSP_H;

		/*  >>refer   molecule   H+     +  NS    =>   NS+   +     H     UMIST  */

			c[ipNS][ipNS] -= HP_NS_NSP_H;
			c[ipNS][ipNSP] += HP_NS_NSP_H;

		/*  >>refer   molecule   H+     +  SO    =>   SO+   +     H     UMIST  */

			c[ipSO][ipSO] -= HP_SO_SOP_H;
			c[ipSO][ipSOP] += HP_SO_SOP_H;

		/*  >>refer   molecule   H+     +  OCS   =>   OCS+  +     H     UMIST  */

			c[ipOCS][ipOCS] -= HP_OCS_OCSP_H;
			c[ipOCS][ipOCSP] += HP_OCS_OCSP_H;

		/*  >>refer   molecule   H+     +  S2    =>   S2+   +     H     UMIST  */

			c[ipS2][ipS2] -= HP_S2_S2P_H;
			c[ipS2][ipS2P] += HP_S2_S2P_H;

		/*  >>refer   molecule   H2+    +  NH    =>   NH+   +     H2    UMIST  */

			c[ipNH][ipNH] -= H2P_NH_NHP_H2;
			c[ipNH][ipNHP] += H2P_NH_NHP_H2;

		/*  >>refer   molecule   H2+    +  NH2   =>   NH2+  +     H2    UMIST  */

			c[ipNH2][ipNH2] -= H2P_NH2_NH2P_H2;
			c[ipNH2][ipNH2P] += H2P_NH2_NH2P_H2;

		/*  >>refer   molecule   H2+    +  NH3   =>   NH3+  +     H2    UMIST  */

			c[ipNH3][ipNH3] -= H2P_NH3_NH3P_H2;
			c[ipNH3][ipNH3P] += H2P_NH3_NH3P_H2;

		/*  >>refer   molecule   H2+    +  CN    =>   CN+   +     H2    UMIST  */

			c[ipCN][ipCN] -= H2P_CN_CNP_H2;
			c[ipCN][ipCNP] += H2P_CN_CNP_H2;

		/*  >>refer   molecule   H2+    +  HCN   =>   HCN+  +     H2    UMIST  */

			c[ipHCN][ipHCN] -= H2P_HCN_HCNP_H2;
			c[ipHCN][ipHCNP] += H2P_HCN_HCNP_H2;

		/*  >>refer   molecule   H2+    +  NO    =>   NO+   +     H2    UMIST  */

			c[ipNO][ipNO] -= H2P_NO_NOP_H2;
			c[ipNO][ipNOP] += H2P_NO_NOP_H2;

		/*  >>refer   molecule   He+    +  NH3   =>   NH3+  +     He    UMIST  */

			c[ipNH3][ipNH3] -= HeP_NH3_NH3P_He;
			c[ipNH3][ipNH3P] += HeP_NH3_NH3P_He;

		/*  >>refer   molecule   He+    +  N2    =>   N2+   +     He    UMIST  */

			c[ipN2][ipN2] -= HeP_N2_N2P_He;
			c[ipN2][ipN2P] += HeP_N2_N2P_He;

		/*  >>refer   molecule   C+     +  NH3   =>   NH3+  +     C     UMIST  */

			c[ipNH3][ipCP] -= CP_NH3_NH3P_C_1;
			c[ipCP][ipCP] -= CP_NH3_NH3P_C_2;
			bvec[ipCP] -= bvec_CP_NH3_NH3P_C;
			
			c[ipNH3][ipNH3] -= CP_NH3_NH3P_C_1;
			c[ipCP][ipNH3] -= CP_NH3_NH3P_C_2;
			bvec[ipNH3] -= bvec_CP_NH3_NH3P_C;
			
			c[ipNH3][ipNH3P] += CP_NH3_NH3P_C_1;
			c[ipCP][ipNH3P] += CP_NH3_NH3P_C_2;
			bvec[ipNH3P] += bvec_CP_NH3_NH3P_C;

		/*  >>refer   molecule   C      +  CN+   =>   CN    +     C+    UMIST  */
			
			c[ipCNP][ipCNP] -= C_CNP_CN_CP_1;
			c[ipATC][ipCNP] -= C_CNP_CN_CP_2;
			bvec[ipCNP] -= bvec_C_CNP_CN_CP;
			
			c[ipCNP][ipCN] += C_CNP_CN_CP_1;
			c[ipATC][ipCN] += C_CNP_CN_CP_2;
			bvec[ipCN] += bvec_C_CNP_CN_CP;
			
			c[ipCNP][ipCP] += C_CNP_CN_CP_1;
			c[ipATC][ipCP] += C_CNP_CN_CP_2;
			bvec[ipCP] += bvec_C_CNP_CN_CP;

		/*  >>refer   molecule   C      +  N2+   =>   N2    +     C+    UMIST  */

			c[ipN2P][ipN2P] -= C_N2P_N2_CP_1;
			c[ipATC][ipN2P] -= C_N2P_N2_CP_2;
			bvec[ipN2P] -= bvec_C_N2P_N2_CP;
			
			c[ipN2P][ipN2] += C_N2P_N2_CP_1;
			c[ipATC][ipN2] += C_N2P_N2_CP_2;
			bvec[ipN2] += bvec_C_N2P_N2_CP;
			
			c[ipN2P][ipCP] += C_N2P_N2_CP_1;
			c[ipATC][ipCP] += C_N2P_N2_CP_2;
			bvec[ipCP] += bvec_C_N2P_N2_CP;

		/*  >>refer   molecule   C+     +  NO    =>   NO+   +     C     UMIST  */

			c[ipNO][ipCP] -= CP_NO_NOP_C_1;
			c[ipCP][ipCP] -= CP_NO_NOP_C_2;
			bvec[ipCP] -= bvec_CP_NO_NOP_C;
			
			c[ipNO][ipNO] -= CP_NO_NOP_C_1;
			c[ipCP][ipNO] -= CP_NO_NOP_C_2;
			bvec[ipNO] -= bvec_CP_NO_NOP_C;
			
			c[ipNO][ipNOP] += CP_NO_NOP_C_1;
			c[ipCP][ipNOP] += CP_NO_NOP_C_2;
			bvec[ipNOP] += bvec_CP_NO_NOP_C;
			
		/*  >>refer   molecule   C+     +  SIN   =>   SIN+  +     C     UMIST  */

			c[ipSIN][ipCP] -= CP_SIN_SINP_C_1;
			c[ipCP][ipCP] -= CP_SIN_SINP_C_2;
			bvec[ipCP] -= bvec_CP_SIN_SINP_C;
			
			c[ipSIN][ipSIN] -= CP_SIN_SINP_C_1;
			c[ipCP][ipSIN] -= CP_SIN_SINP_C_2;
			bvec[ipSIN] -= bvec_CP_SIN_SINP_C;
			
			c[ipSIN][ipSINP] += CP_SIN_SINP_C_1;
			c[ipCP][ipSINP] += CP_SIN_SINP_C_2;
			bvec[ipSINP] += bvec_CP_SIN_SINP_C;
			
		/*  >>refer   molecule   C      +  CS+   =>   CS    +     C+    UMIST  */

			c[ipCSP][ipCSP] -= C_CSP_CS_CP_1;
			c[ipATC][ipCSP] -= C_CSP_CS_CP_2;
			bvec[ipCSP] -= bvec_C_CSP_CS_CP;
			
			c[ipCSP][ipCS] += C_CSP_CS_CP_1;
			c[ipATC][ipCS] += C_CSP_CS_CP_2;
			bvec[ipCS] += bvec_C_CSP_CS_CP;
			
			c[ipCSP][ipCP] += C_CSP_CS_CP_1;
			c[ipATC][ipCP] += C_CSP_CS_CP_2;
			bvec[ipCP] += bvec_C_CSP_CS_CP;

		/*  >>refer   molecule   C+     +  NS    =>   NS+   +     C     UMIST  */

			c[ipNS][ipCP] -= CP_NS_NSP_C_1;
			c[ipCP][ipCP] -= CP_NS_NSP_C_2;
			bvec[ipCP] -= bvec_CP_NS_NSP_C;
			
			c[ipNS][ipNS] -= CP_NS_NSP_C_1;
			c[ipCP][ipNS] -= CP_NS_NSP_C_2;
			bvec[ipNS] -= bvec_CP_NS_NSP_C;
			
			c[ipNS][ipNSP] += CP_NS_NSP_C_1;
			c[ipCP][ipNSP] += CP_NS_NSP_C_2;
			bvec[ipNSP] += bvec_CP_NS_NSP_C;
			
		/*  >>refer   molecule   C+     +  SO    =>   SO+   +     C     UMIST  */

			c[ipSO][ipCP] -= CP_SO_SOP_C_1;
			c[ipCP][ipCP] -= CP_SO_SOP_C_2;
			bvec[ipCP] -= bvec_CP_SO_SOP_C;
			
			c[ipSO][ipSO] -= CP_SO_SOP_C_1;
			c[ipCP][ipSO] -= CP_SO_SOP_C_2;
			bvec[ipSO] -= bvec_CP_SO_SOP_C;
			
			c[ipSO][ipSOP] += CP_SO_SOP_C_1;
			c[ipCP][ipSOP] += CP_SO_SOP_C_2;
			bvec[ipSOP] += bvec_CP_SO_SOP_C;
			
		/*  >>refer   molecule   C+     +  OCS   =>   OCS+  +     C     UMIST  */

			c[ipOCS][ipCP] -= CP_OCS_OCSP_C_1;
			c[ipCP][ipCP] -= CP_OCS_OCSP_C_2;
			bvec[ipCP] -= bvec_CP_OCS_OCSP_C;
			
			c[ipOCS][ipOCS] -= CP_OCS_OCSP_C_1;
			c[ipCP][ipOCS] -= CP_OCS_OCSP_C_2;
			bvec[ipOCS] -= bvec_CP_OCS_OCSP_C;
			
			c[ipOCS][ipOCSP] += CP_OCS_OCSP_C_1;
			c[ipCP][ipOCSP] += CP_OCS_OCSP_C_2;
			bvec[ipOCSP] += bvec_CP_OCS_OCSP_C;
			
		/*  >>refer   molecule   CH     +  NH2+  =>   NH2   +     CH+   UMIST  */

			c[ipNH2P][ipCH] -= CH_NH2P_NH2_CHP_1;
			c[ipCH][ipCH] -= CH_NH2P_NH2_CHP_2;
			bvec[ipCH] -= bvec_CH_NH2P_NH2_CHP;
			
			c[ipNH2P][ipNH2P] -= CH_NH2P_NH2_CHP_1;
			c[ipCH][ipNH2P] -= CH_NH2P_NH2_CHP_2;
			bvec[ipNH2P] -= bvec_CH_NH2P_NH2_CHP;
			
			c[ipNH2P][ipNH2] += CH_NH2P_NH2_CHP_1;
			c[ipCH][ipNH2] += CH_NH2P_NH2_CHP_2;
			bvec[ipNH2] += bvec_CH_NH2P_NH2_CHP;
			
			c[ipNH2P][ipCHP] += CH_NH2P_NH2_CHP_1;
			c[ipCH][ipCHP] += CH_NH2P_NH2_CHP_2;
			bvec[ipCHP] += bvec_CH_NH2P_NH2_CHP;

		/*  >>refer   molecule   CH+    +  NH3   =>   NH3+  +     CH    UMIST  */

			c[ipNH3][ipCHP] -= CHP_NH3_NH3P_CH_1;
			c[ipCHP][ipCHP] -= CHP_NH3_NH3P_CH_2;
			bvec[ipCHP] -= bvec_CHP_NH3_NH3P_CH;
			
			c[ipNH3][ipNH3] -= CHP_NH3_NH3P_CH_1;
			c[ipCHP][ipNH3] -= CHP_NH3_NH3P_CH_2;
			bvec[ipNH3] -= bvec_CHP_NH3_NH3P_CH;
			
			c[ipNH3][ipNH3P] += CHP_NH3_NH3P_CH_1;
			c[ipCHP][ipNH3P] += CHP_NH3_NH3P_CH_2;
			bvec[ipNH3P] += bvec_CHP_NH3_NH3P_CH;
			
			c[ipNH3][ipCH] += CHP_NH3_NH3P_CH_1;
			c[ipCHP][ipCH] += CHP_NH3_NH3P_CH_2;
			bvec[ipCH] += bvec_CHP_NH3_NH3P_CH;

		/*  >>refer   molecule   CH     +  CN+   =>   CN    +     CH+   UMIST  */

			c[ipCNP][ipCH] -= CH_CNP_CN_CHP_1;
			c[ipCH][ipCH] -= CH_CNP_CN_CHP_2;
			bvec[ipCH] -= bvec_CH_CNP_CN_CHP;
			
			c[ipCNP][ipCNP] -= CH_CNP_CN_CHP_1;
			c[ipCH][ipCNP] -= CH_CNP_CN_CHP_2;
			bvec[ipCNP] -= bvec_CH_CNP_CN_CHP;
			
			c[ipCNP][ipCN] += CH_CNP_CN_CHP_1;
			c[ipCH][ipCN] += CH_CNP_CN_CHP_2;
			bvec[ipCN] += bvec_CH_CNP_CN_CHP;
			
			c[ipCNP][ipCHP] += CH_CNP_CN_CHP_1;
			c[ipCH][ipCHP] += CH_CNP_CN_CHP_2;
			bvec[ipCHP] += bvec_CH_CNP_CN_CHP;

		/*  >>refer   molecule   CH     +  N2+   =>   N2    +     CH+   UMIST  */

			c[ipN2P][ipCH] -= CH_N2P_N2_CHP_1;
			c[ipCH][ipCH] -= CH_N2P_N2_CHP_2;
			bvec[ipCH] -= bvec_CH_N2P_N2_CHP;
			
			c[ipN2P][ipN2P] -= CH_N2P_N2_CHP_1;
			c[ipCH][ipN2P] -= CH_N2P_N2_CHP_2;
			bvec[ipN2P] -= bvec_CH_N2P_N2_CHP;
			
			c[ipN2P][ipN2] += CH_N2P_N2_CHP_1;
			c[ipCH][ipN2] += CH_N2P_N2_CHP_2;
			bvec[ipN2] += bvec_CH_N2P_N2_CHP;
			
			c[ipN2P][ipCHP] += CH_N2P_N2_CHP_1;
			c[ipCH][ipCHP] += CH_N2P_N2_CHP_2;
			bvec[ipCHP] += bvec_CH_N2P_N2_CHP;

		/*  >>refer   molecule   CH+    +  NO    =>   NO+   +     CH    UMIST  */

			c[ipNO][ipCHP] -= CHP_NO_NOP_CH_1;
			c[ipCHP][ipCHP] -= CHP_NO_NOP_CH_2;
			bvec[ipCHP] -= bvec_CHP_NO_NOP_CH;
			
			c[ipNO][ipNO] -= CHP_NO_NOP_CH_1;
			c[ipCHP][ipNO] -= CHP_NO_NOP_CH_2;
			bvec[ipNO] -= bvec_CHP_NO_NOP_CH;
			
			c[ipNO][ipNOP] += CHP_NO_NOP_CH_1;
			c[ipCHP][ipNOP] += CHP_NO_NOP_CH_2;
			bvec[ipNOP] += bvec_CHP_NO_NOP_CH;
			
			c[ipNO][ipCH] += CHP_NO_NOP_CH_1;
			c[ipCHP][ipCH] += CHP_NO_NOP_CH_2;
			bvec[ipCH] += bvec_CHP_NO_NOP_CH;

		/*  >>refer   molecule   N+     +  NH    =>   NH+   +     N     UMIST  */

			c[ipNH][ipNP] -= NP_NH_NHP_N_1;
			c[ipNP][ipNP] -= NP_NH_NHP_N_2;
			bvec[ipNP] -= bvec_NP_NH_NHP_N;
			
			c[ipNH][ipNH] -= NP_NH_NHP_N_1;
			c[ipNP][ipNH] -= NP_NH_NHP_N_2;
			bvec[ipNH] -= bvec_NP_NH_NHP_N;
			
			c[ipNH][ipNHP] += NP_NH_NHP_N_1;
			c[ipNP][ipNHP] += NP_NH_NHP_N_2;
			bvec[ipNHP] += bvec_NP_NH_NHP_N;
			
		/*  >>refer   molecule   N+     +  NH2   =>   NH2+  +     N     UMIST  */

			c[ipNH2][ipNP] -= NP_NH2_NH2P_N_1;
			c[ipNP][ipNP] -= NP_NH2_NH2P_N_2;
			bvec[ipNP] -= bvec_NP_NH2_NH2P_N;
			
			c[ipNH2][ipNH2] -= NP_NH2_NH2P_N_1;
			c[ipNP][ipNH2] -= NP_NH2_NH2P_N_2;
			bvec[ipNH2] -= bvec_NP_NH2_NH2P_N;
			
			c[ipNH2][ipNH2P] += NP_NH2_NH2P_N_1;
			c[ipNP][ipNH2P] += NP_NH2_NH2P_N_2;
			bvec[ipNH2P] += bvec_NP_NH2_NH2P_N;

		/*  >>refer   molecule   N+     +  NH3   =>   NH3+  +     N     UMIST  */

			c[ipNH3][ipNP] -= NP_NH3_NH3P_N_1;
			c[ipNP][ipNP] -= NP_NH3_NH3P_N_2;
			bvec[ipNP] -= bvec_NP_NH3_NH3P_N;
			
			c[ipNH3][ipNH3] -= NP_NH3_NH3P_N_1;
			c[ipNP][ipNH3] -= NP_NH3_NH3P_N_2;
			bvec[ipNH3] -= bvec_NP_NH3_NH3P_N;
			
			c[ipNH3][ipNH3P] += NP_NH3_NH3P_N_1;
			c[ipNP][ipNH3P] += NP_NH3_NH3P_N_2;
			bvec[ipNH3P] += bvec_NP_NH3_NH3P_N;

		/*  >>refer   molecule   N+     +  CN    =>   CN+   +     N     UMIST  */

			c[ipCN][ipNP] -= NP_CN_CNP_N_1;
			c[ipNP][ipNP] -= NP_CN_CNP_N_2;
			bvec[ipNP] -= bvec_NP_CN_CNP_N;
			
			c[ipCN][ipCN] -= NP_CN_CNP_N_1;
			c[ipNP][ipCN] -= NP_CN_CNP_N_2;
			bvec[ipCN] -= bvec_NP_CN_CNP_N;
			
			c[ipCN][ipCNP] += NP_CN_CNP_N_1;
			c[ipNP][ipCNP] += NP_CN_CNP_N_2;
			bvec[ipCNP] += bvec_NP_CN_CNP_N;

		/*  >>refer   molecule   N+     +  HCN   =>   HCN+  +     N     UMIST  */

			c[ipHCN][ipNP] -= NP_HCN_HCNP_N_1;
			c[ipNP][ipNP] -= NP_HCN_HCNP_N_2;
			bvec[ipNP] -= bvec_NP_HCN_HCNP_N;
			
			c[ipHCN][ipHCN] -= NP_HCN_HCNP_N_1;
			c[ipNP][ipHCN] -= NP_HCN_HCNP_N_2;
			bvec[ipHCN] -= bvec_NP_HCN_HCNP_N;
			
			c[ipHCN][ipHCNP] += NP_HCN_HCNP_N_1;
			c[ipNP][ipHCNP] += NP_HCN_HCNP_N_2;
			bvec[ipHCNP] += bvec_NP_HCN_HCNP_N;

		/*  >>refer   molecule   N      +  N2+   =>   N2    +     N+    UMIST  */

			c[ipN2P][ipN2P] -= N_N2P_N2_NP_1;
			c[ipATN][ipN2P] -= N_N2P_N2_NP_2;
			bvec[ipN2P] -= bvec_N_N2P_N2_NP;
			
			c[ipN2P][ipN2] += N_N2P_N2_NP_1;
			c[ipATN][ipN2] += N_N2P_N2_NP_2;
			bvec[ipN2] += bvec_N_N2P_N2_NP;
			
			c[ipN2P][ipNP] += N_N2P_N2_NP_1;
			c[ipATN][ipNP] += N_N2P_N2_NP_2;
			bvec[ipNP] += bvec_N_N2P_N2_NP;

		/*  >>refer   molecule   N+     +  NO    =>   NO+   +     N     UMIST  */

			c[ipNO][ipNP] -= NP_NO_NOP_N_1;
			c[ipNP][ipNP] -= NP_NO_NOP_N_2;
			bvec[ipNP] -= bvec_NP_NO_NOP_N;
			
			c[ipNO][ipNO] -= NP_NO_NOP_N_1;
			c[ipNP][ipNO] -= NP_NO_NOP_N_2;
			bvec[ipNO] -= bvec_NP_NO_NOP_N;
			
			c[ipNO][ipNOP] += NP_NO_NOP_N_1;
			c[ipNP][ipNOP] += NP_NO_NOP_N_2;
			bvec[ipNOP] += bvec_NP_NO_NOP_N;
			
		/*  >>refer   molecule   N+     +  OCS   =>   OCS+  +     N     UMIST  */

			c[ipOCS][ipNP] -= NP_OCS_OCSP_N_1;
			c[ipNP][ipNP] -= NP_OCS_OCSP_N_2;
			bvec[ipNP] -= bvec_NP_OCS_OCSP_N;
			
			c[ipOCS][ipOCS] -= NP_OCS_OCSP_N_1;
			c[ipNP][ipOCS] -= NP_OCS_OCSP_N_2;
			bvec[ipOCS] -= bvec_NP_OCS_OCSP_N;
			
			c[ipOCS][ipOCSP] += NP_OCS_OCSP_N_1;
			c[ipNP][ipOCSP] += NP_OCS_OCSP_N_2;
			bvec[ipOCSP] += bvec_NP_OCS_OCSP_N;

		/*  >>refer   molecule   CH2    +  NH2+  =>   NH2   +     CH2+  UMIST  */

			c[ipNH2P][ipCH2] -= CH2_NH2P_NH2_CH2P_1;
			c[ipCH2][ipCH2] -= CH2_NH2P_NH2_CH2P_2;
			bvec[ipCH2] -= bvec_CH2_NH2P_NH2_CH2P;
			
			c[ipNH2P][ipNH2P] -= CH2_NH2P_NH2_CH2P_1;
			c[ipCH2][ipNH2P] -= CH2_NH2P_NH2_CH2P_2;
			bvec[ipNH2P] -= bvec_CH2_NH2P_NH2_CH2P;
			
			c[ipNH2P][ipNH2] += CH2_NH2P_NH2_CH2P_1;
			c[ipCH2][ipNH2] += CH2_NH2P_NH2_CH2P_2;
			bvec[ipNH2] += bvec_CH2_NH2P_NH2_CH2P;
			
			c[ipNH2P][ipCH2P] += CH2_NH2P_NH2_CH2P_1;
			c[ipCH2][ipCH2P] += CH2_NH2P_NH2_CH2P_2;
			bvec[ipCH2P] += bvec_CH2_NH2P_NH2_CH2P;

		/*  >>refer   molecule   CH2    +  CN+   =>   CN    +     CH2+  UMIST  */

			c[ipCNP][ipCH2] -= CH2_CNP_CN_CH2P_1;
			c[ipCH2][ipCH2] -= CH2_CNP_CN_CH2P_2;
			bvec[ipCH2] -= bvec_CH2_CNP_CN_CH2P;
			
			c[ipCNP][ipCNP] -= CH2_CNP_CN_CH2P_1;
			c[ipCH2][ipCNP] -= CH2_CNP_CN_CH2P_2;
			bvec[ipCNP] -= bvec_CH2_CNP_CN_CH2P;
			
			c[ipCNP][ipCN] += CH2_CNP_CN_CH2P_1;
			c[ipCH2][ipCN] += CH2_CNP_CN_CH2P_2;
			bvec[ipCN] += bvec_CH2_CNP_CN_CH2P;
			
			c[ipCNP][ipCH2P] += CH2_CNP_CN_CH2P_1;
			c[ipCH2][ipCH2P] += CH2_CNP_CN_CH2P_2;
			bvec[ipCH2P] += bvec_CH2_CNP_CN_CH2P;

		/*  >>refer   molecule   CH2    +  N2+   =>   N2    +     CH2+  UMIST  */

			c[ipN2P][ipCH2] -= CH2_N2P_N2_CH2P_1;
			c[ipCH2][ipCH2] -= CH2_N2P_N2_CH2P_2;
			bvec[ipCH2] -= bvec_CH2_N2P_N2_CH2P;
			
			c[ipN2P][ipN2P] -= CH2_N2P_N2_CH2P_1;
			c[ipCH2][ipN2P] -= CH2_N2P_N2_CH2P_2;
			bvec[ipN2P] -= bvec_CH2_N2P_N2_CH2P;
			
			c[ipN2P][ipN2] += CH2_N2P_N2_CH2P_1;
			c[ipCH2][ipN2] += CH2_N2P_N2_CH2P_2;
			bvec[ipN2] += bvec_CH2_N2P_N2_CH2P;
			
			c[ipN2P][ipCH2P] += CH2_N2P_N2_CH2P_1;
			c[ipCH2][ipCH2P] += CH2_N2P_N2_CH2P_2;
			bvec[ipCH2P] += bvec_CH2_N2P_N2_CH2P;

		/*  >>refer   molecule   CH2+   +  NO    =>   NO+   +     CH2   UMIST  */

			c[ipNO][ipCH2P] -= CH2P_NO_NOP_CH2_1;
			c[ipCH2P][ipCH2P] -= CH2P_NO_NOP_CH2_2;
			bvec[ipCH2P] -= bvec_CH2P_NO_NOP_CH2;
			
			c[ipNO][ipNO] -= CH2P_NO_NOP_CH2_1;
			c[ipCH2P][ipNO] -= CH2P_NO_NOP_CH2_2;
			bvec[ipNO] -= bvec_CH2P_NO_NOP_CH2;
			
			c[ipNO][ipNOP] += CH2P_NO_NOP_CH2_1;
			c[ipCH2P][ipNOP] += CH2P_NO_NOP_CH2_2;
			bvec[ipNOP] += bvec_CH2P_NO_NOP_CH2;
			
			c[ipNO][ipCH2] += CH2P_NO_NOP_CH2_1;
			c[ipCH2P][ipCH2] += CH2P_NO_NOP_CH2_2;
			bvec[ipCH2] += bvec_CH2P_NO_NOP_CH2;

		/*  >>refer   molecule   NH     +  O+    =>   O     +     NH+   UMIST  */

			c[ipOP][ipOP] -= NH_OP_O_NHP_1;
			c[ipNH][ipOP] -= NH_OP_O_NHP_2;
			bvec[ipOP] -= bvec_NH_OP_O_NHP;
			
			c[ipOP][ipNH] -= NH_OP_O_NHP_1;
			c[ipNH][ipNH] -= NH_OP_O_NHP_2;
			bvec[ipNH] -= bvec_NH_OP_O_NHP;
			
			c[ipOP][ipNHP] += NH_OP_O_NHP_1;
			c[ipNH][ipNHP] += NH_OP_O_NHP_2;
			bvec[ipNHP] += bvec_NH_OP_O_NHP;
			
		/*  >>refer   molecule   NH     +  OH+   =>   OH    +     NH+   UMIST  */

			c[ipOHP][ipOHP] -= NH_OHP_OH_NHP_1;
			c[ipNH][ipOHP] -= NH_OHP_OH_NHP_2;
			bvec[ipOHP] -= bvec_NH_OHP_OH_NHP;
			
			c[ipOHP][ipNH] -= NH_OHP_OH_NHP_1;
			c[ipNH][ipNH] -= NH_OHP_OH_NHP_2;
			bvec[ipNH] -= bvec_NH_OHP_OH_NHP;
			
			c[ipOHP][ipOH] += NH_OHP_OH_NHP_1;
			c[ipNH][ipOH] += NH_OHP_OH_NHP_2;
			bvec[ipOH] += bvec_NH_OHP_OH_NHP;
			
			c[ipOHP][ipNHP] += NH_OHP_OH_NHP_1;
			c[ipNH][ipNHP] += NH_OHP_OH_NHP_2;
			bvec[ipNHP] += bvec_NH_OHP_OH_NHP;

		/*  >>refer   molecule   NH+    +  NH3   =>   NH3+  +     NH    UMIST  */

			c[ipNH3][ipNHP] -= NHP_NH3_NH3P_NH_1;
			c[ipNHP][ipNHP] -= NHP_NH3_NH3P_NH_2;
			bvec[ipNHP] -= bvec_NHP_NH3_NH3P_NH;
			
			c[ipNH3][ipNH3] -= NHP_NH3_NH3P_NH_1;
			c[ipNHP][ipNH3] -= NHP_NH3_NH3P_NH_2;
			bvec[ipNH3] -= bvec_NHP_NH3_NH3P_NH;
			
			c[ipNH3][ipNH3P] += NHP_NH3_NH3P_NH_1;
			c[ipNHP][ipNH3P] += NHP_NH3_NH3P_NH_2;
			bvec[ipNH3P] += bvec_NHP_NH3_NH3P_NH;
			
			c[ipNH3][ipNH] += NHP_NH3_NH3P_NH_1;
			c[ipNHP][ipNH] += NHP_NH3_NH3P_NH_2;
			bvec[ipNH] += bvec_NHP_NH3_NH3P_NH;

		/*  >>refer   molecule   NH+    +  H2O   =>   H2O+  +     NH    UMIST  */

			c[ipH2O][ipNHP] -= NHP_H2O_H2OP_NH_1;
			c[ipNHP][ipNHP] -= NHP_H2O_H2OP_NH_2;
			bvec[ipNHP] -= bvec_NHP_H2O_H2OP_NH;
			
			c[ipH2O][ipH2O] -= NHP_H2O_H2OP_NH_1;
			c[ipNHP][ipH2O] -= NHP_H2O_H2OP_NH_2;
			bvec[ipH2O] -= bvec_NHP_H2O_H2OP_NH;
			
			c[ipH2O][ipH2OP] += NHP_H2O_H2OP_NH_1;
			c[ipNHP][ipH2OP] += NHP_H2O_H2OP_NH_2;
			bvec[ipH2OP] += bvec_NHP_H2O_H2OP_NH;
			
			c[ipH2O][ipNH] += NHP_H2O_H2OP_NH_1;
			c[ipNHP][ipNH] += NHP_H2O_H2OP_NH_2;
			bvec[ipNH] += bvec_NHP_H2O_H2OP_NH;

		/*  >>refer   molecule   NH     +  CN+   =>   CN    +     NH+   UMIST  */

			c[ipCNP][ipNH] -= NH_CNP_CN_NHP_1;
			c[ipNH][ipNH] -= NH_CNP_CN_NHP_2;
			bvec[ipNH] -= bvec_NH_CNP_CN_NHP;
			
			c[ipCNP][ipCNP] -= NH_CNP_CN_NHP_1;
			c[ipNH][ipCNP] -= NH_CNP_CN_NHP_2;
			bvec[ipCNP] -= bvec_NH_CNP_CN_NHP;
			
			c[ipCNP][ipCN] += NH_CNP_CN_NHP_1;
			c[ipNH][ipCN] += NH_CNP_CN_NHP_2;
			bvec[ipCN] += bvec_NH_CNP_CN_NHP;
			
			c[ipCNP][ipNHP] += NH_CNP_CN_NHP_1;
			c[ipNH][ipNHP] += NH_CNP_CN_NHP_2;
			bvec[ipNHP] += bvec_NH_CNP_CN_NHP;

		/*  >>refer   molecule   NH     +  CO+   =>   CO    +     NH+   UMIST  */

			c[ipCOP][ipNH] -= NH_COP_CO_NHP_1;
			c[ipNH][ipNH] -= NH_COP_CO_NHP_2;
			bvec[ipNH] -= bvec_NH_COP_CO_NHP;
			
			c[ipCOP][ipCOP] -= NH_COP_CO_NHP_1;
			c[ipNH][ipCOP] -= NH_COP_CO_NHP_2;
			bvec[ipCOP] -= bvec_NH_COP_CO_NHP;
			
			c[ipCOP][ipCO] += NH_COP_CO_NHP_1;
			c[ipNH][ipCO] += NH_COP_CO_NHP_2;
			bvec[ipCO] += bvec_NH_COP_CO_NHP;
			
			c[ipCOP][ipNHP] += NH_COP_CO_NHP_1;
			c[ipNH][ipNHP] += NH_COP_CO_NHP_2;
			bvec[ipNHP] += bvec_NH_COP_CO_NHP;

		/*  >>refer   molecule   NH     +  N2+   =>   N2    +     NH+   UMIST  */

			c[ipN2P][ipNH] -= NH_N2P_N2_NHP_1;
			c[ipNH][ipNH] -= NH_N2P_N2_NHP_2;
			bvec[ipNH] -= bvec_NH_N2P_N2_NHP;
			
			c[ipN2P][ipN2P] -= NH_N2P_N2_NHP_1;
			c[ipNH][ipN2P] -= NH_N2P_N2_NHP_2;
			bvec[ipN2P] -= bvec_NH_N2P_N2_NHP;
			
			c[ipN2P][ipN2] += NH_N2P_N2_NHP_1;
			c[ipNH][ipN2] += NH_N2P_N2_NHP_2;
			bvec[ipN2] += bvec_NH_N2P_N2_NHP;
			
			c[ipN2P][ipNHP] += NH_N2P_N2_NHP_1;
			c[ipNH][ipNHP] += NH_N2P_N2_NHP_2;
			bvec[ipNHP] += bvec_NH_N2P_N2_NHP;

		/*  >>refer   molecule   NH+    +  NO    =>   NO+   +     NH    UMIST  */

			c[ipNO][ipNHP] -= NHP_NO_NOP_NH_1;
			c[ipNHP][ipNHP] -= NHP_NO_NOP_NH_2;
			bvec[ipNHP] -= bvec_NHP_NO_NOP_NH;
			
			c[ipNO][ipNO] -= NHP_NO_NOP_NH_1;
			c[ipNHP][ipNO] -= NHP_NO_NOP_NH_2;
			bvec[ipNO] -= bvec_NHP_NO_NOP_NH;
			
			c[ipNO][ipNOP] += NHP_NO_NOP_NH_1;
			c[ipNHP][ipNOP] += NHP_NO_NOP_NH_2;
			bvec[ipNOP] += bvec_NHP_NO_NOP_NH;
			
			c[ipNO][ipNH] += NHP_NO_NOP_NH_1;
			c[ipNHP][ipNH] += NHP_NO_NOP_NH_2;
			bvec[ipNH] += bvec_NHP_NO_NOP_NH;

		/*  >>refer   molecule   NH+    +  O2    =>   O2+   +     NH    UMIST  */

			c[ipO2][ipNHP] -= NHP_O2_O2P_NH_1;
			c[ipNHP][ipNHP] -= NHP_O2_O2P_NH_2;
			bvec[ipNHP] -= bvec_NHP_O2_O2P_NH;
			
			c[ipO2][ipO2] -= NHP_O2_O2P_NH_1;
			c[ipNHP][ipO2] -= NHP_O2_O2P_NH_2;
			bvec[ipO2] -= bvec_NHP_O2_O2P_NH;
			
			c[ipO2][ipO2P] += NHP_O2_O2P_NH_1;
			c[ipNHP][ipO2P] += NHP_O2_O2P_NH_2;
			bvec[ipO2P] += bvec_NHP_O2_O2P_NH;
			
			c[ipO2][ipNH] += NHP_O2_O2P_NH_1;
			c[ipNHP][ipNH] += NHP_O2_O2P_NH_2;
			bvec[ipNH] += bvec_NHP_O2_O2P_NH;

		/*  >>refer   molecule   NH+    +  S     =>   S+    +     NH    UMIST  */
			
			c[ipATS][ipNHP] -= NHP_S_SP_NH_1;
			c[ipNHP][ipNHP] -= NHP_S_SP_NH_2;
			bvec[ipNHP] -= bvec_NHP_S_SP_NH;
			
			c[ipATS][ipSP] += NHP_S_SP_NH_1;
			c[ipNHP][ipSP] += NHP_S_SP_NH_2;
			bvec[ipSP] += bvec_NHP_S_SP_NH;
			
			c[ipATS][ipNH] += NHP_S_SP_NH_1;
			c[ipNHP][ipNH] += NHP_S_SP_NH_2;
			bvec[ipNH] += bvec_NHP_S_SP_NH;

		/*  >>refer   molecule   CH3+   +  NO    =>   NO+   +     CH3   UMIST  */

			c[ipNO][ipCH3P] -= CH3P_NO_NOP_CH3_1;
			c[ipCH3P][ipCH3P] -= CH3P_NO_NOP_CH3_2;
			bvec[ipCH3P] -= bvec_CH3P_NO_NOP_CH3;
			
			c[ipNO][ipNO] -= CH3P_NO_NOP_CH3_1;
			c[ipCH3P][ipNO] -= CH3P_NO_NOP_CH3_2;
			bvec[ipNO] -= bvec_CH3P_NO_NOP_CH3;
			
			c[ipNO][ipNOP] += CH3P_NO_NOP_CH3_1;
			c[ipCH3P][ipNOP] += CH3P_NO_NOP_CH3_2;
			bvec[ipNOP] += bvec_CH3P_NO_NOP_CH3;
			
			c[ipNO][ipCH3] += CH3P_NO_NOP_CH3_1;
			c[ipCH3P][ipCH3] += CH3P_NO_NOP_CH3_2;
			bvec[ipCH3] += bvec_CH3P_NO_NOP_CH3;

		/*  >>refer   molecule   O+     +  NH2   =>   NH2+  +     O     UMIST  */

			c[ipNH2][ipOP] -= OP_NH2_NH2P_O_1;
			c[ipOP][ipOP] -= OP_NH2_NH2P_O_2;
			bvec[ipOP] -= bvec_OP_NH2_NH2P_O;
			
			c[ipNH2][ipNH2] -= OP_NH2_NH2P_O_1;
			c[ipOP][ipNH2] -= OP_NH2_NH2P_O_2;
			bvec[ipNH2] -= bvec_OP_NH2_NH2P_O;
			
			c[ipNH2][ipNH2P] += OP_NH2_NH2P_O_1;
			c[ipOP][ipNH2P] += OP_NH2_NH2P_O_2;
			bvec[ipNH2P] += bvec_OP_NH2_NH2P_O;
			
		/*  >>refer   molecule   O+     +  NH3   =>   NH3+  +     O     UMIST  */

			c[ipNH3][ipOP] -= OP_NH3_NH3P_O_1;
			c[ipOP][ipOP] -= OP_NH3_NH3P_O_2;
			bvec[ipOP] -= bvec_OP_NH3_NH3P_O;
			
			c[ipNH3][ipNH3] -= OP_NH3_NH3P_O_1;
			c[ipOP][ipNH3] -= OP_NH3_NH3P_O_2;
			bvec[ipNH3] -= bvec_OP_NH3_NH3P_O;
			
			c[ipNH3][ipNH3P] += OP_NH3_NH3P_O_1;
			c[ipOP][ipNH3P] += OP_NH3_NH3P_O_2;
			bvec[ipNH3P] += bvec_OP_NH3_NH3P_O;
			
		/*  >>refer   molecule   O      +  CN+   =>   CN    +     O+    UMIST  */

			c[ipCNP][ipCNP] -= O_CNP_CN_OP_1;
			c[ipATO][ipCNP] -= O_CNP_CN_OP_2;
			bvec[ipCNP] -= bvec_O_CNP_CN_OP;
			
			c[ipCNP][ipCN] += O_CNP_CN_OP_1;
			c[ipATO][ipCN] += O_CNP_CN_OP_2;
			bvec[ipCN] += bvec_O_CNP_CN_OP;
			
			c[ipCNP][ipOP] += O_CNP_CN_OP_1;
			c[ipATO][ipOP] += O_CNP_CN_OP_2;
			bvec[ipOP] += bvec_O_CNP_CN_OP;

		/*  >>refer   molecule   O      +  HCN+  =>   HCN   +     O+    UMIST  */

			c[ipHCNP][ipHCNP] -= O_HCNP_HCN_OP_1;
			c[ipATO][ipHCNP] -= O_HCNP_HCN_OP_2;
			bvec[ipHCNP] -= bvec_O_HCNP_HCN_OP;
			
			c[ipHCNP][ipHCN] += O_HCNP_HCN_OP_1;
			c[ipATO][ipHCN] += O_HCNP_HCN_OP_2;
			bvec[ipHCN] += bvec_O_HCNP_HCN_OP;
			
			c[ipHCNP][ipOP] += O_HCNP_HCN_OP_1;
			c[ipATO][ipOP] += O_HCNP_HCN_OP_2;
			bvec[ipOP] += bvec_O_HCNP_HCN_OP;

		/*  >>refer   molecule   O      +  N2+   =>   N2    +     O+    UMIST  */

			c[ipN2P][ipN2P] -= O_N2P_N2_OP_1;
			c[ipATO][ipN2P] -= O_N2P_N2_OP_2;
			bvec[ipN2P] -= bvec_O_N2P_N2_OP;
			
			c[ipN2P][ipN2] += O_N2P_N2_OP_1;
			c[ipATO][ipN2] += O_N2P_N2_OP_2;
			bvec[ipN2] += bvec_O_N2P_N2_OP;
			
			c[ipN2P][ipOP] += O_N2P_N2_OP_1;
			c[ipATO][ipOP] += O_N2P_N2_OP_2;
			bvec[ipOP] += bvec_O_N2P_N2_OP;

		/*  >>refer   molecule   O+     +  NO    =>   NO+   +     O     UMIST  */

			c[ipNO][ipOP] -= OP_NO_NOP_O_1;
			c[ipOP][ipOP] -= OP_NO_NOP_O_2;
			bvec[ipOP] -= bvec_OP_NO_NOP_O;
			
			c[ipNO][ipNO] -= OP_NO_NOP_O_1;
			c[ipOP][ipNO] -= OP_NO_NOP_O_2;
			bvec[ipNO] -= bvec_OP_NO_NOP_O;
			
			c[ipNO][ipNOP] += OP_NO_NOP_O_1;
			c[ipOP][ipNOP] += OP_NO_NOP_O_2;
			bvec[ipNOP] += bvec_OP_NO_NOP_O;
			
		/*  >>refer   molecule   O+     +  OCS   =>   OCS+  +     O     UMIST  */

			c[ipOCS][ipOP] -= OP_OCS_OCSP_O_1;
			c[ipOP][ipOP] -= OP_OCS_OCSP_O_2;
			bvec[ipOP] -= bvec_OP_OCS_OCSP_O;
			
			c[ipOCS][ipOCS] -= OP_OCS_OCSP_O_1;
			c[ipOP][ipOCS] -= OP_OCS_OCSP_O_2;
			bvec[ipOCS] -= bvec_OP_OCS_OCSP_O;
			
			c[ipOCS][ipOCSP] += OP_OCS_OCSP_O_1;
			c[ipOP][ipOCSP] += OP_OCS_OCSP_O_2;
			bvec[ipOCSP] += bvec_OP_OCS_OCSP_O;

		/*  >>refer   molecule   NH2    +  OH+   =>   OH    +     NH2+  UMIST  */

			c[ipOHP][ipNH2] -= NH2_OHP_OH_NH2P_1;
			c[ipNH2][ipNH2] -= NH2_OHP_OH_NH2P_2;
			bvec[ipNH2] -= bvec_NH2_OHP_OH_NH2P;
			
			c[ipOHP][ipOHP] -= NH2_OHP_OH_NH2P_1;
			c[ipNH2][ipOHP] -= NH2_OHP_OH_NH2P_2;
			bvec[ipOHP] -= bvec_NH2_OHP_OH_NH2P;
			
			c[ipOHP][ipOH] += NH2_OHP_OH_NH2P_1;
			c[ipNH2][ipOH] += NH2_OHP_OH_NH2P_2;
			bvec[ipOH] += bvec_NH2_OHP_OH_NH2P;
			
			c[ipOHP][ipNH2P] += NH2_OHP_OH_NH2P_1;
			c[ipNH2][ipNH2P] += NH2_OHP_OH_NH2P_2;
			bvec[ipNH2P] += bvec_NH2_OHP_OH_NH2P;

		/*  >>refer   molecule   NH2+   +  NH3   =>   NH3+  +     NH2   UMIST  */

			c[ipNH3][ipNH2P] -= NH2P_NH3_NH3P_NH2_1;
			c[ipNH2P][ipNH2P] -= NH2P_NH3_NH3P_NH2_2;
			bvec[ipNH2P] -= bvec_NH2P_NH3_NH3P_NH2;
			
			c[ipNH3][ipNH3] -= NH2P_NH3_NH3P_NH2_1;
			c[ipNH2P][ipNH3] -= NH2P_NH3_NH3P_NH2_2;
			bvec[ipNH3] -= bvec_NH2P_NH3_NH3P_NH2;
			
			c[ipNH3][ipNH3P] += NH2P_NH3_NH3P_NH2_1;
			c[ipNH2P][ipNH3P] += NH2P_NH3_NH3P_NH2_2;
			bvec[ipNH3P] += bvec_NH2P_NH3_NH3P_NH2;
			
			c[ipNH3][ipNH2] += NH2P_NH3_NH3P_NH2_1;
			c[ipNH2P][ipNH2] += NH2P_NH3_NH3P_NH2_2;
			bvec[ipNH2] += bvec_NH2P_NH3_NH3P_NH2;

		/*  >>refer   molecule   NH2    +  H2O+  =>   H2O   +     NH2+  UMIST  */

			c[ipH2OP][ipNH2] -= NH2_H2OP_H2O_NH2P_1;
			c[ipNH2][ipNH2] -= NH2_H2OP_H2O_NH2P_2;
			bvec[ipNH2] -= bvec_NH2_H2OP_H2O_NH2P;
			
			c[ipH2OP][ipH2OP] -= NH2_H2OP_H2O_NH2P_1;
			c[ipNH2][ipH2OP] -= NH2_H2OP_H2O_NH2P_2;
			bvec[ipH2OP] -= bvec_NH2_H2OP_H2O_NH2P;
			
			c[ipH2OP][ipH2O] += NH2_H2OP_H2O_NH2P_1;
			c[ipNH2][ipH2O] += NH2_H2OP_H2O_NH2P_2;
			bvec[ipH2O] += bvec_NH2_H2OP_H2O_NH2P;
			
			c[ipH2OP][ipNH2P] += NH2_H2OP_H2O_NH2P_1;
			c[ipNH2][ipNH2P] += NH2_H2OP_H2O_NH2P_2;
			bvec[ipNH2P] += bvec_NH2_H2OP_H2O_NH2P;

		/*  >>refer   molecule   NH2    +  CN+   =>   CN    +     NH2+  UMIST  */

			c[ipCNP][ipNH2] -= NH2_CNP_CN_NH2P_1;
			c[ipNH2][ipNH2] -= NH2_CNP_CN_NH2P_2;
			bvec[ipNH2] -= bvec_NH2_CNP_CN_NH2P;
			
			c[ipCNP][ipCNP] -= NH2_CNP_CN_NH2P_1;
			c[ipNH2][ipCNP] -= NH2_CNP_CN_NH2P_2;
			bvec[ipCNP] -= bvec_NH2_CNP_CN_NH2P;
			
			c[ipCNP][ipCN] += NH2_CNP_CN_NH2P_1;
			c[ipNH2][ipCN] += NH2_CNP_CN_NH2P_2;
			bvec[ipCN] += bvec_NH2_CNP_CN_NH2P;
			
			c[ipCNP][ipNH2P] += NH2_CNP_CN_NH2P_1;
			c[ipNH2][ipNH2P] += NH2_CNP_CN_NH2P_2;
			bvec[ipNH2P] += bvec_NH2_CNP_CN_NH2P;

		/*  >>refer   molecule   NH2    +  CO+   =>   CO    +     NH2+  UMIST  */

			c[ipCOP][ipNH2] -= NH2_COP_CO_NH2P_1;
			c[ipNH2][ipNH2] -= NH2_COP_CO_NH2P_2;
			bvec[ipNH2] -= bvec_NH2_COP_CO_NH2P;
			
			c[ipCOP][ipCOP] -= NH2_COP_CO_NH2P_1;
			c[ipNH2][ipCOP] -= NH2_COP_CO_NH2P_2;
			bvec[ipCOP] -= bvec_NH2_COP_CO_NH2P;
			
			c[ipCOP][ipCO] += NH2_COP_CO_NH2P_1;
			c[ipNH2][ipCO] += NH2_COP_CO_NH2P_2;
			bvec[ipCO] += bvec_NH2_COP_CO_NH2P;
			
			c[ipCOP][ipNH2P] += NH2_COP_CO_NH2P_1;
			c[ipNH2][ipNH2P] += NH2_COP_CO_NH2P_2;
			bvec[ipNH2P] += bvec_NH2_COP_CO_NH2P;

		/*  >>refer   molecule   NH2    +  N2+   =>   N2    +     NH2+  UMIST  */

			c[ipN2P][ipNH2] -= NH2_N2P_N2_NH2P_1;
			c[ipNH2][ipNH2] -= NH2_N2P_N2_NH2P_2;
			bvec[ipNH2] -= bvec_NH2_N2P_N2_NH2P;
			
			c[ipN2P][ipN2P] -= NH2_N2P_N2_NH2P_1;
			c[ipNH2][ipN2P] -= NH2_N2P_N2_NH2P_2;
			bvec[ipN2P] -= bvec_NH2_N2P_N2_NH2P;
			
			c[ipN2P][ipN2] += NH2_N2P_N2_NH2P_1;
			c[ipNH2][ipN2] += NH2_N2P_N2_NH2P_2;
			bvec[ipN2] += bvec_NH2_N2P_N2_NH2P;
			
			c[ipN2P][ipNH2P] += NH2_N2P_N2_NH2P_1;
			c[ipNH2][ipNH2P] += NH2_N2P_N2_NH2P_2;
			bvec[ipNH2P] += bvec_NH2_N2P_N2_NH2P;

		/*  >>refer   molecule   NH2+   +  NO    =>   NO+   +     NH2   UMIST  */

			c[ipNO][ipNH2P] -= NH2P_NO_NOP_NH2_1;
			c[ipNH2P][ipNH2P] -= NH2P_NO_NOP_NH2_2;
			bvec[ipNH2P] -= bvec_NH2P_NO_NOP_NH2;
			
			c[ipNO][ipNO] -= NH2P_NO_NOP_NH2_1;
			c[ipNH2P][ipNO] -= NH2P_NO_NOP_NH2_2;
			bvec[ipNO] -= bvec_NH2P_NO_NOP_NH2;
			
			c[ipNO][ipNOP] += NH2P_NO_NOP_NH2_1;
			c[ipNH2P][ipNOP] += NH2P_NO_NOP_NH2_2;
			bvec[ipNOP] += bvec_NH2P_NO_NOP_NH2;
			
			c[ipNO][ipNH2] += NH2P_NO_NOP_NH2_1;
			c[ipNH2P][ipNH2] += NH2P_NO_NOP_NH2_2;
			bvec[ipNH2] += bvec_NH2P_NO_NOP_NH2;

		/*  >>refer   molecule   NH2    +  O2+   =>   O2    +     NH2+  UMIST  */

			c[ipO2P][ipNH2] -= NH2_O2P_O2_NH2P_1;
			c[ipNH2][ipNH2] -= NH2_O2P_O2_NH2P_2;
			bvec[ipNH2] -= bvec_NH2_O2P_O2_NH2P;
			
			c[ipO2P][ipO2P] -= NH2_O2P_O2_NH2P_1;
			c[ipNH2][ipO2P] -= NH2_O2P_O2_NH2P_2;
			bvec[ipO2P] -= bvec_NH2_O2P_O2_NH2P;
			
			c[ipO2P][ipO2] += NH2_O2P_O2_NH2P_1;
			c[ipNH2][ipO2] += NH2_O2P_O2_NH2P_2;
			bvec[ipO2] += bvec_NH2_O2P_O2_NH2P;
			
			c[ipO2P][ipNH2P] += NH2_O2P_O2_NH2P_1;
			c[ipNH2][ipNH2P] += NH2_O2P_O2_NH2P_2;
			bvec[ipNH2P] += bvec_NH2_O2P_O2_NH2P;

		/*  >>refer   molecule   NH2+   +  S     =>   S+    +     NH2   UMIST  */

			c[ipATS][ipNH2P] -= NH2P_S_SP_NH2_1;
			c[ipNH2P][ipNH2P] -= NH2P_S_SP_NH2_2;
			bvec[ipNH2P] -= bvec_NH2P_S_SP_NH2;
			
			c[ipATS][ipSP] += NH2P_S_SP_NH2_1;
			c[ipNH2P][ipSP] += NH2P_S_SP_NH2_2;
			bvec[ipSP] += bvec_NH2P_S_SP_NH2;
			
			c[ipATS][ipNH2] += NH2P_S_SP_NH2_1;
			c[ipNH2P][ipNH2] += NH2P_S_SP_NH2_2;
			bvec[ipNH2] += bvec_NH2P_S_SP_NH2;

		/*  >>refer   molecule   CH4+   +  NH3   =>   NH3+  +     CH4   UMIST  */

			c[ipNH3][ipCH4P] -= CH4P_NH3_NH3P_CH4_1;
			c[ipCH4P][ipCH4P] -= CH4P_NH3_NH3P_CH4_2;
			bvec[ipCH4P] -= bvec_CH4P_NH3_NH3P_CH4;
			
			c[ipNH3][ipNH3] -= CH4P_NH3_NH3P_CH4_1;
			c[ipCH4P][ipNH3] -= CH4P_NH3_NH3P_CH4_2;
			bvec[ipNH3] -= bvec_CH4P_NH3_NH3P_CH4;
			
			c[ipNH3][ipNH3P] += CH4P_NH3_NH3P_CH4_1;
			c[ipCH4P][ipNH3P] += CH4P_NH3_NH3P_CH4_2;
			bvec[ipNH3P] += bvec_CH4P_NH3_NH3P_CH4;
			
			c[ipNH3][ipCH4] += CH4P_NH3_NH3P_CH4_1;
			c[ipCH4P][ipCH4] += CH4P_NH3_NH3P_CH4_2;
			bvec[ipCH4] += bvec_CH4P_NH3_NH3P_CH4;

		/*  >>refer   molecule   CH4+   +  OCS   =>   OCS+  +     CH4   UMIST  */

			c[ipOCS][ipCH4P] -= CH4P_OCS_OCSP_CH4_1;
			c[ipCH4P][ipCH4P] -= CH4P_OCS_OCSP_CH4_2;
			bvec[ipCH4P] -= bvec_CH4P_OCS_OCSP_CH4;
			
			c[ipOCS][ipOCS] -= CH4P_OCS_OCSP_CH4_1;
			c[ipCH4P][ipOCS] -= CH4P_OCS_OCSP_CH4_2;
			bvec[ipOCS] -= bvec_CH4P_OCS_OCSP_CH4;
			
			c[ipOCS][ipOCSP] += CH4P_OCS_OCSP_CH4_1;
			c[ipCH4P][ipOCSP] += CH4P_OCS_OCSP_CH4_2;
			bvec[ipOCSP] += bvec_CH4P_OCS_OCSP_CH4;
			
			c[ipOCS][ipCH4] += CH4P_OCS_OCSP_CH4_1;
			c[ipCH4P][ipCH4] += CH4P_OCS_OCSP_CH4_2;
			bvec[ipCH4] += bvec_CH4P_OCS_OCSP_CH4;

		/*  >>refer   molecule   OH+    +  NH3   =>   NH3+  +     OH    UMIST  */

			c[ipNH3][ipOHP] -= OHP_NH3_NH3P_OH_1;
			c[ipOHP][ipOHP] -= OHP_NH3_NH3P_OH_2;
			bvec[ipOHP] -= bvec_OHP_NH3_NH3P_OH;
			
			c[ipNH3][ipNH3] -= OHP_NH3_NH3P_OH_1;
			c[ipOHP][ipNH3] -= OHP_NH3_NH3P_OH_2;
			bvec[ipNH3] -= bvec_OHP_NH3_NH3P_OH;
			
			c[ipNH3][ipNH3P] += OHP_NH3_NH3P_OH_1;
			c[ipOHP][ipNH3P] += OHP_NH3_NH3P_OH_2;
			bvec[ipNH3P] += bvec_OHP_NH3_NH3P_OH;
			
			c[ipNH3][ipOH] += OHP_NH3_NH3P_OH_1;
			c[ipOHP][ipOH] += OHP_NH3_NH3P_OH_2;
			bvec[ipOH] += bvec_OHP_NH3_NH3P_OH;

		/*  >>refer   molecule   OH     +  CN+   =>   CN    +     OH+   UMIST  */

			c[ipCNP][ipOH] -= OH_CNP_CN_OHP_1;
			c[ipOH][ipOH] -= OH_CNP_CN_OHP_2;
			bvec[ipOH] -= bvec_OH_CNP_CN_OHP;
			
			c[ipCNP][ipCNP] -= OH_CNP_CN_OHP_1;
			c[ipOH][ipCNP] -= OH_CNP_CN_OHP_2;
			bvec[ipCNP] -= bvec_OH_CNP_CN_OHP;
			
			c[ipCNP][ipCN] += OH_CNP_CN_OHP_1;
			c[ipOH][ipCN] += OH_CNP_CN_OHP_2;
			bvec[ipCN] += bvec_OH_CNP_CN_OHP;
			
			c[ipCNP][ipOHP] += OH_CNP_CN_OHP_1;
			c[ipOH][ipOHP] += OH_CNP_CN_OHP_2;
			bvec[ipOHP] += bvec_OH_CNP_CN_OHP;

		/*  >>refer   molecule   OH     +  N2+   =>   N2    +     OH+   UMIST  */

			c[ipN2P][ipOH] -= OH_N2P_N2_OHP_1;
			c[ipOH][ipOH] -= OH_N2P_N2_OHP_2;
			bvec[ipOH] -= bvec_OH_N2P_N2_OHP;
			
			c[ipN2P][ipN2P] -= OH_N2P_N2_OHP_1;
			c[ipOH][ipN2P] -= OH_N2P_N2_OHP_2;
			bvec[ipN2P] -= bvec_OH_N2P_N2_OHP;
			
			c[ipN2P][ipN2] += OH_N2P_N2_OHP_1;
			c[ipOH][ipN2] += OH_N2P_N2_OHP_2;
			bvec[ipN2] += bvec_OH_N2P_N2_OHP;
			
			c[ipN2P][ipOHP] += OH_N2P_N2_OHP_1;
			c[ipOH][ipOHP] += OH_N2P_N2_OHP_2;
			bvec[ipOHP] += bvec_OH_N2P_N2_OHP;

		/*  >>refer   molecule   OH+    +  NO    =>   NO+   +     OH    UMIST  */

			c[ipNO][ipOHP] -= OHP_NO_NOP_OH_1;
			c[ipOHP][ipOHP] -= OHP_NO_NOP_OH_2;
			bvec[ipOHP] -= bvec_OHP_NO_NOP_OH;
			
			c[ipNO][ipNO] -= OHP_NO_NOP_OH_1;
			c[ipOHP][ipNO] -= OHP_NO_NOP_OH_2;
			bvec[ipNO] -= bvec_OHP_NO_NOP_OH;
			
			c[ipNO][ipNOP] += OHP_NO_NOP_OH_1;
			c[ipOHP][ipNOP] += OHP_NO_NOP_OH_2;
			bvec[ipNOP] += bvec_OHP_NO_NOP_OH;
			
			c[ipNO][ipOH] += OHP_NO_NOP_OH_1;
			c[ipOHP][ipOH] += OHP_NO_NOP_OH_2;
			bvec[ipOH] += bvec_OHP_NO_NOP_OH;

		/*  >>refer   molecule   NH3    +  H2O+  =>   H2O   +     NH3+  UMIST  */

			c[ipH2OP][ipNH3] -= NH3_H2OP_H2O_NH3P_1;
			c[ipNH3][ipNH3] -= NH3_H2OP_H2O_NH3P_2;
			bvec[ipNH3] -= bvec_NH3_H2OP_H2O_NH3P;
			
			c[ipH2OP][ipH2OP] -= NH3_H2OP_H2O_NH3P_1;
			c[ipNH3][ipH2OP] -= NH3_H2OP_H2O_NH3P_2;
			bvec[ipH2OP] -= bvec_NH3_H2OP_H2O_NH3P;
			
			c[ipH2OP][ipH2O] += NH3_H2OP_H2O_NH3P_1;
			c[ipNH3][ipH2O] += NH3_H2OP_H2O_NH3P_2;
			bvec[ipH2O] += bvec_NH3_H2OP_H2O_NH3P;
			
			c[ipH2OP][ipNH3P] += NH3_H2OP_H2O_NH3P_1;
			c[ipNH3][ipNH3P] += NH3_H2OP_H2O_NH3P_2;
			bvec[ipNH3P] += bvec_NH3_H2OP_H2O_NH3P;

		/*  >>refer   molecule   NH3    +  HCN+  =>   HCN   +     NH3+  UMIST  */

			c[ipHCNP][ipNH3] -= NH3_HCNP_HCN_NH3P_1;
			c[ipNH3][ipNH3] -= NH3_HCNP_HCN_NH3P_2;
			bvec[ipNH3] -= bvec_NH3_HCNP_HCN_NH3P;
			
			c[ipHCNP][ipHCNP] -= NH3_HCNP_HCN_NH3P_1;
			c[ipNH3][ipHCNP] -= NH3_HCNP_HCN_NH3P_2;
			bvec[ipHCNP] -= bvec_NH3_HCNP_HCN_NH3P;
			
			c[ipHCNP][ipHCN] += NH3_HCNP_HCN_NH3P_1;
			c[ipNH3][ipHCN] += NH3_HCNP_HCN_NH3P_2;
			bvec[ipHCN] += bvec_NH3_HCNP_HCN_NH3P;
			
			c[ipHCNP][ipNH3P] += NH3_HCNP_HCN_NH3P_1;
			c[ipNH3][ipNH3P] += NH3_HCNP_HCN_NH3P_2;
			bvec[ipNH3P] += bvec_NH3_HCNP_HCN_NH3P;

		/*  >>refer   molecule   NH3    +  CO+   =>   CO    +     NH3+  UMIST  */

			c[ipCOP][ipNH3] -= NH3_COP_CO_NH3P_1;
			c[ipNH3][ipNH3] -= NH3_COP_CO_NH3P_2;
			bvec[ipNH3] -= bvec_NH3_COP_CO_NH3P;
			
			c[ipCOP][ipCOP] -= NH3_COP_CO_NH3P_1;
			c[ipNH3][ipCOP] -= NH3_COP_CO_NH3P_2;
			bvec[ipCOP] -= bvec_NH3_COP_CO_NH3P;
			
			c[ipCOP][ipCO] += NH3_COP_CO_NH3P_1;
			c[ipNH3][ipCO] += NH3_COP_CO_NH3P_2;
			bvec[ipCO] += bvec_NH3_COP_CO_NH3P;
			
			c[ipCOP][ipNH3P] += NH3_COP_CO_NH3P_1;
			c[ipNH3][ipNH3P] += NH3_COP_CO_NH3P_2;
			bvec[ipNH3P] += bvec_NH3_COP_CO_NH3P;

		/*  >>refer   molecule   NH3    +  N2+   =>   N2    +     NH3+  UMIST  */

			c[ipN2P][ipNH3] -= NH3_N2P_N2_NH3P_1;
			c[ipNH3][ipNH3] -= NH3_N2P_N2_NH3P_2;
			bvec[ipNH3] -= bvec_NH3_N2P_N2_NH3P;
			
			c[ipN2P][ipN2P] -= NH3_N2P_N2_NH3P_1;
			c[ipNH3][ipN2P] -= NH3_N2P_N2_NH3P_2;
			bvec[ipN2P] -= bvec_NH3_N2P_N2_NH3P;
			
			c[ipN2P][ipN2] += NH3_N2P_N2_NH3P_1;
			c[ipNH3][ipN2] += NH3_N2P_N2_NH3P_2;
			bvec[ipN2] += bvec_NH3_N2P_N2_NH3P;
			
			c[ipN2P][ipNH3P] += NH3_N2P_N2_NH3P_1;
			c[ipNH3][ipNH3P] += NH3_N2P_N2_NH3P_2;
			bvec[ipNH3P] += bvec_NH3_N2P_N2_NH3P;

		/*  >>refer   molecule   NH3+   +  SI    =>   SI+   +     NH3   UMIST  */

			c[ipATSI][ipNH3P] -= NH3P_SI_SIP_NH3_1;
			c[ipNH3P][ipNH3P] -= NH3P_SI_SIP_NH3_2;
			bvec[ipNH3P] -= bvec_NH3P_SI_SIP_NH3;
			
			c[ipATSI][ipSIP] += NH3P_SI_SIP_NH3_1;
			c[ipNH3P][ipSIP] += NH3P_SI_SIP_NH3_2;
			bvec[ipSIP] += bvec_NH3P_SI_SIP_NH3;
			
			c[ipATSI][ipNH3] += NH3P_SI_SIP_NH3_1;
			c[ipNH3P][ipNH3] += NH3P_SI_SIP_NH3_2;
			bvec[ipNH3] += bvec_NH3P_SI_SIP_NH3;

		/*  >>refer   molecule   NH3+   +  NO    =>   NO+   +     NH3   UMIST  */

			c[ipNO][ipNH3P] -= NH3P_SI_SIP_NH3_1;
			c[ipNH3P][ipNH3P] -= NH3P_SI_SIP_NH3_2;
			bvec[ipNH3P] -= bvec_NH3P_SI_SIP_NH3;
			
			c[ipNO][ipNO] -= NH3P_SI_SIP_NH3_1;
			c[ipNH3P][ipNO] -= NH3P_SI_SIP_NH3_2;
			bvec[ipNO] -= bvec_NH3P_SI_SIP_NH3;
			
			c[ipNO][ipNOP] += NH3P_SI_SIP_NH3_1;
			c[ipNH3P][ipNOP] += NH3P_SI_SIP_NH3_2;
			bvec[ipNOP] += bvec_NH3P_SI_SIP_NH3;
			
			c[ipNO][ipNH3] += NH3P_SI_SIP_NH3_1;
			c[ipNH3P][ipNH3] += NH3P_SI_SIP_NH3_2;
			bvec[ipNH3] += bvec_NH3P_SI_SIP_NH3;

		/*  >>refer   molecule   NH3    +  O2+   =>   O2    +     NH3+  UMIST  */

			c[ipO2P][ipNH3] -= NH3_O2P_O2_NH3P_1;
			c[ipNH3][ipNH3] -= NH3_O2P_O2_NH3P_2;
			bvec[ipNH3] -= bvec_NH3_O2P_O2_NH3P;
			
			c[ipO2P][ipO2P] -= NH3_O2P_O2_NH3P_1;
			c[ipNH3][ipO2P] -= NH3_O2P_O2_NH3P_2;
			bvec[ipO2P] -= bvec_NH3_O2P_O2_NH3P;
			
			c[ipO2P][ipO2] += NH3_O2P_O2_NH3P_1;
			c[ipNH3][ipO2] += NH3_O2P_O2_NH3P_2;
			bvec[ipO2] += bvec_NH3_O2P_O2_NH3P;
			
			c[ipO2P][ipNH3P] += NH3_O2P_O2_NH3P_1;
			c[ipNH3][ipNH3P] += NH3_O2P_O2_NH3P_2;
			bvec[ipNH3P] += bvec_NH3_O2P_O2_NH3P;

		/*  >>refer   molecule   NH3    +  S+    =>   S     +     NH3+  UMIST  */

			c[ipSP][ipNH3] -= NH3_SP_S_NH3P_1;
			c[ipNH3][ipNH3] -= NH3_SP_S_NH3P_2;
			bvec[ipNH3] -= bvec_NH3_SP_S_NH3P;
			
			c[ipSP][ipSP] -= NH3_SP_S_NH3P_1;
			c[ipNH3][ipSP] -= NH3_SP_S_NH3P_2;
			bvec[ipSP] -= bvec_NH3_SP_S_NH3P;
			
			c[ipSP][ipNH3P] += NH3_SP_S_NH3P_1;
			c[ipNH3][ipNH3P] += NH3_SP_S_NH3P_2;
			bvec[ipNH3P] += bvec_NH3_SP_S_NH3P;
			
		/*  >>refer   molecule   NH3    +  HS+   =>   HS    +     NH3+  UMIST  */

			c[ipHSP][ipNH3] -= NH3_HSP_HS_NH3P_1;
			c[ipNH3][ipNH3] -= NH3_HSP_HS_NH3P_2;
			bvec[ipNH3] -= bvec_NH3_HSP_HS_NH3P;
			
			c[ipHSP][ipHSP] -= NH3_HSP_HS_NH3P_1;
			c[ipNH3][ipHSP] -= NH3_HSP_HS_NH3P_2;
			bvec[ipHSP] -= bvec_NH3_HSP_HS_NH3P;
			
			c[ipHSP][ipHS] += NH3_HSP_HS_NH3P_1;
			c[ipNH3][ipHS] += NH3_HSP_HS_NH3P_2;
			bvec[ipHS] += bvec_NH3_HSP_HS_NH3P;
			
			c[ipHSP][ipNH3P] += NH3_HSP_HS_NH3P_1;
			c[ipNH3][ipNH3P] += NH3_HSP_HS_NH3P_2;
			bvec[ipNH3P] += bvec_NH3_HSP_HS_NH3P;

		/*  >>refer   molecule   NH3    +  SO+   =>   SO    +     NH3+  UMIST  */

			c[ipSOP][ipNH3] -= NH3_SOP_SO_NH3P_1;
			c[ipNH3][ipNH3] -= NH3_SOP_SO_NH3P_2;
			bvec[ipNH3] -= bvec_NH3_SOP_SO_NH3P;
			
			c[ipSOP][ipSOP] -= NH3_SOP_SO_NH3P_1;
			c[ipNH3][ipSOP] -= NH3_SOP_SO_NH3P_2;
			bvec[ipSOP] -= bvec_NH3_SOP_SO_NH3P;
			
			c[ipSOP][ipSO] += NH3_SOP_SO_NH3P_1;
			c[ipNH3][ipSO] += NH3_SOP_SO_NH3P_2;
			bvec[ipSO] += bvec_NH3_SOP_SO_NH3P;
			
			c[ipSOP][ipNH3P] += NH3_SOP_SO_NH3P_1;
			c[ipNH3][ipNH3P] += NH3_SOP_SO_NH3P_2;
			bvec[ipNH3P] += bvec_NH3_SOP_SO_NH3P;

		/*  >>refer   molecule   H2O    +  HCN+  =>   HCN   +     H2O+  UMIST  */

			c[ipHCNP][ipH2O] -= H2O_HCNP_HCN_H2OP_1;
			c[ipH2O][ipH2O] -= H2O_HCNP_HCN_H2OP_2;
			bvec[ipH2O] -= bvec_H2O_HCNP_HCN_H2OP;
			
			c[ipHCNP][ipHCNP] -= H2O_HCNP_HCN_H2OP_1;
			c[ipH2O][ipHCNP] -= H2O_HCNP_HCN_H2OP_2;
			bvec[ipHCNP] -= bvec_H2O_HCNP_HCN_H2OP;
			
			c[ipHCNP][ipHCN] += H2O_HCNP_HCN_H2OP_1;
			c[ipH2O][ipHCN] += H2O_HCNP_HCN_H2OP_2;
			bvec[ipHCN] += bvec_H2O_HCNP_HCN_H2OP;
			
			c[ipHCNP][ipH2OP] += H2O_HCNP_HCN_H2OP_1;
			c[ipH2O][ipH2OP] += H2O_HCNP_HCN_H2OP_2;
			bvec[ipH2OP] += bvec_H2O_HCNP_HCN_H2OP;

		/*  >>refer   molecule   H2O    +  N2+   =>   N2    +     H2O+  UMIST  */

			c[ipN2P][ipH2O] -= H2O_N2P_N2_H2OP_1;
			c[ipH2O][ipH2O] -= H2O_N2P_N2_H2OP_2;
			bvec[ipH2O] -= bvec_H2O_N2P_N2_H2OP;
			
			c[ipN2P][ipN2P] -= H2O_N2P_N2_H2OP_1;
			c[ipH2O][ipN2P] -= H2O_N2P_N2_H2OP_2;
			bvec[ipN2P] -= bvec_H2O_N2P_N2_H2OP;
			
			c[ipN2P][ipN2] += H2O_N2P_N2_H2OP_1;
			c[ipH2O][ipN2] += H2O_N2P_N2_H2OP_2;
			bvec[ipN2] += bvec_H2O_N2P_N2_H2OP;
			
			c[ipN2P][ipH2OP] += H2O_N2P_N2_H2OP_1;
			c[ipH2O][ipH2OP] += H2O_N2P_N2_H2OP_2;
			bvec[ipH2OP] += bvec_H2O_N2P_N2_H2OP;

		/*  >>refer   molecule   H2O+   +  NO    =>   NO+   +     H2O   UMIST  */

			c[ipNO][ipH2OP] -= H2OP_NO_NOP_H2O_1;
			c[ipH2OP][ipH2OP] -= H2OP_NO_NOP_H2O_2;
			bvec[ipH2OP] -= bvec_H2OP_NO_NOP_H2O;
			
			c[ipNO][ipNO] -= H2OP_NO_NOP_H2O_1;
			c[ipH2OP][ipNO] -= H2OP_NO_NOP_H2O_2;
			bvec[ipNO] -= bvec_H2OP_NO_NOP_H2O;
			
			c[ipNO][ipNOP] += H2OP_NO_NOP_H2O_1;
			c[ipH2OP][ipNOP] += H2OP_NO_NOP_H2O_2;
			bvec[ipNOP] += bvec_H2OP_NO_NOP_H2O;
			
			c[ipNO][ipH2O] += H2OP_NO_NOP_H2O_1;
			c[ipH2OP][ipH2O] += H2OP_NO_NOP_H2O_2;
			bvec[ipH2O] += bvec_H2OP_NO_NOP_H2O;

		/*  >>refer   molecule   CN+    +  HCN   =>   HCN+  +     CN    UMIST  */

			c[ipHCN][ipCNP] -= CNP_HCN_HCNP_CN_1;
			c[ipCNP][ipCNP] -= CNP_HCN_HCNP_CN_2;
			bvec[ipCNP] -= bvec_CNP_HCN_HCNP_CN;
			
			c[ipHCN][ipHCN] -= CNP_HCN_HCNP_CN_1;
			c[ipCNP][ipHCN] -= CNP_HCN_HCNP_CN_2;
			bvec[ipHCN] -= bvec_CNP_HCN_HCNP_CN;
			
			c[ipHCN][ipHCNP] += CNP_HCN_HCNP_CN_1;
			c[ipCNP][ipHCNP] += CNP_HCN_HCNP_CN_2;
			bvec[ipHCNP] += bvec_CNP_HCN_HCNP_CN;
			
			c[ipHCN][ipCN] += CNP_HCN_HCNP_CN_1;
			c[ipCNP][ipCN] += CNP_HCN_HCNP_CN_2;
			bvec[ipCN] += bvec_CNP_HCN_HCNP_CN;

		/*  >>refer   molecule   CN+    +  CO    =>   CO+   +     CN    UMIST  */

			c[ipCO][ipCNP] -= CNP_CO_COP_CN_1;
			c[ipCNP][ipCNP] -= CNP_CO_COP_CN_2;
			bvec[ipCNP] -= bvec_CNP_CO_COP_CN;
			
			c[ipCO][ipCO] -= CNP_CO_COP_CN_1;
			c[ipCNP][ipCO] -= CNP_CO_COP_CN_2;
			bvec[ipCO] -= bvec_CNP_CO_COP_CN;
			
			c[ipCO][ipCOP] += CNP_CO_COP_CN_1;
			c[ipCNP][ipCOP] += CNP_CO_COP_CN_2;
			bvec[ipCOP] += bvec_CNP_CO_COP_CN;
			
			c[ipCO][ipCN] += CNP_CO_COP_CN_1;
			c[ipCNP][ipCN] += CNP_CO_COP_CN_2;
			bvec[ipCN] += bvec_CNP_CO_COP_CN;

		/*  >>refer   molecule   CN     +  N2+   =>   N2    +     CN+   UMIST  */

			c[ipN2P][ipCN] -= CN_N2P_N2_CNP_1;
			c[ipCN][ipCN] -= CN_N2P_N2_CNP_2;
			bvec[ipCN] -= bvec_CN_N2P_N2_CNP;
			
			c[ipN2P][ipN2P] -= CN_N2P_N2_CNP_1;
			c[ipCN][ipN2P] -= CN_N2P_N2_CNP_2;
			bvec[ipN2P] -= bvec_CN_N2P_N2_CNP;
			
			c[ipN2P][ipN2] += CN_N2P_N2_CNP_1;
			c[ipCN][ipN2] += CN_N2P_N2_CNP_2;
			bvec[ipN2] += bvec_CN_N2P_N2_CNP;
			
			c[ipN2P][ipCNP] += CN_N2P_N2_CNP_1;
			c[ipCN][ipCNP] += CN_N2P_N2_CNP_2;
			bvec[ipCNP] += bvec_CN_N2P_N2_CNP;

		/*  >>refer   molecule   CN+    +  NO    =>   NO+   +     CN    UMIST  */

			c[ipNO][ipCNP] -= CNP_NO_NOP_CN_1;
			c[ipCNP][ipCNP] -= CNP_NO_NOP_CN_2;
			bvec[ipCNP] -= bvec_CNP_NO_NOP_CN;
			
			c[ipNO][ipNO] -= CNP_NO_NOP_CN_1;
			c[ipCNP][ipNO] -= CNP_NO_NOP_CN_2;
			bvec[ipNO] -= bvec_CNP_NO_NOP_CN;
			
			c[ipNO][ipNOP] += CNP_NO_NOP_CN_1;
			c[ipCNP][ipNOP] += CNP_NO_NOP_CN_2;
			bvec[ipNOP] += bvec_CNP_NO_NOP_CN;
			
			c[ipNO][ipCN] += CNP_NO_NOP_CN_1;
			c[ipCNP][ipCN] += CNP_NO_NOP_CN_2;
			bvec[ipCN] += bvec_CNP_NO_NOP_CN;

		/*  >>refer   molecule   CN+    +  O2    =>   O2+   +     CN    UMIST  */

			c[ipO2][ipCNP] -= CNP_O2_O2P_CN_1;
			c[ipCNP][ipCNP] -= CNP_O2_O2P_CN_2;
			bvec[ipCNP] -= bvec_CNP_O2_O2P_CN;
			
			c[ipO2][ipO2] -= CNP_O2_O2P_CN_1;
			c[ipCNP][ipO2] -= CNP_O2_O2P_CN_2;
			bvec[ipO2] -= bvec_CNP_O2_O2P_CN;
			
			c[ipO2][ipO2P] += CNP_O2_O2P_CN_1;
			c[ipCNP][ipO2P] += CNP_O2_O2P_CN_2;
			bvec[ipO2P] += bvec_CNP_O2_O2P_CN;
			
			c[ipO2][ipCN] += CNP_O2_O2P_CN_1;
			c[ipCNP][ipCN] += CNP_O2_O2P_CN_2;
			bvec[ipCN] += bvec_CNP_O2_O2P_CN;

		/*  >>refer   molecule   CN+    +  S     =>   S+    +     CN    UMIST  */

			c[ipATS][ipCNP] -= CNP_S_SP_CN_1;
			c[ipCNP][ipCNP] -= CNP_S_SP_CN_2;
			bvec[ipCNP] -= bvec_CNP_S_SP_CN;
			
			c[ipATS][ipSP] += CNP_S_SP_CN_1;
			c[ipCNP][ipSP] += CNP_S_SP_CN_2;
			bvec[ipSP] += bvec_CNP_S_SP_CN;
			
			c[ipATS][ipCN] += CNP_S_SP_CN_1;
			c[ipCNP][ipCN] += CNP_S_SP_CN_2;
			bvec[ipCN] += bvec_CNP_S_SP_CN;

		/*  >>refer   molecule   HCN    +  CO+   =>   CO    +     HCN+  UMIST  */

			c[ipCOP][ipHCN] -= HCN_COP_CO_HCNP_1;
			c[ipHCN][ipHCN] -= HCN_COP_CO_HCNP_2;
			bvec[ipHCN] -= bvec_HCN_COP_CO_HCNP;
			
			c[ipCOP][ipCOP] -= HCN_COP_CO_HCNP_1;
			c[ipHCN][ipCOP] -= HCN_COP_CO_HCNP_2;
			bvec[ipCOP] -= bvec_HCN_COP_CO_HCNP;
			
			c[ipCOP][ipCO] += HCN_COP_CO_HCNP_1;
			c[ipHCN][ipCO] += HCN_COP_CO_HCNP_2;
			bvec[ipCO] += bvec_HCN_COP_CO_HCNP;
			
			c[ipCOP][ipHCNP] += HCN_COP_CO_HCNP_1;
			c[ipHCN][ipHCNP] += HCN_COP_CO_HCNP_2;
			bvec[ipHCNP] += bvec_HCN_COP_CO_HCNP;

		/*  >>refer   molecule   HCN    +  N2+   =>   N2    +     HCN+  UMIST  */

			c[ipN2P][ipHCN] -= HCN_N2P_N2_HCNP_1;
			c[ipHCN][ipHCN] -= HCN_N2P_N2_HCNP_2;
			bvec[ipHCN] -= bvec_HCN_N2P_N2_HCNP;
			
			c[ipN2P][ipN2P] -= HCN_N2P_N2_HCNP_1;
			c[ipHCN][ipN2P] -= HCN_N2P_N2_HCNP_2;
			bvec[ipN2P] -= bvec_HCN_N2P_N2_HCNP;
			
			c[ipN2P][ipN2] += HCN_N2P_N2_HCNP_1;
			c[ipHCN][ipN2] += HCN_N2P_N2_HCNP_2;
			bvec[ipN2] += bvec_HCN_N2P_N2_HCNP;
			
			c[ipN2P][ipHCNP] += HCN_N2P_N2_HCNP_1;
			c[ipHCN][ipHCNP] += HCN_N2P_N2_HCNP_2;
			bvec[ipHCNP] += bvec_HCN_N2P_N2_HCNP;

		/*  >>refer   molecule   HCN+   +  NO    =>   NO+   +     HCN   UMIST  */

			c[ipNO][ipHCNP] -= HCNP_NO_NOP_HCN_1;
			c[ipHCNP][ipHCNP] -= HCNP_NO_NOP_HCN_2;
			bvec[ipHCNP] -= bvec_HCNP_NO_NOP_HCN;
			
			c[ipNO][ipNO] -= HCNP_NO_NOP_HCN_1;
			c[ipHCNP][ipNO] -= HCNP_NO_NOP_HCN_2;
			bvec[ipNO] -= bvec_HCNP_NO_NOP_HCN;
			
			c[ipNO][ipNOP] += HCNP_NO_NOP_HCN_1;
			c[ipHCNP][ipNOP] += HCNP_NO_NOP_HCN_2;
			bvec[ipNOP] += bvec_HCNP_NO_NOP_HCN;
			
			c[ipNO][ipHCN] += HCNP_NO_NOP_HCN_1;
			c[ipHCNP][ipHCN] += HCNP_NO_NOP_HCN_2;
			bvec[ipHCN] += bvec_HCNP_NO_NOP_HCN;

		/*  >>refer   molecule   HCN+   +  O2    =>   O2+   +     HCN   UMIST  */

			c[ipO2][ipHCNP] -= HCNP_O2_O2P_HCN_1;
			c[ipHCNP][ipHCNP] -= HCNP_O2_O2P_HCN_2;
			bvec[ipHCNP] -= bvec_HCNP_O2_O2P_HCN;
			
			c[ipO2][ipO2] -= HCNP_O2_O2P_HCN_1;
			c[ipHCNP][ipO2] -= HCNP_O2_O2P_HCN_2;
			bvec[ipO2] -= bvec_HCNP_O2_O2P_HCN;
			
			c[ipO2][ipO2P] += HCNP_O2_O2P_HCN_1;
			c[ipHCNP][ipO2P] += HCNP_O2_O2P_HCN_2;
			bvec[ipO2P] += bvec_HCNP_O2_O2P_HCN;
			
			c[ipO2][ipHCN] += HCNP_O2_O2P_HCN_1;
			c[ipHCNP][ipHCN] += HCNP_O2_O2P_HCN_2;
			bvec[ipHCN] += bvec_HCNP_O2_O2P_HCN;

		/*  >>refer   molecule   HCN+   +  S     =>   S+    +     HCN   UMIST  */

			c[ipATS][ipHCNP] -= HCNP_S_SP_HCN_1;
			c[ipHCNP][ipHCNP] -= HCNP_S_SP_HCN_2;
			bvec[ipHCNP] -= bvec_HCNP_S_SP_HCN;
			
			c[ipATS][ipSP] += HCNP_S_SP_HCN_1;
			c[ipHCNP][ipSP] += HCNP_S_SP_HCN_2;
			bvec[ipSP] += bvec_HCNP_S_SP_HCN;
			
			c[ipATS][ipHCN] += HCNP_S_SP_HCN_1;
			c[ipHCNP][ipHCN] += HCNP_S_SP_HCN_2;
			bvec[ipHCN] += bvec_HCNP_S_SP_HCN;

		/*  >>refer   molecule   CO     +  N2+   =>   N2    +     CO+   UMIST  */

			c[ipN2P][ipCO] -= CO_N2P_N2_COP_1;
			c[ipCO][ipCO] -= CO_N2P_N2_COP_2;
			bvec[ipCO] -= bvec_CO_N2P_N2_COP;
			
			c[ipN2P][ipN2P] -= CO_N2P_N2_COP_1;
			c[ipCO][ipN2P] -= CO_N2P_N2_COP_2;
			bvec[ipN2P] -= bvec_CO_N2P_N2_COP;
			
			c[ipN2P][ipN2] += CO_N2P_N2_COP_1;
			c[ipCO][ipN2] += CO_N2P_N2_COP_2;
			bvec[ipN2] += bvec_CO_N2P_N2_COP;
			
			c[ipN2P][ipCOP] += CO_N2P_N2_COP_1;
			c[ipCO][ipCOP] += CO_N2P_N2_COP_2;
			bvec[ipCOP] += bvec_CO_N2P_N2_COP;

		/*  >>refer   molecule   CO+    +  NO    =>   NO+   +     CO    UMIST  */

			c[ipNO][ipCOP] -= COP_NO_NOP_CO_1;
			c[ipCOP][ipCOP] -= COP_NO_NOP_CO_2;
			bvec[ipCOP] -= bvec_COP_NO_NOP_CO;
			
			c[ipNO][ipNO] -= COP_NO_NOP_CO_1;
			c[ipCOP][ipNO] -= COP_NO_NOP_CO_2;
			bvec[ipNO] -= bvec_COP_NO_NOP_CO;
			
			c[ipNO][ipNOP] += COP_NO_NOP_CO_1;
			c[ipCOP][ipNOP] += COP_NO_NOP_CO_2;
			bvec[ipNOP] += bvec_COP_NO_NOP_CO;
			
			c[ipNO][ipCO] += COP_NO_NOP_CO_1;
			c[ipCOP][ipCO] += COP_NO_NOP_CO_2;
			bvec[ipCO] += bvec_COP_NO_NOP_CO;

		/*  >>refer   molecule   N2+    +  NO    =>   NO+   +     N2    UMIST  */

			c[ipNO][ipN2P] -= N2P_NO_NOP_N2_1;
			c[ipN2P][ipN2P] -= N2P_NO_NOP_N2_2;
			bvec[ipN2P] -= bvec_N2P_NO_NOP_N2;
			
			c[ipNO][ipNO] -= N2P_NO_NOP_N2_1;
			c[ipN2P][ipNO] -= N2P_NO_NOP_N2_2;
			bvec[ipNO] -= bvec_N2P_NO_NOP_N2;
			
			c[ipNO][ipNOP] += N2P_NO_NOP_N2_1;
			c[ipN2P][ipNOP] += N2P_NO_NOP_N2_2;
			bvec[ipNOP] += bvec_N2P_NO_NOP_N2;
			
			c[ipNO][ipN2] += N2P_NO_NOP_N2_1;
			c[ipN2P][ipN2] += N2P_NO_NOP_N2_2;
			bvec[ipN2] += bvec_N2P_NO_NOP_N2;

		/*  >>refer   molecule   N2+    +  O2    =>   O2+   +     N2    UMIST  */

			c[ipO2][ipN2P] -= N2P_O2_O2P_N2_1;
			c[ipN2P][ipN2P] -= N2P_O2_O2P_N2_2;
			bvec[ipN2P] -= bvec_N2P_O2_O2P_N2;
			
			c[ipO2][ipO2] -= N2P_O2_O2P_N2_1;
			c[ipN2P][ipO2] -= N2P_O2_O2P_N2_2;
			bvec[ipO2] -= bvec_N2P_O2_O2P_N2;
			
			c[ipO2][ipO2P] += N2P_O2_O2P_N2_1;
			c[ipN2P][ipO2P] += N2P_O2_O2P_N2_2;
			bvec[ipO2P] += bvec_N2P_O2_O2P_N2;
			
			c[ipO2][ipN2] += N2P_O2_O2P_N2_1;
			c[ipN2P][ipN2] += N2P_O2_O2P_N2_2;
			bvec[ipN2] += bvec_N2P_O2_O2P_N2;

		/*  >>refer   molecule   N2+    +  S     =>   S+    +     N2    UMIST  */

			c[ipATS][ipN2P] -= N2P_S_SP_N2_1;
			c[ipN2P][ipN2P] -= N2P_S_SP_N2_2;
			bvec[ipN2P] -= bvec_N2P_S_SP_N2;
			
			c[ipATS][ipSP] += N2P_S_SP_N2_1;
			c[ipN2P][ipSP] += N2P_S_SP_N2_2;
			bvec[ipSP] += bvec_N2P_S_SP_N2;
			
			c[ipATS][ipN2] += N2P_S_SP_N2_1;
			c[ipN2P][ipN2] += N2P_S_SP_N2_2;
			bvec[ipN2] += bvec_N2P_S_SP_N2;

		/*  >>refer   molecule   SI     +  NO+   =>   NO    +     SI+   UMIST  */

			c[ipNOP][ipNOP] -= SI_NOP_NO_SIP_1;
			c[ipATSI][ipNOP] -= SI_NOP_NO_SIP_2;
			bvec[ipNOP] -= bvec_SI_NOP_NO_SIP;
			
			c[ipNOP][ipNO] += SI_NOP_NO_SIP_1;
			c[ipATSI][ipNO] += SI_NOP_NO_SIP_2;
			bvec[ipNO] += bvec_SI_NOP_NO_SIP;
			
			c[ipNOP][ipSIP] += SI_NOP_NO_SIP_1;
			c[ipATSI][ipSIP] += SI_NOP_NO_SIP_2;
			bvec[ipSIP] += bvec_SI_NOP_NO_SIP;

		/*  >>refer   molecule   SI     +  HS+   =>   HS    +     SI+   UMIST  */

			c[ipHSP][ipHSP] -= SI_HSP_HS_SIP_1;
			c[ipATSI][ipHSP] -= SI_HSP_HS_SIP_2;
			bvec[ipHSP] -= bvec_SI_HSP_HS_SIP;
			
			c[ipHSP][ipHS] += SI_HSP_HS_SIP_1;
			c[ipATSI][ipHS] += SI_HSP_HS_SIP_2;
			bvec[ipHS] += bvec_SI_HSP_HS_SIP;
			
			c[ipHSP][ipSIP] += SI_HSP_HS_SIP_1;
			c[ipATSI][ipSIP] += SI_HSP_HS_SIP_2;
			bvec[ipSIP] += bvec_SI_HSP_HS_SIP;
			
		/*  >>refer   molecule   SI     +  CS+   =>   CS    +     SI+   UMIST  */

			c[ipCSP][ipCSP] -= SI_CSP_CS_SIP_1;
			c[ipATSI][ipCSP] -= SI_CSP_CS_SIP_2;
			bvec[ipCSP] -= bvec_SI_CSP_CS_SIP;
			
			c[ipCSP][ipCS] += SI_CSP_CS_SIP_1;
			c[ipATSI][ipCS] += SI_CSP_CS_SIP_2;
			bvec[ipCS] += bvec_SI_CSP_CS_SIP;
			
			c[ipCSP][ipSIP] += SI_CSP_CS_SIP_1;
			c[ipATSI][ipSIP] += SI_CSP_CS_SIP_2;
			bvec[ipSIP] += bvec_SI_CSP_CS_SIP;

		/*  >>refer   molecule   NO     +  HNO+  =>   HNO   +     NO+   UMIST  */

			c[ipHNOP][ipNO] -= NO_HNOP_HNO_NOP_1;
			c[ipNO][ipNO] -= NO_HNOP_HNO_NOP_2;
			bvec[ipNO] -= bvec_NO_HNOP_HNO_NOP;
			
			c[ipHNOP][ipHNOP] -= NO_HNOP_HNO_NOP_1;
			c[ipNO][ipHNOP] -= NO_HNOP_HNO_NOP_2;
			bvec[ipHNOP] -= bvec_NO_HNOP_HNO_NOP;
			
			c[ipHNOP][ipHNO] += NO_HNOP_HNO_NOP_1;
			c[ipNO][ipHNO] += NO_HNOP_HNO_NOP_2;
			bvec[ipHNO] += bvec_NO_HNOP_HNO_NOP;
			
			c[ipHNOP][ipNOP] += NO_HNOP_HNO_NOP_1;
			c[ipNO][ipNOP] += NO_HNOP_HNO_NOP_2;
			bvec[ipNOP] += bvec_NO_HNOP_HNO_NOP;

		/*  >>refer   molecule   NO     +  O2+   =>   O2    +     NO+   UMIST  */

			c[ipO2P][ipNO] -= NO_O2P_O2_NOP_1;
			c[ipNO][ipNO] -= NO_O2P_O2_NOP_2;
			bvec[ipNO] -= bvec_NO_O2P_O2_NOP;
			
			c[ipO2P][ipO2P] -= NO_O2P_O2_NOP_1;
			c[ipNO][ipO2P] -= NO_O2P_O2_NOP_2;
			bvec[ipO2P] -= bvec_NO_O2P_O2_NOP;
			
			c[ipO2P][ipO2] += NO_O2P_O2_NOP_1;
			c[ipNO][ipO2] += NO_O2P_O2_NOP_2;
			bvec[ipO2] += bvec_NO_O2P_O2_NOP;
			
			c[ipO2P][ipNOP] += NO_O2P_O2_NOP_1;
			c[ipNO][ipNOP] += NO_O2P_O2_NOP_2;
			bvec[ipNOP] += bvec_NO_O2P_O2_NOP;

		/*  >>refer   molecule   NO     +  S+    =>   S     +     NO+   UMIST  */

			c[ipSP][ipNO] -= NO_SP_S_NOP_1;
			c[ipNO][ipNO] -= NO_SP_S_NOP_2;
			bvec[ipNO] -= bvec_NO_SP_S_NOP;
			
			c[ipSP][ipSP] -= NO_SP_S_NOP_1;
			c[ipNO][ipSP] -= NO_SP_S_NOP_2;
			bvec[ipSP] -= bvec_NO_SP_S_NOP;
			
			c[ipSP][ipNOP] += NO_SP_S_NOP_1;
			c[ipNO][ipNOP] += NO_SP_S_NOP_2;
			bvec[ipNOP] += bvec_NO_SP_S_NOP;

		/*  >>refer   molecule   NO     +  HS+   =>   HS    +     NO+   UMIST  */

			c[ipHSP][ipNO] -= NO_HSP_HS_NOP_1;
			c[ipNO][ipNO] -= NO_HSP_HS_NOP_2;
			bvec[ipNO] -= bvec_NO_HSP_HS_NOP;
			
			c[ipHSP][ipHSP] -= NO_HSP_HS_NOP_1;
			c[ipNO][ipHSP] -= NO_HSP_HS_NOP_2;
			bvec[ipHSP] -= bvec_NO_HSP_HS_NOP;
			
			c[ipHSP][ipHS] += NO_HSP_HS_NOP_1;
			c[ipNO][ipHS] += NO_HSP_HS_NOP_2;
			bvec[ipHS] += bvec_NO_HSP_HS_NOP;
			
			c[ipHSP][ipNOP] += NO_HSP_HS_NOP_1;
			c[ipNO][ipNOP] += NO_HSP_HS_NOP_2;
			bvec[ipNOP] += bvec_NO_HSP_HS_NOP;

		/*  >>refer   molecule   NO     +  SIO+  =>   SIO   +     NO+   UMIST  */

			c[ipSIOP][ipNO] -= NO_SIOP_SIO_NOP_1;
			c[ipNO][ipNO] -= NO_SIOP_SIO_NOP_2;
			bvec[ipNO] -= bvec_NO_SIOP_SIO_NOP;
			
			c[ipSIOP][ipSIOP] -= NO_SIOP_SIO_NOP_1;
			c[ipNO][ipSIOP] -= NO_SIOP_SIO_NOP_2;
			bvec[ipSIOP] -= bvec_NO_SIOP_SIO_NOP;
			
			c[ipSIOP][ipSIO] += NO_SIOP_SIO_NOP_1;
			c[ipNO][ipSIO] += NO_SIOP_SIO_NOP_2;
			bvec[ipSIO] += bvec_NO_SIOP_SIO_NOP;
			
			c[ipSIOP][ipNOP] += NO_SIOP_SIO_NOP_1;
			c[ipNO][ipNOP] += NO_SIOP_SIO_NOP_2;
			bvec[ipNOP] += bvec_NO_SIOP_SIO_NOP;

		/*  >>refer   molecule   NO     +  S2+   =>   S2    +     NO+   UMIST  */

			c[ipS2P][ipNO] -= NO_S2P_S2_NOP_1;
			c[ipNO][ipNO] -= NO_S2P_S2_NOP_2;
			bvec[ipNO] -= bvec_NO_S2P_S2_NOP;
			
			c[ipS2P][ipS2P] -= NO_S2P_S2_NOP_1;
			c[ipNO][ipS2P] -= NO_S2P_S2_NOP_2;
			bvec[ipS2P] -= bvec_NO_S2P_S2_NOP;
			
			c[ipS2P][ipS2] += NO_S2P_S2_NOP_1;
			c[ipNO][ipS2] += NO_S2P_S2_NOP_2;
			bvec[ipS2] += bvec_NO_S2P_S2_NOP;
			
			c[ipS2P][ipNOP] += NO_S2P_S2_NOP_1;
			c[ipNO][ipNOP] += NO_S2P_S2_NOP_2;
			bvec[ipNOP] += bvec_NO_S2P_S2_NOP;

		/*  >>refer   molecule   O2+    +  NO2   =>   NO2+  +     O2    UMIST  */

			c[ipNO2][ipO2P] -= O2P_NO2_NO2P_O2_1;
			c[ipO2P][ipO2P] -= O2P_NO2_NO2P_O2_2;
			bvec[ipO2P] -= bvec_O2P_NO2_NO2P_O2;
			
			c[ipNO2][ipNO2] -= O2P_NO2_NO2P_O2_1;
			c[ipO2P][ipNO2] -= O2P_NO2_NO2P_O2_2;
			bvec[ipNO2] -= bvec_O2P_NO2_NO2P_O2;
			
			c[ipNO2][ipNO2P] += O2P_NO2_NO2P_O2_1;
			c[ipO2P][ipNO2P] += O2P_NO2_NO2P_O2_2;
			bvec[ipNO2P] += bvec_O2P_NO2_NO2P_O2;
			
			c[ipNO2][ipO2] += O2P_NO2_NO2P_O2_1;
			c[ipO2P][ipO2] += O2P_NO2_NO2P_O2_2;
			bvec[ipO2] += bvec_O2P_NO2_NO2P_O2;

		/*  >>refer   molecule   S      +  HS+   =>   HS    +     S+    UMIST  */

			c[ipHSP][ipHSP] -= S_HSP_HS_SP_1;
			c[ipATS][ipHSP] -= S_HSP_HS_SP_2;
			bvec[ipHSP] -= bvec_S_HSP_HS_SP;
						
			c[ipHSP][ipHS] += S_HSP_HS_SP_1;
			c[ipATS][ipHS] += S_HSP_HS_SP_2;
			bvec[ipHS] += bvec_S_HSP_HS_SP;
			
			c[ipHSP][ipSP] += S_HSP_HS_SP_1;
			c[ipATS][ipSP] += S_HSP_HS_SP_2;
			bvec[ipSP] += bvec_S_HSP_HS_SP;
			
		/*  >>refer   molecule   NH+    +  e     =>   N     +     H     UMIST  */

			c[ipNHP][ipNHP] -= NHP_e_N_H;

		/*  >>refer   molecule   NH2+   +  e     =>   N     +     H  +  H      UMIST  */

			c[ipNH2P][ipNH2P] -= NH2P_e_N_H_H;

		/*  >>refer   molecule   NH2+   +  e     =>   NH    +     H     UMIST  */

			c[ipNH2P][ipNH2P] -= NH2P_e_NH_H;
			c[ipNH2P][ipNH] += NH2P_e_NH_H;

		/*  >>refer   molecule   NH3+   +  e     =>   NH    +     H  +  H      UMIST  */

			c[ipNH3P][ipNH3P] -= NH3P_e_NH_H_H;
			c[ipNH3P][ipNH] += NH3P_e_NH_H_H;

		/*  >>refer   molecule   NH3+   +  e     =>   NH2   +     H     UMIST  */

			c[ipNH3P][ipNH3P] -= NH3P_e_NH2_H;
			c[ipNH3P][ipNH2] += NH3P_e_NH2_H;

		/*  >>refer   molecule   NH4+   +  e     =>   NH2   +     H  +  H      UMIST  */

			c[ipNH4P][ipNH4P] -= NH4P_e_NH2_H_H;
			c[ipNH4P][ipNH2] += NH4P_e_NH2_H_H;

		/*  >>refer   molecule   NH4+   +  e     =>   NH2   +     H2    UMIST  */

			c[ipNH4P][ipNH4P] -= NH4P_e_NH2_H2;
			c[ipNH4P][ipNH2] += NH4P_e_NH2_H2;

		/*  >>refer   molecule   NH4+   +  e     =>   NH3   +     H     UMIST  */

			c[ipNH4P][ipNH4P] -= NH4P_e_NH3_H;
			c[ipNH4P][ipNH3] += NH4P_e_NH3_H;

		/*  >>refer   molecule   CN+    +  e     =>   N     +     C     UMIST  */

			c[ipCNP][ipCNP] -= CNP_e_N_C;

		/*  >>refer   molecule   HCN+   +  e     =>   CN    +     H     UMIST  */

			c[ipHCNP][ipHCNP] -= HCNP_e_CN_H;
			c[ipHCNP][ipCN] += HCNP_e_CN_H;

		/*  >>refer   molecule   N2+    +  e     =>   N     +     N     UMIST  */

			c[ipN2P][ipN2P] -= N2P_e_N_N;

		/*  >>refer   molecule   NO+    +  e     =>   O     +     N     UMIST  */

			c[ipNOP][ipNOP] -= NOP_e_O_N;

		/*  >>refer   molecule   HNO+   +  e     =>   NO    +     H     UMIST  */

			c[ipHNOP][ipHNOP] -= HNOP_e_NO_H;
			c[ipHNOP][ipNO] += HNOP_e_NO_H;

		/*  >>refer   molecule   HS+    +  e     =>   S     +     H     UMIST  */

			c[ipHSP][ipHSP] -= HSP_e_S_H;

		/*  >>refer   molecule   OCN+   +  e     =>   CO    +     N     UMIST  */

			c[ipOCNP][ipOCNP] -= OCNP_e_CO_N;
			c[ipOCNP][ipCO] += OCNP_e_CO_N;

		/*  >>refer   molecule   SIN+   +  e     =>   SI    +     N     UMIST  */

			c[ipSINP][ipSINP] -= SINP_e_SI_N;

		/*  >>refer   molecule   CS+    +  e     =>   S     +     C     UMIST  */

			c[ipCSP][ipCSP] -= CSP_e_S_C;

		/*  >>refer   molecule   HCS+   +  e     =>   CS    +     H     UMIST  */

			c[ipHCSP][ipHCSP] -= HCSP_e_CS_H;
			c[ipHCSP][ipCS] += HCSP_e_CS_H;

		/*  >>refer   molecule   NO2+   +  e     =>   NO    +     O     UMIST  */

			c[ipNO2P][ipNO2P] -= NO2P_e_NO_O;
			c[ipNO2P][ipNO] += NO2P_e_NO_O;

		/*  >>refer   molecule   NS+    +  e     =>   S     +     N     UMIST  */

			c[ipNSP][ipNSP] -= NSP_e_S_N;

		/*  >>refer   molecule   SO+    +  e     =>   S     +     O     UMIST  */

			c[ipSOP][ipSOP] -= SOP_e_S_O;

		/*  >>refer   molecule   OCS+   +  e     =>   S     +     CO    UMIST  */

			c[ipOCSP][ipOCSP] -= OCSP_e_S_CO;
			c[ipOCSP][ipCO] += OCSP_e_S_CO;

		/*  >>refer   molecule   OCS+   +  e     =>   CS    +     O     UMIST  */

			c[ipOCSP][ipOCSP] -= OCSP_e_CS_O;
			c[ipOCSP][ipCS] += OCSP_e_CS_O;

		/*  >>refer   molecule   S2+    +  e     =>   S     +     S     UMIST  */

			c[ipS2P][ipS2P] -= S2P_e_S_S;

		/*  >>refer   molecule   H-     +  N     =>   NH    +     e     UMIST  */

			c[ipATN][ipNH] += Hminus_N_NH_e;

		/*  >>refer   molecule   H-     +  NH    =>   NH2   +     e     UMIST  */

			c[ipNH][ipNH] -= Hminus_NH_NH2_e;
			c[ipNH][ipNH2] += Hminus_NH_NH2_e;

		/*  >>refer   molecule   H-     +  NH2   =>   NH3   +     e     UMIST  */

			c[ipNH2][ipNH2] -= Hminus_NH2_NH3_e;
			c[ipNH2][ipNH3] += Hminus_NH2_NH3_e;

		/*  >>refer   molecule   H-     +  CN    =>   HCN   +     e     UMIST  */

			c[ipCN][ipCN] -= Hminus_CN_HCN_e;
			c[ipCN][ipHCN] += Hminus_CN_HCN_e;

		/*  >>refer   molecule   C      +  N     =>   CN    +     NU    UMIST  */

			c[ipATN][ipCN]  += C_N_CN_NU_1;
			c[ipATC][ipCN] += C_N_CN_NU_2;
			bvec[ipCN] += bvec_C_N_CN_NU;

		/*  >>refer   molecule   C      +  S     =>   CS    +     NU    UMIST  */

			c[ipATS][ipCS]  += C_S_CS_NU_1;
			c[ipATC][ipCS] += C_S_CS_NU_2;
			bvec[ipCS] += bvec_C_S_CS_NU;

		/*  >>refer   molecule   C+     +  S     =>   CS+   +     NU    UMIST  */

			c[ipATS][ipCP]  -= CP_S_CSP_NU_1;
			c[ipCP][ipCP]  -= CP_S_CSP_NU_2;
			bvec[ipCP] -= bvec_CP_S_CSP_NU;

			c[ipATN][ipCSP]  += CP_S_CSP_NU_1;
			c[ipCP][ipCSP]  += CP_S_CSP_NU_2;
			bvec[ipCSP] += bvec_CP_S_CSP_NU;

		/*  >>refer   molecule   N+     +  N     =>   N2+   +     NU    UMIST  */

			c[ipATN][ipNP]  -= NP_N_N2P_NU_1;
			c[ipNP][ipNP]  -= NP_N_N2P_NU_2;
			bvec[ipNP] -= bvec_NP_N_N2P_NU;

			c[ipATN][ipN2P]  += NP_N_N2P_NU_1;
			c[ipNP][ipN2P] += NP_N_N2P_NU_2;
			bvec[ipN2P] += bvec_NP_N_N2P_NU;

		/*  >>refer   molecule   CO     +  S     =>   OCS   +     NU    UMIST  */

			c[ipATS][ipCO]  -= CO_S_OCS_NU_1;
			c[ipCO][ipCO] -= CO_S_OCS_NU_2;
			bvec[ipCO] -= bvec_CO_S_OCS_NU;

			c[ipATS][ipOCS]  += CO_S_OCS_NU_1;
			c[ipCO][ipOCS] += CO_S_OCS_NU_2;
			bvec[ipOCS] += bvec_CO_S_OCS_NU;

		/*  >>refer   molecule   NH     +  NU    =>   NH+   +     e     UMIST  */

			c[ipNH][ipNH] -= NH_NU_NHP_e;
			c[ipNH][ipNHP] += NH_NU_NHP_e;

		/*  >>refer   molecule   NH     +  NU    =>   N     +     H     UMIST  */

			c[ipNH][ipNH] -= NH_NU_N_H;

		/*  >>refer   molecule   NH2    +  NU    =>   NH    +     H     UMIST  */

			c[ipNH2][ipNH2] -= NH2_NU_NH_H;
			c[ipNH2][ipNH] += NH2_NU_NH_H;

		/*  >>refer   molecule   NH2    +  NU    =>   NH2+  +     e     UMIST  */

			c[ipNH2][ipNH2] -= NH2_NU_NH2P_e;
			c[ipNH2][ipNH2P] += NH2_NU_NH2P_e;

		/*  >>refer   molecule   NH3    +  NU    =>   NH3+  +     e     UMIST  */

			c[ipNH3][ipNH3] -= NH3_NU_NH3P_e;
			c[ipNH3][ipNH3P] += NH3_NU_NH3P_e;

		/*  >>refer   molecule   NH3    +  NU    =>   NH    +     H2    UMIST  */

			c[ipNH3][ipNH3] -= NH3_NU_NH_H2;
			c[ipNH3][ipNH] += NH3_NU_NH_H2;

		/*  >>refer   molecule   NH3    +  NU    =>   NH2   +     H     UMIST  */

			c[ipNH3][ipNH3] -= NH3_NU_NH2_H;
			c[ipNH3][ipNH2] += NH3_NU_NH2_H;

		/*  >>refer   molecule   CN     +  NU    =>   N     +     C     UMIST  */

			c[ipCN][ipCN] -= CN_NU_N_C;

		/*  >>refer   molecule   HCN    +  NU    =>   CN    +     H     UMIST  */

			c[ipHCN][ipHCN] -= HCN_NU_CN_H;
			c[ipHCN][ipCN] += HCN_NU_CN_H;

		/*  >>refer   molecule   N2     +  NU    =>   N     +     N     UMIST  */

			c[ipN2][ipN2] -= N2_NU_N_N;

		/*  >>refer   molecule   NO     +  NU    =>   O     +     N     UMIST  */

			c[ipNO][ipNO] -= NO_NU_O_N;

		/*  >>refer   molecule   NO     +  NU    =>   NO+   +     e     UMIST  */

			c[ipNO][ipNO] -= NO_NU_NOP_e;
			c[ipNO][ipNOP] += NO_NU_NOP_e;

		/*  >>refer   molecule   HNO    +  NU    =>   NO    +     H     UMIST  */

			c[ipHNO][ipHNO] -= HNO_NU_NO_H;
			c[ipHNO][ipNO] += HNO_NU_NO_H;

		/*  >>refer   molecule   HS     +  NU    =>   S     +     H     UMIST  */

			c[ipHS][ipHS] -= HS_NU_S_H;

		/*  >>refer   molecule   HS+    +  NU    =>   S+    +     H     UMIST  */

			c[ipHSP][ipHSP] -= HSP_NU_SP_H;
			c[ipHSP][ipSP] += HSP_NU_SP_H;

		/*  >>refer   molecule   OCN    +  NU    =>   CN    +     O     UMIST  */

			c[ipOCN][ipOCN] -= OCN_NU_CN_O;
			c[ipOCN][ipCN] += OCN_NU_CN_O;

		/*  >>refer   molecule   CS     +  NU    =>   S     +     C     UMIST  */

			c[ipCS][ipCS] -= CS_NU_S_C;

		/*  >>refer   molecule   CS+    +  NU    =>   S+    +     C     UMIST  */

			c[ipCSP][ipCSP] -= CSP_NU_SP_C;
			c[ipCSP][ipSP] += CSP_NU_SP_C;

		/*  >>refer   molecule   CS     +  NU    =>   CS+   +     e     UMIST  */

			c[ipCS][ipCS] -= CS_NU_CSP_e;
			c[ipCS][ipCSP] += CS_NU_CSP_e;

		/*  >>refer   molecule   NO2    +  NU    =>   NO    +     O     UMIST  */

			c[ipNO2][ipNO2] -= NO2_NU_NO_O;
			c[ipNO2][ipNO] += NO2_NU_NO_O;

		/*  >>refer   molecule   NS     +  NU    =>   S     +     N     UMIST  */

			c[ipNS][ipNS] -= NS_NU_S_N;

		/*  >>refer   molecule   SO     +  NU    =>   S     +     O     UMIST  */

			c[ipSO][ipSO] -= SO_NU_S_O;

		/*  >>refer   molecule   SO     +  NU    =>   SO+   +     e     UMIST  */

			c[ipSO][ipSO] -= SO_NU_SOP_e;
			c[ipSO][ipSOP] += SO_NU_SOP_e;

		/*  >>refer   molecule   OCS    +  NU    =>   S     +     CO    UMIST  */

			c[ipOCS][ipOCS] -= OCS_NU_S_CO;
			c[ipOCS][ipCO] += OCS_NU_S_CO;

		/*  >>refer   molecule   OCS    +  NU    =>   OCS+  +     e     UMIST  */

			c[ipOCS][ipOCS] -= OCS_NU_OCSP_e;
			c[ipOCS][ipOCSP] += OCS_NU_OCSP_e;

		/*  >>refer   molecule   NH     +  CRP   =>   NH+   +     e     UMIST  */

			c[ipNH][ipNH] -= NH_CRP_NHP_e;
			c[ipNH][ipNHP] += NH_CRP_NHP_e;

		/*  >>refer   molecule   NH     +  CRP   =>   N     +     H     UMIST  */

			c[ipNH][ipNH] -= NH_CRP_N_H;

		/*  >>refer   molecule   NH2    +  CRP   =>   NH    +     H     UMIST  */

			c[ipNH2][ipNH2] -= NH2_CRP_NH_H;
			c[ipNH2][ipNH] += NH2_CRP_NH_H;

		/*  >>refer   molecule   NH2    +  CRP   =>   NH2+  +     e     UMIST  */

			c[ipNH2][ipNH2] -= NH2_CRP_NH2P_e;
			c[ipNH2][ipNH2P] += NH2_CRP_NH2P_e;

		/*  >>refer   molecule   NH3    +  CRP   =>   NH3+  +     e     UMIST  */

			c[ipNH3][ipNH3] -= NH3_CRP_NH3P_e;
			c[ipNH3][ipNH3P] += NH3_CRP_NH3P_e;

		/*  >>refer   molecule   NH3    +  CRP   =>   NH    +     H2    UMIST  */

			c[ipNH3][ipNH3] -= NH3_CRP_NH_H2;
			c[ipNH3][ipNH] += NH3_CRP_NH_H2;

		/*  >>refer   molecule   NH3    +  CRP   =>   NH2   +     H     UMIST  */

			c[ipNH3][ipNH3] -= NH3_CRP_NH2_H;
			c[ipNH3][ipNH2] += NH3_CRP_NH2_H;

		/*  >>refer   molecule   CN     +  CRP   =>   N     +     C     UMIST  */

			c[ipCN][ipCN] -= CN_CRP_N_C;

		/*  >>refer   molecule   HCN    +  CRP   =>   CN    +     H     UMIST  */

			c[ipHCN][ipHCN] -= HCN_CRP_CN_H;
			c[ipHCN][ipCN] += HCN_CRP_CN_H;

		/*  >>refer   molecule   N2     +  CRP   =>   N     +     N     UMIST  */

			c[ipN2][ipN2] -= N2_CRP_N_N;

		/*  >>refer   molecule   NO     +  CRP   =>   O     +     N     UMIST  */

			c[ipNO][ipNO] -= NO_CRP_O_N;

		/*  >>refer   molecule   NO     +  CRP   =>   NO+   +     e     UMIST  */

			c[ipNO][ipNO] -= NO_CRP_NOP_e;
			c[ipNO][ipNOP] += NO_CRP_NOP_e;

		/*  >>refer   molecule   HNO    +  CRP   =>   NO    +     H     UMIST  */

			c[ipHNO][ipHNO] -= HNO_CRP_NO_H;
			c[ipHNO][ipNO] += HNO_CRP_NO_H;

		/*  >>refer   molecule   HS     +  CRP   =>   S     +     H     UMIST  */

			c[ipHS][ipHS] -= HS_CRP_S_H;

		/*  >>refer   molecule   OCN    +  CRP   =>   CN    +     O     UMIST  */

			c[ipOCN][ipOCN] -= OCN_CRP_CN_O;
			c[ipOCN][ipCN] += OCN_CRP_CN_O;

		/*  >>refer   molecule   CS     +  CRP   =>   S     +     C     UMIST  */

			c[ipCS][ipCS] -= CS_CRP_S_C;

		/*  >>refer   molecule   CS     +  CRP   =>   CS+   +     e     UMIST  */

			c[ipCS][ipCS] -= CS_CRP_CSP_e;
			c[ipCS][ipCSP] += CS_CRP_CSP_e;

		/*  >>refer   molecule   NO2    +  CRP   =>   NO    +     O     UMIST  */

			c[ipNO2][ipNO2] -= NO2_CRP_NO_O;
			c[ipNO2][ipNO] += NO2_CRP_NO_O;

		/*  >>refer   molecule   NS     +  CRP   =>   S     +     N     UMIST  */

			c[ipNS][ipNS] -= NS_CRP_S_N;

		/*  >>refer   molecule   SO     +  CRP   =>   S     +     O     UMIST  */

			c[ipSO][ipSO] -= SO_CRP_S_O;

		/*  >>refer   molecule   SO     +  CRP   =>   SO+   +     e     UMIST  */

			c[ipSO][ipSO] -= SO_CRP_SOP_e;
			c[ipSO][ipSOP] += SO_CRP_SOP_e;

		/*  >>refer   molecule   OCS    +  CRP   =>   S     +     CO    UMIST  */

			c[ipOCS][ipOCS] -= OCS_CRP_S_CO;
			c[ipOCS][ipCO] += OCS_CRP_S_CO;

		/*  >>refer   molecule   OCS    +  CRP   =>   OCS+  +     e     UMIST  */

			c[ipOCS][ipOCS] -= OCS_CRP_OCSP_e;
			c[ipOCS][ipOCSP] += OCS_CRP_OCSP_e;

		/*  >>refer   molecule   H-     +  NH4+  =>   NH3   +     H2    UMIST  */

			c[ipNH4P][ipNH4P] -= Hminus_NH4P_NH3_H2;
			c[ipNH4P][ipNH3] += Hminus_NH4P_NH3_H2;

		/*  >>refer   molecule   CH     +  N+    =>   N     +     CH+   UMIST  */

			c[ipNP][ipCH] -= CH_NP_N_CHP_1;
			c[ipCH][ipCH] -= CH_NP_N_CHP_2;
			bvec[ipCH] -= bvec_CH_NP_N_CHP;
			
			c[ipNP][ipNP] -= CH_NP_N_CHP_1;
			c[ipCH][ipNP] -= CH_NP_N_CHP_2;
			bvec[ipNP] -= bvec_CH_NP_N_CHP;
			
			c[ipNP][ipCHP] += CH_NP_N_CHP_1;
			c[ipCH][ipCHP] += CH_NP_N_CHP_2;
			bvec[ipCHP] += bvec_CH_NP_N_CHP;

		/*  >>refer   molecule   CH+    +  S     =>   S+    +     CH    UMIST  */
			
			c[ipATS][ipCHP] -= CHP_S_SP_CH_1;
			c[ipCHP][ipCHP] -= CHP_S_SP_CH_2;
			bvec[ipCHP] -= bvec_CHP_S_SP_CH;
			
			c[ipATS][ipSP] += CHP_S_SP_CH_1;
			c[ipCHP][ipSP] += CHP_S_SP_CH_2;
			bvec[ipSP] += bvec_CHP_S_SP_CH;
			
			c[ipATS][ipCH] += CHP_S_SP_CH_1;
			c[ipCHP][ipCH] += CHP_S_SP_CH_2;
			bvec[ipCH] += bvec_CHP_S_SP_CH;

		/*  >>refer   molecule   N+     +  CH2   =>   CH2+  +     N	    UMIST  */

			c[ipCH2][ipNP] -= NP_CH2_CH2P_N_1;
			c[ipNP][ipNP] -= NP_CH2_CH2P_N_2;
			bvec[ipNP] -= bvec_NP_CH2_CH2P_N;

			c[ipCH2][ipCH2] -= NP_CH2_CH2P_N_1;
			c[ipNP][ipCH2] -= NP_CH2_CH2P_N_2;
			bvec[ipCH2] -= bvec_NP_CH2_CH2P_N;
						
			c[ipCH2][ipCH2P] += NP_CH2_CH2P_N_1;
			c[ipNP][ipCH2P] += NP_CH2_CH2P_N_2;
			bvec[ipCH2P] += bvec_NP_CH2_CH2P_N;
			
		/*  >>refer   molecule   N+     +  CH4   =>   CH4+  +     N	    UMIST  */

			c[ipCH4][ipNP] -= NP_CH4_CH4P_N_1;
			c[ipNP][ipNP] -= NP_CH4_CH4P_N_2;
			bvec[ipNP] -= bvec_NP_CH4_CH4P_N;
			
			c[ipCH4][ipCH4] -= NP_CH4_CH4P_N_1;
			c[ipNP][ipCH4] -= NP_CH4_CH4P_N_2;
			bvec[ipCH4] -= bvec_NP_CH4_CH4P_N;
			
			c[ipCH4][ipCH4P] += NP_CH4_CH4P_N_1;
			c[ipNP][ipCH4P] += NP_CH4_CH4P_N_2;
			bvec[ipCH4P] += bvec_NP_CH4_CH4P_N;
			
		/*  >>refer   molecule   N+     +  OH    =>   OH+   +     N	    UMIST  */

			c[ipOH][ipNP] -= NP_OH_OHP_N_1;
			c[ipNP][ipNP] -= NP_OH_OHP_N_2;
			bvec[ipNP] -= bvec_NP_OH_OHP_N;
			
			c[ipOH][ipOH] -= NP_OH_OHP_N_1;
			c[ipNP][ipOH] -= NP_OH_OHP_N_2;
			bvec[ipOH] -= bvec_NP_OH_OHP_N;
			
			c[ipOH][ipOHP] += NP_OH_OHP_N_1;
			c[ipNP][ipOHP] += NP_OH_OHP_N_2;
			bvec[ipOHP] += bvec_NP_OH_OHP_N;
			
		/*  >>refer   molecule   N+     +  H2O   =>   H2O+  +     N	    UMIST  */

			c[ipH2O][ipNP] -= NP_H2O_H2OP_N_1;
			c[ipNP][ipNP] -= NP_H2O_H2OP_N_2;
			bvec[ipNP] -= bvec_NP_H2O_H2OP_N;
			
			c[ipH2O][ipH2O] -= NP_H2O_H2OP_N_1;
			c[ipNP][ipH2O] -= NP_H2O_H2OP_N_2;
			bvec[ipH2O] -= bvec_NP_H2O_H2OP_N;
			
			c[ipH2O][ipH2OP] += NP_H2O_H2OP_N_1;
			c[ipNP][ipH2OP] += NP_H2O_H2OP_N_2;
			bvec[ipH2OP] += bvec_NP_H2O_H2OP_N;
			
		/*  >>refer   molecule   N+     +  CO    =>   CO+   +     N	    UMIST  */

			c[ipCO][ipNP] -= NP_CO_COP_N_1;
			c[ipNP][ipNP] -= NP_CO_COP_N_2;
			bvec[ipNP] -= bvec_NP_CO_COP_N;
			
			c[ipCO][ipCO] -= NP_CO_COP_N_1;
			c[ipNP][ipCO] -= NP_CO_COP_N_2;
			bvec[ipCO] -= bvec_NP_CO_COP_N;
			
			c[ipCO][ipCOP] += NP_CO_COP_N_1;
			c[ipNP][ipCOP] += NP_CO_COP_N_2;
			bvec[ipCOP] += bvec_NP_CO_COP_N;

		/*  >>refer   molecule   N+     +  O2    =>   O2+   +     N	    UMIST  */

			c[ipO2][ipNP] -= NP_O2_O2P_N_1;
			c[ipNP][ipNP] -= NP_O2_O2P_N_2;
			bvec[ipNP] -= bvec_NP_O2_O2P_N;
			
			c[ipO2][ipO2] -= NP_O2_O2P_N_1;
			c[ipNP][ipO2] -= NP_O2_O2P_N_2;
			bvec[ipO2] -= bvec_NP_O2_O2P_N;
			
			c[ipO2][ipO2P] += NP_O2_O2P_N_1;
			c[ipNP][ipO2P] += NP_O2_O2P_N_2;
			bvec[ipO2P] += bvec_NP_O2_O2P_N;

		/*  >>refer   molecule   OH+    +  S     =>   S+    +     OH    UMIST  */

			c[ipATS][ipOHP] -= OHP_S_SP_OH_1;
			c[ipOHP][ipOHP] -= OHP_S_SP_OH_2;
			bvec[ipOHP] -= bvec_OHP_S_SP_OH;
			
			c[ipATS][ipSP] += OHP_S_SP_OH_1;
			c[ipOHP][ipSP] += OHP_S_SP_OH_2;
			bvec[ipSP] += bvec_OHP_S_SP_OH;
			
			c[ipATS][ipOH] += OHP_S_SP_OH_1;
			c[ipOHP][ipOH] += OHP_S_SP_OH_2;
			bvec[ipOH] += bvec_OHP_S_SP_OH;

		/*  >>refer   molecule   H2O+   +  S     =>   S+    +     H2O   UMIST  */

			c[ipATS][ipH2OP] -= H2OP_S_SP_H2O_1;
			c[ipH2OP][ipH2OP] -= H2OP_S_SP_H2O_2;
			bvec[ipH2OP] -= bvec_H2OP_S_SP_H2O;
			
			c[ipATS][ipSP] += H2OP_S_SP_H2O_1;
			c[ipH2OP][ipSP] += H2OP_S_SP_H2O_2;
			bvec[ipSP] += bvec_H2OP_S_SP_H2O;
			
			c[ipATS][ipH2O] += H2OP_S_SP_H2O_1;
			c[ipH2OP][ipH2O] += H2OP_S_SP_H2O_2;
			bvec[ipH2O] += bvec_H2OP_S_SP_H2O;

		/*  >>refer   molecule   CO+    +  S     =>   S+    +     CO    UMIST  */

			c[ipATS][ipCOP] -= COP_S_SP_CO_1;
			c[ipCOP][ipCOP] -= COP_S_SP_CO_2;
			bvec[ipCOP] -= bvec_COP_S_SP_CO;
			
			c[ipATS][ipSP] += COP_S_SP_CO_1;
			c[ipCOP][ipSP] += COP_S_SP_CO_2;
			bvec[ipSP] += bvec_COP_S_SP_CO;
			
			c[ipATS][ipCO] += COP_S_SP_CO_1;
			c[ipCOP][ipCO] += COP_S_SP_CO_2;
			bvec[ipCO] += bvec_COP_S_SP_CO;

		/*  >>refer   molecule   SI     +  S+    =>   S     +     SI+   UMIST  */

			c[ipSP][ipSP] -= SI_SP_S_SIP_1;
			c[ipATSI][ipSP] -= SI_SP_S_SIP_2;
			bvec[ipSP] -= bvec_SI_SP_S_SIP;
			
			c[ipSP][ipSIP] += SI_SP_S_SIP_1;
			c[ipATSI][ipSIP] += SI_SP_S_SIP_2;
			bvec[ipSIP] += bvec_SI_SP_S_SIP;
			
		/*  >>refer   molecule   O2+    +  S     =>   S+    +     O2    UMIST  */

			c[ipATS][ipO2P] -= O2P_S_SP_O2_1;
			c[ipO2P][ipO2P] -= O2P_S_SP_O2_2;
			bvec[ipO2P] -= bvec_O2P_S_SP_O2;
			
			c[ipATS][ipSP] += O2P_S_SP_O2_1;
			c[ipO2P][ipSP] += O2P_S_SP_O2_2;
			bvec[ipSP] += bvec_O2P_S_SP_O2;
			
			c[ipATS][ipO2] += O2P_S_SP_O2_1;
			c[ipO2P][ipO2] += O2P_S_SP_O2_2;
			bvec[ipO2] += bvec_O2P_S_SP_O2;

		/*  >>refer   molecule   H-     +  N+    =>   N     +     H	    UMIST  */

			c[ipNP][ipNP] -= Hminus_NP_N_H;

		/* >>refer	molecule	N+ + e => N	 Done internally by Cloudy*/

		/* Recombination of N+ */
		c[ipNP][ipNP] -= (ionbal.RateRecomTot[ipNITROGEN][0]+gv.GrainChTrRate[ipNITROGEN][1][0]);
	
		/* >>refer	molecule	N + hnu => N+	e	 Done internally by Cloudy*/

		/* Photoionization of N */
		c[ipATN][ipNP] += (ionbal.RateIonizTot[ipNITROGEN][0]+gv.GrainChTrRate[ipNITROGEN][0][1]);


		/* >>refer	molecule	S+ + e => S	 Done internally by Cloudy*/

		/* Recombination of S+ */
		c[ipSP][ipSP] -= (ionbal.RateRecomTot[ipSULPHUR][0]+gv.GrainChTrRate[ipSULPHUR][1][0]);

		/* >>refer	molecule	S + hnu => S+	e	 Done internally by Cloudy*/

		/* Photoionization of S */
		c[ipATS][ipSP] += (ionbal.RateIonizTot[ipSULPHUR][0]+gv.GrainChTrRate[ipSULPHUR][0][1]);

		
	
	/********************************************************************************************/
	
	/*							DONE WITH BALANCE EQUATIONS									    */
	
	/********************************************************************************************/
		 
	/*--------------------------------------------------------------------
		* */
	/*printf( " Here are all matrix elements\n ");

	for (i=0; i < NUM_COMOLE_CALC; i++)
		
	{
		

			for (j=0; j < NUM_COMOLE_CALC; j++)
			{
				printf( "%4.4s", co.chLab[i] );
				printf( "%4.4s\t", co.chLab[j] );
				printf( "%.8e,\n", c[j][i] );
			}
	}
	printf( "bvec's are:\n" );
	for (i=0; i < NUM_COMOLE_CALC; i++)
	{
		printf( "%.8e,\n", bvec[i] );
	}*/


	if ( trace.lgTrace && trace.lgTr_CO_Mole )
	{
		fprintf( ioQQQ, " COMOLE matrix\n           " );

		for ( i=0; i < MIN2(NUM_COMOLE_CALC,8); i++ )
		{
			fprintf( ioQQQ, "%4.4s", co.chLab[i] );
		}
		fprintf( ioQQQ, "     \n" );

		for ( j=0; j < NUM_COMOLE_CALC; j++ )
		{
			fprintf( ioQQQ, " %4.4s", co.chLab[j] );
			fprintf( ioQQQ, " " );
			for ( i=0; i < MIN2(NUM_COMOLE_CALC,8); i++ )
			{
				fprintf( ioQQQ, "%9.1e", c[i][j] );
			}
			fprintf( ioQQQ, "\n" );
		}

		if ( NUM_COMOLE_CALC >= 9 )
		{
			fprintf( ioQQQ, " COMOLE matrix\n           " );

			for ( i=8; i < NUM_COMOLE_CALC; i++ )
			{
				fprintf( ioQQQ, "%4.4s", co.chLab[i] );
			}
			fprintf( ioQQQ, "     \n" );

			for ( j=0; j < NUM_COMOLE_CALC; j++ )
			{
				fprintf( ioQQQ, " %4.4s", co.chLab[j] );
				fprintf( ioQQQ, " " );
				for ( i=8; i < NUM_COMOLE_CALC; i++ )
				{
					fprintf( ioQQQ, "%9.1e", c[i][j] );
				}
				fprintf( ioQQQ, "\n" );
			}
		}

		fprintf( ioQQQ, 
			" COMOLE H2 den:%10.3e, H2,3+=%10.2e%10.2e Carb sum=%10.3e Oxy sum=%10.3e\n", 
			hmi.H2_total, 
			hmi.Hmolec[ipMH2p], 
			hmi.Hmolec[ipMH3p], 
			c[NUM_HEAVY_MOLEC][ipATC], 
			c[NUM_HEAVY_MOLEC][ipATO] );

	}

	/* save matrix before we invert it */
	for ( i=0; i < NUM_COMOLE_CALC; i++ )
	{
		for ( j=0; j < NUM_COMOLE_CALC; j++ )
		{
			csav[j][i] = c[j][i];
		}
	}
	/* remember longest CO timescale */

	if ( -c[ipCO][ipCO] > SMALLFLOAT )
	{
		/* this is rate CO is destroyed, equal to formation rate in equilibrium */
		timesc.AgeCOMoleDest = -1./c[ipCO][ipCO];
		/* moved to radinc */
		/*timesc.BigCOMoleForm = (float)MAX2(timesc.BigCOMoleForm,timesc.AgeCOMoleForm);*/
	}
	else
	{
		timesc.AgeCOMoleDest = 0.;
	}

	/* this one may be more robust */
	for ( j=0; j < NUM_COMOLE_CALC; j++ )
	{
		for ( i=0; i < NUM_COMOLE_CALC; i++ )
		{
			amat[i][j] = c[i][j];
		}
	}

	merror = 0;

	/*lint -e740 unusual pointer case */
	getrf_wrapper(NUM_COMOLE_CALC,NUM_COMOLE_CALC,(double*)amat,NUM_COMOLE_CALC, ipiv,&merror);
	/*DGETRF(NUM_COMOLE_CALC,NUM_COMOLE_CALC,(double*)amat,NUM_COMOLE_CALC, ipiv,&merror);*/

	if ( merror != 0 )
	{
		fprintf( ioQQQ, " CO_step getrf_wrapper error\n" );
		puts( "[Stop in CO_step]" );
		cdEXIT(EXIT_FAILURE);
	}

	getrs_wrapper('N',NUM_COMOLE_CALC,1,(double*)amat,NUM_COMOLE_CALC,ipiv,bvec,NUM_COMOLE_CALC,&merror);
	/*lint +e740 unusual pointer case */

	if ( merror != 0 )
	{
		fprintf( ioQQQ, " CO_step: dgetrs finds singular or ill-conditioned matrix\n" );
		puts( "[Stop in CO_step]" );
		cdEXIT(EXIT_FAILURE);
	}

	/* check for negative populations, which happens when 100% co */
	*lgNegPop = FALSE;
	*lgZerPop = FALSE;
	co_denominator = 0;

	for ( i=0; i < NUM_COMOLE_CALC; i++ )
	{
		if ( bvec[i] < 0. )
		{
			/* >>chng 03 sep 11, the following*/
			/* comparison between the solution vector from 32 bit machines vs
			 * maple on a pc shows that very small negative numbers are produced by
			 * the linear algebra package used by the code, but is positive with
			 * the math package.  allow very small negative numbers to occur,
			 * and silently reset to a postive number. 
			 *
			 * >>chng 04 feb 25
			 * Here we want to check if the negative abundance is a significant
			 * fraction of any of the species in the network.  The code below
			 * checks to see which elements the molecule in question is made of,
			 * then finds which one has the least abundance.  The one with
			 * the least abundance will then be used as the divisor in checking 
			 * if the negative abundance is too large to be ignored.*/
			
			/*  >>chng 04 apr 21, when an element in the chemical network is 
			 *  turned off, the molecular abundance of a species containing that
			 *  element was not zero but rather a small number of order 1e-20. When 
			 *  these abundances went negative, the code thought the abundances were
			 *  important because it checks the ratio of the species to its gas phase
			 *  abundance.  When the gas phase abundance is zero, the denominator is set 
			 *  to SMALLFLOAT, which is ~1e-35.  This led to a ratio of molecule to gas
			 *	phase of ~1e15, clearly unphysical.  Here the value of co_denominator 
			 *  will be set to a high value if the gas phase abundance is zero.*/

			if( dense.lgElmtOn[co.nelem_hevmol[i]] )
			{
				co_denominator = dense.gas_phase[co.nelem_hevmol[i]];
			}
			else
			{
				/* >>chng 04 apr 20, set to zero if element is off */
				co_denominator = 1e10;
			}

			
			/* we must have a positive value by now, unlesss element is turned off */
			ASSERT( co_denominator > SMALLFLOAT || !dense.lgElmtOn[co.nelem_hevmol[i]] );

			/* >>chng 04 feb 28, threshold from -1e-10 to -1e-6, the 
			 * level of roundoff in a float */
			/*if( bvec[i] / MAX2 (co_denominator, SMALLFLOAT) > -1e-10) */
			if( bvec[i] / SDIV(co_denominator) > -1e-6) 
			{
				/* this case, it is only slightly negative relative to
				 * the parent species - multiply by -1 to make positive
				 * and press on */
				bvec[i] *= -1.;
			}
			else
			{
				/*>>chng 04 mar 06 press on */
				*lgNegPop = TRUE;
				if( nzone>0 )
				{
					fprintf(ioQQQ,
						" CO_step neg pop for species %li %s, value is %.2e rel value is %.2e zone %.2f Te %.4e\n",
						i , 
						co.chLab[i] , 
						/* abs value */
						bvec[i], 
						/* relative value */
						bvec[i] / SDIV(co_denominator) ,
						fnzone,
						phycon.te);
				}
				bvec[i] *= -1;
				/*>>chng 04 jan 24 set to zero instead of *-1,
				 * h2_cr.in co density went to infinite, with some negative
				 * var getting to - inf */
				bvec[i] = SMALLFLOAT;
			} 
		}
		else if ( bvec[i] == 0. )
		{
			/* this is not used for anything in calling routine and 
			 * could be cleaned up */
			*lgZerPop = TRUE;
			/* >>chng 04 feb 28, zero pop not really a problem in very deep neutral
			 * gas - this happens */
#			if 0
			if( /*nzone>0 ||*/ CODEBUG>1 )
			{
				fprintf(ioQQQ," PROBLEM ");
				fprintf(ioQQQ,
					" CO_step zero pop for species %li %s, value is %.2e zone %li\n",
					i , co.chLab[i] , bvec[i], nzone);
			}
#			endif
			bvec[i] = SMALLFLOAT;
		}
		co.hevmol[i] = (float)bvec[i];
	}
	/* >>chng 04 mar 06 pass negative pop as a problem, but not a fatal one,
	 * also do not call this during 0th zone when search for conditions
	 * is underway */
	if( *lgNegPop && (nzone>0&&!conv.lgSearch)  )
	{
		conv.lgConvPops = FALSE;
		fprintf(ioQQQ," CO network negative population occurred, Te=%.4e, calling ConvFail. ",
			phycon.te);
		fprintf( ioQQQ, " CO/C=%9.1e", co.hevmol[ipCO]/SDIV(dense.gas_phase[ipCARBON]) );
		fprintf( ioQQQ, "\n" );
		/*ConvFail("pops", "CO");*/
		*lgNegPop = FALSE;
	}
	/* if negative pops were present need to renorm bvec to get
	 * proper sum rule */
	if( 0 && *lgNegPop )
	{

		for(j=0; j<2; ++j )
		{
			double sumcar = 0.;
			double sumoxy = 0.;
			double renorm;
			for ( i=0; i < NUM_COMOLE_CALC; i++ )
			{
				/* this case, different molecules */
				sumcar += co.hevmol[i]*co.nCarb[i];
				sumoxy += co.hevmol[i]*co.nOxyg[i];
			}
			renorm = (cartot_ion + oxytot_ion) / SDIV( sumcar+sumoxy);
			if(j)
				fprintf(ioQQQ,"\t%f\n", renorm);
			else
				fprintf(ioQQQ,"renormco\t%.2f\t%f", fnzone, renorm);
			for ( i=0; i < NUM_COMOLE_CALC; i++ )
			{
				co.hevmol[i] *= (float)renorm;
			}
		}
	}

	if ( merror != 0 )
	{
		fprintf( ioQQQ, " COMOLE matrix inversion error, MERROR=%5ld zone=%5ld\n", 
				 (long)merror, nzone );
		ShowMe();
		fprintf( ioQQQ, " Product matrix\n           " );

		for ( i=0; i < MIN2(NUM_COMOLE_CALC,8); i++ )
		{
			fprintf( ioQQQ, "%4.4s", co.chLab[i] );
		}
		fprintf( ioQQQ, "     \n" );

		for ( j=0; j < NUM_COMOLE_CALC; j++ )
		{
			fprintf( ioQQQ, " %4.4s", co.chLab[j] );
			fprintf( ioQQQ, " " );

			for ( i=0; i < MIN2(NUM_COMOLE_CALC,8); i++ )
			{
				fprintf( ioQQQ, "%9.1e", csav[i][j]*
						 co.hevmol[i] );
			}
			fprintf( ioQQQ, "\n" );
		}

		if ( NUM_COMOLE_CALC >= 9 )
		{
			fprintf( ioQQQ, " COMOLE matrix\n           " );
			for ( i=8; i < NUM_COMOLE_CALC; i++ )
			{
				fprintf( ioQQQ, "%4.4s", co.chLab[i] );
			}
			fprintf( ioQQQ, "     \n" );

			for ( j=0; j < NUM_COMOLE_CALC; j++ )
			{
				fprintf( ioQQQ, " %4.4s", co.chLab[j] );
				fprintf( ioQQQ, " " );
				for ( i=8; i < NUM_COMOLE_CALC; i++ )
				{
					fprintf( ioQQQ, "%9.1e", 
							 csav[i][j]* co.hevmol[i] );
				}
				fprintf( ioQQQ, "\n" );
			}
		}

		fprintf( ioQQQ, " Molecular densities relative to H2\n " );
		for ( j=0; j < NUM_COMOLE_CALC; j++ )
		{
			fprintf( ioQQQ, "%4.4s:%10.2e", co.chLab[j]
					 , co.hevmol[j] );
		}
		fprintf( ioQQQ, " \n" );

		puts( "[Stop in CO_step]" );
		cdEXIT(EXIT_FAILURE);
	}

	if ( trace.lgTrace && trace.lgTr_CO_Mole )
	{
		fprintf( ioQQQ, " Product matrix\n           " );

		for ( i=0; i < MIN2(NUM_COMOLE_CALC,8); i++ )
		{
			fprintf( ioQQQ, "%4.4s", co.chLab[i] );
		}
		fprintf( ioQQQ, "     \n" );

		for ( j=0; j < NUM_COMOLE_CALC; j++ )
		{
			fprintf( ioQQQ, " %4.4s", co.chLab[j] );
			fprintf( ioQQQ, " " );
			for ( i=0; i < MIN2(NUM_COMOLE_CALC,8); i++ )
			{
				fprintf( ioQQQ, "%9.1e", csav[i][j]*
						 co.hevmol[i] );
			}
			fprintf( ioQQQ, "\n" );

		}

		if ( NUM_COMOLE_CALC >= 9 )
		{
			fprintf( ioQQQ, " COMOLE matrix\n           " );
			for ( i=8; i < NUM_COMOLE_CALC; i++ )
			{
				fprintf( ioQQQ, "%4.4s", co.chLab[i] );
			}
			fprintf( ioQQQ, "     \n" );

			for ( j=0; j < NUM_COMOLE_CALC; j++ )
			{
				fprintf( ioQQQ, " %4.4s", co.chLab[j] );
				fprintf( ioQQQ, " " );

				for ( i=8; i < NUM_COMOLE_CALC; i++ )
				{
					fprintf( ioQQQ, "%9.1e", csav[i][j]* co.hevmol[i] );
				}
				fprintf( ioQQQ, "\n" );
			}
		}

		fprintf( ioQQQ, " Molecular densities relative to H2\n " );
		for ( j=0; j < NUM_COMOLE_CALC; j++ )
		{
			fprintf( ioQQQ, "%4.4s:%10.2e", co.chLab[j]
					 , co.hevmol[j] );
		}
		fprintf( ioQQQ, " \n" );
	}

	/*printf( " Here are all the densities\n " );
	printf( "CH: %.3e\tCH+: %.3e\tOH: %.3e\tOH+: %.3e\n"
		    "O2: %.3e\tCO: %.3e\tCO+: %.3e\tH2O: %.3e\n"
			"H2O+: %.3e\tO2+: %.3e\tH3O+: %.3e\tCH2+: %.3e\n"
			"CH2: %.3e\tC+: %.3e\tO+: %.3e\tC: %.3e\n"
			"O: %.3e\n", 
			co.hevmol[ipCH] ,co.hevmol[ipCHP] ,co.hevmol[ipOH] ,co.hevmol[ipOHP] ,
			co.hevmol[ipO2] ,co.hevmol[ipCO] ,co.hevmol[ipCOP] ,co.hevmol[ipH2O] ,
			co.hevmol[ipH2OP] ,co.hevmol[ipO2P] ,co.hevmol[ipH3OP] ,co.hevmol[ipCH2P] ,
			co.hevmol[ipCH2] ,co.hevmol[ipCP],co.hevmol[ipOP] ,co.hevmol[ipATC] , 
			co.hevmol[ipATO] );*/

	/* heating due to CO photodissociation */
	co.CODissHeat = (float)(co.CO_photo_dissoc_rate*co.hevmol[ipCO]*1e-12);

	thermal.heating[0][9] = co.CODissHeat;

	/* the real multi-level model molecule */
	abundan = co.hevmol[ipCO];
	/* IonStg and nelem were set to 2, 0 in makelevlines */
	ASSERT( C12O16Rotate[0].IonStg < LIMELM+2 );
	ASSERT( C12O16Rotate[0].nelem-1 < LIMELM+2 );
	dense.xIonDense[ C12O16Rotate[0].nelem-1][C12O16Rotate[0].IonStg-1] = abundan;

	CO_PopsEmisCool(&C12O16Rotate, nCORotate,abundan , "12CO",
		&CoolHeavy.C12O16Rot,&CoolHeavy.dC12O16Rot );
	/*if( nzone>400 )
		fprintf(ioQQQ,"DEBUG co cool\t%.2f\t%.4e\t%li\t%.4e\t%.4e\n",
			fnzone,CoolHeavy.C12O16Rot,nCORotate,abundan,phycon.te );*/

	abundan = co.hevmol[ipCO]/co.RatioC12O16_2_C13O16;
	/* IonStg and nelem were set to 3, 0 in makelevlines */
	ASSERT( C13O16Rotate[0].IonStg < LIMELM+2 );
	ASSERT( C13O16Rotate[0].nelem-1 < LIMELM+2 );
	dense.xIonDense[ C13O16Rotate[0].nelem-1][C13O16Rotate[0].IonStg-1] = abundan;

	CO_PopsEmisCool(&C13O16Rotate, nCORotate,abundan ,"13CO",
		&CoolHeavy.C13O16Rot,&CoolHeavy.dC13O16Rot );

	/* now set total density of each element locked in gas phase */
	for ( i=0;i<LIMELM; ++i )
	{
		dense.xMolecules[i] = 0.;
	}

	/* total number of H per unit vol in molecules,
	 * of course not including H0/H+ */
	for (i=0;i<N_H_MOLEC;i++) 
	{
		dense.xMolecules[ipHYDROGEN] += hmi.Hmolec[i]*hmi.nProton[i];
	}
	dense.xMolecules[ipHYDROGEN] -= (hmi.Hmolec[ipMH] + hmi.Hmolec[ipMHp]);

	/* >>chng 02 sep 05, dense.xMolecules[[ipHYDROGEN] is the part of H 
	 * that is not computed in hmole
	 * add in gas phase abundances locked in molecules
	 * H is special since treated in bidiag with all hmole molecules
	 * xMolecules are the densities of these species that are done in co,
	 * this sum is only up to NUM_HEAVY_MOLEC and so does not include the atoms/ions */
	for(i=0; i<NUM_HEAVY_MOLEC; ++i)
	{
		/* these were all initialized to zero above */
		dense.xMolecules[ipHYDROGEN] +=co.nHydr[i]*co.hevmol[i];
		dense.xMolecules[ipCARBON]   +=co.nCarb[i]*co.hevmol[i];
		dense.xMolecules[ipOXYGEN]   +=co.nOxyg[i]*co.hevmol[i];
		dense.xMolecules[ipSILICON]  +=co.nSili[i]*co.hevmol[i];
		dense.xMolecules[ipSULPHUR]  +=co.nSulp[i]*co.hevmol[i];
		dense.xMolecules[ipNITROGEN] +=co.nNitr[i]*co.hevmol[i];
	}

	/* if populations not conserved then not converged */
#	define EPS_MOLE	0.1
	if( dense.lgElmtOn[ipHYDROGEN] &&
		dense.xMolecules[ipHYDROGEN] > dense.gas_phase[ipHYDROGEN]*(1.+EPS_MOLE) )
	{
		conv.lgConvIoniz = FALSE;
		sprintf( conv.chConvIoniz, "COcon%2i",ipHYDROGEN );
		conv.BadConvIoniz[0] = dense.xMolecules[ipHYDROGEN];
		conv.BadConvIoniz[1] = dense.gas_phase[ipHYDROGEN];
	}
	else if( dense.lgElmtOn[ipCARBON] &&
		dense.xMolecules[ipCARBON] > dense.gas_phase[ipCARBON]*(1.+EPS_MOLE) )
	{
		conv.lgConvIoniz = FALSE;
		sprintf( conv.chConvIoniz, "COcon%2i",ipCARBON );
		conv.BadConvIoniz[0] = dense.xMolecules[ipCARBON];
		conv.BadConvIoniz[1] = dense.gas_phase[ipCARBON];
	}
	else if( dense.lgElmtOn[ipOXYGEN] &&
		dense.xMolecules[ipOXYGEN] > dense.gas_phase[ipOXYGEN]*(1.+EPS_MOLE) )
	{
		conv.lgConvIoniz = FALSE;
		sprintf( conv.chConvIoniz, "COcon%2i",ipOXYGEN );
		conv.BadConvIoniz[0] = dense.xMolecules[ipOXYGEN];
		conv.BadConvIoniz[1] = dense.gas_phase[ipOXYGEN];
	}
	else if( dense.lgElmtOn[ipSILICON] &&
		dense.xMolecules[ipSILICON] > dense.gas_phase[ipSILICON]*(1.+EPS_MOLE) )
	{
		conv.lgConvIoniz = FALSE;
		sprintf( conv.chConvIoniz, "COcon%2i",ipSILICON );
		conv.BadConvIoniz[0] = dense.xMolecules[ipSILICON];
		conv.BadConvIoniz[1] = dense.gas_phase[ipSILICON];
	}
	else if( dense.lgElmtOn[ipSULPHUR] &&
		dense.xMolecules[ipSULPHUR] > dense.gas_phase[ipSULPHUR]*(1.+EPS_MOLE) )
	{
		conv.lgConvIoniz = FALSE;
		sprintf( conv.chConvIoniz, "COcon%2i",ipSULPHUR );
		conv.BadConvIoniz[0] = dense.xMolecules[ipSULPHUR];
		conv.BadConvIoniz[1] = dense.gas_phase[ipSULPHUR];
	}
	else if( dense.lgElmtOn[ipNITROGEN] &&
		dense.xMolecules[ipNITROGEN] > dense.gas_phase[ipNITROGEN]*(1.+EPS_MOLE) )
	{
		conv.lgConvIoniz = FALSE;
		sprintf( conv.chConvIoniz, "COcon%2i",ipNITROGEN );
		conv.BadConvIoniz[0] = dense.xMolecules[ipNITROGEN];
		conv.BadConvIoniz[1] = dense.gas_phase[ipNITROGEN];
	}
#	undef EPS_MOLE

#	ifdef DEBUG_FUN
	fputs( " <->CO_step()\n", debug_fp );
#	endif
	return;
}

/*lint +e550 */

/* evaluate CO rotation cooling */
void CO_PopsEmisCool(
		EmLine ** Rotate , 
		long int nRotate ,
		float abundan, 
		char * chLabel ,
		float * Cooling ,
		float * dCoolingDT  )
{

	/* will need to MALLOC space for these but only on first call */
	static double **data, 
	**dest, 
	/* pump[low][high] is rate (s^-1) from lower to upper level */
	**pump,
	**CollRate,
	*pops,
	*create,
	*destroy,
	*depart,
	/* statistical weight */
	*stat ,
	/* excitation energies in kelvin */
	*excit;

	/*static long int **ipdest;*/

	static int lgFirst=TRUE;
	long int i,
	j,
	ilo , 
	ihi;
	static long int nUsed;
	int lgDeBug,lgNegPop;
	double rot_cooling , dCoolDT ;
	static long int ndimMalloced = 0;

#	ifdef DEBUG_FUN
	fputs( "<+>CO_PopsEmisCool()\n", debug_fp );
#	endif

	if ( lgFirst )
	{
		/* will never do this again */
		lgFirst = FALSE;
		/* remember how much space we malloced in case ever called with more needed */
		ndimMalloced = nRotate;
		/* allocate the 1D arrays*/
		if ( (excit = (double *)MALLOC( sizeof(double)*(size_t)(nRotate+1) )) == NULL )
			BadMalloc();
		if ( (stat = (double *)MALLOC( sizeof(double)*(size_t)(nRotate+1) )) == NULL )
			BadMalloc();
		if ( (pops = (double *)MALLOC( sizeof(double)*(size_t)(nRotate+1) )) == NULL )
			BadMalloc();
		if ( (create = (double *)MALLOC( sizeof(double)*(size_t)(nRotate+1) )) == NULL )
			BadMalloc();
		if ( (destroy = (double *)MALLOC( sizeof(double)*(size_t)(nRotate+1) )) == NULL )
			BadMalloc();
		if ( (depart = (double *)MALLOC( sizeof(double)*(size_t)(nRotate+1) )) == NULL )
			BadMalloc();
		/* create space for the 2D arrays */
		if ( (pump = ((double **)MALLOC((size_t)(nRotate+1)*sizeof(double *)))) == NULL )
			BadMalloc();
		if ( (CollRate = ((double **)MALLOC((size_t)(nRotate+1)*sizeof(double *)))) == NULL )
			BadMalloc();
		if ( (dest = ((double **)MALLOC((size_t)(nRotate+1)*sizeof(double *)))) == NULL )
			BadMalloc();
		if ( (data = ((double **)MALLOC((size_t)(nRotate+1)*sizeof(double *)))) == NULL )
			BadMalloc();
		/*if ( (ipdest = ((long int **)MALLOC((size_t)(nRotate+1)*sizeof(long int *)))) == NULL )
			BadMalloc();*/
		for ( i=0; i<(nRotate+1); ++i )
		{
			if ( (pump[i] = ((double *)MALLOC((size_t)(nRotate+1)*sizeof(double )))) == NULL )
				BadMalloc();
			if ( (CollRate[i] = ((double *)MALLOC((size_t)(nRotate+1)*sizeof(double )))) == NULL )
				BadMalloc();
			if ( (dest[i] = ((double *)MALLOC((size_t)(nRotate+1)*sizeof(double )))) == NULL )
				BadMalloc();
			if ( (data[i] = ((double *)MALLOC((size_t)(nRotate+1)*sizeof(double )))) == NULL )
				BadMalloc();
			/*if ( (ipdest[i] = ((long int *)MALLOC((size_t)(nRotate+1)*sizeof(double )))) == NULL )
				BadMalloc();*/
		}
	}
	/* this is test for call with too many rotation levels to handle - logic needs
	 * for largest rotor to be called first */
	if ( nRotate > ndimMalloced )
	{
		fprintf(ioQQQ," CO_PopsEmisCool has been called with the number of rotor levels greater than space allocated.\n");
		puts( "[Stop in CO_PopsEmisCool]" );
		cdEXIT(EXIT_FAILURE);
	}

	/* all elements are used, and must be set to zero if zero */
	for ( i=0; i < (nRotate+1); i++ )
	{
		create[i] = 0.;
		destroy[i] = 0.;
		for ( j=0; j < (nRotate+1); j++ )
		{
			data[j][i] = -1e33;
			dest[j][i] = 0.;
			pump[j][i] = 0.;
		}
		data[i][i] = 0.;
	}

	/* the statistical weights of the levels */
	for ( j=0; j < nRotate; j++ )
	{
		/* statistical weights for each level */
		stat[j] = (*Rotate)[j].gLo;
	}
	/* this is the highest level, which is one more than the highest line */
	stat[nRotate] = (*Rotate)[nRotate-1].gHi;

	/* set up the excitation potentials of each level relative to ground -
	 * the struc saves the energy of the line only */
	excit[0] = 0.;
	for ( j=1; j < nRotate; j++ )
	{
		/* excitation energy of each level relative to ground, in K */
		excit[j] = excit[j-1] + (*Rotate)[j-1].EnergyK;
	}

	/* this is the highest level, which is one more than the highest line */
	excit[nRotate] = excit[nRotate-1] + (*Rotate)[nRotate-1].EnergyK;

	nUsed = nRotate;

	/* this determines the largest molecule that can be inverted at this
	 * temperature.  Need boltzmann factors to be positive for all levels
	 * nUsed is the index of the highest level, so the number of levels (passed
	 * to the solver) is nUsed+1 
	 * excit[nUsed]/phycon.te cannot be much larger than 20, or matrix inversion will fail */
	/* >>chng 03 sep 18, allow to go to 1, a two level atom */
	/*while ( (excit[nUsed] > phycon.te*20.) && (nUsed > 1) )*/
	/* >>chng 03 oct 03, chng 20 to 25 */
	/*while ( (excit[nUsed] > phycon.te*25.) && (nUsed > 1) )*/
	/* >>chng 03 oct 03, keep at least 5 levels */
	/*while ( (excit[nUsed] > phycon.te*25.) && (nUsed > 1) )*/
	while ( (excit[nUsed] > phycon.te*25.) && (nUsed > 5) )
	{
		--nUsed;
	}

	for ( j=0; j < nRotate; j++ )
	{
		data[j][j+1] = (*Rotate)[j].Aul*((*Rotate)[j].Pesc + (*Rotate)[j].Pelec_esc);
		dest[j][j+1] = (*Rotate)[j].Aul*(*Rotate)[j].Pdest;
		/* next 2 not not used by levelN since flag passed saying to use CollRate instead */
		(*Rotate)[j].cs = 1.;
		/*data[j+1][j] = (*Rotate)[j].cs*hmi.Hmolec[ipMH2g]/dense.eden ;*/
		data[j+1][j] = (*Rotate)[j].cs*hmi.H2_total/dense.eden ;
		/* photon pumping rate */
		pump[j][j+1] = (*Rotate)[j].pump;
		/* the continuum indices are on the f, not c, scale, and will be passed to 
		 * atom_levelN, which works on f, not c, scale */
		/*ipdest[j][j+1] = (*Rotate)[j].ipCont;*/
	}

	/* next loop for collisional transitions that have delta J >1 */
	for ( ilo=0; ilo < nRotate-1; ilo++ )
	{
		/* need to have upper limit to to nRotate because 
		 * number ov levels is 1 gt number of lines*/
		for ( ihi=ilo+2; ihi <= nRotate; ihi++ )
		{
			/* this is not used by levelN since flag passed saying to use CollRate instead */
			/*data[ihi][ilo] = 1. *hmi.Hmolec[ipMH2g]/dense.eden ;*/
			data[ihi][ilo] = 1. *hmi.H2_total/dense.eden ;
			/* these are escape and dest rates, which are zero for a rigid rotator */
			data[ilo][ihi] = 0 ;
			dest[ilo][ihi] = 0 ;
		}
	}

	/* now evaluate the H2 collision rates */
	/* recall one more level than lines */
	for ( ilo=0; ilo < nRotate; ilo++ )
	{
		/* need to have upper limit to to nRotate because 
		 * number of levels is 1 gt number of lines*/
		for ( ihi=ilo+1; ihi <= MIN2(nRotate,ilo+5); ihi++ )
		{
			/* >>refer	CO-H2	collision	de Jong, T., Chu, S-I., & Dalgarno, A. 1975, ApJ, 199, 69 */
			double a[5]={1.66, 2.80, 1.19, 1.00, 1.30};
			double b[5]={1.67, 1.47, 1.85, 1.55, 2.24};
			/* >>refer	CO-He	collision	McKee, C.F., Storey, J.W.V., Watson, D.M., & Green, S., 1982, ApJ, 259, 647 */
			/* this reference gives He-CO collisions,
			 * their table 1 says He collisions are 1.37 slower than H2 collisions*/
			/* >>chng 03 sep 19, from grnd H2 to total H2 */
			double collid = hmi.H2_total + dense.xIonDense[ipHELIUM][0]/1.37;
			/* de Jong et al. explicitly consider temperatures as low as 20K,
			 * don't extrapolate signifcantly lower than this */
			double TeUsed = MAX2(10., phycon.te );

			/* first do deexcitation rate, equation 17 of deJong et al. */
			CollRate[ihi][ilo] = a[ihi-ilo-1]*1.e-10*(*Rotate)[ilo].gLo/(*Rotate)[ilo].gHi*
				(1.+(excit[ihi]-excit[ilo])/TeUsed) *
				sexp( b[ihi-ilo-1]*sqrt((excit[ihi]-excit[ilo])/TeUsed) )*collid;
			/* this is mainly so that rest of code gets valid cs in case crit dense printed */
			if ( ihi == ilo+1 )
			{
				/* save downward collision rate */
				(*Rotate)[ilo].ColUL = (float)CollRate[ihi][ilo];
				/* convert into fake electron collision strength */
				LineConvRate2CS( &(*Rotate)[ilo] , (*Rotate)[ilo].ColUL);
			}

			/* now get excitation rate */
			CollRate[ilo][ihi] = CollRate[ihi][ilo]*
				sexp( (excit[ihi]-excit[ilo])/phycon.te )*
				(*Rotate)[ilo].gHi / (*Rotate)[ilo].gLo;

			/* debug print statement */
			/*fprintf(ioQQQ," %li %li %.2e %.2e \n",ilo, ihi, 
				CollRate[ihi][ilo]/hmi.H2_total  , CollRate[ilo][ihi]/hmi.H2_total );*/
		}
		/* finish off with zeros */
		for ( ihi=ilo+6; ihi <= nRotate; ihi++ )
		{
			CollRate[ihi][ilo] = 0.;
			CollRate[ilo][ihi] = 0.;
		}
	}

	lgDeBug = FALSE;

	atom_levelN(
		  /* number of levels is number of lines plus one */
		  /* set nUsed so that CO is evaluated even at very low temperatures */
		  nUsed+1, /*nRotate+1,*/
		  abundan,
		  stat,
		  excit,
		  pops,
		  depart,
		  &data,
		  &dest,
		  &pump,
		  &CollRate,
		  create,
		  destroy,
		  /* say that we have evaluated the collision rates already */
		  TRUE,
		  /*&ipdest,*/
		  &rot_cooling,
		  &dCoolDT,
		  chLabel,
		  /* lgNegPop positive if negative pops occured, negative if too cold */
		  &lgNegPop,
		  lgDeBug );/* option to print stuff - set to true for debug printout */

	/* put cooling into place where we can use it later */
	*Cooling = (float)rot_cooling;

	/* >>chng 03 sep 18, CO rot cooling temp deriv is too small, and temp
	 * changes too big - incr deriv by 5x 
	*dCoolingDT = (float)(dCoolDT);*/
	*dCoolingDT = (float)(rot_cooling/phycon.te);

#	if 0
	if( lgMainCO )
		fprintf(ioQQQ,"COcool\t%i\t%.2f\t%e\t%e\t%e\t%e\t%e\n",
		nUsed,
		fnzone,
		phycon.te,
		*Cooling/abundan,
		*dCoolingDT ,
		*Cooling,
		thermal.htot );/**/
#	endif

	/* zero out higher populations for case where full CO levels not done */
	for ( i=nUsed+1; i<=nRotate; ++i )
	{
		pops[i] = 0.;
		depart[i] = 0.;
	}

	/* can only define first LIMLEVELN elements, the vector's length */
	for ( i=0; i< MIN2(LIMLEVELN,nRotate) ; ++i )
	{
		atoms.PopLevels[i] = pops[i];
		atoms.DepLTELevels[i] = depart[i];
	}

	if ( lgNegPop > 0 )
	{
		fprintf(ioQQQ,"CO_PopsEmisCool called atom_levelN which returned negative populations.\n");
	}

	/* now establish information that is passed out to rest of code's infrastructure */
	for ( j=0; j<nRotate; ++j )
	{
		double EnrLU, EnrUL;
		/* lower upper populations, stim emission correct population */
		(*Rotate)[j].PopLo = pops[j];
		(*Rotate)[j].PopHi = pops[j+1];
		(*Rotate)[j].PopOpc = (pops[j] - pops[j+1]*(*Rotate)[j].gLo/(*Rotate)[j].gHi);

		/* number of photons in the line */
		(*Rotate)[j].phots = (*Rotate)[j].Aul*((*Rotate)[j].Pesc + (*Rotate)[j].Pelec_esc)*pops[j+1];

#		if 0
		/* >>chng 03 oct 04, moved to RT_OTS */
		/* local ots rates, added to line ots array */
		(*Rotate)[j].ots = (*Rotate)[j].Aul*(*Rotate)[j].Pdest*(float)(*Rotate)[j].PopHi;
		RT_OTS_AddLine( (*Rotate)[j].ots , (*Rotate)[j].ipCont);
#		endif

		/* the intensity in the line */
		(*Rotate)[j].xIntensity = (*Rotate)[j].phots*(*Rotate)[j].EnergyErg;

		/* ratio of collisional to total excitation */
		(*Rotate)[j].ColOvTot = (float)(CollRate[j][j+1]/(CollRate[j][j+1]+(*Rotate)[j].pump) );

		/* two cases - collisionally excited (usual case) or 
		 * radiatively excited - in which case line can be a heat source
		 * following are correct heat exchange, if will mix to get correct deriv */
		EnrLU = (*Rotate)[j].PopLo*CollRate[j][j+1]*(*Rotate)[j].EnergyErg;
		EnrUL = (*Rotate)[j].PopHi*CollRate[j+1][j]*(*Rotate)[j].EnergyErg;
		/* energy exchange due to this level
		 * net cooling due to excit minus part of de-excit */
		(*Rotate)[j].cool = EnrLU - EnrUL*(*Rotate)[j].ColOvTot;
		/* net heating is remainder */
		(*Rotate)[j].heat = EnrUL*(1.f - (*Rotate)[j].ColOvTot);
		/* do not add to cooling, since done with evaluated cooling from atom_levelN */
		/*CoolAdd( chLabel, (long)t10->WLAng , t10->cool);*/
	}

	/* generate flag if co cooling important and highest level is fainter
	 * than second highest level */
	if ( rot_cooling / thermal.ctot > 0.1 && 
		 (*Rotate)[nUsed-1].xIntensity > (*Rotate)[nUsed-2].xIntensity &&
		 /*>>chng 03 oct 03, add check whether molecule has been trimed down 
		  * due to small Boltzmann factor */ 
		 /* >>chng 03 oct 20, following had ; after ), so CoolCaped always true */
		 nUsed == nRotate )
	{
		co.lgCOCoolCaped = TRUE;
	}

#	ifdef DEBUG_FUN
	fputs( " <->CO_PopsEmisCool()\n", debug_fp );
#	endif

	return;
}

/*CO_colden maintain H2 column densities within X */
void CO_colden( char *chLabel )
{
	long int iRot;

	if ( strcmp(chLabel,"ZERO") == 0 )
	{
		static int lgFIRST=TRUE;
		if ( lgFIRST )
		{
			lgFIRST = FALSE;
			if ( (col12 = (double *)MALLOC( sizeof(double)*(size_t)(nCORotate+1) )) == NULL )
				BadMalloc();
			if ( (col13 = (double *)MALLOC( sizeof(double)*(size_t)(nCORotate+1) )) == NULL )
				BadMalloc();
		}
		/* the column density (cm-2) of ortho and para H2 */
		/* zero out formation rates and column densites */
		for ( iRot=0; iRot<=nCORotate; ++iRot )
		{
			/* zero it out */
			col12[iRot] = 0.;
			col13[iRot] = 0.;
		}
	}
	else if ( strcmp(chLabel,"ADD ") == 0 )
	{
		/*  add together column densities */
		for ( iRot=0; iRot<nCORotate; ++iRot )
		{
			/* zero it out */
			col12[iRot] += C12O16Rotate[iRot].PopLo*radius.drad_x_fillfac;
			col13[iRot] += C13O16Rotate[iRot].PopLo*radius.drad_x_fillfac;
		}
	}

	/* we will not print column densities so skip that - if not print then we have a problem */
	else if ( strcmp(chLabel,"PRIN") != 0 )
	{
		fprintf( ioQQQ, " CO_colden does not understand the label %s\n", 
				 chLabel );
		puts( "[Stop in CO_colden]" );
		cdEXIT(EXIT_FAILURE);
	}
}

/*cdCO_colden return column density in H2, negative -1 if cannot find state,
 * header is cddrive */
double cdCO_colden( long isotope , long iRot )
{

	/* make sure incoming parameters are ok */
	if ( isotope !=12 && isotope != 13 )
	{
		fprintf(ioQQQ," cdCO_colden can only do 12CO and 13CO\n");
		return -1.;
	}
	if ( iRot < 0 || iRot > nCORotate )
	{
		fprintf(ioQQQ," cdCO_colden - rotation quantum number must be 0 or greater, and less than %li\n", 
				nCORotate);
		return -1.;
	}

	/* the incoming parameters are fully qualified - return the column density */
	if ( isotope == 12 )
	{
		return col12[iRot];
	}
	else
	{
		return col13[iRot];
	}
}

/*CO_OTS - add CO lines to ots fields */
void CO_OTS( void )
{

	long int j;

#	ifdef DEBUG_FUN
	fputs( "<+>CO_OTS()\n", debug_fp );
#	endif

	/* add all CO lines */
	for ( j=0; j<nCORotate; ++j )
	{
		C12O16Rotate[j].ots = C12O16Rotate[j].Aul*C12O16Rotate[j].Pdest*
			(float)C12O16Rotate[j].PopHi;
		RT_OTS_AddLine( C12O16Rotate[j].ots , C12O16Rotate[j].ipCont);

		C13O16Rotate[j].ots = C13O16Rotate[j].Aul*C13O16Rotate[j].Pdest*
			(float)C13O16Rotate[j].PopHi;
		RT_OTS_AddLine( C13O16Rotate[j].ots , C13O16Rotate[j].ipCont);
	}

#	ifdef DEBUG_FUN
	fputs( " <->CO_OTS()\n", debug_fp );
#	endif
	return;
}
/*lint +e778 constant expression evaluatess to 0 in operation '-' */

