/* This file is part of Cloudy and is copyright (C) 1978-2004 by Gary J. Ferland.
 * For conditions of distribution and use, see copyright notice in license.txt */
/*CO_drive main driver for heavy molecular equilibrium routines */
void CO_drive(void);

/*CO_step fills in matrix for heavy elements molecular routines */
void CO_step(
	/* set true if we found neg pops */
	int *lgNegPop, 
	/* set true if we tried to compute the pops, but some were zero */
	int *lgZerPop );

/* evaluate rotation levels populations, emission and cooling */
void CO_PopsEmisCool(EmLine ** Rotate , long int nRotate , float abund, 	
	/* string used to identify calling program in case of error */
	char *chLabel , float *Cooling , float * dCoolingdT  );

/*CO_colden maintain H2 column densities within X */
void CO_colden( char *chLabel );

/* called from cdInit to initialized co routines */
void CO_Init(void);

/*CO_OTS - add CO lines to ots fields, called by RT_OTS */
void CO_OTS( void );

/* >>chng 03 feb 09, rm ipH3P_hev, since not used, and decrement NUM_HEAVY_MOLEC to 17 */
/* >>chng 03 aug 04, rm ipCTWO and ipC2P from hevmol since not included in balance,
 * and always finds zero column density, so NUM_HEAVY_MOLEC from 17 to 15 */
/* >>chng 03 aug 05, rm ch2 and ch3, so n from 15 to 13 */
/* >>chng 03 nov 14  add Si chemistry & CH3+, so that now every
     reaction that is in the TH85 chemical network is also included
     in Cloudy.  Additionally, there are also reactions taken from other
     papers (mostly Hollenbach and McKee...see co.c).  In all 20 molecular
     species are calculated, along with the atomic and first ionization 
	 stages of C, O, and Si*/
/* >>chng 04 May 13, Nick Abel.  Add CH3, CH4, CH4+, and CH5+ to network in order 
	to get the same chemical abundances vs. depth as other PDR codes in the Leiden
	meeting.  With changes we now can predict molecular abundances for 24 C, O, 
	and Si bearing molecules. */

/* >>chng 04 jul 13, Nick Abel.  Add nitrogen and sulphur bearing molecules
   * to the chemical network.  First added to generate a chemical model for
   * eta carinae, but is applicable to all molecular clouds */

	 
#define	NUM_HEAVY_MOLEC	61

/* define a new parameter that includes the atomic and first ionized species
   of each element that can combine to form molecules.  This is used in comole
   to improve the calculation, as deep in molecular regions reactions with molecules
   can be important to the ionization balance */

#define NUM_COMOLE_CALC 71 

/* define the number of atomic elements used in the chemical network */

#define NUM_ELEMENTS 5

#define	ipCH	0
#define	ipCHP	1
#define	ipOH	2
#define	ipOHP	3
#define	ipO2  	4
#define	ipCO	5
#define	ipCOP	6
#define	ipH2O	7
#define	ipH2OP	8
#define	ipO2P	9
#define	ipH3OP	10
#define	ipCH2P	11
#define ipCH2   12
#define ipHCOP  13
#define ipCH3P  14
#define ipSIH2P 15
#define ipSIH   16
#define ipHOSIP 17
#define ipSIO   18
#define ipSIOP  19
#define ipCH3   20
#define ipCH4   21
#define ipCH4P  22
#define ipCH5P  23
#define	ipN2	24
#define	ipN2P	25
#define	ipNO	26
#define	ipNOP	27
#define	ipS2  	28
#define	ipS2P	29
#define	ipOCN	30
#define	ipOCNP	31
#define	ipNH	32
#define	ipNHP	33
#define	ipNH2	34
#define	ipNH2P	35
#define ipNH3   36
#define ipNH3P  37
#define ipNH4P  38
#define ipCN    39
#define ipCNP   40
#define ipHCN   41
#define ipHCNP  42
#define ipHNO   43
#define ipHNOP  44
#define ipHS    45
#define ipHSP   46
#define ipCS    47
#define	ipCSP	48
#define	ipNO2	49
#define	ipNO2P	50
#define	ipNS	51
#define	ipNSP  	52
#define	ipSO	53
#define	ipSOP	54
#define	ipSIN	55
#define	ipSINP 	56
#define	ipN2O	57
#define	ipHCSP	58
#define	ipOCS	59
#define	ipOCSP	60
#define ipCP    61
#define ipOP    62
#define	ipSIP	63
#define ipNP    64
#define ipSP    65
#define ipATC   66
#define ipATO   67
#define ipATSI  68
#define ipATN   69
#define ipATS   70


EXTERN struct t_co {

	/* CODissHeat is CO Photodissociation heating */
	float CODissHeat, 
	  /* largest fraction of total heating */
	  codfrc, 
	  /* total heating integrated over cloud */
	  codtot;

	/* flag saying what fraction of total cooling was carried by CO */
	double COCoolBigFrac;

	/* flag saying CO is important but lines capped by highest level */
	int lgCOCoolCaped;

	/* rate OH + hnu -> H + O*, cm-3 s-1, per unit vol and time */
	float rate_OH_dissoc;

	/* flag to turn off CO molecules, set with no molecules command */
	int lgNoCOMole;

	/* molecules of the heavy elements.  order must exactly match that in hevcolumn
	 * number of molecules in heavy element network */

	/* the density (cm-3) of each species */
	float hevmol[NUM_COMOLE_CALC], 
	  /* total column density in this iteration */
	  hevcol[NUM_COMOLE_CALC], 
	  /* column density in previous iteration */
	  hevcol_old[NUM_COMOLE_CALC],
	  /* these are source and sink terms for the hydrogen molecular
	     network that appear in co.c */
	  hydro_sink[8],
	  hydro_source[8], 
	  /* the particle densities in first zone where CO computed,
	   * in last iteration */
	  HevMolSav[NUM_COMOLE_CALC] ,
	  xMoleFracMax[NUM_COMOLE_CALC];

	/* this is the atomic number of the main element within the molecule */
	int nelem_hevmol[NUM_COMOLE_CALC];

	/* previous soln to molec network */
	float co_save[NUM_COMOLE_CALC];

	/* abundance ratio C12O16 to C13O16, init in zero.c  */
	float RatioC12O16_2_C13O16;

	/* flag set true if H2O deEXTERN struction rate went to zero */
	int lgH2Ozer;

	/* set rates to that in UMIST */
    int lgUMISTrates;

	double h2lim;

	long co_nzone , iteration_co;

	/* labels for the molecule names */
	char chLab[NUM_COMOLE_CALC][6];

	/* total electron density in molecules */
	double comole_eden;

	/* number of O, C, Si, N, S, and e- in each molecule */
	int nHydr[NUM_COMOLE_CALC];
	int nCarb[NUM_COMOLE_CALC];
	int nOxyg[NUM_COMOLE_CALC];
	int nElec[NUM_COMOLE_CALC];
	int nSili[NUM_COMOLE_CALC];
	int nNitr[NUM_COMOLE_CALC];
	int nSulp[NUM_COMOLE_CALC];

	/* the van Dishoeck & Black CO photodissociation rate */
	float CO_photo_dissoc_rate;

	/* The following are rates used in determining the ionization balance of helium */
	float rate_co_hep_o_cp_he,
		hep_destroy,
		rate_HeP_CO_O_CP_He,
		rate_HeP_CH_CHP_He,
		rate_HeP_H2O_H2OP_He, 	
		rate_HeP_O2_O2P_He,       
		rate_HeP_Si_SiP_He,	
		rate_HeP_CH_CP_He_H,    
		rate_HeP_CH2_CHP_He_H,	
		rate_HeP_OH_OP_He_H,    
		rate_HeP_H2O_OHP_He_H,	
		rate_HeP_SiH_SiP_He_H,   
		rate_HeP_H2O_OH_He_HP,	
		rate_HeP_CH2_CP_He_H2, 
		rate_HeP_O2_OP_O_He,	
		rate_HeP_SiO_SiP_O_He,
		rate_HeP_SiO_Si_OP_He,	
		rate_HeP_CH3_CHP_He,
		rate_HeP_CH4_CHP_He,	
		rate_HeP_CH4_CH2P_He,
		rate_HeP_CH4_CH3_He,	
		rate_HeP_CH4_CH3P_He,
		rate_HeP_CH4_CH4P_He,
		rate_HeP_NH_NP_He_H	 ,
		rate_HeP_NH2_NP_He_H2     ,	
		rate_HeP_NH2_NHP_He_H    ,
		rate_HeP_NH3_NHP_He_H2   ,	
		rate_HeP_NH3_NH2P_He_H   ,
		rate_HeP_CN_N_CP_He      ,	
		rate_HeP_CN_NP_C_He      ,
		rate_HeP_HCN_N_CHP_He    ,	
		rate_HeP_HCN_NP_CH_He    ,
		rate_HeP_HCN_N_CP_He_H   ,	
		rate_HeP_HCN_CNP_He_H    ,
		rate_HeP_N2_NP_N_He      ,	
		rate_HeP_NO_OP_N_He      ,
		rate_HeP_NO_O_NP_He      ,
		rate_HeP_HNO_NOP_He_H    ,
		rate_HeP_HNO_NO_He_HP    ,	
		rate_HeP_HS_SP_He_H      ,
		rate_HeP_OCN_CN_OP_He    ,
		rate_HeP_OCN_CNP_O_He    ,
		rate_HeP_SIN_SIP_N_He    ,
		rate_HeP_N2O_N2_OP_He    ,
		rate_HeP_N2O_N2P_O_He    ,
		rate_HeP_N2O_NO_NP_He    ,
		rate_HeP_N2O_NOP_N_He    ,
		rate_HeP_CS_SP_C_He      ,
		rate_HeP_CS_S_CP_He      ,
		rate_HeP_NS_S_NP_He      ,
		rate_HeP_NS_SP_N_He      ,
		rate_HeP_SO_S_OP_He      ,
		rate_HeP_SO_SP_O_He      ,
		rate_HeP_OCS_SP_CO_He    ,
		rate_HeP_OCS_S_COP_He    ,
		rate_HeP_OCS_CSP_O_He    ,
		rate_HeP_OCS_CS_OP_He    ,
		rate_HeP_S2_SP_S_He      ,
		rate_HeP_NH3_NH3P_He     ,
		rate_HeP_N2_N2P_He       ;

	/*  These reactions and included in hmole_step as formation and destruction processes */

	double H_CH_C_H_H           ;
	double H_OH_O_H_H	     ;
	double H_H2O_OH_H_H         ;
	double H_COP_CO_HP          ;	
	double H_CH_C_H2            ;
	double H_CHP_CP_H2          ;
	double H_CH2_CH_H2          ;
	double H_CH3P_CH2P_H2       ;
	double H_OH_O_H2            ;
	double H_H2O_OH_H2          ;
	double Hminus_HCOP_CO_H2    ;
	double Hminus_H3OP_H2O_H2   ;
	double Hminus_H3OP_OH_H2_H  ;
	double HP_CH_CHP_H          ;
	double HP_CH2_CH2P_H        ;
	double HP_H2O_H2OP_H        ;
	double HP_O2_O2P_H          ;
	double HP_OH_OHP_H          ;
	double HP_SiO_SiOP_H        ;
	double HP_CH2_CHP_H2        ;
	double HP_SiH_SiP_H2        ;
	double H2_CHP_CH2P_H        ;
	double H2_CH2P_CH3P_H       ;
	double H2_OHP_H2OP_H        ;
	double H2_H2OP_H3OP_H       ;
	double H2_COP_HCOP_H        ;
	double H2_OP_OHP_H          ;
	double H2_SiOP_SiOHP_H      ;
	double H2_C_CH_H            ;
	double H2_CP_CHP_H          ;
	double H2_CH_CH2_H          ;
	double H2_OH_H2O_H          ;
	double H2_O_OH_H            ;
	double H2_CH_C_H2_H         ;
	double H2_OH_O_H2_H         ;
	double H2_H2O_OH_H2_H       ;
	double H2_O2_O_O_H2         ;
	double H2_O2_OH_OH          ;
	double H2s_CH_C_H2_H        ;
	double H2s_OH_O_H2_H        ;
	double H2s_H2O_OH_H2_H      ;
	double H2s_O2_O_O_H2        ;
	double H2P_C_CHP_H          ;
	double H2P_CH_CH2P_H        ;	
	double H2P_CH2_CH3P_H       ;
	double H2P_OH_H2OP_H        ;
	double H2P_H2O_H3OP_H       ;
	double H2P_CO_HCOP_H        ;
	double H2P_O_OHP_H          ;	
	double H2P_CH_CHP_H2        ;
	double H2P_CH2_CH2P_H2      ;
	double H2P_CO_COP_H2        ;
	double H2P_H2O_H2OP_H2      ;
	double H2P_O2_O2P_H2        ;
	double H2P_OH_OHP_H2        ;
	double H3P_C_CHP_H2         ;
	double H3P_CH_CH2P_H2       ;
	double H3P_CH2_CH3P_H2      ;
	double H3P_OH_H2OP_H2       ;
	double H3P_H2O_H3OP_H2      ;
	double H3P_CO_HCOP_H2       ;
	double H3P_O_OHP_H2         ;
	double H3P_SiH_SiH2P_H2     ;
	double H3P_SiO_SiOHP_H2     ;
	double h2s_ch_ch2_h         ;
	double h2s_o_oh_h           ;
	double h2s_oh_h2o_h         ;
	double h2s_c_ch_h           ;
	double h2s_cp_chp_h         ;
	double H_CH3_CH2_H2         ;
	double H_CH4P_CH3P_H2       ;
	double H_CH5P_CH4P_H2       ;
	double H2_CH2_CH3_H         ;
	double H2_CH3_CH4_H         ;
	double H2_CH4P_CH5P_H       ;
	double H2s_CH2_CH3_H        ;
	double H2s_CH3_CH4_H        ;
	double H2P_CH4_CH3P_H2      ;
	double H2P_CH4_CH4P_H2      ;
	double H2P_CH4_CH5P_H       ;
	double H3P_CH3_CH4P_H2      ;
	double H3P_CH4_CH5P_H2      ;
	double HP_CH3_CH3P_H        ;
	double HP_CH4_CH3P_H2       ;
	double HP_CH4_CH4P_H        ;

	double C_H3OP_HCOP_H2_1,
	C_OH_CO_H_1,
	CP_OH_CO_HP_1,
	CP_H2O_HCOP_H_1,
	CP_OH_COP_H_1,
	O_CH_CO_H_1,
	O_CHP_COP_H_1,
	O_CH2_CO_H_H_1,
	O_CH2_CO_H2_1,
	O_CH2P_HCOP_H_1,
	O_CH3P_HCOP_H2_1,
	O_H2OP_O2P_H2_1,
	O_OH_O2_H_1,
	O_OHP_O2P_H_1,
	O_SiH_SiO_H_1,
	O_SiH2P_SiOHP_H_1,
	OP_CH_COP_H_1,
	OP_OH_O2P_H_1,
	Si_OH_SiO_H_1,
	SiP_H2O_SiOHP_H_1,
	SiP_OH_SiOP_H_1,
	CHP_H2O_HCOP_H2_1,
	CHP_OH_COP_H2_1,
	H_C_CH_nu,
	H_CP_CHP_nu,
	H_OH_H2O_nu,
	Hminus_CH_CH2_e,
	Hminus_C_CH_e,
	Hminus_OH_H2O_e,
	Hminus_O_OH_e,
	H2_C_CH2_nu,
	H2_CP_CH2P_nu,
	H2_SiP_SiH2P_nu,
	HeP_CH_CP_He_H,
	HeP_CH2_CHP_He_H,
	HeP_OH_OP_He_H,
	HeP_H2O_OHP_He_H,
	HeP_SiH_SiP_He_H,
	HeP_H2O_OH_He_HP,
	HeP_CH2_CP_He_H2,
	crnu_CH_C_H,
	crnu_CHP_CP_H,
	crnu_H2O_OH_H,
	crnu_OH_O_H,
	crnu_SiH_Si_H,
	nu_CH_C_H,
	nu_CHP_CP_H,
	nu_CH2_CH_H,
	nu_CH2P_CHP_H,
	nu_CH3P_CH2P_H,
	nu_CH3P_CHP_H2,
	nu_H2O_OH_H,
	nu_OH_O_H,
	nu_OHP_O_HP,
	nu_SiH_Si_H,
	e_CHP_C_H,
	e_CH2P_CH_H,
	e_CH2P_C_H_H,
	e_CH2P_C_H2,
	e_CH3P_C_H2_H,
	e_CH3P_CH2_H,
	e_CH3P_CH_H_H,
	e_CH3P_CH_H2,
	e_H2OP_OH_H,
	e_H2OP_O_H_H,
	e_H2OP_O_H2,
	e_H3OP_H2O_H,
	e_H3OP_OH_H_H,
	e_H3OP_OH_H2,
	e_H3OP_O_H2_H,
	e_HCOP_CO_H,
	e_OHP_O_H,
	e_SiH2P_SiH_H,
	e_SiH2P_Si_H_H,
	e_SiH2P_Si_H2,
	e_SiOHP_SiO_H,
	H2_CH_CH3_nu,
	H2_CH3P_CH5P_nu,
	H2s_CH_CH3_nu,
	Hminus_CH2_CH3_e,
	Hminus_CH3_CH4_e,
	nu_CH3_CH2_H,
	nu_CH3_CH_H2,
	nu_CH4_CH3_H,
	nu_CH4_CH2_H2,
	nu_CH4_CH_H2,
	crnu_CH3_CH2_H,
	crnu_CH3_CH_H2,
	crnu_CH4_CH2_H2,
	e_CH5P_CH3_H2,
	e_CH5P_CH4_H,
	e_CH4P_CH3_H,
	e_CH4P_CH2_H_H,
	H2_N_NH_H  ,      
	H2_NH_NH2_H ,        
	H2_NH2_NH3_H , 
	H2_CN_HCN_H   ,      
	HP_HNO_NOP_H2,
	HP_HS_SP_H2,
	H_HSP_SP_H2 ,
	H2P_N_NHP_H  ,     
	H2_NP_NHP_H   ,    
	H2_NHP_N_H3P   ,    
	H2P_NH_NH2P_H   ,  
	H2_NHP_NH2P_H    , 
	H2_NH2P_NH3P_H    , 
	H2_NH3P_NH4P_H     ,
	H2P_CN_HCNP_H     ,
	H2_CNP_HCNP_H     ,
	H2P_NO_HNOP_H      ,
	H2_SP_HSP_H        ,
	H2_CSP_HCSP_H      ,
	H3P_NH_NH2P_H2     ,
	H3P_NH2_NH3P_H2    ,
	H3P_NH3_NH4P_H2    ,
	H3P_CN_HCNP_H2     ,
	H3P_NO_HNOP_H2     ,
	H3P_S_HSP_H2       ,
	H3P_CS_HCSP_H2     ,
	H3P_NO2_NOP_OH_H2  ,
	HP_NH_NHP_H        ,
	HP_NH2_NH2P_H      ,
	HP_NH3_NH3P_H      ,
	H_CNP_CN_HP        ,
	HP_HCN_HCNP_H      ,
	H_HCNP_HCN_HP      ,
	H_N2P_N2_HP        ,
	HP_NO_NOP_H        ,
	HP_HS_HSP_H        ,
	HP_SIN_SINP_H      ,
	HP_CS_CSP_H         ,
	HP_NS_NSP_H        ,
	HP_SO_SOP_H        ,
	HP_OCS_OCSP_H      ,
	HP_S2_S2P_H     ,
	H2P_NH_NHP_H2    ,
	H2P_NH2_NH2P_H2   ,
	H2P_NH3_NH3P_H2   ,
	H2P_CN_CNP_H2      ,
	H2P_HCN_HCNP_H2    ,
	H2P_NO_NOP_H2     ;





}	co;

