/* This file is part of Cloudy and is copyright (C) 1978-2004 by Gary J. Ferland.
 * For conditions of distribution and use, see copyright notice in license.txt */
/*ContCreatePointers create pointers for lines and continua, one time per coreload */
void ContCreatePointers(void);

/*ContSetIntensity derive intensity of incident continuum, returns 0 if continuum
 * is ok, 1 if failure of some kind*/
int ContSetIntensity(void);

/* set up continuum energy mesh if first call, otherwise reset to original mesh */
void ContCreateMesh(void);

/*ContNegative sanity check for negative continuum intensities */
void ContNegative(void);

/*ffun evaluate total flux for sum of all continuum sources */
double ffun(double anu);

/*ffun1 derive flux at a specific energy, for one continuum */
double ffun1(double xnu);

/*ContPump local continuum pumping rate radiative transfer for all lines */
double ContPump(EmLine * t );

EXTERN struct t_continuum {
	/* this is information needed to set the energy binning,
	 * full continuum is described by series of ranges where resolution is
	 * constant over that range */
	float *filbnd, 

	  *fildel, 

	  *filres;

	long int *ifill0, 
	  /*number of ranges entered for this continuum source*/
	  nrange; 

	/* each of these is the upper bound of an energy band,
	 * the first lowest bound is the low-energy limit of the code */
	double *StoredEnergy,
		/* the resolution, dE/E for each band */
		*StoredResolution;

	/* the number of bands read in */
	long int nStoredBands;

	/* factor to reset continuum resolution set in continuum_mesh.dat,
	 * default is unity, reset with set resolution command */
	double ResolutionScaleFactor;

	/* flag saying that parts of continuum are zero */
	int lgCon0,
	  lgCoStarInterpolationCaution;

	/* TotalLumin is total luminosity in incident continuum  */
	double TotalLumin, 
	  totlsv;

	/* the incident continuum at Hb and La */
	float cn4861, 
	  cn1216, 
	  sv4861, 
	  sv1216;

}	continuum;
