/* This file is part of Cloudy and is copyright (C) 1978-2004 by Gary J. Ferland.
 * For conditions of distribution and use, see copyright notice in license.txt */
/*CoolMang compute manganese cooling */
#include "cddefines.h"
#include "taulines.h"
#include "lines_service.h"
#include "atoms.h"
#include "cooling.h"

void CoolMang()
{

#	ifdef DEBUG_FUN
	fputs( "<+>CoolMang()\n", debug_fp );
#	endif

	/* [Mn IX] 7968.5A
	 * Y(ik) from 
	 *  >>refer	mn9	cs	Pelan, J., & Berrington, K.A. 1995, A&A Suppl, 110, 209 */
	PutCS(2.48,&TauLines[ipxMn0979]);
	atom_level2(&TauLines[ipxMn0979]);

	/* [Mn 17] 1169.59, cs from 
	 *  >>refer	mn17	cs	Saraph, H.E. & Tully, J.A. 1994, A&AS, 107, 29 */
	PutCS(0.12,&TauLines[ipxMn1712]);
	atom_level2(&TauLines[ipxMn1712]);

#	ifdef DEBUG_FUN
	fputs( " <->CoolMang()\n", debug_fp );
#	endif
	return;
}

