/* This file is part of Cloudy and is copyright (C) 1978-2004 by Gary J. Ferland.
 * For conditions of distribution and use, see copyright notice in license.txt */
/* fe.h - vars that are for Fe only */
EXTERN struct t_fe {

	/* total cooling due to 12 level model FeIV atom, and three uv lines
	 * 4P5/2 - 6S5/2, 4P3/2 - 6S5/2, and 4D+ - 6S
	 * Fe4CoolTot is total cooling due to entire atom, also three selectec lines */
	double Fe4CoolTot, 
	  fe42836, 
	  fe42829, 
	  fe42567, 
	  fe40401, 
	  fe41207, 
	  fe41206, 
	  fe41106, 
	  fe41007, 
	  fe41008, 
	  fe40906;

	/* fekhot, fekcld, number of photons in hot and cold iron, per unit vol */
	float fekhot, 
	  fekcld;

	/* Fe Ka from iron in grains */
	float fegrain;

	/* uv pumping of fe coronal lines */
	long int ipfe10;
	float pfe10, 
	  pfe11a, 
	  pfe11b, 
	  pfe14;

	}	fe;

