/* This file is part of Cloudy and is copyright (C) 1978-2004 by Gary J. Ferland.
 * For conditions of distribution and use, see copyright notice in license.txt */
/* geometry.h */
EXTERN struct t_geometry {

	/* true if geometry is plane parallel, set in comment */
	int lgGeoPP;

	/* angle of illumination - actually 1./cos(normal), so > 1. */
	float AngleIllum;

	/* FillFac is filling factor, default 1,
	* others are parameters to make function of radius */
	float FillFac, 
	  filpow, 
	  fiscal;

	/* flag saying whether spherical geometry */
	int lgSphere;

	/* default open geometry, covgeo is unity, covrt is zero.  
	 * closed geometry, covgeo is unity, and covrt is unity */

	/* covering factors, account for possible less than total coverageof 4\pi */ 
	/* linearly affects line luminosities but not intensities (since they are
	 * per unit area of cloud.
	 * When sphere command is entered with no optional covering factor this is
	 * set to 1 and covrt is set to covgeo.  The default is an open geometry,
	 * and covgeo is unity for this as well */
	float covgeo;

	/* radiative transfer covering factor accounts for diffuse radiation
	 * escaping from system in open geometry.  weakly affects intensities and
	 * luminosities.  For open geometry this is zero (half of diffuse fields
	 * escape from cloud and do not strike gas, for a closed geometry this is unity 
	 * also set to covgeo (def unity) if covering factor command is entered */
	float covrt;

	/* flag saying that spherical geometry is static, set with sphere static */
	int lgStatic;

	/* option to simulate a slit projected onto the nebula.  This is false by
	 * default, and set true with SLIT option on the SPHERE command 
	int lgSlit;*/

	/* this is power that goes with lgSlit - default is 0 when sphere slit
	 * is set, but is 1 if long keyword appears 
	 * default set in zerologic is 2 */
	long int iEmissPower;

	/* flag saying that it is ok to not iterate when sphere static is set,
	 * set with (OK) option on sphere static, used for testing hydrogen atom */
	int lgStaticNoIt;

	/* nprint is how many zones to print */
	long int  nprint;

	/* nend[iteration] is limiting number of zones for that iteration */
	long int nend[ITRDIM];

	/* lgZonSet set if stopping zone specified */
	int lgZoneSet;

	/* lgZoneTrp set if stopped due to zone number */
	int lgZoneTrp;

	/* default limit to number of zones */
	long int nEndDflt;

	/* lgEndDflt true if still at default */
	int lgEndDflt;

	}	geometry;


