/* This file is part of Cloudy and is copyright (C) 1978-2004 by Gary J. Ferland.
 * For conditions of distribution and use, see copyright notice in license.txt */

/* Set this flag to one of the following values
 *	0	don't print
 *	1	print As
 *	2	print only forbidden As
 *	3	print Es
 *	4	print threshold photoionization cross-sections
 *	5	print radiative recombination coefficients.	
 *  6   print photoionization cross-section grids.	*/
/* Out files are "Helike___.txt" with the blank being, respectively,
 *	"As","fAs","Es","ThPCS","RR", and "PCSgrid."	*/
#define	printflag	(0)

/* temperatures at which CS for He1 are stored */
#define HE1CSARRAY 10
/* the magic number for the table of He1 transition probabilities, YYMMDD */
#define TRANSPROBMAGIC	(31218)
/* the magic number for the table of He1 effective collision strengths, YYMMDD */
#define COLLISMAGIC		(30915)
/* the magic number for the table of He1 case A and B emissivities, YYMMDD */
#define CASEABMAGIC		(31104)

#define N_(A_)	(iso.quant_desig[ipHE_LIKE][nelem][A_].n)
#define L_(A_)	(iso.quant_desig[ipHE_LIKE][nelem][A_].l)
#define S_(A_)	(iso.quant_desig[ipHE_LIKE][nelem][A_].s)
#define J_(A_)	( (A_>=ipHe2p3P0 && A_<=ipHe2p3P2) ? (A_-3):0 )

/* one SD is 20% variation	*/
#define LMIX_STD_DEV	0.20 
/* one SD is 25% variation	*/
#define BRAY_STD_DEV	0.25
/* one SD is 50% variation	*/
#define VRIENS_STD_DEV	0.50

/* He-like main routine to call HeLikeLevel and determine 
 * model he-like species atom level balance	*/
void HeLike(void);

/*HeLikeLevel level populations  */
void HeLikeLevel( long nelem);

/*HeLikeError generate gaussian errors */
void HeLikeError( long nelem);

/*A custom wrapper for RandGauss than truncates at two standard deviations. */
double MyGaussRand( double PctUncertainty );

/* create he-like series */
void HeCreate(void);

/* routine to print departure coefficients for he-like species */
void prt_He_like_DeparCoef(long int nelem );

/* routine to print level pops for he-like species */
void prt_He_like_Pops(long int nelem );

/* Calculate "EnergyWN" for 4 autoionizing levels of each
 * "turned-on" element.	*/
void He1Autoionize(void);

/* routine to punch table needed for AGN3 - collision strengths of HeI */
void AGN_He1_CS( FILE *ioPun );

/* put an error bar on a piece of data, to be used with Gaussian random noise gen */
void putError(long nelem, long ipHi, long ipLo, long whichData, float errorToPut);

/* these static variables were moved from helike.c so that helikelevel.c could see them.	*/
extern const int ipEnergy;
extern const int ipRad;
extern const int ipCollis;

/* this becomes the most number of levels in any member of the he-like iso sequence */
EXTERN long int max_num_levels, max_n;

/* This array does the reverse of iso.quant_desig[ipHE_LIKE]
 * Since separate j levels within a triplet term are only resolved in the case of 2tripP,
 * allocating memory for a j dimension is unwarranted.  Instead 
 * QuantumNumbers2Index[nelem][2][1][1] will point to 2^3P2, with 2^3P0 and 2^3P1
 * easily accessed by subtracting 2 and 1 respectively from the returned index.	*/
EXTERN long ****QuantumNumbers2Index;

/* all of these are initialized in zero */
EXTERN struct t_helike 
{
	double he2sdest;

	/* flag saying whether to use a set of physics meant to 
	 * replicate the Benjamin et al. HeI results 
	 * set with ATOM HE-LIKE BENJAMIN command */
	int lgSetBenjamin;

	/* number of CS in the above array */
	long int nCS;

	/* Hy2nu is hydrogen two photon, others He1 and He2 */
	float *he12nu/*[NC_ELL]*/;

	/* flag set by compile he-like command, says to regenerate table of recombination coef */
	int lgCompileRecomb;

	/* parameters for changing gbar - set with set hegbar command */
	int lgCS_Vriens ,
		lgCS_None ,
		lgCS_new,
		lgCS_Vrinceanu;

	/* used to print warning if density too low for first collapsed level to be l-mixed	*/
	int lgCritDensLMix;

 	/* flag saying whether to include fine-structure mixing in spontaneous decays	
	 * set with ATOM HE-LIKE FSM command */
	int lgFSM;

	/* will be lifetime of each level of each species in sequence.	*/
	double **Lifetime;
	
	/* array of collision strengths read from data file...this is interpolated upon.	*/
	float ****HeCS;
	
	/* vector of temperatures corresponding to collision strengths stuffed into HeCS.	*/
	double CSTemp[HE1CSARRAY];

	/* This three ONLY differ from the corresponding components of the iso structure in that
	 * the size of the atom may have to be truncated due to continuum lowering.  But we do not change
	 * the values in iso, because they will define the biggest size possible, and are used to 
	 * malloc arrays one time only.	*/ 
	long int *numLevels;
	long int *nCollapsed;
	long int *n_HighestResolved;

	/* This variable is set to true if the model is full size in the sense that all levels below
	 * continuum are considered.	*/
	int lgFullSize[LIMELM];

	/* This flag is set to true if the rates should be treated with a randomly generated error,
	 * on the range specifically set for each rate, before being entered into the rate matrix.	*/
	int lgRandErrGen;

	/* this is flag saying that random gaussians have already been set...they should only
	 * be done once per model, and this must be reset to false at the beginning of each model.	*/
	int lgErrGenDone;

	int lgTopoff;

	/* This is the used to set a unique seed in parallel gaussian runs */
	int modelRank;

	/* This is the array in which uncertainties are stored if helike.lgRandErrGen is set. */
	float ****Error;

	/* This is the array in which gaussian errors are generated, using the values in 
	 * the Error array above as the standard deviations */
	float ****ErrorFactor;

	/* Tells which dielectronic recombination data set to use.	*/
	int lgDielRecom;

	/* the effective collisional rate for 2^3S, including all collisional transfers to singlets
	 * and collisional ionization.  For helium only.	*/
	double qTot2TripS;

	double **TotBranchRatio;
		 
}	helike;

