/* This file is part of Cloudy and is copyright (C) 1978-2004 by Gary J. Ferland.
 * For conditions of distribution and use, see copyright notice in license.txt */
/* hextra.h */
EXTERN struct t_hextra {
	/* parameters dealing with 'extra' heat to add to this zone due to cosmic rays*/
	float cryden, 
	  crpowr, 
	  crtemp ;
	/* this is current cosmic ray density divided by default galactic background */
	float cryden_ov_background;
	/* this is default cosmic ray background */
	float background;

	/* these three set with hextra command, first the heating rate */
	float TurbHeat, 
	  /* the scale radius for the heating */
	  turrad,

	  /* the scale radius from the back of the cloud */
	  turback;
	int lgLeidenCsupraHack; /* This option turns off the cosmic ray ionization
							   of C and O, since other codes from the Leiden meeting
							   do not include this process. */

	}	hextra;


