/* This file is part of Cloudy and is copyright (C) 1978-2004 by Gary J. Ferland.
 * For conditions of distribution and use, see copyright notice in license.txt */
/* >>chng 04 aug 14, PvH chng hmrate into macro to speed up co.c */
/*hmrate compile molecular rates using Hollenback and McKee fits */
#define hmrate(a,b,c) ( ((b) == 0 && (c) == 0) ? (a) : \
	( ((c) == 0) ? (a)*pow(phycon.te/300.,(b)) : \
	( ((c)/phycon.te > 50.) ? 0. : ( ((b) == 0) ?  (a)*exp(-(c)/phycon.te) : \
					 (a)*pow(phycon.te/300.,(b))*exp(-(c)/phycon.te) ) ) ) )

#if 0
/* >>chng 04 aug 15, PvH change from old code below to above, speed up, better optim */
/*hmrate compile molecular rates using Hollenback and Mckee fits,
 * called by hmole and comole  */
#include "cddefines.h"
#include "phycon.h"
#include "hmrate.h"

double hmrate(double a, 
	  double b, 
	  double c)
{
	double bfac, 
	  cfac, 
	  hmrate_v;

#	ifdef DEBUG_FUN
	fputs( "<+>hmrate()\n", debug_fp );
#	endif

	/* function to evaluate 
	 * >>refer	chemistry		Hollenbach and McKee ApJ 342, 306.
	 * A is leading coef, B is power temp depen, and C is exponential
	 * rate = a * (te/300K)^b * EXP(-c/te)
	 * */
	if( c/phycon.te > 50. )
	{
		hmrate_v = 0.;
		
#		ifdef DEBUG_FUN
		fputs( " <->hmrate()\n", debug_fp );
#		endif
		return( hmrate_v );
	}

	if( c == 0. )
	{
		cfac = 1.;
	}
	else
	{
		cfac = exp(-c/phycon.te);
	}

	if( b == 0. )
	{
		bfac = 1.;
	}
	else
	{
		bfac = pow(phycon.te/300.,b);
	}

	hmrate_v = a*bfac*cfac;


#	ifdef DEBUG_FUN
	fputs( " <->hmrate()\n", debug_fp );
#	endif
	return( hmrate_v );
}
#endif

