/* This file is part of Cloudy and is copyright (C) 1978-2004 by Gary J. Ferland.
 * For conditions of distribution and use, see copyright notice in license.txt */
/* 
 * set of routines to do spline interpolation
 * call spline first to set coefficients up,
 * then call splint to interpolate
 * spldrv gives dy/dx(x) rather than y(x)
 * splint_safe and spldrv_safe check whether x is within bounds
 */

void spline(double[],double[],long,double,double,double[]);
void splint(double[],double[],double[],long,double,double*);
void splint_safe(double[],double[],double[],long,double,double*,int*);
void spldrv(double[],double[],double[],long,double,double*);
void spldrv_safe(double[],double[],double[],long,double,double*,int*);

/*
 * series of interpolation routines from CUJ Feb 2000, by Kyle Loudon
 */

#ifndef INTERPOLATE_H
#define INTERPOLATE_H

double lagrange(const double *x, const double *fx, int n,
   double X);

double newton(const double *x, const double *fx, int n,
   double X, double tolerance, int *degree);

double pwlinear(const double *x, const double *fx, int n,
   double X);

double pwhermite(const double *x, const double *fx, const
   double *fpx, int n, double X);

#endif
