/* This file is part of Cloudy and is copyright (C) 1978-2004 by Gary J. Ferland.
 * For conditions of distribution and use, see copyright notice in license.txt */
/*ion_zero zero out heating save arrays */
#include "cddefines.h"
#include "thermal.h"
#include "ionbal.h"

void ion_zero(long int nelem)
{
	long int i;

#	ifdef DEBUG_FUN
	fputs( "<+>ion_zero()\n", debug_fp );
#	endif

	/* heating array, but only for direct photoionization */
	for( i=0; i < nelem; i++ )
	{
		thermal.heating[nelem][i] = 0.;
	}

#	ifdef DEBUG_FUN
	fputs( " <->ion_zero()\n", debug_fp );
#	endif
	return;
}

