/* This file is part of Cloudy and is copyright (C) 1978-2004 by Gary J. Ferland.
 * For conditions of distribution and use, see copyright notice in license.txt */
/*lines main routine to put emission line intensities into line stack */
void lines(void);

/* general information at start of lines */
void lines_general(void);

/* the hydrogenic iso-sequence */
void lines_hydro(void);

/* information about grains */
void lines_grains(void);

/*lines_setup convert level 1 and level 2 line parameters and pointers 
 * into internal form used by code */
void lines_setup(void);

/* enter all continua */
void lines_continuum(void);

/* enter all molecules into emission line stack */
void lines_molecules(void);

/* enter all helium iso seq into emission line stack */
void lines_helium(void);

/*lines_lv1_li_ne place lines of elements lithium through neon into lines storage stack */
void lines_lv1_li_ne(void);

/*lines_lv1_na_ar place lines of elements sodium through argon into lines storage stack */
void lines_lv1_na_ar(void);

/*lines_lv1_k_zn place lines of elements potatium and heavier into lines storage stack */
void lines_lv1_k_zn(void);

/* routine to stuff comments into the stack of comments,
 * return is index to this comment */
long int StuffComment( char * chComment );

/*lines_table envoked by table lines command, check if we can find all lines in a given list
 * returns 0 if ok, n is n lines not found */
int lines_table(void);

#define NHOLDCOMMENTS 100

/* this struc is different from following since they are only pointer here, will be malloced 
 * to form a large array after number of lines is counted, but this is the final form */
EXTERN struct t_LineSave {
	/* number of emission lines in main stack */

	/* nsum is current index, to last line entered in the array */
	/* linadd increments nsum before doing anything else */
	long int nsum;

	/* total number of dust lines */
	long int ndsum;

	/* index to number of comments printed within the block of lines */
	long int nComment;

	long int npxdd;

	/* variable to tell lines whether this is the first initialaization
	 * pass or whether we are in the middle of a model
	 * ipass=0 on initialization call, =1 on all others */
	long int ipass;

	/* holds comment strings associated with various blocks of output lines */
	char chHoldComments[NHOLDCOMMENTS][INPUT_LINE_LENGTH];

	/* NormWL is array index for emission line on normalize command */
	long int ipNormWavL;

	/* array index for emergent emission line on normalize command */
	long int ipEmerNormWavL;

	/* WavLNorm is wavelength of emission line on normalize command */
	float WavLNorm;

	/* the assocated uncertainty in the wavelength */
	float errorwave;

	/* ScaleNormLine is the scale factor for its appearance */
	double ScaleNormLine;

	/* chNormLab is optional label */
	char chNormLab[5];

	/* flag saying whether norm has been set */
	int lgNormSet ;

	/* flag saying whether norm has been found */
	int lgNormFound;

	/* save rec coef data for recombination lines of C, N, O */
	float RecCoefCNO[4][471];

}	LineSave;

/* this struc is different from above since only pointer here, will be malloced 
 * to form a large array after number of lines is counted */
/* these are the main line save arrays */
typedef struct tag_LineSv {

	/* one char saying whether heat 'h', cooling 'c', information, 'i' */
	char chSumTyp;

	/* the four char string label for the line */
	char chALab[5];

	/* xLineEnergy is energy of line in Rydbergs,
	 * also serves as sentinel saying this line should be added as a contributor
	 * to total spectrum when plotting continuum.  For each real line there are many
	 * components added into the line stack, only the first, the real total intensity,
	 * has this non-zero */
	float xLineEnergy;

	/* integrated intensity of the line */
	double sumlin;

	/* the emissivity, per unit vol, for current conditions */
	double emslin;

	/* the wavelength of the line */
	/* >>chng 01 aug 14, change to a float from a long int */
	float wavelength;

} LinSv;

extern LinSv *LineSv;

typedef struct tag_LinDstSv {

	/* these are the smaller arrays for dust lines */
	char chSMDLab[5];
	float wavelength;
	float smdlin;

/*} LineDSv[NDLINES];*/
} LinDstSv;

extern LinDstSv *LineDSv;
