/* This file is part of Cloudy and is copyright (C) 1978-2004 by Gary J. Ferland.
 * For conditions of distribution and use, see copyright notice in license.txt */
/*OpacityZero zero out opacity save arrays, save old opacity in OldOpacSave array */
#include "cddefines.h"
#include "rfield.h"
#include "opacity.h"

void OpacityZero(void)
{
	long int i;

#	ifdef DEBUG_FUN
	fputs( "<+>OpacityZero()\n", debug_fp );
#	endif


	for( i=0; i < rfield.nupper; i++ )
	{
		opac.opacity_sct[i] = 0.;
		/* save the current opacities */
		opac.OldOpacSave[i] = opac.opacity_abs[i];
		opac.opacity_abs[i] = 0.;
	}

	/* only zero out the static array if we are going to
	 * totally redo the static part */
	if( opac.lgRedoStatic )
	{
		/*fprintf(ioQQQ," OpacityZero is zeroing out the static opacities\n");*/
		for( i=0; i < rfield.nupper; i++ )
		{
			opac.OpacStatic[i] = 0.;
		}
	}

#	ifdef DEBUG_FUN
	fputs( " <->OpacityZero()\n", debug_fp );
#	endif
	return;
}

/* set old opac array to current versin during search phase */
void OpacityZeroOld(void)
{
	long int i;

#	ifdef DEBUG_FUN
	fputs( "<+>OpacityZeroOld()\n", debug_fp );
#	endif


	for( i=0; i < rfield.nupper; i++ )
	{
		/* save the current opacities */
		opac.OldOpacSave[i] = opac.opacity_abs[i];
	}

#	ifdef DEBUG_FUN
	fputs( " <->OpacityZeroOld()\n", debug_fp );
#	endif
	return;
}

