/* This file is part of Cloudy and is copyright (C) 1978-2004 by Gary J. Ferland.
 * For conditions of distribution and use, see copyright notice in license.txt */
/* called instead of cloudy to do optimize routine,
 * return value is 0 if calculation is ok, 1 if disaster */
int optimize_do(void);

/*optimize_input sets input lines to feed into cloudy in optimization runs */
void optimize_input(int *lgLimOK);

/* optimize_subplex is the main driver, and only exposed, routine for the
 * cowan downhill simplex routine */
void optimize_subplex(long int n, 
	  double tol, 
	  long int maxnfe, 
	  long int mode, 
	  float scale[], 
	  float x[], 
	  float *fx, 
	  long int *nfe, 
	  float work[], 
	  long int iwork[], 
	  long int *iflag);

/*powell - spectrum minimization routine - logic closely based on Press et al.
 * but totally recoded to be redistributable */
void optimize_powell(float p[], 
  float *xi, 
  long int *n, 
  long int np, 
  double ftol, 
  long int *iter, 
  float *fret);

/* recoded optimize_amoeba simplex optimization routine - logic based on Press et al,
 * but totally recode to be freely redistributable */
void optimize_amoeba(float*,float[],long,long,double,double(*)(float[]),
	long*);

/*<NP->*/
/*<I4> default to INTEGER*4*/
#define	VRSNEW	3.00f
#define STDLEN  16
/* this is the name of the file that optimize_phymir automatically creates containing
 * information to continue the optimization at a later time.  */
/* >>chng 00 sep 12, had been continue.in but was confused with normal input files*/
#define CNTFILE "continue.pmr"

void optimize_phymir(float[],float[],long,float*,float);

/*optimize_func actual function called during evaluation of optimization run */
double optimize_func(float param[]);

/* varypar.h */
/* the limit to the number of numbers on the command line */
#define	LIMEXT	5L
#define	LIMPAR	20L
#define	NCOLLM	100L
#define	NOBSLM	100L
#define HOSTLN  16L

extern char chOptimFileName[]; /* file name for output*/

EXTERN struct t_VaryPar {

	/* flag set true if vary option used */
	int lgVaryOn,	
		/* flag set true if no vary command entered */
		lgNoVary;

	/* flag set true if optimize command entered */
	int lgOptimr;

	float 
		/* min and max of range of variation */
	  varmax[LIMPAR], 
	  varmin[LIMPAR], 

	  /* vparm is the value of the parameters on the line ,
	   * there can be as many as LIMEXT parameters - only first is varied */
	  vparm[LIMEXT][LIMPAR], 

	  /* the increment */
	  vincr[LIMPAR];

	/* the number of numbers on the command line */
	long int nvarxt[LIMPAR], 
	  nvfpnt[LIMPAR];

	float vpused[LIMPAR], 
	  OptIncrm[LIMPAR], 
	  varang[LIMPAR][2];

	long int nvary, 
	  nparm;
	int lgVarOn;
	float amcol[NCOLLM], 
	  amcerr[NCOLLM];
	long int ionam[NCOLLM], 
	  ncobs;
	float amint[NOBSLM], 
	  amierr[NOBSLM];
	long int 
	  nlobs, 
	  nIterOptim;

	/* line wavelengths */
	float wavelength [NOBSLM],
		/* error on the wavelength */
		errorwave[NOBSLM];

	/* following will be file where best values will go */
	FILE *ioOptim;
	float OptGlobalErr;
	long int nOptimiz;
	int lgOptimFlow;
	float optint, 
	  optier;
	long int nTrOpt;
	int lgTrOpt, 
	  lgOptLin, 
	  lgOptLum, 
	  lgOptCol;

	/* the following is needed by PHYMIR */
	char HostName[HOSTLN];
	int lgParallel,
	  lgOptCont,
	  maxCPU;

	char chVarFmt[LIMPAR][FILENAME_PATH_LENGTH_2], 
	  chColmnLab[NCOLLM][5], 
	  chAmLab[NOBSLM][5], 
	  chOptRtn[5];
	}	optimize;

/*
 *
 *logical variable says whether current line image has vary option
 *
 *optimize increments, deltas for changing optimized variables
 *range for optimize command
 *io unit for final best parameters from optimizer
 *limit to number of iterations for optimizer, set with 
 *optimize iterations command
 *set with optimize tolerance command, used for global match to fit
 * default set in scalar to 0.10
 *current counter for the number of calls to the optimizer
 *lgTrOpt flag set with optimization trace command
 *nTrOpt is which call to cloudy to turn on trace
 *flags set if we are to optimize lines, luminosity, or colums
 *
 *
 *     labels for column densities on vary command
 *     this specifies the optimization routine
 *     'amoe', 'powe', 'bubr'
 */
