/* This file is part of Cloudy and is copyright (C) 1978-2004 by Gary J. Ferland.
 * For conditions of distribution and use, see copyright notice in license.txt */
/*ParseAbsMag parse the absolute magnitude command */
#include "cddefines.h"
#include "rfield.h"
#include "called.h"
#include "parse.h"

void ParseAbsMag(char *chCard, 
  long int *nqh)
{
	int lgEOL;
	long int i;

#	ifdef DEBUG_FUN
	fputs( "<+>ParseAbsMag()\n", debug_fp );
#	endif


	/* enter luminosity in absolute magnitudes */
	i = 5;
	strcpy( rfield.chRSpec[*nqh], "4 PI" );
	rfield.totpow[*nqh] = FFmtRead(chCard,&i,INPUT_LINE_LENGTH,&lgEOL);
	if( lgEOL )
	{
		if( called.lgTalk )
		{
			fprintf( ioQQQ, " There should have been a number on this line.   Sorry.\n" );
		}
		puts( "[Stop in ParseAbsMag]" );
		cdEXIT(EXIT_FAILURE);
	}
	if( lgMatch("BOLO",chCard) )
	{
		strcpy( rfield.chSpNorm[*nqh], "LUMI" );
		rfield.range[0][*nqh] = rfield.emm;
		rfield.range[1][*nqh] = rfield.egamry;
		/* page 197 allen 76 */
		rfield.totpow[*nqh] = ((4.75 - rfield.totpow[*nqh])/
		  2.5 + 33.5827);
	}
	else if( lgMatch("VISU",chCard) )
	{
		strcpy( rfield.chSpNorm[*nqh], "FLUX" );
		/* this is 5550A, the center of the V filter */
		rfield.range[0][*nqh] = 0.164f;
		/* totpow(nqh) = (4.79 - totpow(nqh)) / 2.5  + 18.758
		 * page 197, allen 76, 3rd line from bottom */
		rfield.totpow[*nqh] = (-rfield.totpow[*nqh]/2.5 + 
		  20.65296);
	}
	else
	{
		if( called.lgTalk )
		{
			fprintf( ioQQQ, " Keyword BOLOmetric or VISUal must appear.\n" );
		}
		puts( "[Stop in ParseAbsMag]" );
		cdEXIT(EXIT_FAILURE);
	}

	++*nqh;
	if( *nqh >= LIMSPC )
	{
		puts( "[Stop in ParseAbsMag]" );
		cdEXIT(EXIT_FAILURE);
	}

#	ifdef DEBUG_FUN
	fputs( " <->ParseAbsMag()\n", debug_fp );
#	endif
	return;
}

