/* This file is part of Cloudy and is copyright (C) 1978-2004 by Gary J. Ferland.
 * For conditions of distribution and use, see copyright notice in license.txt */
/*ParseGlobule parse parameters off the globule command */
#include "cddefines.h"
#include "radius.h"
#include "dense.h"
#include "optimize.h"
#include "input.h"
#include "parse.h"

void ParseGlobule(char *chCard)
{
	int lgEOL;
	long int i;

#	ifdef DEBUG_FUN
	fputs( "<+>ParseGlobule()\n", debug_fp );
#	endif

	/* globule with density increasing inward
	 * parameters are outer density, radius of globule, and density power */
	i = 5;
	radius.glbden = (float)FFmtRead(chCard,&i,INPUT_LINE_LENGTH,&lgEOL);
	if( lgEOL )
	{
		radius.glbden = 1.;
		dense.gas_phase[ipHYDROGEN] = 0.;
	}

	else
	{
		dense.gas_phase[ipHYDROGEN] = radius.glbden;
		radius.glbden = (float)pow(10.f,radius.glbden);
	}

	radius.glbrad = (float)FFmtRead(chCard,&i,INPUT_LINE_LENGTH,&lgEOL);
	if( lgEOL )
	{
		radius.glbrad = 3.086e18f;
	}
	else
	{
		radius.glbrad = (float)pow(10.f,radius.glbrad);
	}

	/* this is largest zone thickness, used to set first zone thickness */
	radius.sdrmax = radius.glbrad/25.;

	/* turn off min dr checking in NEXTDR */
	radius.lgDrMnOn = FALSE;
	radius.glbpow = (float)FFmtRead(chCard,&i,INPUT_LINE_LENGTH,&lgEOL);
	if( lgEOL )
		radius.glbpow = 1.;
	strcpy( dense.chDenseLaw, "GLOB" );

	/* this is distance to globule */
	radius.glbdst = radius.glbrad;

	/* vary option */
	if( optimize.lgVarOn )
	{
		/* pointer to where to write */
		optimize.nvfpnt[optimize.nparm] = input.nRead;

		/* this is the number of parameters to feed onto the input line */
		optimize.nvarxt[optimize.nparm] = 3;
		strcpy( optimize.chVarFmt[optimize.nparm], "GLOBULE %f %f %f" );

		/* param is log of abundance by number relative to hydrogen */
		optimize.vparm[0][optimize.nparm] = (float)log10(radius.glbden);
		optimize.vparm[1][optimize.nparm] = (float)log10(radius.glbrad);
		optimize.vparm[2][optimize.nparm] = radius.glbpow;
		optimize.vincr[optimize.nparm] = 0.2f;
		++optimize.nparm;
	}

#	ifdef DEBUG_FUN
	fputs( " <->ParseGlobule()\n", debug_fp );
#	endif
	return;
}

