/* This file is part of Cloudy and is copyright (C) 1978-2004 by Gary J. Ferland.
 * For conditions of distribution and use, see copyright notice in license.txt */
/*ParseMap parse map command to produce map of heating and cooling,
 * map is produced by calling punt(" map") */
#include "cddefines.h"
#include "map.h"
#include "parse.h"

void ParseMap(char *chCard )
{
	int lgEOL, 
	  lgLogOn;
	long int i;

#	ifdef DEBUG_FUN
	fputs( "<+>ParseMap()\n", debug_fp );
#	endif

	/* say output goes to stdout */
	if( ioQQQ == NULL )
	{
		ioMAP = stdout;
	}
	else
	{
		ioMAP = ioQQQ;
	}

	/* do cooling space map for specified zones
	 * if no number, or <0, do map and punch out without doing first zone */
	i = 5;
	map.MapZone = (long)FFmtRead(chCard,&i,INPUT_LINE_LENGTH,&lgEOL);
	if( lgEOL )
	{
		map.MapZone = 0;
		
#		ifdef DEBUG_FUN
		fputs( " <->ParseMap()\n", debug_fp );
#		endif
		return;
	}

	if( lgMatch("RANG",chCard) )
	{
		map.RangeMap[0] = (float)FFmtRead(chCard,&i,INPUT_LINE_LENGTH,&lgEOL);
		if( map.RangeMap[0] <= 10. )
		{
			map.RangeMap[0] = (float)pow(10.f,map.RangeMap[0]);
			lgLogOn = TRUE;
		}
		else
		{
			lgLogOn = FALSE;
		}
		map.RangeMap[1] = (float)FFmtRead(chCard,&i,INPUT_LINE_LENGTH,&lgEOL);
		if( lgLogOn )
			map.RangeMap[1] = (float)pow(10.f,map.RangeMap[1]);

		if( lgEOL )
		{
			fprintf( ioQQQ, " There must be a zone number, followed by two temperatures, on this line.  Sorry.\n" );
			puts( "[Stop in ParseMap]" );
			cdEXIT(EXIT_FAILURE);
		}
		
#		ifdef DEBUG_FUN
		fputs( " <->ParseMap()\n", debug_fp );
#		endif
		return;
	}

#	ifdef DEBUG_FUN
	fputs( " <->ParseMap()\n", debug_fp );
#	endif
	return;
}

