/* This file is part of Cloudy and is copyright (C) 1978-2004 by Gary J. Ferland.
 * For conditions of distribution and use, see copyright notice in license.txt */
/* radius.h */

/*radius_next use adaptive logic to find next zone thickness 
 * return 0 if ok, 1 for abort */
int radius_next(void);

/*radius_first derive thickness of first zone */
void radius_first(void);

/*radius_increment do work associated with geometry increments of this zone */
void radius_increment(void);

EXTERN struct t_radiusVar {
	double 
		/* the inner radius in cm */
		rinner, 

		/* the outer radius of the current zone */
		Radius, 

		/* the thickness of the current zone */
		drad, 

		/* the depth, the distance from the outer edge of
		 * current zone to the illuminated face */
		depth, 

		/* an estimate of the depth to the shielded face */
		Depth2Go,

		/* ratio of square of outer edge of current zone to 
		 * radius of illuminated face of cloud - note continuum
		* is relative to outer edge after ZoneDone is called too*/
		r1r0sq,

		/* total physical thickness of modeled region, (not outer radius)
		 * this can set set as a stopping criteria, but if
		 * not set is 1e30 before first iteration.  At end of each iteration, router
		 * is set to total depth from illuminated face to outer edge */
		router[ITRDIM];

	/* next dr, as set in nextdr */
	double drNext;

	/* the distance to the object from Earth, 
	 * set with the distance command */
	double distance;

	/* sign of dr for going in or out, 1 (usually) or -1 */
	double dRadSign;

	/* drad_x_fillfac is drad * filling factor */
	double drad_x_fillfac;

	/* mean of the above over past few zones */
	double drad_x_fillfac_mean;

	/* integrated dReff, integral of depth times filling factor */
	double depth_x_fillfac;

	/* dVeff is effec vol relative to inner radius */
	double  dVeff;

	/* dRNeff is next dr effective radius */
	double  dRNeff;

	/* dVolOutwrd, dVolReflec, outward and reflected effective vols
	 * used to get outward and reflected beams,
	 * these include only the vol of the current shell times the covering
	 * factor, and a number between 0 and 1 that is the fraction of the beam that goes
	 * out or is reflected.  this is determined by the rt covering factor */
	double dVolOutwrd; 
	double dVolReflec;

	/* Beam vars are related to lines where inward and outward fracs known */
	/* BeamInIn inward part of inwardly directed beam, 0 if sphere */
	double BeamInIn;

	/* BeamInOut outward part of inwardly directed beam, 0 if not sphere */
	double BeamInOut;

	/* BeamOutOut outward part of outwardly directed beam */
	double BeamOutOut;

	/* flag saying that zone thickness became too small, likely because
	 * of an uncontrolled oscillation */
	int lgdR2Small;

	/* this says whether radius has been set - if true then can do luminosities,
	 * if false then only intensities */
	int lgRadiusKnown;

	/* lgCylnOn set true when cylinder command given
	 * cylind is half height in centimeters */
	double CylindHigh;
	int lgCylnOn;

	/* default inner radius when none set, log r =25 in scalar */
	double rdfalt;

	/* variables that deal with the globule command,
	 * glbden, the density */
	float glbden, 
	  /* the radius for the globule command */
	  glbrad, 
	  /* the globule power */
	  glbpow, 
	  glbdst;

	/* flag to turn off dr checking in dextdr when globule command entered	*/
	int lgDrMnOn;

	/* lgPredLumin flag set true if intensities entered into 4\pi st */
	int lgPredLumin;

	/* log of4 pi r_inner^2, 0 if intensities are printed, 
	 * but is log of 4pi r_o^2 if any luminosity commands are entered */
	float pirsq;

	/* additive factor to convert stored line intensities within code 
	 * into a final desired unit, luminosity, flux at Earth, or surface brightness */
	double Conv2PrtInten; 

	/* these are 1e-30 and 1e30 by default, and are set with "set dr" cmnds
	 * used as one of a pair of limits to how big or small zones get
	 * set dr command forces constant dr by setting both to same number */
	double sdrmin, 
	  sdrmax;

	/*lgSMinON is flag saying that set drmin has been enteed*/
	int lgSMinON;

	/* this flag controlled in radius_first and says whether this option
	 * caused the first zone to have larger than optimal thickness */
	int lgDR2Big;

	/* fraction of initial thickness, set in firstdr
	* do not let dr get smaller than this */
	float drMinimum;

	/* set true is calculations stops because zone thickness gets too small */
	int lgDrMinUsed;

	/* flag set in nextdr saying whether dr is negative	*/
	int lgDrNeg;

	/* fractional change used in nextdr */
	float drChange;

	}	radius;

