/* This file is part of Cloudy and is copyright (C) 1978-2004 by Gary J. Ferland.
 * For conditions of distribution and use, see copyright notice in license.txt */
/*
 * these save EXTERN structure variables, like te vs depth
 * zeroed out in zero, incremented in RT_tau_inc
 */

EXTERN struct t_struc {

	/* this is the new variable that replaces the old NZLIM,
	 * it gives the largest number of zones that will be neede
	 * in the current calculation, and is used to create
	 * space for the following variables, and also similar
	 * variables in dynamics.c */
	long int nzlim;

	/* these will all become vectors with length given by the limit to the number of zones */
	float *testr, 
	  *volstr, 
	  *drad_x_fillfac, 
	  /* the thickness of the current zone */
	  *drad, 
	  *histr, 
	  *hiistr, 
	  *ednstr, 
	  *o3str, 
	  /* the total pressure, including all terms (ram, radiation, integrated incident, gas)*/
	  *pressure,
	  /* just the gas pressure, nkT */
	  *GasPressure ,
	  /* radiation pressure */
	  *PresRadCurr ,
	  /* >>chng 02 May 2001 rjrw: add hden for dilution */
	  *hden ,
	  /* total particles per unit vol */
	  *DenParticles ,
	  /* density, gm/cm3 total grams per unit vol */
	  *DenMass,
	  /* depth of this position */
	  *depth,
	  /* Lyman continuum optical depth for current iteration */
	  *xLyman_depth;

	/* number of zones saved */
	long int nzone;

	/* save ionization balance array across model */
	float ***xIonDense ;

	/* the hydrogen molecules */
	/*float *Molec[N_H_MOLEC];*/
	float **Hmolec,
		**COmolec;

	/* total gas phase abundances */
	float **gas_phase;

	  /* cooling and heating for each zone */
	double *coolstr ,
	  *heatstr;

	/* this is the relative ionization that is the limit for choosing 
	 * zones using it, and for detecting it in prt_comment,
	 * default is 1e-3 */
	float dr_ionfrac_limit;

	}	struc;

