#!perl -w
# in above -w turns on some warnings

# all statements that start with # are comments

# perl script to back up the cloudy source files onto a different computer
# this is automatically executed once per week, early Saturday morning
# the g drive is now set up as the d drive on nimbus,
# so this script copies files across the network

# bring in the perl module that includes copy
use File::Copy;

#	nt
# the disk drive where the files and results live, we will back this up
$c = "c";
# input and output directories
$in_dir = "$c:/projects/cloudy/current/tsuite/auto/";
# this is the letter of the cdrw drive on the network 
$cdrw_dir = "j:/";
# this is the large raid drive on thunder
$out_dir = "r:/usr/gary/backup/cloudy/";

# get current time and date
($sec,$min,$hour,$mday,$mon,$year,$wday,$yday,$isdst) =
                                            gmtime(time);
# create basename for file
$basename = "$year"."$mon"."$mday" ;

# move to the directory, which contains source.tar and 
if( !chdir( $in_dir ) )
{
	printf(" invalid directory for output of test suite\n");
	printf(" was ==%s==\n",$in_dir );
	exit(1);
}

# create fully resolved names for where the files will end up
$exe = "$out_dir"."$basename".".exe" ;
$source = "$out_dir"."$basename".".src.tar";
$dat = "$out_dir"."$basename".".data.tar";
$hazy = "$out_dir"."$basename".".hazy.tar";
$agn = "$out_dir"."$basename".".agn.tar";
$tsuite = "$out_dir"."$basename".".tsuite.tar";

copy( "cloudy.exe" , $exe );
copy( "source.tar" , $source );
copy( "data.tar"   , $dat );
copy( "tsuite.tar" , $tsuite );

#=========================================================
# make backup copy of hazy
$hazy_dir= "$c:/projects/";
# move to the hazy directory
if( !chdir( $hazy_dir ) )
{
	printf(" invalid directory for hazy\n");
	printf(" was ==%s==\n",$hazy_dir );
	exit(1);
}
system( 
"tar_mks -cvf \"$hazy\" hazy/*.doc hazy/*.jnb ");
#=========================================================

#make backup copy of agn
#$agn_dir= "c:/projects/";
#if( !chdir( $agn_dir ) )
#{
#	printf(" invalid directory for agn\n");
#	printf(" was ==%s==\n",$agn_dir );
#	exit(1);
#}
# make backup copy of agn word docs
#system( 
#"tar_mks -cvf \"$agn\" agn/*.doc agn/*/*.doc ");
#=========================================================

# move to the saved files directory on another computer, 
# which contains the tar files we just copied over 
if( !chdir( $out_dir ) )
{
	printf(" invalid directory for output of test suite\n");
	printf(" was ==%s==\n",$out_dir );
	exit(1);
}
# have to delete existing files since gzip will hang waiting for response on overwrite
if( -e "$tsuite".".gz" )
{
	unlink( "$tsuite".".gz" );
}
if( -e "$exe".".gz" )
{
	unlink( "$exe".".gz" );
}
if( -e "$source".".gz" )
{
	unlink( "$source".".gz" );
}
if( -e "$dat".".gz" )
{
	unlink( "$dat".".gz" );
}
if( -e "$hazy".".gz" )
{
	unlink( "$hazy".".gz" );
}
#if( -e "$agn".".gz" )
#{
#	unlink( "$agn".".gz" );
#}

system( "gzip $exe" );
system( "gzip $tsuite" );
system( "gzip $source" );
system( "gzip $dat" );
system( "gzip $hazy" );
#system( "gzip $agn" );

# copy it to the cdrw 

copy( "$exe.gz"    , $cdrw_dir );
copy( "$tsuite.gz" , $cdrw_dir );
copy( "$source.gz" , $cdrw_dir );
copy( "$dat.gz"    , $cdrw_dir );
copy( "$hazy.gz"   , $cdrw_dir );
#copy( "$agn.gz"    , $cdrw_dir );

# send email does work 
send_mail();
exit;


#=============================================================
#             send_mail(),
#=============================================================

sub send_mail {
 
   open( ioLOG , ">backup.txt" );

   printf( ioLOG " exe, data, and source backed up to lightning.\n");  
   printf( ioLOG " file name was %s\n", $basename) ;
   close( ioLOG );
   system("c:\\u\\blat\\blat.exe backup.txt -t gary\@pa.uky.edu -s CloudyBackup " );
 
}

#sub send_mail {
# 
#	use OLE;
#
#	$DevMailer = CreateObject OLE 'Geocel.Mailer';
#	$DevMailer->AddServer ("cloud9.pa.uky.edu",25);
#	$DevMailer->AddRecipient ("gary\@cloud9.pa.uky.edu","Gary Ferland");
#	$DevMailer->{FromName}  = "Cloudy backup";
#	$DevMailer->{FromAddress}  = "gary\@cloud9.pa.uky.edu";
#
#	$DevMailer->{Subject} = "exe and source backed up to nimbus";  
#	$DevMailer->{Body} = "file name was ";
#	$DevMailer->{Body} = $DevMailer->{Body} . $basename;
#	# actually send the email
#	$success = $DevMailer->Send();
# 
#}
